/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.VdcStorageProfileType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VdcStorageProfile
extends VcloudEntity<VdcStorageProfileType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType vdcReference;

    VdcStorageProfile(VcloudClient client, VdcStorageProfileType vdcStorageProfileType) {
        super(client, vdcStorageProfileType);
        this.sortVdcStorageProfileReferences();
    }

    public static VdcStorageProfile getVdcStorageProfileByReference(VcloudClient client, ReferenceType vdcStorageProfileRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vdcStorageProfileRef.getHref());
        return new VdcStorageProfile(client, (VdcStorageProfileType)VdcStorageProfile.getResourceByReference(client, vdcStorageProfileRef));
    }

    private void sortVdcStorageProfileReferences() {
        for (LinkType storageProfileLink : ((VdcStorageProfileType)this.getResource()).getLink()) {
            if (!storageProfileLink.getRel().equals("up") || !storageProfileLink.getType().equals("application/vnd.vmware.vcloud.vdc+xml")) continue;
            this.vdcReference = storageProfileLink;
        }
    }

    public ReferenceType getVdcReference() throws VCloudException {
        if (this.vdcReference != null) {
            return this.vdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

