/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.MetadataBooleanValue;
import com.vmware.vcloud.api.rest.schema.MetadataDateTimeValue;
import com.vmware.vcloud.api.rest.schema.MetadataNumberValue;
import com.vmware.vcloud.api.rest.schema.MetadataStringValue;
import com.vmware.vcloud.api.rest.schema.MetadataTypedValue;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.constants.MetadataDomain;
import com.vmware.vcloud.sdk.constants.query.ExpressionType;
import com.vmware.vcloud.sdk.constants.query.MetadataExpressionType;
import com.vmware.vcloud.sdk.constants.query.QueryField;
import java.net.URI;
import java.net.URISyntaxException;

public class Expression {
    private String expressionText = "";

    public Expression(QueryField key, String value, ExpressionType expressionType) {
        if (key != null && value != null && expressionType != null && !value.isEmpty()) {
            StringBuilder expressionValue = new StringBuilder();
            expressionValue.append(key.value());
            expressionValue.append(expressionType.value());
            expressionValue.append(value);
            try {
                this.expressionText = this.encodeValue(expressionValue.toString());
            }
            catch (URISyntaxException e) {
                throw new VCloudRuntimeException(e);
            }
        }
    }

    public Expression(String key, MetadataDomain domain, MetadataTypedValue value, MetadataExpressionType expressionType) {
        if (key != null && value != null && expressionType != null) {
            StringBuilder expressionValue = new StringBuilder();
            expressionValue.append("metadata@" + domain.value() + ":" + key);
            expressionValue.append(expressionType.value());
            if (value instanceof MetadataStringValue) {
                expressionValue.append("STRING:" + ((MetadataStringValue)value).getValue());
            } else if (value instanceof MetadataDateTimeValue) {
                expressionValue.append("DATETIME:" + ((MetadataDateTimeValue)value).getValue().toString());
            } else if (value instanceof MetadataNumberValue) {
                expressionValue.append("NUMBER:" + ((MetadataNumberValue)value).getValue());
            } else if (value instanceof MetadataBooleanValue) {
                expressionValue.append("BOOLEAN:" + ((MetadataBooleanValue)value).isValue());
            }
            try {
                this.expressionText = this.encodeValue(expressionValue.toString());
            }
            catch (URISyntaxException e) {
                throw new VCloudRuntimeException(e);
            }
        }
    }

    public Expression(String key, MetadataTypedValue value, MetadataExpressionType expressionType) {
        if (key != null && value != null && expressionType != null) {
            StringBuilder expressionValue = new StringBuilder();
            expressionValue.append("metadata:" + key);
            expressionValue.append(expressionType.value());
            if (value instanceof MetadataStringValue) {
                expressionValue.append("STRING:" + ((MetadataStringValue)value).getValue());
            } else if (value instanceof MetadataDateTimeValue) {
                expressionValue.append("DATETIME:" + ((MetadataDateTimeValue)value).getValue().toString());
            } else if (value instanceof MetadataNumberValue) {
                expressionValue.append("NUMBER:" + ((MetadataNumberValue)value).getValue());
            } else if (value instanceof MetadataBooleanValue) {
                expressionValue.append("BOOLEAN:" + ((MetadataBooleanValue)value).isValue());
            }
            try {
                this.expressionText = this.encodeValue(expressionValue.toString());
            }
            catch (URISyntaxException e) {
                throw new VCloudRuntimeException(e);
            }
        }
    }

    String getExpressionText() {
        return this.expressionText;
    }

    private String encodeValue(String value) throws URISyntaxException {
        URI uri = new URI("http://www.vmware.com/vcloud/v1.5");
        URI encodedUrl = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath() + "/" + value, uri.getQuery(), uri.getFragment());
        return encodedUrl.toString().replace("http://www.vmware.com/vcloud/v1.5/", "");
    }
}

