/*
 * Decompiled with CFR 0.152.
 */
package com.eg.cli;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Vector;

public class ConnectionThread
extends Thread {
    private HttpURLConnection con;
    private String caller = null;
    private boolean isObjectStream = false;
    public boolean done = false;
    public int code = 0;
    public ArrayList data = null;
    private ArrayList input = null;
    private Object[] inputList = null;
    private String whoIs = null;
    private boolean haveToConnect = false;

    public ConnectionThread(HttpURLConnection httpURLConnection, boolean bl) {
        this.con = httpURLConnection;
        this.isObjectStream = bl;
        this.start();
    }

    public ConnectionThread(HttpURLConnection httpURLConnection, boolean bl, String string) {
        this.con = httpURLConnection;
        this.isObjectStream = bl;
        this.caller = string;
        this.start();
    }

    public ConnectionThread(HttpURLConnection httpURLConnection, boolean bl, String string, ArrayList arrayList) {
        this.con = httpURLConnection;
        this.isObjectStream = bl;
        this.haveToConnect = true;
        this.input = arrayList;
        this.whoIs = string;
        this.start();
    }

    public ConnectionThread(HttpURLConnection httpURLConnection, boolean bl, String string, ArrayList arrayList, Object[] objectArray) {
        this.con = httpURLConnection;
        this.isObjectStream = bl;
        this.haveToConnect = true;
        this.input = arrayList;
        this.inputList = objectArray;
        this.whoIs = string;
        this.start();
    }

    public ConnectionThread(HttpURLConnection httpURLConnection, boolean bl, String string, Vector vector) {
        this.con = httpURLConnection;
        this.isObjectStream = bl;
        this.haveToConnect = true;
        if (vector == null) {
            this.input = null;
        } else {
            this.input = new ArrayList();
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                this.input.add(e);
            }
        }
        this.whoIs = string;
        this.start();
    }

    public ConnectionThread(HttpURLConnection httpURLConnection, boolean bl, String string, ArrayList arrayList, String string2) {
        this.con = httpURLConnection;
        this.isObjectStream = bl;
        this.haveToConnect = true;
        this.caller = string2;
        this.input = arrayList;
        this.whoIs = string;
        this.start();
    }

    @Override
    public void run() {
        block24: {
            if (this.haveToConnect) {
                if (this.input != null) {
                    Closeable closeable;
                    if (!this.isObjectStream) {
                        try {
                            closeable = new PrintWriter(new OutputStreamWriter(this.con.getOutputStream(), "UTF-8"));
                            if (this.whoIs != null) {
                                ((PrintWriter)closeable).println(this.whoIs);
                            }
                            if (this.input != null) {
                                int n = this.input.size();
                                for (int i = 0; i < n; ++i) {
                                    ((PrintWriter)closeable).println((String)this.input.get(i));
                                }
                            }
                            ((PrintWriter)closeable).close();
                            this.con.connect();
                        }
                        catch (Exception exception) {
                            this.code = 0;
                            this.done = true;
                            if (this.caller != null) {
                                System.out.println("Connection failed for " + this.caller + " " + exception.toString());
                            }
                            return;
                        }
                    } else {
                        try {
                            closeable = new ObjectOutputStream(this.con.getOutputStream());
                            if (this.whoIs != null) {
                                ((ObjectOutputStream)closeable).writeObject(this.whoIs);
                            }
                            if (this.input != null && this.input.size() > 0) {
                                ((ObjectOutputStream)closeable).writeObject(this.input);
                            }
                            if (this.inputList != null) {
                                for (int i = 0; i < this.inputList.length; ++i) {
                                    ((ObjectOutputStream)closeable).writeObject(this.inputList[i]);
                                }
                            }
                            ((ObjectOutputStream)closeable).close();
                            this.con.connect();
                        }
                        catch (Exception exception) {
                            this.code = 0;
                            this.done = true;
                            if (this.caller != null) {
                                System.out.println("Connection failed for " + this.caller + " " + exception.toString());
                            }
                            return;
                        }
                    }
                } else {
                    try {
                        this.con.connect();
                    }
                    catch (Exception exception) {
                        this.code = 0;
                        this.done = true;
                        if (this.caller != null) {
                            System.out.println("Connection failed for " + this.caller + " " + exception.toString());
                        }
                        return;
                    }
                }
            }
            try {
                this.data = new ArrayList();
                this.code = this.con.getResponseCode();
                if (this.code == 200) {
                    this.readLinesFromStream();
                }
                this.done = true;
            }
            catch (Exception exception) {
                this.code = 0;
                this.done = true;
                if (this.caller == null) break block24;
                System.out.println("Failed to get connection response code for " + this.caller + " " + exception.toString());
            }
        }
    }

    private void readObjectsFromStream() throws Exception {
        block12: {
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream(this.con.getInputStream());
                if (objectInputStream == null) break block12;
                this.data = new ArrayList();
                Object object = objectInputStream.readObject();
                while (object != null) {
                    this.data.add(object);
                    try {
                        object = objectInputStream.readObject();
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                if (this.caller != null) {
                    System.out.println("Read failed for " + this.caller + " " + exception.toString());
                }
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    private void readLinesFromStream() throws Exception {
        block10: {
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            try {
                inputStream = this.con.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                if (bufferedReader == null) break block10;
                this.data = new ArrayList();
                String string = bufferedReader.readLine();
                while (string != null) {
                    this.data.add(string);
                    string = bufferedReader.readLine();
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                if (this.caller != null) {
                    System.out.println("Read failed for " + this.caller + " " + exception.toString());
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }
}

