/*
 * Decompiled with CFR 0.152.
 */
package com.eg.cli;

import com.eg.cli.CLIValidator;
import com.eg.cli.Help;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class CLIController {
    private Class cmdClass = null;
    private Object clsObj = null;
    private String[] actualArgs = null;
    private Method mainMethod = null;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Usage > eGCLI <Operation> <-param> <paramValue> [<-param> <paramValue>]");
        } else {
            CLIController cLIController = new CLIController();
            CLIValidator cLIValidator = new CLIValidator();
            Help help = null;
            ArrayList arrayList = cLIValidator.getClassWithLessArg();
            ArrayList arrayList2 = cLIValidator.getNoArgsValidationList();
            stringArray[0] = cLIValidator.getRealCommand(stringArray[0].toLowerCase());
            if (arrayList2 != null && arrayList2.contains(stringArray[0])) {
                if (cLIValidator.isCommandAvailable(stringArray)) {
                    cLIController.invokeMainMethod(stringArray);
                } else {
                    help = new Help(stringArray);
                }
            } else if (arrayList != null && arrayList.contains(stringArray[0])) {
                if (cLIValidator.isValidCLIArgs(stringArray)) {
                    cLIController.invokeMainMethod(stringArray);
                } else {
                    cLIController.displayErrorMsg(cLIValidator, stringArray);
                }
            } else if (stringArray.length > 0 && stringArray.length < 4) {
                if (cLIValidator.isCommandAvailable(stringArray)) {
                    if (cLIValidator.isValidCLIArgs(stringArray)) {
                        help = new Help(stringArray);
                    } else {
                        cLIController.displayErrorMsg(cLIValidator, stringArray);
                    }
                } else {
                    help = new Help(stringArray);
                }
            } else if (cLIValidator.isCommandAvailable(stringArray)) {
                if (cLIValidator.isValidCLIArgs(stringArray)) {
                    cLIController.invokeMainMethod(stringArray);
                } else {
                    cLIController.displayErrorMsg(cLIValidator, stringArray);
                }
            } else {
                help = new Help(stringArray);
            }
        }
    }

    private void invokeMainMethod(String[] stringArray) {
        try {
            String string = stringArray[0];
            this.cmdClass = Class.forName("com.eg.cli." + string);
            this.clsObj = this.cmdClass.newInstance();
            this.actualArgs = new String[stringArray.length - 1];
            int n = 0;
            for (int i = 1; i < stringArray.length; ++i) {
                this.actualArgs[n++] = stringArray[i];
            }
            this.mainMethod = this.cmdClass.getMethod("main", this.actualArgs.getClass());
            this.mainMethod.invoke(this.clsObj, new Object[]{this.actualArgs});
        }
        catch (Exception exception) {
            System.out.println("Error : Invalid Command");
        }
    }

    private void displayErrorMsg(CLIValidator cLIValidator, String[] stringArray) {
        String string = cLIValidator.getInvalidKey().trim();
        String string2 = cLIValidator.getInvalidBooleanVal().trim();
        if (string2 != null && string2.length() > 0) {
            System.out.println("Error : <-" + string + "> has Invalid <-paramValue>. Should contain boolean value");
        } else if (string != null && string.length() > 0) {
            System.out.println("Error : Invalid parameter(s) : " + string + "");
        }
        Help help = new Help(stringArray);
    }
}

