//  New Relic for Mobile -- iOS edition
//
//  See:
//    https://docs.newrelic.com/docs/releases/ios for release notes
//
//  Copyright (c) 2017 New Relic. All rights reserved.
//  See https://docs.newrelic.com/docs/licenses/ios-agent-licenses for license details
//


import Foundation
import eGMobileAPM

@objc(eGCordovaPlugin) class eGCordovaPlugin: CDVPlugin {
    
    override func pluginInitialize() {
        let applicationToken = commandDelegate.settings["ios_app_token"] as? String ?? "x"
        let managerUrl = commandDelegate.settings["manager_url"] as? String ?? "x"
        if applicationToken == nil || ((applicationToken == "") || (applicationToken == "x")) {
            print("Failed to load application token! The iOS agent is not configured for Cordova.")
        } else {
            egAPM.sharedInstance().start(apptoken: applicationToken, collectorHost: managerUrl)
        }
    }
    
    @objc(getBaseOs:)func getBaseOs(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let baseOs = getBaseOs()
        print("Base Os is \(baseOs )")
        if baseOs != nil && (baseOs.count ) > 0 && baseOs != nil {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: baseOs)
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    
    @objc(getUserCountry:)func getUserCountry(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let userCountry = getUserCountry()
        print("User Country is \(userCountry )")
        if userCountry != nil && (userCountry.count) > 0 && userCountry != nil {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: userCountry)
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    @objc(getOSVersion:)func getOSVersion(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let osVersion = getOSVersion()
        print("Os Version is \(osVersion )")
        if osVersion != nil && (osVersion.count) > 0 && osVersion != nil {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: osVersion)
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    @objc(getDeviceName:)func getDeviceName(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let deviceName = getDeviceName()
        print("Device Name is \(deviceName )")
        if deviceName != nil && (deviceName.count) > 0 && deviceName != nil {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: deviceName)
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    @objc(getAppName:)func getAppName(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let appName = getAppName()
        print("App Name  is \(appName )")
        if appName != nil && (appName.count) > 0 && appName != nil {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: appName)
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    @objc(getAppinfo:)func getAppinfo(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let appInfo = getAppinfo()
        print("App Info  is \(appInfo )")
        if appInfo != nil && (appInfo.count) > 0 && appInfo != nil {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: appInfo)
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    @objc(getResInfo:)func getResInfo(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let resInfo = getResInfo()
        print("Res Info  is \(resInfo )")
        if resInfo != nil && (resInfo.count) > 0 && resInfo != nil {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: resInfo)
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    @objc(getDevInfo:)func getDevInfo(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let devInfo = getDevInfo()
        print("Dev Info  is \(devInfo )")
        if devInfo != nil && (devInfo.count) > 0 && devInfo != nil {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: devInfo)
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    @objc(getCurrentActivityName:)func getCurrentActivityName(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let currentViewController = getCurrentActivityName()
        print("View Controller  is \(currentViewController )")
        if currentViewController != nil && (currentViewController.count) > 0 && currentViewController != nil {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: currentViewController)
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    @objc(getUserInfo:)func getUserInfo(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let userInfo = getUserInfo()
        print("User Info is \(userInfo )")
        if userInfo != nil && (userInfo.count) > 0 && userInfo != nil {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: userInfo)
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    
    @objc(setUserName:)func setUserName(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let name = command?.arguments[0] as? String
        print(String(format: "Metric %@", name ?? ""))
        if name != nil && (name?.count ?? 0) > 0 {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: egAPM.sharedInstance().setUserName(name ?? ""))
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    
    @objc(setAttribute:)func setAttribute(_ command: CDVInvokedUrlCommand?) {
        var pluginResult: CDVPluginResult? = nil
        let name = command?.arguments[0] as? String
        let value = (command?.arguments[1] as? NSNumber)?.intValue ?? 0
        print(String(format: "Metric %@ %li", name ?? "", value))
        if name != nil && (name?.count ?? 0) > 0  {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_OK, messageAs: egAPM.sharedInstance().setAttribute(name ?? "", value))
        } else {
            pluginResult = CDVPluginResult(status: CDVCommandStatus_ERROR)
        }
        commandDelegate.send(pluginResult, callbackId: command?.callbackId)
    }
    
    func getBaseOs() -> String {
        return "ios"
    }
    
    func getUserCountry() -> String  {
       return egAPM.sharedInstance().userCountry()
    }
    
    func getOSVersion() -> String {
        return egAPM.sharedInstance().osVersion()
    }
    
    func getDeviceName() -> String {
        return egAPM.sharedInstance().deviceName()
    }
    
    func getAppName() -> String {
        return egAPM.sharedInstance().appName()
    }
    
    func getAppinfo() -> String {
        return egAPM.sharedInstance().appInfo()
    }
    
    func getResInfo() -> String {
        return egAPM.sharedInstance().resInfo()
    }
    
    func getDevInfo() -> String {
        return egAPM.sharedInstance().devInfo()
    }
    
    func getUserInfo() -> String {
        return egAPM.sharedInstance().userInfo()
    }
    
    func setUserName(_ name: String) {
        var name = name
        name = name.replacingOccurrences(of: "[", with: "")
        name = name.replacingOccurrences(of: "]", with: "")
        name = name.replacingOccurrences(of: "\"", with: "")
        egAPM.sharedInstance().setUserName(name)
    }

    func setAttribute(_ key: String, _ value: String) {
        var key = key
        var value = value
        key = key.replacingOccurrences(of: "[", with: "")
        key = key.replacingOccurrences(of: "]", with: "")
        key = key.replacingOccurrences(of: "\"", with: "")
        value = value.replacingOccurrences(of: "[", with: "")
        value = value.replacingOccurrences(of: "]", with: "")
        value = value.replacingOccurrences(of: "\"", with: "")
        egAPM.sharedInstance().setAttribute(key, value)
    }
    
    func getCurrentActivityName() -> String {
        return egAPM.sharedInstance().getViewController()
    }
}
   

