/*     */ package com.egurkha.jsp.indexer.parser;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class ParseException
/*     */   extends Exception
/*     */ {
/*     */   protected boolean specialConstructor;
/*     */   public Token currentToken;
/*     */   public int[][] expectedTokenSequences;
/*     */   public String[] tokenImage;
/*     */   protected String eol;
/*     */   
/*     */   public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
/*  33 */     super("");
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/* 160 */     this.eol = System.getProperty("line.separator", "\n"); this.specialConstructor = true; this.currentToken = currentTokenVal; this.expectedTokenSequences = expectedTokenSequencesVal; this.tokenImage = tokenImageVal; } public ParseException() { this.eol = System.getProperty("line.separator", "\n"); this.specialConstructor = false; } public ParseException(String message) { super(message); this.eol = System.getProperty("line.separator", "\n");
/*     */     this.specialConstructor = false; }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   protected String addEscapeString(String str) {
/* 169 */     StringBuffer retval = new StringBuffer();
/*     */     
/* 171 */     for (int i = 0; i < str.length(); i++) {
/*     */       char ch;
/* 173 */       switch (str.charAt(i)) {
/*     */         case '\000':
/*     */           break;
/*     */         
/*     */         case '\b':
/* 178 */           retval.append("\\b");
/*     */           break;
/*     */         case '\t':
/* 181 */           retval.append("\\t");
/*     */           break;
/*     */         case '\n':
/* 184 */           retval.append("\\n");
/*     */           break;
/*     */         case '\f':
/* 187 */           retval.append("\\f");
/*     */           break;
/*     */         case '\r':
/* 190 */           retval.append("\\r");
/*     */           break;
/*     */         case '"':
/* 193 */           retval.append("\\\"");
/*     */           break;
/*     */         case '\'':
/* 196 */           retval.append("\\'");
/*     */           break;
/*     */         case '\\':
/* 199 */           retval.append("\\\\");
/*     */           break;
/*     */         default:
/* 202 */           if ((ch = str.charAt(i)) < ' ' || ch > '~') {
/*     */             
/* 204 */             String s = "0000" + Integer.toString(ch, 16);
/* 205 */             retval.append(
/* 206 */                 "\\u" + s.substring(s.length() - 4, s.length()));
/*     */             
/*     */             break;
/*     */           } 
/* 210 */           retval.append(ch);
/*     */           break;
/*     */       } 
/*     */     
/*     */     } 
/* 215 */     return retval.toString();
/*     */   }
/*     */   
/*     */   public String getMessage() {
/*     */     if (!this.specialConstructor)
/*     */       return super.getMessage(); 
/*     */     String expected = "";
/*     */     int maxSize = 0;
/*     */     for (int i = 0; i < this.expectedTokenSequences.length; i++) {
/*     */       if (maxSize < (this.expectedTokenSequences[i]).length)
/*     */         maxSize = (this.expectedTokenSequences[i]).length; 
/*     */       for (int k = 0; k < (this.expectedTokenSequences[i]).length; k++)
/*     */         expected = String.valueOf(expected) + this.tokenImage[this.expectedTokenSequences[i][k]] + " "; 
/*     */       if (this.expectedTokenSequences[i][(this.expectedTokenSequences[i]).length - 1] != 0)
/*     */         expected = String.valueOf(expected) + "..."; 
/*     */       expected = String.valueOf(expected) + this.eol + "    ";
/*     */     } 
/*     */     String retval = "Encountered \"";
/*     */     Token tok = this.currentToken.next;
/*     */     for (int j = 0; j < maxSize; j++) {
/*     */       if (j != 0)
/*     */         retval = String.valueOf(retval) + " "; 
/*     */       if (tok.kind == 0) {
/*     */         retval = String.valueOf(retval) + this.tokenImage[0];
/*     */         break;
/*     */       } 
/*     */       retval = String.valueOf(retval) + addEscapeString(tok.image);
/*     */       tok = tok.next;
/*     */     } 
/*     */     retval = String.valueOf(retval) + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
/*     */     retval = String.valueOf(retval) + "." + this.eol;
/*     */     if (this.expectedTokenSequences.length == 1) {
/*     */       retval = String.valueOf(retval) + "Was expecting:" + this.eol + "    ";
/*     */     } else {
/*     */       retval = String.valueOf(retval) + "Was expecting one of:" + this.eol + "    ";
/*     */     } 
/*     */     retval = String.valueOf(retval) + expected;
/*     */     return retval;
/*     */   }
/*     */ }


/* Location:              C:\Users\dhanabal\Desktop\Index\!\com\egurkha\jsp\indexer\parser\ParseException.class
 * Java compiler version: 1 (45.3)
 * JD-Core Version:       1.1.3
 */