/*    */ package com.egurkha.jsp.indexer;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.Writer;
/*    */ import jakarta.servlet.jsp.JspException;
/*    */ import jakarta.servlet.jsp.JspTagException;
/*    */ import jakarta.servlet.jsp.tagext.BodyContent;
/*    */ import jakarta.servlet.jsp.tagext.BodyTag;
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ 
/*    */ public final class PagesTag
/*    */   extends PageTagSupport
/*    */   implements BodyTag
/*    */ {
/* 29 */   private BodyContent content = null;
/* 30 */   private int page = 0;
/* 31 */   private int lastPage = 0;
/*    */ 
/*    */   
/*    */   public void setBodyContent(BodyContent bc) {
/* 35 */     this.content = bc;
/*    */   }
/*    */ 
/*    */   
/*    */   public int doStartTag() throws JspException {
/* 40 */     super.doStartTag();
/*    */     
/* 42 */     int firstPage = this.pagerTag.getFirstIndexPage();
/* 43 */     this.lastPage = this.pagerTag.getLastIndexPage(firstPage);
/* 44 */     this.page = firstPage;
/*    */     
/* 46 */     return (this.page <= this.lastPage) ? 2 : 0;
/*    */   }
/*    */ 
/*    */   
/*    */   public void doInitBody() throws JspException {
/* 51 */     setPageAttributes(this.page);
/* 52 */     this.page++;
/*    */   }
/*    */ 
/*    */   
/*    */   public int doAfterBody() throws JspException {
/* 57 */     if (this.page <= this.lastPage) {
/*    */       
/* 59 */       setPageAttributes(this.page);
/* 60 */       this.page++;
/* 61 */       return 2;
/*    */     } 
/*    */ 
/*    */ 
/*    */     
/*    */     try {
/* 67 */       this.content.writeOut((Writer)this.content.getEnclosingWriter());
/* 68 */       return 0;
/*    */     }
/* 70 */     catch (IOException e) {
/*    */       
/* 72 */       throw new JspTagException(e.toString());
/*    */     } 
/*    */   }
/*    */ 
/*    */ 
/*    */ 
/*    */   
/*    */   public int doEndTag() throws JspException {
/* 80 */     this.content = null;
/* 81 */     super.doEndTag();
/* 82 */     return 6;
/*    */   }
/*    */ 
/*    */   
/*    */   public void release() {
/* 87 */     this.content = null;
/* 88 */     super.release();
/*    */   }
/*    */ }


/* Location:              C:\Users\dhanabal\Desktop\Index\!\com\egurkha\jsp\indexer\PagesTag.class
 * Java compiler version: 1 (45.3)
 * JD-Core Version:       1.1.3
 */