import { addPlugin } from "react-native-flipper";
import ConnectionManager from "./connection-manager";
var FlipperConnectionManager = /** @class */ (function () {
    function FlipperConnectionManager(path) {
        var _this = this;
        this.openCallbacks = [];
        this.closeCallbacks = [];
        this.messageCallbacks = [];
        // handleConnect = (connection: Flipper.FlipperConnection) => {
        this.handleConnect = function (connection) {
            _this.flipperConnection = connection;
            connection.receive("sendReactotronCommand", function (data, responder) {
                _this.handleMessage(data);
                responder.success();
            });
            _this.openCallbacks.forEach(function (callback) { return callback(); });
        };
        this.handleMessage = function (data) {
            _this.messageCallbacks.forEach(function (callback) { return callback(data); });
        };
        this.handleDisconnect = function () {
            _this.flipperConnection = null;
            _this.closeCallbacks.forEach(function (callback) { return callback(); });
        };
        this.baseConnectionManager = new ConnectionManager(path);
        addPlugin({
            getId: function () {
                return "flipper-plugin-reactotron";
            },
            onConnect: this.handleConnect,
            onDisconnect: this.handleDisconnect,
            runInBackground: function () { return true; },
        });
    }
    FlipperConnectionManager.prototype.send = function (payload) {
        this.baseConnectionManager.send(payload);
        if (this.flipperConnection) {
            this.flipperConnection.send("Command", JSON.parse(payload));
        }
    };
    FlipperConnectionManager.prototype.on = function (event, callback) {
        this.baseConnectionManager.on(event, callback);
        switch (event) {
            case "open":
                if (this.flipperConnection) {
                    // If we are already connected, let them know right now.
                    callback();
                }
                this.openCallbacks.push(callback);
                break;
            case "close":
                this.closeCallbacks.push(callback);
                break;
            case "message":
                this.messageCallbacks.push(callback);
                break;
        }
    };
    FlipperConnectionManager.prototype.close = function () {
        this.baseConnectionManager.close();
    };
    return FlipperConnectionManager;
}());
export default FlipperConnectionManager;
