package com.eginnovations.react.plugin;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;

import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.eg.agent.android.*;

public class EgAgentModule extends ReactContextBaseJavaModule {

	private static final String NAME = "eGAgent";
	private Map<String, String> properties = new HashMap();

	private final ReactApplicationContext reactContext;

	public EgAgentModule(ReactApplicationContext reactContext) {
		super(reactContext);
		this.reactContext = reactContext;
	}

	@Override
	public String getName() {
		return NAME;
	}

	@ReactMethod
	public void start(ReadableMap properties, Callback cb) {
		Log.d("Starting... properties ", properties.toString());
		// System.out.println("Starting... properties " + properties);

		if (!properties.hasKey("appToken") || !properties.getType("appToken").equals(ReadableType.String)) {
			Log.e(getClass().getName(), "Could not start instrumentation: Invalid or missing appToken");
			return;
		}

		if (!properties.hasKey("hostUrl") || !properties.getType("hostUrl").equals(ReadableType.String)) {
			Log.e(getClass().getName(), "Could not start instrumentation: Invalid or missing hostUrl");
			return;
		}
		this.properties = new HashMap();
		this.properties.put("appToken", properties.getString("appToken"));
		this.properties.put("hostUrl", properties.getString("hostUrl"));
		final eGAndroidAgent agent = eGAndroidAgent.withCollectorHost(properties.getString("appToken"),
				properties.getString("hostUrl"));

		if (properties.hasKey("loggingEnabled") && properties.getType("loggingEnabled").equals(ReadableType.Boolean)) {
			agent.withLoggingEnabled(properties.getBoolean("loggingEnabled"));
			this.properties.put("loggingEnabled", String.valueOf(properties.getBoolean("loggingEnabled")));
		} else {
			agent.withLoggingEnabled(true);
			this.properties.put("loggingEnabled", String.valueOf(true));
		}

		if (properties.hasKey("logLevel") && properties.getType("logLevel").equals(ReadableType.Number)) {
			agent.withLogLevel(properties.getInt("logLevel"));
			this.properties.put("logLevel", String.valueOf(properties.getInt("logLevel")));
		} else {
			agent.withLogLevel(1);
			this.properties.put("logLevel", String.valueOf(1));
		}

		if (properties.hasKey("useSsl") && properties.getType("useSsl").equals(ReadableType.Boolean)) {
			agent.usingSsl(properties.getBoolean("useSsl"));
			this.properties.put("useSsl", String.valueOf(properties.getBoolean("useSsl")));
		} else {
			agent.usingSsl(false);
			this.properties.put("useSsl", String.valueOf(false));
		}

		try {
			agent.setAppliactionPlatform(AppPlatform.React);
			agent.start(reactContext);
			if (agent.isStarted()) {
				cb.invoke();
				Log.d("[eG]", "eGAgent started ");
			}
		} catch (RuntimeException e) {
			e.printStackTrace();
			cb.invoke(e.getMessage());
		}

	}

	@ReactMethod
	public void setUserName(String userName) {
		eGAndroidAgent.setUserName(userName);

	}

	@ReactMethod
	public void setUserAttribute(String key, String value) {
		eGAndroidAgent.setAttribute(key, value);

	}

	@ReactMethod(isBlockingSynchronousMethod = true)
	public String getUserInfo() {
		return MobileAgentUpload.getUserInfo();
	}

	@ReactMethod(isBlockingSynchronousMethod = true)
	public String getDevInfo() {
		return MobileAgentUpload.getDevInfo();
	}

	@ReactMethod(isBlockingSynchronousMethod = true)
	public String getAppinfo() {
		return MobileAgentUpload.getAppinfo();
	}

	@ReactMethod(isBlockingSynchronousMethod = true)
	public String getResInfo() {
		return MobileAgentUpload.getResInfo();
	}

	@ReactMethod(isBlockingSynchronousMethod = true)
	public String getCurrentActivityNameSync() {
		return getCurrentActivity().getLocalClassName();
	}

	@ReactMethod
	public void getCurrentActivityName(Promise p) {
		p.resolve(getCurrentActivityNameSync());

	}

	@Override
	public Map<String, Object> getConstants() {
		String /* appVersion, buildNumber, */ appName;

		try {
			appName = getReactApplicationContext().getApplicationInfo()
					.loadLabel(getReactApplicationContext().getPackageManager()).toString();
		} catch (Exception e) {
			appName = "unknown";
		}

		final Map<String, Object> constants = new HashMap<>();

		constants.put("deviceId", Build.BOARD);
		constants.put("bundleId", getReactApplicationContext().getPackageName());
		constants.put("systemName", "Android");
		constants.put("systemVersion", Build.VERSION.RELEASE);
		constants.put("appName", appName);
		constants.put("brand", Build.BRAND);
		constants.put("model", Build.MODEL);

		constants.putAll(properties);
		return constants;
	}

	@ReactMethod(isBlockingSynchronousMethod = true)
	public String getUserCountrySync() {
		return BaseAndroidAgent.getUserCountry(this.reactContext);
	}

	@ReactMethod
	public void getUserCountry(Promise p) {
		p.resolve(getUserCountrySync());
	}

	@ReactMethod(isBlockingSynchronousMethod = true)
	public String getDeviceNameSync() {
		try {
			String bluetoothName = Settings.Secure.getString(getReactApplicationContext().getContentResolver(),
					"bluetooth_name");
			if (bluetoothName != null) {
				return bluetoothName;
			}

			if (Build.VERSION.SDK_INT >= 25) {
				String deviceName = Settings.Global.getString(getReactApplicationContext().getContentResolver(),
						Settings.Global.DEVICE_NAME);
				if (deviceName != null) {
					return deviceName;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			// same as default unknown return
		}
		return "unknown";
	}

	@ReactMethod
	public void getDeviceName(Promise p) {
		// System.out.println("getDeviceName :: "+getDeviceNameSync());
		p.resolve(getDeviceNameSync());
	}

	@ReactMethod(isBlockingSynchronousMethod = true)
	public String getBaseOsSync() {
		return "Android";
	}

	@ReactMethod
	public void getBaseOs(Promise p) {
		p.resolve(getBaseOsSync());
	}

}
