"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var path = require("path");
exports.PATCHES = [
    {
        name: "eG Innovations build plugin link",
        anchor: /^((\s*\n)*(\/\/.+\n|\/\*[^]*\*\/))*/g,
        payload: "\n// Applies the eG Innovations build time instrumentation plugin.\n" +
            "// This should be placed at the top of your top-level build.gradle file.\n" +
            "buildscript {"+
                "repositories {"+
                    "flatDir {"+
                        "dirs '../node_modules/react-native-eg-agent/android/eg-agent'"+
                    "}"+
                "}"+
                "apply plugin: 'android'"+
                "apply plugin: 'eg'"+

                "dependencies {"+
                    "classpath fileTree( exclude: ['a*.jar'], include: ['a*.jar'], dir: '../node_modules/react-native-eg-agent/android/eg-agent')"+
                "}"+
            "}",
        target: path.join(process.cwd(), 'android/build.gradle')
    },
    {
        name: "eG Innovations app build plugin link",
        anchor: /^((\s*\n)*(\/\/.+\n|\/\*[^]*\*\/))*/g,
        payload: "\n// Applies the eG Innovations agent plugin.\n" +
            "// This should be placed at the top of your top-level build.gradle file.\n" +
            "buildscript {"+
                "repositories {"+
                    "flatDir {"+
                        "dirs '../../node_modules/react-native-eg-agent/android/eg-agent'"+
                    "}"+
                "}"+
                "dependencies {"+
                    "classpath fileTree(include: ['*.jar'], dir: '../../node_modules/react-native-eg-agent/android/eg-agent')"+
                "}"+
            "}",
        target: path.join(process.cwd(), 'android/build.gradle')
    }
];
