<!DOCTYPE html>

<%
/************************************************************************************************
*	File				:	ErDBUptimePrint.jsp
*	Version			:	7.2
*	Author			:	Suganya.S
*	Creation Date	:	03-09-2021
*
*************************************************************************************************/
%>


<%@ include file="ErTracker.jsp"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgReportInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import="egurkha.reporter.*"%>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="com.eg.* "%>
<%@ page import="java.net.*"%>
<%@ page import="java.util.*"%>
<%@ page import="net.sf.json.*" %>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import="com.egurkha.util.DateUtil"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ page import="com.egurkha.util.StringUtils"%>

<%@ page import="com.eg.EgReportInfo" %>

<%
	String COLON = ":";
	String pdfPrint = request.getParameter("pdfPrint");
	String titleToDisplay=request.getParameter("er_RmDispName");
	String s_st_date = request.getParameter("startdate");
	String s_en_date = request.getParameter("enddate");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String strmin = request.getParameter("startmin");
	String enmin = request.getParameter("endmin");
	
	if(s_st_date==null)
	{
		s_st_date = request.getParameter("er_stdate");
	}
	if(s_en_date==null)
	{
		s_en_date = request.getParameter("er_enddate");
	}
	if(s_st_hr==null)
	{
		s_st_hr = request.getParameter("er_sthr");
	}
	if(s_en_hr==null)
	{
		s_en_hr = request.getParameter("er_endhr");
	}
	if(strmin==null)
	{
		strmin = request.getParameter("er_stmin");
	}
	if(enmin==null)
	{
		enmin = request.getParameter("er_endmin");
	}

	String timefrom2=request.getParameter("timefrom");
	String minfrom2=request.getParameter("minfrom");
	String timeto2=request.getParameter("timeto");
	String minto2=request.getParameter("minto");
	String er_component[] = request.getParameterValues("er_component");
	String er_componentStr = request.getParameter("er_component");
	String er_componentType=request.getParameter("er_compType");
	String er_site = request.getParameter("er_site");
	String er_option =request.getParameter("er_option");
	String templateFor = request.getParameter("templateFor");
	String installDir = EgInstallInfo.getInstallDir();
	String s_iniFile_dir = installDir+ "/manager/config/";
	EgReportInfo reportInfo=new EgReportInfo("manager");
	ErUtils erUtils = new ErUtils();
	EgMappingInfo intlmap = null;
	if (thisuser != null) 
	{
		intlmap = new EgMappingInfo(thisuser.getLanguage());
	}
	
	String componentTypeDisp = "";
	if(er_componentType!=null)
	{
		componentTypeDisp = intlmap.getComponentTypeDescription(er_componentType);
		if(componentTypeDisp.equalsIgnoreCase("All"))
		{
			componentTypeDisp = intlmap.getTextDescription("reporter.common.All Component Types");
		}
	}
	String headerKeyName="";
	if(er_option!=null && er_option.equalsIgnoreCase("Segment"))
	{
		headerKeyName=er_option+" : "+er_site;
	}
	else if(er_option!=null && er_option.equalsIgnoreCase("Service"))
	{
		headerKeyName=er_option+" : "+er_site;
	}
	else if(er_option!=null && er_option.equalsIgnoreCase("Component"))
	{
		headerKeyName=er_option;
	}
	else
	{
		headerKeyName="Zone"+" : "+er_site;
	}
	try 
	{
		EgTimeZoneConverter timeZoneConverterStart = null;
		EgTimeZoneConverter timeZoneConverterEnd = null;
		String startDateForDisplay = null;
		String startHourForDisplay = null;
		String endDateForDisplay = null;
		String endHourForDisplay = null;
		String startMinForDisplay = null;
		String endMinForDisplay = null;

		String mngrIP = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
		mngrIP = "../..";
		String strManagerURL = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort();
		String controllerURL = strManagerURL+"/final/servlet/com.eg.ErTemplateC;jsessionid=" + session.getId() + "?";
%>

<!Doctype html>
<head>
<%
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
	<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
	&nbsp; &nbsp; <egui:intnl text="reporter.common.Print" /> &nbsp;</title>
<%
	}
	else
	{
%>
	<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
	&nbsp; &nbsp;</title>
<%
	}
%>

<meta name="Author" content="">
<meta  charset="UTF-8">
<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
<style type="text/css" media="print">
@media print {body {-webkit-print-color-adjust: exact;}}
#printbt{ display:none}
</style>

</head>
<body  style="padding:10px;background-color:#ffffff">
<%
	String strLogCls = "printHeaderBoxLogo";
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
		strLogCls = "printHeaderBoxLogo";
	}
	else
	{
		strLogCls = "printPdfHeaderBoxLogo";
	}
%>
	<div class="<%=strLogCls%>" style="padding-top:10px"><img src="<%=imageName%>" border="0" /></div>
	<div class="printHeaderBox">
<%
	if (!StringUtils.isNull(titleToDisplay))
	{
%>
		<div class="printHeaderBoxTitle"><%=titleToDisplay%> for &nbsp;<%=headerKeyName%>&nbsp;</div>
<%
	}
	else
	{
%>
		<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.eG Report " />&nbsp;<%=headerKeyName%>&nbsp;</div>
<%
	}
	if (pdfPrint != null && pdfPrint.equalsIgnoreCase("yes")) 
	{
%>
		<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse"  src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
	}
%>
	</div>
	<div class="printOuterBoxNoBorder"> 
<%
	String dispStart = "";
	String dispEnd = "";
	dispStart = s_st_date + " " + s_st_hr + COLON + strmin ;
	dispEnd = s_en_date + " " + s_en_hr + COLON + enmin ;
	//Time zone Conversion
	timeZoneConverterStart = new EgTimeZoneConverter(dispStart ,thisuser);
	startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
	startHourForDisplay = timeZoneConverterStart.getHour();
	startMinForDisplay = timeZoneConverterStart.getMinute();

	timeZoneConverterEnd = new EgTimeZoneConverter(dispEnd ,thisuser);
	endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
	endHourForDisplay = timeZoneConverterEnd.getHour();
	endMinForDisplay = timeZoneConverterEnd.getMinute();

	String pdfStartDate = startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
	String pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;

	String Days = reportInfo.getExcludeWeekend(templateFor);
	String excludeweekend=request.getParameter("er_excwe");
	if (excludeweekend==null ||	excludeweekend.equals(""))
	{
		excludeweekend="No";
	}
	Vector dvec = new Vector();
	String stimefmt =	pdfStartDate+ " hrs";
	String etimefmt =	pdfEndDate+ " hrs";
	String ssd="Start Date : "+stimefmt+"  "+"End Date : "+etimefmt;
%>
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Analyze by" /> - <span class="bold"><%=intlmap.getTextDescription("reporter.common."+er_option)%></span></div>
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Component Type" /> - <span class="bold"><%=componentTypeDisp%></span></div>
<%
	String compTypeInfo = intlmap.getTextDescription("reporter.common.Component Type")+" : " +componentTypeDisp;
	
	String componentInfo = "" ;
	
	if(er_component!=null)
	{
		for(int i=0;i<er_component.length;i++)
		{
			String temp = er_component[i];
			if(temp!=null)
			{
				if(temp.equalsIgnoreCase("all"))
				{
					temp = intlmap.getTextDescription("reporter.common.All Components");
				}
				else
				{
					if(temp.indexOf(":")>-1)
					{
						temp  = temp.substring(0,temp.lastIndexOf(":"));
					}
					if(temp.endsWith(":NULL"))
					{
						temp  = temp.substring(0,temp.lastIndexOf(":"));
					}
				}
				componentInfo+=temp+",";
			}
		}
		if(componentInfo.endsWith(","))
		{
			componentInfo = componentInfo.substring(0,componentInfo.length()-1);
		}
	}
	if(er_componentStr!=null && er_componentStr.equalsIgnoreCase("all"))
	{
%>
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Components" /> - <span class="bold"><egui:intnl text="reporter.common.All Components" /></span></div>
<%
	}
	else if(componentInfo!=null && componentInfo.length()>0)
	{
		if(componentInfo.length()>32)
		{
			componentInfo = componentInfo.substring(0,31)+"...";
		}
%>
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Components" /> - <span class="bold"><%=componentInfo%></span></div>
<%
	}
%>
	<div class="printSelectionFields"><egui:intnl text="reporter.common.Timeline" /> - <span class="bold"><%=stimefmt%>&nbsp;to <%=etimefmt%></span></div>
<%
	String sessionName = templateFor.toUpperCase()+"_RESULT";
	HashMap resultMap = (HashMap)session.getAttribute(sessionName);
	boolean noDataFound = false;
	if(resultMap==null || resultMap.size()==0)
	{
		noDataFound = true;
	}
%>
	</div>
<%
	if(!noDataFound)
	{
		JSONArray summaryArr = resultMap.get("summaryAry") != null ? (JSONArray)resultMap.get("summaryAry"):null;
		JSONArray recommendationsAry = resultMap.get("recommendationsAryPrint") != null ? (JSONArray)resultMap.get("recommendationsAryPrint"):null;
		JSONArray downTimeAry = resultMap.get("downTimeAry") != null ? (JSONArray)resultMap.get("downTimeAry"):null;
		JSONArray downTimeAryTable = resultMap.get("downTimeAryTable") != null ? (JSONArray)resultMap.get("downTimeAryTable"): null;
		JSONArray downtimeTableHeaderAry = resultMap.get("downtimeTableHeaderAry") != null ? (JSONArray)resultMap.get("downtimeTableHeaderAry"):null;
		String downTimeAryTableHeader = resultMap.get("downTimeAryTableHeader") != null ? (String)resultMap.get("downTimeAryTableHeader"):"";
		String recommendationTitle = resultMap.get("recommendationTitle") != null ? (String)resultMap.get("recommendationTitle"):"";
		String downTimeText = resultMap.get("downTimeText") != null ? (String)resultMap.get("downTimeText"): "";
		JSONObject barGraphObj = resultMap.get("barChartObj") != null ? (JSONObject)resultMap.get("barChartObj"): null;
		JSONArray observationAry = resultMap.get("observationAry") != null ? (JSONArray)resultMap.get("observationAry"):null;
		session.setAttribute("barChartObjSQLUptime",barGraphObj);
		String barChartURL=controllerURL+"command=IMAGE&option=print&er_width=850&er_height=300&sessionKey=barChartObjSQLUptime&templateFor="+templateFor;
		if(recommendationsAry.size()==0)
		{
			recommendationsAry.add("<div style='margin:0px 0px 6px 5px'><span class='newFont_normal13'>"+intlmap.getTextDescription("reporter.common.There were no Uptime / Downtime issues observed in this SQL")+"</span></div>");
			recommendationTitle=intlmap.getTextDescription("reporter.common.Conclusions / Recommendations");
		}
%>
		<%if(summaryArr!=null&&summaryArr.size()>0){%>
		<table align="center" style="width:100%" cellspacing="0" cellpadding="0" border="0">
			<tbody>
				<tr>
					<td>
						<div class="printOuterBox">
							<div class="printOuterBoxHeader">
								<egui:intnl text="reporter.common.Overview" />
							</div>
							<table width = "100%">
								<tr>
									<%for(int lp=0; lp < summaryArr.size(); lp++){
										JSONObject summaryObj = (JSONObject)summaryArr.get(lp);
										if(lp != summaryArr.size()-1){%>
									<td width="25%" style="border-color: #EBEBEB;border-style: solid;border-width: 0 1px 0px 0px;">
										<%}else{%>
									<td width="25%">
										<%}%>
										<table align="center" cellspacing="0" border="0" style="align:center;margin:auto auto;width:100%;">
											<tr>
												<td colspan="1" rowspan="1">
													<table align="center">
														<tr>
															<td align="right" style="padding-right:5px">
																<div class="<%=(String)summaryObj.get("iconCls")%>"></div>
															</td>
															<td class="newFont_bold28"><%=(String)summaryObj.get("data")%></td>
															<%if(lp != summaryArr.size()-1)
																{%>
															<td class="newFont_bold20">%</td>
															<%}%>
														</tr>
													</table>
												</td>
											</tr>
											<tr style="text-align: center;">
												<td colspan="1" rowspan="1" class="newFont_bold13"><%=(String)summaryObj.get("name")%></td>
											</tr>
										</table>
									</td>
									<%}%>
								</tr>
							</table>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<%}%>
		<table style="margin:10px 0px 10px 0px;width:100%" cellspacing="0" cellpadding="0" border="0">
			<tbody>
				<!--BAR CHART IMAGE CONTAINER STARTS HERE-->
				<tr>
					<td>
						<div class="printOuterBox">
							<table style="width:100%">
								<tbody>
									<tr>
										<td>
											<div class="printOuterBoxHeader">
												<egui:intnl text="reporter.common.Uptime Analysis" />
											</div>
											<div>
												<img src="<%=barChartURL%>"/>
											</div>
										</td>
									</tr>
									<%if(downTimeAryTable!=null&&downTimeAryTable.size()>0){%>
									<tr>
										<td>
											<div style="font-size: 15px;font-weight: 500;margin: 0px 0px 10px 0px;"><%=downTimeAryTableHeader%></div>
											<div class="newTable">
												<table style="width:100%">
													<thead>
														<tr>
															<%ArrayList tempList = new ArrayList();
																for(int j=0; j < downtimeTableHeaderAry.size(); j++)
																{
																	String headerName=(String)downtimeTableHeaderAry.get(j);
																	%>
															<%if(j==0){%>
															<th align="center"><%=headerName%></th>
															<%}
																else
																{
																%>
															<th align="left"><%=headerName%></th>
															<%}%>
															<%}%>
														</tr>
													</thead>
													<tbody>
														<%for(int k=0;k<downTimeAryTable.size();k++){
															JSONObject outliersObj = (JSONObject)downTimeAryTable.get(k);
															%>
														<tr>
															<td align="center">
																<div class="<%=(String)outliersObj.get("type")%>"></div>
															</td>
															<td align="left"><%=(String)outliersObj.get("shutDate")%></td>
															<td align="left"><%=(String)outliersObj.get("rebootDate")%></td>
															<td align="left"><%=(String)outliersObj.get("duration")%></td>
														</tr>
														<%}%>
													</tbody>
												</table>
											</div>
										</td>
									</tr>
									<%}%>
									<%
									String seperatorCls="jvmGraphSeperatorLineRight";
									if(observationAry!=null&&observationAry.size()>0){
										if(observationAry.size()==1)
										{
											seperatorCls="";
										}
									%>
									<tr>
										<td>
											<div style="background-color: #f2f2f2; border: 1px solid #d5d5d5;margin:10px 0px 0px 0px;" class="<%=seperatorCls%>">
												<div style="padding:10px 0px 10px 10px" class="newFont_bold15 jvmNotes">
													<egui:intnl text="reporter.common.Observations" />
												</div>
												<div style="margin:0px 0px 0px 0px;padding: 0 20px 0 10px;">
													<table style="width:100%;margin-bottom:10px;">
														<tbody>
															<%for(int lp=0; lp < observationAry.size(); lp=lp+2){
																String observationOne=null;
																String observationTwo=null;
																if(lp<observationAry.size())
																{
																	 observationOne = (String)observationAry.get(lp);
																}
																if(lp+1<observationAry.size())
																{
																	 observationTwo = (String)observationAry.get(lp+1);
																}
																%>
															<tr style="padding-bottom:10px;">
																<%if(observationOne!=null){%>
																<td width="50%" class="jvmHeaptable">
																	<table style="width:100%">
																		<tr>
																			<%if(pdfPrint!=null && pdfPrint.equalsIgnoreCase("yes")){%>
																			<td width="10px" style="vertical-align:top;padding-top:7px;">
																				<div style="height:8px;width:8px;border-radius: 4px; border:2px solid #707070;">&nbsp;</div>
																			</td>
																			<%}
																				else
																				{%>
																			<td width="10px" style="padding: 0 10px 10px 0;">
																				<svg xmlns="http://www.w3.org/2000/svg"  width="20" height="20">
																					<g>
																						<circle cx="15" cy="15" r="3" fill="none" stoke-width="3" stroke="#707070"></circle>
																					</g>
																				</svg>
																			</td>
																			<%}%>
																			<td><%=observationOne%></td>
																		</tr>
																	</table>
																</td>
																<%}%>
																<%if(observationTwo!=null){%>
																<td width="50%" class="jvmHeaptable">
																	<table>
																		<tr>
																			<%if(pdfPrint!=null && pdfPrint.equalsIgnoreCase("yes")){%>
																			<td width="10px" style="vertical-align:top;padding-top:7px;">
																				<div style="height:8px;width:8px;border-radius: 4px; border:2px solid #707070;">&nbsp;</div>
																			</td>
																			<%}
																				else
																				{%>
																			<td width="10px" style="padding: 0 10px 10px 0;">
																				<svg xmlns="http://www.w3.org/2000/svg"  width="20" height="20">
																					<g>
																						<circle cx="15" cy="15" r="3" fill="none" stoke-width="3" stroke="#707070"></circle>
																					</g>
																				</svg>
																			</td>
																			<%}%>
																			<td><%=observationTwo%></td>
																		</tr>
																	</table>
																</td>
																<%}%>
															</tr>
															<%}%>
														</tbody>
													</table>
												</div>
											</div>
										</td>
									</tr>
									<%}%>
								</tbody>
							</table>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<%if(recommendationsAry!=null&&recommendationsAry.size()>0){%>
		<table style="margin:5px 5px 10px 0px;" cellspacing="0" cellpadding="0" border="0" width="100%">
			<tbody>
				<tr>
					<td>
						<div class="notes" style="width:100%;padding: 10px 0px 0px 10px;">

					<%
						if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
						{
					%>
							<div class="paperPin"> </div>
					<%
						}
						else
						{
					%>
							<div style="top:-15px" class="paperPin"> </div>
					<%
						}
					%>
							<div style="padding:0px 0px 10px 0px;line-height: 1.5em" class="newFont_bold15">
								<%=recommendationTitle%>
							</div>
							<table style="line-height: 1.5em" width="100%">
								<tbody>
									<%for(int lp=0; lp < recommendationsAry.size(); lp++){%>
									<tr>
										<%if(pdfPrint!=null && pdfPrint.equalsIgnoreCase("yes")){%>
										<td width="10px" style="padding: 0 0 10px 0;">
											<div style="height:8px;width:8px;border-radius: 4px; border:2px solid #707070;">&nbsp;</div>
										</td>
										<%}
											else
											{%>
										<td width="10px" style="padding: 0 10px 20px 0;">
											<svg xmlns="http://www.w3.org/2000/svg"  width="20" height="20">
												<g>
													<circle cx="15" cy="15" r="3" fill="none" stoke-width="3" stroke="#707070"></circle>
												</g>
											</svg>
										</td>
										<%}%>
										<td style="padding: 0 0 10px 0;"><%=(String)recommendationsAry.get(lp)%></td>
									</tr>
									<%}%>
								</tbody>
							</table>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<%
		}
	}
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
		<div class="printFooterText"><%=strPrintFooterText%></div>
<%
	}
%>
	</body>
</html>
<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>
<%@ include file = "ErRemoveUser.jsp" %>
<%
if(titleToDisplay!=null && !titleToDisplay.isEmpty())
{
	//For Setting the PDf File Name
	String reportFileName=customReplaceAll(titleToDisplay," ","_");
	HashMap paramVal =new HashMap();
	paramVal.put("fileName",reportFileName);
	session.setAttribute("parameters", paramVal);
}
%>
<%!
public  String customReplaceAll(String source,String toReplace,String replacement) 
{
	int idx = source.lastIndexOf(toReplace);
	if (idx != -1) {
		StringBuffer ret = new StringBuffer(source);
		ret.replace(idx, idx + toReplace.length(), replacement);
		while ((idx = source.lastIndexOf(toReplace, idx - 1)) != -1) {
			ret.replace(idx, idx + toReplace.length(), replacement);
		}
		source = ret.toString();
	}
	return source;
}
%>