<%
/*
	Author			:	James Thomas
	Creation Date	:	06th September 2006
	Purpose			:	To display zones, services, services and independent components
	Design Changes	:	Jaiwin
*/	
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %> 
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page errorPage="EgProbsM.jsp" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "java.util.Hashtable" %>
<%@ page import="com.egurkha.monitor.ZoneDashboardData"%>
<%@ page import="com.egurkha.monitor.ZoneDashboardResult"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	ZoneDashboardData d = (ZoneDashboardData) session.getAttribute("zoneDashboardData");
	ZoneDashboardResult r = (ZoneDashboardResult) session.getAttribute("zoneDashboardResult");

	int columnWidth = 100;
	String states[]={"GOOD","UNKNOWN","LOW","INTERMEDIATE","HIGH"};
	IniUI ui = (IniUI)IniUI.getInstance();
	
	Health zonesHealth = (Health) r.zonesHealth;
	Health servicesHealth = (Health) r.servicesHealth;
	Health segmentsHealth = (Health) r.segmentsHealth;
	Health independentComponentsHealth = (Health) r.independentComponentsHealth;
	Health aggregateComponentsHealth = (Health) r.aggregateComponentsHealth;

	long zonesTotal = zonesHealth.getTotal();
	long servicesTotal = servicesHealth.getTotal();
	long segmentsTotal = segmentsHealth.getTotal();
	long independentComponentsTotal = independentComponentsHealth.getTotal();
	long aggregateComponentsTotal = aggregateComponentsHealth.getTotal();

	if (zonesTotal == 0  && servicesTotal == 0 && segmentsTotal == 0 && independentComponentsTotal == 0 && aggregateComponentsTotal == 0)
	{
%>
		<jsp:forward page="empty.jsp" >
			<jsp:param name="reason" value="No components have been enabled for monitoring"/>
		</jsp:forward>
<%
	}

	Hashtable backgroundColorAndState = new Hashtable();
	backgroundColorAndState.put("0id", "GOOD_bg");
	backgroundColorAndState.put("1id", "UNKNOWN_bg");
	backgroundColorAndState.put("2id", "LOW_bg");
	backgroundColorAndState.put("3id", "INTERMEDIATE_bg");
	backgroundColorAndState.put("4id", "HIGH_bg");
	backgroundColorAndState.put("0state", "GOOD");
	backgroundColorAndState.put("1state", "UNKNOWN");
	backgroundColorAndState.put("2state", "LOW");
	backgroundColorAndState.put("3state", "INTERMEDIATE");
	backgroundColorAndState.put("4state", "HIGH");
%>

<html>
<head>

<title>&nbsp;Elements Status</title>
 <egui:skin ui="monitor"/>
</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0"  style="over-flow:auto">
<jsp:useBean id="trans" scope ="page" class="egurkha.TransactionBean" />
<table width="100%" cellpadding="0" cellspacing="0" border="0" ><col width="30%"><col width="10%"><col width="60%">
<tr>
	<td nowrap align="left" id="cell_border1" height="25">&nbsp; 
<%
	if(zonesTotal > 0)
	{
%>
	<a href="../servlet/com.eg.EgMonitorController?monCmd=zoneList&from=ZoneDashboard&action=zone&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>" target="_parent" class="eg_monlink">
<%
	}
	else
	{
%>
		<a <%=zonesTotal>0?"class=\"eg_monlink\"":""%>>
<%
	}	
%>
		<egui:intnl text="monitor.zonehome.Sub Zones"/></a>
	</td>
	<td nowrap align="center"  id="cell_border2" class="eg_8">
		<%=zonesTotal%>
	</td>
	<td nowrap align="left" height="25" style="padding-right:0px;padding-left:0px;border-right-width:0px" id="cell_border1" >
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<tr>
<%
			for (int i=0; i<states.length; i++)
				{
					long stateCount = zonesHealth.getValue(State.getState(states[i]));
					if (stateCount==0)
					continue;
%>
				<a href="../servlet/com.eg.EgMonitorController?monCmd=zoneList&from=ZoneDashboard&action=zoneState&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&stateName=<%=backgroundColorAndState.get(i+"state")%>" target="_parent" >		
			<span>
			<td   align="center" valign="middle" class="mouse" 	width="<%=(stateCount*100/columnWidth)%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=zoneList&from=ZoneDashboard&action=zoneState&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&stateName=<%=backgroundColorAndState.get(i+"state")%>')"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight:normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;</font></td>
			</span>
			</a>
<%
				}
%>
		</tr>
<%	
		if(zonesTotal==0)
		{
%>
<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
		}
%>
		</table>
		
	</td>
</tr>
<tr>
	<td nowrap align="left" height="25" id="cell_border1" >&nbsp;
<%
	if(servicesTotal>0)
	{
%>
	<a href="../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=ZoneDashboard&action=service&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>" target="_parent" class="eg_monlink">
<%
	}
	else
	{
%>
	<a # class="eg_monlink">
<%
	}
%>
	<egui:intnl text="monitor.zonehome.Services"/></a>
	</td>
	<td nowrap align="center"  id="cell_border2" class="eg_8" >
				<%=servicesTotal%></td>
	<td nowrap align="left"  style="padding-right:0px;padding-left:0px;border-right-width:0px" id="cell_border1" >
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = servicesHealth.getValue(State.getState(states[i]));
				if (stateCount==0)
					continue;
		%>
			<a href="../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=ZoneDashboard&action=serviceState&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&stateName=<%=backgroundColorAndState.get(i+"state")
			%>" target="_parent">
			
			<span>
			<td  align="center" valign="middle" class="mouse" width="<%=(stateCount*100/columnWidth)%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=ZoneDashboard&action=serviceState&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&stateName=<%=backgroundColorAndState.get(i+"state")
			%>')"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;</font></td>
			</span>
			</a>
			<%
			}
%>
<%	
		if(servicesTotal==0)
		{
%>
<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
		}
		%>
		</table>
	
	</td>
</tr>		
<tr>
	<td  id="cell_border1" height="25" nowrap align="left" > &nbsp;
	
<%
	if(segmentsTotal>0)
	{
%>		
		<a href="../servlet/com.eg.EgMonitorController?monCmd=segmentList&from=ZoneDashboard&action=segment&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>" target="_parent" class="eg_monlink">
<%
	}
	else
	{
%>
		<a # class="eg_monlink">
<%
	}
%>
	<egui:intnl text="monitor.common.Segments"/></a>
	</td>
	<td nowrap align="center" id="cell_border2" class="eg_8">
				<%=segmentsTotal%></td>
	<td nowrap align="left"  style="padding-right:0px;padding-left:0px;border-right-width:0px" id="cell_border1" >
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<tr>
		<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = segmentsHealth.getValue(State.getState(states[i]));
				if (stateCount==0)
					continue;
		%>
			<a href="../servlet/com.eg.EgMonitorController?monCmd=segmentList&from=ZoneDashboard&action=segmentState&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&stateName=<%=backgroundColorAndState.get(i+"state")
		%>" target="_parent">			
			<span>
			<td  align="center" valign="middle" class="mouse" 	width="<%=(stateCount*100/columnWidth)%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=segmentList&from=ZoneDashboard&action=segmentState&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&stateName=<%=backgroundColorAndState.get(i+"state")
		%>')"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;</font></td>
			</span>
			</a>
			<%
			}
			%>
			</tr>
<%	
		if(segmentsTotal==0)
		{
%>
<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
		}
%>
		</table>
		
	</td>
</tr>
<%
if(!(aggregateComponentsTotal==0))
{
%>
<tr>
	<td nowrap align="left" id="cell_border1" height="25" style="padding-right:0px;padding-left:0px;border-right-width:0px" >&nbsp;<a <%=(aggregateComponentsTotal>0)?"href=\"../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&zes=true&zoneName="+EgURLEncoder.encode(d.zoneName,"UTF-8")+"&zName="+d.zoneName+"&searchIndComps=true&action=component&menuName=agg\"":"#"%> target="_parent" class="eg_monlink"> <egui:intnl text="monitor.zonehome.Aggregates"/></a>
	</td>
	<td nowrap align="center"  id="cell_border2" class="eg_8">
				<%=aggregateComponentsTotal%></td>
	<td nowrap align="center" id="cell_border1">
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<tr>
		<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = aggregateComponentsHealth.getValue(State.getState(states[i]));;
				if (stateCount==0)
				continue;
		%>
		<a href="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&action=componentState&searchIndComps=true&menuName=agg&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&stateName=<%=backgroundColorAndState.get(i+"state")%>" target="_parent">
		<span>
			<td  align="center" valign="middle" class="mouse"  width="<%=(stateCount*100/columnWidth)%>%" id="<%=backgroundColorAndState.get(i+"id")%>"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;" onClick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&action=componentState&menuName=agg&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&stateName=<%=backgroundColorAndState.get(i+"state")%>')">&nbsp;<%=stateCount%>&nbsp;</font></td>
		</span>
		</a>			
<%
	}	
%>
		</tr>
<%	
	if(aggregateComponentsTotal==0)
	{
%>
		<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
	}
%>
		</table>	
		
	</td>
</tr>
<%
}
%>
<tr>
	<td nowrap align="left" id="cell_border1" height="25" style="border-bottom-width:1px">&nbsp;
<%
	if(independentComponentsTotal>0)
	{
%>
		<a href="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&searchIndComps=true&action=component&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>" target="_parent" class="eg_monlink">
<%
	}
	else
	{
%>
		<a # class="eg_monlink">
<%
	}
%>
		<egui:intnl text="monitor.zonehome.Components"/></a>
	</td>
	<td nowrap align="center"  id="cell_border2" style="border-bottom-width:1px" class="eg_8">
				<%=independentComponentsTotal%></td>
	<td nowrap align="center"  style="padding-right:0px;padding-left:0px;border-bottom-width:1px;border-right-width:0px" id="cell_border1" >
		<table width="<%=columnWidth%>%" border="0" cellspacing="0" cellpadding="0" height="15">
		<tr>
		<%
			for (int i=0; i<states.length; i++)
			{
				long stateCount = independentComponentsHealth.getValue(State.getState(states[i]));;
				if (stateCount==0)
				continue;
		%>
		<a href="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&searchIndComps=true&action=componentState&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&stateName=<%=backgroundColorAndState.get(i+"state")%>" target="_parent">
		<span>
			<td  align="center" valign="middle" class="mouse"  width="<%=(stateCount*100/columnWidth)%>%" id="<%=backgroundColorAndState.get(i+"id")%>" onclick="loadURL('../servlet/com.eg.EgMonitorController?monCmd=componentList&from=ZoneDashboard&searchIndComps=true&action=componentState&zoneName=<%=EgURLEncoder.encode(d.zoneName,"UTF-8")%>&stateName=<%=backgroundColorAndState.get(i+"state")%>')"><font face="Verdana,Arial" style="font-family: Verdana,Arial; font-size: 11px; font-weight: normal; letter-spacing: 1px;">&nbsp;<%=stateCount%>&nbsp;</font></td>
		</span>
		</a>			
<%
			}	
%>
		</tr>
<%	
		if(independentComponentsTotal==0)
		{
%>
<tr><td align="center"><!--egui:intnl text='monitor.zonehome.None'/-->&nbsp;</td></tr>
<%
		}
%>
		</table>
	</td>
</tr>
</table>
</body>
<script language="javascript">
function loadURL(myURL)
{
	if(window.parent!=null)
	{
		window.parent.location.href=myURL;
	}
}
</script>
</html>