<%
/********************************************************************************************************
*	Name			:	serviceUsers.jsp
*	Purpose			:	This jsp is used to display users and their associated services
*	Version			:	5.4
*	ModifedDate		:	Nov 29 2011
*	Modified		:	S.Saravanan
*******************************************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page errorPage="EgErrorSmall.jsp" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "java.util.*" %>
<%@ page import="com.egurkha.util.*"%>
<%@ page import = "com.egurkha.ini.*" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragma","no-cache");
response.setDateHeader ("Expires", -1);
response.setContentType("application/json");
UserServicesResult r = (UserServicesResult) request.getAttribute("result");
UserServicesData d = (UserServicesData) request.getAttribute("data");
String treeFlag=request.getParameter("treeFlag");
long refreshFrequency = 60 * 1000L;
String refFreq = d.user.getRefreshFrequency();
IniUI iniUI = IniUI.getInstance();
UserRegistry userReg = UserRegistry.getInstance();
User users = userReg.getUser(session.getId());
EgTopoInfo topoInfo=new EgTopoInfo("manager");
String thisLanguage = iniUI.getDefaultLanguage();
int displayNameLength = 28;
int displayHeadLength = 10;
if (users!=null)
{
	String userLang = users.getLanguage();
	if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
	{
		thisLanguage=userLang;
	}
}
boolean isUserLanguageEnglish=true;
if(thisLanguage!=null && !thisLanguage.equals("en_US"))
{
	isUserLanguageEnglish=false;
}
if(refFreq!=null && refFreq.length()>0)
{
	refreshFrequency =  Long.valueOf(refFreq).longValue() * 1000L;	
}


%>

<%
try{
/* UserRegistry registry = UserRegistry.getInstance();
User users = registry.getUser(session.getId()); 
String thisLanguage="";
 try
{
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	thisLanguage = ui.getDefaultLanguage();
	if (users!=null)
	{
		String userLang = users.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
}
catch(Exception e)
{
	System.out.println(e);
}*/
//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage); 

JSONObject json  = new JSONObject();
JSONObject labelObj= new JSONObject();
JSONArray serviceData= new JSONArray(); 
JSONObject serviceDataObject = new JSONObject();

if(d.from!=null && d.from.equals("serviceGroup"))
{
	labelObj.put("monitor.associationsservices.Services",mappingInfo.getTextDescription("monitor.associationsservices.Service Groups"));
}
else
{
	labelObj.put("monitor.associationsservices.Services",mappingInfo.getTextDescription("monitor.associationsservices.Services"));
}

labelObj.put("monitor.associationsservices.Users",mappingInfo.getTextDescription("monitor.associationsservices.Users"));
json.put("screenLabels",labelObj); 

if (r.serviceList!=null)
{
	int i = 0;
	ArrayList userList = null;
	EgService service = null;
	ArrayList none = new ArrayList();
	if(r.serviceList.size()>0)
	{
		for(i = 0; i < r.serviceList.size(); i++)
		{
			userList = new ArrayList();
			int IntCount=0;
			if(r.showImage)
				IntCount=4;//12;
			else
				IntCount=4;
			service = (EgService) r.serviceList.get(i);
			//userList = none;
			if(r.serviceUsers.get(service.getName()) != null)
			{
				userList = (ArrayList) r.serviceUsers.get(service.getName());
			}
			
			
			 ArrayList sitesOnly = topoInfo.getAllSitesOnly();
			boolean isSite=false;
			if(sitesOnly!=null)
			{
				if(sitesOnly.contains(service.getName()))
				{
					isSite=true;
				}
				else
				{
					isSite=false;
				}
			}
			
			String siteText = "";
			
			if(isSite){
				siteText="(Site)";
			}
			
			serviceDataObject.put("name",service.getName()+siteText);
			serviceDataObject.put("iconClass","state_footer_"+service.getState().getName());
				serviceDataObject.put( "link","/final/monitor/serviceDashboard.jsp?treeFlag="+treeFlag+"&outsideService=true&titleText=Services&selectNode=Service$cap$"+EgURLEncoder.encode(service.getName(),"UTF-8")+EgURLEncoder.encode(com.egurkha.util.StringUtils.encodeSecurityChar(siteText),"UTF-8") + "&serviceFromZone="+EgURLEncoder.encode(service.getName(),"UTF-8") );
		
			
			 if (userList != null && userList.size()>0)
			{
				/*for(int j = 0; (j < userList.size()); j++)					// Command by Prem for username display
				{
					String user = null;
					if(j < userList.size())
					{
						user = (String) userList.get(j);
					}

					serviceDataObject.put("userName",user);
				}*/
				serviceDataObject.put("userName",userList);
			}
			else
			{
				serviceDataObject.put("userName",mappingInfo.getTextDescription("monitor.associationszone.None"));
			}
			 serviceData.add(serviceDataObject);
		}
		
	}
 	else{
		serviceDataObject.put("error",mappingInfo.getTextDescription("monitor.services.No services found"));
	} 
}

 else
{
	serviceDataObject.put("error",mappingInfo.getTextDescription("monitor.services.No services found"));
}


json.put("serviceData",serviceData);

response.getWriter().write(json.toString());
}
catch(Throwable t){
	t.printStackTrace();
}
%>
