<%
/********************************************************************************************************
*	Name			:	msO365UserDashboardDataPrint.jsp
*	Purpose			:	To Save MS Office 365 User Dashboard Data as PDF and CSV
*	Version			:	eG 7.1.8 and Above
*	Creation Date	:	26/11/2020
*	Authtor			:	Saravanan.A
*******************************************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "java.util.Map.Entry"%>
<%@ page import = "java.io.*"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.egurkha.monitor.EgServerDashBoardDAO"%>
<%@ page import = "com.egurkha.monitor.EgServerDashboardModel"%>
<%@ page import = "com.egurkha.monitor.EgDashBoardModel"%>
<%@ page import = "com.egurkha.monitor.MeasuresDAO"%>
<%@ page import = "com.egurkha.monitor.MonitorDAOFactory"%>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.monitor.VmDashboardHelper"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "egurkha.reporter.ErUserData"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import="com.egurkha.ini.*"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "java.text.*" %>
<%@ page import = "java.math.*" %>
<%@ page import = "java.sql.Timestamp"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@  page import= "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgMaintenanceInfo"%>
<%@ page import = "com.eg.EgMetaThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	request.setCharacterEncoding("UTF-8");
%>

<!-- <link rel='stylesheet' type='text/css' href='/final/monitor/eg_styles/printPageStyles.css' /> -->
<%
	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO = monitorDaoFactory.getServerDashBoardDAO();

	Hashtable metaTest=(Hashtable)EgMetaThread.metaTest;
	if(metaTest == null)
		metaTest=new Hashtable(); 

try
{
	UserRegistry registry = UserRegistry.getInstance();
	User user = null; //registry.getUser(session.getId());
	String fromMenuStr = request.getParameter("fromMenu");
	boolean isFromMenu=false;
	if(fromMenuStr!=null && (fromMenuStr.equalsIgnoreCase("true") || fromMenuStr.equalsIgnoreCase("yes")))
		isFromMenu=true;
	if(isFromMenu)
		user = registry.getUser(session.getId(),true);
	else
		user = registry.getUser(session.getId());

	String showKeyUserStr = request.getParameter("showKeyUser");
	boolean showKeyUser=false;
	if(showKeyUserStr!=null && (showKeyUserStr.equalsIgnoreCase("true") || showKeyUserStr.equalsIgnoreCase("yes")))
		showKeyUser=true;

	String overviewType = request.getParameter("overviewType");

	String updateUserAssociateStr = request.getParameter("updateUserAssociate");
	boolean updateUserAssociateFlag=false;
	if(showKeyUser && updateUserAssociateStr!=null && (updateUserAssociateStr.equalsIgnoreCase("true") || updateUserAssociateStr.equalsIgnoreCase("yes")))
		updateUserAssociateFlag=true;

	//JSONObject jsonRoot = new JSONObject();
	EgUserRole userRole = null;
	boolean isAllCompAccess=false;
	boolean isDataManagerLogin=false;
	String userName = "admin";
	String file = "eg_officeUsersDetails.ini";
	String dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile ini = new IniFile(dir + file);
	IniFile uiIni = new IniFile(dir + "eg_ui.ini");

	boolean isDebugEnabled = false;
	int logFileSize = 30;

	String userExpLogging = ini.getValue("Logging","enableLogging");
	if(userExpLogging!=null && (userExpLogging.equalsIgnoreCase("true") || userExpLogging.equalsIgnoreCase("yes")))
		isDebugEnabled = true;

	if(isDebugEnabled){
		String fileSize = ini.getValue("Logging","fileSize");
		try{
			if(fileSize != null && fileSize.trim().length() > 0)
				logFileSize = Integer.parseInt(fileSize);

		}catch(Exception e){
			logFileSize = 30;
		}
	}

	int license_count=0;
	int unlicense_count=0;

	EgDateInfo egDt = new EgDateInfo();
	String dispDate=egDt.egetDate();
	EgMaintenanceInfo maintenanceInfo = new EgMaintenanceInfo("manager");

	String strEGManagerUser=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","eGManagerUser");
	strEGManagerUser=(strEGManagerUser==null || strEGManagerUser.trim().length()==0)?"false":strEGManagerUser;
	boolean isEGManagerUser = strEGManagerUser.equalsIgnoreCase("true")?true:false;

	String strO365UserTestCount=ini.getValue("OFFICE_USER_DASHBOARD_TITLE","EnableTestDataCount");
	strO365UserTestCount=(strO365UserTestCount==null || strO365UserTestCount.trim().length()==0)?"false":strO365UserTestCount;
	boolean isO365UserTestCount = strO365UserTestCount.equalsIgnoreCase("true")?true:false;

	String show_app_overview = ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","ShowApplicationsOverview");

	String userType = request.getParameter("userType");
	boolean isMSO365DD = (userType != null && userType.equals("MSO365DD"))?true:false;
	if(user==null && (!isFromMenu))
	{
		String login_user ="";
		if(isEGManagerUser)
			login_user = request.getParameter("user");

		userName=(login_user==null || login_user.trim().length()==0)?"admin":login_user;
		ErUserData userData = new ErUserData(userName,false);
		if(userData==null)
		{
			userName="admin";
			userData = new ErUserData(userName,false);
			user = userData.usr;
		}
		else if(userData!=null)
			user = userData.usr;

		if(user!=null)
		{
			userRole = user.getUserRole();
			isAllCompAccess = userRole.hasAllComponentAccess();
		}
	}
	else if(user!=null)
	{
		userName = user.getLoginID();
		userRole = user.getUserRole();
		isAllCompAccess = userRole.hasAllComponentAccess();
		isDataManagerLogin = true;
	}

	boolean isOnlyVMAssigned=false;
	boolean isVMAssigned=false;
	if(user!=null && user.isOnlyVMAssigned() && (!user.isVMAssigned()) && user.getOnlyVMs().size()>0 && userType!=null && userType.equalsIgnoreCase("VDI"))
		isOnlyVMAssigned=true;
	else if(user!=null && (!user.isOnlyVMAssigned()) && user.isVMAssigned() && user.getOnlyVMs().size()>0 && userType!=null && userType.equalsIgnoreCase("VDI"))
		isVMAssigned=true;
	else if(user!=null && user.isOnlyVMAssigned() && user.isVMAssigned() && user.getOnlyVMs().size()>0 && userType!=null && userType.equalsIgnoreCase("VDI"))
	{
		isOnlyVMAssigned=true;
		isVMAssigned=true;
	}
	EgTimeZoneConverter convert = null;
	writeLog(" userName  "+userName,isDebugEnabled,logFileSize);
	StringBuffer buf = new StringBuffer();
	IniUI ui = IniUI.getInstance();
	IniFile egEx = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_external.ini");
	IniFile egFormat  = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_format.ini");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgDbInfo Dbdata = new EgDbInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");
	EgGroupInfo groupInfo = new EgGroupInfo();
	EgServerDashboardModel dashboardModel = new EgServerDashboardModel();
	EgDashBoardModel egDashboard=new  EgDashBoardModel();
	String thisLanguage = ui.getDefaultLanguage();
	if(user!=null)
	{
		user.setUserLanguageAndSkins();
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			thisLanguage=userLang;
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String monitor_Skin = user.getMonitorSkin();
	VmDashboardHelper vmDashHelper=new VmDashboardHelper(user);
	List VmsList = new ArrayList();
	EgList egList=new EgList();
	String noOfInfoToDisplay = ""+10;
	EgList vdiDesktopsList= new EgList();
	EgList vdiDesktopsListTmp= new EgList();
	int vdiDesktopsListTotalCount=0;
	int groupByUserCount = 0;
	Hashtable finalDesktopVmsHash=new Hashtable();
	Hashtable infosCompHash=new Hashtable();
	ArrayList infolist = new ArrayList();
	ArrayList infolist1 = new ArrayList();
	ArrayList dbinfolist = new ArrayList();

	ArrayList ls_server=(ArrayList)user.getServersForType("MS_Office_365");
	ArrayList ls_server_count=new ArrayList();
	ls_server_count.addAll(ls_server);

	List resTypeList = new LinkedList();
	/*List resCnameList = new LinkedList();
	List resCompsList = new LinkedList();
	List resNickList = new LinkedList();
	List resPortList = new LinkedList();*/

	//Hashtable typeCompInfoHash=new Hashtable();
	//Hashtable componentsInfo = new Hashtable();
	//Hashtable measuresInfo = new Hashtable();
	Hashtable measureValues = new Hashtable();
	Hashtable commonMeasureValues = new Hashtable();
	//Hashtable user_count_hash = new Hashtable();
	ArrayList groupByUserKeys = new ArrayList();
	Hashtable finalGroupByUserTab = new Hashtable();
	//Hashtable groupByUser = new Hashtable();
	String maxUser="";
	//List componentTypeList=new ArrayList();
	List measureList = new ArrayList();
	String desktopUserName = request.getParameter("username");
	String isFromVCDS = request.getParameter("isFromVCDS");
	String searchString = (desktopUserName!=null && !desktopUserName.equalsIgnoreCase("") && desktopUserName.length()>0)?desktopUserName:request.getParameter("searchString");
	searchString=(searchString==null || searchString.trim().length()==0)?"":searchString;
	searchString = com.egurkha.util.StringUtils.decodeSecurityChar(searchString);
	boolean isAdtnlSearch = false;
	boolean addtionalSearchFlag = false;
	String adtnlSearchColumns = "";
	String adtnlSearchStr_EN = "";
	ArrayList addSearchColList = null;
	String adtnlSearchStr = request.getParameter("adtnlSearchStr");
	adtnlSearchStr = (adtnlSearchStr==null || adtnlSearchStr.trim().length()==0 || adtnlSearchStr.equalsIgnoreCase("NULL"))?"":adtnlSearchStr;
	String addSeachSubject = "Additional_Search";
	String additionalSearch = ini.getValue(addSeachSubject,"EnableAddtionalSearch");
	String adtnlSearchText = "";
	
	String searchStringVCDS ="";
	

	String priority = request.getParameter("priority");
	priority=(priority==null || priority.trim().length()==0)?"ALL":priority;
	String tmp_priority=priority;

	String vdiType = request.getParameter("vdiType");
	vdiType=(vdiType==null || vdiType.trim().length()==0)?"":vdiType;

	String orderBy =request.getParameter("orderBy");
	orderBy=(orderBy==null || orderBy.trim().length()==0)?"desc":orderBy;
	if(orderBy==null || orderBy.trim().length()==0 || orderBy.equalsIgnoreCase("null"))
	{
		orderBy="desc";
	}

	String dsInfo = request.getParameter("dsInfo");
	if(dsInfo!=null && dsInfo.trim().length()>0)
		dsInfo =com.egurkha.util.StringUtils.decodeSecurityChar(dsInfo);
	String showDSInfo=null;
	Hashtable vmsHash = new Hashtable();
	String dscomp = request.getParameter("dscomp");
	String dscomptype = request.getParameter("dscomptype");
	
	String dsmsmt_host = request.getParameter("dsmsmt_host");

	
	boolean isFromGeo=false;
	String fromGeoStr = request.getParameter("fromGeo");
	if(fromGeoStr!=null && (fromGeoStr.equalsIgnoreCase("true") || fromGeoStr.equalsIgnoreCase("yes")))
		isFromGeo=true;

	String iniName = null,user_name = null,isUserBased = null,dashboard_name = null,view_name = null,time_line = null,geoInfo = null,usercountval = null,dashboard_mapping = null,fromServiceHomePage = null,fromZonePage = null,selectedTest=null,selectedMeasure=null,selectedTestMea=null;
	int userTotalCount = 0;

	String enableBackButton = request.getParameter("enableBackButton");
	enableBackButton=(enableBackButton==null || enableBackButton.trim().length()==0)?"false":enableBackButton;

	String orderByColumnName = request.getParameter("orderByColumn");
	String isCsv_str = request.getParameter("isCSV");
	boolean isCSV=false;
	if(isCsv_str!=null && (isCsv_str.equalsIgnoreCase("true") || isCsv_str.equalsIgnoreCase("yes")))
	{
		isCSV=true;
	}
	String defaultOrderMeasure = ini.getValue("USER_DESKTOP_METRICS_DEFAULT_ORDER_MEASURE",userType);
	if(defaultOrderMeasure!=null && defaultOrderMeasure.trim().length()>0)
	{
		String deTest=defaultOrderMeasure.substring(0,defaultOrderMeasure.indexOf(":"));
		String deMea=defaultOrderMeasure.substring(defaultOrderMeasure.indexOf(":")+1);
		defaultOrderMeasure = Dbdata.getColumnForMeasure(deTest,deMea);
	}
	if((orderByColumnName==null || orderByColumnName.equals("null")) && defaultOrderMeasure!=null && defaultOrderMeasure.trim().length()>0)
		orderByColumnName=defaultOrderMeasure;

	String columnDispName = request.getParameter("columnDispName");
	String pageNoReq = request.getParameter("pageNo");
	if(pageNoReq==null || pageNoReq.trim().length()==0)
		pageNoReq = "0";

	int pageNo = Integer.parseInt(pageNoReq);

	userType = request.getParameter("userType");
	String searchFrom = request.getParameter("searchFrom");
	if(userType==null || userType.trim().length()==0)
		userType = request.getParameter("usertype");
	userType=(userType==null || userType.trim().length()==0)?"VDI":userType;
	boolean isEndUserOverview = false;
	boolean isFromUEDSort = false;
	String fromuedsort = request.getParameter("isfromuedsort");
	fromuedsort = (fromuedsort==null || fromuedsort.trim().length()==0)?"":fromuedsort;
	if(fromuedsort!=null && fromuedsort.trim().length()>0 && (fromuedsort.equalsIgnoreCase("true")||fromuedsort.equalsIgnoreCase("yes")))
		isFromUEDSort = true;
	String overviewSearchStr = request.getParameter("overviewsearchstr");
	overviewSearchStr = (overviewSearchStr==null || overviewSearchStr.trim().length()==0)?"":overviewSearchStr;
	String isFromUEDOverview = request.getParameter("isfromuedoverview");
	isFromUEDOverview = (isFromUEDOverview==null || isFromUEDOverview.trim().length()==0)?"":isFromUEDOverview;
	
	String aduserFilter = request.getParameter("aduserFilter");
	if(aduserFilter != null)
		aduserFilter=  com.egurkha.util.StringUtils.replace(aduserFilter,"|eq|","=");

	boolean defaultAdCase = false;
	if(aduserFilter != null && aduserFilter.equalsIgnoreCase("default")){
		aduserFilter ="All";
		defaultAdCase = true;
	}

	String showUserLocations = ini.getValue("GEO_LOCATION_SETTINGS",userType+":ShowUserLocations");
	String strSeparator = ini.getValue("GEO_LOCATION_SETTINGS",userType+":Separator");
	String strReplaceSep = ini.getValue("GEO_LOCATION_SETTINGS",userType+":ReplaceSeparatorTo");
	showUserLocations = (showUserLocations==null || showUserLocations.trim().length()==0)?"":showUserLocations;
	boolean isShowUserLocation = false;
	if(showUserLocations!=null && showUserLocations.trim().length()>0 && (showUserLocations.equalsIgnoreCase("true") || showUserLocations.equalsIgnoreCase("yes")))
		isShowUserLocation = true;

	String col_Type = request.getParameter("columnType");
	String strUDSortByAllValue=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","SortByAllMeasureValue");
	strUDSortByAllValue=(strUDSortByAllValue==null || strUDSortByAllValue.trim().length()==0)?"false":strUDSortByAllValue;
	boolean isUDSortByAllValue = (strUDSortByAllValue.equalsIgnoreCase("true") || strUDSortByAllValue.equalsIgnoreCase("yes"))?true:false;

	String strOfficeDefaultStateSort=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","OfficeDefaultStateSort");
	strOfficeDefaultStateSort=(strOfficeDefaultStateSort==null || strOfficeDefaultStateSort.trim().length()==0)?"false":strOfficeDefaultStateSort;
	boolean isOfficeDefaultStateSort = (strOfficeDefaultStateSort.equalsIgnoreCase("true") || strOfficeDefaultStateSort.equalsIgnoreCase("yes"))?true:false;

	String strODSSOrder=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","OfficeDefaultStateSortOrder");
	strODSSOrder=(strODSSOrder==null || strODSSOrder.trim().length()==0)?"desc":strODSSOrder;

	String strMValueOrder=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","SortByAllMeasureValueOrder");
	strMValueOrder=(strMValueOrder==null || strMValueOrder.trim().length()==0)?"asc":strMValueOrder;
	
	IniFile dashIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_dashboardConfig.ini",true);
	boolean isDetailsFromADOnly = false;
	String locStr = dashIni.getValue("USER_LOCATION_TEST_CONFIG",userType+":ShowLocationFromADOnly");
	if(locStr != null && locStr.trim().length() > 0 && (locStr.equalsIgnoreCase("true") || locStr.equalsIgnoreCase("yes"))){
		isDetailsFromADOnly = true;
	}

	ArrayList converstionTestMeasureUnit = getConvertionTestMeasureUnitList(dashIni);
	boolean isUnitConvertion = (converstionTestMeasureUnit != null && converstionTestMeasureUnit.size() > 0)?true:false;
	String defaultFilter = ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","defaultFilter");
	ArrayList subFilterList = null;
	String subFilter = ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","subFilter");
	if(subFilter != null && subFilter.trim().length() > 0)
		subFilterList = com.egurkha.util.StringUtils.egTokenizer(subFilter, ",", true,false,true);

	ArrayList excludedTestList = new ArrayList();
	String excluded_str = ini.getValue("EXCLUDED_CUT_OFF_FACTOR",userType);
	if(excluded_str != null && excluded_str.trim().length() > 0)
		excludedTestList = com.egurkha.util.StringUtils.egTokenizer(excluded_str, ",", true,false,true);

	String decimalFormatMeasure = ini.getValue("USER_DESKTOP_METRICS_DECIMAL_FORMAT_MEASURES",userType);
	ArrayList decimalFormatTestMeasureList = (ArrayList)getTokenList(decimalFormatMeasure,",");

	String convertToDaysMeasure = ini.getValue("USER_DESKTOP_METRICS_CONVERT_TO_DAYS_MEASURES",userType);
	ArrayList convertToDaysTestMeasureList =(ArrayList)getTokenList(convertToDaysMeasure,",");

	String convertToYesNo = ini.getValue("USER_DESKTOP_METRICS_CONVERT_TO_YES_OR_NO",userType);
	ArrayList convertToYesNoList =(ArrayList)getTokenList(convertToYesNo,",");

	String udm_hide_unit = ini.getValue("USER_DESKTOP_METRICS_HIDE_UNIT",userType);
	ArrayList udm_hide_unit_list = (ArrayList)getTokenList(udm_hide_unit,",");

	String default_Filter=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","defaultFilter");
	String sub_Filter=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","subFilter");
	ArrayList tmpSubFilList = (ArrayList)getTokenList(sub_Filter,",");

	boolean isRetrieveFDB=false;
	String isRetrieveUserExpDatafromDB = ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","RetrieveUserExpDatafromDB");
	if(isRetrieveUserExpDatafromDB!=null && isRetrieveUserExpDatafromDB.length()>0 && (isRetrieveUserExpDatafromDB.equalsIgnoreCase("true") || isRetrieveUserExpDatafromDB.equalsIgnoreCase("yes")))
		isRetrieveFDB=true;


	JSONObject isEnableFilterJson = new JSONObject();
	String tmp_metrics = ini.getValue("USER_DESKTOP_METRICS",userName+":"+userType);
	if(tmp_metrics==null || tmp_metrics.trim().length()==0)
	{
		String tmp_metricsD = ini.getValue("USER_DESKTOP_METRICS","DEFAULT_"+userType);
		String tmp_metricsT = ini.getValue("USER_DESKTOP_METRICS",userType);
		if(tmp_metricsD != null && tmp_metricsD.trim().length() > 0)
			tmp_metrics = (String)getMeasureForUI(tmp_metricsD,tmp_metricsT);
		else
			tmp_metrics = tmp_metricsT;
	}
	ArrayList filterList = (ArrayList)getFilterlist(tmp_metrics);
	
	String tmpOrderByColumnName=orderByColumnName;
	

	boolean isdefaultFilter=false;
	boolean istmpSubFilter=false;
	boolean istmpnextSubFilter=false;
	if(filterList!=null && filterList.size()>0)
	{
		if(default_Filter!=null && default_Filter.length()>0 && filterList.contains(default_Filter))
			isdefaultFilter=true;
	}
	
	isEnableFilterJson.put("isdefaultFilter",isdefaultFilter);
	if(tmpSubFilList!=null && tmpSubFilList.size()>0)
	{
		String tmp_Sub_Val=(String)tmpSubFilList.get(0);
		if(tmp_Sub_Val!=null && tmp_Sub_Val.length()>0 && filterList.contains(tmp_Sub_Val))
			istmpSubFilter = true;
		
		if(tmpSubFilList.size()>1)
		{
			String tmp_Sub_Val_2=(String)tmpSubFilList.get(1);
			if(tmp_Sub_Val_2!=null && tmp_Sub_Val_2.length()>0 && filterList.contains(tmp_Sub_Val_2))
				istmpnextSubFilter=true;
		}
	}
	isEnableFilterJson.put("istmpSubFilter",istmpSubFilter);
	isEnableFilterJson.put("istmpnextSubFilter",istmpnextSubFilter);

	//Hashtable finalEndUserDatas = (Hashtable)vmDashHelper.getEndUserDatas(userType);
	Hashtable finalEndUserDatas = (Hashtable)vmDashHelper.getMsO365UserDatas(userType);
	Hashtable infoResHash = new Hashtable();
	Hashtable dataResHash = new Hashtable();
	Hashtable fullInfoHash = new Hashtable();
	boolean orderByCol_flag=false;
	boolean isDataAvailable = false;

	List listData = new LinkedList();
	int measuresCount = 0;
	if(finalEndUserDatas!=null && finalEndUserDatas.size()>0)
	{
		//if(!showKeyUser)
		{
			infoResHash = (Hashtable)finalEndUserDatas.get("users");
			dataResHash = (Hashtable)finalEndUserDatas.get("usersDetails");
		}
	}

	if(orderByColumnName!=null && orderByColumnName.trim().length()>0 && !orderByColumnName.equalsIgnoreCase("null"))
	{
		tmp_priority="ALL";
		orderByCol_flag=true;
	}
	else if(isUDSortByAllValue || isAdtnlSearch || isEndUserOverview || isOfficeDefaultStateSort)
		tmp_priority="ALL";

	String keyUserUED = ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","HighUserProfileExpDashboard");
	keyUserUED = (keyUserUED==null || keyUserUED.trim().length()==0)?"":keyUserUED;
	boolean isKeyUserUED = false;
	if(keyUserUED!=null && keyUserUED.trim().length()>0 && (keyUserUED.equalsIgnoreCase("true") || keyUserUED.equalsIgnoreCase("yes")))
	{
		isKeyUserUED = true;
	}

	boolean isShowUniqueUserCountInUI = false;
	String showUniqueUserCountInUI=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","ShowUniqueUserCountInUI");
	showUniqueUserCountInUI=(showUniqueUserCountInUI==null || showUniqueUserCountInUI.trim().length()==0)?"false":showUniqueUserCountInUI;
	if(showUniqueUserCountInUI != null && showUniqueUserCountInUI.trim().length() > 0 && (showUniqueUserCountInUI.equalsIgnoreCase("true") || showUniqueUserCountInUI.equalsIgnoreCase("yes")))
		isShowUniqueUserCountInUI = true;

	boolean liveDataFromVirtualApps = false;
	String strliveDataFromVirtualApps=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","LiveDataFromVirtualApps");
	strliveDataFromVirtualApps=(strliveDataFromVirtualApps==null || strliveDataFromVirtualApps.trim().length()==0)?"false":strliveDataFromVirtualApps;
	if(strliveDataFromVirtualApps != null && strliveDataFromVirtualApps.trim().length() > 0 && (strliveDataFromVirtualApps.equalsIgnoreCase("true") || strliveDataFromVirtualApps.equalsIgnoreCase("yes")))
		liveDataFromVirtualApps = true;

	String groupByStr = ini.getValue("LOC_USER_DESKTOP_METRICS",userType+":GroupBy");
	ArrayList groupByList = new ArrayList();
	if(groupByStr!=null && groupByStr.trim().length()>0)
		groupByList = StringUtils.egTokenizer(groupByStr,",",false,true,true);		//param 3-->includeEmpty,4-->unique,5-->trim
	String filterFlag = request.getParameter("filterFlag");
	ArrayList filterInfo = null;
	Hashtable filterInfoHash = null;

	String compDispName = request.getParameter("compDispName");
	compDispName = (compDispName!= null && compDispName.trim().length()>0 && compDispName.equalsIgnoreCase("components"))?"Component(s)":compDispName;
	String showComFilterVal = request.getParameter("showComFilter");
	boolean showComFilter = (showComFilterVal!=null && showComFilterVal.trim().length()>0 && showComFilterVal.equals("true"))?true:false;
	String detail = request.getParameter("detail");
	if(detail != null && detail.equals("ComponentType"))
		detail = "componentType";
	String compCombo = request.getParameter("compCombo");
	//detail = (detail!=null && detail.trim().length()>0 && detail.equalsIgnoreCase("componentType"))?"Component":detail;
	String filterBy = "";
	String searchFilter = "";
	String nextSearch = "";
	String nextSubSearch = "";
	String filterlabel1 = "", filterlabel2 = "", filterlabel3 = "";
	String priorityFilter = request.getParameter("priorityFilter");
	String gatewayFilter = request.getParameter("gatewayFilter");
	priorityFilter = (priorityFilter==null || priorityFilter.trim().length()==0||priorityFilter.equalsIgnoreCase("NULL"))?"":priorityFilter;
	gatewayFilter = (gatewayFilter==null || gatewayFilter.trim().length()==0||gatewayFilter.equalsIgnoreCase("NULL"))?"":gatewayFilter;
	String searchFilDispTxt = request.getParameter("searchFilDispTxt");
	String nextSearchFilDispTxt = request.getParameter("nextSearchFilDispTxt");
	filterBy = request.getParameter("filterBy");
	String filterByDisplay=filterBy;
	searchFilter = request.getParameter("searchFilter");
	searchFilter = (searchFilter==null || searchFilter.trim().length()==0 || searchFilter.equalsIgnoreCase("NULL"))?"":searchFilter;
	if(searchFilter != null && searchFilter.trim().length() > 0)
		searchFilter = searchFilter.trim();
	nextSearch = request.getParameter("nextSearch");
	nextSearch = (nextSearch==null || nextSearch.trim().length()==0 || nextSearch.equalsIgnoreCase("NULL"))?"":nextSearch;
	if(nextSearch != null && nextSearch.trim().length() > 0)
		nextSearch = nextSearch.trim();
	nextSubSearch = request.getParameter("nextSubSearch");
	nextSubSearch = (nextSubSearch==null || nextSubSearch.trim().length()==0 || nextSubSearch.equalsIgnoreCase("NULL"))?"":nextSubSearch;
	if(nextSubSearch != null && nextSubSearch.trim().length() > 0)
		nextSubSearch = nextSubSearch.trim();
	Hashtable statesList = null;
	JSONObject fil_json = new JSONObject();
	JSONObject json  = new JSONObject();
	String isfromctx = request.getParameter("fromctx");
	boolean isFromctx = false;
	if(isfromctx != null && isfromctx.equalsIgnoreCase("true"))
		isFromctx =true;
	String host_comp_type="";
	
	String accountName = request.getParameter("accountName");
	String accountValue = request.getParameter("accountValue");
	
	if(accountValue!=null && !accountValue.equals("ALL"))
	{
		if(filterInfoHash == null)
			filterInfoHash = new Hashtable();

		filterInfoHash.put("accountName",accountName);
		filterInfoHash.put("accountValue",accountValue);

		if(ls_server!=null && ls_server.size()>1)
		{
			ArrayList tmp_ls_server=new ArrayList();
			for(int kk=0;kk<ls_server.size();kk++)
			{
				String ser_name=(String)ls_server.get(kk);
				ArrayList ser_sp_list = StringUtils.egTokenizer(ser_name,":",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
				String only_nick_name=null;
				if(ser_sp_list!=null && ser_sp_list.size()==3)
				{
					only_nick_name=(String)ser_sp_list.get(1);
				}

				if(only_nick_name!=null && only_nick_name.startsWith(accountName))
					tmp_ls_server.add(ser_name);
			}
			if(tmp_ls_server!=null)
			{
				ls_server_count =  new ArrayList();
				ls_server_count.addAll(tmp_ls_server);
			}
		}
	}
	
	if(infoResHash!=null && infoResHash.size()>0)
	{
		finalDesktopVmsHash = (Hashtable)vmDashHelper.getAllUsersForMSOffice365(searchString,tmp_priority,userType,vdiType,pageNo,infoResHash,null,aduserFilter,filterInfoHash);
	}
	/*else
	{
		finalDesktopVmsHash = (Hashtable)vmDashHelper.getUsersForMSOffice365(searchString,tmp_priority,userType,vdiType,pageNo,aduserFilter,filterInfoHash);
	}*/
	String adFilter = "";
	ArrayList adFilterKeys = new ArrayList();
	Hashtable userRelatedAd = new Hashtable();
	boolean isGetLiveData=false;
	Integer uniqueUserCount=new Integer(0);
	Hashtable keyStateCountHash = new Hashtable();

	int high_int=0;
	int inter_int=0;
	int low_int=0;
	int unknown_int=0;
	int good_int=0;
	if(finalDesktopVmsHash!=null && finalDesktopVmsHash.size()>0)
	{
		vdiDesktopsList = (EgList)finalDesktopVmsHash.get("EgList");
		vdiDesktopsListTmp = (EgList)vdiDesktopsList.clone();
		vdiDesktopsListTotalCount = (Integer)finalDesktopVmsHash.get("EgListCount");

		uniqueUserCount = (Integer)finalDesktopVmsHash.get("UniqueUserCount");
		
		if(showKeyUser && isKeyUserUED)
		{
			vdiDesktopsList = (EgList)finalDesktopVmsHash.get("KeyEgList");
			vdiDesktopsListTotalCount = (Integer)finalDesktopVmsHash.get("KeyEgListCount");
			keyStateCountHash = (Hashtable)finalDesktopVmsHash.get("KeyEgStateCount");
			if(keyStateCountHash!=null)
			{
				high_int = ((Integer)keyStateCountHash.get("HIGH")).intValue();
				inter_int = ((Integer)keyStateCountHash.get("INTER")).intValue();
				low_int = ((Integer)keyStateCountHash.get("LOW")).intValue();
				unknown_int = ((Integer)keyStateCountHash.get("UNKNOWN")).intValue();
				good_int = ((Integer)keyStateCountHash.get("GOOD")).intValue();
			}
		}

		statesList = (Hashtable)finalDesktopVmsHash.get("statesList");
		infosCompHash = (Hashtable)finalDesktopVmsHash.get("INFOS_COMP");
		Hashtable tmp_CTHash = (Hashtable)finalDesktopVmsHash.get("TYPE_COMP_INFO");
		//typeCompInfoHash = tmp_CTHash;

		
		if(isRetrieveFDB)
		{
			//userTotalCount=vdiDesktopsListTotalCount;
			infolist1 = (ArrayList)finalDesktopVmsHash.get("TMPINFOS");
			if((tmp_priority!=null && (!tmp_priority.equals("ALL"))) || (priorityFilter!=null && !priorityFilter.equalsIgnoreCase("All")) || (gatewayFilter!=null && !gatewayFilter.equalsIgnoreCase("All")))
				userTotalCount=vdiDesktopsListTotalCount;
			else if(infolist1!=null && infolist1.size()>0)
				userTotalCount=infolist1.size();
			else
				userTotalCount=vdiDesktopsListTotalCount;
		}
		else
		{
			infolist = (ArrayList)finalDesktopVmsHash.get("INFOS");
			if((tmp_priority!=null && (!tmp_priority.equals("ALL"))) || (priorityFilter!=null && !priorityFilter.equalsIgnoreCase("All")) || (gatewayFilter!=null && !gatewayFilter.equalsIgnoreCase("All")))
				userTotalCount=vdiDesktopsListTotalCount;
			else if(infolist!=null && infolist.size()>0)
				userTotalCount=infolist.size();
		}
		

		if(isShowUniqueUserCountInUI && uniqueUserCount!=null && uniqueUserCount>0  && (!isFromctx))
			userTotalCount = uniqueUserCount;

		infolist = (ArrayList)finalDesktopVmsHash.get("INFOS");
		dbinfolist = (ArrayList)finalDesktopVmsHash.get("DBINFOS");

		resTypeList = (List)finalDesktopVmsHash.get("CTYPE");
		//componentTypeList = resTypeList;
		/*resCnameList = (List)finalDesktopVmsHash.get("CNAME");
		resCompsList = (List)finalDesktopVmsHash.get("COMPS");
		resNickList = (List)finalDesktopVmsHash.get("NICKS");
		resPortList = (List)finalDesktopVmsHash.get("PORTS");*/

		fullInfoHash = (Hashtable)finalDesktopVmsHash.get("FULLINFOS");
		maxUser = (String)finalDesktopVmsHash.get("MAX_USER");
		//user_count_hash = (Hashtable)finalDesktopVmsHash.get("MAX_USER_HASH");

		if(finalDesktopVmsHash.containsKey("adFilter"))
			adFilter = (String)finalDesktopVmsHash.get("adFilter");
		if(finalDesktopVmsHash.containsKey("adFilterKeys"))
			adFilterKeys = (ArrayList)finalDesktopVmsHash.get("adFilterKeys");
		if(finalDesktopVmsHash.containsKey("userRelatedAd"))
			userRelatedAd = (Hashtable)finalDesktopVmsHash.get("userRelatedAd");
		if(finalDesktopVmsHash.containsKey("groupByUserKeys"))
		groupByUserKeys = (ArrayList)finalDesktopVmsHash.get("groupByUserKeys");
		if(groupByUserKeys==null||groupByUserKeys.size()==0)
			isEndUserOverview = false;
	}
	
	String inner_header="";
	String header_display="";
	String header_display_icon="";
	String is_Header_DispName=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","ShowUserCountInUI");
	String skipDesktopsForUserType = ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","SkipDesktopsFor"+userType);
	boolean check_Header_DispName = false;
	if(is_Header_DispName!=null && (is_Header_DispName.equalsIgnoreCase("true") || is_Header_DispName.equalsIgnoreCase("yes")))
	{
		check_Header_DispName=true;
		if(!isEndUserOverview && vdiDesktopsListTotalCount>0)
		{
			String countHeader = (isFromGeo && (selectedMeasure!=null && selectedMeasure.trim().length()>0 && selectedMeasure.equalsIgnoreCase("UniqueSessionCount")))?"Sessions":"Unique Users";

			String text_UserType=userType;
			header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+text_UserType+" ("+countHeader+": "+vdiDesktopsListTotalCount+")");
		}
		else if(isEndUserOverview)
		{
			header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By Location for")+" "+userType;
		}
	}
	else
	{
		if(!isEndUserOverview)
		{
			header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
		}
		else if(isEndUserOverview)
		{
			header_display=mappingInfo.getTextDescription("monitor.endUserDashboard.Citrix User Experience By Location for")+" "+userType;
			//jsonRoot.put("header_display",header_display);
		}
	}

	if(vdiType != null && vdiType.indexOf(":") != -1)
		host_comp_type = vdiType.substring(0,vdiType.indexOf(":"));

	Hashtable TotalMeasureInfo = new Hashtable();
	//session.removeAttribute(userType+"InfoSession");
	//session.removeAttribute(userType+"InfoFilterSession");
	JSONArray fil = new JSONArray();
	if(searchFrom==null || searchFrom.trim().length()==0)
	{
		if((!isGetLiveData) && dataResHash!=null && dataResHash.size()>0 && ((vdiDesktopsList!=null && vdiDesktopsList.size()>0 && vdiDesktopsListTotalCount>0)||(groupByUserKeys!=null && groupByUserKeys.size()>0)))
		{
			TotalMeasureInfo=(Hashtable)dataResHash.clone();
		}
		else if((vdiDesktopsList!=null && vdiDesktopsList.size()>0 && vdiDesktopsListTotalCount>0)||(groupByUserKeys!=null && groupByUserKeys.size()>0))
		{
			String temp_user_type = userType;
			if(isFromctx)
			{
				if(finalDesktopVmsHash == null)
					finalDesktopVmsHash = new Hashtable();

				temp_user_type = temp_user_type+":"+host_comp_type;
				finalDesktopVmsHash.put("isFromHost","true");
			}
			else if(isFromGeo)
				finalDesktopVmsHash.put("isFromGeo","true");
			//TotalMeasureInfo = vmDashHelper.getAllDesktopVmsMeasureDataForGenericEUD(finalDesktopVmsHash,userType);
			//TotalMeasureInfo = vmDashHelper.getAllDesktopVmsMeasureDataForGenericEUD(finalDesktopVmsHash,userType,userName);
			TotalMeasureInfo = vmDashHelper.getOfficeUsersMeasureData(finalDesktopVmsHash,temp_user_type,userName);
		}
		
		if(TotalMeasureInfo != null && TotalMeasureInfo.containsKey("InfoSession") && TotalMeasureInfo.containsKey("InfoFilterSession"))
		{
			Hashtable geoMapInfo = (Hashtable)TotalMeasureInfo.get("InfoSession");
			Hashtable InfoFilterSession = (Hashtable)TotalMeasureInfo.get("InfoFilterSession");
			Hashtable geoLocMapInfos = (Hashtable)TotalMeasureInfo.get("geoLocMapInfos");

			TotalMeasureInfo.remove("InfoSession");
			TotalMeasureInfo.remove("InfoFilterSession");
			TotalMeasureInfo.remove("geoLocMapInfos");

			if(geoMapInfo != null && geoMapInfo.size() > 0)
			{
				Iterator it = geoMapInfo.entrySet().iterator();
				while(it.hasNext()){
					Entry en = (Entry)it.next();
					Set set = (HashSet)en.getValue();
					ArrayList list = new ArrayList(set);
					if(list != null && list.size() > 0)
						fil.add((String)en.getKey());
				}
				session.setAttribute(userType+"InfoSession",geoMapInfo);
				session.setAttribute(userType+"tmpInfoSession",geoMapInfo);
				session.setAttribute(userType+"geoLocMapInfos",geoLocMapInfos);
				//session.setAttribute("statesList",statesList);
			}
			if(InfoFilterSession != null && InfoFilterSession.size() > 0)
				session.setAttribute(userType+"InfoFilterSession",InfoFilterSession);
		}
		if(statesList!=null && statesList.size()>0)
			session.setAttribute("statesList",statesList);
		if(TotalMeasureInfo!=null && TotalMeasureInfo.containsKey("finalGroupByUserTab"))
			finalGroupByUserTab = (Hashtable) TotalMeasureInfo.get("finalGroupByUserTab");

		boolean isSortingFlage=false;
		if(tmpOrderByColumnName!=null && tmpOrderByColumnName.trim().length()>0 && !tmpOrderByColumnName.equalsIgnoreCase("null") && !tmpOrderByColumnName.equalsIgnoreCase("default"))
		{
			isSortingFlage=true;
			if(col_Type!=null && col_Type.trim().length()>0 && (!col_Type.equalsIgnoreCase("NULL")))
			{
				if(isFromUEDSort)
					groupByUserKeys = (ArrayList)vmDashHelper.getSortedListForUEDOverview(groupByUserKeys,TotalMeasureInfo,"enduseroverview",tmpOrderByColumnName,orderBy,col_Type);
				else
				{
					if(tmpOrderByColumnName.equalsIgnoreCase("FIRST_COLUMN"))
					{
						vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,tmpOrderByColumnName,null,orderBy);
					}
					else
					{
						vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,TotalMeasureInfo,"virtual",tmpOrderByColumnName,orderBy,col_Type);
					}
				}
			}
			else
			{
				if(tmpOrderByColumnName.equalsIgnoreCase("HOST"))
				{
					columnDispName="Host";
					vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,tmpOrderByColumnName,null,orderBy);
				}
				else if(tmpOrderByColumnName.equalsIgnoreCase("FIRST_COLUMN"))
				{
					vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,tmpOrderByColumnName,null,orderBy);
				}
				else
				{
					if(tmpOrderByColumnName.equals("TotLicAssgnd"))
					{
						if(TotalMeasureInfo!=null)
							TotalMeasureInfo.put("HypenZero","TRUE");

						vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,TotalMeasureInfo,"virtual",tmpOrderByColumnName,orderBy);
					}
					else
					{
						vdiDesktopsList=vmDashHelper.getSortedList(vdiDesktopsList,TotalMeasureInfo,"virtual",tmpOrderByColumnName,orderBy);
					}
				}
			}
			if(priority!=null && !priority.equalsIgnoreCase("ALL"))
				vdiDesktopsList = vmDashHelper.getSubList(vdiDesktopsList,priority,pageNo);
		}
		else if(isUDSortByAllValue)
		{
			isSortingFlage=true;
			vdiDesktopsList=vmDashHelper.getAllMeasureValueBasedSortedList(vdiDesktopsList,TotalMeasureInfo,userType,strMValueOrder);
			if(priority!=null && !priority.equalsIgnoreCase("ALL"))
				vdiDesktopsList = vmDashHelper.getSubList(vdiDesktopsList,priority,pageNo);
		}
		
		if(isOfficeDefaultStateSort || isSortingFlage)
		{
			String tempUserType = userType;
			if(isFromctx)
				tempUserType = userType+":"+host_comp_type;
			//vdiDesktopsList=vmDashHelper.getMeasureStateBasedSortedList(vdiDesktopsList,TotalMeasureInfo,tempUserType,strODSSOrder,isFromctx,ls_server);

			Hashtable New_Resh_hash=new Hashtable();
			if(isSortingFlage)
				New_Resh_hash=(Hashtable)vmDashHelper.getMeasureStateBasedSortedList(vdiDesktopsListTmp,TotalMeasureInfo,tempUserType,strODSSOrder,isFromctx,ls_server);
			else
				New_Resh_hash=(Hashtable)vmDashHelper.getMeasureStateBasedSortedList(vdiDesktopsList,TotalMeasureInfo,tempUserType,strODSSOrder,isFromctx,ls_server);

			if(New_Resh_hash!=null && New_Resh_hash.size()>0)
			{
				if(!isSortingFlage)
					vdiDesktopsList=(EgList)New_Resh_hash.get("EGLIST");

				if(isO365UserTestCount)
				{
					Hashtable out_hash=(Hashtable)vmDashHelper.getOfficeUsersCount(tempUserType,ls_server_count);
					if(out_hash!=null && out_hash.size()>0)
					{
						ArrayList DBMeasureList=(ArrayList)out_hash.get("DBMeasureList");
						
						String dbMeaName1=(String)DBMeasureList.get(0);
						String dbMeaName2=(String)DBMeasureList.get(1);

						dbMeaName1 = (String)out_hash.get(dbMeaName1);
						dbMeaName2 = (String)out_hash.get(dbMeaName2);
						if(dbMeaName1 != null && dbMeaName1.trim().length() > 0)
							license_count=Integer.parseInt(dbMeaName1);
						if(dbMeaName2 != null && dbMeaName2.trim().length() > 0)
							unlicense_count=Integer.parseInt(dbMeaName2);
					}
				}
				else
				{
					license_count=((Integer)New_Resh_hash.get("LICENSE_COUNT")).intValue();
					unlicense_count=((Integer)New_Resh_hash.get("UNLICENSE_COUNT")).intValue();
				}
			}

			if(!isSortingFlage && priority!=null && !priority.equalsIgnoreCase("ALL"))
				vdiDesktopsList = vmDashHelper.getSubList(vdiDesktopsList,priority,pageNo);
		}
	}
	if(groupByUserKeys!=null && groupByUserKeys.size()>0)
		groupByUserCount = groupByUserKeys.size();
	if(isAdtnlSearch)
	{
		boolean isOnlyStartsWithCheck = false;
		String startsWithCheck=ini.getValue("Additional_Search","EnableStartsWithSearch");
		if(startsWithCheck != null && startsWithCheck.trim().length()>0 && startsWithCheck.equalsIgnoreCase("true"))
			isOnlyStartsWithCheck = true;
		vdiDesktopsList = (EgList)vmDashHelper.getAdditionalSearchVdiDesktopsList(vdiDesktopsList,TotalMeasureInfo,adtnlSearchStr,adtnlSearchColumns,isOnlyStartsWithCheck);
		if(vdiDesktopsList!=null && vdiDesktopsList.size()>0)
			userTotalCount = vdiDesktopsList.size();
	}
	if(isDetailsFromADOnly)
	{
		if(searchFilter!=null && searchFilter.trim().length()>0 && !searchFilter.equalsIgnoreCase("All") && nextSearch!=null && nextSearch.trim().length()>0 && !nextSearch.equalsIgnoreCase("All"))
		{
			vdiDesktopsList = (EgList)vmDashHelper.getFilteredVdiDesktopsListWithLocation(vdiDesktopsList,TotalMeasureInfo,nextSearch,searchFilter);
		}
	}
	String searchByText = (String)getSearchByText(userType,mappingInfo);

	if(TotalMeasureInfo!=null && TotalMeasureInfo.size()>0)
	{
		buf.append("<link rel='stylesheet' type='text/css' href='/final/styles/eGLightThemeIcons.css' />");
		buf.append("<link rel='stylesheet' type='text/css' href='eg_styles/printPageStyles.css' />");
		buf.append("<link rel='stylesheet' type='text/css' href='/final/monitor/eg_scripts/microSoftUserDashboard/css/microSoftUserDashboardLight.css' />");
		
		IniUI img1=IniUI.getInstance();
		String logo=img1.getMonitorHomeLogo();
		if(img1.isHKTThemeEnabled())
		{
			logo = img1.getHKTReporterLogo();
		}

		if((!isEndUserOverview) && (!isFromUEDSort))
		{
			//String mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Dashboard for "+userType);
			String mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
			if(showKeyUser && isKeyUserUED)
			{
				mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for High Profile "+userType+" Users");
			}
			//String countHeader = (userType.equals("XenApp7") || userType.equals("XenApp"))?"Unique Users":"Unique Users/Desktops";
			if(check_Header_DispName && userTotalCount>0)
			{
				if(userType!=null && userType.equalsIgnoreCase("MSO365DD"))
				{
					String countHeader = "Total Users";
					//mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.MS Office Users Overview")+" ("+countHeader+": "+userTotalCount+")";
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.Microsoft 365 User Dashboard")+" ("+countHeader+": "+userTotalCount+" - "+mappingInfo.getTextDescription("monitor.endUserDashboard.Licensed Users")+": "+license_count+" - "+mappingInfo.getTextDescription("monitor.endUserDashboard.Unlicensed Internal Users")+": "+unlicense_count+")";
				}
				else
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" (Total users: "+userTotalCount+")");
				}
			}
			else if(check_Header_DispName && vdiDesktopsListTotalCount>0)
			{
				if(userType!=null && userType.equalsIgnoreCase("MSO365DD"))
				{
					String countHeader = "Total Users";
					//mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.MS Office Users Overview")+" ("+countHeader+": "+userTotalCount+")";
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.Microsoft 365 User Dashboard")+" ("+countHeader+": "+userTotalCount+" - "+mappingInfo.getTextDescription("monitor.endUserDashboard.Licensed Users")+": "+license_count+" - "+mappingInfo.getTextDescription("monitor.endUserDashboard.Unlicensed Internal Users")+": "+unlicense_count+")";
				}
				else
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType+" (Total users: "+vdiDesktopsListTotalCount+")");
				}
			}
			else
			{
				if(showKeyUser && isKeyUserUED)
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for High Profile "+userType+" Users");
				}
				else if(userType!=null && userType.equalsIgnoreCase("MSO365DD"))
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.Microsoft 365 User Dashboard");
				}
				else
				{
					mainTitle=mappingInfo.getTextDescription("monitor.endUserDashboard.User Experience Overview for "+userType);
				}
			}
			mainTitle=com.egurkha.util.StringUtils.replace(mainTitle,"&#46", ".");
			listData.add(mainTitle);

			listData.add("");
			buf.append("<div style='padding:10px'>");
			buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" style=\"table-layout:fixed;width:100%;\">");
			buf.append("<tr><td width=\"100%\" align=\"center\" height=\"100%\" valign=\"top\">");
			if(logo!=null && logo.trim().length()>0)
			{
				buf.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\" align=\"center\">");
				buf.append("<tr><td style=\"padding:5px 10px 10px 10px\">");
				buf.append("<img src="+logo+" border=\"0\" /></td></tr></table>");
			}
			buf.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\"  style=\"border-bottom:1px solid #999;\">");
			buf.append("<tr><td style=\"padding:2px\"><div style=\"float:left\" ><header>"+mainTitle+"</header></div></td></tr></table>");
			buf.append("</td></tr></table>");
			
			
			if(isMSO365DD){
				buf.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\"  style=\"margin:5px 0px 10px 0px;border-bottom:1px solid #999; table-layout:fixed;width:100%;\"><tr>");
			}
			if(searchString!=null && !searchString.equalsIgnoreCase("NULL") && searchString.trim().length()>0)
			{
				String key = mappingInfo.getTextDescription("monitor.endUserDashboard.Search By ");
				if(isMSO365DD){
					buf.append("<td><div style='padding:20px' >"+key+" ("+searchByText+") : "+searchString+"</div></td>");
				}
				listData.add(key+" ("+searchByText+") "+"="+searchString);
			}
			if(accountName!=null && accountName.trim().length()>0 && !accountName.equalsIgnoreCase("NULL"))
			{
				String key = mappingInfo.getTextDescription("monitor.endUserDashboard.Tenant Name");
				if(isMSO365DD){
					buf.append("<td><div style='padding:20px' >"+key+" : "+accountName+"</div></td>");
				}
				listData.add(key+" "+"="+accountName);
			}
			//jp
			String currOrderByColumnName = request.getParameter("currOrderByColumn");
			String currOrderByName = request.getParameter("currOrderBy");
			if(isMSO365DD){
				currOrderByName = request.getParameter("orderBy");
				currOrderByColumnName = request.getParameter("columnDispName");
				 
			}
			if(currOrderByColumnName!=null && !currOrderByColumnName.equalsIgnoreCase("NULL") && currOrderByColumnName.trim().length()>0 && !currOrderByColumnName.equalsIgnoreCase("default"))
			{
				if(columnDispName!=null && columnDispName.trim().length()>0)
				{
					String orderByColText = mappingInfo.getTextDescription("monitor.endUserDashboard.Sort By");
					if(isMSO365DD){
						buf.append("<td><div style='padding:20px'>"+orderByColText+" : "+columnDispName+"</div></td>");
					}
					listData.add(orderByColText+"="+columnDispName);

					if(currOrderByName!=null && !currOrderByName.equalsIgnoreCase("NULL") && currOrderByName.trim().length()>0)
					{
						String orderByText = mappingInfo.getTextDescription("monitor.endUserDashboard.Order By");
						if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("desc"))
						{
							currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Descending");
						}
						else if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("asc"))
						{
							currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Ascending");
						}
						if(isMSO365DD){
								buf.append("<td><div style='padding:20px' >"+orderByText+" : "+currOrderByName+"</div></td>");
						}
						listData.add(orderByText+"="+currOrderByName);
					}
					if(!isMSO365DD)
						buf.append("</tr>");
				}
				else
				{
					String sortByDispCol = ini.getValue("USER_DESKTOP_METRICS",userType);
					ArrayList sortByDispColList =  new ArrayList();
					if(sortByDispCol!=null && sortByDispCol.trim().length()>0)
					{
						sortByDispColList = com.egurkha.util.StringUtils.egTokenizer(sortByDispCol,",",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
					}
					if(sortByDispColList!=null && sortByDispColList.size()>0)
					{
						String sortByColDispName = "";
						for(int s = 0;s<sortByDispColList.size();s++)
						{
							String colName = (String)sortByDispColList.get(s);
							String tmpTest = colName.substring(0,colName.indexOf(":"));
							String tmpMeasure = "";
							tmpMeasure = colName.substring(colName.indexOf(":")+1);
							if(tmpMeasure!=null && tmpMeasure.trim().length()>0 && tmpMeasure.indexOf(":")>-1)
								tmpMeasure=tmpMeasure.substring(0,tmpMeasure.indexOf(":"));
							String tmpOrderByColName = Dbdata.getColumnForMeasure(tmpTest,tmpMeasure);
							if(tmpOrderByColName!=null && tmpOrderByColName.trim().length()>0 && tmpOrderByColName.equals(currOrderByColumnName))
								sortByColDispName = colName.substring(colName.lastIndexOf(":")+1);
						}
						if(sortByColDispName!=null && !sortByColDispName.equalsIgnoreCase("NULL") && sortByColDispName.trim().length()>0)
						{
							String orderByColText = mappingInfo.getTextDescription("monitor.endUserDashboard.Sort By");
							buf.append("<tr><td><span style=\"float:left\" class=\"formLabel\">"+orderByColText+"</span> ");
							buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
							buf.append("<span style=\"float:left;\" class=\"formValue\">"+sortByColDispName+"</span></td>");

							listData.add(orderByColText+"="+sortByColDispName);

							if(currOrderByName!=null && !currOrderByName.equalsIgnoreCase("NULL") && currOrderByName.trim().length()>0)
							{
								String orderByText = mappingInfo.getTextDescription("monitor.endUserDashboard.Order By");
								if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("desc"))
								{
									currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Descending");
								}
								else if(currOrderByName!=null && currOrderByName.trim().length()>0 && currOrderByName.equalsIgnoreCase("asc"))
								{
									currOrderByName = mappingInfo.getTextDescription("monitor.endUserDashboard.Ascending");
								}
								buf.append("<td><span style=\"float:left\" class=\"formLabel\">"+orderByText+"</span> ");
								buf.append("<span style=\"float:left;width:10px\" align=\"center\" >:</span> ");
								buf.append("<span style=\"float:left;\" class=\"formValue\">"+currOrderByName+"</span></td>");
								listData.add(orderByText+"="+currOrderByName);
							}
							buf.append("</tr>");
						}
					}
				}
			}
			
			boolean checkOnlyVmCase = false;
			
			if(isMSO365DD)
				buf.append("</tr>");
			listData.add("");
			listData.add("");
			Vector headerVect = new Vector();
			buf.append("</table>");
			buf.append("<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"  height=\"auto\">");
			buf.append("<tr>");
			buf.append("<td width=\"100%\" valign=\"top\" height=\"100%\">");
			buf.append("<div>");
			buf.append("<table class=\"printTable\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"  valign=\"top\" >");
			buf.append("<thead>");
			buf.append("<tr >");

			if(userType!=null && userType.equalsIgnoreCase("MSO365DD"))
				buf.append("<th class=\"printTableHeader\" align=\"center\"  wrap >"+mappingInfo.getTextDescription("monitor.VirtualDashboard.User Principal Name")+ "</th>");

			headerVect.add("");
			if(userType!=null && userType.equalsIgnoreCase("MSO365DD"))
				headerVect.add(mappingInfo.getTextDescription("monitor.VirtualDashboard.User Principal Name"));
			//String widthOfTheHead="";
			String strVdiHostCombo=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","showVdiHostCombo");
			strVdiHostCombo=(strVdiHostCombo==null || strVdiHostCombo.trim().length()==0)?"false":strVdiHostCombo;
			String strVdiDefaultHost=ini.getValue("OFFICE_USERS_DASHBOARD_SETTINGS","Default_VdiType");
			strVdiDefaultHost=(strVdiDefaultHost==null || strVdiDefaultHost.trim().length()==0)?"":strVdiDefaultHost;
			boolean showVdiHostCombo = "true".equalsIgnoreCase(strVdiHostCombo)?true:false;
			//boolean isSkipVal = false;
			//ArrayList skippedColumns = new ArrayList();
			if(showVdiHostCombo && vdiType!=null && vdiType.trim().length()>0)
			{
				strVdiDefaultHost = vdiType;
			}

			//String measures = ini.getValue("USER_DESKTOP_METRICS",userType);
			String measures=null;
			String measuresD=null;
			String measuresToSkip=null;
			String measuresT=null;
			if(userName!=null && userName.trim().length()>0)
				measures = ini.getValue("USER_DESKTOP_METRICS",userName+":"+userType);
		
			if(measures==null || measures.trim().length()==0){
				measuresD = ini.getValue("USER_DESKTOP_METRICS","DEFAULT_"+userType);
				measuresT = ini.getValue("USER_DESKTOP_METRICS",userType);
				if(measuresD != null && measuresD.trim().length() > 0)
					measures = (String)getMeasureForUI(measuresD,measuresT);
				else
					measures = measuresT;
			}

			if(detail!=null && filterBy!=null && (detail.equalsIgnoreCase("componentType") || detail.equalsIgnoreCase("Component")) && (!filterBy.equalsIgnoreCase("All")))
			{
				measuresToSkip = ini.getValue("USER_DESKTOP_METRICS","SKIP_METRICS:"+userType+":"+filterBy);
				if(measuresToSkip!=null && measuresToSkip.trim().length()>0)
					measures =  (String)removeSkipMetrics(measures,measuresToSkip);
			}
			else if(resTypeList!=null && resTypeList.size()==1)
			{
				measuresToSkip = ini.getValue("USER_DESKTOP_METRICS","SKIP_METRICS:"+userType+":"+(String)resTypeList.get(0));
				if(measuresToSkip!=null && measuresToSkip.trim().length()>0)
					measures =  (String)removeSkipMetrics(measures,measuresToSkip);
			}

			String extra_measures="";
			
			// hide Measures in UI whose Component Type is Disabled
			measures = (String) HideDisabledTest(measures, userType, user, specsInfo,ini,isDetailsFromADOnly,isShowUserLocation);

			String[] measureArray = measures.split(",");
			ArrayList displayColsList = new ArrayList();
			ArrayList validColsList = new ArrayList();
			Hashtable sameLabelHash = new Hashtable();
			measuresCount = measureArray.length;
			String subColumnHeader = "<th style='display:flex;padding:0px;margin:0px' colspan='3' ><div style=' flex:1;width:450px;display:flex; flex-direction:column'><div style='border-bottom:1px solid #cdcdcd'>MAIL BOX LIMITS</div><div style='display:flex;'> ";
			int subColumnHeaderCount = 0;
			ArrayList sb_list=new ArrayList();
			ArrayList sb_final_list=new ArrayList();
			Hashtable sb_final_hash=new Hashtable();
			for(int x=0;x<measureArray.length;x++)
			{
				String tempValue = measureArray[x];
				String tempTest = "";
				String tempMeasure = "";
				String tempDispName = "";
				String locKeyName = "";
				String colName = "";
				ArrayList locColumnsList = null;
				StringTokenizer valTokens = new StringTokenizer(tempValue,":");
				int count = valTokens.countTokens();
				String group_mea_name = ini.getValue("USER_DESKTOP_METRICS_GROUP_COLUMNS",userType+"~!~"+tempValue);
				boolean isDDDColumn = false;
				boolean isLocColumn = false;
				boolean isTestColumn = false;
				boolean isAddCol=false;
				String meas ="";
				if (valTokens.hasMoreTokens())
				{
					if(count==3)
					{
						tempTest = valTokens.nextToken();
						tempMeasure = valTokens.nextToken();
						tempDispName = valTokens.nextToken();
						isTestColumn=true;
					}
					else if(count==2)
					{
						if(isShowUserLocation)
						{
							tempTest = valTokens.nextToken();
							tempMeasure = valTokens.nextToken();
							//tempDispName = mappingInfo.getMeasureDescription(tempTest,tempMeasure);
							isLocColumn = true;
							meas = "NONE";

							ArrayList tmpMeasureList = new ArrayList();
							tmpMeasureList = StringUtils.egTokenizer(tempMeasure,"~$~",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
							if(tmpMeasureList!=null && tmpMeasureList.size()>0)
							{
								int meaListSize=tmpMeasureList.size();
								if(meaListSize==1)
								{
									tempDispName = tempMeasure;
								}
								else if(meaListSize>1)
								{
									tempDispName = (String)tmpMeasureList.get(1);
									//if(x == 0 && searchFilter != null && searchFilter.trim().length() > 0 && !searchFilter.equalsIgnoreCase("All") && !searchFilter.equalsIgnoreCase("null")){
									/*if(searchFilter != null && searchFilter.trim().length() > 0 && !searchFilter.equalsIgnoreCase("All") && !searchFilter.equalsIgnoreCase("null")){
										continue;
									}
									//else if(x == 1 && nextSearch != null && nextSearch.trim().length() > 0 && !nextSearch.equalsIgnoreCase("All") && !nextSearch.equalsIgnoreCase("null")){
									else if(nextSearch != null && nextSearch.trim().length() > 0 && !nextSearch.equalsIgnoreCase("All") && !nextSearch.equalsIgnoreCase("null")){
										continue;
									}
									//else if(x == 2 && nextSubSearch != null && nextSubSearch.trim().length() > 0 && !nextSubSearch.equalsIgnoreCase("All") && !nextSubSearch.equalsIgnoreCase("null")){
									else if(nextSubSearch != null && nextSubSearch.trim().length() > 0 && !nextSubSearch.equalsIgnoreCase("All") && !nextSubSearch.equalsIgnoreCase("null")){
										continue;
									}*/
								}
							}
						}
					}
					else if(count==5)
					{
						tempTest = valTokens.nextToken();
						tempMeasure = valTokens.nextToken();
						colName = valTokens.nextToken();
						meas = valTokens.nextToken();
						tempDispName = valTokens.nextToken();
						isDDDColumn = true;
						//mappingInfo.getMeasureDescription(tempTest+"_DDD",tempMeasure);
					}
				}
				if(isTestColumn || isDDDColumn || isLocColumn)
				{
					boolean isTestRelevantForServer = true;
					if(showVdiHostCombo && strVdiDefaultHost!=null && strVdiDefaultHost.trim().length()>0)
					{
						isTestRelevantForServer = specsInfo.isTestRelevantForServer(strVdiDefaultHost,tempTest);
					}
					if(!isTestRelevantForServer)
					{
						continue;
					}
					if(displayColsList!=null && displayColsList.contains(tempDispName))
					{
						if(sameLabelHash!=null && sameLabelHash.containsKey(tempDispName))
						{
							ArrayList tmp_list=(ArrayList)sameLabelHash.get(tempDispName);
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						else
						{
							ArrayList tmp_list=new ArrayList();
							tmp_list.add(tempValue);
							sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
						}
						continue;
					}

					String testnameWithMeasure = tempTest+":"+tempMeasure.trim();
					String unitForMeasure="";
					if(isDDDColumn && meas!=null && meas.trim().length()>0 &&(!meas.equalsIgnoreCase("NONE")&&!meas.equalsIgnoreCase("DATE")))
					{
						unitForMeasure = "("+meas+")";
					}
					else if(!isDDDColumn && !isLocColumn)
					{
						//unitForMeasure="&nbsp;("+tablesInfo.getUnitForMeasure(tempTest,tempMeasure.trim())+")";
						String unitVal=tablesInfo.getUnitForMeasure(tempTest,tempMeasure.trim());
						if(unitVal!=null && unitVal.trim().length()>0)
						{
							unitForMeasure="&nbsp;("+unitVal+")";
						}
					}
					if(unitForMeasure!=null && unitForMeasure.indexOf("MB")>-1)
						unitForMeasure ="&nbsp;(GB)";

					if(tempDispName!=null && tempDispName.equalsIgnoreCase("Status")){
						unitForMeasure="";
					}
					else if(tempDispName!=null && (tempDispName.equalsIgnoreCase("Disk Used") || tempDispName.equalsIgnoreCase("Used Space"))){
						unitForMeasure="("+mappingInfo.getTextDescription("monitor.VirtualDashboard.GB")+")";
					}
					String orderByColumn = "";
					if(isLocColumn)
					{
						orderByColumn = tempDispName;
						//orderByColumnName = tempDispName;
					}
					else if (isDDDColumn)
					{
						orderByColumn = Dbdata.getColumnForMeasure(tempTest+"_DDD",colName);
						//col_name = dbInfo.getColumnForMeasure(test+"_DDD",tmp_col_name);
						//orderByColumnName = Dbdata.getColumnForMeasure(tempTest,tempMeasure);
					}
					else
					{
						orderByColumn = Dbdata.getColumnForMeasure(tempTest,tempMeasure); 
					}

					if((convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(tempTest+":"+tempMeasure)) || (udm_hide_unit_list!=null && udm_hide_unit_list.size()>0 && udm_hide_unit_list.contains(tempTest+":"+tempMeasure)) || (convertToYesNoList!=null && convertToYesNoList.size()>0 && convertToYesNoList.contains(tempTest+":"+tempMeasure)))
					{
						unitForMeasure="";
					}

					if(isUnitConvertion && converstionTestMeasureUnit.contains(testnameWithMeasure))
					{
						String unitMeas = dashIni.getValue("Convert_To_MB_GB_TB",testnameWithMeasure);
						if(unitMeas != null && unitMeas.trim().length() > 0)
							unitForMeasure="("+unitMeas+")";
					}
					if(isDDDColumn || (isShowUserLocation && isLocColumn))
					{
						if((unitForMeasure==null || unitForMeasure.equals("")) && (meas!=null && !meas.equalsIgnoreCase("DATE")))
						{
							buf.append("<th class=\"printTableHeader\" align=\"center\" wrap >"+tempDispName+" </th>");
							headerVect.add(tempDispName);
						}
						else
						{
							buf.append("<th class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+"</br>"+unitForMeasure+" </th>");
							headerVect.add(tempDispName+unitForMeasure);
						}

						isAddCol = true;
						sb_list=new ArrayList();
					}
					else
					{
						if(unitForMeasure==null || unitForMeasure.equals(""))
						{
							buf.append("<th class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+" </th>");
							headerVect.add(tempDispName);
							isAddCol = true;
							sb_list=new ArrayList();
						}
						else
						{
							boolean isSubHeaderColumn = false;
							tempMeasure = tempMeasure.trim();
							if(isMSO365DD ){
								if(group_mea_name!=null && group_mea_name.trim().length()>0){
								int groupCount = Integer.parseInt(ini.getValue("USER_DESKTOP_METRICS_GROUP_COLUMNS_COUNT",group_mea_name));
								if(subColumnHeaderCount == 0)
									subColumnHeader = "<th style='padding:0px;margin:0px' colspan='3' ><div style=' flex:1;width:450px;display:flex; flex-direction:column'><div style='border-bottom:1px solid #cdcdcd'>"+group_mea_name+"</div><div style='display:flex;flex-direction:row;'> ";
								/*if(tempMeasure.equalsIgnoreCase("RchWarngQuota") || tempMeasure.equalsIgnoreCase("RchSndQuota") ||tempMeasure.equalsIgnoreCase("RchSndRcvQuota") ||tempMeasure.equalsIgnoreCase("sendCount") || tempMeasure.equalsIgnoreCase("rcvCount") || tempMeasure.equalsIgnoreCase("readCount")){*/
									isSubHeaderColumn = true;
									subColumnHeaderCount++;
									String borderSize = "1";
									if(subColumnHeaderCount == groupCount){
										borderSize= "0";
									}
									subColumnHeader += "<div style=' flex:1;border-right:"+borderSize+"px solid #cdcdcd;padding:2px '>"+tempDispName+"</div>";
									sb_list.add(group_mea_name+" - "+tempDispName);
									sb_final_hash.put(group_mea_name+" - "+tempDispName,tempValue);

									if(subColumnHeaderCount == groupCount)
									{
										subColumnHeader += "</div></div></th>";
										buf.append(subColumnHeader);
										subColumnHeaderCount = 0;
										subColumnHeader="";
										isAddCol = true;

										for(int kk=0;kk<sb_list.size();kk++)
										{
											String newTmpCol=(String)sb_list.get(kk);
											headerVect.add(newTmpCol);
										}

										sb_final_list.addAll(sb_list);
										sb_list=new ArrayList();
									}
									else
										isAddCol = false;

								}else
								{
									buf.append("<th class=\"printTableHeader\" align=\"center\" wrap > "+tempDispName+"</th>");
									headerVect.add(tempDispName);
									isAddCol = true;
									sb_list=new ArrayList();
								}
							}
							
							/*if(isMSO365DD){
								if(isSubHeaderColumn)
									headerVect.add(group_mea_name+" - "+tempDispName);
								else
									headerVect.add(tempDispName);
							}*/
						}
					}

					if(isAddCol && displayColsList!=null && tempDispName!=null && !displayColsList.contains(tempDispName))
					{
						if(sb_final_list!=null && sb_final_list.size()>0)
						{
							for(int kk=0;kk<sb_final_list.size();kk++)
							{
								String newTmpCol=(String)sb_final_list.get(kk);
								String newTmpValue=(String)sb_final_hash.get(newTmpCol);
								displayColsList.add(newTmpCol);
								if(sameLabelHash!=null && sameLabelHash.containsKey(newTmpCol))
								{
									ArrayList tmp_list=(ArrayList)sameLabelHash.get(newTmpCol);
									tmp_list.add(newTmpValue);
									sameLabelHash.put(newTmpCol,(ArrayList)tmp_list);
								}
								else
								{
									ArrayList tmp_list=new ArrayList();
									tmp_list.add(newTmpValue);
									sameLabelHash.put(newTmpCol,(ArrayList)tmp_list);
								}
							}
						}
						else
						{
							displayColsList.add(tempDispName);
							if(sameLabelHash!=null && sameLabelHash.containsKey(tempDispName))
							{
								ArrayList tmp_list=(ArrayList)sameLabelHash.get(tempDispName);
								tmp_list.add(tempValue);
								sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
							}
							else
							{
								ArrayList tmp_list=new ArrayList();
								tmp_list.add(tempValue);
								sameLabelHash.put(tempDispName,(ArrayList)tmp_list);
							}
						}
					}

					if(isAddCol && validColsList!=null && tempValue!=null && !validColsList.contains(tempValue))
					{
						if(sb_final_list!=null && sb_final_list.size()>0)
						{
							for(int kk=0;kk<sb_final_list.size();kk++)
							{
								String newTmpCol=(String)sb_final_list.get(kk);
								String newTmpValue=(String)sb_final_hash.get(newTmpCol);

								validColsList.add(newTmpValue);
							}

							sb_final_list=new ArrayList();
							sb_final_hash=new Hashtable();
						}
						else
						{
							validColsList.add(tempValue);
						}
					}
				}
			}

			
				if(validColsList!=null && validColsList.size()>0)
				{
					measureArray = new String[validColsList.size()];
					int yy=0;
					for(int y=0;y<validColsList.size();y++)
					{
						String tempValue1 = (String)validColsList.get(y);
						if(tempValue1!=null && tempValue1.trim().length()>0)
						{
							measureArray[yy++]=tempValue1;
						}
					}
				}
				
				listData.add(headerVect);
				buf.append("</tr>");
				buf.append("</thead>");
				buf.append("<tbody>");

			EgService serv = null;
			int desktopsSize = (vdiDesktopsList!=null && vdiDesktopsList.size()>0)?vdiDesktopsList.size():0;
			for(int i=0;i<desktopsSize;i++)
			{
				serv = (EgService)vdiDesktopsList.get(i);
				Vector dataVector = new Vector();
				StringBuffer dataBuf = new StringBuffer(128);

				String desktopComponent = serv.getName();
				String desktopState = serv.getState().getName();
				String desktopName = "";
				String comp = "";
				String compValue = "";
				String compName = "";
				String compTenantName = null;
				String compNameWithOutPort = "";
				String port = "NULL";

				if(desktopComponent!=null && desktopComponent.indexOf("^")>-1)
				{
					desktopName = desktopComponent.substring(0,desktopComponent.indexOf("^"));
					comp = desktopComponent.substring(desktopComponent.indexOf("^")+1);
				}
				if(comp!=null && comp.indexOf(":")>-1)
				{
					compValue = comp.substring(0,comp.indexOf(":"));
					compName = comp.substring(comp.indexOf(":")+1);
				}
				if(compName!=null && compName.indexOf(":")>-1)
				{
					compNameWithOutPort = compName.substring(0,compName.indexOf(":"));
					port = compName.substring(compName.indexOf(":")+1);

					int inxTen=compNameWithOutPort.lastIndexOf("_");
					if(inxTen!=-1)
						compTenantName = compNameWithOutPort.substring(0,inxTen);
				}
				measureValues = (Hashtable)TotalMeasureInfo.get(comp);
				commonMeasureValues = new Hashtable();
				if(ls_server!=null && ls_server.size()>1)
				{
					commonMeasureValues = (Hashtable)TotalMeasureInfo.get("eGCommon:NULL");
					if(commonMeasureValues!=null && commonMeasureValues.size()>0)
					{
						//measureValues.putAll(commonMeasureValues);
					}
					else if(commonMeasureValues==null && compTenantName!=null)
					{
						commonMeasureValues = (Hashtable)TotalMeasureInfo.get(compTenantName+"_eGCommon:NULL");
						if(commonMeasureValues!=null && commonMeasureValues.size()>0)
						{
							//measureValues.putAll(commonMeasureValues);
						}
					}
				}

				String msmtHost = "";
				String ctype_layer=ini.getValue("USER_DESKTOP_LAYERS",compValue);
				if(userType!=null && userType.equalsIgnoreCase("VDIESX"))
					ctype_layer=ini.getValue("USER_DESKTOP_LAYERS",userType+":"+compValue);
				ctype_layer=(ctype_layer==null || ctype_layer.trim().length()==0)?"VIRTUAL_DESKTOP":ctype_layer;
				//ArrayList arr = tablesInfo.getTestsForLayer(ctype_layer);
				ArrayList arr = tablesInfo.getTestsForLayer(ctype_layer,compValue);
				if(arr!=null && arr.size()>0)
				{
					boolean flag=true;
					for (int t=0;t<arr.size();t++)
					{
						String insideviewTest=(String) arr.get(t);
						if(insideviewTest!=null && insideviewTest.trim().length()>0)
						{
							List agents=egExternalInfo.getAgentsFor(insideviewTest.trim(),compValue,compNameWithOutPort);

							if(agents!=null && agents.size()>0)
							{
								msmtHost=(String)agents.get(0);
								flag=false;
								break;
							}
						}
					}

					if(flag)
						msmtHost=compNameWithOutPort;
				}
				else
					msmtHost=compNameWithOutPort;

				String disp_desktopName=desktopName;
				boolean isDescriptorMaintenanceForTest=false;
				if(disp_desktopName!=null && disp_desktopName.indexOf("_on_")>0)
				{
					String tmpdisp_desktopName = disp_desktopName;
					tmpdisp_desktopName = tmpdisp_desktopName.substring(tmpdisp_desktopName.indexOf("_on_")+4);
					isDescriptorMaintenanceForTest=maintenanceInfo.isItMaintenanceTime("Vmg", dispDate,tmpdisp_desktopName,true);
				}
				else
				{
					isDescriptorMaintenanceForTest=maintenanceInfo.isItMaintenanceTime("Vmg", dispDate,disp_desktopName,true);
				}

				String strName = compName;
				if (strName.endsWith(EgConstants.NULL_PORT) && (strName.indexOf(EgConstants.NULL_PORT) > -1))
				{
					strName = Server.getServerNameWithoutPort(strName, false);
				}

				String disp_StrName = strName;
									if(userType!=null && (userType.equalsIgnoreCase("AppXenApp7") || userType.equalsIgnoreCase("AppDDXenApp7") || userType.equals("AppLaunchDDXenApp7") || userType.equals("OverviewAppXenApp7") || userType.equals("OverviewAppVDI") || userType.equals("MSO365DD")))
									{
										if(disp_desktopName.indexOf("~SEQ~")>-1)
										{
											disp_desktopName=disp_desktopName.substring(0,disp_desktopName.indexOf("~SEQ~"));
										}
									}
									dataBuf.append("<tr class=\"x-grid-row  x-grid-row-alt\">");
									dataBuf.append("<td style='display:inline-flex;flex-flow: nowrap;border:none;text-align:left;width:100%;white-space:nowrap;'>"+disp_desktopName+"</td>");
										dataVector.add("");
										String labeldeskState = mappingInfo.getLabelDescription(desktopState);
										
										dataVector.add(disp_desktopName);

				measureList = Arrays.asList(measureArray);
				boolean isAllNeg=true;
				if((measureValues!=null && measureValues.size()>0) || (commonMeasureValues!=null && commonMeasureValues.size()>0))
				{
					String ctype_out_layer=ui.getValue("Layer_for_ComponentType",compValue);
					ctype_out_layer=(ctype_out_layer==null || ctype_out_layer.trim().length()==0)?"VIRTUAL_GUESTS":ctype_out_layer;
					ArrayList listOfTest=(ArrayList)tablesInfo.getTestsForLayer(ctype_out_layer,compValue);

					if(userType!=null && (userType.equals("CitrixXenVDI") || userType.equals("VDI") || userType.equals("ESX")))
					{
						String ctype_in_layer=ini.getValue("USER_DESKTOP_LAYERS",compValue);
						ctype_in_layer=(ctype_in_layer==null || ctype_in_layer.trim().length()==0)?"VIRTUAL_DESKTOP":ctype_in_layer;
						listOfTest.addAll((ArrayList)tablesInfo.getTestsForLayer(ctype_in_layer,compValue));
					}

					int p=0;
					String info_to_lower=desktopName;
					String info_to_lower_for_test=desktopName;
					if(info_to_lower_for_test.indexOf("~SEQ~")>-1)
					{
						info_to_lower_for_test=info_to_lower_for_test.substring(0,info_to_lower_for_test.indexOf("~SEQ~"));
					}

					Hashtable temp_Desc_Hash= new Hashtable();
					Hashtable temp_Test_Hash= new Hashtable();
					while(p<measureList.size())
					{
						String keyForList = (String)measureList.get(p);
						String keyMeasure = "";
						String keyOrgMeasure = "";
						String keyTest = "";
						String keydisplayMeasure = "";
						StringTokenizer valTokens = new StringTokenizer(keyForList,":");
						int tokCount = valTokens.countTokens();
						boolean isDDDTestColumn = false;
						boolean isLocationColumn = false;
						if(tokCount==5)
							isDDDTestColumn = true;
						else if(tokCount==2)
							isLocationColumn = true;
						String orgColName = "";
						String funcName = "";
						String dispName = "";
						
						String tempDispName = "";
						String locKeyName = "";
						String Value="";
						String units="";
						
						ArrayList keyMeasureList = null; 
						ArrayList locMeasuresList = new ArrayList();
						if(isDDDTestColumn)
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
								if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
								{
									orgColName=keyMeasure.substring(keyMeasure.indexOf(":")+1);
									keyMeasure = keyMeasure.substring(0,keyMeasure.indexOf(":"));
									if(orgColName!=null && orgColName.indexOf(":")>-1)
									{
										funcName=orgColName.substring(orgColName.indexOf(":")+1);
										orgColName = orgColName.substring(0,orgColName.indexOf(":"));
									}
									if(funcName!=null && funcName.indexOf(":")>-1)
									{
										dispName = funcName.substring(funcName.indexOf(":")+1);
										funcName = funcName.substring(0,funcName.indexOf(":"));
									}
								}
							}
							
							if(keyTest!=null && keyTest.trim().length()>0 && listOfTest!=null && listOfTest.size()>0 && !listOfTest.contains(keyTest) && dispName!=null)
							{
								ArrayList tmpArry=(ArrayList)sameLabelHash.get(dispName);
								
								if(tmpArry!=null && tmpArry.size()>0)
								{
									for(int kk=0;kk<tmpArry.size();kk++)
									{
										String newKeyForList =(String)tmpArry.get(kk);
										String newKeyTest=null;
										if(newKeyForList!=null && newKeyForList.indexOf(":")>-1)
										{
											newKeyTest=newKeyForList.substring(0,newKeyForList.indexOf(":"));
										}

										if(newKeyTest!=null && newKeyTest.trim().length()>0 && listOfTest!=null && listOfTest.contains(newKeyTest))
										{
											keyForList = newKeyForList;
											if(keyForList!=null && keyForList.indexOf(":")>-1)
											{
												keyTest=keyForList.substring(0,keyForList.indexOf(":"));
												keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
												if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
												{
													orgColName=keyMeasure.substring(keyMeasure.indexOf(":")+1);
													keyMeasure = keyMeasure.substring(0,keyMeasure.indexOf(":"));
													if(orgColName!=null && orgColName.indexOf(":")>-1)
													{
														funcName=orgColName.substring(orgColName.indexOf(":")+1);
														orgColName = orgColName.substring(0,orgColName.indexOf(":"));

														if(funcName!=null && funcName.indexOf(":")>-1)
														{
															dispName=funcName.substring(funcName.indexOf(":")+1);
															funcName = funcName.substring(0,funcName.indexOf(":"));
														}
													}
												}
											}

											break;
										}
									}
								}
							}

							keydisplayMeasure = dispName;
							String colKeyName = Dbdata.getColumnForMeasure(keyTest+"_DDD",orgColName);
							String tmpK = colKeyName+"^"+info_to_lower.toLowerCase()+"^"+compNameWithOutPort;
							Value=getMeasureValue(measureValues,keyTest,colKeyName,info_to_lower,compNameWithOutPort,compTenantName,commonMeasureValues);
							Value = getManagerTimeToUserTimeConvertion(egFormat,convert,user,keyTest,orgColName,Value);
						}
						else
						{
							if(keyForList!=null && keyForList.indexOf(":")>-1)
							{
								keyTest=keyForList.substring(0,keyForList.indexOf(":"));
								keyMeasure=keyForList.substring(keyForList.indexOf(":")+1);
								if(keyMeasure!=null && keyMeasure.indexOf(":")>-1)
								{
									keydisplayMeasure=keyMeasure.substring(keyMeasure.indexOf(":")+1);
									keyMeasure=keyMeasure.substring(0,keyMeasure.indexOf(":"));
								}
							}
							units=tablesInfo.getUnitForMeasure(keyTest,keyMeasure);
							keyOrgMeasure = keyMeasure;
							keyMeasure = Dbdata.getColumnForMeasure(keyTest,keyMeasure);
							//if(specsInfo.isTestRelevantForServer(compValue,keyTest))
							{
								Value=getMeasureValue(measureValues,keyTest,keyMeasure,info_to_lower_for_test,compNameWithOutPort,compTenantName,commonMeasureValues);
							}
						}

						//if((Value==null || Value.trim().length()==0) && compValue!=null && compValue.equals("Xen_desktop_server"))
						if(Value==null || Value.trim().length()==0)
						{
							if(info_to_lower!=null && (info_to_lower.indexOf(" ")>-1 && info_to_lower.indexOf("on")>-1))
							{
								ArrayList tokenList =  com.egurkha.util.StringUtils.egTokenizer(info_to_lower, " on ",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
								if(tokenList!=null && tokenList.size()==2)
								{
									info_to_lower=(String)tokenList.get(0)+"_on_"+(String)tokenList.get(1);
								}
							}
							Value=getMeasureValue(measureValues,keyTest,keyMeasure,info_to_lower,compNameWithOutPort,compTenantName,commonMeasureValues);
						}
						String mes_state="";
						String mes_name="";
						String total_spc="0";

						if(Value!=null && Value.indexOf("^")>-1)
						{
							mes_state=Value.substring(Value.indexOf("^")+1);
							if(mes_state!=null && mes_state.indexOf("^")>-1)
							{
								mes_name=mes_state.substring(mes_state.indexOf("^")+1);
								mes_state=mes_state.substring(0,mes_state.indexOf("^"));
								if(mes_name!=null && mes_name.indexOf("^")>-1)
								{
									total_spc=mes_name.substring(mes_name.indexOf("^")+1);
									mes_name=mes_name.substring(0,mes_name.indexOf("^"));
								}
							}
							Value=Value.substring(0,Value.indexOf("^"));
						}
						else if(Value==null)
						{
							Value="-";
							mes_name=keyMeasure;
							mes_state="GOOD";
						}

						boolean sameLabelFlag=false;
						if(sameLabelHash!=null && sameLabelHash.size()>0 && keydisplayMeasure!=null && sameLabelHash.containsKey(keydisplayMeasure))
						{
							ArrayList tmpArry2=(ArrayList)sameLabelHash.get(keydisplayMeasure);
							ArrayList tmpNewArry=new ArrayList();
							tmpNewArry.addAll(tmpArry2);
							if(userType!=null && !userType.equals("CitrixXenVDI"))
							{
								if(tmpNewArry!=null && tmpNewArry.size()>0 && keyForList!=null && tmpNewArry.contains(keyForList))
									tmpNewArry.remove(keyForList);
							}
							if(tmpNewArry!=null && tmpNewArry.size()>0)
							{
								sameLabelFlag=true;
								if(!dashboardModel.isTestActive(compValue, compName, keyTest, "custom"))
									Value="-";
							}
						}
						if((Value==null || Value.trim().length()==0 || Value.equals("-")) && sameLabelFlag && (sameLabelHash!=null && sameLabelHash.size()>0 && sameLabelHash.containsKey(keydisplayMeasure)))
						{
							ArrayList tmpArry3=(ArrayList)sameLabelHash.get(keydisplayMeasure);
							ArrayList tmpOldArry=new ArrayList();
							if(tmpArry3!=null && tmpArry3.size()>0)
							{
								tmpOldArry.addAll(tmpArry3);
								if(tmpOldArry.contains(keyForList))
								{
									tmpOldArry.remove(keyForList);
								}
								for(int kk=0;kk<tmpOldArry.size();kk++)
								{
									keyForList =(String)tmpOldArry.get(kk);
									String tmp_keyTest=null;
									String tmp_keyMeasure=null;
									String tmp_keydisplayMeasure=null;
									String tmp_keyDDMeasure=null;
									//String tmp_units=null;
									if(keyForList!=null && keyForList.indexOf(":")>-1)
									{
										ArrayList keyTokenList =  com.egurkha.util.StringUtils.egTokenizer(keyForList, ":",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim

										if(keyTokenList!=null && keyTokenList.size()==3)
										{
											tmp_keyTest=(String)keyTokenList.get(0);
											tmp_keyMeasure=(String)keyTokenList.get(1);
											tmp_keydisplayMeasure=(String)keyTokenList.get(2);
										}
										else if(keyTokenList!=null && keyTokenList.size()==5)//VmgPcoIPSessionTest:Round_trip:ClientIp:NONE:Client IP
										{
											tmp_keyTest=(String)keyTokenList.get(0);
											tmp_keyMeasure=(String)keyTokenList.get(1);
											tmp_keyDDMeasure=(String)keyTokenList.get(2);
											tmp_keydisplayMeasure=(String)keyTokenList.get(4);
										}
									}
									
									//tmp_units=tablesInfo.getUnitForMeasure(tmp_keyTest,tmp_keyMeasure);
									String tmp_keyOrgMeasure = tmp_keyMeasure;
									if(tmp_keyDDMeasure!=null)
										tmp_keyMeasure = Dbdata.getColumnForMeasure(tmp_keyTest+"_DDD",tmp_keyDDMeasure);
									else
										tmp_keyMeasure = Dbdata.getColumnForMeasure(tmp_keyTest,tmp_keyMeasure);

									String tmp_Value=null;
									boolean isTimeout = false;

									if(tmp_keyDDMeasure==null)
										isTimeout = isTimeoutCheck(compName,tmp_keyTest,msmtHost,compValue,info_to_lower);

									if((!isTimeout) || excludedTestList.contains(tmp_keyTest))
									{
										if(specsInfo.isTestRelevantForServer(compValue,tmp_keyTest))
										{
											tmp_Value=getMeasureValue(measureValues,tmp_keyTest,tmp_keyMeasure,info_to_lower,compNameWithOutPort,compTenantName,commonMeasureValues);
											if(tmp_Value==null || tmp_Value.trim().length()==0)
											{
												if(info_to_lower!=null && (info_to_lower.indexOf(" ")>-1 && info_to_lower.indexOf("on")>-1))
												{
													ArrayList tokenList =  com.egurkha.util.StringUtils.egTokenizer(info_to_lower, " on ",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
													if(tokenList!=null && tokenList.size()==2)
													{
														info_to_lower=(String)tokenList.get(0)+"_on_"+(String)tokenList.get(1);
													}
												}
												tmp_Value=getMeasureValue(measureValues,tmp_keyTest,tmp_keyMeasure,info_to_lower,compNameWithOutPort,compTenantName,commonMeasureValues);
											}
										}

										if(tmp_Value!=null && tmp_Value.indexOf("^")>-1)
										{
											String tmp_mes_state=tmp_Value.substring(tmp_Value.indexOf("^")+1);
											String tmp_total_spc=null;
											String tmp_mes_name=null;
											if(tmp_mes_state!=null && tmp_mes_state.indexOf("^")>-1)
											{
												tmp_mes_name=tmp_mes_state.substring(tmp_mes_state.indexOf("^")+1);
												tmp_mes_state=tmp_mes_state.substring(0,tmp_mes_state.indexOf("^"));
												if(tmp_mes_name!=null && tmp_mes_name.indexOf("^")>-1)
												{
													total_spc=tmp_mes_name.substring(tmp_mes_name.indexOf("^")+1);
													tmp_mes_name=tmp_mes_name.substring(0,tmp_mes_name.indexOf("^"));
												}
											}
											tmp_Value=tmp_Value.substring(0,tmp_Value.indexOf("^"));

											if(tmp_Value!=null && !tmp_Value.trim().equals("-"))
											{
												keyTest=tmp_keyTest;
												keyMeasure=tmp_keyMeasure;
												keyOrgMeasure = tmp_keyOrgMeasure;
												Value=tmp_Value;
												total_spc= tmp_total_spc;
												mes_name=tmp_mes_name;
												mes_state=tmp_mes_state;
												break;
											}
										}
									}
								}
							}
						}

						String desc_key=compNameWithOutPort+":"+port+":"+compValue+":"+keyTest;
						Vector getDescs = (Vector)temp_Desc_Hash.get(desc_key);
						if(getDescs==null || getDescs.size()==0)
						{
							//getDescs=(Vector)dashboardDAO.getDescriptorsForTest(compNameWithOutPort+":"+port, compValue, keyTest, "custom");
							if(getDescs!=null && getDescs.size()>0)
								temp_Desc_Hash.put(desc_key,(Vector)getDescs);
						}
						String test_key=compValue+":"+compNameWithOutPort+":"+port;
						Hashtable getTests = (Hashtable)temp_Test_Hash.get(test_key);
						if(getTests==null || getTests.size()==0)
						{
							getTests =(Hashtable) metaTest.get(test_key);
							if(getTests!=null)
								temp_Test_Hash.put(test_key,getTests);
						}
						
						
						String orgValue="0.0";
						
						try
						{
							if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
							{
								orgValue=Value;
								//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
								}
								else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value = getConvertDays(Value,egDashboard);
								}
								else if(convertToYesNoList!=null && keyForList!=null && convertToYesNoList.contains(keyForList))
								{
									double new_value=Double.parseDouble(Value);
									if(new_value>0)
									{
										Value ="Yes ";
									}
									else
									{
										Value ="No ";
									}
								}
								else
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								}

								Value=String.valueOf(Value);
							}
							else if(Value!=null && Value.trim().length()>0  && Double.parseDouble(Value)>0)
							{
								orgValue=Value;
								//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
								}
								else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
								{
									Value = getConvertDays(Value,egDashboard);
								}
								else if(convertToYesNoList!=null && keyForList!=null && convertToYesNoList.contains(keyForList))
								{
									double new_value=Double.parseDouble(Value);
									if(new_value>0)
									{
										Value ="Yes ";
									}
									else
									{
										Value ="No ";
									}
								}
								else
								{
									//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
								}

								Value=String.valueOf(Value);
							}
							else if(Value!=null && Value.trim().length()>0  && Double.parseDouble(Value)==0)
							{
								orgValue=Value;
								if(convertToYesNoList!=null && keyForList!=null && convertToYesNoList.contains(keyForList))
								{
									double new_value=Double.parseDouble(Value);
									if(new_value>0)
									{
										Value ="Yes ";
									}
									else
									{
										Value ="No ";
									}
								}
								else
									Value=String.valueOf(Value);
							}
						}
						catch(Exception ee)
						{
							if(Value!=null && Value.trim().length()>0 && Value.equals("-"))
							{
								if(convertToYesNoList!=null && keyForList!=null && convertToYesNoList.contains(keyForList))
								{
									orgValue="Unknown ";
									Value ="Unknown ";
								}
								else if(convertToYesNoList!=null && keyForList!=null && keyForList.equals("O365UsersLicnsDtls:TotLicAssgnd:Licenses Assigned"))
								{
									orgValue="0";
									Value ="NA";
								}
								else
								{
									Value=String.valueOf(Value);
									orgValue=Value;
								}
							}
							else
							{
								if(Value==null || Value.equalsIgnoreCase("unknown"))
									Value = "-";

								Value=Value;
								orgValue=Value;
							}
						}
						if(mes_state!=null && mes_state.length()>0 && mes_state.equalsIgnoreCase("NONE"))
						{
							mes_state="GOOD";
						}
						else if(mes_state!=null && mes_state.trim().length()==0)
						{
							mes_state="GOOD";
						}
							String measuresLink = "";
							if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
							{
								String layerName = tablesInfo.getRelevantLayer(compValue,keyTest,keyOrgMeasure);
								layerName=(layerName==null || layerName.trim().length()==0)?ctype_layer:layerName;
								
								String infoKey = compValue+":"+compName+":"+keyTest+":"+info_to_lower;
								HashSet infosSet = null;
								if(fullInfoHash!=null && fullInfoHash.size()>0)
									infosSet = (HashSet)fullInfoHash.get(infoKey);
								ArrayList infosList = null;
								if(infosSet!=null && infosSet.size()>0)
									infosList = new ArrayList(infosSet);
								String info_name = "";
								if(infosList!=null && infosList.size()>1)
								{
									for(int is=0;is<infosList.size();is++)
									{
										String tmpInfo = (String)infosList.get(is);
										if(tmpInfo!=null && (tmpInfo.endsWith(":Summary") || tmpInfo.endsWith(":Total")))
										{
											info_name = tmpInfo;
											break;
										}
									}
									if(info_name==null || info_name.equalsIgnoreCase("null") || info_name.trim().length()==0)
									{
										info_name = (String)infosList.get(0);
									}
								}
								else if(infosList!=null && infosList.size()==1)
								{
									info_name = (String)infosList.get(0);
								}
								if(info_name==null || info_name.equalsIgnoreCase("null") || info_name.trim().length()==0)
								{
									info_name = "+" + info_to_lower;
								}
								measuresLink = "/final/monitor/EgSiteInfraView.jsp?qctr=2"+"&site=NULL"+"&fromalarm=0"+"&newWindow=false"+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&comptype="+compValue+"&layer="+layerName+"&test="+keyTest+"-"+EgURLEncoder.encode(info_name,"UTF-8")+"&tstate="+mes_state+"&toDashBoardLayer=true";
							}
							if(mes_name!=null)
							{
								if(Value!=null && !Value.equals("-"))
								{
									try
									{
										double fillColorValue=Double.parseDouble(orgValue);
										if(units!=null && units.equals("MB"))
										{
											//units = "GB";
											fillColorValue=fillColorValue/1024.0;
										}
										Value=String.valueOf(fillColorValue);
										//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
										if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
										{
											if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
											{
												Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
											}
											else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
											{
												Value = getConvertDays(Value,egDashboard);
											}
											else if(convertToYesNoList!=null && keyForList!=null && convertToYesNoList.contains(keyForList))
											{
												double new_value=Double.parseDouble(Value);
												if(new_value>0)
												{
													Value ="Yes ";
												}
												else
												{
													Value ="No ";
												}
											}
											else
											{
												Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
											}
										}
										else if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)==0)
										{
											if(convertToYesNoList!=null && keyForList!=null && convertToYesNoList.contains(keyForList))
											{
												double new_value=Double.parseDouble(Value);
												if(new_value>0)
												{
													Value ="Yes ";
												}
												else
												{
													Value ="No ";
												}
											}
										}
										else
										{
											//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
										}

										Value=String.valueOf(Value);
									}
									catch(Exception ee)
									{
										if(Value!=null && Value.trim().length()>0 && Value.equals("-"))
										{
											if(convertToYesNoList!=null && keyForList!=null && convertToYesNoList.contains(keyForList))
											{
												orgValue="Unknown ";
												Value ="Unknown ";
											}
											else if(convertToYesNoList!=null && keyForList!=null && keyForList.equals("O365UsersLicnsDtls:TotLicAssgnd:Licenses Assigned"))
											{
												orgValue="0";
												Value ="NA";
											}
											else
											{
												Value=String.valueOf(Value);
												orgValue=Value;
											}
										}
										else
										{
											Value=String.valueOf(orgValue);
										}
									}

									if(isDDDTestColumn || isLocationColumn)
									{
										dataBuf.append("<td  align=\"left\"  >");
										dataBuf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"left\">");
									}
									else
									{
										dataBuf.append("<td  align=\"center\" >");
										//buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"right\">");
										dataBuf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">");
									}
									dataBuf.append("<tr style=\"background:none !important\">");
									if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											dataBuf.append("<td class=\"mouse\" align=\"left\" style=\"text-align:left;\" \"data-qtip=\""+Value+"\" data-qclass=\"yellowTip\" >");
											
										}
										else
										{
											dataBuf.append("<td class=\"mouse\" align=\"right\" >");
										}
									}
									else
									{
										if(isDDDTestColumn || isLocationColumn)
										{
											dataBuf.append("<td style=\"white-space:pre-wrap;border:none;\" align=\"left\">");
										}
										else
										{
											dataBuf.append("<td style=\"white-space:pre-wrap;border:none;\" align=\"left\">");
										}
									}
								}
								else
								{
									if(isDDDTestColumn || isLocationColumn)
									{
										dataBuf.append("<td  style=\"text-align:left;\" align=\"left\" >");
											dataBuf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"red\"  style=\"table-layout:auto;\" align=\"left\">");
									}
									else
									{
										dataBuf.append("<td align=\"center\" >");
											//buf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"right\">");
											dataBuf.append("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" borderColor=\"green\"  style=\"table-layout:auto;\" align=\"center\">");
									}
									dataBuf.append("<tr style=\"background:none !important\">");
									if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
									{
										if(isDDDTestColumn||isLocationColumn)
										{
											dataBuf.append("<td align=\"left\" style=\"border:none;padding-right:10px;text-align:left;\" >");
										}
										else
										{
											dataBuf.append("<td class=\"mouse\" align=\"left\" style=\"border:none;padding-right:10px\" >");
										}
									}
									else
									{
										dataBuf.append("<td align=\"left\" style=\"border:none;padding-right:10px\">");
									}
								}
							}
							else
							{
								dataBuf.append("<td  style=\"padding-top:4px;\" align=\"center\"  >");
									dataBuf.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"table-layout:auto;border:0px solid red;border:none;\" align=\"right\">");
										dataBuf.append("<tr style=\"background:none !important\">");
											if(fromMenuStr!=null && !fromMenuStr.equalsIgnoreCase("null") && fromMenuStr.trim().length()>0 && fromMenuStr.equalsIgnoreCase("true"))
											{
												if(isDDDTestColumn||isLocationColumn)
												{
													dataBuf.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\" >");
												}
												else
												{
													dataBuf.append("<td class=\"mouse\" align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\" onClick=\"javascript:goToDetails('"+measuresLink+"');\" >");
												}
											}
											else
											{
												dataBuf.append("<td align=\"right\" style=\"font-size:11px;text-align:right;width:20px;padding-right:10px\">");
											}
							}

							if(isUnitConvertion && converstionTestMeasureUnit.contains(keyTest+":"+keyOrgMeasure) && (!Value.equals("-")) && (!Value.equals("0")))
								Value = getConvertedValue(tablesInfo,Dbdata,dashIni,keyTest,keyOrgMeasure,Value);

							Value = formatDbValue(Value);

							String iniVar=keyTest+":"+keyOrgMeasure+":"+Value;
							boolean isMDV=false;
							String iniValue=(String)uiIni.getValue("Measure_value_display",iniVar);
							if(iniValue!=null && iniValue.trim().length()>0)
							{
								Value = iniValue;
								if(Value.endsWith("connection"))
								{
									int ind=Value.indexOf(" ");
									if(ind!=-1)
										Value=Value.substring(0,ind);
								}
								isMDV=true;
							}

							String labelTmpState = mappingInfo.getLabelDescription(mes_state);
							//dataVector.add(Value);
							
							if(Value!=null && !Value.equals("-"))
							{
								isAllNeg = false;
								boolean usage =true;
								
								if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage && (!isMDV))
								{
									if(isMSO365DD)
										dataVector.add(Value);
									int columnWidth = 100;
									Long temp_measure_value=new Long(Math.round(Double.parseDouble(Value)));
									long fillColorValue=temp_measure_value.longValue();
									long value2 = (fillColorValue*100)/columnWidth;
									String mes_state_GOOD="";
									if(mes_state.equalsIgnoreCase("high"))
									{
										mes_state_GOOD="#cd0f0f";
									}
									else if(mes_state.equalsIgnoreCase("intermediate"))
									{
										mes_state_GOOD="#fa9d1c";
									}
									else if(mes_state.equalsIgnoreCase("low"))
									{
										mes_state_GOOD="#ccc100";
									}
									else if(mes_state.equalsIgnoreCase("unknown"))
									{
										mes_state_GOOD="#30a1d9";
									}
									else if(mes_state.equalsIgnoreCase("good")) 
									{
										mes_state_GOOD="#0c9a12";
									}

								}
							}
							dataBuf.append("</td>");

							if(Value!=null && !Value.equals("-"))
							{
								boolean usage =true;
								
								if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage  && (!isMDV))
								{
									if(isMSO365DD)
										dataBuf.append("<td>"+Value+"</td>");
									
								}
								else
								{
									if(funcName!=null && (funcName.equalsIgnoreCase("NONE") || funcName.equalsIgnoreCase("DATE")))
									{
										dataVector.add(Value);
										
										dataBuf.append("<td style=\"border:none;text-align:left;padding-left:3px;width:42px;white-space:nowrap\">"+Value+"</td>");
									}
									else
									{
										//jp
										
										String iconClass ="stateSymbol_"+mes_state;
										if(isMSO365DD){
											dataVector.add(Value);
											if(Value.equalsIgnoreCase("yes"))
												iconClass="msUserYES";
											else if(Value.equalsIgnoreCase("no"))
												iconClass="msUserNO";
											else if(Value.equalsIgnoreCase("yes "))
												iconClass="iconLicensed";
											else if(Value.equalsIgnoreCase("no "))
												iconClass="iconNotLicensed";
											else if(Value.equalsIgnoreCase("unknown "))
												iconClass="iconUnknownLicensed";
											else
												iconClass="";

											if(iconClass.trim().length()>0){
												//dataBuf.append("<td><div style='display: flex;'><div style='display:flex;margin: auto auto;'><div class='"+iconClass+"' style='border:0px solid red; margin:0px auto auto auto'></div><div style='margin: 4px auto auto 2px;'>"+Value+"</div></div></div></td>");
												if(iconClass.indexOf("Licensed")>0)
												{
													dataBuf.append("<td><div style='display:flex;'><div style='margin:auto auto' ><div class='"+iconClass+"'  ></div></div><div style='margin:0px auto auto auto ;'><div style='position:relative;margin-top:-2px'>&nbsp;</div></div></div></td>");
												}
												else
												{
													dataBuf.append("<td><div style='display:flex;'><div style='margin:auto auto' ><div class='"+iconClass+"'  ></div></div><div style='margin:0px auto auto auto ;'><div style='position:relative;margin-top:-2px'>"+Value+"</div></div></div></td>");
												}
											}
											else
												dataBuf.append("<td>"+Value+"</td>");
										}
									}
								}
								
							}
							else
							{
								dataVector.add(Value);
								boolean usage =true;
								if(mes_name!=null && mes_name.equalsIgnoreCase("Cpu_used")  && (!isMDV))
								{
									dataBuf.append("<td style=\"border:none;text-align:center;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap\">"+Value+"</td>");
								}
								else if(units!=null && units.equals("%") && !mes_name.equalsIgnoreCase("Ready") && usage  && (!isMDV))
								{
									dataBuf.append("<td style=\"border:none;text-align:center;padding-left:3px;padding-right:30px;width:42px;white-space:nowrap\">"+Value+"</td>");
								}
								else
								{
									dataBuf.append("<td style=\"border:none;text-align:center;padding-left:3px;width:100%;white-space:nowrap;\">"+Value+"</td>");
								}
								
							}
										dataBuf.append("</tr>");
									dataBuf.append("</table>");
								dataBuf.append("</td>");
						
						p++;
					}
				}
				dataBuf.append("</tr>");

				if(!isAllNeg)
				{
					listData.add(dataVector);
					buf.append(dataBuf.toString());
				}
				else if(tmpOrderByColumnName!=null && tmpOrderByColumnName.trim().length()>0 && !tmpOrderByColumnName.equalsIgnoreCase("null") && !tmpOrderByColumnName.equalsIgnoreCase("default"))
				{
					listData.add(dataVector);
					buf.append(dataBuf.toString());
				}
			}
								buf.append("</tbody>");	
							buf.append("</table>");
						buf.append("</div>");
					buf.append("</td>");
				buf.append("</tr>");
			buf.append("</table>");
		}
	}
	else
	{
		int col_span=measureList.size();
		buf.append("<table border=\"0\" width=\"100%\" height=\"100%\" bordercolor=\"green\">");
			buf.append("<tr style=\"background:none\">");
				buf.append("<td align=\"center\" width=\"100%\" colspan=\""+col_span+"\" height=\"100%\" class=\"commonErrorMsgText\" >");
					buf.append("<img src = \"/final/images/spacer.gif\" class=\"iconInformation\" lign = \"center\" border = \"0\"  vspace = \"10\"/>");
					if(userType!=null && userType.equalsIgnoreCase("VDIESX"))
					{
						//buf.append("<br>"+mappingInfo.getTextDescription("monitor.endUserDashboard.The relevant virtual components may not be Managed"));
						buf.append("<br>"+mappingInfo.getTextDescription("monitor.endUserDashboard.No Data Found"));
					}
					else
					{
						buf.append("<br>"+mappingInfo.getTextDescription("monitor.endUserDashboard.No Records Found"));
					}
				buf.append("</td>");
			buf.append("</tr>");
		buf.append("</table>");
	}
	session.setAttribute("endusercsvlist",listData);

	if(isDataManagerLogin)
	{
		if(request.getQueryString()!=null)
		{
			String qry=request.getQueryString();
			qry=com.egurkha.util.StringUtils.replace(qry, "\\", "\\\\");
			session.setAttribute("monitorLastSession","/final/monitor/msO365UserDashboard.jsp?access=allusers&"+qry);
		}
		else
			session.setAttribute("monitorLastSession","/final/monitor/msO365UserDashboard.jsp?access=allusers");
	}
	buf.append("</div>");
	if(!isCSV)
		response.getWriter().write(buf.toString());
}
catch(Throwable th)
{
	th.printStackTrace();
}
%>

<%!
	private static DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance();
	static{
		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');

		df.applyPattern("#.##");
		df.setDecimalFormatSymbols(dfs);
		df.setGroupingSize(0);
	}

	private static DecimalFormat df2 = (DecimalFormat)NumberFormat.getNumberInstance();
	static{
		DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
		dfs2.setDecimalSeparator('.');

		df2.applyPattern("#.####");
		df2.setDecimalFormatSymbols(dfs2);
		df2.setGroupingSize(0);
	}

	private static DecimalFormat df3 = (DecimalFormat)NumberFormat.getNumberInstance();
	static{
		DecimalFormatSymbols dfs3 = new DecimalFormatSymbols();
		dfs3.setDecimalSeparator('.');

		df3.applyPattern("#");
		df3.setDecimalFormatSymbols(dfs3);
		df3.setGroupingSize(0);
	}

	public static String formatDbValue(String measure)
	{
		String value="";
		try
		{
			/*
				* Check the indexOf "e", For avoid Exponent or Scientific Notation in a String, 
				Because of Address and other String field changed like double data type value
				when we use Double.parseDouble, Its wrong, So put this fix.

				* The real double value not affected because of this change. its shown as per db..

				* changed by Saravanan.A on 31-1-2012.
			*/

			/*
				* Double parsing have problem when double value range exceed, So used BigDecimal instead of Double parsing.

				* changed by Saravanan.A on 15-2-2012.
			*/

			String measure_lower=null;
			if(measure!=null && measure.length()>0)
				measure_lower=measure.toLowerCase().trim();
			
			if(measure_lower!=null && measure_lower.indexOf("e")>-1)
			{
				try
				{
					BigDecimal bigDecRef = new BigDecimal(measure);
					value=df2.format(bigDecRef);
				}
				catch(Exception eee)
				{
					value=measure;
				}
			}
			else
			{
				//double val=Double.parseDouble(measure);
				//value = df.format(val);

				BigDecimal bigDecRef = new BigDecimal(measure);
				value = df.format(bigDecRef);
				double xxx=bigDecRef.doubleValue();
				if(xxx>=100.0)
				{
					value = df3.format(bigDecRef);
				}
				else if(xxx>=1 && xxx<100)
				{
					value = df.format(bigDecRef);
				}
				else
				{
					value=df2.format(bigDecRef);
				}

			}
		}catch(Exception e)
		{
			value=measure;
		}
		return value;
	}

%>
<%!
	public void writeLog(String content,boolean isDebugEnabledField,int logFileSizeField)
	{
		if(isDebugEnabledField)
		{
			boolean append = true;
				try
				{
					String path = EgInstallInfo.getInstallDir()+ "/manager/logs/userExpDashBoard.txt";
					File f = new File(path); 
					if(f.exists())
					{
						int size = new FileInputStream(f).available();
						if(size>(1024*1024*logFileSizeField))
						{
							append = false;
							content = "";
						}
					}
					PrintWriter pw = new PrintWriter(new FileWriter(path,append));
					pw.write(new java.util.Date()+" endUserDashboardDataPrint.jsp "+content);
					pw.write("\n");
					pw.flush();
					pw.close();
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
		}
	}

	public static String getConvertDays(String Value,EgDashBoardModel egDashboard)
	{
		String dateDiff="";
		String currentValue=Value;
		try
		{
			if(currentValue!=null && !currentValue.trim().equals(""))
			{
				long minutes=0;
				float seconds=0.0f;
				if(currentValue!=null && currentValue.indexOf(".")>0)
				{
					minutes=Long.parseLong(currentValue.substring(0,currentValue.indexOf(".")));
					if(currentValue.substring(currentValue.indexOf(".")+1).length()>2)
					{
						seconds=Float.parseFloat(currentValue.substring(currentValue.indexOf("."),currentValue.indexOf(".")+3));
					}
					else
					{
						seconds=Float.parseFloat(currentValue.substring(currentValue.indexOf(".")));
					}
				}
				else
				{
					minutes=Long.parseLong(currentValue);
				}
				long valueInSecond=(minutes*60)+(long)(seconds*60);
				dateDiff=egDashboard.getDateDifferenceStringforUptime(valueInSecond);
			}
			else
			{
				dateDiff=currentValue;
			}
		}
		catch(Exception eeew)
		{
			dateDiff=currentValue;
		}

		if(dateDiff!=null && dateDiff.indexOf("M")!=-1 && dateDiff.indexOf("S")!=-1)
		{
			try
			{
				dateDiff=dateDiff.substring(0,dateDiff.indexOf("M")+4);
			}
			catch(Throwable ee)
			{
				ee.printStackTrace();
				dateDiff=dateDiff;
			}
		}

		return dateDiff;
	}
	//------- Time Out Check -------
	public boolean isTimeoutCheck(String compName,String tmp_keyTest,String msmtHost,String compValue,String info_to_lower)
	{
		Hashtable lastMsmtTime =  (Hashtable)EgLastMeasureThread.lastMsmtTime;
		MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
		MeasuresDAO tmpMeasuresDao = monitorDaoFactory.getMeasuresDAO();

		//lastMsmtTime for Test
		String measureLastKey = compName+":"+tmp_keyTest+":"+msmtHost;
		String infoML = "";
		String msmtTimeML = "";
		boolean MlFinds = false;
		boolean isTimeout = true;
		
		if(info_to_lower.indexOf("+")<0)
		{
			info_to_lower = "+"+info_to_lower;
		}
		
		if(lastMsmtTime != null && lastMsmtTime.containsKey(measureLastKey))
		{
			ArrayList infoLastMsmtList = (ArrayList) lastMsmtTime.get(measureLastKey);
			if(infoLastMsmtList != null && infoLastMsmtList.size() > 0)
			{
				for(int k=0;k<infoLastMsmtList.size();k=k+2)
				{
					infoML = (String)infoLastMsmtList.get(k);
					msmtTimeML = (String)infoLastMsmtList.get(k+1);
					if(info_to_lower.equals(infoML) || infoML.startsWith(info_to_lower))
					{
						MlFinds = true;
						break;
					}
				}
			}
		}

		String db_str_msmt_time = "";
		SimpleDateFormat currForm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat outForm = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
		
		try
		{
			 db_str_msmt_time = outForm.format(currForm.parse(msmtTimeML));
		}
		catch(Exception e)
		{
			MlFinds = false;
		}

		if(MlFinds)
		{
			isTimeout = tmpMeasuresDao.isTimeOut(db_str_msmt_time,tmp_keyTest+"#"+msmtHost,compName,compValue);
		}

		return isTimeout;
	}

	public String removeSkipMetrics(String measuresOrg, String measuresToSkipTmp)
	{
		String measures="";
		try
		{
			ArrayList measures_t_list=new ArrayList();
			if(measuresToSkipTmp!=null && measuresToSkipTmp.trim().length()>0)
			{
				measures_t_list = StringUtils.egTokenizer(measuresToSkipTmp,",",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
			}

			if(measures_t_list!=null && measures_t_list.size()>0)
			{
				boolean commaNeeded=false;
				String temp="";
				StringTokenizer values = new StringTokenizer(measuresOrg,",");
				while(values.hasMoreTokens())
				{
					String value = values.nextToken();
					if(value!=null && !value.equals(""))
					{
						if(!measures_t_list.contains(value))
						{
							temp += commaNeeded?","+value:value;
							commaNeeded = true;
						}
					}
				}

				if(temp!=null && temp.length()>0)
				{
					measures = temp;
				}
				else
					measures = measuresOrg;
			}
			else
			{
				measures = measuresOrg;
			}
		}
		catch(Throwable eee)
		{
			eee.printStackTrace();
			measures = measuresOrg;
		}

		return measures;
	}

	public String getMeasureForUI(String measuresD, String measuresT)
	{
		String measures="";
		try
		{
			ArrayList measures_t_list=new ArrayList();
			if(measuresT!=null && measuresT.trim().length()>0)
			{
				measures_t_list = StringUtils.egTokenizer(measuresT,",",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
			}

			if(measures_t_list!=null && measures_t_list.size()>0)
			{
				boolean commaNeeded=false;
				String temp="";
				StringTokenizer values = new StringTokenizer(measuresD,",");
				while(values.hasMoreTokens())
				{
					String value = values.nextToken();
					if(value!=null && !value.equals(""))
					{
						StringTokenizer valTokens = new StringTokenizer(value,":");
						int count = valTokens.countTokens();
						if(count==3)
						{
							String tempTestMeasure = "";
							tempTestMeasure = value.substring(0,value.lastIndexOf(":"));
							String tempDisplayName = value.substring(value.lastIndexOf(":")+1);
							String tempTestMeasureDisp = tempTestMeasure+":"+tempDisplayName.trim();
							
							//if(!tempTestMeasure.equalsIgnoreCase(testMeasure))
							if(measures_t_list.contains(tempTestMeasureDisp))
							{
								temp += commaNeeded?","+tempTestMeasureDisp:tempTestMeasureDisp;
								commaNeeded = true;
							}
						}
						else
						{
							temp+= commaNeeded?","+value:value;
							commaNeeded = true;
						}
					}
				}

				if(temp!=null && temp.length()>0)
				{
					measures = temp;
				}
				else
					measures = measuresD;
			}
			else
			{
				measures = measuresD;
			}
		}
		catch(Throwable eee)
		{
			eee.printStackTrace();
			measures = measuresD;
		}

		return measures;
	}
	public String getInfoForTests(String userType,String testName,String comptype,String compname, String Port,String info,Vector getDescs, Hashtable testDetails,IniFile ini, ArrayList infoBaseTestList)
	{
		String infoVar=info;
		if(infoBaseTestList!=null && testName!=null && infoBaseTestList.contains(testName))
		{
			if(testDetails!=null && testDetails.size()>0)
			{
				ArrayList testData = (ArrayList)testDetails.get(testName);
				if(testData!=null && testData.size()>=3)
				{
					String toAppendInfo = ini.getValue("UED_INFO_BASED_TESTS",userType+"_"+testName);

					if(toAppendInfo!=null && toAppendInfo.trim().length()>0)
					{
						toAppendInfo=toAppendInfo.trim();
						if(testData.contains(infoVar+toAppendInfo))
						{
							infoVar = infoVar+toAppendInfo;
						}
						else
						{
							if(!getDescs.contains(infoVar))
							{
								for(int z=0;z<getDescs.size();z++)
								{
									String infodesc = (String)getDescs.get(z);
									if(infodesc.startsWith(infoVar))
									{
										infoVar=infodesc;
										break;
									}
								}
							}
						}
					}
					else
					{
						if(testName.equalsIgnoreCase("VmgSystemTest") || testName.equalsIgnoreCase("VmgSystemDemoTest"))
						{
							if(testData.contains(infoVar+":Summary"))
							{
								infoVar = infoVar+":Summary";
							}
							else
							{
								if(!getDescs.contains(infoVar))
								{
									for(int z=0;z<getDescs.size();z++)
									{
										String infodesc = (String)getDescs.get(z);
										if(infodesc.startsWith(infoVar))
										{
											infoVar=infodesc;
											break;
										}
									}
								}
							}
						}
						else if(testName.equalsIgnoreCase("VmgDiskSpaceTest"))
						{
							if(testData.contains(infoVar+":Total"))
							{
								infoVar = infoVar+":Total";
							}
							else
							{
								if(!getDescs.contains(infoVar))
								{
									for(int z=0;z<getDescs.size();z++)
									{
										String infodesc = (String)getDescs.get(z);
										if(infodesc.startsWith(infoVar))
										{
											infoVar=infodesc;
											break;
										}
									}
								}
							}
						}
						else if(testName.equalsIgnoreCase("VmgDiskActivityTest") || testName.equalsIgnoreCase("VmgDiskActDemoTest"))
						{
							if(!getDescs.contains(infoVar))
							{
								for(int z=0;z<getDescs.size();z++)
								{
									String infodesc = (String)getDescs.get(z);
									if(infodesc.startsWith(infoVar))
									{
										infoVar=infodesc;
										break;
									}
								}
							}
						}
						else if(testName.equalsIgnoreCase("VmgWinNetTrafficTest"))
						{
							if(!getDescs.contains(infoVar))
							{
								for(int z=0;z<getDescs.size();z++)
								{
									String infodesc = (String)getDescs.get(z);
									if(infodesc.startsWith(infoVar))
									{
										infoVar=infodesc;
										break;
									}
								}
							}
						}
						else if(testName.equalsIgnoreCase("VmgBrowsActTest"))
						{
							if(!getDescs.contains(infoVar))
							{
								for(int z=0;z<getDescs.size();z++)
								{
									String infodesc = (String)getDescs.get(z);
									if(infodesc.startsWith(infoVar))
									{
										infoVar=infodesc;
										break;
									}
								}
							}
						}
						else if(getDescs!=null && getDescs.size()>0)
						{
							if(!getDescs.contains(infoVar))
							{
								for(int z=0;z<getDescs.size();z++)
								{
									String infodesc = (String)getDescs.get(z);
									if(infodesc.startsWith(infoVar))
									{
										infoVar=infodesc;
										break;
									}
								}
							}
						}
					}
				}
			}
		}
		return infoVar;
	}
	public String getValueForDouble(String Value, ArrayList decimalFormatTestMeasureList,ArrayList  convertToDaysTestMeasureList, String keyTest,String keyOrgMeasure, EgDashBoardModel  egDashboard)
	{
		String result_Val="";
		String orgValue="0.0";
		try
		{
			if(Value!=null && Value.trim().length()>0 && Value.indexOf(".")>-1 && Double.parseDouble(Value)>0)
			{
				orgValue=Value;
				//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
				if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
				{
					Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
				}
				else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
				{
					Value = getConvertDays(Value,egDashboard);
				}
				else
				{
					Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
				}
				Value=String.valueOf(Value);
			}
			else if(Value!=null && Value.trim().length()>0  && Double.parseDouble(Value)>0)
			{
				orgValue=Value;
				//Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
				if(decimalFormatTestMeasureList!=null && decimalFormatTestMeasureList.size()>0 && decimalFormatTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
				{
					Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),4));
				}
				else if(convertToDaysTestMeasureList!=null && convertToDaysTestMeasureList.size()>0 && convertToDaysTestMeasureList.contains(keyTest+":"+keyOrgMeasure))
				{
					Value = getConvertDays(Value,egDashboard);
				}
				else
				{
					Value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(Value),2));
				}
				Value=String.valueOf(Value);
			}
		}
		catch(Exception ee)
		{
			if(Value==null || Value.equalsIgnoreCase("unknown"))
				Value = "-";

			Value=Value;
			orgValue=Value;
		}
		result_Val=Value+"~$~"+orgValue;

		return result_Val;
	}

	public String[] getMeasuresArray(ArrayList tmpValidColsList)
	{
		String[] tmpMeasureArray =null;
		if(tmpValidColsList!=null && tmpValidColsList.size()>0)
		{
			tmpMeasureArray = new String[tmpValidColsList.size()];
			int yy=0;
			for(int y=0;y<tmpValidColsList.size();y++)
			{
				String tempValue1 = (String)tmpValidColsList.get(y);
				if(tempValue1!=null && tempValue1.trim().length()>0)
				{
					tmpMeasureArray[yy++]=tempValue1;
				}
			}
		}

		return tmpMeasureArray;
	}

	public ArrayList getTokenList(String inputStr,String sep)
	{
		ArrayList tmpList = new ArrayList();
		if(inputStr!=null && inputStr.trim().length()>0)
		{
			tmpList = com.egurkha.util.StringUtils.egTokenizer(inputStr,sep,false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
		}

		return tmpList;
	}

	public String getMsmtHost(EgTablesInfo tablesInfo1,EgExternalInfo egExternalInfo1,String ctype_layer1,String tempCompType,String tempCompNameWithOutPort2)
	{
		String outputMsmtHost=null;
		try
		{
			ArrayList listOfTest=(ArrayList)tablesInfo1.getTestsForLayer(ctype_layer1,tempCompType);
			if(listOfTest!=null && listOfTest.size()>0)
			{
				boolean flag=true;
				for (int t=0;t<listOfTest.size();t++)
				{
					String insideviewTest=(String) listOfTest.get(t);
					if(insideviewTest!=null && insideviewTest.trim().length()>0)
					{
						List tempAgents=egExternalInfo1.getAgentsFor(insideviewTest.trim(),tempCompType,tempCompNameWithOutPort2);

						if(tempAgents!=null && tempAgents.size()>0)
						{
							outputMsmtHost=(String)tempAgents.get(0);
							flag=false;
							break;
						}
					}
				}

				if(flag)
					outputMsmtHost=tempCompNameWithOutPort2;
			}
			else
				outputMsmtHost=tempCompNameWithOutPort2;
		}
		catch(Exception ee)
		{
			outputMsmtHost=tempCompNameWithOutPort2;
			ee.printStackTrace();
		}

		if(outputMsmtHost==null || outputMsmtHost.trim().length()==0)
			outputMsmtHost=tempCompNameWithOutPort2;

		return outputMsmtHost;
	}

	public String getRelavantOrderByColumnNames(ArrayList metricsList,String columnDispName,EgDbInfo Dbdata)
	{
		String tmpOrderByColumnName=null;
		StringBuffer orderByColumnNameSb = new StringBuffer();
		if(metricsList != null && metricsList.size()>0)
		{
			int val_count = 0;
			for(int i=0;i<metricsList.size();i++)
			{
				String met = (String)metricsList.get(i);
				if(met == null || met.trim().length() == 0)
					continue;
				ArrayList check = com.egurkha.util.StringUtils.egTokenizer(met, ":", true,false,true);
				if(check != null)
				{
					int sizeCheck=check.size();
					if(sizeCheck==3 || sizeCheck==5)
					{
						String tempTest = "";
						String tempMeasure = "";
						String tempDispName = "";
						String tempLocColName = "";
						String meas = "";
						String colName = "";

						if(sizeCheck==3)
						{
							tempTest =  (String)check.get(0);
							tempMeasure =  (String)check.get(1);
							tempDispName =  (String)check.get(2);
						}
						else if(sizeCheck==5)
						{
							tempTest = (String)check.get(0);
							tempMeasure = (String)check.get(1);
							colName = (String)check.get(2);
							meas = (String)check.get(3);
							tempDispName = (String)check.get(4);
						}

						if(tempDispName!=null && tempDispName.equalsIgnoreCase(columnDispName))
						{
							if(sizeCheck==3)
							{
								String neworderByColumn = Dbdata.getColumnForMeasure(tempTest,tempMeasure); 
								if(neworderByColumn==null || neworderByColumn.trim().length()==0)
									neworderByColumn = tempMeasure;

								orderByColumnNameSb.append(","+neworderByColumn);
							}
							else if(sizeCheck==5)
							{
								String neworderByColumn = Dbdata.getColumnForMeasure(tempTest+"_DDD",colName); 
								if(neworderByColumn==null || neworderByColumn.trim().length()==0)
									neworderByColumn = colName;

								orderByColumnNameSb.append(","+neworderByColumn);
							}
						}
					}
				}
			}
		}

		if(orderByColumnNameSb!=null)
			tmpOrderByColumnName = orderByColumnNameSb.toString();
	
		if(tmpOrderByColumnName!=null && tmpOrderByColumnName.startsWith(","))
			tmpOrderByColumnName = tmpOrderByColumnName.substring(1);

		return tmpOrderByColumnName;
	}

	public Hashtable getFilterTypeDetails(User user,String detail,String filterBy,Hashtable filterInfoHash)
	{
		if(detail != null && detail.equalsIgnoreCase("componentType"))
		{
			if(filterBy !=null && filterBy.equalsIgnoreCase("Virtual_Machine"))
			{
				ArrayList allNickForVms = new ArrayList();
				ArrayList allNickForVmComp = new ArrayList();
				List temp_listComps = user.getOnlyVMServers();
				if(temp_listComps!=null && temp_listComps.size()>0)
				{
					for(int l=0;l<temp_listComps.size();l++)
					{
						String compDetails = (String)temp_listComps.get(l);
						allNickForVmComp.add(compDetails);
					}

					filterInfoHash.put("allNickForVMComp",allNickForVmComp);
					//filterInfoHash.put("allNickForVMList",allNickForVms);
				}
			}
			else if(filterBy !=null && !filterBy.equalsIgnoreCase("All"))
			{
				ArrayList allNickForComp = new ArrayList();
				List temp_listComps = user.getServers(false);
				for(int l=0;l<temp_listComps.size();l++)
				{
					String compDetails = (String)temp_listComps.get(l);
					if(compDetails.indexOf(filterBy) != -1)
						allNickForComp.add(compDetails);

				}
				filterInfoHash.put("allNickForComp",allNickForComp);
			}
		}

		return filterInfoHash;
	}

	public ArrayList getNotZoneList(List temp_listZone,EgGroupInfo groupInfo)
	{
		ArrayList notZoneList2 = new ArrayList();
		if(temp_listZone != null && temp_listZone.size() > 0){
			for(int l=0;l<temp_listZone.size();l++){
				String zone1 = (String) temp_listZone.get(l);
				List temp_zoneComps = groupInfo.getAllComponentsUnderZone(zone1,true);
				if(temp_zoneComps != null && temp_zoneComps.size() > 0){
					for(int p=0;p<temp_zoneComps.size();p++){
						String compType = (String)temp_zoneComps.get(p);
						notZoneList2.add(compType);
					}
				}
			}
		}

		return notZoneList2;
	}
	public String getMeasureValue(Hashtable measureValues,String test,String measure,String info,String compNameWithOutPort,String compTenantName,Hashtable commonMeasureValues)
	{
		String value=(String)measureValues.get(test+"^"+measure+"^"+info+"^"+compNameWithOutPort);

		if(value==null || value.trim().length()==0)
			value=(String)measureValues.get(test+"^"+measure+"^"+info.toLowerCase()+"^"+compNameWithOutPort);

		if(value==null || value.trim().length()==0)
			value=(String)measureValues.get(measure+"^"+info+"^"+compNameWithOutPort);

		if(value==null || value.trim().length()==0)
			value=(String)measureValues.get(measure+"^"+info.toLowerCase()+"^"+compNameWithOutPort);

		//---start common comp----
		if(commonMeasureValues!=null && commonMeasureValues.size()>0)
		{
			if(value==null || value.trim().length()==0)
				value=(String)commonMeasureValues.get(test+"^"+measure+"^"+info+"^eGCommon");

			if(value==null || value.trim().length()==0)
				value=(String)commonMeasureValues.get(test+"^"+measure+"^"+info.toLowerCase()+"^eGCommon");

			if(value==null || value.trim().length()==0)
				value=(String)commonMeasureValues.get(measure+"^"+info+"^eGCommon");

			if(value==null || value.trim().length()==0)
				value=(String)commonMeasureValues.get(measure+"^"+info.toLowerCase()+"^eGCommon");

			if(value==null || value.trim().length()==0)
				value=(String)commonMeasureValues.get(test+"^"+measure+"^"+info+"^"+compTenantName+"_eGCommon");

			if(value==null || value.trim().length()==0)
				value=(String)commonMeasureValues.get(test+"^"+measure+"^"+info.toLowerCase()+"^"+compTenantName+"_eGCommon");

			if(value==null || value.trim().length()==0)
				value=(String)commonMeasureValues.get(measure+"^"+info+"^"+compTenantName+"_eGCommon");

			if(value==null || value.trim().length()==0)
				value=(String)commonMeasureValues.get(measure+"^"+info.toLowerCase()+"^"+compTenantName+"_eGCommon");
		}
		//---end commmon comp----

		return value;
	}

	public String getManagerTimeToUserTimeConvertion(IniFile egFormat, EgTimeZoneConverter convert, User user, String testName, String measureName, String orgValue)
	{
		String value = orgValue;
		
		try
		{		
			String dateColumn ="";			
			if(measureName!=null && measureName.trim().length()>0)			
				dateColumn=(String)egFormat.getValue("Convert_ManagerTime_To_UserTime",testName+":"+measureName);	
			
			if(dateColumn!=null && dateColumn.trim().length()>0 && orgValue!=null && orgValue.indexOf(" ")>-1)
			{						
				String date = orgValue.substring(0,orgValue.indexOf(" ")).trim();
				String time = orgValue.substring(orgValue.indexOf(" ")).trim();						

				if(user != null)
				{
					String userFormat = user.getUserDateFormat();											
					date = DateUtil.changeDateFormat(date,dateColumn,userFormat);									
					convert = new EgTimeZoneConverter(date+" "+time,user);										
					date = convert.getDate(false)+" "+convert.getHour()+":"+convert.getMinute()+":"+convert.getSecond();		
					value = date;																	
				}
			}
		}
		catch(Exception e)
		{
			return value;
		}
		return value;
	}

	public ArrayList getUniqueUserList(EgList vdiDesktopsList)
	{
		ArrayList tmpList = new ArrayList();
		HashSet uniqueUserSet=new HashSet();
		if(vdiDesktopsList!=null)
		{
			for(int i=0;i<vdiDesktopsList.size();i++)
			{
				EgService serv = (EgService)vdiDesktopsList.get(i);
				String desktopComponent = serv.getName();
				String desktopState = serv.getState().getName();

				String desktopName = "";
				String info="";
				String comp = "";
				
				if(desktopComponent!=null && desktopComponent.indexOf("^")>-1)
				{
					desktopName = desktopComponent.substring(0,desktopComponent.lastIndexOf("^"));
					info = desktopName;
					comp = desktopComponent.substring(desktopComponent.lastIndexOf("^")+1);
				}

				if(info.indexOf("\\") > -1 && info.indexOf("_on_") > -1 && info.indexOf("\\") < info.indexOf("_on_"))
				{
					ArrayList user_and_desktop =  com.egurkha.util.StringUtils.egTokenizer(info, "_on_",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim

					if(user_and_desktop!=null && user_and_desktop.size()>0)
					{
						String only_user=(String)user_and_desktop.get(0);
						if(only_user!=null && only_user.trim().length()>0)
							uniqueUserSet.add(only_user);
					}
				}
				else
					uniqueUserSet.add(info);
			}
			if(uniqueUserSet!=null && uniqueUserSet.size()>0)
				tmpList.addAll(uniqueUserSet);
		}
		return tmpList;
	}
	public String getLabel(String name, String value)
	{
		return "<td><span style=\"float:left\" class=\"formLabel\">"+name+"</span><span style=\"float:left;width:10px\" align=\"center\" >:</span><span style=\"float:left;\" class=\"formValue\">"+value+"</span></td>";
	}

	public String HideDisabledTest(String measure, String userType , User user, EgSpecsInfo specsInfo ,IniFile ini,boolean isDetailsFromADOnly,boolean isShowUserLocation)
	{
		String tem_measures= measure;
		String result_measure= "";
		try
		{

			List test_comps = user.getServerTypes();
			List vmTypeList = user.getOnlyVMTypes();
			List vmServersList = user.getOnlyVMServers(false);
			String userTypeStr=ini.getValue("USER_TYPE_COMPONENTS",userType);
			ArrayList userTypeList = new ArrayList();
			if(userTypeStr!=null && userTypeStr.trim().length()>0)
				userTypeList = (ArrayList)getTokenList(userTypeStr,",");
			else
				 return tem_measures;
			
			ArrayList measure_List = new ArrayList();
			ArrayList tmp_measure_List = new ArrayList();
			
			if(measure!=null && measure.trim().length()>0)
				measure_List = (ArrayList)getTokenList(measure,",");
			else
				 return tem_measures;

			String selectedComp ="";
			if(test_comps!=null && test_comps.size()>0)
			{
				for(int c=0;c<measure_List.size();c++)
				{
					String meas = (String)measure_List.get(c);
					String meas_test = meas.substring(0,meas.indexOf(":"));

					boolean isAddMea=false;

					for(int b=0;b<test_comps.size();b++)
					{
						String compTypr= (String) test_comps.get(b);
						if(compTypr!=null && userTypeList.contains(compTypr))
						{
							if(specsInfo.isTestRelevantForServer(compTypr,meas_test))
							{
								isAddMea=true;
							}
							else if(isDetailsFromADOnly && isShowUserLocation && meas_test.equals("GeoDetails"))
							{
								isAddMea=true;
							}
						}

						if(isAddMea)
							break;
					}

					if(isAddMea)
					{
						if(!tmp_measure_List.contains(meas))
						{
							tmp_measure_List.add(meas);
							result_measure+=meas+",";
						}
					}
				}

				/*for(int b=0;b<test_comps.size();b++)
				{
					String compTypr= (String) test_comps.get(b);
					if(userTypeList.contains(compTypr))
					{
						selectedComp = (String) test_comps.get(b);
						if(selectedComp!= null && selectedComp.trim().length()>0)
						{
							for(int c=0;c<measure_List.size();c++)
							{
								String meas = (String)measure_List.get(c);
								String meas_test = meas.substring(0,meas.indexOf(":"));
								if(specsInfo.isTestRelevantForServer(selectedComp,meas_test))
								{
									if(!tmp_measure_List.contains(meas))
									{
										tmp_measure_List.add(meas);
										result_measure+=meas+",";
									}
								}
								else if(isDetailsFromADOnly && isShowUserLocation && meas_test.equals("GeoDetails"))
								{
									if(!tmp_measure_List.contains(meas))
									{
										tmp_measure_List.add(meas);
										result_measure+=meas+",";
									}
								}
							}
						}
					}
				}*/

				if(tmp_measure_List!=null && tmp_measure_List.size()==0 && (user.isOnlyVMAssigned() || user.isVMAssigned()) && user.getOnlyVMs().size()>0 && vmTypeList!=null && vmTypeList.size()>0)
				{
					for(int b=0;b<vmTypeList.size();b++)
					{
						String compTypr= (String) vmTypeList.get(b);
						if(userTypeList.contains(compTypr))
						{
							selectedComp = (String) vmTypeList.get(b);
							if(selectedComp!= null && selectedComp.trim().length()>0)
							{
								for(int c=0;c<measure_List.size();c++)
								{
									String meas = (String)measure_List.get(c);
									String meas_test = meas.substring(0,meas.indexOf(":"));
									if(specsInfo.isTestRelevantForServer(selectedComp,meas_test))
									{
										if(!tmp_measure_List.contains(meas))
										{
											tmp_measure_List.add(meas);
											result_measure+=meas+",";
										}
									}
									else if(isDetailsFromADOnly && isShowUserLocation && meas_test.equals("GeoDetails"))
									{
										if(!tmp_measure_List.contains(meas))
										{
											tmp_measure_List.add(meas);
											result_measure+=meas+",";
										}
									}
								}
							}
						}
					}
				}
			}
			else
				return tem_measures;

			if(result_measure.trim().length()>0 && result_measure.endsWith(","))
				result_measure = result_measure.substring(0,result_measure.lastIndexOf(","));
		}
		catch(Exception eeb)
		{
			eeb.printStackTrace();
			return tem_measures;
		}
		return result_measure;
	}

	public String HideDisabledTest2(String measure, String userType , User user, EgSpecsInfo specsInfo ,IniFile ini,boolean isDetailsFromADOnly,boolean isShowUserLocation)
	{
		String tem_measures= measure;
		String result_measure= "";
		try
		{
			List test_comps = user.getServerTypes();
			List vmTypeList = user.getOnlyVMTypes();
			List vmServersList = user.getOnlyVMServers(false);
			String userTypeStr=ini.getValue("USER_TYPE_COMPONENTS",userType);
			ArrayList userTypeList = new ArrayList();
			if(userTypeStr!=null && userTypeStr.trim().length()>0)
				userTypeList = (ArrayList)getTokenList(userTypeStr,",");
			else
				 return tem_measures;
			
			ArrayList measure_List = new ArrayList();
			ArrayList tmp_measure_List = new ArrayList();
			
			if(measure!=null && measure.trim().length()>0)
				measure_List = (ArrayList)getTokenList(measure,",");
			else
				 return tem_measures;

			String selectedComp ="";
			if(test_comps!=null && test_comps.size()>0)
			{
				for(int b=0;b<userTypeList.size();b++)
				{
					String compTypr = (String) userTypeList.get(b);
					if(test_comps.contains(compTypr))
					{
						for(int c=0;c<measure_List.size();c++)
						{
							String meas = (String)measure_List.get(c);
							String meas_test = meas.substring(0,meas.indexOf(":"));
							if(specsInfo.isTestRelevantForServer(compTypr,meas_test))
							{
								if(!tmp_measure_List.contains(meas))
								{
									tmp_measure_List.add(meas);
									result_measure+=meas+",";
								}
							}
							else if(isDetailsFromADOnly && isShowUserLocation && meas_test.equals("GeoDetails"))
							{
								if(!tmp_measure_List.contains(meas))
								{
									tmp_measure_List.add(meas);
									result_measure+=meas+",";
								}
							}
						}
					}
				}
				if(tmp_measure_List!=null && tmp_measure_List.size()==0 && (user.isOnlyVMAssigned() || user.isVMAssigned()) && user.getOnlyVMs().size()>0 && vmTypeList!=null && vmTypeList.size()>0)
				{
					for(int b=0;b<vmTypeList.size();b++)
					{
						String compTypr= (String) vmTypeList.get(b);
						if(userTypeList.contains(compTypr))
						{
							selectedComp = (String) vmTypeList.get(b);
							if(selectedComp!= null && selectedComp.trim().length()>0)
							{
								for(int c=0;c<measure_List.size();c++)
								{
									String meas = (String)measure_List.get(c);
									String meas_test = meas.substring(0,meas.indexOf(":"));
									if(specsInfo.isTestRelevantForServer(selectedComp,meas_test))
									{
										if(!tmp_measure_List.contains(meas))
										{
											tmp_measure_List.add(meas);
											result_measure+=meas+",";
										}
									}
									else if(isDetailsFromADOnly && isShowUserLocation && meas_test.equals("GeoDetails"))
									{
										if(!tmp_measure_List.contains(meas))
										{
											tmp_measure_List.add(meas);
											result_measure+=meas+",";
										}
									}
								}
							}
						}
					}
				}
			}
			else
				return tem_measures;

			if(result_measure.trim().length()>0 && result_measure.endsWith(","))
				result_measure = result_measure.substring(0,result_measure.lastIndexOf(","));
		}
		catch(Exception eeb)
		{
			eeb.printStackTrace();
			return tem_measures;
		}
		return result_measure;
	}
	/*public ArrayList getUniqueUserList(EgList vdiDesktopsList)
	{
		ArrayList tmpList = new ArrayList();
		HashSet uniqueUserSet=new HashSet();
		if(vdiDesktopsList!=null)
		{
			for(int i=0;i<vdiDesktopsList.size();i++)
			{
				EgService serv = (EgService)vdiDesktopsList.get(i);
				String desktopComponent = serv.getName();
				String desktopState = serv.getState().getName();

				String desktopName = "";
				String info="";
				String comp = "";
				
				if(desktopComponent!=null && desktopComponent.indexOf("^")>-1)
				{
					desktopName = desktopComponent.substring(0,desktopComponent.lastIndexOf("^"));
					info = desktopName;
					comp = desktopComponent.substring(desktopComponent.lastIndexOf("^")+1);
				}

				if(info.indexOf("\\") > -1 && info.indexOf("_on_") > -1 && info.indexOf("\\") < info.indexOf("_on_"))
				{
					ArrayList user_and_desktop =  com.egurkha.util.StringUtils.egTokenizer(info, "_on_",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim

					if(user_and_desktop!=null && user_and_desktop.size()>0)
					{
						String only_user=(String)user_and_desktop.get(0);
						if(only_user!=null && only_user.trim().length()>0)
							uniqueUserSet.add(only_user);
					}
				}
				else
					uniqueUserSet.add(info);
			}
			if(uniqueUserSet!=null && uniqueUserSet.size()>0)
				tmpList.addAll(uniqueUserSet);
		}
		return tmpList;
	}*/

	public Hashtable titleFormation(String userType)
	{
		Hashtable tmpTitleHash=new Hashtable();
		String header_display="";
		String header_display_icon="";
		String countHeader="";
		if(userType.equals("ESX"))
		{
			//header_display = "VM Resource Consumption for "+compTypeDisp+" : "+s_compName;
			header_display = "VM Resource Consumption for ";
			header_display_icon = "iconComponent";
			countHeader = "Total VMs";
		}
		else if(userType.equals("VDI"))
		{
			//header_display = "Desktop Resource Consumption for "+compTypeDisp+" : "+s_compName;
			header_display = "Users/Desktops Resource Consumption ";
			header_display_icon = "iconDesktop";
			countHeader = "Unique Users/Desktops";
		}
		else
		{
			//header_display = "User Resource Consumption for "+compTypeDisp+" : "+s_compName;
			header_display = "User Resource Consumption ";
			header_display_icon = "descriptor_user";
			countHeader = "Unique Users";
		}

		tmpTitleHash.put("header_display",header_display);
		tmpTitleHash.put("header_display_icon",header_display_icon);
		tmpTitleHash.put("countHeader",countHeader);

		return tmpTitleHash;
	}


	public String HideDisabledTest_old(String measure, String userType , User user, EgSpecsInfo specsInfo ,IniFile ini,boolean isDetailsFromADOnly,boolean isShowUserLocation)
	{
		String tem_measures= measure;
		String result_measure= "";
		try
		{
			List test_comps = user.getServerTypes();
			List vmTypeList = user.getOnlyVMTypes();
			List vmServersList = user.getOnlyVMServers(false);
			String userTypeStr=ini.getValue("USER_TYPE_COMPONENTS",userType);
			ArrayList userTypeList = new ArrayList();
			if(userTypeStr!=null && userTypeStr.trim().length()>0)
				userTypeList = (ArrayList)getTokenList(userTypeStr,",");
			else
				 return tem_measures;
			
			ArrayList measure_List = new ArrayList();
			ArrayList tmp_measure_List = new ArrayList();
			
			if(measure!=null && measure.trim().length()>0)
				measure_List = (ArrayList)getTokenList(measure,",");
			else
				 return tem_measures;

			String selectedComp ="";
			if(test_comps!=null && test_comps.size()>0)
			{
				for(int b=0;b<test_comps.size();b++)
				{
					String compTypr= (String) test_comps.get(b);
					if(userTypeList.contains(compTypr))
					{
						selectedComp = (String) test_comps.get(b);
						if(selectedComp!= null && selectedComp.trim().length()>0)
						{
							for(int c=0;c<measure_List.size();c++)
							{
								String meas = (String)measure_List.get(c);
								String meas_test = meas.substring(0,meas.indexOf(":"));
								if(specsInfo.isTestRelevantForServer(selectedComp,meas_test))
								{
									if(!tmp_measure_List.contains(meas))
									{
										tmp_measure_List.add(meas);
										result_measure+=meas+",";
									}
								}
								else if(isDetailsFromADOnly && isShowUserLocation && meas_test.equals("GeoDetails"))
								{
									if(!tmp_measure_List.contains(meas))
									{
										tmp_measure_List.add(meas);
										result_measure+=meas+",";
									}
								}
							}
						}
					}
				}
				if(tmp_measure_List!=null && tmp_measure_List.size()==0 && (user.isOnlyVMAssigned() || user.isVMAssigned()) && user.getOnlyVMs().size()>0 && vmTypeList!=null && vmTypeList.size()>0)
				{
					for(int b=0;b<vmTypeList.size();b++)
					{
						String compTypr= (String) vmTypeList.get(b);
						if(userTypeList.contains(compTypr))
						{
							selectedComp = (String) vmTypeList.get(b);
							if(selectedComp!= null && selectedComp.trim().length()>0)
							{
								for(int c=0;c<measure_List.size();c++)
								{
									String meas = (String)measure_List.get(c);
									String meas_test = meas.substring(0,meas.indexOf(":"));
									if(specsInfo.isTestRelevantForServer(selectedComp,meas_test))
									{
										if(!tmp_measure_List.contains(meas))
										{
											tmp_measure_List.add(meas);
											result_measure+=meas+",";
										}
									}
									else if(isDetailsFromADOnly && isShowUserLocation && meas_test.equals("GeoDetails"))
									{
										if(!tmp_measure_List.contains(meas))
										{
											tmp_measure_List.add(meas);
											result_measure+=meas+",";
										}
									}
								}
							}
						}
					}
				}
			}
			else
				return tem_measures;

			if(result_measure.trim().length()>0 && result_measure.endsWith(","))
				result_measure = result_measure.substring(0,result_measure.lastIndexOf(","));
		}
		catch(Exception eeb)
		{
			eeb.printStackTrace();
			return tem_measures;
		}
		return result_measure;
	}
	public ArrayList getFilterlist(String tmp_metrics)
	{
		ArrayList filterList = new ArrayList();
		ArrayList tmp_metricsList = new ArrayList();
		if(tmp_metrics != null && tmp_metrics.trim().length() > 0)
		{
			tmp_metricsList = com.egurkha.util.StringUtils.egTokenizer(tmp_metrics, ",", true,false,true);
			if(tmp_metricsList != null && tmp_metricsList.size() > 0)
			{
				for(int i=0;i<tmp_metricsList.size();i++){
					String met = (String)tmp_metricsList.get(i);
					if(met == null || met.trim().length() == 0)
						continue;

					ArrayList check = com.egurkha.util.StringUtils.egTokenizer(met, ":", true,false,true);
					if(check != null && check.size() ==2){
						String geoCheck = (String)check.get(0);
						String geoCheckValue = (String)check.get(1);

						if(geoCheck != null && geoCheck.trim().length()  > 0)
						{
							if(geoCheck.equalsIgnoreCase("GeoDetails") )
							{
								ArrayList valList = com.egurkha.util.StringUtils.egTokenizer(geoCheckValue, "~$~", true,false,true);

								if(valList != null && valList.size() ==2){
									filterList.add((String)valList.get(0));
								}
							}
						}
					}
				}
			}
		}
		return filterList;
	}
	public String getSearchByText(String userType ,EgMappingInfo mappingInfo)
	{
		String searchByText ="";

		if(userType!=null && userType.equalsIgnoreCase("VDI"))
		searchByText = mappingInfo.getTextDescription("monitor.VirtualDashboard.Users/Desktops");
		else if(userType!=null && userType.equalsIgnoreCase("ESX"))
			searchByText = mappingInfo.getTextDescription("monitor.VirtualDashboard.VMs");
		else if(userType!=null && userType.equalsIgnoreCase("DWINVD"))
			searchByText = mappingInfo.getTextDescription("monitor.VirtualDashboard.Desktops");
		else if(userType!=null && userType.equalsIgnoreCase("AppXenApp7") || userType.equalsIgnoreCase("AppDDXenApp7") || userType.equals("OverviewAppXenApp7") || userType.equals("OverviewAppVDI"))
				searchByText = mappingInfo.getTextDescription("monitor.VirtualDashboard.Applications");
		else
			searchByText = mappingInfo.getTextDescription("monitor.VirtualDashboard.Users");

		return searchByText;
	}
	public String getMultiCompNameText(String compCombo)
	{
		String compNameDisp ="";
		if(compCombo!=null && compCombo.trim().length()>0)
		{
			ArrayList compComboList = StringUtils.egTokenizer(compCombo,",",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
			for(int b=0;b<compComboList.size();b++)
			{
				String multiComp = (String)compComboList.get(b);
				if(multiComp.indexOf(":")!=-1)
					multiComp = multiComp.substring(compCombo.indexOf(":")+1);
				if(multiComp!=null && multiComp.endsWith(":NULL"))
					multiComp = multiComp.substring(0,multiComp.indexOf(":NULL"));
				if(b>0)
					compNameDisp = compNameDisp +","+multiComp;
				else
					compNameDisp = multiComp;
			}
			if(compNameDisp.endsWith(","))
				compNameDisp = compNameDisp.substring(0,compNameDisp.indexOf(","));
		}
		return compNameDisp;
	}

	public ArrayList getConvertionTestMeasureUnitList(IniFile dashIni)
	{
		ArrayList testWithMeasureNameList = new ArrayList();
		try
		{
			String[] testWithMeasure = dashIni.getVariables("Convert_To_MB_GB_TB");

			for(int i=0;i<testWithMeasure.length;i++)
			{
				testWithMeasureNameList.add(testWithMeasure[i]);
			}
		}
		catch (Exception er)
		{
		}
		return testWithMeasureNameList;
	}

	public String getConvertedValue(EgTablesInfo tablesInfo,EgDbInfo dbInfo,IniFile dashboardConfigIni,String test,String messy,String value)
	{
		String orgVal = value;
		String org_unit = tablesInfo.getUnitForMeasure(test,messy);
		String pair = test+":"+messy;
		String convert_unit=dashboardConfigIni.getValue("Convert_To_MB_GB_TB",pair);
		if(convert_unit!=null && !convert_unit.trim().equals("") && convert_unit.length()> 0 && org_unit != null && (!org_unit.equalsIgnoreCase(convert_unit)))
		{
			String measValue="";
			double mod_Val=0;
			String convert_val="";
			try
			{
				double currentValue=Double.parseDouble(value);
				if(org_unit.equalsIgnoreCase("KBPS"))
				{
					if(convert_unit.equalsIgnoreCase("TBPS"))
					{
						mod_Val= currentValue/(1000.0*1000.0*1000.0);
						convert_val=String.valueOf(mod_Val);
					}
					else if(convert_unit.equalsIgnoreCase("GBPS"))
					{
						mod_Val= currentValue/(1000.0*1000.0);
						convert_val=String.valueOf(mod_Val);
					}
					else if(convert_unit.equalsIgnoreCase("MBPS"))
					{
						mod_Val= currentValue/1000.0;
						convert_val=String.valueOf(mod_Val);
					}
					else
					{
						mod_Val= currentValue;
						convert_val=String.valueOf(mod_Val);
					}
				}
				else if(org_unit.equalsIgnoreCase("KB"))
				{
					if(convert_unit.equalsIgnoreCase("TB"))
					{
						mod_Val= currentValue/(1024.0*1024.0*1024.0);
						convert_val=String.valueOf(mod_Val);
					}
					else if(convert_unit.equalsIgnoreCase("GB"))
					{
						mod_Val= currentValue/(1024.0*1024.0);
						convert_val=String.valueOf(mod_Val);
					}
					else if(convert_unit.equalsIgnoreCase("MB"))
					{
						mod_Val= currentValue/1024.0;
						convert_val=String.valueOf(mod_Val);
					}
					else
					{
						mod_Val= currentValue;
						convert_val=String.valueOf(mod_Val);
					}
				}
				else if(org_unit.equalsIgnoreCase("MB"))
				{
					if(convert_unit.equalsIgnoreCase("TB"))
					{
						mod_Val= currentValue/(1024.0*1024.0);
						convert_val=String.valueOf(mod_Val);
					}
					else if(convert_unit.equalsIgnoreCase("GB"))
					{
						mod_Val= currentValue/(1024.0);
						convert_val=String.valueOf(mod_Val);
					}
					else
					{
						mod_Val= currentValue;
						convert_val=String.valueOf(mod_Val);
					}
				}
				else if(org_unit.equalsIgnoreCase("GB"))
				{
					if(convert_unit.equalsIgnoreCase("TB"))
					{
						mod_Val= currentValue/(1024.0);
						convert_val=String.valueOf(mod_Val);
					}
					else
					{
						mod_Val= currentValue;
						convert_val=String.valueOf(mod_Val);
					}
				}
				else
					convert_val = value;

			}
			catch(Exception e)
			{
				convert_val = value;
			}
			measValue=dbInfo.formatValue(convert_val);
			orgVal = measValue;
		}
		return orgVal;
	}
%>

