<%
/*****************************************************************************************************
 *	Name			:	EgVmwareLiveGraphHome.jsp
 *	Version			:	eG 4.0
 *	Purpose			:	To View the comparison graph for Vmware_esx_server and Vmware_vdi_server
 *	Creation Date	:	10-05-2007.
  *****************************************************************************************************/
%>
<%@ include file="EgTracker.jsp" %>
<%@ page errorPage="EgError.jsp"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "java.util.Date"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "java.util.Calendar"%>
<%@ page import = "java.util.TimeZone"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ taglib prefix="egui" uri="../../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	UserRegistry ur = UserRegistry.getInstance();
	User user = ur.getUser(session.getId());
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String mgrIP = specsInfo.getEGServer();
	String comptype=null;
	String compName=null;
	if(request.getParameter("comptype")!=null)
		comptype=request.getParameter("comptype");
	if(request.getParameter("er_component")!=null)
		compName=request.getParameter("er_component");

	IniFile egUI = null;
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	egUI = new IniFile(s_iniFile_dir + uiFile);

	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	int currYear = 0;
	Calendar cal = Calendar.getInstance();
	currYear = cal.get(cal.YEAR);

	EgDateInfo egDate = new EgDateInfo();
    	Date local_date = new Date(egDate.egetUTCDate());
    	cal.setTime(local_date);
    	cal.setTimeZone(egDate.getRealTimeZone());
    	String temp1 = (cal.get(cal.MONTH)+1) + "/" + cal.get(cal.DAY_OF_MONTH) + "/" +cal.get(cal.YEAR);
	String temp2 = cal.get(cal.HOUR_OF_DAY)+":"+cal.get(cal.MINUTE)+":"+cal.get(cal.SECOND);
    	String dispDate = DateUtil.changeDateFormat(temp1,"MM/dd/yyyy",currentDateFormat);
    	TimeZone tz = egDate.getRealTimeZone();
	String tzName = tz.getDisplayName(tz.inDaylightTime(local_date), TimeZone.SHORT);

	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dispDate+" "+temp2,user);
	//String loginUserDateTime = (String)timeZoneConverter.getDate(false);

	String loginUserDateTime = (String)timeZoneConverter.getDateTime();
	String loginUserDate = (String)timeZoneConverter.getDate(false);
	boolean isFusionChartValue=HighChartTimeline.isFusion();
	long refreshFrequency = 10000L;
	if (user!=null)
	{
		String refFrequency = user.getRefreshFrequency();
		if(refFrequency!=null && refFrequency.length()>0)
		{
			refreshFrequency =  Long.valueOf(refFrequency).longValue() * 1000L;
		}
	}

	IniFile reportIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_report.ini");
	
	String strYaxisBasedOnData = reportIni.getValue("CHART_TYPE","YaxisBasedOnData");
	boolean isYaxisBasedOnData=false;
	if(strYaxisBasedOnData!=null && (strYaxisBasedOnData.equalsIgnoreCase("yes") || strYaxisBasedOnData.equalsIgnoreCase("true")))
		isYaxisBasedOnData = true;

%>
<html>
<head>
	
	<meta name="format-detection" content="telephone=no"/>
	<title> eG LiveGraph v<%=EgInstallInfo.version%> &nbsp; - &nbsp; [ <%=user.getLoginID()%> : <%=mgrIP%> ] &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
	<meta name="Author" content="Vijay & Jaiwin"/>
	<script>
		var vlheader='<egui:intnl text="monitor.livegraph.VIRTUAL METRICS"/>';
		var timeZoneOffsetVal='<%=timezoneOffsetValue%>';
		var isFusionChartValue=<%=isFusionChartValue%>;
		var strSkin='<%=monitor_Skin%>';
		var csrfToken = '<%=strCsrfToken%>';
		var isYaxisBasedOnData=<%=isYaxisBasedOnData%>;
	</script>
	<egui:skin ui="monitor"/>

	<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="VLiveGraph" appFile="app.js"/>


	<!--<link rel="stylesheet" type="text/css" href="/final/monitor/eg_styles/liveGraph.css" />
	 <link rel="stylesheet" type="text/css" href="/final/extjs/css/CheckHeader.css" />
	<link rel="stylesheet" type="text/css" href="/final/extjs/css/ItemSelector.css" /> -->

	<script type="text/javascript" src ="/final/jquery/jquery.js"></script>

	<script language="javascript" type="text/javascript" src="/final/styles/jscrollpane/mwheelIntent.js"></script>
	<script language="javascript" type="text/javascript" src="/final/monitor/eg_scripts/jsrsClient.js"></script>
	<script src="/final/scripts/eg_DateUtil.js"></script>

	<!--<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>-->
	<script language="javascript" src="/final/monitor/eg_scripts/ajaxutils.js" type="text/javascript"></script>
	<script language="javascript" src="/final/monitor/eg_scripts/eg_validate.js"></script>
	<script src="/final/monitor/eg_scripts/eg_date.js"></script>

	<script language="javascript" type="text/javascript" src="/final/Highcharts/js/highstock.js"></script>
	<!-- <script language="javascript" type="text/javascript" src="/final/monitor/eg_scripts/EgHighChart.js"></script> -->
	<script language="javascript" type="text/javascript" src="/final/scripts/utilities/EgCommonHighChart.js"></script>
	
	<script src="/final/scripts/utilities/ScrollableTreePanel.js"></script>
	<script src="/final/scripts/utilities/ScrollPanel.js"></script>
	<!-- <script src="/final/scripts/utilities/ScrollableUtils.js"></script> -->
	<script src="/final/scripts/utilities/ZoomGraphPanel.js"></script>

	<script language="javascript1.3">

		function parseScript(_source)
		{
			var source = _source;
			var scripts = new Array();
			
			// Strip out tags
			while(source.indexOf("<script") > -1 || source.indexOf("</script") > -1) {

				var s = source.indexOf("<script");
				var s_e = source.indexOf(">", s);
				var e = source.indexOf("</script", s);
				var e_e = source.indexOf(">", e);
				// Add to scripts array
				scripts.push(source.substring(s_e+1, e));
				// Strip from source
				source = source.substring(0, s) + source.substring(e_e+1);
			}
			// Loop through every script collected and eval it
			for(var i=0; i<scripts.length; i++) {
				try {
					eval(scripts[i]);
				}
				catch(ex) {
					return;
				}
			}
			// Return the cleaned source
			return source;
		}
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				parseScript(errorStr);
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
			});
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		});

		var refreshRate = 0;
		refreshRate = parseInt('<%=refreshFrequency%>');
		var vlhelp='<egui:intnl text="monitor.livegraph.Help"/>';
		var vlclose='<egui:intnl text="monitor.livegraph.Close"/>';
		var vlzoomheader='<egui:intnl text="monitor.livegraph.Virtual Zoom Graph"/>';

		var ndf='<egui:intnl text="monitor.measure.No data found"/>';
		var defaultVLUrl='/final/monitor/livegraph/EgVmwareLiveGraphDisplay.jsp?comptype=<%=comptype%>&er_component=<%=EgURLEncoder.encode(compName,"UTF-8")%>';
		//var defaultVLUrl='/final/monitor/livegraph/main.htm';
		var isVirtualLV=true;
		var remoteURL="/final/servlet/com.eg.EgMonRemoteScriptingServlet";
		var timelineEncodedURL='<%=response.encodeURL("/final/monitor/egDashBoardTimeline.jsp?")%>';

		var main_commonUrl=null;
		var main_gType=null;

		var mgr_dateFormat= getExtjsDateFormat('<%=tracker_currentDateFormat%>');
		var mgr_disp_dateFormat= '<%=tracker_currentDateFormat%>';
		var mgr_curr_dateFormat= '<%=tracker_currentDateFormat%>';
		var currentDateFormat_js= '<%=currentDateFormat%>';
		var help_text='<egui:intnl text="monitor.livegraph.Help"/>';

		var MONTH_NAMES_JS=new Array('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
		var MONTH_INT_JS=new Array('0','1','2','3','4','5','6','7','8','9','10','11');
		function getMonthValue(mon_text)
		{
			var index_mon=-1;
			try
			{
				index_mon = MONTH_NAMES_JS.indexOf(mon_text);
			}
			catch (e)
			{
				if(index_mon==null || index_mon>0)
				{
					index_mon = MONTH_INT_JS.indexOf(mon_text); 
				}
			}

			try
			{
				if(index_mon==null || index_mon>0)
				{
					index_mon = MONTH_INT_JS.indexOf(mon_text); 
				}
			}
			catch(ee)
			{}
			
			return index_mon;
		}

		var startOfTimerDate = '<%=loginUserDateTime%>';
		var s_yr = <%=timeZoneConverter.getYear(true)%>;
		var s_mon = getMonthValue('<%=timeZoneConverter.getMonth()%>');
		var s_day = '<%=timeZoneConverter.getDay()%>';
		var s_hr = <%=timeZoneConverter.getHour()%>;
		var s_min = <%=timeZoneConverter.getMinute()%>;
		var s_sec = <%=timeZoneConverter.getSecond()%>;
		var eday = new Date(s_yr,s_mon,s_day,s_hr,s_min,s_sec);
		function egClock()
		{
			timediff = eday.getUTCMilliseconds();
			timediff = timediff + 1003;
			eday.setUTCMilliseconds(timediff);
			hourNow = eday.getHours();
			mnNow = eday.getMinutes();
			scNow = eday.getSeconds();
			miNow = eday.getTime();
			monNow = (eday.getMonth()+1);
			dayNow = eday.getDate();
			if(monNow <= 9)
			{
				mon = "0" + monNow;
			}
			else
			{
				mon = monNow;
			}
			if(dayNow <= 9)
			{
				day = "0" + dayNow;
			}
			else
			{
				day = dayNow;
			}
			if(hourNow <= 9)
			{
				hour = "0" + hourNow;
			}
			else
			{
				hour = hourNow;
			}
			if(mnNow <= 9)
			{
				min = "0" + mnNow;
			}
			else
			{
				min = mnNow;
			}
			if (scNow <= 9)
			{
				secs = "0" + scNow;
			}
			else
			{
				secs = scNow;
			}
			var display_date_time  = '<%=loginUserDate%>' +  " " + hour + ":" + min + ":" + secs ;
			return display_date_time;
		}


		documentView ={
			getObject: function()
			{
				if(typeof( window.innerWidth) == 'number')
				{//Firefox
					this.height = window.innerHeight;
					this.width = window.innerWidth;
					this.fireFox = true;
				}
				else if( document.documentElement && ( document.documentElement.clientWidth
					|| document.documentElement.clientHeight ))
				{//IE 6 + in 'standards compliant mode'
					this.height = document.documentElement.clientHeight;
					this.width = document.documentElement.clientWidth;
					this.ie = true;
				}
				else if(document.body && document.body.clientHeight)
				{ //IE 4 compatible
					this.height = document.body.clientHeight;
					this.width = document.body.clientWidth;
					this.ie = true;
				}
				return this;
			},
			getHeight: function()
			{
				return this.getObject().height;
			},
			getWidth: function()
			{
				return this.getObject().width;
			},
			isIE: function()
			{
				return this.getObject().ie;
			},
			isFireFox: function()
			{
				return this.getObject().fireFox;
			}
		};
		
	</script>
</head>

<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" bgcolor="#ffffff" ID="space6"  style="overflow:hidden" scroll="no"><%=dispDate%>
</body>
</html>

<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>