<%@ include file = "EgLoginTracker.jsp"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import= "com.egurkha.User"%>
<%@ page import= "com.egurkha.UserRegistry"%>
<%@ page import= "java.util.ArrayList"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="net.sf.json.*"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	
	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);

	JSONObject option = new JSONObject();
	JSONObject optionData = new JSONObject();
	JSONObject optionDataValue = new JSONObject();
	JSONArray optionValues = new JSONArray();
	JSONArray monitorSetData = new JSONArray();
	JSONArray monitorData = new JSONArray();
	
	String refreshTime = u_ser.getRefreshFrequency();
	int refresh_Time=60000;//default time if time is null
	if(refreshTime!=null && refreshTime !="")
	{
		refresh_Time=Integer.parseInt(refreshTime);
		refresh_Time=refresh_Time*1000;
	}
	int currYear = 0;
	Calendar cal = Calendar.getInstance();
	currYear = cal.get(cal.YEAR);

	String comp_type=request.getParameter("comptype");
	String Monitorset_value = request.getParameter("Monitorset_value");
	comp_type=(comp_type==null || comp_type.trim().length()==0)?"SAP_R3_server":comp_type;
	ArrayList al=new ArrayList();
	String component=null;

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	
	try
	{
		al=user.getServersForType(comp_type);//get component for the server type
	}
	catch(Throwable edd)
	{
		edd.printStackTrace();
	}

	if(al!=null && al.size()>0)
	{
		option.put("displayField",mappingInfo.getTextDescription("monitor.SAP.Please choose a component"));
		option.put("valueField","-1");

		optionValues.add(option);
		for(int i=0;i<al.size();i++)
		{
			option = new JSONObject();
			String cmp=(String)al.get(i);
			int index=cmp.indexOf(":");
			component=cmp.substring(index+1);
			String display_comp_name=component;
			
			if (component.endsWith(EgConstants.NULL_PORT) && (component.indexOf(EgConstants.NULL_PORT) > -1))
			{
				display_comp_name = Server.getServerNameWithoutPort(component, false);
			}

			if(component!=null && display_comp_name!=null)
			{
				option.put("displayField",display_comp_name);
				option.put("valueField",display_comp_name);
			}
			optionValues.add(option);
		}
	}
	else
	{
		option.put("displayField",mappingInfo.getTextDescription("monitor.SAP.No Components"));
		option.put("valueField","-1");

		optionValues.add(option);

		optionData.put("displayField",mappingInfo.getTextDescription("monitor.SAP.No Monitor Set"));
		optionData.put("valueField",-1);
		monitorSetData.add(optionData);

		optionDataValue.put("displayField",mappingInfo.getTextDescription("monitor.SAP.No Monitors "));
		optionDataValue.put("valueField",-1);
		monitorData.add(optionDataValue);
	}
%>

<!DOCTYPE html>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1"/>
<title><egui:intnl text='monitor.SAP.EgSAPMETRIC'/></title>

<script>
	var mgrDateFormat = " ";
</script>

<egui:skin ui="monitor"/>
<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="SAPMetric" appFile="app.js"/>
<script type="text/javascript" src="/final/monitor/eg_scripts/yahoo.js" ></script>
<script type="text/javascript" src="/final/monitor/eg_scripts/event.js"></script>
<script type="text/javascript" src="/final/monitor/eg_scripts/treeview.js" ></script>
<script type="text/javascript" src="/final/monitor/eg_scripts/jktreeview.js" ></script>
<script src="/final/scripts/eg_DateUtil.js" type='text/javascript'></script>



<!-- fancy Scroll-->
<script src="/final/jquery/jquery.js"></script>
<script src="/final/styles/jscrollpane/jquery.jscrollpane.min.js" ></script>
<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>

<script>
	mgrDateFormat=getExtjsDateFormat('<%=currentDateFormat%>');
	var componentsListObject = Ext.decode('<%=optionValues.toString()%>');
	var monitorSetListData = Ext.decode('<%=monitorSetData.toString()%>');
	var monitorSetListValues = Ext.decode('<%=monitorData.toString()%>');
	var defaultComp = '<%=mappingInfo.getTextDescription("monitor.SAP.Please choose a component")%>';

	var componentLabel="<egui:intnl text='monitor.SAP.Component'/>";
	var monitorSetValue="<egui:intnl text='monitor.SAP.Monitor Sets'/>";
	var monitorsValue="<egui:intnl text='monitor.SAP.Monitors'/>";
	var submitButton="<egui:intnl text='monitor.SAP.Submit'/>";
	var treePanelLabel="<egui:intnl text='monitor.SAP.Tree Panel'/>";
	var csrfToken = '<%=strCsrfToken%>';

	function parseScript(_source)
	{
		var source = _source;
		var scripts = new Array();
		
		// Strip out tags
		while(source.indexOf("<script") > -1 || source.indexOf("</script") > -1) {

			var s = source.indexOf("<script");
			var s_e = source.indexOf(">", s);
			var e = source.indexOf("</script", s);
			var e_e = source.indexOf(">", e);
			
			// Add to scripts array
			scripts.push(source.substring(s_e+1, e));
			// Strip from source
			source = source.substring(0, s) + source.substring(e_e+1);
		}

		// Loop through every script collected and eval it
		for(var i=0; i<scripts.length; i++) {
			try {
				eval(scripts[i]);
			}
			catch(ex) {
				alert('<egui:intnl text="monitor.SAP.Error Occured in Tree Forming "/>');
				alert(ex);
				return;
			}
		}
		
		// Return the cleaned source
		
		return source;
	}

	Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				parseScript(errorStr);
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
			});
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		});
</script>


</head>
<body class="content-frame">
</body>
</html>