<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.eg.*"%>
<%@ page import="java.text.*"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
try
{

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox2 = ( ua != null && ua.indexOf( "Firefox2/" ) != -1 );
	boolean isFirefox3 = ( ua != null && ua.indexOf( "Firefox3/" ) != -1 );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox3/" ) != -1 );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
	boolean isIE6=( ua != null && ua.indexOf("MSIE 6.0") != -1 );
	boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );

	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");

	IniUI iniUI = IniUI.getInstance();
	String currentDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");

	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	DateTimeTokenizer dtd = new DateTimeTokenizer();

	EgServerDashboardModel  egDashboard=new  EgServerDashboardModel();
	EgServerDashboardMGraphModel measureGraph=new EgServerDashboardMGraphModel();

	EgFusionChartUtil fusionChart=new EgFusionChartUtil();
	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();
	MeasuresDAO MeasuresDao = monitorDaoFactory.getMeasuresDAO();
	

	ErUtils erutils=new ErUtils();

	SimpleDateFormat sf=new SimpleDateFormat("MM/dd/yyyy");
	SimpleDateFormat sf1=new SimpleDateFormat("dd/MM/yyyy HH:mm");
	SimpleDateFormat testTableDateFmt=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	String UseCutOffFactor=iniObj.getValue("Dashboard_Settings","UseCutOffFactor");
	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String subsystem=request.getParameter("subsystem");
	String tab=request.getParameter("tab");
	String selectedInfo=request.getParameter("selectedInfo");
	String graphType=request.getParameter("graphType");
	String site=request.getParameter("site");
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}

	String subject=compType;
	String hostName="";
	String portNo="";
	String sid="";
	String msmtHost="";
	String measure="";

	String startTime="";
	String endTime="";
	String startHour="";
	String endHour="";
	String startMin="";
	String endMin="";
	Hashtable  list = null;
	String lastmsmtTime = "";
	int lastmsmtTimeIndex =0;
	Hashtable measureLastData = dashboardDAO.getMeasureLast();

	Vector healthChartAttributes=new Vector();
	healthChartAttributes.add("palette='2'");
	healthChartAttributes.add("decimals='2'");
	healthChartAttributes.add("enableRotation='1'");
	healthChartAttributes.add("bgColor='99CCFF,FFFFFF'");
	healthChartAttributes.add("bgAlpha='0,0'");
	healthChartAttributes.add("bgRatio='0,100'");
	healthChartAttributes.add("bgAngle='360'");
	healthChartAttributes.add("showBorder='0'");
	healthChartAttributes.add("startingAngle='80'");
	healthChartAttributes.add("chartLeftMargin ='0'");
	healthChartAttributes.add("chartTopMargin ='0'");
	healthChartAttributes.add("chartBottomMargin ='0'");
	healthChartAttributes.add("chartRightMargin ='0'");
	//healthChartAttributes.add("showToolTipShadow ='1'");
	healthChartAttributes.add("pieSliceDepth='7'");
	healthChartAttributes.add("numberSuffix=''");
	healthChartAttributes.add("showToolTipShadow ='1'");
	healthChartAttributes.add("pieOuterFaceAlpha  ='75'");
	healthChartAttributes.add("pieInnerFaceAlpha  ='100'");
	healthChartAttributes.add("pieYScale  ='60'");
	healthChartAttributes.add("smartLineColor  ='000000'");
	healthChartAttributes.add("smartLabelClearance  ='2'");
	healthChartAttributes.add("captionPadding  ='0'");
	healthChartAttributes.add("bgSWFAlpha  ='0'");
	healthChartAttributes.add("enableSmartLabels='1'");
	healthChartAttributes.add("pieRadius='34'");
	healthChartAttributes.add("labelDistance='6'");
	healthChartAttributes.add("isSmartLineSlanted='1'");
	healthChartAttributes.add("exportEnabled='0'");
	healthChartAttributes.add("exportAction='download'");
	healthChartAttributes.add("exportAtClient='0'");
	healthChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

	if(tab==null)
		tab="Application";

	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	String cnameDAO = compName;
	if(compType.equalsIgnoreCase("Oracle_server") && compName.indexOf(":")!=compName.lastIndexOf(":"))
	{
		cnameDAO = compName.substring(0,compName.lastIndexOf(":"));
	}

	list =(Hashtable) measureLastData.get(cnameDAO);

	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	Vector runingTestList=egDashboard.getRunningTest(compName,compType,tab);
	String defaultMGraphDuration=iniObj.getValue("Default_MeasureGraph_Duration","duration");

	Vector times=egDashboard.getStartEndDateTimeForMeasure(defaultMGraphDuration);

	if(times!=null && times.size()>=4)
	{
		startTime=(String)times.get(0);
		endTime=(String)times.get(1);
		startHour=(String)times.get(2);
		endHour=(String)times.get(3);
	}
	EgDateInfo edi = new EgDateInfo();
	SimpleDateFormat testDateFormat= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	SimpleDateFormat timeOutDateFormat= new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
	SimpleDateFormat timeFormat= new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
	Date tempDate = edi.egetRealDate();
	java.util.Date endDate =  edi.egetRealDate();
	long vSDate = endDate.getTime()-(60*60*1000);
	String vStrDate  = edi.egetDate(vSDate);
	java.util.Date tmp_date = timeFormat.parse(vStrDate);
	vStrDate = timeOutDateFormat.format(tmp_date);
	java.util.Date startDate= edi.egetDateUS(vStrDate);

	String isThresholdNeed=iniObj.getValue("Dashboard_Settings","ApplyThreshold");

	if(subsystem!=null && subsystem.equalsIgnoreCase("Tablespaces"))
	{
		String testName="OraTablespacesTest";
		if(runingTestList!=null && runingTestList.contains(testName)) 
		{
			Vector measures=new Vector();
			String measuresForDB="";
			Vector infos=(Vector)allTestInfos.get(testName);
			Collections.sort(infos,String.CASE_INSENSITIVE_ORDER);
			boolean isDatabasesAvailable=(infos!=null && !infos.isEmpty());
		
			if(isDatabasesAvailable && (selectedInfo==null || selectedInfo.equalsIgnoreCase("null") || selectedInfo.equals("") || selectedInfo.equalsIgnoreCase("undefined")))
			{
				selectedInfo=(String)infos.get(0);
				selectedInfo=com.egurkha.util.StringUtils.replace(selectedInfo,"+","");
			}
			else if(selectedInfo!=null && !selectedInfo.equals(""))
			{
				selectedInfo=selectedInfo.trim();
			}
			String testMeasures =iniObj.getValue(subject,tab+"_"+subsystem);
			Vector allMeasures=egDashboard.getTokensAsVector(testMeasures,",");

			if(graphType == null || graphType.trim().equals(""))
			{
				graphType="oracletablespaces";
			}
			if((graphType!=null && graphType.equalsIgnoreCase("oracletablespaces")) && isDatabasesAvailable)
			{
%>

<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%" class="eg_cellbglits1">
	<tr>
		<td id="treeViewTd"  width="180" align="left" valign="top" style="padding-top:8px;padding-left:8px;padding-right:0px;padding-bottom:0px;" border="0" class="eg_cellbglits1">
			<table width="180" cellpadding="0" cellspacing="0" border="0">
				<tr>
					<td>
						<div id="citrixUserDiv" style="height:300px;width:178;border:0px solid #ff0000;background-color:transparent">
							<table width="100%" cellspacing="0" cellpadding="0" border="0">
								<tr>
									<td class="whiteTopLeft eg_blankspace" width="8"> <img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"> </td>
									<td class="eg_whitebg eg_blankspace" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
									<td width="8" class="whiteTopRight eg_blankspace"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
								</tr>
							</table>
						
							<div id="citrixUserDivInner" class="eg_whitebg div_scroll" style="height:300px;width:178;border:0px solid green;">
								<div class="dtree">
									<div id="dd0" class="clip" style="border: 0px solid rgb(255, 0, 0);">
										<div class="dTreeNode" style="font-size: 7.5pt; color: rgb(0, 0, 0);" oncontextmenu="return false;">
											<img src="/final/monitor/eg_images/icon_oracle_tablespace.png" alt="" border="0"/>
											<span><b><egui:intnl text='monitor.dashboard.OracleTablespaces'/></b></span>
										</div>
<%
				int totalInfoCount=infos.size();
				for(int i=0;i<totalInfoCount;i++)
				{
					String info=(String)infos.get(i);
					info = com.egurkha.util.StringUtils.replace(info,"+","");
					boolean isSelectedTablespaces=false;

					if(info!=null && selectedInfo.equalsIgnoreCase(info))
						isSelectedTablespaces=true;
%>
										<div id="dd1" class="dtree" style="border: 0px solid rgb(255, 0, 0); display: block;">
											<div class="dTreeNode" style="font-size: 7.5pt; color: rgb(0, 0, 0);" oncontextmenu="return false;">
<%
					if(i==infos.size()-1)
					{
%>
												<img src="/final/admin/eg_images/tree/joinbottom.gif" alt="">
<%
					}
					else
					{
%>
												<img src="/final/admin/eg_images/tree/join.gif" alt="">
<%
					}
%>
												<img id="id2"src="/final/monitor/eg_images/icon_oracle_tablespace.png" alt="" border="0">
												<span><a class="mouse <%=(isSelectedTablespaces)?"nodeSel":"eg_monlink"%>" onclick="javascript:changeGraphType1('Tablespaces','<%=tab%>','<%=graphType%>','true','','','<%=info%>')"> <%=com.egurkha.util.StringUtils.replace(info,"+","")%></a></span>
											</div>
										</div>
<%
				}
%>
									</div>
								</div>
							</div>
							<table width="100%" cellspacing="0" cellpadding="0" border="0">
								<tr>
									<td class="whiteBottLeft" width="8"	><img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"></td>
									<td class="eg_whitebg" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
									<td width="8" class="whiteBottRight"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
								</tr>
							</table>
						</div>
					</td>
				</tr>
			</table>
		</td>

		<td style="width:6px;padding:0px;" id="hide" class="eg_cellbglits1">
			<div style="width:6px">
				<table border="0" cellspacing="0" cellpadding="0" style="width:6px">
					<tr>
						<td style="width:6px;padding:0px" class="eg_blankspace" id="expandTd"> <a href="javascript:void(0);" onclick="javascript:closeOracleTreeWindow()"><img id="expand" src="/final/monitor/eg_images/<%=monitor_Skin%>/split_left.gif" width="7" height="50" border="0"/></a> </td>
					</tr>
				</table>
			</div>
		</td>

		<td height="100%"  valign="top" class="eg_cellbglits1" style="padding-top:8px;padding-left:0px;padding-right:8px;padding-bottom:0px;">
			<div id="ctxUserRightDiv" style="width:754;height:300px;border:0px solid #ff0000;">
				<table width="100%" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td class="whiteTopLeft" width="8"><img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"></td>
						<td class="eg_whitebg" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
						<td width="8" class="whiteTopRight"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
					</tr>
				</table>

				<div class="div_scroll eg_whitebg" id="ctxUserRightDivInner" align="center" valign="top" style="margin:0px;padding:0px;width:754px;height:300px;border:0px solid blue">
					<table width="100%" cellpadding="6" cellspacing="0" border="0" align="center">
						<tr>
							<td valign="top"  height="100%">
								<table border="0" cellspacing="0" cellpadding="2" width="100%"  height="100%">
									<tr>
										<td  class="eg_75bold gradient_header" height="20" align="center"><egui:intnl text="monitor.dashboard.Tablespaces"/>-<%=com.egurkha.util.StringUtils.replace(selectedInfo,"+","")%></td>
									</tr>
									<tr>
										<td class="vmborder" style="padding:0px" align="center">
											<table border="0" cellspacing="0" cellpadding="0" width="100%"  height="100%" >
												<tr>
													<td width="100%" align="center" valign="top">
<%
				String currentMeasureValue="";
				String tempTestMeasure="";
				String test="";
				testMeasures=iniObj.getValue(subject,"Application_Tablespaces_Overview_DialGraphs");
				Vector allMeasuresandTestObj=egDashboard.getTokensAsVector(testMeasures,",");
				int tdcount=0;
				double defaultDialGraphWidth=240;  // default dial graph width for calculation
				double defaultDialGraphHeight=150;  // default dial graph height for calculation
				double dialGraphWidth=240;  
				double dialGraphHeight=150;
				double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1000;
				double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
				double defaultGauageOuterRadius=80; // default dial graph width for calculation
				double defaultGaugeXPos=123; // default dial graph Gauge X position for calculation
				double defaultGaugeYPos=106; // default dial graph Gauge Y position for calculation 
				String gauageOuterRadius="75";
				String gaugeXPos="97";
				String gaugeYPos="106";
				String gaugeInnerRadius="45";
				if(screenWidthInDouble>0)
				{
					dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
					dialGraphWidth=MathUtils.round(dialGraphWidth,0);
					dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
					dialGraphHeight=MathUtils.round(dialGraphHeight,0);
					double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
					double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
					gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);
					gaugeInnerRadius=erutils.round((gauageOuterRadiusInDouble-30),0);
					double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
					double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;
					double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
					gaugeXPos=erutils.round(gaugeXPosInDouble,0);
					double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
					gaugeYPos=erutils.round(gaugeYPosInDouble,0);
				}
				for(int i=0;i<allMeasuresandTestObj.size();i++)
				{
					tempTestMeasure=(String)allMeasuresandTestObj.get(i);
					test=tempTestMeasure.substring(0,tempTestMeasure.indexOf(":"));
					measure=tempTestMeasure.substring(tempTestMeasure.indexOf(":")+1);
					msmtHost=(String)allMsmtHosts.get(test);
					String mappedMetricDisplayName=mappingInfo.getMeasureDescription(test,measure);
					String toolTopDisplayStrForMeasure=mappedMetricDisplayName;
					if(mappedMetricDisplayName!=null && mappedMetricDisplayName.length()>18)
						mappedMetricDisplayName=mappedMetricDisplayName.substring(0,15);
					boolean isTestHas_CutOffFactor=false;
					if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
					{
						if(egDashboard.isTestHasCutOffFactor(test))
						{
							if(infos!=null && !infos.isEmpty())
							{
								String info_for_cuttofffactor="+"+selectedInfo;
								boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,info_for_cuttofffactor);
								if(isTestExceededCutOffFactor)
									isTestHas_CutOffFactor=true;
							}				
						}
					}
					Vector chartAttributes=new Vector();
					chartAttributes.add("palette='2'");
					chartAttributes.add("bgColor='FFFFFF'");
					chartAttributes.add("bgAlpha='0'");
					//chartAttributes.add("upperLimit='100'");
					//chartAttributes.add("lowerLimit='0'");
					chartAttributes.add("baseFontColor='333333'");
					chartAttributes.add("majorTMNumber='6'");
					chartAttributes.add("majorTMColor='FFFFFF'");
					chartAttributes.add("majorTMHeight='8'");
					chartAttributes.add("minorTMNumber='6'");
					chartAttributes.add("minorTMColor='FFFFFF'");
					chartAttributes.add("minorTMHeight='3'");
					chartAttributes.add("majorTMThickness='1'");
					chartAttributes.add("markerRadius='30'");
					chartAttributes.add("showGaugeBorder='0'");
					chartAttributes.add("toolTipBgColor='ffffff'");
					chartAttributes.add("toolTipBorderColor='555555'");
					chartAttributes.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
					chartAttributes.add("gaugeInnerRadius='"+gaugeInnerRadius+"'");
					chartAttributes.add("gaugeOriginX='"+gaugeXPos+"'");
					chartAttributes.add("gaugeOriginY='"+gaugeYPos+"'");
					chartAttributes.add("annRenderDelay='1'");
					chartAttributes.add("gaugeFillRatio='3'");
					chartAttributes.add("pivotRadius='6'");
					chartAttributes.add("showPivotBorder='1'");
					chartAttributes.add("pivotBorderColor='000000'");
					chartAttributes.add("pivotBorderThickness='5'");
					chartAttributes.add("pivotFillMix='FFFFFF,000000'");
					chartAttributes.add("pivotFillType='linear'");
					chartAttributes.add("showShadow='0'");
					chartAttributes.add("showBorder='0'");
					chartAttributes.add("baseFontSize='8.75'");
					chartAttributes.add("chartLeftMargin='35'");
					chartAttributes.add("chartRightMargin='35'");
					chartAttributes.add("chartTopMargin='25'");
					chartAttributes.add("chartBottomMargin='25'");
					chartAttributes.add("  gaugeFillMix='{dark-10},{light-70},{dark-10}'  tickValueDistance='10' ");
					chartAttributes.add("clickURL='javascript:dialOnclick(&apos;customizedDial"+tdcount+"&apos;)'"); 
					String xmlForSteeCase=fusionChart.getXMLDataForCustomziedGauge(test,measure,compType,hostName,portNo,sid,"NULL",msmtHost,isThresholdNeed,chartAttributes,"000000",false,"+"+selectedInfo,false,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight);
					
					String layerName=dashboardDAO.getLayerForTest(compType,test,measure);
					String compTypeForAlarm=compType;
					if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
						compTypeForAlarm="Host_system";

					String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-+"+selectedInfo,measure);
					String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-+"+selectedInfo+"&tstate="+measureState+"&msmt_host=";
					if(xmlForSteeCase!=null && !xmlForSteeCase.equals("") && !xmlForSteeCase.equalsIgnoreCase("null") && !isTestHas_CutOffFactor)
					{
%>

														<div style="float:left;border:0px solid blue" >
															<table cellpadding="2" cellspacing="0" border="0" bordercolor="red">
																<tr>
																	<td align="center" valign="top" class="eg_75bold"><span alt="<%=toolTopDisplayStrForMeasure%>" title="<%=toolTopDisplayStrForMeasure%>"><%=mappedMetricDisplayName%>(<%=tablesInfo.getUnitForMeasure(test,measure)%>)</span></td>
																</tr>
																<tr>
																	<td align="center"  style="padding:0px"  valign="top">
																		<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" id="StackedColumn3D" >
																		<param name="movie" value="/final/FusionCharts/swf/AngularGauge.swf" />
																		<param name="FlashVars" value="&dataXML=<%=xmlForSteeCase%>&chartWidth=<%=dialGraphWidth%>&chartHeight=<%=dialGraphHeight%>">
																		<param name="quality" value="high" />
																		<param name="WMode" value="Transparent">

																		<embed wmode="transparent" src="/final/FusionCharts/swf/AngularGauge.swf" flashVars="&dataXML=<%=xmlForSteeCase%>" quality="high" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>"  name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																		</object> -->

																		<div id="customizedDialContainer<%=i%>"  style="height:100%;"></div>
																		<script type="text/javascript">
																			if  ( FusionCharts( "mycustomizedDialChartId<%=i%>" ) )
																					FusionCharts( "mycustomizedDialChartId<%=i%>" ).dispose();
																			var myChart = new FusionCharts( "/final/FusionCharts/swf/AngularGauge.swf","mycustomizedDialChartId<%=i%>", "<%=dialGraphWidth%>", "<%=dialGraphHeight%>","0","1");
																			myChart.setXMLData("<%=xmlForSteeCase%>");
																			myChart.setTransparent(true);
																			myChart.render("customizedDialContainer<%=i%>");
																		</script>

																		<input type="hidden" id="customizedDial<%=tdcount%>" value="<%=layerPageUrl%>"/>
																	</td>
																</tr>
															</table>
														</div>
<%
					}
					else
					{
%>

														<div style="width:205px;height:150px;float:left;">
															<table width="205px" cellpadding="2" cellspacing="0" border="0" bordercolor="red">
																<tr>
																	<td align="center" valign="top" class="eg_75bold"></td>
																</tr>
																<tr>
																	<td align="center" valign="middle" height="100%"><span class="eg_75bold" alt="<%=toolTopDisplayStrForMeasure%>" title="<%=toolTopDisplayStrForMeasure%>"><%=mappedMetricDisplayName%>(<%=tablesInfo.getUnitForMeasure(test,measure)%>)</span><br><br>
																	<img src="/final/monitor/eg_images/gray/exclamation-icon.gif"/><br> 
																	<egui:intnl text="monitor.dashboard.No Measures available"/>
																	</td>
																</tr>
															</table>
														</div>

<%
					}
				}
%>
													</td>
												</tr>
												<tr>
													<td>
<%
				testMeasures=iniObj.getValue(subject,"Application_Tablespaces_Overview_DigitalGraphs");
				Vector allMeasuresandTest=egDashboard.getTokensAsVector(testMeasures,",");
				int digitalChartWidth=100;
				boolean isMeasureAvailable=false;
				for(int i=0;i<allMeasuresandTest.size();i++)
				{
					boolean isTestHas_CutOffFactor=false;
					tempTestMeasure=(String)allMeasuresandTest.get(i);
					test=tempTestMeasure.substring(0,tempTestMeasure.indexOf(":"));
					measure=tempTestMeasure.substring(tempTestMeasure.indexOf(":")+1);
					msmtHost=(String)allMsmtHosts.get(test);						currentMeasureValue=dashboardDAO.getCurrentMeasure(hostName,portNo,sid+"+"+selectedInfo,test,measure,msmtHost);
					double currentMeasValue=Double.parseDouble(currentMeasureValue);
					if(currentMeasValue<0)
					{
						continue;
					}
					if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
					{
						if(egDashboard.isTestHasCutOffFactor(test))
						{
							String info_for_cutofffactor="+"+selectedInfo;
							boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,test,msmtHost,info_for_cutofffactor);
							if(isTestExceededCutOffFactor)
							{
								isTestHas_CutOffFactor=true;
							}
						}
					}
					String mappedMetricDisplayName=mappingInfo.getMeasureDescription(test,measure);
					String toolTopDisplayStrForMeasure=mappedMetricDisplayName;
					if(mappedMetricDisplayName!=null && mappedMetricDisplayName.length()>17)
						mappedMetricDisplayName=mappedMetricDisplayName.substring(0,14)+"...";
					String layerName=dashboardDAO.getLayerForTest(compType,test,measure);
					String compTypeForAlarm=compType;
					if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
						compTypeForAlarm="Host_system";
					currentMeasureValue=erutils.round(currentMeasValue,2);
					String measureState=egDashboard.getTestMeasureState(compName,compTypeForAlarm,layerName,test+"-+"+selectedInfo,measure);
					String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+compName+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+test+"-"+"+"+selectedInfo+"&tstate="+measureState+"&msmt_host=";
					
					currentMeasureValue=erutils.round(currentMeasValue,2);
					isMeasureAvailable=(currentMeasureValue!=null && !currentMeasureValue.trim().equals("") && ((!currentMeasureValue.trim().equals("-5") && !currentMeasureValue.trim().equals("-1") && !testerInfo.getAllowNegativeValues(test,measure)) || (testerInfo.getAllowNegativeValues(test,measure))));
					digitalChartWidth=100;
					if(currentMeasureValue!=null && currentMeasureValue.length()>0)
						digitalChartWidth=(currentMeasureValue.length()>7)?(currentMeasureValue.length()*18):100;
					if(isMeasureAvailable && !isTestHas_CutOffFactor)
					{
%>

														<div style="width:205px;height:150px;float:left;border:0px solid green">
															<table width="205px" cellpadding="2" cellspacing="0" border="0" bordercolor="red" height="100%">
																<tr>
																	<td align="center" valign="top" style="height:20px;padding-bottom:0px" class="eg_75bold" >&nbsp;</td>
																</tr>
																<tr>
																	<td align="center"  style="padding-top:0px" valign="middle" height="100%"><span class="eg_75bold" alt="<%=toolTopDisplayStrForMeasure%>" title="<%=toolTopDisplayStrForMeasure%>"><%=mappedMetricDisplayName%>(<%=tablesInfo.getUnitForMeasure(test,measure)%>)</span><br><br>
																		<a class="eg_monlink" onclick="javascript:goToLayerModel('<%=layerPageUrl%>');" border="0"> <img border="0" src="../servlet/com.egurkha.monitor.egDigitalChart?width=<%=digitalChartWidth%>&height=40&value=<%=currentMeasureValue%>&forecolor=00FF00&background=999999&background1=999999" /> </a>
																	</td>
																</tr>
															</table>
														</div>

<%
					}
					else
					{
%>
														<div style="width:205px;height:150px;float:left;">
															<table width="205px" cellpadding="2" cellspacing="0" border="0" bordercolor="red">
																<tr>
																	<td align="center" valign="top" class="eg_75bold"></td>
																</tr>
																<tr>
																	<td align="center" valign="middle" height="100%"><span class="eg_75bold" alt="<%=toolTopDisplayStrForMeasure%>" title="<%=toolTopDisplayStrForMeasure%>"><%=mappedMetricDisplayName%>(<%=tablesInfo.getUnitForMeasure(test,measure)%>)</span><br><br>
																	<img src="/final/monitor/eg_images/gray/exclamation-icon.gif"/><br> 
																	<egui:intnl text="monitor.dashboard.No Measures available"/>
																	</td>
																</tr>
															</table>
														</div>
<%
					}
				}
%>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</div>
				<table width="100%" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td class="whiteBottLeft" width="8"><img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"></td>
						<td class="eg_whitebg" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
						<td width="8" class="whiteBottRight"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
					</tr>
				</table>
			</div>
		</td>
	</tr>
</table>
<%
			}
		}
		else
		{
%>
<div class="div_scroll eg_cellbglits1" style="margin-left:0px;margin-top:0px;float:left;width:100%;height:100%;border:0px solid red;">
	<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" bordercolor="blue">
		<tr>
			<td align="center" valign="middle">
				<img src="/final/monitor/eg_images/gray/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No Measures available"/>
			</td>
		</tr>
	</table>
</div>
	
<%

		}
	}
	else
	{
		String testName="OraConnectionsTest";
		if(graphType ==null || graphType.trim().equals(""))
		{
			graphType="oracleconnection";
		}
		Vector databaseUsers=(Vector)allTestInfos.get(testName);
		boolean isDatabasesAvailable=(databaseUsers!=null && !databaseUsers.isEmpty());
		if((graphType!=null && graphType.equalsIgnoreCase("oracleconnection")) && isDatabasesAvailable)
		{
			if(isDatabasesAvailable)
			{
				Collections.sort(databaseUsers,String.CASE_INSENSITIVE_ORDER);
				Vector tempDBVec=new Vector();
				tempDBVec.add("All Users");
				tempDBVec.addAll(databaseUsers);
				databaseUsers=tempDBVec;
			}			
			if(isDatabasesAvailable && (selectedInfo==null || selectedInfo.equalsIgnoreCase("null") || selectedInfo.equals("") || selectedInfo.equalsIgnoreCase("undefined")))
			{
				selectedInfo=(String)databaseUsers.get(0);
				selectedInfo=com.egurkha.util.StringUtils.replace(selectedInfo,"+","");
			}
			else if(selectedInfo!=null && (!selectedInfo.equals("") && !selectedInfo.equals("All Users")))
			{
				selectedInfo=com.egurkha.util.StringUtils.replace(selectedInfo," ","+");
			}
			boolean isAllUsers=false;
			if(selectedInfo!=null && selectedInfo.equals("All Users"))
				isAllUsers=true;
	%>
<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%" class="eg_cellbglits1">
	<tr>
		<td id="treeViewTd"  width="180" align="left" valign="top" style="padding-top:8px;padding-left:8px;padding-right:0px;padding-bottom:0px;" border="0" >
			<table cellpadding="0" cellspacing="0" border="0"  bordercolor="red">
				<tr>
					<td width="100%" style="padding-right:0px">
					<div id="citrixUserDiv" style="height:300px;width:178;border:0px solid #ff0000;background-color:transparent">
						<table width="100%" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td class="whiteTopLeft eg_blankspace" width="8"> <img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"> </td>
								<td class="eg_whitebg eg_blankspace" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
								<td width="8" class="whiteTopRight eg_blankspace"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
							</tr>
						</table>
					
						<div id="citrixUserDivInner" class="eg_whitebg div_scroll" style="height:300px;width:178;border:0px solid green">

							<div class="dtree" id="eg_whitebg" style="padding-left:3px;">
								<div id="dd0" class="clip" style="border: 0px solid rgb(255, 0, 0);" >
									<div class="dTreeNode" style="font-size: 7.5pt; color: rgb(0, 0, 0);" oncontextmenu="return false;">
										<img class="png" id="id1" src="/final/monitor/eg_images/users.png" alt="" border="0">
										<span><b><egui:intnl text="monitor.dashboard.Database Users"/></b></span>
									</div>
<%
			for(int i=0;i<databaseUsers.size();i++)
			{
				String databaseUser=(String)databaseUsers.get(i);
				databaseUser = com.egurkha.util.StringUtils.replace(databaseUser,"+","");

				boolean isSelectedUser=false;
				if(selectedInfo!=null && selectedInfo.equals(databaseUser))
					isSelectedUser=true;
%>
									<div id="dd1" class="clip" style="border: 0px solid rgb(255, 0, 0); display: block;">
										<div class="dTreeNode" oncontextmenu="return false;">
<%
				if(i==databaseUsers.size()-1)
				{
%>
										<img src="/final/admin/eg_images/tree/joinbottom.gif" alt="">
<%
				}
				else
				{
%>
										<img src="/final/admin/eg_images/tree/join.gif" alt="">
<%
				}
%>
										<img class="png" id="id2"src="/final/monitor/eg_images/user.png" alt="" border="0">
											<span><a class="<%=(isSelectedUser)?"nodeSel eg_monlink mouse":"eg_monlink mouse"%>" onclick="javascript:changeGraphType1('<%=subsystem%>','<%=tab%>','<%=graphType%>','true','','','<%=databaseUser%>')"><%=databaseUser%></a></span>
										</div>
									</div>
<%
			}
%>
								</div>
							</div>
						</div>
						<table width="100%" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td class="whiteBottLeft" width="8"	><img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"></td>
								<td class="eg_whitebg" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
								<td width="8" class="whiteBottRight"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
							</tr>
						</table>
					</div>
					</td>
				</tr>
			</table>
		</td>

		<td style="width:6px;padding:0px;" id="hide" class="eg_cellbglits1">
			<div style="width:6px">
				<table border="0" cellspacing="0" cellpadding="0" style="width:4px">
					<tr>
						<td style="width:5px;padding:0px" class="eg_blankspace" id="expandTd"> <a href="javascript:void(0);" onclick="javascript:closeOracleTreeWindow()"><img id="expand" src="/final/monitor/eg_images/<%=monitor_Skin%>/split_left.gif" width="7" height="50" border="0"/></a>
						</td>
					</tr>
				</table>
			</div>
		</td>

		<td width="100%" height="100%"  valign="top" class="eg_cellbglits1" style="padding-top:8px;padding-left:0px;padding-right:8px;padding-bottom:0px;">
			<div id="ctxUserRightDiv" style="width:754;height:300px;border:0px solid #ff0000;">
			<table width="100%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td class="whiteTopLeft" width="8"><img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"></td>
					<td class="eg_whitebg" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
					<td width="8" class="whiteTopRight"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
				</tr>
			</table>

				<div class="div_scroll eg_whitebg" id="ctxUserRightDivInner" align="center" valign="top" style="margin:0px;padding:0px;width:754px;height:300px;border:0px solid blue">
					<table width="100%" cellpadding="6" cellspacing="0" border="0" align="center">
						<tr>
							<td width="49%"> 
								<table cellspacing="0" cellpadding="0" width="100%" border="0" bordercolor="red">
									<tr>
<%

			String testMeasures =iniObj.getValue(subject,tab+"_"+subsystem+"_Users"); 
			Vector allMeasures=egDashboard.getTokensAsVector(testMeasures,",");
			String s_lastMsmtTime="";
			Date lastMsmtTime = edi.egetRealDate();
			String s_timeonly="";
			Vector vec_times=new Vector();
			Hashtable conHash=new Hashtable();
			Hashtable Ora_User_connections= new Hashtable();
			if(allMeasures!=null && allMeasures.size()>0)
			{
				if(isAllUsers)
				{
					for(int i=0;i<databaseUsers.size();i++)
					{
						String databaseUser=(String)databaseUsers.get(i);
						for(int j=0;j<allMeasures.size();j++)
						{
							String tempMeasures = (String)allMeasures.get(j);
							String test_name = tempMeasures.substring(0,tempMeasures.indexOf(":"));
							String metric= tempMeasures.substring(tempMeasures.indexOf(":")+1);
							msmtHost = (String)allMsmtHosts.get(test_name);
							String  dbColName = dbInfo.getColumnForMeasure(test_name,metric);
							String currentMeasureValue="";
							if(list!=null && list.containsKey(test_name))
							{
								ArrayList lastMsmtTimeListForTest=(ArrayList)list.get(test_name);
								lastmsmtTimeIndex = lastMsmtTimeListForTest.indexOf(test_name)+3;
								lastmsmtTime = lastMsmtTimeListForTest.get(lastmsmtTimeIndex).toString();
								tempDate =testDateFormat.parse(lastmsmtTime);
								lastmsmtTime=timeFormat.format(tempDate);
								currentMeasureValue=dashboardDAO.getCurrentMeasure(hostName,portNo,sid+databaseUser,test_name,dbColName,msmtHost);
							}
							if(Ora_User_connections!=null && Ora_User_connections.containsKey(metric))
							{
								if(currentMeasureValue!=null && (!currentMeasureValue.equals("") &&  !currentMeasureValue.equalsIgnoreCase("null")))
								{
									Integer existingMeasureValue=(Integer)Ora_User_connections.get(metric);
									int existingVal=existingMeasureValue.intValue();
									if(existingVal<0)
										existingVal=0;
									int currentMeasValue=Integer.parseInt(currentMeasureValue);
									if(currentMeasValue>0)
									{
										existingVal=(existingVal+currentMeasValue);
										Ora_User_connections.put(metric,new Integer(existingVal));
									}
								}
							}
							else
							{
								if(currentMeasureValue!=null && (!currentMeasureValue.equals("") &&  !currentMeasureValue.equalsIgnoreCase("null")))
								{
									int curMeasValue=Integer.parseInt(currentMeasureValue);
									Ora_User_connections.put(metric,new Integer(curMeasValue));
								}
								else
								{
									Ora_User_connections.put(metric,new Integer(-5));
								}
							}
						}
					}
				}
				else
				{
					for(int j=0;j<allMeasures.size();j++)
					{
						String tempMeasures = (String)allMeasures.get(j);
						String test_name = tempMeasures.substring(0,tempMeasures.indexOf(":"));
						String metric= tempMeasures.substring(tempMeasures.indexOf(":")+1);
						msmtHost = (String)allMsmtHosts.get(test_name);
						String  dbColName = dbInfo.getColumnForMeasure(test_name,metric);
						String currentMeasureValue="";
						if(list!=null  && list.containsKey(test_name))
						{
							ArrayList lastMsmtTimeListForTest=(ArrayList)list.get(test_name);
							lastmsmtTimeIndex = lastMsmtTimeListForTest.indexOf(test_name)+3;
							lastmsmtTime = lastMsmtTimeListForTest.get(lastmsmtTimeIndex).toString();
							tempDate =testDateFormat.parse(lastmsmtTime);
							lastmsmtTime=timeFormat.format(tempDate);	currentMeasureValue=dashboardDAO.getCurrentMeasure(hostName,portNo,sid+"+"+selectedInfo,test_name,dbColName,msmtHost);
						}
						if(currentMeasureValue!=null && (!currentMeasureValue.equals("") &&  !currentMeasureValue.equalsIgnoreCase("null")))
						{
							Ora_User_connections.put(metric,new Integer(currentMeasureValue));
						}
						else
						{
							Ora_User_connections.put(metric,new Integer("-5"));
						}
					}
				}
			}
			String total="-5";
			String active="-5";
			String inactive="-5";
			if(Ora_User_connections!=null &&Ora_User_connections.size()>0)
			{
				Integer totInt=(Integer)Ora_User_connections.get("Total_connections");
				Integer actInt=(Integer)Ora_User_connections.get("Total_active_count");
				Integer InActInt=(Integer)Ora_User_connections.get("Total_inactive_count");
				if(totInt!=null)
					total=(String)""+totInt.intValue();
				if(actInt!=null)
					active=(String)""+actInt.intValue();
				if(InActInt!=null)
					inactive=(String)""+InActInt.intValue();
			}


%>

										<td valign="top">
											<table width="100%" height="15"  cellspacing="0" cellpadding="0" class="vmborder" align="left">
												<tr>
													<td align="center" class="eg_75bold jvm_header"><egui:intnl text='monitor.dashboard.Oracle User Connections'/> - <%=selectedInfo%></td>
												</tr>
<%
			boolean isTestHas_CutOffFactor=false;
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor(testName))
				{
					String info_for_cutofffactor="+"+selectedInfo;
					boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,sid,testName,msmtHost,info_for_cutofffactor);
					if(isTestExceededCutOffFactor)
					{
						isTestHas_CutOffFactor=true;
					}
				}
			}
			if( (active !=null   && total !=null && inactive !=null )  && (!active.equals("-5") &&  !inactive.equals("-5")) ||  !total.equals("-5")  &&  (!active.equals("")   && !total.equals("")  && !inactive.equals(""))  && !(active.equals("0") && inactive.equals("0")) || !total.equals("0") && !isTestHas_CutOffFactor)
			{
	
				long maxCount = 0L;
				long size = 0L;
				String xmlData=fusionChart.getXMLForUserConnection(Ora_User_connections,healthChartAttributes);
%>
												<tr>
													<td nowrap>
														<table width="99%" cellpadding="0" cellspacing="0" border="0">
															<tr>
																<td align="center" valign="top" >
																	<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="290" height="110" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
																	<param name="FlashVars" value="&dataXML=<%=xmlData%>&chartWidth=290&chartHeight=110">
																	<param name="quality" value="high" />
																	<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
																	<param name="WMode" value="Transparent">
																	<embed wmode="transparent" src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xmlData%>" quality="high" width="290" height="110" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																	</object> -->

																	<div id="Pie3DDialContainer"  style="height:100%;"></div>
																	<script type="text/javascript">
																		if  ( FusionCharts( "mycPie3DChartId" ) )
																				FusionCharts( "mycPie3DChartId" ).dispose();
																		var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","mycPie3DChartId", "290", "110","0","1");
																		myChart.setXMLData("<%=xmlData%>");
																		myChart.setTransparent(true);
																		myChart.render("Pie3DDialContainer");
																	</script>
																</td>
															</tr>
														</table>
													</td>
												</tr>
<%
			}
			else
			{

%>
												<tr>
													<td width="100%" height="100%" align="center" valign="top">
														<table  cellpadding="0" cellspacing="0" border="0"  width="100%" height="100%">
															<tr>
																<td  width="100%" height="110px" align="center" valign="middle"><img src="/final/monitor/eg_images/gray/exclamation-icon.gif"/><br> 
																<egui:intnl text="monitor.dashboard.No User connections available"/> </td>
															</tr>
														</table>
													</td>
												</tr>

<%
			}
%>
											</table>
										</td>
									</tr>
								</table>
							</td>
							<td width="49%">
								<table cellspacing="0" cellpadding="0" width="99%" align="right" border="0">
									<tr>
										<td valign="top">
											<table width="100%" height="15"  cellspacing="0" cellpadding="0" class="vmborder" align="left">
												<tr>
													<td align="center" class="eg_75bold jvm_header"><egui:intnl text='monitor.dashboard.Oracle User Session'/> - <%=selectedInfo%></td>
												</tr>
<%
			String totSession="";
			String activeSession="";
			String currentSessionValue="";
			String testMeasuresForSession=iniObj.getValue(subject,tab+"_"+subsystem+"_Overview_Sessions");
			Vector allMeasuresForSession=egDashboard.getTokensAsVector(testMeasuresForSession,",");
			int val1Count = 0;
			int val2Count = 0;
			int val3Count = 0;
			int vActiveCount = 0;
			int vInActiveCount = 0;
			int measureVal=0;
			int existingVal=0;
			Hashtable useSessionObj=new Hashtable();
			if(allMeasuresForSession!=null && allMeasuresForSession.size()>0)
			{
				if(isAllUsers)
				{
					for(int j=0;j<allMeasuresForSession.size();j++)
					{
						String tempMeasures = (String)allMeasuresForSession.get(j);
						String test_name = tempMeasures.substring(0,tempMeasures.indexOf(":"));
						String metric= tempMeasures.substring(tempMeasures.indexOf(":")+1);
						msmtHost = (String)allMsmtHosts.get(test_name);
						String  dbColName = dbInfo.getColumnForMeasure(test_name,metric);
						String currentMeasureValue="";
						if(list!=null  && list.containsKey(test_name))
						{
							ArrayList lastMsmtTimeListForTest=(ArrayList)list.get(test_name);
							lastmsmtTimeIndex = lastMsmtTimeListForTest.indexOf(test_name)+3;
							lastmsmtTime = lastMsmtTimeListForTest.get(lastmsmtTimeIndex).toString();
							tempDate =testDateFormat.parse(lastmsmtTime);
							lastmsmtTime=timeFormat.format(tempDate);
							currentMeasureValue=dashboardDAO.getCurrentMeasure(hostName,portNo,sid+"+",test_name,dbColName,msmtHost);
						}
						if(useSessionObj!=null &&useSessionObj.containsKey(metric))
						{
							if(currentMeasureValue!=null && (!currentMeasureValue.equals("") &&  !currentMeasureValue.equalsIgnoreCase("null")))
							{
								Integer existingMeasureValue=(Integer)useSessionObj.get(metric);
								existingVal=existingMeasureValue.intValue();
								if(existingVal<0)
									existingVal=0;
								int currentMeasValue=Integer.parseInt(currentMeasureValue);
								if(currentMeasValue>0)
								{
									existingVal=(existingVal+currentMeasValue);
									useSessionObj.put(metric,new Integer(existingVal));
								}
							}
						}
						else
						{
							if(currentMeasureValue!=null && (!currentMeasureValue.equals("") &&  !currentMeasureValue.equalsIgnoreCase("null")))
							{
								measureVal=Integer.parseInt(currentMeasureValue);
								useSessionObj.put(metric,new Integer(measureVal));
							}
							else
							{
								useSessionObj.put(metric,new Integer(-5));
							}
						}
					}
				}
				else
				{
					for(int i=0;i<allMeasuresForSession.size();i++)
					{
						String tsTestMeasure=(String)allMeasuresForSession.get(i);
						String tsTestName=tsTestMeasure.substring(0,tsTestMeasure.indexOf(":"));
						String tsMeasureName=tsTestMeasure.substring(tsTestMeasure.indexOf(":")+1);
						int valCount=0;
						if(tsTestMeasure!=null && tsTestMeasure.equals("OraSessionTest:Num_total_sessions"))
							continue;
						EgDiagnosisBean dd=new EgDiagnosisBean();
						String[] sesDesc = dd.getDescription(tsTestName,tsMeasureName);
						String se_format="";
						String se_desc="";
						if (sesDesc != null && sesDesc.length>1)
						{
							se_format=sesDesc[0];
							se_desc=sesDesc[1];
						}
						ArrayList headers =new ArrayList(egDashboard.getTokensAsVector(se_format," "));	s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(tsTestName,tsMeasureName,hostName,portNo,"NULL",sid+"+",msmtHost);
						lastMsmtTime= edi.egetRealDate();
						if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
							lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
						else
							s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);
						startTime=sf.format(lastMsmtTime);
						endTime=sf.format(lastMsmtTime);
						s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
						vec_times=egDashboard.getTokensAsVector(s_timeonly,":");
						startHour=(String)vec_times.get(0);
						endHour=(String)vec_times.get(0);
						startMin=(String)vec_times.get(1);
						endMin=(String)vec_times.get(1);
						int i_endMin=Integer.parseInt(endMin)+1;
						endMin=i_endMin+"";
						ArrayList s_results=dd.getDiagnosisData(hostName, portNo,"NULL",tsTestName,tsMeasureName,sid+"+", startTime, endTime, startHour, endHour,startMin,endMin,"1","user_name",msmtHost);
						ArrayList sessionDatas = new ArrayList();

						if(s_results.size()>=2)
						{
							sessionDatas=(ArrayList)s_results.get(1);
						}
						ArrayList ActConLists=sessionDatas;
						Hashtable countobj=new Hashtable();
						String osname="";
						String prgname="";
						if(ActConLists!=null && !ActConLists.isEmpty())
						{
							for(int j=0;j<ActConLists.size();j++)
							{
								Object checkObj=(Object)ActConLists.get(j);
								if(checkObj instanceof String)
								{
									String actlists=(String)ActConLists.get(j);
									Vector actlistObj=egDashboard.getTokensAsVector(actlists,"~!~");
									if (actlistObj!=null && actlistObj.size()>0)
									{
										if(actlistObj.get(0).toString().equalsIgnoreCase(selectedInfo))
										{
											if(actlistObj.get(2).toString().equalsIgnoreCase("ACTIVE"))
											{
												String account=(String)actlistObj.get(4);
												vActiveCount=vActiveCount+Integer.parseInt(account);
											}
											else if(actlistObj.get(2).toString().equalsIgnoreCase("INACTIVE"))
											{
												String inaccount=(String)actlistObj.get(4);
												vInActiveCount=vInActiveCount+Integer.parseInt(inaccount);
											}
										}
									}
									useSessionObj.put("activesession",new Integer(vActiveCount));
									useSessionObj.put("inactivesession",new Integer(vInActiveCount));
								}
								else if(checkObj instanceof ArrayList)
								{
									ArrayList tempList=(ArrayList)ActConLists.get(j);
									if(tempList!=null && tempList.size()>0)
									{
										for(int k=0;k<tempList.size();k++)
										{
											String desc_Name =(String)tempList.get(k);
											if(desc_Name.equalsIgnoreCase(selectedInfo))
											{
												for(int indx=0;indx<allMeasuresForSession.size();indx++)
												{
													String tempMeasures = (String)allMeasuresForSession.get(indx);
													String test_name = tempMeasures.substring(0,tempMeasures.indexOf(":"));
													String metric= tempMeasures.substring(tempMeasures.indexOf(":")+1);
													if(metric!=null && !metric.equalsIgnoreCase("Num_total_sessions"))
													{
														if(metric!=null && metric.equalsIgnoreCase(tsMeasureName))
														{
															if(i==0)
																valCount=++val1Count;
															else if(i==1)
																valCount=++val2Count;
															else
																valCount=++val3Count;
														}
													}
												}
					}
											else if(desc_Name!=null && desc_Name.equals("-"))
											{
												desc_Name="unknown";
											}
										}
									}
								}
							}
						}
						useSessionObj.put(tsMeasureName,new Integer(valCount));
					}
				}
			}
			if(measureVal!=0 || (vActiveCount!=0 && vInActiveCount!=0) || (val1Count!=0 || val2Count!=0))
			{
				String xmlDataForSession=fusionChart.getXMLForUserSessions(useSessionObj,healthChartAttributes);
%>
												<tr>
													<td>
														<table cellspacing="0" cellpadding="0" width="100%" border="0">
															<tr>
																<td align="center" valign="top">
																	<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="290" height="110" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
																	<param name="FlashVars" value="&dataXML=<%=xmlDataForSession%>&chartWidth=290&chartHeight=110">
																	<param name="quality" value="high" />
																	<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
																	<param name="WMode" value="Transparent">
																	<embed wmode="transparent" src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xmlDataForSession%>" quality="high" width="290" height="110" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																	</object> -->

																	<div id="Pie3DDial2Container"  style="height:100%;"></div>
																	<script type="text/javascript">
																		if  ( FusionCharts( "mycPie3D2ChartId" ) )
																			FusionCharts( "mycPie3D2ChartId" ).dispose();
																		var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","mycPie3D2ChartId", "290", "110","0","1");
																		myChart.setXMLData("<%=xmlDataForSession%>");
																		myChart.setTransparent(true);
																		myChart.render("Pie3DDial2Container");
																	</script>
																</td>
															</tr>
														</table>
													</td>
												</tr>
<%
			}
			else
			{
%>
												<tr>
													<td width="100%" height="100%" align="center" valign="top">
														<table  cellpadding="0" cellspacing="0" border="0"  width="100%" height="100%">
															<tr>
																<td  width="100%" height="110px" align="center" valign="middle"><img src="/final/monitor/eg_images/gray/exclamation-icon.gif"/><br>  <egui:intnl text="monitor.dashboard.No User sessions available"/> </td>
															</tr>
														</table>
													</td>
												</tr>

<%
			}
%>


											</table>
										</td>
									</tr>
								</table>
							</td>
						</tr>
<%
			String descriptor=com.egurkha.util.StringUtils.replace(selectedInfo,sid+"+","");
			String oraLockMetrics=iniObj.getValue(subject,"Application_Database access_Overview_LockSummary");
			String ddtest=oraLockMetrics.substring(0,oraLockMetrics.indexOf(":"));
			String ddmeasure=oraLockMetrics.substring(oraLockMetrics.indexOf(":")+1,oraLockMetrics.indexOf("#"));
			String ddParamsForLocks=oraLockMetrics.substring(oraLockMetrics.indexOf("#")+8,oraLockMetrics.length());
			String desc=sid+"+";
			if(runingTestList!=null && runingTestList.contains(ddtest))
			{
%>
						<tr>
							<td colspan="2" style="padding-top:6px">
								<table width="100%" border="0" cellpadding="0" cellspacing="0" class="vmborder">
									<tr>
										<td colspan="2" height="20px" align="center" class="eg_75bold jvm_header" ><egui:intnl text='monitor.dashboard.Oracle Lock'/>-<egui:intnl text='monitor.dashboard.Summary'/></td>
									</tr>

<%
				msmtHost=(String)allMsmtHosts.get(ddtest);

				EgDiagnosisBean dd=new EgDiagnosisBean();
				dd.getDescription(ddtest,ddmeasure);

				s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(ddtest,ddmeasure,hostName,portNo,"NULL",desc,msmtHost);

				lastMsmtTime = edi.egetRealDate();
				if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
					lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
				else
					s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);

				startTime=sf.format(lastMsmtTime);
				endTime=sf.format(lastMsmtTime);

				s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
				vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

				startHour=(String)vec_times.get(0);
				endHour=(String)vec_times.get(0);
				startMin=(String)vec_times.get(1);
				endMin=(String)vec_times.get(1);

				int i_endMin=Integer.parseInt(endMin)+1;
				endMin=i_endMin+"";

				ArrayList lockDDResult=dd.getDiagnosisData(hostName, portNo,"NULL", ddtest, ddmeasure,desc, startTime, endTime, startHour, endHour,startMin,endMin,"1","",msmtHost);

				ArrayList allLocks=new ArrayList();
				String mesureString="";
				String measuredata="";
				if(lockDDResult.size()>=2)
				{
					allLocks=(ArrayList)lockDDResult.get(1);
				}
				boolean isLockAvailable=false;
				for(int i=0; i<allLocks.size(); i++)
				{
					mesureString=(String)allLocks.get(i);
					ArrayList tokenizedData=new ArrayList(egDashboard.getTokensAsVector(mesureString,"~!~"));
					if(!isAllUsers)
					{
						if(tokenizedData!=null && tokenizedData.contains(descriptor))
						{
							isLockAvailable=true;
							break;
						}

					}
					else
					{
						if(tokenizedData!=null && !tokenizedData.isEmpty())
						{
							isLockAvailable=true;
							break;
						}
					}
				}
				int imgcn=0;
				int stColPo=0;
				int endColPo=0;
				if(isLockAvailable && !isTestHas_CutOffFactor)
				{
					ArrayList headerList=new ArrayList();
					int ddParamCount=0;
					if(ddParamsForLocks!=null && !ddParamsForLocks.equals(""))
					{
						StringTokenizer stkDDParams=new StringTokenizer(ddParamsForLocks,",");
						while(stkDDParams.hasMoreTokens())
						{
							String ddParam=stkDDParams.nextToken();
				
							if(ddParam!=null)
							{
								if(ddParam.equals("DbUser"))
								{
									if(isAllUsers)
										headerList.add(ddParam);
								}
								else
								{
									headerList.add(ddParam);
								}
							}
						}
						ddParamCount++;
					}
					endColPo=headerList.size();
					
%>
									<tr>
										<td width="100%">
											<table width="100%" border="0" cellpadding="2" cellspacing="0" class="tableborder_jvm">
												<tr>
<%
					for(int j=0;j<headerList.size();j++)
					{
						String headerforLock=(String)headerList.get(j);
						if(headerforLock!=null && !headerforLock.equals(""))
						{
							String mappedHeader=iniObj.getValue("Dashboard_TableColumn_mapping",ddtest+":"+ddmeasure+"#DDFormat:"+headerforLock);
							if(mappedHeader!=null && !mappedHeader.equals(""))
								headerforLock=mappedHeader;
						}
%>
													<td class="tdborder2_jvm">
														<table border="0" cellspacing="0" cellpadding="0" width="100%">
															<tr>
																<td><a class="eg_monlink" href="" onclick="this.blur();return sortTable('LockTable',<%=j%>,<%=stColPo%>,<%=endColPo%>,
																'<%=imgcn%>');">
																<span class="eg_75bold"><%=headerforLock%></span></a></td>
																<td style="width:15px"><img id="imgdd<%=imgcn%>" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortTable('LockTable',<%=j%>,<%=stColPo%>,<%=endColPo%>,
																'<%=imgcn%>');" style="display:none"/></td>
															</tr>
														</table>
													</td>
<%
						imgcn++;
					}
%>
												</tr>
												<tbody id="LockTable" name="LockTable">
<%
					for(int k=0; k<allLocks.size(); k++)
					{
						mesureString=(String)allLocks.get(k);
						ArrayList tokenizedData=new ArrayList(egDashboard.getTokensAsVector(mesureString,"~!~"));
						if(isAllUsers)
						{
%>
												<tr>
<%
							for(int l=0; l<tokenizedData.size();l++)
							{
%>
													<td class="tdborder_jvm" valign="top"> <%=(String)tokenizedData.get(l)%> </td>
<%
							}
%>
												
												</tr>
<%
						}
						else
						{
							if(tokenizedData!=null && tokenizedData.contains(descriptor))
							{
						
%>
												<tr>
<%
								tokenizedData.remove(descriptor);
								for(int l=0; l<tokenizedData.size();l++)
								{
%>
													<td class="tdborder_jvm" valign="top"> <%=(String)tokenizedData.get(l)%> </td>
<%
								}
%>
												
												</tr>
<%
							}
						}
					}
%>
												</tbody>
												<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortTable('LockTable',0,0,8,0);" style="visibility:hidden;display:none;">
											</table>
										</td>
									</tr>
<%
				}
				else
				{
%>
									<tr>
										<td width="100%" height="100%" align="center" valign="top">
											<table  cellpadding="0" cellspacing="0" border="0"  width="100%" height="100%">
												<tr>
													<td  width="100%" height="110px" align="center" valign="middle"><img src="/final/monitor/eg_images/gray/exclamation-icon.gif"/><br>  <egui:intnl text="monitor.dashboard.No User locks available"/></td>
												</tr>
											</table>
										</td>
									</tr>
<%
				}
%>
								</table>
							</td>
						</tr>
<%
			}
%>
					</table>
				</div>
				<table width="100%" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td class="whiteBottLeft" width="8"><img src="/final/monitor/eg_images/spacer.gif" height="8" width="8"></td>
						<td class="eg_whitebg" width="100%"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
						<td width="8" class="whiteBottRight"><img src="/final/monitor/eg_images/spacer.gif" height="8"></td>
					</tr>
				</table>
			</div>
		</td>
	</tr>
</table>
<%
		}
		else if((graphType!=null && graphType.equalsIgnoreCase("OracleHighUtilQueries")))
		{
			String metricWithDisplayNames=iniObj.getValue(subject,"Application_Database access_Top Queries_summary");
			String metricWithTest=metricWithDisplayNames.substring(0,metricWithDisplayNames.indexOf("#"));
			String ddParamsForTest=metricWithDisplayNames.substring(metricWithDisplayNames.indexOf("#")+8,metricWithDisplayNames.length());
			String ddtest=metricWithTest.substring(0,metricWithTest.indexOf(":"));
			String ddmeasure=metricWithTest.substring(metricWithTest.indexOf(":")+1,metricWithTest.length());

			String desc=sid+"+";

			if(runingTestList!=null && runingTestList.contains(ddtest))
			{	
%>
<table width="100%" cellpadding="0" cellspacing="0" width="100"  border="0" class="eg_whitebg">
	<tr>
<%
				if(isMSIE)
				{
%>
		<td style="padding-right:10px">
<%
				}
				else
				{
%>
		<td>
<%
				}
%>
			<div style="margin:5px;border:0px solid #ff0000">
				<table width="100%" border="0" cellpadding="2" cellspacing="0" class="vmborder">
					<tr>
						<td colspan="11"  height="20px"  align="center" class="eg_75bold jvm_header"><egui:intnl text='monitor.dashboard.Oracle High resource utilizing Queries'/> </td>
					</tr>
					<tr>
<%
				msmtHost=(String)allMsmtHosts.get(ddtest);

				EgDiagnosisBean dd=new EgDiagnosisBean();
				dd.getDescription(ddtest,ddmeasure);
				String s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(ddtest,ddmeasure,hostName,portNo,"NULL",desc,msmtHost);
				Date lastMsmtTime = edi.egetRealDate();
				if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
					lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
				else
					s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);
				startTime=sf.format(lastMsmtTime);
				endTime=sf.format(lastMsmtTime);
				String s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
				Vector vec_times=egDashboard.getTokensAsVector(s_timeonly,":");
				startHour=(String)vec_times.get(0);
				endHour=(String)vec_times.get(0);
				startMin=(String)vec_times.get(1);
				endMin=(String)vec_times.get(1);
				int i_endMin=Integer.parseInt(endMin)+1;
				endMin=i_endMin+"";

				ArrayList a_results=dd.getDiagnosisData(hostName, portNo,"NULL", ddtest, ddmeasure,sid+"*", startTime, endTime, startHour, endHour,startMin,endMin,"1","",msmtHost);
				ArrayList allDatas=new ArrayList();
				if(a_results.size()>=2)
				{
					allDatas=(ArrayList)a_results.get(1);
				}
				boolean isDataAvail=false;
				for(int i=0;i<allDatas.size();i++)
				{
					String s_singleData=(String)allDatas.get(i);
					ArrayList singleData=new ArrayList(egDashboard.getTokensAsVector(s_singleData,"~!~"));
					
					if(singleData!=null && !singleData.isEmpty())
					{
						isDataAvail=true;
						break;
					}
				}
				int imgcnt=0;
				int stColPos=0;
				int endColPos=0;
				int ddParamCount=0;
				if(isDataAvail)
				{
					ArrayList headers=new ArrayList();
					if(ddParamsForTest!=null && !ddParamsForTest.equals(""))
					{
						StringTokenizer stkDDParams=new StringTokenizer(ddParamsForTest,",");
						while(stkDDParams.hasMoreTokens())
						{
							String ddParam=stkDDParams.nextToken();
							headers.add(ddParam);
							ddParamCount++;
						}

					}
					endColPos=ddParamCount;
					for(int i=0;i<headers.size();i++)
					{
						String header=(String)headers.get(i);
						if(!header.equals("SQL"))
						{
						
%>
						<td class="tdborder2_jvm">
							<table border="0" cellspacing="0" cellpadding="0" width="100%">
								<tr>
									<td><a class="eg_monlink" href="" onclick="this.blur();return sortTablewithimage('HighResourceQueriesTable',<%=i%>,<%=stColPos%>,<%=endColPos%>,'<%=imgcnt%>');"> <span class="eg_75bold"><%=header%></span></a></td>
									<td style="width:15px" border="2"><img id="imgddd<%=imgcnt%>" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortTablewithimage('HighResourceQueriesTable',<%=i%>,<%=stColPos%>,<%=endColPos%>,'<%=imgcnt%>');" style="display:none"/></td>
								</tr>
							</table>
						</td>
<%
							imgcnt++;
						}
						else
						{
%>
						<td class="eg_75bold tdborder2_jvm" wrap><%=header%></td>
<%
						}
					}
%>
					</tr>
					<tbody id="HighResourceQueriesTable" name="HighResourceQueriesTable">
<%
					for(int i=0;i<allDatas.size();i++)
					{
						String s_singleData=(String)allDatas.get(i);
						ArrayList singleData=new ArrayList(egDashboard.getTokensAsVector(s_singleData,"~!~"));
%>
					<tr>
<%
						for(int j=0;j<singleData.size();j++)
						{
							String data=(String)singleData.get(j);
							if(j==singleData.size()-1)
							{
%>
						<td class="tdborder_jvm" wrap><%=data.substring(0,data.length()-1)%></td>
<%
							}
							else
							{
%>
						<td class="tdborder_jvm" wrap><%=data%></td>
<%
							}
						}
%>
					</tr>
<%
					}
%>
					</tbody>
					<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortTablewithimage('HighResourceQueriesTable',0,0,8,0);" style="visibility:hidden;display:none;">
<%
				}
				else
				{
%>
					<tr>
						<td height="290px" width="100%">
							<table align="center" width="100%" height="100%" cellpadding="0" cellspacing="0" border="0">
								<tr>
									<td align="center" valign="middle" height="100%" width="100%"><img src="/final/monitor/eg_images/gray/exclamation-icon.gif"/><br> 
										<egui:intnl text="monitor.dashboard.No Measures available"/>
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
				}
%>
				</table>
			</div>
		</td>
	</tr>
</table>
<%
			}
			else
			{
%>

<table width="100%" cellpadding="0" cellspacing="0" height="100%"  border="0" class="eg_whitebg">
	<tr>
		<td align="center" valign="middle"><img src="/final/monitor/eg_images/gray/exclamation-icon.gif"/> <br> <egui:intnl text="monitor.dashboard.No Measures available"/>
		</td>
	</tr>
</table>
<%
			}
		}
		else
		{
%>
	<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" bordercolor="blue">
		<tr>
			<td align="center" valign="middle">
				<img src="/final/monitor/eg_images/gray/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures available"/>
			</td>
		</tr>
	</table>
<%
		}
	}
%>
<input type="hidden" id="graphType" value="<%=graphType%>"/>
<input type="hidden" id="selectedInfo" value="<%=selectedInfo%>"/>
<%
	if(request.getQueryString()!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+compType+"&subsystem="+subsystem+"&host="+compName+"&selectedInfo="+selectedInfo+"&tab="+tab+"&graphType="+graphType+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&selectedInfo="+selectedInfo+"&tab="+tab+"&subsystem="+subsystem+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>


