<%@ page language="java" contentType="text/html;charSet=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="EgServerDashboardTracker.jsp"%>
<%@ page errorPage="EgProbsM.jsp"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "java.sql.ResultSet" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>
<%
try
{
	String compType=request.getParameter("compType");
	String compName=request.getParameter("compName");
	String selectedTest=request.getParameter("test");
	String graphType=request.getParameter("graphType");
	String from=request.getParameter("from");
	String profileName=request.getParameter("profileName");

	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniObj = new IniFile(s_iniFile_dir+"eg_customdashboard.ini");
	IniFile mappingIni = new IniFile(s_iniFile_dir+"eg_customdashboardTitleMapping.ini");
	IniFile formatIni = new IniFile(s_iniFile_dir+"eg_format.ini");

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgDiagnosisBean ddb=new EgDiagnosisBean();
	EgCustomDashboardModel egCustomDashboard=new EgCustomDashboardModel();
	EgServerDashboardModel egDashboard=new EgServerDashboardModel();
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	Vector layers=egDashboard.getLayersForModule(compType,"All");

	String layerList="";

	for(int i=0;i<layers.size();i++)
	{
		layerList+="'"+(String)layers.get(i)+"'";
		layerList+=(i<layers.size()-1?",":"");
	}

	String subject=u_ser.getLoginID()+"_"+compType+"_"+profileName;
	Vector infoBasedTests=egCustomDashboard.getInfoBasedTests(compType);
	ArrayList tests=new ArrayList();
	if(from!=null && from.equalsIgnoreCase("config"))
		tests=specsInfo.getEnabledTests(compType,true);
	else
		tests=specsInfo.getEnabledTests(compType,false);
	boolean loadTests=(tests.size()>0 && !tests.isEmpty());
	boolean isDDComparisonTable=false;
	if(from!=null && from.equalsIgnoreCase("ddcomparisontable"))
		isDDComparisonTable=true;
	if(from!=null && from.equalsIgnoreCase("table"))
	{
		boolean componentHaveInfoBasedTest=false;
		for(int i=0;i<tests.size();i++)
		{
			String testForTable=(String)tests.get(i);
			if(testForTable!=null && (infoBasedTests!=null && infoBasedTests.contains(testForTable)))
			{
				componentHaveInfoBasedTest=true;
				break;
			}
		}
		loadTests=loadTests && (infoBasedTests!=null && !infoBasedTests.isEmpty()) && componentHaveInfoBasedTest;
	}
	else if(isDDComparisonTable)
	{
		String s_temp = new String();
		Vector v_validTests=new Vector();
		String strVarArr[] = formatIni.getVariables("FORMAT");
		String fakeTestArr[] = formatIni.getVariables("COMMON_DD_MAPPING");
		StringBuffer s_testListBuff=new StringBuffer(256);
		ResultSet rs=null;
		for(int i=0;i<strVarArr.length;i++)
		{
			s_temp=strVarArr[i].trim();
			if(s_temp.indexOf(":")>0)
			{
				s_temp = s_temp.substring(0,s_temp.indexOf(":"));
				v_validTests.addElement(s_temp);
			}
		}
		for(int i=0;i<fakeTestArr.length;i++)
		{
			s_temp=fakeTestArr[i].trim();
			if(s_temp.indexOf(":")>0)
			{
				s_temp = s_temp.substring(0,s_temp.indexOf(":"));
				v_validTests.addElement(s_temp);
			}
		}
		if(tests!=null && !tests.isEmpty())
		{
			ArrayList ddTests=new ArrayList();
			for(int k_ctr=0;k_ctr < tests.size();k_ctr++)
			{
				String s_test_temp = ((String)tests.get(k_ctr)).trim();
				if(v_validTests.indexOf(s_test_temp)>-1)
				{
					if(ddTests!=null && !ddTests.contains(s_test_temp))
						ddTests.add(s_test_temp);
				}
			}
			if ( ddTests == null || ddTests.isEmpty() )
				loadTests = false;
			tests=ddTests;
		}
	}
	else if(graphType!=null && graphType.equalsIgnoreCase("dial"))
	{
		ArrayList testsHavingMeasuresWithPercentage=new ArrayList();
		for(int i=0;i<tests.size();i++)
		{
			String testNam=(String)tests.get(i);
			String measureNames[]=dbInfo.getMeasurementsForTest(testNam);
			if(measureNames!=null && measureNames.length>0)
			{
				for(int m=0;m<measureNames.length;m++)
				{
					String meas=measureNames[m];
					if(meas!=null && !meas.equals(""))
					{
						String unitForMeasure=tablesInfo.getUnitForMeasure(testNam,meas);
						if(unitForMeasure!=null && (unitForMeasure.trim().equals("%") || unitForMeasure.trim().equalsIgnoreCase("percent")))
						{
							testsHavingMeasuresWithPercentage.add(testNam);
							break;
						}
					}
				}
			}
		}
		if(testsHavingMeasuresWithPercentage!=null && !testsHavingMeasuresWithPercentage.isEmpty())
			tests=testsHavingMeasuresWithPercentage;
	}
	if(loadTests)
	{
		Collections.sort(tests,String.CASE_INSENSITIVE_ORDER);
		String defaultMGraphDuration=request.getParameter("measureGraphDuration");
		if(defaultMGraphDuration==null || defaultMGraphDuration.trim().equals(""))
			defaultMGraphDuration=mappingIni.getValue(subject+"_MeasureGraph_Duration","duration");

		if(defaultMGraphDuration==null || defaultMGraphDuration.trim().equals(""))
			defaultMGraphDuration="1 hour";
%>
<table  border="0" bordercolor="0">
	<tr>
		<td class="font_bold11 padding4" ><egui:intnl text="monitor.dashboard.Tests"/></td>
		<td class="font_bold11 padding4" >
			<select id="testSelect" onchange="testOnSelect()" class="egInputSelect" style="width:240px">
<%
		for(int i=0;i<tests.size();i++)
		{
			String selected="";
			String test=(String)tests.get(i);
			

			if(from!=null && from.equalsIgnoreCase("table"))
			{
				if(infoBasedTests!=null && !infoBasedTests.contains(test))
				{
					continue;
				}
			}
			if(selectedTest==null || selectedTest.trim().equals(""))
				selectedTest=test;

			if(selectedTest!=null && selectedTest.equals(test))
				selected="selected";
			
%>
				<option value="<%=test%>" <%=selected%>><egui:intnl test="<%=test%>"/></option>
<%
		}
%>
			</select>
		</td>
	</tr>
	<tr>
		<td class="font_bold11 padding4" ><egui:intnl text="monitor.dashboard.Measures"/></td>
		<td class="font_bold11 padding4" >
<%
		String measureNames[]=dbInfo.getMeasurementsForTest(selectedTest);
		if(measureNames!=null && measureNames.length>0)
			Arrays.sort(measureNames,String.CASE_INSENSITIVE_ORDER);

		String onAddButtonClickFunctionName="";
		String onOkButtonClickFunctionName="";
		Vector ddMeasures=new Vector();
		String selectedMeasure="";

		if(from!=null && from.equalsIgnoreCase("table"))
		{
			onOkButtonClickFunctionName="javascript:loadMeasureOnTable();";
%>
			<select id="measureSelect" multiple class="egInputSelectMulti" style="width:240px">
<%
		}
		else if(isDDComparisonTable)
		{
			onOkButtonClickFunctionName="javascript:saveDDComparisonTableConfig(false);";
			ddMeasures=ddb.populateMeasures(selectedTest);
			selectedMeasure=request.getParameter("selectedMeasure");
%>
			<select id="measureSelect" onchange="javascript:changeMeasuresForDD();" class="egInputSelect" style="width:240px">
			<option value="-5" Selected><egui:intnl text="monitor.dashboard.Please Select Measure"/></option>
<%
		}
		else if(from!=null && from.equalsIgnoreCase("kpi"))
		{
			onAddButtonClickFunctionName="javascript:loadMeasuerOnKPI(false);";
			onOkButtonClickFunctionName="javascript:loadMeasuerOnKPI(true);";
%>
			<select id="measureSelect" multiple class="egInputSelectMulti" style="width:240px">
<%
		}
		else if(from!=null && from.equalsIgnoreCase("config"))
		{
			onAddButtonClickFunctionName="javascript:loadMeasuerOnConfig(false);";
			onOkButtonClickFunctionName="javascript:loadMeasuerOnConfig(true);";
%>
			<select id="measureSelect" multiple class="egInputSelectMulti" style="width:240px">
<%
		}
		else
		{
			onOkButtonClickFunctionName="javascript:measureOnSelect();";
%>
			<select id="measureSelect" class="egInputSelect" style="width:240px">
				<option value="-5" Selected><egui:intnl text="monitor.dashboard.Please Select Measure"/></option>
<%
		}
		if(isDDComparisonTable)
		{
			if(ddMeasures!=null && !ddMeasures.isEmpty())
			{
				Collections.sort(ddMeasures,String.CASE_INSENSITIVE_ORDER);
				for(int i=0;i<ddMeasures.size();i++)
				{
					String measure=(String)ddMeasures.get(i);
					String units = tablesInfo.getUnitForMeasure(selectedTest,measure);
					if(!units.equals("") && !units.equals("null"))
					{
						units = "("+units+")";
					}
					String selected="";
					if(selectedMeasure!=null && selectedMeasure.equals(measure))
						selected="selected";
%>
				<option value="<%=measure%>" <%=selected%>><egui:intnl measure='<%=selectedTest+":"+measure%>'/><%=" "+units%></option>
<%
				}
			}
		}
		else
		{
			for(int i=0;i<measureNames.length;i++)
			{
				String measure=measureNames[i];
				String units = "";

				if(graphType!=null && graphType.equalsIgnoreCase("comparision"))
				{
					if(testerInfo.getAllowNegativeValues(selectedTest,measure))
						continue;
				}

				if(!selectedTest.endsWith("_cf"))
				{
					units = tablesInfo.getUnitForMeasure(selectedTest,measure);

					if((graphType!=null && graphType.equalsIgnoreCase("dial")) && (units!=null && (!units.equals("%") && !units.equalsIgnoreCase("percent"))))
						continue;

					if(!units.equals("") && !units.equals("null"))
					{
						units = "("+units+")";
					}
				}
%>
				<option value="<%=measure%>"><egui:intnl measure='<%=selectedTest+":"+measure%>'/><%=" "+units%></option>
<%
			}
		}
%>
			</select>
		</td>
	</tr>
<%
		if(isDDComparisonTable)
		{
			if((selectedTest!=null && !selectedTest.equals("")) && (selectedMeasure!=null && !selectedMeasure.equals("")))
			{

%>
	<tr>
		<td class="font_bold11 padding4" ><egui:intnl text="monitor.dashboard.DD Columns"/></td>
		<td class="font_bold11 padding4" >
			<select id="ddColumnsList" multiple class="egInputSelectMulti" style="width:240px">
<%
				String strValue=formatIni.getValue("DDD_TESTS", selectedTest);
				if(strValue!=null && !strValue.equals(""))
				{
					String ddFormats=strValue;
					StringTokenizer stkFormats=new StringTokenizer(ddFormats,",");
					String ddFormatsWithDesc[]=ddb.getDescription(selectedTest,selectedMeasure);
					String ddFormats1=ddFormatsWithDesc[0];
					String ddDesc=ddFormatsWithDesc[1];
					ddFormats1=ddFormats1.substring(ddFormats1.indexOf(":")+1);
					StringTokenizer stkFormats1=new StringTokenizer(ddFormats1);
					while(stkFormats.hasMoreTokens())
					{
						String ddFormat=stkFormats.nextToken();
						String dispDDFormat=ddFormat;
						if(stkFormats1.hasMoreTokens())
							dispDDFormat=stkFormats1.nextToken();
						if(ddFormat!=null && ddFormat.indexOf("#")>-1)
							ddFormat=StringUtils.replace(ddFormat,"#","");
						if(dispDDFormat!=null && dispDDFormat.indexOf("#")>-1)
							dispDDFormat=StringUtils.replace(dispDDFormat,"#","");
%>
				<option value="<%=ddFormat+":"+dispDDFormat%>"><egui:intnl text='<%="monitor.detaileddiagnosis."+dispDDFormat%>'/></option>
<%
					}
				}
				else
				{
					String ddFormatsWithDesc[]=ddb.getDescription(selectedTest,selectedMeasure);
					if(ddFormatsWithDesc!=null && ddFormatsWithDesc.length>0)
					{
						String ddFormats=ddFormatsWithDesc[0];
						String ddDesc=ddFormatsWithDesc[1];
						ddFormats=ddFormats.substring(ddFormats.indexOf(":")+1);
						StringTokenizer stkFormats=new StringTokenizer(ddFormats);
						while(stkFormats.hasMoreTokens())
						{
							String ddFormat=stkFormats.nextToken();
							if(ddFormat!=null && ddFormat.indexOf("#")>-1)
								ddFormat=StringUtils.replace(ddFormat,"#","");
%>
				<option value="<%=ddFormat+":"+ddFormat%>"><egui:intnl text='<%="monitor.detaileddiagnosis."+ddFormat%>'/></option>
<%
						}
					}
				}
%>
			</select>
		</td>
	</tr>
<%
			}
		}
%>
	<tr>
<%		if(from!=null && (from.equalsIgnoreCase("config") || from.equalsIgnoreCase("kpi")))
		{
%>
		<td class="font_bold11 padding4"  align="center" colspan="2">
			<table border="0" cellspacing="0" cellpadding="0" width="100%">
				<col width="48%"><col width="2%"><col width="48%">
				<tr>
					<td align="right"><input class="istam_button_bg" type="button" value="   Add   " onclick="<%=onAddButtonClickFunctionName%>" width="10px" tabindex="1" /></td>
					<td>&nbsp;</td>
					<td><input class="istam_button_bg" type="button" value="   OK   " onclick="<%=onOkButtonClickFunctionName%>" width="10px" tabindex="1" /></td>
				</tr>
			</table>
		</td>

<%
		}
		else
		{
%>
		<td align="center" colspan="2" class="font_bold11 padding4" ><input class="istam_button_bg" type="button" value="   OK   " onclick="<%=onOkButtonClickFunctionName%>" width="10px" tabindex="1" /></td>
<%
		}
%>
	</tr>
</table>
<%
	}
	else
	{
%>
<table width="100%" cellpadding="3" cellspacing="0" border="0">
		<tr>
			<td align="center" colspan="2" valign="middle" class="istam_ExclamationText">
				<img src="/final/images/clear.png" class="iconInformation"> <br> <egui:intnl text="monitor.common.No config tests enabled"/>!
			</td>
		</tr>
</table>
<%
	}
%>
<input type="hidden" id="graphType" value="<%=graphType%>"/>
<input type="hidden" id="from" value="<%=from%>"/>
<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>