<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.eg.*"%>
<%@ page import="java.text.*"%>
<%@ page import="com.egurkha.util.DateTimeTokenizer"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
try
{
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");

	IniUI iniUI = IniUI.getInstance();
	String currentDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");

	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	DateTimeTokenizer dtd = new DateTimeTokenizer();

	EgServerDashboardModel  egDashboard=new  EgServerDashboardModel();
	EgServerDashboardMGraphModel measureGraph=new EgServerDashboardMGraphModel();

	EgFusionChartUtil fusionChart=new EgFusionChartUtil();
	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();
	MeasuresDAO MeasuresDao = monitorDaoFactory.getMeasuresDAO();
	String sub="Search_Option";
	String searchavail=iniObj.getValue(sub,"NodeAvailable");
	int searchavailable = Integer.parseInt(searchavail);

	ErUtils erutils=new ErUtils();

	String subject=request.getParameter("subject");
	String tab=request.getParameter("tab");

	if(tab==null)
		tab="Application";

	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String subsystem=request.getParameter("subsystem");

	String hostName="";
	String portNo="";
	String sid="";
	String startTime="";
	String endTime="";
	String startHour="";
	String endHour="";
	String startMin="";
	String endMin="";
	String startSec="";
	String endSec="";
	String startDateTime="";
	String endDateTime="";
	String state="";
	String info="";
	String msmtHost="";
	String test="";
	String measure="";
	String selectstring="";

	long HOUR=60*60*1000;
	long DAY=24*60*60*1000;

	String hostNames[]=request.getParameterValues("hostName");
	if(hostNames!=null)
	{
		for(int i=0;i<hostNames.length;i++)
		{
			if(hostNames[i]!=null && hostNames[i].indexOf(":")!=-1)
			{
				compName=hostNames[i];
				break;
			}
		}
	}

	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);

	boolean isSystemTab=(tab!=null && tab.equalsIgnoreCase("System"));
	boolean isNetworkTab=(tab!=null && tab.equalsIgnoreCase("Network"));
	boolean isApplicationTab=(tab!=null && tab.equalsIgnoreCase("Application"));

	boolean ddEnabled=EgMemInfo.ddEnabled;

	if(isSystemTab)
	{
		subject="System_Dashboard_Metrics";
	}
	else if(isNetworkTab)
	{
		subject="Network_Dashboard_Metrics";
	}
	else
	{
		subject=compType;
	}

	String s_specificsubject=iniObj.getValue("CommonDashboardConiguration",compType);

	if((isSystemTab || isNetworkTab) && s_specificsubject!=null && s_specificsubject.equalsIgnoreCase("yes"))
	{
		subject=compType;
	}

	egDashboard.setSubject(subject);


	SimpleDateFormat  sdf=new SimpleDateFormat("MM/dd/yyyy HH:mm");
	SimpleDateFormat sf=new SimpleDateFormat("MM/dd/yyyy");
	SimpleDateFormat sf1=new SimpleDateFormat("dd/MM/yyyy");
	SimpleDateFormat testTableDateFmt=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	java.util.Date end_Date=new java.util.Date();
	java.util.Date start_Date=new java.util.Date(end_Date.getTime()-(HOUR));
	java.util.Date start_DateForDay=new java.util.Date(end_Date.getTime()-(DAY));

	String s_startTime=sdf.format(start_Date);
	String s_startTimeForDay=sdf.format(start_DateForDay);
	String s_endTime=sdf.format(end_Date);

	String fromCitrixApplication=request.getParameter("fromCitrixApplication");
	boolean isFromCitrixApplication=(fromCitrixApplication!=null && fromCitrixApplication.equalsIgnoreCase("true"));
	String user=request.getParameter("selectedInfo");
	String graphType="citrixuser";
	if(isFromCitrixApplication)
	{
		graphType="citrixapps";
	}
	if(!isFromCitrixApplication)
	{
		if(user!=null && !user.equalsIgnoreCase("undefined") && !user.trim().equalsIgnoreCase("null"))
			user="+"+user.trim();

		Vector ctxUsers=(Vector)allTestInfos.get("CtxXpUserTest");
		selectstring=request.getParameter("selectstring");//noorul

		Vector infoselect=new Vector();
	if(selectstring!=null && !selectstring.equals(""))
	{
		if(!selectstring.startsWith("*") && !selectstring.contains("*"))
		{
			for(int i=0;i<ctxUsers.size();i++)
			{
				String infor=(String)ctxUsers.get(i);
				String infosearch = infor.toLowerCase();
				selectstring = selectstring.toLowerCase();
				if(infosearch.indexOf(selectstring)!=-1)
				{
				infoselect.add(infor);
				}
			}
		}
		else if(selectstring.startsWith("*"))
		{
			for(int i=0;i<ctxUsers.size();i++)
			{
				String infor=(String)ctxUsers.get(i);
				infor=infor.substring(infor.indexOf("+")+1,infor.length());
				String infosearch = infor.toLowerCase();
				String selects=selectstring.substring(selectstring.indexOf("*")+1,selectstring.length());
				selects = selects.toLowerCase();
				boolean infose=infosearch.startsWith(selects);
				if(infose==true)
				{
					infoselect.add(infor);
				}
			}
		}
		else if(selectstring.endsWith("*"))
		{
			for(int i=0;i<ctxUsers.size();i++)
			{
				String infor=(String)ctxUsers.get(i);
				infor=infor.substring(infor.indexOf("+")+1,infor.length());
				String infosearch = infor.toLowerCase();
				String selects=selectstring.substring(0,selectstring.indexOf("*"));
				selects = selects.toLowerCase();
				boolean infose=infosearch.endsWith(selects);
				if(infose==true)
				{
					infoselect.add(infor);
				}
			}
		}
	}
		if(ctxUsers!=null && ctxUsers.size()>0)
		{
			if(selectstring!=null && !selectstring.equals(""))
			{
				String fla="citrix";
%>
<table border="0" bordercolor="green" class="padding4" cellpadding="0" cellspacing="0" width="100%" height="100%">
	<tr>
		<td width="20%" align="left" valign="top" style="padding-right:0px">
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="vm  border">
				<tr>
					<td width="100%" class="tdborder2_jvm"> 
						<div id="citrixUserDiv" class="div_scroll" style="width:100%;border:0px solid #ff0000">
								<div id="searchdiv">
									<table cellpadding="2" cellspacing="0" border="0" width="100%">
										<tr>
											<td align="right" class="eg_75bold">
												<a id="eg_monlink" onClick='searchBack("<%=fla%>");' style="cursor:pointer">
												<img src='/final/monitor/eg_images/back-arrow.gif' border='0'>
												&nbsp;<egui:intnl text="monitor.dashboard.All Users"/>
												</a>
											</td>
										</tr>
									</table>
								</div>
							<div class="dtree">
								<div id="dd0" class="clip" style="border: 0px solid rgb(255, 0, 0);">
									<div class="dTreeNode" style="font-size: 7.5pt; color: rgb(0, 0, 0);" oncontextmenu="return false;">
										<img class="png" id="id1" src="/final/monitor/eg_images/users.png" alt="" border="0">
										<span><b>Citrix Users</b></span>
									</div>
<%
				for(int i=0;i<infoselect.size();i++)
				{
					String ctinfo=(String)infoselect.get(i);
				if(user==null || user.trim().equals("") || user.trim().equalsIgnoreCase("null") || user.equalsIgnoreCase("undefined"))
					user=ctinfo;

				boolean isSelectedUser=false;
				if(user!=null && user.equals(ctinfo))
					isSelectedUser=true;
%>
									<div id="dd1" class="clip" style="border: 0px solid rgb(255, 0, 0); display: block;">
										<div class="dTreeNode"  oncontextmenu="return false;">
<%
				if(i==infoselect.size()-1)
				{
%>
										<img src="/final/admin/eg_images/tree/joinbottom.gif" alt="">
<%
				}
				else
				{
%>
										<img src="/final/admin/eg_images/tree/join.gif" alt="">
<%
				}
%>
										<img class="png" id="id2"src="/final/monitor/eg_images/user.png" alt="" border="0">
										<span><a class="<%=(isSelectedUser)?"nodeSel eg_monlink mouse":"eg_monlink mouse"%>" onclick="javascript:changeGraphType1('<%=subsystem%>','<%=tab%>','citrixuser','true','','','<%=(String)ctxUsers.get(i)%>','<%=selectstring%>')"><%=com.egurkha.util.StringUtils.replace((String)infoselect.get(i),"+","")%></a>
										</span>
										</div>
									</div>
<%
			}
			}
			else
			{
%>
<table border="0" bordercolor="green" class="padding4" cellpadding="0" cellspacing="0" width="100%" height="100%">
	<tr>
		<td width="20%" align="left" valign="top" style="padding-right:0px">
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="vm  border">
				<tr>
					<td width="100%" class="tdborder2_jvm"> 
						<div id="citrixUserDiv" class="div_scroll" style="width:100%;border:0px solid #ff0000">
<%
		if(ctxUsers.size()>searchavailable)
		{
		String flag="citrix";
%>
					<jsp:include page="EgSearchOption.jsp" flush="true" >
					<jsp:param name="flag" value="<%=flag%>" />
					<jsp:param name="compName" value="<%=compName%>" />
					<jsp:param name="compType" value="<%=compType%>" />
					<jsp:param name="tab" value="<%=tab%>" />
					
					</jsp:include>
<%
			}
%>
							<div class="dtree">
								<div id="dd0" class="clip" style="border: 0px solid rgb(255, 0, 0);">
									<div class="dTreeNode" style="font-size: 7.5pt; color: rgb(0, 0, 0);" oncontextmenu="return false;">
										<img class="png" id="id1" src="/final/monitor/eg_images/users.png" alt="" border="0">
										<span><b>Citrix Users</b></span>
									</div>
<%
			for(int i=0;i<ctxUsers.size();i++)
			{
				String tempUser=(String)ctxUsers.get(i);
				if(user==null || user.trim().equals("") || user.trim().equalsIgnoreCase("null") || user.equalsIgnoreCase("undefined"))
					user=tempUser;

				boolean isSelectedUser=false;
				if(user!=null && user.equals(tempUser))
					isSelectedUser=true;
%>
									<div id="dd1" class="clip" style="border: 0px solid rgb(255, 0, 0); display: block;">
										<div class="dTreeNode"  oncontextmenu="return false;">
<%
				if(i==ctxUsers.size()-1)
				{
%>
										<img src="/final/admin/eg_images/tree/joinbottom.gif" alt="">
<%
				}
				else
				{
%>
										<img src="/final/admin/eg_images/tree/join.gif" alt="">
<%
				}
%>
										<img class="png" id="id2"src="/final/monitor/eg_images/user.png" alt="" border="0">
											<span><a class="<%=(isSelectedUser)?"nodeSel eg_monlink mouse":"eg_monlink mouse"%>" onclick="javascript:changeGraphType1('<%=subsystem%>','<%=tab%>','citrixuser','true','','','<%=(String)ctxUsers.get(i)%>','')"><%=com.egurkha.util.StringUtils.replace((String)ctxUsers.get(i),"+","")%></a></span>
										</div>
									</div>
<%
				}
			}
%>
								</div>
							</div>
						</div>
					</td>
				</tr>
			</table>
		</td>
		<td width="80%" height="100%"  valign="top">
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="table   border_jvm">
				<tr>
					<td width="100%" class="tdborder_jvm"> 
					<div id="citrixUserSummaryDiv" class="div_scroll" style="width:100%;border:0px solid #ff0000">
						<table cellpadding="0" cellspacing="0" border="0" width="100%" class="main_padding4">
<%
			String descriptor=com.egurkha.util.StringUtils.replace(user,"+","");
%>
							<tr>
								<td valign="top">
									<table cellpadding="0" class="main_padding4" cellspacing="0" border="0" width="100%">
										<tr>
<%
			String s_circleIniVal=iniObj.getValue(subject,"Application_Overview_CircleChart");

			Vector circleTestMeasures=egDashboard.getTokensAsVector(s_circleIniVal,",");

			for(int i=0;i<circleTestMeasures.size();i++)
			{
				String tempTestMeasure=(String)circleTestMeasures.get(i);
				test=tempTestMeasure.substring(0,tempTestMeasure.indexOf(":"));
				measure=tempTestMeasure.substring(tempTestMeasure.indexOf(":")+1);

				msmtHost=(String)allMsmtHosts.get(test);

				String measureForDB=dbInfo.getColumnForMeasure(test,measure);
				String measureValue=dashboardDAO.getCurrentMeasure(hostName,portNo,com.egurkha.util.StringUtils.replace(user,"|plus|","+"),test,measureForDB,msmtHost);

				String measureMapping=iniObj.getValue("Dashboard_measures_mapping",test+":"+measure);

				if(measureMapping==null || measureMapping.trim().equals(""))
					measureMapping=mappingInfo.getMeasureDescription(test,measure);

				Vector chartAttributes=new Vector();

				chartAttributes.add("bgColor='FFFFFF'");
				chartAttributes.add("upperLimit='100'");
				chartAttributes.add("lowerLimit='0'");
				chartAttributes.add("baseFontColor='FFFFFF'");
				chartAttributes.add("majorTMNumber='11'");
				chartAttributes.add("majorTMColor='FFFFFF'");
				chartAttributes.add("majorTMHeight='8'");
				chartAttributes.add("minorTMNumber='4'");
				chartAttributes.add("minorTMColor='FFFFFF'");
				chartAttributes.add("minorTMHeight='3'");
				chartAttributes.add("toolTipBorderColor='FFFFFF'");
				chartAttributes.add("toolTipBgColor='333333'");
				chartAttributes.add("gaugeOuterRadius='55'");
				chartAttributes.add("gaugeOriginX='80'");
				chartAttributes.add("gaugeOriginY='80'");
				chartAttributes.add("gaugeScaleAngle='270'");
				chartAttributes.add("placeValuesInside='1'");
				chartAttributes.add("gaugeInnerRadius='90%25'");
				chartAttributes.add("annRenderDelay='1'");
				chartAttributes.add("gaugeFillMix=''");
				chartAttributes.add("pivotRadius='8'");
				chartAttributes.add("showPivotBorder='0'");
				chartAttributes.add("pivotFillMix='{CCCCCC},{333333}'");
				chartAttributes.add("pivotFillRatio='20,80'");
				chartAttributes.add("showShadow='0'");
				chartAttributes.add("showBorder='0'");
				chartAttributes.add("baseFontSize='8'");

				chartAttributes.add("chartLeftMargin='0'");
				chartAttributes.add("chartRightMargin='0'");
				chartAttributes.add("chartTopMargin='0'");
				chartAttributes.add("chartBottomMargin='0'");


				String xmlForSteeCase=fusionChart.getXMLForSteelCase(measureValue,chartAttributes);
%>
											<td valign="top">
												<table cellpadding="2" cellspacing="0" border="0">
													<tr>
														<td class="eg_75bold"><%=measureMapping%>(<%=tablesInfo.getUnitForMeasure(test,measure)%>)</td>
													</tr>
													<tr>
														<td align="left" style="padding:0px">
															<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="150" height="150" id="StackedColumn3D" >
																<param name="movie" value="/final/FusionCharts/swf/AngularGauge.swf" />
																<param name="FlashVars" value="&dataXML=<%=xmlForSteeCase%>&chartWidth=150&chartHeight=150">
																<param name="quality" value="high" />
																<embed src="/final/FusionCharts/swf/AngularGauge.swf" flashVars="&dataXML=<%=xmlForSteeCase%>" quality="high" width="150" height="150" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
															</object> -->

															<div id="chartAngularGaugeContainer<%=i%>"  style="height:100%;"></div>
															<script type="text/javascript">
																if  ( FusionCharts( "myAngularGaugeChartId<%=i%>" ) )
																		FusionCharts( "myAngularGaugeChartId<%=i%>" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/AngularGauge.swf","myAngularGaugeChartId<%=i%>", "150", "150","0","1");
																myChart.setXMLData("<%=xmlForSteeCase%>");
																myChart.setTransparent(true);
																myChart.render("chartAngularGaugeContainer<%=i%>");
															</script>
														</td>
													</tr>
												</table>
											</td>
<%
			}

			String user_test="CtxXpUserTest";

			String s_lastMsmtTime=dashboardDAO.lastMeasurementTimeForTest(compType,hostName,test,tab);

			Date lastMsmtTime=new Date();
			if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
				lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
			else
				s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);

			lastMsmtTime.setHours(lastMsmtTime.getHours()-1);

			startTime=sf1.format(lastMsmtTime);

			String s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
			Vector vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

			startHour=lastMsmtTime.getHours()+"";
			startMin=lastMsmtTime.getMinutes()+":"+lastMsmtTime.getSeconds();

			lastMsmtTime.setHours(lastMsmtTime.getHours()+1);
			endTime=sf1.format(lastMsmtTime);

			s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
			vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

			endHour=lastMsmtTime.getHours()+"";
			endMin=lastMsmtTime.getMinutes()+":"+lastMsmtTime.getSeconds();


			String s_BarIniVal=iniObj.getValue(subject,"Application_Overview_BarChart");
			Vector barTestMeasures=egDashboard.getTokensAsVector(s_BarIniVal,",");
			for(int i=0;i<barTestMeasures.size();i++)
			{
				String tempTestMeasure=(String)barTestMeasures.get(i);
				test=tempTestMeasure.substring(0,tempTestMeasure.indexOf(":"));
				measure=tempTestMeasure.substring(tempTestMeasure.indexOf(":")+1);

				msmtHost=(String)allMsmtHosts.get(test);

				String measureForDB=dbInfo.getColumnForMeasure(test,measure);
				//String measureValue=dashboardDAO.getCurrentMeasure(hostName,portNo,com.egurkha.util.StringUtils.replace(user,"|plus|","+"),test,measureForDB,msmtHost);

				String measureMapping=iniObj.getValue("Dashboard_measures_mapping",test+":"+measure);

				if(measureMapping==null || measureMapping.trim().equals(""))
					measureMapping=mappingInfo.getMeasureDescription(test,measure);

				Vector chartAttributes=new Vector();
				chartAttributes.add("palette='3'");
				chartAttributes.add("bgColor='ffffff'");
				chartAttributes.add("cylFillColor='#FC8D59'");
				chartAttributes.add("cylRadius='15'");
				chartAttributes.add("ticksOnRight='0'");
				chartAttributes.add("tickMarkGap='0'");
				
				chartAttributes.add("showBorder='0'");
				chartAttributes.add("chartLeftMargin='0'");
				chartAttributes.add("chartRightMargin='0'");
				chartAttributes.add("chartTopMargin='0'");
				chartAttributes.add("chartBottomMargin='0'");
				chartAttributes.add("adjustTM='0'");
				String unitForMeasure=tablesInfo.getUnitForMeasure(test,measure);
				if(unitForMeasure!=null && unitForMeasure.equalsIgnoreCase("number"))
				{
					chartAttributes.add("decimals='0'");
					chartAttributes.add("majorTMNumber='4'");
					chartAttributes.add("minorTMNumber='4'");
				}
				else
				{
					chartAttributes.add("majorTMNumber='5'");
					chartAttributes.add("minorTMNumber='4'");
				}
				chartAttributes.add("majorTMThickness='1'");
				chartAttributes.add("minorTMThickness='1'");
				chartAttributes.add("majorTMHeight='6'");
				chartAttributes.add("minorTMHeight='3'");

				String xmlForCylinder=fusionChart.getXMLForCylinderGauge(test,measure,compType,hostName,portNo,com.egurkha.util.StringUtils.replace(user,"|plus|","+"),msmtHost,"NULL",sid,chartAttributes,tab);
%>
											<td valign="top" align="right">
												<table cellpadding="2" cellspacing="0" border="0">
													<tr>
														<td align="center" valign="top" style="height:50px" class="eg_75bold"><%=measureMapping%>(<%=unitForMeasure%>)</td>
													</tr>
													<tr>
														<td align="right" valign="top">
<%				if(xmlForCylinder!=null && !xmlForCylinder.trim().equals(""))
				{
%>

														<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90" height="130" id="StackedColumn3D" >
															<param name="movie" value="/final/FusionCharts/swf/Cylinder.swf" />
															<param name="FlashVars" value="&dataXML=<%=xmlForCylinder%>&chartWidth=90&chartHeight=130">
															<param name="quality" value="high" />
															<embed src="/final/FusionCharts/swf/Cylinder.swf" flashVars="&dataXML=<%=xmlForCylinder%>" quality="high" width="90" height="130" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
														</object> -->

														<div id="chartCylinderContainer<%=i%>"  style="height:100%;"></div>
														<script type="text/javascript">
															if  ( FusionCharts( "myCylinderChartId<%=i%>" ) )
																	FusionCharts( "myCylinderChartId<%=i%>" ).dispose();
															var myChart = new FusionCharts( "/final/FusionCharts/swf/Cylinder.swf","myCylinderChartId<%=i%>", "90", "130","0","1");
															myChart.setXMLData("<%=xmlForCylinder%>");
															myChart.setTransparent(true);
															myChart.render("chartCylinderContainer<%=i%>");
														</script>
<%
				}
				else
				{
%>
														<table border="0" cellspacing="0" cellpadding="0" width="100%">
															<tr>
																<td align="center">
																	<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No Measures available"/>!					
																</td>
															</tr>
														</table>
<%
				}
%>
														</td>
													</tr>
												</table>
											</td>
<%
			}
%>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td>
									<table width="100%" border="0" cellpadding="0" cellspacing="0" class="vmborder">
										<tr>
											<td colspan="2" height="20px" align="center" class="eg_75bold jvm_header" >Citrix Sessions-Summary</td>
										</tr>
										<tr>
											<td width="100%">
												<table width="100%" border="0" cellpadding="2" cellspacing="0" class="tableborder_jvm">
<%
			String ddtest="CtxSessionTest";
			String ddmeasure="Active_sessions";
			String colNamesForQuery="Username,Idle_time,Logon_time";
			String flag="1";
			String desc="+";

			msmtHost=(String)allMsmtHosts.get(ddtest);

			EgDiagnosisBean dd=new EgDiagnosisBean();
			dd.getDescription(ddtest,ddmeasure);


			s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(ddtest,ddmeasure,hostName,portNo,"NULL",desc,msmtHost);

			lastMsmtTime=new java.util.Date();
			if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
				lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
			else
				s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);

			startTime=sf.format(lastMsmtTime);
			endTime=sf.format(lastMsmtTime);

			s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
			vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

			startHour=(String)vec_times.get(0);
			endHour=(String)vec_times.get(0);
			startMin=(String)vec_times.get(1);
			endMin=(String)vec_times.get(1);

			int i_endMin=Integer.parseInt(endMin)+1;
			endMin=i_endMin+"";

			ArrayList a_results=dd.getDiagnosisData(hostName,portNo,"NULL",ddtest,ddmeasure,desc,startTime,endTime, startHour, endHour,startMin+":"+lastMsmtTime.getSeconds(),endMin+":"+lastMsmtTime.getSeconds(),flag,colNamesForQuery,msmtHost);

			ArrayList allDatas=new ArrayList();
			if(a_results.size()>=2)
			{
				allDatas=(ArrayList)a_results.get(1);
			}

			ArrayList headers=new ArrayList();
			//headers.add("Username");
			headers.add("Idletime");
			headers.add("Login time");

			for(int i=0;i<allDatas.size();i++)
			{
				ArrayList singleData=(ArrayList)allDatas.get(i);

				if(singleData!=null && singleData.contains(descriptor))
				{
					singleData.remove(descriptor);
					for(int j=0;j<singleData.size();j++)
					{
%>
													<tr>
														<td class="tdborder_jvm"><%=(String)headers.get(j)%></td>
														<td class="tdborder_jvm"><%=(String)singleData.get(j)%></td>
													</tr>
<%
					}
					break;
				}
			}

			boolean isDataAvail=false;

			ddtest="CtxDisconnectsTest";
			ddmeasure="Quick_reconnects";

			msmtHost=(String)allMsmtHosts.get(ddtest);

			EgDiagnosisBean dd1=new EgDiagnosisBean();
			dd1.getDescription(ddtest,ddmeasure);

			s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(ddtest,ddmeasure,hostName,portNo,"NULL",desc,msmtHost);

			if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
				lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
			else
				s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);

			startTime=sf.format(lastMsmtTime);
			endTime=sf.format(lastMsmtTime);

			s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
			vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

			startHour=(String)vec_times.get(0);
			endHour=(String)vec_times.get(0);
			startMin=(String)vec_times.get(1);
			endMin=(String)vec_times.get(1);

			i_endMin=Integer.parseInt(endMin)+1;
			endMin=i_endMin+"";

			a_results=dd1.getDiagnosisData(hostName,portNo,"NULL",ddtest,ddmeasure,desc,startTime,endTime, startHour, endHour,startMin+":"+lastMsmtTime.getSeconds(),endMin+":"+lastMsmtTime.getSeconds(),flag,"",msmtHost);

			ArrayList tempList=new ArrayList();
			if(a_results.size()>=2)
			{
				tempList=(ArrayList)a_results.get(1);
			}

			for(int i=0;i<tempList.size();i++)
			{
				ArrayList disconnectDDData=new ArrayList();

				if(tempList.get(i) instanceof ArrayList)
					disconnectDDData=(ArrayList)tempList.get(i);
				else if(tempList.get(i) instanceof String)
				{
					String tempStr=(String)tempList.get(i);
					disconnectDDData.addAll(egDashboard.getTokensAsVector(tempStr,"~!~"));
				}

				if(disconnectDDData!=null && disconnectDDData.contains(descriptor) && disconnectDDData.size()>4)
				{
%>
													<tr>
														<td class="tdborder_jvm">Client Type</td>
														<td class="tdborder_jvm"><%=(String)disconnectDDData.get(2)%></td>
													</tr>
													<tr>
														<td class="tdborder_jvm">Disconnected Time</td>
														<td class="tdborder_jvm"><%=(String)disconnectDDData.get(3)%></td>
													</tr>
													<tr>
														<td class="tdborder_jvm">Disconnected Duration</td>
														<td class="tdborder_jvm"><%=(String)disconnectDDData.get(4)%></td>
													</tr>
<%
					isDataAvail=true;
					break;
				}
			}

			ddtest="CtxXpUserTest";
			ddmeasure="No_of_sessions";

			String infoForBilling=user;
			long userDuration=egDashboard.getCitrixUserDuration(compType,hostName,portNo,ddtest,infoForBilling,s_startTimeForDay,s_endTime);

			String userDurationStr=egDashboard.getDateDifferenceString(userDuration);

			if(userDurationStr==null || userDurationStr.trim().equals(""))
				userDurationStr="-";
%>
													<tr>
														<td class="tdborder_jvm">Total Connection Time(24 hours)</td>
														<td valign="top" class="tdborder_jvm"><%=userDurationStr%></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
<%
				colNamesForQuery="PID,ProcName,Cpu_util,Memory_util,IO_reads,IO_writes,Page_faults,Virtual_memory,Handles,Published_dname";

				String ddTimeline="1 hour";
				Vector times=egDashboard.getStartEndDateTimeForMeasure(ddTimeline);

				if(times!=null && times.size()>=4)
				{
					startTime=(String)times.get(0);
					endTime=(String)times.get(1);
					startHour=(String)times.get(2);
					endHour=(String)times.get(3);
				}

				msmtHost=(String)allMsmtHosts.get(ddtest);

				EgDiagnosisBean dd2=new EgDiagnosisBean();
				dd2.getDescription(ddtest,ddmeasure);

				String userTitle="Citrix User Applications Summary";
%>
							<TR>
								<TD>
									<table width="100%" border="0" cellpadding="2" cellspacing="0" class="vmborder">
										<tr>
											<td align="center" class="eg_75bold jvm_header "><%=userTitle%></td>
										</tr>
										<tr>
											<td style="padding:0px" height="100%">
												<table width="100%" border="0" cellpadding="2" cellspacing="0" class="tableborder_jvm" height="100%"><col width="35%"><col width="5%"><col width="10%"><col width="10%"><col width="18%"><col width="22%">
<%
			a_results=dd2.getDiagnosisData(hostName,portNo,"NULL",ddtest,ddmeasure,user,startTime,endTime, startHour, endHour,end_Date.getMinutes()+":"+end_Date.getSeconds(),end_Date.getMinutes()+":"+end_Date.getSeconds(),flag,colNamesForQuery,msmtHost);
			if(a_results!=null && a_results.size()>0)
			{
				Vector process=new Vector();
				Vector cpu=new Vector();
				Vector memory=new Vector();

				String processName="";

				Hashtable processData=new Hashtable();
				if(a_results!=null && a_results.size()>0)
				{
					ArrayList lastData=(ArrayList)a_results.get(1);
					if(lastData!=null && lastData.size()>0)
					{
						Iterator itr=lastData.iterator();
						while(itr.hasNext())
						{
							ArrayList data1=(ArrayList)itr.next();
							Vector value=new Vector();
							processName=(String)data1.get(1);
							if(processData.containsKey(processName))
							{
								Vector tempVec=(Vector)processData.get(processName);
								int count=((Integer)tempVec.get(0)).intValue();
								count++;
								double cpuVal=Double.parseDouble((String)tempVec.get(1));
								double memoryVal=Double.parseDouble((String)tempVec.get(2));
								double tempcpuVal=Double.parseDouble((String)data1.get(2));
								double tempmemoryVal=Double.parseDouble((String)data1.get(3));
								String cpuValStr=erutils.round((cpuVal+tempcpuVal),2);
								String memoryValStr=erutils.round((memoryVal+tempmemoryVal),2);
								processData.remove(processName); 
								value.add(new Integer(count));
								value.add(cpuValStr);
								value.add(memoryValStr);
							}
							else
							{
								value.add(new Integer(1));
								value.add(data1.get(2));
								value.add(data1.get(3));
							}

							long process_usedsummary=egDashboard.getCitrixProcessDuration(compType,hostName,portNo,ddtest,descriptor,processName,s_startTimeForDay,s_endTime);

							String s_process_usedsummary=egDashboard.getDateDifferenceString(process_usedsummary);

							if(s_process_usedsummary==null || s_process_usedsummary.trim().equals(""))
								s_process_usedsummary="-";

							value.add(data1.get(9));
							value.add(s_process_usedsummary);
							processData.put(processName,value);
						}
					}
				}
%>
													<tr>
														<td class="eg_75bold tdborder2_jvm" style="padding-top:0px;padding-bottom:0px">
															<table cellspacing="0" cellpadding="0"   border="0" width="100%">
																<tr>
																	<td>
																		<a class="eg_monlink" href="" onclick="this.blur();return sortTable('CitrixUserAppTable',0,0,4,0);"><span class="eg_75bold">Applications</span></a>
																	</td>
																	<td style="width:15px" >
																		<img id="imgdd0" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortTable('CitrixUserAppTable',0,0,4,0);" style="display:none"/>
																	</td>
																</tr>
															</table>
														</td>
														<td class="eg_75bold tdborder2_jvm" style="padding-top:0px;padding-bottom:0px">
															<table cellspacing="0" cellpadding="0"   border="0" width="100%">
																<tr>
																	<td>
																		<a class="eg_monlink" href="" onclick="this.blur();return sortTable('CitrixUserAppTable',1,0,4,1);"><span class="eg_75bold">Instances</span></a>
																	</td>
																	<td style="width:15px" ><img id="imgdd1" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortTable('CitrixUserAppTable',1,0,4,1);" style="display:none"/>
																	</td>
																</tr>
															</table>
														</td>
														<td class="eg_75bold tdborder2_jvm" style="padding-top:0px;padding-bottom:0px">
															<table cellspacing="0" cellpadding="0" border="0" width="100%">
																<tr>
																	<td nowrap>
																		<a class="eg_monlink" href="" onclick="this.blur();return sortTable('CitrixUserAppTable',2,0,4,2);"><span class="eg_75bold">%Cpu</span></a>
																	</td>
																	<td style="width:15px" >
																		<img id="imgdd2" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortTable('CitrixUserAppTable',2,0,4,2);" style="display:none"/>
																	</td>
																</tr>
															</table>
														</td>
														<td class="eg_75bold tdborder2_jvm" style="padding-top:0px;padding-bottom:0px">
															<table cellspacing="0" cellpadding="0"   border="0" width="100%">
																<tr>
																	<td nowrap>
																		<a class="eg_monlink" href="" onclick="this.blur();return sortTable('CitrixUserAppTable',3,0,4,3);"><span class="eg_75bold">%Memory</span></a>
																	</td>
																	<td style="width:15px" >
																		<img id="imgdd3" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortTable('CitrixUserAppTable',3,0,4,3);" style="display:none"/>
																	</td>
																</tr>
															</table>
														</td>
														<td class="eg_75bold tdborder2_jvm" style="padding-top:0px;padding-bottom:0px">
															<table cellspacing="0" cellpadding="0"   border="0" width="100%">
																<tr>
																	<td nowrap>
																		<a class="eg_monlink" href="" onclick="this.blur();return sortTable('CitrixUserAppTable',4,0,4,4);"><span class="eg_75bold">Published Desktop</span></a>
																	</td>
																	<td style="width:15px" >
																		<img id="imgdd4" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortTable('CitrixUserAppTable',4,0,4,4);" style="display:none"/>
																	</td>
																</tr>
															</table>
														</td>
														<td class="tdborder2_jvm eg_75bold" style="padding-top:0px;padding-bottom:0px" nowrap> AppProcess Usage Duration <br>(24 hours)
														</td>
													</tr>
													<tbody id="CitrixUserAppTable" name="CitrixUserAppTable">
<%
				ArrayList processDatakey=new ArrayList(processData.keySet());

				Collections.sort(processDatakey,String.CASE_INSENSITIVE_ORDER);

				Iterator processItr=processDatakey.iterator();
				while(processItr.hasNext())
				{
					processName=(String)processItr.next();
					Vector value=(Vector)processData.get(processName);
					String publishedDeskTop=(String)value.get(3);
%>
													<tr>
														<td valign="top" class="tdborder_jvm"><%=processName%></td>
														<td valign="top" class="tdborder_jvm"><%=value.get(0)%></td>
														<td valign="top" class="tdborder_jvm"><%=value.get(1)%></td>
														<td valign="top" class="tdborder_jvm"><%=value.get(2)%></td>
<%
	if(publishedDeskTop!=null && publishedDeskTop.length()<20)
	{
%>
														<td valign="top" class="tdborder_jvm"><%=publishedDeskTop%></td>
<%
	}
	else
	{

%>
														<td valign="top" class="tdborder_jvm">
															<table border="0" cellspacing="0" cellpadding="1" align="left">
<%
		int idx = publishedDeskTop.length()/20;
		int index = 0;
		for (int j=0; j<idx; j++)
		{
%>
																<tr>
																	<td>
																		<%=publishedDeskTop.substring(index,index+20)%>
																	</td>
																</tr>
<%
			index = index+20;
		}
%>
																<tr>
																	<td>
																		<%=publishedDeskTop.substring(index)%>
																	</td>
																</tr>
															</table>
														</td>
<%
	}
%>
														
														<td valign="top" class="tdborder_jvm"><%=value.get(4)%></td>
													</tr>
<%
				}
%>
													</tbody>
<%
			}
			else
			{
%>
													<tr>
														<td colspan="5" valign="center" align="center"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No Measures available"/>!</td>
													</tr>
<%
			}
%>

													<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortTable('CitrixUserAppTable',0,0,4,0);" style="visibility:hidden;display:none;"> 
												</table>
											</TD>
										</TR>
									</TABLE>
								</td>
							</tr>
						</table>
						</div>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<%
		}
		else
		{
%>
<table cellpadding="0" cellspacing="0" border="0" width="100%" height="100%">
	<tr>
		<td  width="100%" height="100%" align="center" valign="center"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br > <egui:intnl text="monitor.dashboard.No Citrix users available"/>!</td>
	</tr>
</table>
<%
		}
	}
	else
	{
		String ddtest="CtxAppTest";
		String ddmeasure="Number_of_processes,CtxAppTest:Cpu_util,CtxAppTest:Memory_util";
		String measuresForDB="";
		Vector measures=new Vector();
		StringTokenizer stkTokens=new StringTokenizer(ddmeasure,",");
		int countTokens=stkTokens.countTokens();
		while(stkTokens.hasMoreTokens())
		{
			String testMeasure=stkTokens.nextToken();
			String measName=testMeasure.substring(testMeasure.indexOf(":")+1,testMeasure.length());
			measures.add(measName);
			measuresForDB+=","+dbInfo.getColumnForMeasure(ddtest,measName);
		}

		if(measuresForDB.indexOf(",")==0)
		{
			measuresForDB=measuresForDB.substring(1,measuresForDB.length());
		}

		msmtHost=(String)allMsmtHosts.get(ddtest);

		Vector allValuesForInfo=dashboardDAO.getCurrentForAllInfos(hostName,portNo,ddtest,measuresForDB,msmtHost);
		String tableTitle=iniObj.getValue("Dashboard_Comparison_TableTitle",ddtest);
		if(tableTitle!=null && tableTitle.equals(""))
		{
			tableTitle=mappingInfo.getTestDescription(ddtest);
		}

		String s_infomapping=iniObj.getValue("Dashboard_Info_Mapping",ddtest);
		String rsTableName="CitrixAppSummary";
%>
<table border="0" bordercolor="green" class="padding6" cellpadding="0" cellspacing="0" width="100%" height="100%">
	<tr>
		<td valign="top">
			<table border="0" cellspacing="0" cellpadding="0" width="100%" class="vmborder" height="100%">
				<tr>
					<td class="eg_75bold jvm_header" height="20px" style="padding-left:4px"><%=tableTitle%></td>
				</tr>
<%
	if(allValuesForInfo!=null && allValuesForInfo.size()>0)
	{
%>
				<tr>
					<td>
						<div id="citrixAppDiv" class="div_scroll" style="height:338px;border:0px solid #ff0000;">
						<table cellspacing="0" cellpadding="2" class="tableborder_jvm"  border="0" width="100%">
							<tr>
								<td class="eg_75bold tdborder2_jvm" style="padding-top:0px;padding-bottom:0px">
									<table cellspacing="0" cellpadding="0"   border="0" width="100%">
										<tr>
											<td ><a class="eg_monlink" href="" onclick="this.blur();return sortTable('<%=rsTableName%>','0',0,3,'0');"><span class="eg_75bold"><egui:intnl text ='<%="monitor.dashboard."+s_infomapping%>'/>
											</a></span></td>
											<td style="width:15px" ><img id="imgdd0" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortTable('<%=rsTableName%>',0,0,3,'0');" style="display:none"/></td>
										</tr>
									</table>
								</td>
<%
		int imgcnt=0;
		for(int i=0;i<measures.size();i++)
		{
			measure=(String)measures.get(i);
			String tableHeader=iniObj.getValue("Dashboard_tableheader_mapping",ddtest+":"+measure);
			if(tableHeader!=null && tableHeader.equals(""))
			{
				tableHeader=mappingInfo.getMeasureDescription(ddtest,measure);
				tableHeader+="("+tablesInfo.getUnitForMeasure(ddtest,measure)+")";
			}
%>
								<td class="eg_75bold tdborder2_jvm" >
									<table cellspacing="0" cellpadding="0"   border="0" width="100%">
										<tr>
											<td ><a class="eg_monlink" href="" onclick="this.blur();return sortTable('<%=rsTableName%>',<%=(i+1)%>,0,3,<%=(imgcnt+1)%>);">
											<span class="eg_75bold"><%=tableHeader%></span></a></td>
											<td style="width:15px" ><img id="imgdd<%=(imgcnt+1)%>" src="/final/monitor/eg_images/arrow_up_black_small.gif" onclick="this.blur();return sortTable('<%=rsTableName%>',<%=(i+1)%>,0,3,<%=(imgcnt+1)%>);" style="display:none"/></td>
										</tr>
									</table>
								</td>
<%
			imgcnt++;
		}
%>
							</tr>
							<tbody name="<%=rsTableName%>" id="<%=rsTableName%>">
<%
		if(allValuesForInfo!=null && allValuesForInfo.size()>0)
		{
			for(int i=0;i<allValuesForInfo.size();i+=measures.size()+1)
			{
				info=(String)allValuesForInfo.get(i);
				info=com.egurkha.util.StringUtils.replace(info,"+","");
%>
							<tr>
								<td class="tdborder_jvm" valign="top"><%=info%></td>
<%
				for(int j=1;j<=measures.size();j++)
				{
					measure=(String)measures.get(j-1);
					String value=(String)allValuesForInfo.get(j+i);
					if(!testerInfo.getAllowNegativeValues(ddtest,measure) && (value!=null) && (value.startsWith("-") || value.trim().equals("")))
					{
						value = "-";
					}
%>
								<td class="tdborder_jvm" valign="top"><%=value%></td>
<%
				}
%>
							</tr>
<%
			}
		}
		
%>
							</tbody>
						</table>
						</div>
						<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortTable('<%=rsTableName%>',0,0,3,0);" style="visibility:hidden;display:none;"> 
					</td>
				</tr>
<%
	}
	else
	{
%>
				<tr>
						<td colspan="0" valign="center" align="center" border="3"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"><br><egui:intnl text="monitor.dashboard.No Measures available"/>!</td>
				</tr>
<%
	}
%>

			</table>
		</td>
	</tr>
</table>
<%
		
	}
%>
<input type="hidden" id="graphType" value="<%=graphType%>"/>
<input type="hidden" id="selectedInfo" value="<%=user%>"/>
<%
	
	if(request.getQueryString()!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+compType+"&subsystem="+subsystem+"&host="+compName+"&selectedInfo="+user+"&tab="+tab+"&graphType="+graphType+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&selectedInfo="+user+"&tab="+tab+"&subsystem="+subsystem+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>