<%
/*******************************************************************************
*	File name		: XenBlocks.jsp
*	Purpose			: This page contains all the blocks for Xen DDC Application 
					  Dashboard relies on Xen BrokerOverview page
*	Version			: eG 5.4
*	Creation Date	: 22/07/2011.
********************************************************************************/
%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ include file = "EgLoginTracker.jsp"%>

<%@ page import ="com.egurkha.monitor.*"%>
<%@ page import="com.eg.*"%>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import ="com.egurkha.monitor.*"%>
<%@ page import ="java.text.SimpleDateFormat"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="com.eg.EgFormatInfo"%>
<%@ page import="com.eg.EgMemInfo"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import= "com.eg.EgMappingInfo"%>
<%
	response.setHeader("catch-control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>

<%
try
{
	String tab = "";
	String sid = "";
	String val = "";
	String data = "";
	String gname = "";
	String count = "";
	String isXen = "";
	String color = "";
	String portNo = "";
	String domain = "";
	String macInfo = "";
	String machine = "";
	String hostName = "";
	String realName = "";
	String compName = "";
	String compType = "";
	String graphtype = "";
	String tmpCatalog = "";
	String radiotype = "history";
	String fromComparision = "";
	String totalDesktops = "";
	String isFormServer = "";
	String selectedMacName = "";
	tab = request.getParameter("tab");
	val = request.getParameter("value");
	data = request.getParameter("category");
	color = request.getParameter("color");
	gname = request.getParameter("gname");
	count = request.getParameter("count");
	isXen = request.getParameter("xennext");
	macInfo = request.getParameter("info");
	compName = request.getParameter("hostName");
	compType = request.getParameter("compType");
	radiotype = request.getParameter("radiotype");
	graphtype = request.getParameter("caption");
	isFormServer = request.getParameter("formserver");
	totalDesktops = request.getParameter("totalDesktops");
	fromComparision = request.getParameter("fromComparision");
	selectedMacName = request.getParameter("mac_name");
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals("") && !screenWidth.equals("null"))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals("") && !screenHeight.equals("null"))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}

	if( compName != null && !compName.equals("") )
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	String check1="";
	String check2="";
	String checked="checked";
	if( radiotype != null && radiotype.equalsIgnoreCase("history") )
	{
		radiotype="history";
		check1="checked";
	}
	else
	{
		radiotype="comparision";
		check2="checked";
	}

	IniUI iniUI = IniUI.getInstance();
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile formatIni = new IniFile(s_iniFile_dir+"eg_format.ini",true);
	IniFile iniObj = new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");

	SimpleDateFormat sf=new SimpleDateFormat("MM/dd/yyyy");
	SimpleDateFormat testTableDateFmt=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	SimpleDateFormat sdfMM=new SimpleDateFormat("MM/dd/yyyy");

	EgDbInfo MeasureDisplay = new EgDbInfo("manager");
	EgFormatInfo formatInfo = new EgFormatInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgXenDDCHelper ddcHelper = new EgXenDDCHelper();
	EgMappingInfo mappingInfo = new EgMappingInfo(trackerLanguage);
	EgFusionChartUtil fusionChart = new EgFusionChartUtil(trackerLanguage);
	EgServerDashboardModel egDashboard = new  EgServerDashboardModel();
	MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO = monitorDaoFactory.getServerDashBoardDAO();
	EgServerDashboardMGraphModel measureGraph = new EgServerDashboardMGraphModel();

	Hashtable allTestInfos = dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	Hashtable allMsmtHosts = dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	String UseCutOffFactor=iniObj.getValue("Dashboard_Settings","UseCutOffFactor");
	String msmtHost = "";
	if (isFormServer != null && (isFormServer.equalsIgnoreCase("Yes") || isFormServer.equalsIgnoreCase("true")))
	{
		msmtHost = (String) allMsmtHosts.get("XDGroupTest");
	}
	else
	{
		msmtHost = (String) allMsmtHosts.get("XDCtrlGroupTest");
	}

	if ( data != null && ( isXen != null && isXen.equals("yes") ) )
	{
		String iniValue = "";
		if(isFormServer!=null && (isFormServer.equalsIgnoreCase("Yes") || isFormServer.equalsIgnoreCase("true")))
		{
			iniValue = (String) iniObj.getValue(compType,tab+"_machine_category_Form");
		}
		else
		{
			iniValue = (String) iniObj.getValue(compType,tab+"_machine_category");
		}

%>
		<div id="div1" style="visibility:visible;display:block;border:0px solid red;height:155px;">
			<table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
				<tr>
<%
		if( iniValue != null && iniValue.length() > 0 )
		{
			Vector applyInfo = new Vector();
			Hashtable dataVector = new Hashtable();
			StringTokenizer tok = new StringTokenizer(iniValue,",");
			while(tok.hasMoreTokens())
			{
				String test = "";
				String measure = "";
				String testWithMeasures = (String) tok.nextToken();
				String iniData = testWithMeasures.substring(testWithMeasures.indexOf("$")+1);
				if( iniData.equalsIgnoreCase(data) )
				{
					test = testWithMeasures.substring(0,testWithMeasures.indexOf(":"));
					measure = testWithMeasures.substring(testWithMeasures.indexOf(":")+1,testWithMeasures.indexOf("$"));
					
					dataVector = (Hashtable) ddcHelper.getOverallDetailsFromDDData(hostName,portNo,msmtHost,test,measure,isFormServer);
					int size = dataVector.size();
				}
				
				String machineName = (String) dataVector.get("macName");
				if( machineName != null && machineName.indexOf("\\") > 0 )
				{
					machineName = com.egurkha.util.StringUtils.replace(machineName, "\\", "$");
				}
				boolean isServer = false;
				String chart = "";
				String chartHeight = "";

%>
<%
				for(int i=0;i<3;i++)
				{
					if(( dataVector != null && dataVector.size() > 0 ))
					{
						Vector chartAttributes=new Vector();
						String caption="";
						if( i==0 )
						{
							//chartAttributes.add("caption='Desktops'");
							isServer=true;
							applyInfo=(Vector)dataVector.get("server");
							caption="server";
						}
						if( i==1 )
						{
							//chartAttributes.add("caption='Catalogs'");
							applyInfo=(Vector)dataVector.get("catalog");
							caption="catalog";
							isServer=false;
						}
						if( i==2 )
						{
							//chartAttributes.add("caption='Desktop groups'");
							applyInfo=(Vector)dataVector.get("group");
							caption="group";
							isServer=false;
						}
						//chartAttributes.add("bgColor=' #FFFFFF'");
						//chartAttributes.add("numDivLines='0'");
						if( i==0 )
						{
							chartHeight="102px";
							chartAttributes.add("bgColor='#ffffff, FFFFFF'");
							chartAttributes.add("lowerLimit='0'");
							chartAttributes.add("upperLimit='50'");
							chartAttributes.add("dataStreamURL='DataProviders/Bulb.asp'");
							chartAttributes.add("refreshInterval='4'");
							chartAttributes.add("palette='5'");
							chartAttributes.add("showBorder='0'");
							chartAttributes.add("showValue='1'");
							chartAttributes.add("placeValuesInside='1'");
							//chartAttributes.add("showValue='1'");
							chartAttributes.add("animation='0'");
							chartAttributes.add("gaugeFillAlpha='100'");
							chartAttributes.add("showGaugeBorder='1'");
							chartAttributes.add("gaugeBorderThickness='1'");
							chartAttributes.add("baseFontSize='25'");
							chartAttributes.add("baseFontColor='#000000'");
							String infoForUrl="All";
							if( applyInfo != null && applyInfo.size() > 0  && !data.equals("All"))
							{
								
								for( int j=0;j<applyInfo.size();j++)
								{
									String tmpInfo=(String)applyInfo.get(j);
								
									if( applyInfo.size()>1  && !tmpInfo.equals("-"))
									{
										infoForUrl=tmpInfo;
									}
									else
									{
										infoForUrl=tmpInfo;
									}
								}
								//infoForUrl=(String)applyInfo.get(0);
								//int totalServers=applyInfo.size();
								//totalDesktops=totalDesktops.valueOf(totalServers);
							}

							String url="/final/monitor/XenBlocks.jsp?count=machinepage&category="+data+"&hostName="+compName+"&compType="+compType+"&tab=Application&caption=&formserver="+isFormServer;
							if(totalDesktops!=null && !totalDesktops.equals(""))
							{
								chartAttributes.add("clickURL='javascript:gotoMachines(&apos;"+EgURLEncoder.encode(url+"&category="+infoForUrl+"&hostName="+compName+"&compType="+compType+"&tab=Application&caption="+caption+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight,"UTF-8")+"&apos;)'");
							}
							chart="Bulb.swf";
						}
						else
						{
							if( applyInfo != null && applyInfo.size() > 0)
							{
								if(applyInfo.size()>4)
								{
									chartHeight="190px";
								}
								else
								{
									chartHeight="130px";
								}
							}
							chart="Bar2D.swf";
							//chartAttributes.add("plotFillAngle='360'");
							//chartAttributes.add("plotSpacePercent='80'");
							//chartAttributes.add("chartLeftMargin='10px'");
							chartAttributes.add("canvasRightMargin='10px'");
							//chartAttributes.add("yAxisMaxValue='100'");
							//chartAttributes.add("showValues='0'");
							//chartAttributes.add("canvasBorderThickness='1' ");
							//chartAttributes.add("canvasBorderColor='999999'");
							chartAttributes.add("plotFillAngle='330'");
							chartAttributes.add("plotBorderColor='999999'");
							chartAttributes.add("showAlternateVGridColor='1'");
							chartAttributes.add("divLineAlpha='0'");
							chartAttributes.add("labelPadding='1'");
							chartAttributes.add("animation='0'");
							chartAttributes.add("showBorder='0'");
							chartAttributes.add("formatNumberScale='1'");
							chartAttributes.add("formatNumber='1'");
							chartAttributes.add("yAxisMinValue='0'");
							chartAttributes.add("yAxisMaxValue='1'");
							chartAttributes.add("showYAxisValues='0'");
							chartAttributes.add("setAdaptiveYMin='1'");
							chartAttributes.add("showVLineLabelBorder='1'");
							chartAttributes.add("palette='2'");
							chartAttributes.add("showValues='1'");
							chartAttributes.add("showLabels='1'");
							chartAttributes.add("useRoundEdges='1'");
							chartAttributes.add("exportTargetWindow='1'");
							chartAttributes.add("exportEnabled='0'");
							chartAttributes.add("exportAction='download'");
							chartAttributes.add("exportAtClient='0'");
							chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
							chartAttributes.add("bgColor='ffffff'");
							chartAttributes.add("borderAlpha='100'");
							chartAttributes.add("showToolTipShadow='1'");
							chartAttributes.add("chartLeftMargin='8'");
							chartAttributes.add("chartRightMargin='8'");
							chartAttributes.add("chartTopMargin='8'");
							chartAttributes.add("chartBottomMargin='8'");
							chartAttributes.add("canvasBorderColor  ='000000'");
							chartAttributes.add("canvasBorderThickness  ='0'");
							chartAttributes.add("plotSpacePercent  ='40'");
							chartAttributes.add("outCnvBaseFontColor ='000000'");
							chartAttributes.add("adjustDiv='1'");
							chartAttributes.add("yAxisValueDecimals='2'");
							chartAttributes.add("placeValuesInside='0'");
						}
						String xmlData = fusionChart.getXmlForXen(chartAttributes,applyInfo,compName,compType,tab,machineName,caption,isServer,totalDesktops,isFormServer,screenWidth,screenHeight);
						if( applyInfo != null  && applyInfo.size() > 0 && iniData.equalsIgnoreCase(data) )
						{
%>
						<td align="center" valign="top" height="100%">
							<div class="div_scroll" style="height:150px;">
<%
							double width=190;
							if( i==0 )
							{
								width=180;
%>
							<div align="center" valign="top" class="padding4" ><egui:intnl text="monitor.dashboard.Desktops"/></div>
<%
								
							}
							else if(i==1)
							{
%>
							<div align="center" valign="top" class="padding4" ><egui:intnl text="monitor.dashboard.Catalogs"/></div>
<%
							}
							else if(i==2)
							{
%>
							<div align="center" valign="top" class="padding4" ><egui:intnl text="monitor.dashboard.Desktop Groups"/></div>
<%
							}
							double defaultTableWidth=width;
							double tableWidth=920;
							double tableWidth1024PxInPercent=defaultTableWidth/1024;
							tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
							tableWidth=MathUtils.round(tableWidth,0);
							String tblWidth=Double.toString(tableWidth);
							

%>
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=tblWidth%>" height="<%=chartHeight%>" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
								<param name="FlashVars" value="&dataXML=<%=xmlData%>&chartWidth=<%=tblWidth%>&chartHeight=<%=chartHeight%>">
								<param name="quality" value="high" />
								<param name="movie" value="/final/FusionCharts/swf/<%=chart%>" />
								<param name="WMode" value="Transparent">
								<embed wmode="transparent" src="/final/FusionCharts/swf/<%=chart%>" flashVars="&dataXML=<%=xmlData%>" quality="high" width="<%=tblWidth%>" height="<%=chartHeight%>" name="Bulb" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->

							<div id="BulbContainer<%=i%>"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "myBulbChartId<%=i%>" ) )
										FusionCharts( "myBulbChartId<%=i%>" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/<%=chart%>","myBulbChartId<%=i%>", "<%=tblWidth%>", "<%=chartHeight%>","0","1");
								myChart.setXMLData("<%=xmlData%>");
								myChart.setTransparent(true);
								myChart.render("BulbContainer<%=i%>");
							</script>

							</div>
						</td>
	<%
						}
						else if( iniData.equalsIgnoreCase(data) )
						{
%>
						<td align="center" valign="top" height="100%">
							<table border="0" cellspacing="0" cellpadding="0" width="200px" height="100%">
								<tr>
<%
							if( i==0 )
							{
%>
									<td align="center" valign="middle" class="padding4"><egui:intnl text="monitor.dashboard.Desktops"/></td>
<%
							}
							else if( i==1 )
							{
%>
									<td align="center" valign="middle" class="padding4"><egui:intnl text="monitor.dashboard.Catalogs"/></td>
<%
							}
							else
							{
%>
									<td align="center" valign="middle" class="padding4"><egui:intnl text="monitor.dashboard.Desktop Groups"/></td>
<%
							}
%>
								</tr>
								<tr>
									<td align="center" valign="middle" height="100%" valign="middle" >
										<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
									</td>
								</tr>
							</table>
						</td>
<%
						}
					}
					else if( iniData.equalsIgnoreCase(data) )
					{
%>
						<td align="center" valign="top" height="100%">
							<table border="0" cellspacing="0" cellpadding="0" class="vm  border" width="200px" height="100%">
								<tr>
<%
							if( i==0 )
							{
%>
									<td align="center" valign="middle" class="padding4"><egui:intnl text="monitor.dashboard.Desktops"/></td>
<%
							}
							else if( i==1 )
							{
%>
									<td align="center" valign="middle" class="padding4"><egui:intnl text="monitor.dashboard.Catalogs"/></td>
<%
							}
							else
							{
%>
									<td align="center" valign="middle" class="padding4"><egui:intnl text="monitor.dashboard.Desktop Groups"/></td>
<%
							}
%>
								</tr>
								<tr>
									<td align="center" valign="middle" height="100%" valign="middle" class="eg_75bold">
										<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
									</td>
								</tr>
							</table>
						</td>

<%
					}
				}
				if( iniData.equalsIgnoreCase(data) )
				{
					break;
				}
			}
		}
%>
				</tr>
			</table>
		</div>
<%
	}
	if( count != null && count.equalsIgnoreCase("machinepage") )
	{
		ArrayList ddData = new ArrayList();
		Vector ddVector = new Vector();
		Vector valuesVector = new Vector();
		Vector sessionVector = new Vector();
		Vector displayVector = new Vector();
		String msmt_host="";
		String iniVal="";
		if(isFormServer!=null && (isFormServer.equalsIgnoreCase("Yes") || isFormServer.equalsIgnoreCase("true")))
		{
			msmt_host=(String)allMsmtHosts.get("XDGroupTest");
			iniVal=(String)iniObj.getValue(compType,"Application_machine_category_Form");
		}
		else
		{
			msmt_host=(String)allMsmtHosts.get("XDCtrlGroupTest");
			iniVal=(String)iniObj.getValue(compType,"Application_machine_category");
		}
		if( iniVal != null && iniVal.length() > 0 )
		{
			StringTokenizer st=new StringTokenizer(iniVal,",");
			while(st.hasMoreTokens())
			{
				String testWithMeasure=(String)st.nextToken();
				String inidata=testWithMeasure.substring(testWithMeasure.indexOf("$")+1);
				if( inidata.equalsIgnoreCase(data) )
				{
					String test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
					String measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1,testWithMeasure.indexOf("$"));
					if( inidata.equalsIgnoreCase("All") )
					{
						measure="Available_desktops";
					}
					ddData=(ArrayList)ddcHelper.getMachineDetails(hostName,portNo,msmt_host,compType,tab,test,measure);
				}
			}
		}

		Hashtable ddtable=(Hashtable)ddcHelper.getDDDataForMachine(hostName,portNo,msmt_host,compType,tab,data,graphtype,isFormServer,"machinepage",gname);
		Hashtable tempDDTable = new Hashtable();
		if ( data != null && data.equalsIgnoreCase("All") )
		{
			tempDDTable = (Hashtable)ddcHelper.getDDDataForMachine(hostName,portNo,msmt_host,compType,tab,"PoweredOff_desktops",graphtype,isFormServer,"machinepage",gname);
		}
		Hashtable machineValues=(Hashtable)ddcHelper.getMacdetails(hostName,portNo,compType,tab,msmt_host,isFormServer);

		String[] names={"Name","Power State","Registration State","Desktop State","User connected","Desktop Kind","Is_maintenance_mode","Domain Name","Machine ip","Os type","Desktop Group","Vm Name","Server","Host","User Name"} ;

		String[] session_names={"State","Log on time","End Point Name","End point ip","Connection type","plug-in Version","Brokering time","Desktop License Id"};

		String[] labelName={"Machine Name","DNS Name","IP Address","OS Type","Desktop Group Name","Catalog Name","Hosted Machine Name","Hosted Server Name","Hypervisor Connection Name"};


		List list=Arrays.asList(labelName);
		List ses_list=Arrays.asList(session_names);

		if( macInfo != null && macInfo.indexOf("$") > 0 )
		{
			macInfo=com.egurkha.util.StringUtils.replace(macInfo, "$", "\\");
		}
%>
	<img src="/final/monitor/eg_images/spacer.gif" border="0" style="display:none" onload="javascript:loadAccording();"/>
	
	
	<div id="matchingmachines" class="linesquare matchingMachinesDiv" style="margin:0px;padding:0px;visibility:visible:display:block;valign:top;height:430px;" >

		<div class="eg_medium" style="display:block;visibility:visible;height:20px;width:100%;border-top:0px;border-right:0px;border-left:0px;">
			<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="monitor.dashboard.Matching Machines"/></div>
		</div>

		<div class="eg_whitebg" style="padding:0px;margin:0px;text-align:left;position:relative;display:block;width:100%;visibility:visible;">
			<div style="height:24px;text-align:center;padding:2px 2px 0px 4px" class="eg_morelight linebottom">
				<div class="searchImg" style="float:left;margin-right:5px">
					<div class="rightside" style="display:inline;border:0px solid red;padding:2px;"> <input type="text" id="search" class="textBoxImg" onblur="if(this.value=='') this.value='Filter Machine Name';" onfocus="if(this.value=='Filter Machine Name') this.value='';" onkeyup="javascript:searchMachine(this,0);" value="Filter Machine Name"/> </div>
				</div>

				<div class="searchImg" style="float:left;margin-right:5px">
					<div class="rightside" style="display:inline;border:0px solid red;padding:2px;"> <input type="text" id="search" class="textBoxImg" onblur="if(this.value=='') this.value='Filter DNS Name';" onfocus="if(this.value=='Filter DNS Name') this.value='';" onkeyup="javascript:searchMachine(this,1);" value="Filter DNS Name"/> </div>
				</div>

				<div class="searchImg" style="float:left;margin-right:5px">
					<div class="rightside" style="display:inline;border:0px solid red;padding:2px;"> <input type="text" id="search" class="textBoxImg" onblur="if(this.value=='') this.value='Filter IP Address';" onfocus="if(this.value=='Filter IP Address') this.value='';" onkeyup="javascript:searchMachine(this,2);" value="Filter IP Address"/> </div>
				</div>
			</div>

			<div style="clear:both;" class="matchingMachinesDivContent div_scroll">
				<table cellpadding="0" cellspacing="0" id="myTable" class="machineMatching" border="0" width="100%">
					<thead>
						<tr>
<%
		if( list != null && list.size() > 0 )
		{
			for(int i=0;i<list.size();i++)
			{
				String header=(String)list.get(i);
%>
							<td class="cell_border1 padding4"><%=header%></td>
<%
			}
		}
%>
						</tr>
					</thead>
					<tbody>
<%
		if( ddtable != null && ddtable.size() > 0 )
		{
			Iterator itr=ddtable.keySet().iterator();
			int i=0;
			while(itr.hasNext())
			{
				String trBackground="eg_lightlight";
				if(i%2==0)
				{
					trBackground="eg_whitebg";
				}

%>
						<tr class="<%=trBackground%>" >
<%
				String machineName=(String)itr.next();
				String url=response.encodeURL("/final/monitor/XenBlocks.jsp?");
				url+="info="+EgURLEncoder.encode(machineName,"UTF-8");
				String passValue=machineName;
				if( passValue != null && passValue.indexOf("\\") > 0 )
				{
					passValue=com.egurkha.util.StringUtils.replace(passValue, "\\", "$");
				}
				if ( (data != null && !data.equals("PoweredOff_desktops")) && ( tempDDTable != null && !tempDDTable.containsKey(machineName) ) )
				{
%>
							<td class="padding4"><a href="javascript:void(0);" class="eg_monlink"  style="text-decoration:underline" onclick="javascript:goMacDetails('<%=url+"&count=desktopPage&category="+passValue+"&hostName="+compName+"&compType="+compType+"&tab=Application&gname="+gname+"&formserver="+isFormServer+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight%>')"> <%=machineName%></a></td>
<%
				}
				else
				{
%>
							<td class="padding4"><%=machineName%></td>
<%
				}
				Vector machineData=(Vector)ddtable.get(machineName);
				if( machineData != null && machineData.size() > 0 )
				{
					for(int j=0;j<machineData.size();j++)
					{
						String dispData=(String)machineData.get(j);
						/*String sortedData="";
						if(dispData.length() > 40)
						{
							sortedData=dispData.substring(0,38);
							sortedData=sortedData+"...";
						}
						else
							sortedData=dispData;*/
%>
							<td class="padding4" title="<%=dispData%>"><%=dispData%></td>
<%
					}
				}
%>
						</tr>
<%
				i++;
			}
%>
<%
		}
		else
		{
%>
						<tr>
<%
			for (int i=0;i<9;i++)
			{
%>
							<td class="padding4"> - </td>
<%
			}
%>
						</tr>
<%
		}
%>
					</tbody>
				</table>
			</div>
		</div>
	</div>
<%
	}
	else if( count != null && count.equalsIgnoreCase("desktopPage") )
	{
		String msmt_host="";
		if(isFormServer!=null && (isFormServer.equalsIgnoreCase("Yes") || isFormServer.equalsIgnoreCase("true")))
		{
			msmt_host=(String)allMsmtHosts.get("XDVDTest");
		}
		else
		{
			msmt_host=(String)allMsmtHosts.get("XDCtrlVDTest");
		}
		
		if( data != null && data.indexOf("$") > 0 )
		{
			data=com.egurkha.util.StringUtils.replace(data, "$", "\\");
		}
		Hashtable ddtable=(Hashtable)ddcHelper.getDDDataForMachine(hostName,portNo,msmt_host,compType,tab,"All",graphtype,isFormServer,"desktoppage",gname);
		Hashtable machineValues=(Hashtable)ddcHelper.getMacdetails(hostName,portNo,compType,tab,msmt_host,isFormServer);
		Hashtable sessionDetails=(Hashtable)ddcHelper.getSessionDetails(hostName,portNo,msmt_host,isFormServer);

		String[] names={"Power state","Registration state","Desktop state","User connected","Desktop kind"," Maintenance mode","Domain name","Machine IP","Os type","Desktop group","VM name","Server","Host","Hosted Connection Name"} ;

		String[] session_names={"State","Log on time","End point name","End point IP","Connection type","Plug-in version","Brokering time","Desktop license ID"};

		List list=Arrays.asList(names);
		List ses_list=Arrays.asList(session_names);


		if( macInfo != null && macInfo.indexOf("$") > 0 )
		{
			macInfo=com.egurkha.util.StringUtils.replace(macInfo, "$", "\\");
		}
		Vector ddVector=(Vector)ddtable.get(data);
		Vector valuesVector=(Vector)machineValues.get(data);
		Vector displayVector=new Vector();
		if( ddVector != null || valuesVector != null )
		{
			if(valuesVector!=null)
			{
				displayVector.addAll(valuesVector);
			}
			else
			{
				for(int i=0;i<6;i++)
				{
					displayVector.add("-");
				}
			}
			if(ddVector!=null)
			{
				displayVector.addAll(ddVector);
			}
			else
			{
				for(int i=0;i<8;i++)
				{
					displayVector.add("-");
				}
			}
		}
		Vector sessionVector=(Vector)sessionDetails.get(data);
%>
	
		<div id="machines" class="machinesPopupDiv" style="margin:0px;padding:0px;visibility:visible:display:block;valign:top;height:430px;" >
			<div class="eg_medium" style="display:block;visibility:visible;border:0px solid red;height:20px;width:100%">
				<div class="eg_8bold" style="float:left;padding:2px 2px 2px 4px"><%=com.egurkha.util.StringUtils.replace(data, "+", "")%></div>
			</div>

			<div class="eg_whitebg" style="padding:0px;margin:0px;text-align:left;position:relative;display:block;width:100%;visibility:visible;border:0px solid red;">

				<table cellspacing="0" cellpadding="0" border="0" width="100%" bordercolor="green">
					<tr>
						<td class="linesquare" valign="top" >
							<div class="eg_lightlight" style="padding:4px;">
								<b><egui:intnl text="monitor.dashboard.Machine Details"/></b>
							</div>
							<div class="machineDetailsDiv1 div_scroll" style="border:0px solid red;padding:0px">
								
<%
		if( displayVector != null && displayVector.size() > 0  )
		{
%>
								<table border="0" cellspacing="0" cellpadding="0" width="100%">
									<tr>
										<td style="padding:4px;text-align:left" valign="top" ><egui:intnl text="monitor.dashboard.Machine name" /></td>
										<td align="left" style="padding:4px" valign="top" class="eg_75bold"><%=data%></td>
									</tr>
<%
			for(int i=0;i<list.size();i++)
			{
				String labelName=(String)list.get(i);

				String trBackground="eg_whitebg";
				if(i%2==0)
				{
					trBackground="eg_lightlight";
				}
%>
									<tr class="<%=trBackground%>" >
										<td style="padding:4px;text-align:left" valign="top"><%=labelName%></td>
<%
				if( labelName.equalsIgnoreCase("Desktop Group") )
				{
					String url=response.encodeURL("/final/monitor/XenBlocks.jsp?");
					
%>
										<td align="left" valign="top" style="padding:4px" class="eg_75bold"><a  href="javascript:void(0);" class="eg_monlink" style="text-decoration:underline" onclick="javascript:gotoMachines('<%=url+"gname="+(String)displayVector.get(i)+"&count=group&fromComparision=false&hostName="+compName+"&compType="+compType+"&tab=Application&formserver="+isFormServer+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight%>');" ><b class="eg_75bold"><%=(String)displayVector.get(i)%></b></a></td>
<%
				}
				else
				{
					/*String value=(String)displayVector.get(i);
					String measVal=MeasureDisplay.formatValue(value);
					String messy = MeasureDisplay.getMeasureForColumn(test,measure);
					String iniVar=test+":"+messy+":"+measVal;
					String iniValue=egUI.getValue("Measure_value_display",iniVar);
					if( iniValue != null && iniValue.length() > 0)
					{
						measVal=iniValue;
					}*/
					String measVal=(String)displayVector.get(i);
					if(measVal.startsWith("-"))
					{
						measVal="-";
					}
%>
										<td style="padding:4px" align="left" valign="top" class="eg_75bold"><%=measVal%></td>
<%
				}
%>
									</tr>
<%
			}
		}
		else
		{
%>
								<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" class="eg_whitebg">
									<tr>
										<td  align="center" valign="middle" class="eg_75bold" style="padding:4px" height="100%">
											<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"><br>&nbsp;<egui:intnl text="monitor.dashboard.No Measures Available"/>!
										</td>
									</tr>
<%
		}
%>
								</table>
							</div>
						</td>

						<td class="linesquare" valign="top" style="border-left-width:0px;">
							<div class="eg_lightlight" style="padding:4px;">
								<b><egui:intnl text="monitor.dashboard.Session Details"/></b>
							</div>
							<div class="machineDetailsDiv1 div_scroll" style="border:0px solid red;padding:2px">
								
<%
		if( sessionVector != null && sessionVector.size() > 0 )
		{
%>
								<table border="0" cellspacing="0" cellpadding="0" width="100%" class="tableborder_jvm">
<%
			for(int j=0;j<sessionVector.size();j++)
			{
%>
									<tr>
										<td style="padding:4px" align="left" class="tdborder_jvm">
										<%=(String)ses_list.get(j)%>
										</td>
										<td style="padding:4px" align="left" class="tdborder_jvm eg_75bold">
										<%=(String)sessionVector.get(j)%>
										</td>
									</tr>
<%
			}
		}
		else
		{
%>
								<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" class="eg_whitebg">
									<tr>
										<td align="center" style="padding:4px" height="100%"  valign="middle" class="eg_75bold">
											<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"><br><egui:intnl text="monitor.dashboard.No Measures Available"/>!
										</td>
									</tr>
<%
		}
%>
								</table>
							</div>
						</td>


						<td class="linesquare" valign="top" height="100%" style="border-left-width:0px;">
							<div class="eg_lightlight" style="padding:4px;" >
								<b><egui:intnl text="monitor.dashboard.Activity"/></b>
							</div>
							<div class="machineDetailsDiv2 div_scroll" style="border:0px solid red;">
								<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
									<tr>
										<td align="center" height="100%" valign="top">
<%
		String activityIni="";
		if(isFormServer!=null && (isFormServer.equalsIgnoreCase("Yes") || isFormServer.equalsIgnoreCase("true")))
		{
			activityIni=iniObj.getValue(compType,tab+"_activity_history_Form");
		}
		else
		{
			activityIni=iniObj.getValue(compType,tab+"_activity_history");
		}

		if( activityIni != null && activityIni.length() > 0 )
		{
			int i=0;
			StringTokenizer st=new StringTokenizer(activityIni,",");
			while(st.hasMoreTokens())
			{
				String testMeasure=(String)st.nextToken();
				String test=testMeasure.substring(0,testMeasure.indexOf(":"));
				String measure=testMeasure.substring(testMeasure.indexOf(":")+1);
				String dispMeasureTitle=iniObj.getValue("Dashboard_measures_mapping",test+":"+measure);
				String measureForDB=MeasureDisplay.getColumnForMeasure(test,measure);
				String s_layer=dashboardDAO.getLayerForTest(compType,test,measure);
				String defaultMGraphDuration=iniObj.getValue("Default_MeasureGraph_Duration","duration");
				
				java.util.Date endDate=new java.util.Date();
				java.util.Date startDate=new java.util.Date(endDate.getTime()-(24*60*60*1000));
				String start_time=sdfMM.format(startDate);
				String end_time=sdfMM.format(endDate);
				int startHourInt=startDate.getHours();
				int endHourInt=endDate.getHours();
				String start_hour=Integer.toString(startHourInt);
				String end_hour=Integer.toString(endHourInt);
				String mst_host="";
				mst_host=(String)allMsmtHosts.get(test);
				String FullViewPriority="TOP+-+10";
				String urlForMaximize="/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?endtime="+end_time+"&port="+portNo+"&site=NULL&sid="+sid+"&starttime="+start_time+"&host="+hostName+"&measure="+measureForDB+"&newWindow=true&test="+test+"&layer="+s_layer+"&comptype="+compType+"&from=MonitorDashboard&endhr="+end_hour+"&gtype=1&mode=3D&starthr="+start_hour+"&msmt_host="+mst_host+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=880&height=320&legends=false&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&title=true&priority="+FullViewPriority+"&threshold=no&minmaxavgRequired=true&info=&isInfoReleventGraph=true"+"&fullView=true&module="+tab;

				String measureGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?")+"endtime="+end_time+"&port="+portNo+"&site=NULL&sid="+sid+"&starttime="+start_time+"&host="+hostName+"&measure="+measureForDB+"&newWindow=true&test="+test+"&comptype="+compType+"&from=MonitorDashboard&endhr="+end_hour+"&gtype=1&mode=2D&starthr="+start_hour+"&msmt_host="+mst_host+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=250&height=130&info=";
%>
											<div class="clr" style="border:0px solid red">
												<div class="eg_75bold clr eg_morelight" style="padding:4px;"><%=dispMeasureTitle%> </div>
												
												<div class="clr" style="padding:4px;height:180px;width:100%;border:0px solid red" >
													<table cellpadding="0" cellspacing="0" border="0" width="100%" height="100%">
														<tr>
															<td  width="100%" height="100%" align="center" valign="middle">
															<img  id="history" class="mouse" align="center" onclick="javascript:showBigGraph('<%=urlForMaximize%>',event,'<%=i%>','Measuregraph');"  src="<%=measureGraphUrl%>" /> <input type="hidden" id="fullViewImg<%=i%> value="<%=urlForMaximize%>"/>
															</td>
														</tr>
													</table>
												</div>
											</div>
<%
				i++;
			}
		}
%>

										</td>
									</tr>
								</table>
							</div>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
<%
	}
	else if( count != null && count.equals("group") )
	{
		gname="+"+gname;
		String mHost="";
		String dbData="";
		String displayTitle="";
		Vector dblist=null;

		if(isFormServer!=null && (isFormServer.equalsIgnoreCase("Yes") || isFormServer.equalsIgnoreCase("true")))
		{
			mHost=(String)allMsmtHosts.get("XDGroupTest");

		}
		else
		{
			mHost=(String)allMsmtHosts.get("XDCtrlGroupTest");
		}

		dbData=(String)iniObj.getValue(compType,tab+"_group_data");
		if( dbData != null && dbData.length() > 0 )
		{
			dblist=new Vector();
			StringTokenizer st=new StringTokenizer(dbData,",");
			while(st.hasMoreTokens())
			{
				String dataVal=(String)st.nextToken();
				dblist.add(dataVal);
			}
		}

		Hashtable ddData=(Hashtable)ddcHelper.getDetailsDiagnosysForGroup(hostName,portNo,mHost,isFormServer);
		ArrayList listMacName = new ArrayList();
		HashMap dispDDDataTable = (HashMap)ddData.get(gname);
		if ( dispDDDataTable != null && !dispDDDataTable.isEmpty() )
			listMacName = new ArrayList(dispDDDataTable.keySet());
		Collections.sort(listMacName);
		if ( selectedMacName == null || selectedMacName.equals("") )
		{
			if ( listMacName != null && !listMacName.isEmpty() )
				selectedMacName = (String)listMacName.get(0);
		}
		Hashtable groupDataUsage=(Hashtable)ddcHelper.getGroupDetails(hostName,portNo,mHost,tab,compType,false,isFormServer);
		Vector usageData=(Vector)groupDataUsage.get(gname);
		Vector columnNamesForUsage=ddcHelper.getGroupColumnNames();
		Vector usageColumnName=new Vector();
		usageColumnName.addAll(columnNamesForUsage);

		Hashtable statusTable = (Hashtable) ddcHelper.getGroupDetails(hostName,portNo,mHost,tab,compType,true,isFormServer);
		Vector statusVector=(Vector)statusTable.get(gname);
		Vector columnNamesForStatus=ddcHelper.getGroupColumnNames();
		
		gname=com.egurkha.util.StringUtils.replace(gname, "+", "");
		if( gname != null && gname.equalsIgnoreCase("All") )
		{
			displayTitle="All Desktop Groups";
		}
%>
<%
		if( gname != null && gname.equalsIgnoreCase("All") )
		{
%>
	<div style="visibility:visible;display:block;" id="meausreGraphDiv">
		<div id="machines" class="desktopGroupPopupDiv linesquare" style="margin:0px;padding:0px;visibility:visible:display:block;valign:top;height:430px;" >
			<div class="eg_medium" style="display:block;visibility:visible;border:0px solid red;height:20px;">
				<div class="eg_8bold" style="float:left;padding:2px 2px 2px 4px"><egui:intnl text="monitor.dashboard.Desktop Group"/></div>
			</div>
<%
		}
		else
		{
%>
	<div style="visibility:visible:display:block;width:100%;border:0px solid red" >

		<div id="machines" class="desktopGroupPopupDiv div_scroll linesquare" style="margin:0px;padding:0px;visibility:visible:display:block;valign:top;height:430px;" >



			<div class="eg_medium" style="display:block;visibility:visible;border:0px solid red;height:20px;">
				<div class="eg_8bold" style="float:left;padding:2px 2px 2px 4px"><egui:intnl text="monitor.dashboard.Desktop Group"/> - <%=gname%></div>
			</div>


			<div class="eg_whitebg" style="margin:0px;text-align:left;position:relative;display:block;visibility:visible;border:0px solid green;">
				<table cellspacing="0" cellpadding="0" border="0" >
					<tr>
						<td class="linebottomright" valign="top" align="left">
							<div class="eg_lightlight" style="border-right-width:0px;padding:4px;">
								<table border="0" bordercolor="red" width="90%">
									<tr>
										<td width="30%">
											<b><egui:intnl text="monitor.dashboard.Machines"/></b>
										</td>
										<td align="right" width="60%">
											<select style="width:95%" id="macName" onchange="javascript:loadDetailForXenGroup('<%=gname%>','<%=hostName%>','<%=portNo%>','<%=mHost%>','<%=isFormServer%>');" >
<%
			if ( listMacName != null && !listMacName.isEmpty() )
			{
				for ( int i = 0 ; i < listMacName.size() ; i++ )
				{
					String mac_name = (String)listMacName.get(i);
					boolean isSelected=false;
					if(mac_name!=null && mac_name.equals(selectedMacName))
						isSelected=true;
%>
												<option value="<%=mac_name%>" <%=isSelected ? "selected" : ""%>><%=mac_name%></option>
<%
				}
			}
%>
											</select>
										</td>
									</tr>
								</table>
								
							</div>
							<div id="groupDetails" class="desktopGroupDetailsDiv div_scroll" style="border:0px solid red;">
							<%
								String url = "EgXenDesktopGroupDetails.jsp?gname="+EgURLEncoder.encode(gname,"UTF-8")+"&mac_name="+EgURLEncoder.encode(selectedMacName,"UTF-8")+"&hostName="+EgURLEncoder.encode(hostName,"UTF-8")+"&portNo="+EgURLEncoder.encode(portNo,"UTF-8")+"&mHost="+EgURLEncoder.encode(mHost,"UTF-8")+"&isFormServer="+EgURLEncoder.encode(isFormServer,"UTF-8");
							%>
								<jsp:include page='<%=url%>'/>
							</div>
						</td>
						<td class="linebottomright" valign="top" align="left">
							<div class="eg_lightlight" style="border-right-width:0px;padding:4px;">
								<b><egui:intnl text="monitor.dashboard.Status"/></b>
							</div>
							<div class="desktopGroupStatusDiv div_scroll" style="border:0px solid red;">
<%
		if( statusVector != null && statusVector.size() > 0 )
		{
%>
								<table border="0" cellspacing="0" cellpadding="0" width="100%" >
<%
			for(int i=0;i<statusVector.size();i++)
			{
				String headers=(String)columnNamesForStatus.get(i);
				String details=(String)statusVector.get(i);
				String measVal=MeasureDisplay.formatValue(details);
				String machinePageUrl=response.encodeURL("/final/monitor/XenBlocks.jsp?");
				gname=gname.trim();
				String mappingName=iniObj.getValue("Dashboard_TableColumn_mapping",headers);
				machinePageUrl+="category="+headers+"&count=machinepage&hostName="+compName+"&compType="+compType+"&tab=Application&formserver="+isFormServer+"&caption=group&gname="+gname;
				if( measVal.equals("0") )
				{
					measVal="";
				}
				if(measVal.startsWith("-"))
				{
					measVal="";
				}
				String trBackground="eg_lightlight";
				if(i%2==0)
				{
					trBackground="eg_whitebg";
				}
%>
									<tr class="<%=trBackground%>" >
										<td style="padding:4px;text-align:left" valign="top" ><%=mappingName%></td>
										<td align="left" style="padding:4px" valign="top" class="eg_75bold"><a href="javascript:void(0);" onclick="javascript:gotoMachines('<%=machinePageUrl%>')" class="eg_75bold"><%=measVal%></a></td>
									</tr>
<%
			}
		}
		else
		{
%>
								<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" class="eg_whitebg">
									<tr>
										<td align="center" valign="middle" style="padding:4px">
											<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"><br>&nbsp;<egui:intnl text="monitor.dashboard.No Measures Available"/>!
										</td>
									</tr>
<%
		}
%>
			
								</table>
							</div>
						</td>


						<td class="linebottomright" valign="top">
							<div class="eg_lightlight" style="border-right-width:0px;padding:4px;">
								<b><egui:intnl text="monitor.dashboard.Usage"/></b>
							</div>
							<div class="desktopGroupUsageDiv div_scroll" style="border:0px solid red;">
<%
		if( usageData != null && usageData.size() > 0 )
		{
%>
								<table border="0" cellspacing="0" cellpadding="0" width="100%">
<%
			for(int j=0;j<usageData.size();j++)
			{
				String headers=(String)usageColumnName.get(j);
				String details=(String)usageData.get(j);
				String measVal=MeasureDisplay.formatValue(details);
				String mappingName=iniObj.getValue("Dashboard_TableColumn_mapping",headers);
				String machinePageUrl=response.encodeURL("/final/monitor/XenBlocks.jsp?");
				if( mappingName.equalsIgnoreCase("Total") )
				{
					headers="All";
				}
				gname=gname.trim();
			
				machinePageUrl+="category="+headers+"&count=machinepage&hostName="+compName+"&compType="+compType+"&tab=Application&formserver="+isFormServer+"&caption=group&gname="+gname;
				if( measVal.equals("0") )
				{
					measVal="";
				}
				if(measVal.startsWith("-"))
				{
					measVal="";
				}
				String trBackground="eg_lightlight";
				if(j%2==0)
				{
					trBackground="eg_whitebg";
				}
%>
									<tr class="<%=trBackground%>" >
										<td style="padding:4px;text-align:left" valign="top"><%=mappingName%></td>
<%
				if( mappingName != null && mappingName.equalsIgnoreCase("Usage") )
				{
%>
										<td style="padding:4px;text-align:left" valign="top"><%=measVal%></td>
<%
				}
				else
				{
%>
										<td align="left" style="padding:4px" valign="top" class="eg_75bold"><a href="javascript:void(0);" class="eg_75bold" onclick="javascript:gotoMachines('<%=machinePageUrl%>')"><%=measVal%></a></td>
									</tr>
<%
				}
			}
		}
		else
		{
%>
								<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" class="eg_whitebg">
									<tr>
										<td align="center" valign="middle"  style="padding:4px">
											<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"><br>&nbsp;<egui:intnl text="monitor.dashboard.No Measures Available"/>!
										</td>
									</tr>
<%
		}
%>
								</table>
							</div>
						</td>
					</tr>
				</table>
			</div>
<%
		}
		if(( gname != null && gname.equalsIgnoreCase("All") ))
		{
%>
			<div style="width:100%;padding:0px;" class="allDesktopGroupsDiv div_scroll eg_whitebg" >
<%
			String url=response.encodeURL("/final/monitor/XenBlocks.jsp?");
%>
				<div style="float:left;width:100%;padding:0px;" class="eg_lightlight">
						<div style="float:left;width:65%;padding:8px;text-align:left" class="eg_darktextbold" ><%=displayTitle%></div>
						<div style="float:right;width:30%;border:0px solid green;height:32px;">
							<div onclick="javascript:loadGraph('<%=url+"count=group&radiotype=comparision&fromComparision=true&hostName="+compName+"&compType="+compType+"&tab=Application&gname="+com.egurkha.util.StringUtils.replace(gname+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&formserver="+isFormServer, "+", "")%>',this.value);" id="comparison_button" style="height:32px;border:0px solid red;float:left">
							
								<table border="0" cellpadding="0"  cellspacing="0" bordercolor="blue"  style="table-layout:auto">
									<tr>
										<td align="center" class="mouse" style="width:30px"> <img src="/final/images/ddc_comparison.png" href="javascript:void(0);" /></td>
										<td id="eg_darktextbold"  class="mouse" align="left" style="padding-right:20px" ><egui:intnl text="admin.Comparison."/> </td>
									</tr>
								</table>
							</div>

							<div  onclick="javascript:loadGraph('<%=url+"count=group&radiotype=history&hostName="+compName+"&compType="+compType+"&tab=Application&gname="+com.egurkha.util.StringUtils.replace(gname+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&formserver="+isFormServer, "+", "")%>',this.value)" id="history_button" style="height:32px;border:0px solid red;float:left">
								<table border="0" cellpadding="0"  cellspacing="0" bordercolor="blue"  style="table-layout:auto">
									<tr>
										<td class="mouse" align="center" style="width:30px"><img src="/final/images/ddc_history.png" href="javascript:void(0);" /></td>
										<td class="mouse" id="eg_darktextbold"  align="left" style="padding-right:20px" ><egui:intnl text="admin.history.History"/></td>
									</tr>
								</table>
							</div>
						</div>
				</div>
<%
		}
		else
		{
%>
			<div style="width:100%;padding:0px;border:0px solid blue" >
<%
		}
%>

				<table cellspacing="0" cellpadding="0" border="0" class="eg_whitebg">
					<tr>
						<td><br/>
<%
			double defaultTableWidth=316;
			double tableWidth=920;
			double tableWidth1024PxInPercent=defaultTableWidth/1024;
			tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
			tableWidth=MathUtils.round(tableWidth,0);
			String tblWidth=Double.toString(tableWidth);

			double defaultTableHeight=200;
			double tableHeight=400;
			double tableHeight1024PxInPercent=defaultTableHeight/defaultTableWidth;
			tableHeight=580*tableWidth1024PxInPercent;
			tableHeight=MathUtils.round(tableHeight,0);
			String tblHeight=Double.toString(tableHeight);
	

			boolean ddEnabled=EgMemInfo.ddEnabled;
			String priority="TOP+-+3";
			String iniDDValue="";
			if(isFormServer!=null && (isFormServer.equalsIgnoreCase("Yes") || isFormServer.equalsIgnoreCase("true")))
			{
				iniDDValue=(String)iniObj.getValue(compType,tab+"_group_dd_Form");
			}
			else
			{
				iniDDValue=(String)iniObj.getValue(compType,tab+"_group_dd");
			}
			StringTokenizer st=new StringTokenizer(iniDDValue,",");


			boolean isNonEnglishLanguage=((EgDbInfo.doubleByteEnabled && !trackerLanguage.equals("en_US")) || !trackerLanguage.equals("en_US"));
			String fontForLanguage="verdana";
			String fontSize="7.5";
			if(isNonEnglishLanguage)
			{
				fontForLanguage=iniUI.getFontName();
				fontSize="12";
			}
			int i=0;
			while(st.hasMoreTokens())
			{
				String s_singleDDtestmeasure=(String)st.nextToken();
				boolean isDDFromFirstMsmt=true;
				String FullViewPriority="TOP+-+10";
				String s_test=s_singleDDtestmeasure.substring(0,s_singleDDtestmeasure.indexOf(":"));
				String s_measure=s_singleDDtestmeasure.substring(s_singleDDtestmeasure.indexOf(":")+1);
				String dispMeasureTitle=iniObj.getValue("Dashboard_measures_mapping",s_test+":"+s_measure);
				String measureMapping=iniObj.getValue("Dashboard_ComparisonGraph_Mapping",s_singleDDtestmeasure);
					if(measureMapping==null || measureMapping.equals(""))
						measureMapping=mappingInfo.getMeasureDescription(s_test,s_measure);
				String unit=tablesInfo.getUnitForMeasure(s_test,s_measure);
				String ddtimeline=iniObj.getValue("Default_DD_Duration","duration");

				String msmt_host=(String)allMsmtHosts.get(s_test);
				Vector allInfos=(Vector)allTestInfos.get(s_test);
				String desc="*";
				if(allInfos!=null && allInfos.size()>0)
				{
					desc=(String)allInfos.get(0);
				}
				String infoForLastDDMsmtTime=desc;
				if(formatInfo.isDDDTest(s_test))
				{
					String ddWithoutInfo = formatIni.getValue("Tests_For_DDWithoutInfos", s_test + ":" + s_measure);
					if(ddWithoutInfo!=null && ddWithoutInfo.equalsIgnoreCase("yes"))
					{
						infoForLastDDMsmtTime = "+";
					}
				}

				java.util.Date endDate=new java.util.Date();
				java.util.Date startDate=new java.util.Date(endDate.getTime()-(24*60*60*1000));
				String start_time=sdfMM.format(startDate);
				String end_time=sdfMM.format(endDate);
				int startHourInt=startDate.getHours();
				int endHourInt=endDate.getHours();
				String start_hour=Integer.toString(startHourInt);
				String end_hour=Integer.toString(endHourInt);
				if(( radiotype != null && radiotype.equalsIgnoreCase("comparision") ) && ( gname != null && gname.equalsIgnoreCase("All") ))
				{

					String s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(s_test,s_measure,hostName,portNo,"NULL",infoForLastDDMsmtTime,msmt_host);

					java.util.Date lastMsmtTime=new java.util.Date();
					if(s_lastMsmtTime!=null && !s_lastMsmtTime.trim().equals(""))
						lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);
					else
						s_lastMsmtTime=testTableDateFmt.format(lastMsmtTime);

					String  startTime=sf.format(lastMsmtTime);
					String  endTime=sf.format(lastMsmtTime);

					String s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
					Vector vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

					String startHour=(String)vec_times.get(0);
					String  endHour=(String)vec_times.get(0);
					String  startMin=(String)vec_times.get(1);
					String  endMin=(String)vec_times.get(1);

					int i_endMin=Integer.parseInt(endMin);
					if( i_endMin == 59 )
					{
						i_endMin=0;
						endHour=(Integer.parseInt(endHour)+1)+"";
					}
					else
					{
						i_endMin++;
					}
					endMin=i_endMin+"";

					String  startSec=(String)vec_times.get(2);
					String  endSec=(String)vec_times.get(2);

					String ddGraphUrlLarge=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDashboardBarchart?")+"host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&width=301&height=183&monitorSkin="+monitor_Skin+"&mode=3D&graphdisplay=defaultView&test="+s_test+"&testmeasure="+s_singleDDtestmeasure+"&minmaxavgRequired=false&timeline_compare="+ddtimeline+"&priority="+FullViewPriority+"&isInfoRelevantMeasureGraph=true&starttime="+startTime+"&endtime="+endTime+"&starthr="+startHour+"&endhr="+endHour+"&display=false&fromHist=true&module="+tab;


					Vector comparionChartAttribute=new Vector();
					comparionChartAttribute.add("caption='"+EgURLEncoder.encode(measureMapping+"("+unit+")","UTF-8")+"'");
					comparionChartAttribute.add("palette='2'");
					comparionChartAttribute.add("showValues='1'");
					comparionChartAttribute.add("showLabels='1'");
					comparionChartAttribute.add("showYAxisValues='0'");
					comparionChartAttribute.add("formatNumberScale='0'");
					comparionChartAttribute.add("useRoundEdges='1'");
					comparionChartAttribute.add("bgColor='ffffff'");
					comparionChartAttribute.add("showToolTipShadow='1'");
					comparionChartAttribute.add("chartLeftMargin='8'");
					comparionChartAttribute.add("chartRightMargin='8'");
					comparionChartAttribute.add("chartTopMargin='8'");
					comparionChartAttribute.add("chartBottomMargin='8'");
					comparionChartAttribute.add("exportEnabled='0'");
					comparionChartAttribute.add("exportAction='download'");
					comparionChartAttribute.add("exportAtClient='0'");
					comparionChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
					comparionChartAttribute.add("clickURL='javascript:comparisionBarOnclick("+i+")'");
				//	comparionChartAttribute.add("outCnvBaseFontSize='"+fontSize+"'");
					if( !isNonEnglishLanguage )
					{
						comparionChartAttribute.add("outCnvBaseFontSize='"+fontSize+"'");
						comparionChartAttribute.add("outCnvBaseFontColor ='000000'");
					}
					comparionChartAttribute.add("showBorder ='0'");
					comparionChartAttribute.add("canvasBorderColor  ='000000'");
					comparionChartAttribute.add("plotSpacePercent  ='40'");
					comparionChartAttribute.add("baseFont  ='"+fontForLanguage+"'");
					comparionChartAttribute.add("adjustDiv='1'");
					comparionChartAttribute.add("yAxisValueDecimals='2'");
					comparionChartAttribute.add("decimals='4'");
					comparionChartAttribute.add("placeValuesInside='0'");

					String xmlData=fusionChart.getXMLForComparision(compType,hostName,portNo,s_singleDDtestmeasure,FullViewPriority,isDDFromFirstMsmt,comparionChartAttribute);

					if( xmlData != null && xmlData.trim().length() > 0 )
					{
%>
							<div style="float:left;height:182px" class="padding4"   valign="middle">
								<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=tblWidth%>" height="180" id="StackedColumn3D">
									<param name="FlashVars" value="&dataXML=<%=xmlData%>&chartWidth=<%=tblWidth%>&chartHeight=180">
									<param name="quality" value="high" />
									<param name="WMode" value="Transparent">
									<param name="movie" value="/final/FusionCharts/swf/Bar2D.swf" />
									<embed wmode="transparent" src="/final/FusionCharts/swf/Bar2D.swf" flashVars="&dataXML=<%=xmlData%>" quality="high" width="<%=tblWidth%>" height="180" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object> -->

								<div id="Bar2DContainer<%=i%>"  style="height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "myBar2DChartId<%=i%>" ) )
											FusionCharts( "myBar2DChartId<%=i%>" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/Bar2D.swf","myBar2DChartId<%=i%>", "<%=tblWidth%>", "180","0","1");
									myChart.setXMLData("<%=xmlData%>");
									myChart.setTransparent(true);
									myChart.render("Bar2DContainer<%=i%>");
								</script>

								<input type="hidden" id="comparisionBar<%=i%>" value="<%=ddGraphUrlLarge%>"/>
							</div>
<%
					}
					else
					{
%>
							<div align="center" style="float:left; height:182px;width:<%=tblWidth%>" valign="middle">
								<table  border="0" bordercolor="black"  cellpadding="4" cellspacing="0" width="100%" height="100%">
									<tr>
										<td class="eg_75bold" align="center" style="height:20px" width="100%" ><%=measureMapping%></td>
									</tr>
									<tr>
										<td align="center" valign="middle" height="100%" valign="middle" class="eg_75bold">
											<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.common.No detailed measures available"/>!
										</td>
									</tr>
								</table>
							</div>
<%
					}
				}
				else
				{
					if(tblWidth.indexOf(".")>-1)
						tblWidth=tblWidth.substring(0,tblWidth.indexOf("."));
					if(tblHeight.indexOf(".")>-1)
						tblHeight=tblHeight.substring(0,tblHeight.indexOf("."));
					String measureForDB=MeasureDisplay.getColumnForMeasure(s_test,s_measure);
					String s_layer=dashboardDAO.getLayerForTest(compType,s_test,s_measure);
					String defaultMGraphDuration=iniObj.getValue("Default_MeasureGraph_Duration","duration");
					String urlForMaximize="/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?endtime="+end_time+"&port="+portNo+"&site=NULL&sid="+sid+"&starttime="+start_time+"&host="+hostName+"&measure="+measureForDB+"&newWindow=true&test="+s_test+"&layer="+s_layer+"&comptype="+compType+"&from=MonitorDashboard&endhr="+end_hour+"&gtype=1&mode=3D&starthr="+start_hour+"&msmt_host="+msmt_host+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=880&height=320&legends=false&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&title=true&priority="+FullViewPriority+"&threshold=no&minmaxavgRequired=true&info=&isInfoReleventGraph=true"+"&fullView=true&module="+tab;

					String measureGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?")+"endtime="+end_time+"&port="+portNo+"&site=NULL&sid="+sid+"&starttime="+start_time+"&host="+hostName+"&measure="+measureForDB+"&newWindow=true&test=XDGroupTest&comptype="+compType+"&from=MonitorDashboard&endhr="+end_hour+"&gtype=1&mode=2D&starthr="+start_hour+"&msmt_host="+msmt_host+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+tblWidth+"&height=150&info=";

%>
							<div style="float:left;width:<%=tblWidth%>;border:0px solid green">
								<div class="clr" style="height:10px"></div>
								<div class="clr eg_75bold" align="center"> <%=dispMeasureTitle%> </div>
								<div class="clr" style="height:<%=tblHeight%>;">
									<table cellpadding="0" cellspacing="0" border="0" width="100%" height="100%">
										<tr>
											<td align="center" valign="middle">
												<img id="history" class="mouse" onclick="javascript:showBigGraph('<%=urlForMaximize%>',event,'<%=i%>','Measuregraph');"  src="<%=measureGraphUrl%>" /> <input type="hidden" id="fullViewImg<%=i%> value="<%=urlForMaximize%>"/>
											</td>
										</tr>
									</table>
								</div>
							</div>
<%
				}
												i++;
		}
%>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
<%
	}
	else if( count != null && count.equalsIgnoreCase("groupUsage") )
	{
		double defaultTableWidth=300;
		double tableWidth=920;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);
		if(tblWidth.indexOf(".")>-1)
			tblWidth=tblWidth.substring(0,tblWidth.indexOf("."));
		if( data != null )
		{
				data="+"+data;
		}

		String mstHost="";
		String test="";
		if( allMsmtHosts != null )
		{
			if(isFormServer!=null && (isFormServer.equalsIgnoreCase("Yes") || isFormServer.equalsIgnoreCase("true")))
			{
				test="XDGroupTest";
				mstHost=(String)allMsmtHosts.get(test);
			}
			else
			{
				test="XDCtrlGroupTest";
				mstHost=(String)allMsmtHosts.get(test);
			}
		}

		java.util.Date endDate=new java.util.Date();
		java.util.Date startDate=new java.util.Date(endDate.getTime()-(60*60*1000));
		String startTime=sdfMM.format(startDate);
		String endTime=sdfMM.format(endDate);
		int startHourInt=startDate.getHours();
		int endHourInt=endDate.getHours();
		String startHour=Integer.toString(startHourInt);
		String endHour=Integer.toString(endHourInt);

		String measureForDB=MeasureDisplay.getColumnForMeasure(test,"Desktops_in_use_pct");
		String s_layer=dashboardDAO.getLayerForTest(compType,test,"Desktops_in_use_pct");
		String dispMeasureTitle=iniObj.getValue(compType,"Application_DesktopUsage_mapping");
		String defaultMGraphDuration=iniObj.getValue("Default_MeasureGraph_Duration","duration");
		String FullViewPriority="TOP+-+10";
		String urlForMaximize="/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?endtime="+endTime+"&port="+portNo+"&site=NULL&sid="+sid+"&starttime="+startTime+"&host="+hostName+"&measure="+measureForDB+"&newWindow=true&test=XDGroupTest&layer="+s_layer+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode=3D&starthr="+startHour+"&msmt_host="+mstHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=880&height=320&legends=false&fromDashboard=true&timeline_compare="+defaultMGraphDuration+"&title=true&priority="+FullViewPriority+"&threshold=no&minmaxavgRequired=true&info=&isInfoReleventGraph=true"+"&fullView=true&module="+tab+"&color="+color;

		String measureGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?")+"endtime="+endTime+"&port="+portNo+"&site=NULL&sid="+sid+"&starttime="+startTime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measureForDB+"&newWindow=true&test="+test+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode=2D&starthr="+startHour+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+tblWidth+"&height=130&title=false&info="+EgURLEncoder.encode(data,"UTF-8")+"&color="+color+"&serverdashboard=true&minmaxavgRequired=true";


		



%>
		<div align="center" valign="top" style="border:0px solid #000000;text-align:center;height:155px">
			<table align="center" border="0" cellspacing="0" cellpadding="0" height="100%">
				<tr>
					<td align="center" nowrap class="padding4" ><%=dispMeasureTitle%>-<%=com.egurkha.util.StringUtils.replace(data, "+", "")%></td>
				</tr>
				<tr>
					<td align="center" valign="middle" height="100%">
						<img id="history"  align="center"  src="<%=measureGraphUrl%>" />
					</td>
				</tr>
			</table>
		</div>
<%
	}
	if( request.getQueryString() != null )
	{
		if( session != null )
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+request.getParameter("compType")+"&host="+request.getParameter("hostName")+"&tab="+tab+"&selectedMacName="+selectedMacName);
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if( session != null )
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
}
catch(Exception e)
{
	e.printStackTrace();
}
%>