<%
/**
 *	Displays the current status of the servers being monitored
 *
 *	@author		Arun Jayaprakash
 *	@version	3.0
 *
 *	@modified
 *		17/10/2003	Arun	Set default % for good measures to zero
 *		28/10/2003	Arun	Uses IniUI for headings
 *		03/10/2003	Arun	Fixed bug where badMeasures would take the count of the last BAD state measure
 *							available in the database instead of all BAD state (H/I/L) measures
 *		04/10/2003	Arun	<meta> tag uses eg_ui.ini for refresh time
 *		05/11/2003	Arun	Fixed negative percentages for GOOD and 100+ percentages for UNKNOWN measures
 *							Known issue : Disabled tests might increase the count of measures while 
 *							querying MetaTest table initially
 *		13/05/2004	Arun	Clubbing of multiple components into a single alarm will not show up in 
 *							Unresolved problems
 */
%>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage="EgErrorSmall.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.eg.EgConfigInfo" %>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="com.eg.EgDbAdapterTypeUI" %>
<%@ page import="egurkha.*" %>
<%@ page import="com.egurkha.*" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="java.sql.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="com.eg.EgInstallInfo" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);

	IniUI ui = (IniUI)IniUI.getInstance();
	String refreshTime = ui.getRefreshTime("EgDashboard");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	boolean allComp = userRole.hasAllComponentAccess();

	int badMeasures = 0;
	int unknownMeasures = 0;
	int measureCount = 0;
	int alarmCount = 0;

	double gMeasurePct = 0.0d; //Set by default to 0, so that zero measures will show 0% health
	double bMeasurePct = 0.0d;
	double uMeasurePct = 0.0d;

	List alarms = null;
	String servers = null;
	String sites = null;
	String tests = null;
	ArrayList al_components=null;

	List userServers = user.getServers(false);
	if (userServers.size() > 0)
	{
		measureCount = user.getMeasuresCount();
		Map testNames = user.getTests();

		List serversWithHost = Server.getServersWithHostSystem(userServers, true, false);
		List list = new LinkedList();
		list.addAll(user.getSites());
		list.addAll(user.getServices());
		list.add("NULL");
		
		if (!allComp)
		{
			servers = StringUtils.getArrayAsString(serversWithHost.toArray(), '\'');
			al_components=new ArrayList();
			StringBuffer sb_components=new StringBuffer();
			for (int i=0;i<serversWithHost.size();i++)
			{
				if (i>0 && (i%250== 0))
				{
					String hostname=sb_components.toString();
					al_components.add(hostname);
					sb_components=new StringBuffer();
				}
				
				if (i==0 || sb_components.length()==0)
				{
					sb_components.append("'").append(serversWithHost.get(i)).append("'");
				}else
				{
					sb_components.append(",'").append(serversWithHost.get(i)).append("'");
				}
				
			}
			if (sb_components.length()>0)
			{
				al_components.add(sb_components.toString());
			}
			sites = StringUtils.getArrayAsString(list.toArray(), '\'');
		}
		tests = StringUtils.getArrayAsString(testNames.keySet().toArray(), '\'');
		ArrayList serverList = new ArrayList();
		if (!allComp)
		{
			StringTokenizer st1 = new StringTokenizer(servers, ",");
			while (st1.hasMoreTokens())
			{				
				serverList.add(st1.nextToken().trim());
			}
		}
		ArrayList siteList = new ArrayList();
		if (!allComp)
		{
			StringTokenizer st3 = new StringTokenizer(sites, ",");						
			while (st3.hasMoreTokens())
			{
				siteList.add(st3.nextToken().trim());
			}
		}

		EgDbAdapterUI egDb=EgDbAdapterTypeUI.getObject();
		egDb.setConnection();

		ResultSet rs = null;
		try
		{
			//badCount = 0;
			//unknownCount =0;
			if (allComp)
			{
				rs = egDb.getStateForMeasures("", "");
				//if (rs.next())	//it is called once again in getStateCounts
				{
					int [] measCount = getStateCounts(rs, serverList, siteList);
					
					if(measCount != null)
					{
						badMeasures = measCount[0];
						unknownMeasures = measCount[1];
					}
				}
				rs.close();
				rs = null;
			//}
				if (measureCount < (unknownMeasures+badMeasures))
				{
					//Update measureCount
					int newCount = egDb.getRealMeasuresCount(servers, sites);
					measureCount += newCount;
					user.setMeasuresCount(measureCount);
					registry.updateUser(user);
				}
			}else
			{
				int newCount=0;
				rs = egDb.getStateForMeasures ("",""); // servers and sites are dummy
				//if (rs.next())	//it is called once again in getStateCounts
				{
					int [] measCount = getStateCounts(rs, serverList, siteList);
					if(measCount != null)
					{
						badMeasures = measCount[0];
						unknownMeasures = measCount[1];
					}
				}
				rs.close();
				rs = null;
				if (measureCount < (unknownMeasures+badMeasures))
				{
					for (int i=0;i<al_components.size();i++)
					{
						String strserver=(String)al_components.get(i);
						newCount += egDb.getRealMeasuresCount(strserver, sites);
					}
					measureCount += newCount;
					//Update measureCount
					user.setMeasuresCount(measureCount);
					registry.updateUser(user);
				}
			}
			rs = egDb.getAllAlarms(user.getServerTypes());
			alarms = egDb.getResultSetAsList(rs);
			rs.close();
			egDb.releaseConnection(false);
		}
		catch(SQLException se)
		{
			se.printStackTrace();
			if (rs != null)
			{
				rs.close();
			}

			egDb.releaseConnection(true);
			if (alarms == null)
			{
				alarms = new LinkedList();
			}
		}
		EgDbAdapterTypeUI.releaseObject(egDb);


		if (!user.isSuperMonitor())
		{
			/*
			 * Filter out components that this user does not monitor
			 */
			List remove = new LinkedList();
			//List serversWithoutType = Server.getServersWithHostSystem(userServers, true, true);
			List serversWithType = Server.getServersWithHostSystem(userServers, true, false);
			for (Iterator i=alarms.iterator(); i.hasNext(); )
			{
				String[] row = (String[])i.next();
				String[] compNames = StringUtils.getTokens(row[0], "/");
				String compType = row[1];
				boolean found = false;
				for (int a=0; a<compNames.length; a++)
				{
					//if (serversWithoutType.indexOf(compNames[a]) > -1)
					if (serversWithType.indexOf(compType+":"+compNames[a]) > -1)
					{
						found = true;
						break;
					}
				}

				if (!found)
				{
					remove.add(row);
				}
			}

			if (remove.size() > 0)
			{
				alarms.removeAll(remove);
			}
	
			// new change to check if test is something we care about
			alarmCount = 0;
			for (int x=0; x<alarms.size(); x++)
			{
				String[] s = (String[]) alarms.get(x);
				if (s == null || s.length < 4)
					continue;
				String desc = s[3];
				StringTokenizer st = new StringTokenizer (desc,EgConstants.COMMA);
				int c = st.countTokens();
				boolean found = false;
				for (int r=0; r<c; r++)
				{
					String ndesc = st.nextToken();
					StringTokenizer st2 = new StringTokenizer (ndesc,"|");
					if (st2.countTokens() < 3)
						continue;
					st2.nextToken(); // ignore site
					st2.nextToken(); // ignore info
					String t = st2.nextToken();
					if (testNames != null && testNames.containsKey(t))
					{
						found = true;
						break;
					}
				}
				if (found) 
					alarmCount ++;
			}
		}
		else
			alarmCount = alarms.size();
		if (measureCount > 0)
		{
			double factor = 100.0d/measureCount;
			gMeasurePct = MathUtils.round((measureCount - unknownMeasures - badMeasures) * factor, 2);
			uMeasurePct = MathUtils.round(unknownMeasures * factor, 2);
			bMeasurePct = MathUtils.round(badMeasures * factor, 2);
		}
	}
%>
<html>
<head>
<title><%=ui.getDashboardHeading(IniUI.CURRENT_STATUS)%></title>
<link rel="stylesheet" href="/final/monitor/eg_styles/eg_monitorstyle.css" />
<!--meta http-equiv="refresh" content="<%=refreshTime%>;url=EgCurrentStatus.jsp"-->
</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" id="eg_innerbg">
<table width="100%" height="131" cellpadding="0" cellspacing="0" border="0">
<tr>
<td width="100%" valign="top">
<table width="100%" cellpadding="0" cellspacing="0" border="0" >
	<tr>
		<td width="100%" id="eg_cellbgmedium" height="22">
			<table width="100%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td  nowrap width="145">&nbsp;<%=ui.getDashboardHeading(IniUI.TOTAL_MEASUREMENTS)%></td>
					<td  nowrap width="20" align="center">:</td>
					<td  width="100%" style="font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;"><%=measureCount%></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td width="100%" class="cell_border" bgcolor="#E7E7E7" height="22" valign="top">
			<table width="100%" cellspacing="0" cellpadding="3" border="0" height="100%">
				<tr>
				<td>
					<span  style="text-align:center;width:100%; border-width:1 1px 1px 1;border-style:solid;border-color:#818181;background-color:#CCCCCC;padding-left:3px;padding-right:0px;padding-top:0px;">
							<table cellspacing="0" cellpadding="0" border="0" height="20">
								<tr>
									<td  nowrap width="80"  >&nbsp;<%=ui.getDashboardHeading(IniUI.PCT_ABNORMAL)%></td>
									<td id="HIGHalarms"  width="100%" background="eg_images/eg_layout/abnormal.gif">&nbsp;<font face="Arial,Verdana" style="font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;"><%=bMeasurePct%>%</font></td>
								</tr>
							</table>
					</span>
				</td>
				<td>
					<span  style="text-align:center;width:100%;border-width:1 1px 1px 1;border-style:solid;border-color:#818181;background-color:#CCCCCC;padding-left:3px;padding-right:0px;padding-top:0px">
							<table cellspacing="0" cellpadding="0" border="0" height="20">
								<tr>
									<td  nowrap width="80">&nbsp;<%=ui.getDashboardHeading(IniUI.PCT_UNKNOWN)%></td>
									<td id="UNKNOWNalarms" width="100%">&nbsp;<font face="Arial,Verdana" style="font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;"><%=uMeasurePct%>%</font></td>
									</tr>
							</table>
					</span>
				</td>
				<td style="padding-right:3px">
					<span  style="text-align:center;width:100%;border-width:1 1px 1px 1;border-style:solid;border-color:#818181;background-color:#CCCCCC;padding-left:0px;padding-right:0px;padding-top:0px">
							<table cellspacing="0" cellpadding="0" border="0" height="20">
									<tr>
										<td  nowrap width="70">&nbsp;<%=ui.getDashboardHeading(IniUI.PCT_HEALTHY)%></td>
										<td id="GOODalarms" width="100%">&nbsp;<font face="Arial,Verdana" style="font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;"><%=gMeasurePct%>%</font></td>
									</tr>
							</table>
					</span>	
				</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td width="100%" class="cell_border" bgcolor="#E7E7E7" height="26">
			<table width="100%" cellspacing="0" cellpadding="0" border="0" height="26">
				<tr>
					<td  nowrap width="145">&nbsp;<%=ui.getDashboardHeading(IniUI.OPEN_ALARMS)%></td>
					<td  nowrap width="20" align="center">:</td>
					<td width="100%" style="font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;"><%=alarmCount%></td>
				</tr>
			</table>
		</td>
	</tr>

<%
	if (alarmCount > 0)
	{
		DateTimeTokenizer dtt = new DateTimeTokenizer();
		dtt.setDateFormat(DateTimeTokenizer._YMD);
		dtt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
		dtt.setTimeFormat(DateTimeTokenizer.HMS);

		java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		EgDateInfo egDate = new EgDateInfo();
		sdf.setTimeZone(egDate.getRealTimeZone());
		java.util.Date now = new java.util.Date(egDate.egetDateUS());
		dtt.setEndDateTime(sdf.format(now));
		
		long totalDuration = 0l;
		long maxDuration = dtt.getDateDifference();
		
		for (Iterator i=alarms.iterator(); i.hasNext(); )
		{
			String[] row = (String[])i.next();
			dtt.setStartDateTime(row[5]);

			long difference = dtt.getDateDifference();
			maxDuration = Math.max(maxDuration, difference);
			totalDuration += difference;
		}

%>
	<tr>
		<td  class="cell_border" bgcolor="#E7E7E7"  align="center" height="26" >
			<table cellspacing="0" cellpadding="0" border="0" height="26" width="100%">
				<tr>
					<td nowrap  width="145">&nbsp;<%=ui.getDashboardHeading(IniUI.AVERAGE_DURATION)%></td>
					<td nowrap width="20" align="center">:</td>
					<td width="100%" style="font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;"><%=DateTimeTokenizer.getTimeDifference(totalDuration/alarmCount)%></td></tr>
			</table>
		</td>
	</tr>
	<tr>
		<td bgcolor="#E7E7E7"  class="cell_border" height="25" >
			<table cellspacing="0" cellpadding="0" border="0"  height="25"  width="100%">
				<tr>
					<td nowrap width="145">&nbsp;<%=ui.getDashboardHeading(IniUI.MAXIMUM_DURATION)%></td>
					<td nowrap width="20" align="center">:</td>
					<td width="100%" style="font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;"><%=DateTimeTokenizer.getTimeDifference(maxDuration)%></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
</table>
<td>
</tr>
</table>
</body>
</html>



<%!
//int badCount = 0;
//int unknownCount =0;
	private int[] getStateCounts(ResultSet rs, ArrayList servers, ArrayList sites)
	{
		//Hashtable ht = new Hashtable();
		int [] count = new int[2];
		int badCount = 0;
		int unknownCount =0;
		boolean found = false;

		try
		{

			if(rs != null)
			{
				while(rs.next())
				{
					// site cname ctype state
					String site = rs.getString(1);
					String ctype = rs.getString(2);
					String cname = rs.getString(3);
					String state = rs.getString(4);
					String s = "'"+ctype+':'+cname+"'";
					if (servers.size()>0 && !servers.contains(s))
						continue;
					if (sites.size()>0 && !sites.contains("'"+site+"'"))
						continue;
					found = true;					
					if (EgConfigInfo.isBad(state))
						badCount ++;	
					else
						unknownCount ++;
				}
			}
			if(!found) // ht == null || ht.size() == 0)
			{
				count[0] = 0;
				count[1] = 0;
				return count;
			}
			count[0] = badCount;
			count[1] = unknownCount;
			return count;
		}
		catch(Exception e)
		{
			return null;
		}
	}
%>