<%
/*
	File			:	ecDaywiseChangeDistribution.jsp
	Purpose			:	Display the list of changes daywise for the selected component type
	Creation Date	:	08-01-2009
	Author			:	Krishnamurthi
	UI Design		:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.egurkha.config.TimeLineBean"%>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "egurkha.config.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page import = "egurkha.config.EcFusionChartBean" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String[] duration = {"1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week"};

	private TreeMap getTreeMap(ArrayList al_components)
	{
		TreeMap tmap = null;
		if (al_components != null && !al_components.isEmpty())
		{
			tmap = new TreeMap();
			for(int i=0;i<al_components.size();i++)
			{
				String s_component = (String)al_components.get(i);
				String component_type = s_component.substring(s_component.lastIndexOf(":")+1);
				String component_name;

				if (component_type.equals("Oracle_server"))
				{
					StringTokenizer strTokens = new StringTokenizer(s_component,":");
					component_name = strTokens.nextToken() + ":" + strTokens.nextToken();
					component_type = strTokens.nextToken() + ":" + strTokens.nextToken();
				}
				else
					component_name = s_component.substring(0,s_component.lastIndexOf(":"));

				if (tmap.containsKey(component_type))
				{
					ArrayList al_temp = (ArrayList)tmap.get(component_type);
					al_temp.add(component_name);
				}
				else
				{
					ArrayList al_temp = new ArrayList();
					al_temp.add(component_name);
					tmap.put(component_type,al_temp);
				}
			}
		}
		return tmap;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDateInfo egDateInfo = new EgDateInfo();
	EcProcessChangeData processChangeData = new EcProcessChangeData();
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	boolean hasAllComponentAccess = userRole.hasAllComponentAccess();

	String componentType = request.getParameter("componentType");
	String selectionOption = "";
	if (componentType == null || componentType.equalsIgnoreCase("All"))
	{
		componentType = "All";
		selectionOption = "All Components";
	}
	else
	{
		selectionOption = "Component Type";
	}

	String defaultDuration = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","DaywiseChangeDistribution");
	String selectedDuration = request.getParameter("duration");
	if (selectedDuration == null)
	{
		Map dashboardDaySetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);
		String daySetting = (String)dashboardDaySetting.get(EgConfigConstants.DAYWISE_CHANGE_DISTRIBUTION);
		if (daySetting == null)
		{
			selectedDuration = defaultDuration;
		}
		else
		{
			selectedDuration = daySetting;
		}
	}

	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","BarChartColor");
	String barColorCode = (String)dashboardSetting.get(EgConfigConstants.BAR_COLOR);
	if (barColorCode != null)
	{
		if (barColorCode.indexOf("#") == -1)
			barColor = "#" + barColorCode;
		else
			barColor = barColorCode;
	}

	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	ArrayList aListComponentTypes = new ArrayList();
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	for(int i=0;i<aListAssociatedComponents.size();i++)
	{
		String s_component = (String)aListAssociatedComponents.get(i);
		String component_type = s_component.substring(0,s_component.indexOf(":"));
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if (!isConfigTestEnabled) continue;
		if (!aListComponentTypes.contains(component_type))
		{
			aListComponentTypes.add(component_type);
		}
	}
	if (aListComponentTypes.contains("Host_system"))
	{
		aListComponentTypes.remove("Host_system");
	}

	//UI Date Process - Start
	Map paramMap = new HashMap();
	paramMap.put("ec_timeline",new String[]{selectedDuration});
	paramMap.put("ec_prevtimeline",new String[]{selectedDuration});
	TimeLineBean timeLineBean = new TimeLineBean(paramMap);
	String startDate = timeLineBean.getStartDate();
	String startHour = timeLineBean.getStartHour();
	String startMinute = timeLineBean.getStartMinute();
	String endDate = timeLineBean.getEndDate();
	String endHour = timeLineBean.getEndHour();
	String endMinute = timeLineBean.getEndMinute();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String tempStartDate = DateUtil.changeDateFormat(startDate,"MM/dd/yyyy",currentDateFormat);
	String tempEndDate = DateUtil.changeDateFormat(endDate,"MM/dd/yyyy",currentDateFormat);
	//UI Date Process - End

	//Parameters - Start
	String option1[] = new String[]{"All Components"};
	String timeline[] = new String[]{selectedDuration};
	String prevtimeline[] = new String[]{selectedDuration};

	String strChangeType = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ShowChanges");
	if (strChangeType == null || strChangeType.length() == 0)
	{
		strChangeType = "All";
	}
	if (strChangeType.equalsIgnoreCase("Recent"))
	{
		strChangeType = "Latest";
	}
	else
	{
		strChangeType = "All";
	}

	String changeType[] = new String[]{strChangeType};

	String strViewChange = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ArrangeChanges");
	if (strViewChange == null || strViewChange.length() == 0)
	{
		strViewChange = "byInformation";
	}
	if (strViewChange.equalsIgnoreCase("Date"))
	{
		strViewChange = "byDate";
	}
	else
	{
		strViewChange = "byInformation";
	}

	String viewChange[] = new String[]{"byDate"};

	Map params = new HashMap();
	params.put("ec_option1",option1);
	params.put("ec_timeline",timeline);
	params.put("ec_prevtimeline",prevtimeline);
	params.put("ec_changetype",changeType);
	params.put("ec_viewchange",viewChange);
	params.put("user_language",new String[]{userLanguage});
	//Parameters - End

	ArrayList al_temp = new ArrayList();
	ArrayList al_components = new ArrayList();
	if (selectionOption.equals("Component Type"))
	{
		ArrayList aListTemp = user.getServersForType(componentType);
		for (int k=0;k<aListTemp.size();k++)
		{
			String strComp = (String)aListTemp.get(k);
			if (!aListAssociatedComponents.contains(strComp)) continue;
			al_temp.add(strComp);
		}
	}
	else
	{
		al_temp.addAll(aListAssociatedComponents);
	}
	for(int i=0;i<al_temp.size();i++)
	{
		String s_component = (String)al_temp.get(i);
		String component_type = s_component.substring(0,s_component.indexOf(":"));
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if(!isConfigTestEnabled) continue;
		String component_name = s_component.substring(s_component.indexOf(":")+1);
		al_components.add(component_name+":"+component_type);
	}
	TreeMap tmap_components = getTreeMap(al_components);

	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");

	EcChangeConfigurationBean ccbean = new EcChangeConfigurationBean(params,hasAllComponentAccess);
	ccbean.setTreeMap(tmap_components);
	ccbean.setHostAgentsMapping(hostAgentsMapping);
	TreeMap tmap_changeConfigDetails = ccbean.getChangeConfigurationData();

	String ec_criteria = request.getParameter("ec_criteria");
	String ec_userOption = request.getParameter("ec_userOption");
	
	String sampleValues = "";
	String barLabels = "";
	int maxCount = 0;
	String chartTitle = "";
	String linkUrl = " ";
	ArrayList aListLinks = new ArrayList();
	ArrayList aListColors = new ArrayList();
	ArrayList aListCount = new ArrayList();
	String aListLinkStr = " ";
	String aListColorStr = " ";
	String yAxisMaxValue = " ";

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("default"))
	{
		userDateFormat = currentDateFormat;
	}
	String format = DateUtil.getDateFormatForTimeLinechart(userDateFormat);

	String sampleAxisLabel = mappingInfo.getTextDescription("configmgmt.changes.daywise.Days") + " (" + format + ")";

	TreeMap tmapStart = new TreeMap();
	TreeMap tmapEnd = new TreeMap();

	ArrayList aListDates = new ArrayList();
	ArrayList aListChangeCount = new ArrayList();

	ArrayList aListChangesDatewiseTemp = null;
	if (tmap_changeConfigDetails != null && !tmap_changeConfigDetails.isEmpty())
	{
		ArrayList aListChangesDatewise = (ArrayList)tmap_changeConfigDetails.get("Change By Date");

		chartTitle = mappingInfo.getTextDescription("configmgmt.dashboard.Total Changes") + " : " + aListChangesDatewise.size();

		TreeMap tmapChanges = new TreeMap();
		if (selectedDuration.equalsIgnoreCase("1 day"))
		{
			Map paramMapTemp = new HashMap();
			paramMapTemp.put("ec_timeline",new String[]{selectedDuration});
			paramMapTemp.put("ec_prevtimeline",new String[]{selectedDuration});
			timeLineBean = new TimeLineBean(paramMapTemp);
			String sDate = timeLineBean.getStartDate();
			String eDate = timeLineBean.getEndDate();

			for (int x=0; x<aListChangesDatewise.size(); x++)
			{
				ArrayList aList_A = (ArrayList)aListChangesDatewise.get(x);

				String strDateTime = (String)aList_A.get(0);
				String strDate = strDateTime.substring(0,strDateTime.indexOf(" "));
				String strTime = strDateTime.substring(strDateTime.indexOf(" ")+1);
				String strHour = strTime.substring(0,strTime.indexOf(":"));

				if (sDate.equals(strDate))
				{
					Integer hourObject = new Integer(strHour.trim());
					Integer intObject = (Integer)tmapStart.get(hourObject);
					if (intObject == null)
					{
						tmapStart.put(hourObject,new Integer(1));
					}
					else
					{
						int value = intObject.intValue() + 1;
						tmapStart.put(hourObject,new Integer(value));
					}
				}
				else
				{
					Integer hourObject = new Integer(strHour.trim());
					Integer intObject = (Integer)tmapEnd.get(hourObject);
					if (intObject == null)
					{
						tmapEnd.put(hourObject,new Integer(1));
					}
					else
					{
						int value = intObject.intValue() + 1;
						tmapEnd.put(hourObject,new Integer(value));
					}
				}
			}

			for (int i=Integer.parseInt(startHour);i<=23;i++)
			{
				Integer key_hour = new Integer(i);
				Integer changeCount = (Integer)tmapStart.get(key_hour);
				if (!aListCount.contains(changeCount))
				{
					aListCount.add(changeCount);
				}

				if (changeCount == null)
				{
					sampleValues = sampleValues + ",x";
				}
				else
				{
					sampleValues = sampleValues + "," + changeCount.intValue();
				}
				barLabels = barLabels + "," + key_hour.intValue();
				if (changeCount != null)
				{
					linkUrl = "../servlet/com.eg.EcConfigurationServlet?request_from=DCDSForDashboard&ec_rtype=Change&ec_option1="+URLEncoder.encode(selectionOption)+"&ec_option2="+EgURLEncoder.encode(componentType,"UTF-8")+"&ec_timeline=Any&ec_prevtimeline=Any&ec_stdate_h="+URLEncoder.encode(tempStartDate)+"&ec_enddate_h="+URLEncoder.encode(tempEndDate)+"&ec_sthr_h="+startHour+"&ec_endhr_h="+endHour+"&ec_startmin_h="+startMinute+"&ec_endmin_h="+endMinute+"&ec_changetype="+strChangeType+"&selectDate="+URLEncoder.encode(startDate)+"&ec_viewchange="+strViewChange+"&timeZone="+key_hour+"&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
				}
				aListLinks.add(linkUrl);
				aListColors.add(barColor);
				if (changeCount == null)
				{
					maxCount = Math.max(maxCount,0);
				}
				else
				{
					maxCount = Math.max(maxCount,changeCount.intValue());
				}
			}

			for (int j=0;j<=Integer.parseInt(endHour);j++)
			{
				Integer key_hour = new Integer(j);
				Integer changeCount = (Integer)tmapEnd.get(key_hour);
				if (!aListCount.contains(changeCount))
				{
					aListCount.add(changeCount);
				}

				if (changeCount == null)
				{
					sampleValues = sampleValues + ",x";
				}
				else
				{
					sampleValues = sampleValues + "," + changeCount.intValue();
				}
				barLabels = barLabels + "," + key_hour.intValue();
				if (changeCount != null)
				{
					linkUrl = "../servlet/com.eg.EcConfigurationServlet?request_from=DCDSForDashboard&ec_rtype=Change&ec_option1="+URLEncoder.encode(selectionOption)+"&ec_option2="+EgURLEncoder.encode(componentType,"UTF-8")+"&ec_timeline=Any&ec_prevtimeline=Any&ec_stdate_h="+URLEncoder.encode(tempStartDate)+"&ec_enddate_h="+URLEncoder.encode(tempEndDate)+"&ec_sthr_h="+startHour+"&ec_endhr_h="+endHour+"&ec_startmin_h="+startMinute+"&ec_endmin_h="+endMinute+"&ec_changetype="+strChangeType+"&selectDate="+URLEncoder.encode(endDate)+"&ec_viewchange="+strViewChange+"&timeZone="+key_hour+"&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
				}
				aListLinks.add(linkUrl);
				aListColors.add(barColor);
				if (changeCount == null)
				{
					maxCount = Math.max(maxCount,0);
				}
				else
				{
					maxCount = Math.max(maxCount,changeCount.intValue());
				}
			}

			sampleAxisLabel = mappingInfo.getTextDescription("configmgmt.changes.daywise.Hours");
		}
		else
		{
			String selectedDurationTemp = new String(selectedDuration);
			selectedDurationTemp = selectedDurationTemp.substring(0,selectedDurationTemp.indexOf(" "));
			int idxDays = Integer.parseInt(selectedDurationTemp);

			if (selectedDuration.indexOf("week") > -1)
			{
				idxDays = idxDays * 7;
			}

			for (int i=idxDays;i>0;i--)
			{
				Map paramMapTemp = new HashMap();
				if (i == 1)
				{
					paramMapTemp.put("ec_timeline",new String[]{i+" day"});
					paramMapTemp.put("ec_prevtimeline",new String[]{i+" day"});
				}
				else
				{
					paramMapTemp.put("ec_timeline",new String[]{i+" days"});
					paramMapTemp.put("ec_prevtimeline",new String[]{i+" days"});
				}
				timeLineBean = new TimeLineBean(paramMapTemp);

				aListDates.add(timeLineBean.getStartDate());
				if (i == 1)
				{
					aListDates.add(timeLineBean.getEndDate());
				}
			}

			for (int j=0;j<aListDates.size();j++)
			{
				String tempDate = (String)aListDates.get(j);
				int changeCount = 0;
				for (int x=0; x<aListChangesDatewise.size(); x++)
				{
					ArrayList aList_A = (ArrayList)aListChangesDatewise.get(x);
					String strDateTime = (String)aList_A.get(0);
					if (strDateTime.startsWith(tempDate))
					{
						changeCount++;
					}
				}
				aListChangeCount.add(""+changeCount);
				if (!aListCount.contains(new Integer(changeCount)))
				{
					aListCount.add(new Integer(changeCount));
				}

				if (changeCount > 0)
				{
					linkUrl = "../servlet/com.eg.EcConfigurationServlet?request_from=DCDSForDashboard&ec_rtype=Change&ec_option1="+URLEncoder.encode(selectionOption)+"&ec_option2="+EgURLEncoder.encode(componentType,"UTF-8")+"&ec_timeline=Any&ec_prevtimeline=Any&ec_stdate_h="+URLEncoder.encode(tempStartDate)+"&ec_enddate_h="+URLEncoder.encode(tempEndDate)+"&ec_sthr_h="+startHour+"&ec_endhr_h="+endHour+"&ec_startmin_h="+startMinute+"&ec_endmin_h="+endMinute+"&ec_changetype="+strChangeType+"&selectDate="+URLEncoder.encode(tempDate)+"&ec_viewchange="+strViewChange+"&timeZone=&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
				}
				aListLinks.add(linkUrl);
				aListColors.add(barColor);
				if (changeCount == 0)
				{
					sampleValues = sampleValues + ",x";
				}
				else
				{
					sampleValues = sampleValues + "," + changeCount;
				}

				barLabels = barLabels + "," + StringUtils.replace(DateUtil.changeDateFormat(tempDate,"MM/dd/yyyy",format),",","");
				maxCount = Math.max(maxCount,changeCount);
			}
		}

		StringBuffer linkStrBuffer = new StringBuffer();
		StringBuffer linkStrBufferColors = new StringBuffer();
		if (aListLinks != null && aListLinks.size() > 0)
		{
			linkStrBuffer.append((String)aListLinks.get(0));
			linkStrBufferColors.append((String)aListColors.get(0));
			for (int i=1; i<aListLinks.size(); i++)
			{
				linkStrBuffer.append(",");
				linkStrBuffer.append(aListLinks.get(i));
				linkStrBufferColors.append(",");
				linkStrBufferColors.append(aListColors.get(i));
			}
		}
		aListLinkStr = linkStrBuffer.toString();
		aListColorStr = linkStrBufferColors.toString();
		maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
		sampleValues = sampleValues.substring(1);
		barLabels = barLabels.substring(1);
	}

	boolean flagEqualsOne = true;
	for (int i=1; i<aListCount.size(); i++)
	{
		Integer count_Value = (Integer)aListCount.get(i);
		if (count_Value != null && count_Value.intValue() > 1)
		{
			flagEqualsOne = false;
			break;
		}
	}
	if (flagEqualsOne)
	{
		yAxisMaxValue = "5";
	}
	else
	{
		yAxisMaxValue = "0";
	}
	
	//Fusion Column Chart Data starts--Rekha
	HashMap mapChartAttributes = new HashMap();//map for chart attributes
	mapChartAttributes.put("bgcolor","FFFFFF");
	mapChartAttributes.put("yAxisName","Changes");
	mapChartAttributes.put("xAxisName",sampleAxisLabel);
	mapChartAttributes.put("showToolTip","1");
	mapChartAttributes.put("showValues","1");
	mapChartAttributes.put("showBorder","0");
	mapChartAttributes.put("showShadow","1");
	mapChartAttributes.put("alpha","0");
	mapChartAttributes.put("canvasBgColor","F2F2F2");
	mapChartAttributes.put("canvasBgAlpha","60");
	mapChartAttributes.put("canvasBorderColor","000000");
	mapChartAttributes.put("canvasBorderThickness","1");
	mapChartAttributes.put("canvasBorderAlpha","30");
	mapChartAttributes.put("maxColWidth","40");
	mapChartAttributes.put("labelDisplay","AUTO");
	mapChartAttributes.put("placeValuesInside","1");
	mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
	mapChartAttributes.put("baseFont","Verdana,Normal");
	mapChartAttributes.put("baseFontSize","9");
	mapChartAttributes.put("unescapeLinks","0");
	mapChartAttributes.put("rotateValues","1");

	HashMap mapChartData = new HashMap();//map for chart data
	mapChartData.put("columnLabels",barLabels);
	mapChartData.put("columnValues",sampleValues);
	mapChartData.put("columnLinks",aListLinkStr);
	mapChartData.put("columnColors",aListColorStr);

	HashMap mapProperties = new HashMap();//map for misc properties
	mapProperties.put("showColors","true");
	mapProperties.put("enableLinks","true");

	EcFusionChartBean chartbean = new EcFusionChartBean();
	String xmlString = chartbean.getXMLDataForColumnChart(mapChartAttributes,mapChartData,mapProperties);
	//Fusion Column Chart Data ends
%>

<html>
<head>
<title></title>
<meta name="Author" content="Krishnamurthi">
<egui:skin ui="config"/>
<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="over-flow:hidden" bgcolor="#FFFFFF">

<table width="100%" align="center" border="0" class="body_text" cellpadding="0" cellspacing="0" id="innertable">
	<tr>
		<td height="20">
			<table cellspacing="0" cellpadding="0" border="0" width="100%">
				<tr height="20px">
<%
	if (selectedDuration.equalsIgnoreCase("1 day"))
	{
%>
					<td class="tdbackcolortop pLeft4" width="45%" nowrap><a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=DaywiseChangeDistribution&componentType=<%=URLEncoder.encode(componentType)%>&duration=<%=URLEncoder.encode(selectedDuration)%>&request_from=Dashboard&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_headlink_white"><b><egui:intnl text="configmgmt.dashboard.Changes Over Time"/></b></a></td>
<%
	}
	else
	{
%>
					<td class="tdbackcolortop pLeft4" width="45%" nowrap><a href="/final/servlet/com.eg.EcConfigurationServlet?cmd=DaywiseChangeDistribution&componentType=<%=URLEncoder.encode(componentType)%>&duration=<%=URLEncoder.encode(selectedDuration)%>&request_from=Dashboard&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_headlink_white"><b><egui:intnl text="configmgmt.dashboard.Daywise Change Distribution"/></b></a></td>
<%
	}
%>
					<td class="tdbackcolortop" align="right" width="35%" nowrap>
						<select name="componentType" onChange="javascript:goToDaywiseChangeDistribution()" style="width:165px">
<%
	if (aListComponentTypes != null && !aListComponentTypes.isEmpty())
	{
		if (aListComponentTypes.size() > 1)
		{
%>
						<option value='<%="All"%>' <%=(componentType != null && componentType.equals("All"))?"selected":""%>>
							<egui:intnl text="configmgmt.changes.daywise.All" />
						</option>
<%
		}
		ArrayList serverList = sorter.getSortedCompTypeList(aListComponentTypes);
		for (int j=0; j<serverList.size(); j++)
		{
			EgName nameObj = (EgName)serverList.get(j);
			String actualName = nameObj.getActualName();
			String localName = nameObj.getLocalName();

			String selected = "";
			if (componentType != null && componentType.equals(actualName))
				selected = "selected";
%>
						<option value="<%=actualName%>" <%=selected%>><%=localName%></option>
<%
		}
	}
	else
	{
%>
						<option value="-1">
						<egui:intnl text="configmgmt.changes.daywise.Not Applicable" />
						</option>
<%
	}
%>
						</select>
					</td>
					<td class="tdbackcolortop" width="20%" align="right" nowrap>
						<select name="duration" onChange="javascript:goToDaywiseChangeDistribution()" style="width:85px">
<%
	for (int u=0; u<duration.length; u++)
	{
		String strOption = duration[u];

		String selected = "";
		if (strOption.equals(selectedDuration))
			selected = "selected";

		String strValue = strOption.substring(0,strOption.indexOf(" "));
		String strText = strOption.substring(strOption.indexOf(" ")+1);
%>
						<option value="<%=duration[u]%>" <%=selected%>>
							<%=strValue%>&nbsp;<egui:intnl text='<%="configmgmt.common."+strText%>' />
						</option>
<%
	}
%>
						</select>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	if (tmap_changeConfigDetails != null && !tmap_changeConfigDetails.isEmpty())
	{
		String titleFont = "verdana,normal,11";
		String valueLabelFont = "letter-spacing:1px;verdana,normal,9";
		String barLabelFont = "verdana,normal,9";
		String sampleAxisLabelFont = "verdana,normal,11";
		String rangeAxisLabelFont = "verdana,normal,11";
		if (EgDbInfo.doubleByteEnabled || !userLanguage.equals("en_US"))
		{
			titleFont = iniUI.getFontName() + ",normal,11";
			valueLabelFont = "letter-spacing:1px;"+iniUI.getFontName() + ",normal,9";
			barLabelFont = iniUI.getFontName() + ",normal,9";
			sampleAxisLabelFont = iniUI.getFontName() + ",normal,11";
			rangeAxisLabelFont = iniUI.getFontName() + ",normal,11";
		}
%>
	<tr>
		<td width="100%" align="center">
			<table border="0" cellpadding="0" cellspacing="0" width="100%">
<%
		boolean flag = false;
		if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
		{
			flag = true;
		}
		if (flag)
		{
%>
				<tr>
					<td  height="2" id="blank">&nbsp; </td>
				</tr>
				<tr>
					<td align="center" width="100%" style="font-name:Verdana,Normal;font-size:8;"><b><%=chartTitle%><b></td>
				</tr>
				<tr>
					<td align="center" width="100%" bgcolor="white" nowrap>
						<!-- 
						<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="160" id="Column3D">
							<param name="movie" value="/final/FusionCharts/swf/Column3D.swf" />
							<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=450&chartHeight=160" />
							<param name="quality" value="high" />
							<param name="wmode" value="transparent"/>
							<embed src="/final/FusionCharts/swf/Column3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" quality="high" width="90%" height="160" name="Column3D" type="application/x-shockwave-flash" wmode="transparent" pluginspage="//www.macromedia.com/go/getflashplayer" />
						</object>
						 -->
						
						<div id="chartColumn3DContainerhome"  style="height:100%;"></div>
						<script type="text/javascript">
							if  ( FusionCharts( "myColumn3DChartIdhome" ) )
									FusionCharts( "myColumn3DChartIdhome" ).dispose();
							var myChart = new FusionCharts( "/final/FusionCharts/swf/Column3D.swf","myColumn3DChartIdhome", "90%", "160","0","1");
							myChart.setXMLData("<%=xmlString%>");
							myChart.setTransparent(true);
							myChart.render("chartColumn3DContainerhome");
						</script>
						
					</td>
				</tr>
<%
		}
		else
		{
%>
				<tr>
					<td height="2" id="blank">&nbsp; </td>
				</tr>
				<tr>
					<td align="center" width="100%" style="font-name:Verdana,Normal;font-size:8;"><b><%=chartTitle%><b></td>
				</tr>
				<tr>
					<td align="center" width="100%" bgcolor="white" nowrap>
						<!--
						<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="160" id="Column2D">
							<param name="movie" value="/final/FusionCharts/swf/Column2D.swf" />
							<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=450&chartHeight=160" />
							<param name="quality" value="high" />
							<param name="wmode" value="transparent" />
							<embed src="/final/FusionCharts/swf/Column2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=450&chartHeight=160" quality="high" width="90%" height="160" name="Column2D" type="application/x-shockwave-flash" wmode="transparent" pluginspage="//www.macromedia.com/go/getflashplayer" />
						</object>
						 -->
						<div id="chartColumn2DContainerhome"  style="height:100%;"></div>
						<script type="text/javascript">
							if  ( FusionCharts( "myColumn2DChartIdhome" ) )
									FusionCharts( "myColumn2DChartIdhome" ).dispose();
							var myChart = new FusionCharts( "/final/FusionCharts/swf/Column2D.swf","myColumn2DChartIdhome", "90%", "160","0","1");
							myChart.setXMLData("<%=xmlString%>");
							myChart.setTransparent(true);
							myChart.render("chartColumn2DContainerhome");
						</script>
					</td>
				</tr>
<%
		}

		if (selectedDuration.equalsIgnoreCase("1 day"))
		{
%>
				<param name="barwidth" value="0.8">
				<param name="barLabelAngle" value="300">
<%
			int s = 0;
			for (int i=Integer.parseInt(startHour);i<=23;i++)
			{
				Integer key_hour = new Integer(i);
				Integer changeCount = (Integer)tmapStart.get(key_hour);
				if (changeCount != null)
				{
%>
				<param name="url_0_<%=s%>" value="/final/servlet/com.eg.EcConfigurationServlet?request_from=DCDSForDashboard&ec_rtype=Change&ec_option1=<%=URLEncoder.encode(selectionOption)%>&ec_option2=<%=EgURLEncoder.encode(componentType,"UTF-8")%>&ec_timeline=Any&ec_prevtimeline=Any&ec_stdate_h=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate_h=<%=URLEncoder.encode(tempEndDate)%>&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&selectDate=<%=URLEncoder.encode(startDate)%>&ec_viewchange=byDate&timeZone=<%=key_hour%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>">
				<param name="urltarget_0_<%=s%>" value="">
<%
				}
				s++;
			}

			for (int j=0;j<=Integer.parseInt(endHour);j++)
			{
				Integer key_hour = new Integer(j);
				Integer changeCount = (Integer)tmapEnd.get(key_hour);
				if (changeCount != null)
				{
%>
				<param name="url_0_<%=s%>" value="/final/servlet/com.eg.EcConfigurationServlet?request_from=DCDSForDashboard&ec_rtype=Change&ec_option1=<%=URLEncoder.encode(selectionOption)%>&ec_option2=<%=EgURLEncoder.encode(componentType,"UTF-8")%>&ec_timeline=Any&ec_prevtimeline=Any&ec_stdate_h=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate_h=<%=URLEncoder.encode(tempEndDate)%>&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&selectDate=<%=URLEncoder.encode(endDate)%>&ec_viewchange=byDate&timeZone=<%=key_hour%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>">
				<param name="urltarget_0_<%=s%>" value="">
<%
				}
				s++;
			}
		}
		else
		{
%>
				<param name="barwidth" value="0.2">
				<param name="barLabelAngle" value="360">

<%
			for (int j=0;j<aListDates.size();j++)
			{
				String tempDate = (String)aListDates.get(j);
				String strChangeCount = (String)aListChangeCount.get(j);
				int changeCount = Integer.parseInt(strChangeCount);
				if (changeCount > 0)
				{
%>
				<param name="url_0_<%=j%>" value="/final/servlet/com.eg.EcConfigurationServlet?request_from=DCDSForDashboard&ec_rtype=Change&ec_option1=<%=URLEncoder.encode(selectionOption)%>&ec_option2=<%=EgURLEncoder.encode(componentType,"UTF-8")%>&ec_timeline=Any&ec_prevtimeline=Any&ec_stdate_h=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate_h=<%=URLEncoder.encode(tempEndDate)%>&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&selectDate=<%=URLEncoder.encode(tempDate)%>&ec_viewchange=byDate&timeZone=&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>">
				<param name="urltarget_0_<%=j%>" value="">
<%
				}
			}
		}
%>
			</table>
		</td>
	</tr>
<%
	}
	else
	{
%>
	<tr>
		<td align="center" width="100%" valign="middle">
			<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
				<tr>
					<td align="center" height="60%" valign="bottom"><img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'></td>
				</tr>
				<tr>
					<td align="center" valign="top"><egui:intnl text="configmgmt.dashboard.No configuration changes found" /></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
</table>

</body>
</html>



