<!DOCTYPE html>

<%@ include file="EcTracker.jsp" %>
<%@ page import = "java.util.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import = "com.eg.EgURLEncoder"%>


<%!
	public static String prepareEnocodedQueryString(Map params)
	{
		if (params == null || params.size() == 0) return "";
		String queryStr = "";
		try
		{
			Iterator itr = params.keySet().iterator();
			while (itr.hasNext())
			{
				String key = (String)itr.next();
				if (key.trim().length() == 0) continue;
				Object value= params.get(key);

				if (value instanceof String[])
				{
					String val[] =(String[])value;
					for(int i=0;i<val.length;i++)
						queryStr += key + "=" + EgURLEncoder.encode(val[i],"UTF-8") + "&";
				}
				else
				{
					if (value == null) value = "";
					queryStr += key + "=" + EgURLEncoder.encode((String)value,"UTF-8") + "&";
				}
			}
			if (queryStr.length() > 0) queryStr = queryStr.substring(0,queryStr.length()-1);
		}
		catch(Exception e)
		{
			queryStr = "";
		}
		return queryStr;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String queryString = prepareEnocodedQueryString(request.getParameterMap());
	if (queryString == null) queryString = "";
%>

<html>
<head>
	<meta charset="utf-8">

	<!--Skin color--------->
	<egui:skin ui = "configindex"/>

	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>


	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
	

	<script language="Javascript1.2" src="/final/config/scripts/ec_validate.js"></script>
	<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>

	<script language="JavaScript1.2">
		var csrfToken = '<%=strCsrfToken%>';
		var publicJSON = "";
		var queryString = '<%=queryString%>';
		var probsErrorMessage = '<egui:intnl text="config.error.Problem encountered while loading the user interface"/>';
		var requestTimeOut = '<egui:intnl text="config.error.Response timed out"/>';
		var errorTitle = '<egui:intnl text="config.user.Error"/>';
		
		var config = {
		title : {
			mainPageTitle : '<egui:intnl text="configmgmt.settings.display.User Display Settings" />',
			chartLabelTitle : '<egui:intnl text="configmgmt.settings.display.Bar chart color" />',
			clrCodeLabelTitle : '<egui:intnl text="configmgmt.settings.display.Color Code" />',
			homeLabelTitle : '<egui:intnl text="configmgmt.settings.display.Homepage"/>',
			osTitle : '<egui:intnl text="configmgmt.settings.display.Operating System for Software/Hotfix availability page"/>',
			viewBtnTitle : '<egui:intnl text="configmgmt.settings.display.View" />',
			infoLabelTitle : '<egui:intnl text="configmgmt.settings.display.Define the settings to be applied across the Configuration Management Module"/>',
			submitTitle : '<egui:intnl text="configmgmt.common.Update" />'
		},
		urls : {
			initialURL : "../config/UserSettings/data/UserSettingsJson.jsp",
			servletURL : "../servlet/com.eg.EcConfigurationServletNew"
		},
		msg :{
			errMsg1 : '<egui:intnl text="configmgmt.settings.display.Please enter the hex color code" />',
			errMsg2 : '<egui:intnl text="configmgmt.settings.dashboard.Please select an operating system" />',
			errMsg3 : '<egui:intnl text="configmgmt.settings.display.Please enter the valid hex color code" />',
			alertMsg : '<egui:intnl text="configmgmt.settings.dashboard.Settings updated successfully" />'
		}
	};
	</script>
	<script src="../config/UserSettings/app/app.js"></script>
	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>

</html>



