<%
/*
 *   File			:	EcServicesInformation.jsp
 *   Purpose		:	display the list of services with status for the selected operating system
 *   Creation Date	:	08-09-2006
 *   Author			:	Balasigamani
 *   UI Design		:	Jaiwin
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import ="egurkha.config.EcServiceResult"%>
<%@ page import ="egurkha.config.EcUtils"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="com.eg.EgURLEncoder"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	EcServiceResult serviceResult=(EcServiceResult)request.getAttribute("Result");
	EcUtils ecUtils = new EcUtils();

	String osName=serviceResult.getOsName();
	Vector osNameList=serviceResult.getOsList();
	if(osNameList!=null && osNameList.size()>0)
		osNameList.remove("Unknown");
	Map servicesData=serviceResult.getServiceData();
	ArrayList displayServicesName=serviceResult.getServicesName();
	Collections.sort(displayServicesName,String.CASE_INSENSITIVE_ORDER);

	String ec_criteria = request.getParameter("ec_criteria");
	String ec_userOption = request.getParameter("ec_userOption");
%>

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" id="innertable" height="100%">

<%
	if(displayServicesName!=null && displayServicesName.size()>0)
	{
%>
	<tr>
		<td valign="top">
			<div style="border:0px solid #000000">
			<table cellspacing="0" cellpadding="0" border="0" width="100%" style="table-layout:fixed"><col width="84%"><col width="8%"><col width="8%">
				<tr>
					<td align="center" class="table_header_dash" width="84%" height="20">
						&nbsp;<egui:intnl text="configmgmt.dashboard.Service Name" />
					</td>
					<td align="center" class="table_header_dash" width="8%" height="20" nowrap>
						<img style="text-align:center;" src="/final/config/images/run.png" title='<egui:intnl text="configmgmt.dashboard.Running" />'>
					</td>
					<td align="center" class="table_header_dash" width="8%" height="20" nowrap>
						<img style="text-align:center;" src="/final/config/images/stop.png" title='<egui:intnl text="configmgmt.dashboard.Stopped" />'>
					</td>
				</tr>
	
				<tr>
					<td colspan="3" valign="top" width="100%">
						<table width="100%" cellpadding="2" cellspacing="0" id="body_text" border="0" style="table-layout:fixed"><col width="84%"><col width="8%"><col width="8%">
<%
		for(int s=0;s<displayServicesName.size();s++)
		{
			int running=0;
			int stopped=0;
			int notAvailable=0;

			String serviceName=(String)displayServicesName.get(s); 
			Hashtable infoStatusList=(Hashtable)servicesData.get(serviceName);

			Iterator status=infoStatusList.keySet().iterator();
			while(status.hasNext())
			{
				String s_name=(String)status.next();
				String value=(String)infoStatusList.get(s_name);
				StringTokenizer str=new StringTokenizer(value,"#");
				int countValue=str.countTokens();
				if("Running".equalsIgnoreCase(s_name))
					running=countValue;
				else if("Stopped".equalsIgnoreCase(s_name))
					stopped=countValue;
				else
					notAvailable=countValue;
			}
%>
							<tr>
								<td align="left" width="84%" id="tdbacklightcolor2" wrap><a href="../servlet/com.eg.EcConfigurationServlet?cmd=ServiceDisplay&flagValue=MenuServices&osName=<%=URLEncoder.encode(osName)%>&serviceName=<%=EgURLEncoder.encode(serviceName,"UTF-8")%>&searchCriteria=equals&request_from=Service&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" class="eg_monlink">&nbsp;<%=serviceName%>&nbsp;</a></td>
								<td align="center" class="cell_border" width="8%"><%=running%></td>
								<td align="center" id="tdbacklightcolor2" width="8%"><%=stopped%></td>
							</tr>
<%
		}
%>
						</table>
					</td>
				</tr>
			</table>
			</div>
		</td>
	</tr>
<%
	}
	else
	{
%>
	<tr>
		<td align="center" valign="middle">
			<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
				<tr>
					<td align="center" height="50%" valign="bottom">
						<img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'>
					</td>
				</tr>
				<tr>
					<td align="center" valign="top" height="60">
						<egui:intnl text="configmgmt.dashboard.No service have been associated for this user" />
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
</table>



