<%
/*
 *   File		:	EcComponentsView.jsp
 *   Purpose	:	Shows the distribution of components across NetworkDevices and VirtualServers
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="com.egurkha.pdfmaker.*"%>
<%@ page import="egurkha.config.EcProcessData" %>
<%@ page import="egurkha.config.EcPrintData" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgConfigTestsInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="egurkha.config.EcFusionChartBean" %>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	Map dashBoardData=new TreeMap();
	ArrayList componentTypeList=new ArrayList();

	EgConfigTestsInfo configTestsInfo=new EgConfigTestsInfo("manager");
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList serverList = new ArrayList();
	String configSkin = user.getConfigSkin();
	String userName = user.getLoginID();
	EcProcessData processData=new EcProcessData();
	EgSpecsInfo specsInfo=new EgSpecsInfo("manager");
	EcPrintData printData=new EcPrintData();
	int pieChartLimit = configTestsInfo.getPieChartSamplesLimit();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	processData.setUserObject(user);
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	processData.setAssociatedComponents(aListAssociatedComponents);
	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");
	processData.setHostAgentsMapping(hostAgentsMapping);

	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");
	
	String selectedType = request.getParameter("selectedType");
	String componentType = request.getParameter("componentType");
	String strBackRequest = request.getParameter("back_request");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig"))
	{
		String[] selectedInformation = (String[]) request.getAttribute("Selected Informations");
		componentType = (String) selectedInformation[0];
	}
	String reqFrom = request.getParameter("requestFrom");
	String req_SaveSchedule = request.getParameter("request_from");
	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && req_SaveSchedule != null && req_SaveSchedule.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		selectedType = (String) scheduleDetails.get("selectedType");
		componentType = (String) scheduleDetails.get("componentSelect");
		submitOrNot = "false";
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
	}

	if (scheduleDetails != null && req_SaveSchedule != null && req_SaveSchedule.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	boolean isDisplay = true;
	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
		isDisplay = true;
	}

	if (req_SaveSchedule != null && req_SaveSchedule.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}
	String clickOn = request.getParameter("clickOn");
	String printPageTitle = "";
	String pageInfoCaption = "";
	String pageTitle = "";
	boolean goBack = false;
	boolean requestFromHomePage = false;
	if (reqFrom == null)
	{
		reqFrom = "compsView";
	}
	else if (reqFrom != null && reqFrom.equalsIgnoreCase("Devices"))
	{
		reqFrom = "HomePage";
		requestFromHomePage = true;
		goBack = true;
	}
	if (reqFrom != null && !reqFrom.equalsIgnoreCase("HomePage") && !reqFrom.equalsIgnoreCase("compsview"))
	{
		goBack = true;
	}

	selectedType = (selectedType == null)?"":selectedType;
	componentType = (componentType == null)?"":componentType;
	boolean isFromHome = (reqFrom != null && reqFrom.equals("Homepage"))?true:false;

	if (selectedType.equals("External"))
	{
		aListAssociatedComponents = processData.getNetworkDevices();
		printPageTitle = "Network_Devices";
		pageInfoCaption = "List of devices";
		pageTitle = "INVENTORY BY NETWORK DEVICES";
	}
	else if (selectedType.equals("Virtual"))
	{
		aListAssociatedComponents = processData.getVirtualComponents();
		printPageTitle = "Virtual_Platforms";
		pageInfoCaption = "List of Virtual Platforms";
		pageTitle = "INVENTORY BY VIRTUAL PLATFORMS";
	}
	else if (selectedType.equals("Server"))
	{
		ArrayList aListOthers = new ArrayList();
		aListOthers.addAll(processData.getNetworkDevices());
		aListOthers.addAll(processData.getVirtualComponents());
		aListAssociatedComponents.removeAll(aListOthers);

		printPageTitle = "Servers";
		pageInfoCaption = "List of Servers";
		pageTitle = "INVENTORY BY SERVERS";
	}

	for(int i=0;i<aListAssociatedComponents.size();i++)
	{
		String s_component = (String)aListAssociatedComponents.get(i);
		String component_type = s_component.substring(0,s_component.indexOf(":"));
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if (!isConfigTestEnabled) continue;
		if (!componentTypeList.contains(component_type))
		{
			componentTypeList.add(component_type);
		}
	}

	if (componentTypeList.contains("Host_system"))
	{
		componentTypeList.remove("Host_system");
	}

	if (componentTypeList!=null && componentTypeList.size()>1)
		componentTypeList.add(0,"All");

	if(componentType==null || componentType.length()==0)
	{
		if(componentTypeList!=null && componentTypeList.size()>0)
		{
			componentType=(String)componentTypeList.get(0);
		}
	}

	Map compDetails=(TreeMap)processData.getComponentsWithTypeMap(componentTypeList);
	ArrayList sortedList = processData.getSortedListForComponentsView(compDetails,userLanguage);

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String id = request.getParameter("id");
%>

<html>
<head>
<title>
	<egui:intnl text="configmgmt.dashboard.eG Configuration" /> : <egui:intnl text="configmgmt.inventory.view.Component Type Distribution" />
</title>
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="/final/config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>
<script language="JavaScript1.2" type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<script language="JavaScript1.2">

	function componentSearch()
	{
		var thisForm = document.ComponentOSType;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var componentName= thisForm.componentSelect.value;
		var selectedType = thisForm.selectedType.value;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if(componentName=="-1")
		{
			alert('<egui:intnl text="configmgmt.inventory.view.Please select a component type" />');
			return;
		}
		else
		{
			document.ComponentOSType.secsubmt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
			document.ComponentOSType.secsubmt.disabled=true;
			var reqFrom = '<%=reqFrom%>';
			thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=ComponentsView&requestFrom="+reqFrom+"&selectedType="+selectedType+"&componentType="+componentName+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption);
			thisForm.submit();
		}
	}
	
	function validSchedule()
	{
		var thisForm = document.ComponentOSType;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var componentName= thisForm.componentSelect.value;
		var selectedType = thisForm.selectedType.value;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if(componentName=="-1")
		{
			alert('<egui:intnl text="configmgmt.inventory.view.Please select a component type" />');
			return false;
		}
	}

	function printData()
	{
<%
		if(aListAssociatedComponents == null || aListAssociatedComponents.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}

		StringBuffer printQS = new StringBuffer();
		printQS.append("printType=CONFIG_PRINT");
		printQS.append("&printPageTitle="+printPageTitle);
		printQS.append("&Page=OS");   // Decide file to display for print in the controller
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function savePdf()
	{
<%
		if(aListAssociatedComponents == null || aListAssociatedComponents.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
		session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
		if (selectedType.equals("External"))
		{
			session.setAttribute("REPORT_NAME","InventoryReportByNetworkDevices");
		}
		else if (selectedType.equals("Virtual"))
		{
			session.setAttribute("REPORT_NAME","InventoryReportByVirtualPlatforms");
		}
		else if (selectedType.equals("Server"))
		{
			session.setAttribute("REPORT_NAME","InventoryReportByServers");
		}
		session.setAttribute("REPORT_LAYOUT","Portrait");
		session.setAttribute("PAGE_WIDTH_PDF","1100");
		session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
		session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
		if (aListAssociatedComponents == null || aListAssociatedComponents.size() == 0) 
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		sendMail();
	}

	function goHome()
	{
		window.location.href = '../servlet/com.eg.EcConfigurationServlet?cmd=Home&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
	}

	function getInformations()
	{
		var thisForm = document.ComponentOSType;
		thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=ComponentsView&requestFrom=<%=reqFrom%>&request_from=<%=req_SaveSchedule%>&id=<%=id%>";
		thisForm.submit();
	}

	function csv()
	{
<%
		if (aListAssociatedComponents == null || aListAssociatedComponents.size() == 0) 
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm = document.forms[0];
	thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function schedule(op)
	{
		var checkFlag = validSchedule();
		if(checkFlag == false) return;
		var thisForm = document.ComponentOSType;
		if (op == "schedule")
		{
<%
			if (req_SaveSchedule != null && req_SaveSchedule.equalsIgnoreCase("saveSchedule"))
			{
%>
				thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
			}
		else
			{
%>
				thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=compsView";
<%
			}
%>
		}
		else if (op =="favorite")
			thisForm.action = "/final/config/EcSaveFavorite.jsp";
		else
		{
			alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
			return;
		}
		thisForm.submit();
	}

	function goBackToSaveSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=req_SaveSchedule%>&id=<%=id%>";
		thisForm.submit();
	}


</script>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:auto" onLoad="bigScreen();">
<form name="ComponentOSType" method="POST" style="margin:0px">
<input type="hidden" name="ec_rtype" value="compsView">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="isSubmit" value="true">
<input type="hidden" name="selectedType" value="<%=selectedType%>">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">
<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">
	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<div style="border:0px blue solid;height:24px">
				<div style="border:0px solid;float:left;padding:5px" class="main_head_top">
					&nbsp;<b><%=mappingInfo.getTextDescription("configmgmt.inventory.view."+pageTitle)%></b>
				</div>
				<div style="border:0px solid red;float:right;height:22px;">
<%
	if(requestFromHomePage)
	{
%>
					<div style="border:0px solid red;height:22px;float:right;position:relative;margin-top:2px">
						<table  cellspacing="0" cellpadding="0" border="0" height="20">
							<tr>
								<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

								<td width="2" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>

								<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="printData()">  </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>

								<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"></td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>
							</tr>
						</table>
					</div>
<%
	}
%>
					<div style="border:0px solid;float:right;padding:5px">
<%
	if (goBack)
	{
%>
						<a id='mousehand' onClick="goHome();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
<%
	}
	else if (req_SaveSchedule != null && req_SaveSchedule.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mousehand' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</div>
				</div>
			</div>
		</td>
	</tr>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
<%
	clickOn = (clickOn == null)?"":clickOn;
	if (!clickOn.equalsIgnoreCase("pie") && !clickOn.equalsIgnoreCase("legend"))
	{
%>
			<!-- new tab start here -->
<%
		if (!requestFromHomePage)
		{
%>
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
			if (vecCriterias != null && !vecCriterias.isEmpty())
			{
				for(int i=0; i<vecCriterias.size(); i++)
				{
					String selected = "";
					String strCriteria = (String)vecCriterias.get(i);
					if(ec_criteria != null && strCriteria.equals(ec_criteria))
					{
						selected = "selected";
					}
%>
						<option value="<%=strCriteria%>" <%=selected%>>
							<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
						</option>
<%
				}
			}
			else
			{
%>
				<option value="-1">
					<egui:intnl text="configmgmt.common.Not Applicable" />
				</option>
<%
			}
%>
									</select>
								</td>
<%
			if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
			{
%>
								<td align="right" nowrap>
<%
				if (ec_criteria.equalsIgnoreCase(criterias[0]))
				{
%>
					<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
				}
				else if (ec_criteria.equalsIgnoreCase(criterias[1]))
				{
%>
					<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
				}
				else
				{
%>
					<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
				}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
				if (vecUserOptions != null && !vecUserOptions.isEmpty())
				{
					for(int i=0; i<vecUserOptions.size(); i++)
					{
						String selected = "";
						String strUserOption = (String)vecUserOptions.get(i);
						if(ec_userOption != null && strUserOption.equals(ec_userOption))
						{
							selected = "selected";
						}
%>
						<option value="<%=strUserOption%>" <%=selected%>>
							<%=strUserOption%>
						</option>
<%
					}
				}
				else
				{
%>
					<option value="-1">
						<egui:intnl text="configmgmt.common.Not Applicable" />
					</option>
<%
				}
%>
									</select>
								</td>
<%
			}
			else
			{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
			}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed" id="text_bold"> <col width="100"><col width="100"><col width="10"><col width="250"><col width="80"><col width="10"><col width="250"><col width="100">
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr height="20"> 
											<td  align="center">&nbsp;</td>
											<td colspan="6" align="center">
												<egui:intnl text="configmgmt.inventory.view.Component Type" />&nbsp;:&nbsp;
												<select name="componentSelect">
<%
			if (componentTypeList != null && !componentTypeList.isEmpty())
			{
				for(int i=0; i<componentTypeList.size(); i++)
				{
					String compType1 = (String)componentTypeList.get(i);
					if (compType1.equals("All")) continue;
					serverList.add(compType1);
				}

				if (componentTypeList != null && componentTypeList.size() > 1)
				{
					String selected = "";
					if (componentType != null && componentType.equals("All"))
					{
						selected = "selected";
					}
%>
													<option value="All" <%=selected%>><egui:intnl text="configmgmt.inventory.view.All" /></option>
<%
				}

				serverList = sorter.getSortedCompTypeList(serverList);
				if (componentTypeList.size()>0)
				{
					for (int j=0; j<serverList.size(); j++)
					{
						EgName nameObj = (EgName)serverList.get(j);
						String actualName = nameObj.getActualName();
						String localName = nameObj.getLocalName();
						String selected = "";
						if(componentType != null && componentType.equals(actualName))
							selected = "selected";
%>
													<option value="<%=actualName%>" <%=selected%>><%=localName%></option>
<%
					}
				}
			}
			else
			{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.view.Not Applicable" />
													</option>
<%
			}
%>
												</select>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="8" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center" colspan="1">&nbsp;</td>
												<td align="right" colspan="5" valign="middle" height="20"> 
<%
			if (req_SaveSchedule != null && req_SaveSchedule.equalsIgnoreCase("saveSchedule"))
			{
%>
													<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<%
			}
			else
			{
%>
													<input type="button"  name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:componentSearch()" >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<%
			}
%>
											</td>
											<td align="right"  colspan="2" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" ></td>

														<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()">  </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13" ></td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="7" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
	}
%>

				<tr>
					<td id="padding6" height="100%" width="100%" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
							<tr>
								<td align="center" width="100%" height="100%" valign="top" class="bgwhite">
								<!-- <div id="div_scroll" style="width:100%;height:390px;border:0px solid #CBD8CC"> -->
									<table width="100%" border="0" cellspacing="0" cellpadding="0" height="40%">
<%
	if (componentTypeList != null && !componentTypeList.isEmpty() && submitOrNot.equals("true") && isDisplay)
	{
%>
										<tr>
											<td height="20" id="bgdark" class="whitefont" >
												&nbsp;<b><egui:intnl text='<%="configmgmt.inventory.view."+pageInfoCaption%>'/>
											</td>
										</tr>
<%
	}
%>
										<tr>
											<td  height="5" id="blank">&nbsp; </td>
										</tr>
<%
	String countValue="";
	String countName="";
	String colorValue="";

	//PDF work starts
	ArrayList tableList = new ArrayList();
	EgPdfData pdfData = new EgPdfData();
	EgReportAttributes reportAttributes = new EgReportAttributes();
	String pdfTitle = "INVENTORY REPORT BY NETWORK DEVICES";
	String reportName = "NetworkDevicesInventory";
	if (selectedType.equals("Virtual"))
	{
		pdfTitle = "INVENTORY REPORT BY VIRTUAL PLATFORMS";
		reportName = "VirtualPlatformsInventory";
	}
	else if (selectedType.equals("Server"))
	{
		pdfTitle = "INVENTORY REPORT BY SERVERS";
		reportName = "ServersInventory";
	}
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
		pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view." + pdfTitle) + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
	}
	else
	{
		pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view." + pdfTitle) + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
	}

	String pdfSubTitle = "";
	if (!componentType.equals("All"))
	{
		pdfSubTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.Distribution of components under")+ " " + mappingInfo.getComponentTypeDescription(componentType);
	}

	reportAttributes.setMainTitle(pdfTitle);
	reportAttributes.setSubTitle(pdfSubTitle);
	reportAttributes.setReportName(reportName);
	reportAttributes.setModule("CONFIG");
	reportAttributes.setPortrait(false);
	pdfData.setAttributes(reportAttributes);

	EgTableAttributes egTableAttributes = new EgTableAttributes();
	ArrayList aListColumnNames = new ArrayList();
	ArrayList aListData = new ArrayList();

	if(compDetails!=null && compDetails.size()>0 && submitOrNot.equals("true") && isDisplay)
	{
		TreeMap resultMapForPie = new TreeMap();
		String titleName = "";
		if (selectedType.equals("External"))
		{
			resultMapForPie = (TreeMap)processData.getNetworkDevicesMap(userLanguage);
			if (processData.isPieChartLimitCrossed())
			{
				titleName = mappingInfo.getTextDescription("configmgmt.inventory.view.Total Network Devices")+" ("+mappingInfo.getTextDescription("configmgmt.inventory.view.Top")+" "+pieChartLimit+")";
			}
			else
			{
				titleName = mappingInfo.getTextDescription("configmgmt.inventory.view.Total Network Devices");
			}
		}
		else if (selectedType.equals("Virtual"))
		{
			resultMapForPie = (TreeMap)processData.getVirtualServersMap(userLanguage);
			if (processData.isPieChartLimitCrossed())
			{
				titleName = mappingInfo.getTextDescription("configmgmt.inventory.view.Total Virtual Platforms")+" ("+mappingInfo.getTextDescription("configmgmt.inventory.view.Top")+" "+pieChartLimit+")";
			}
			else
			{
				titleName = mappingInfo.getTextDescription("configmgmt.inventory.view.Total Virtual Platforms");
			}
		}
		else if (selectedType.equals("Server"))
		{
			resultMapForPie = (TreeMap)processData.getServersMap(aListAssociatedComponents,userLanguage);
			if (processData.isPieChartLimitCrossed())
			{
				titleName = mappingInfo.getTextDescription("configmgmt.inventory.view.Total Servers")+" ("+mappingInfo.getTextDescription("configmgmt.inventory.view.Top")+" "+pieChartLimit+")";
			}
			else
			{
				titleName = mappingInfo.getTextDescription("configmgmt.inventory.view.Total Servers");
			}
		}

		// Print
		printData.setMapData(compDetails);
		printData.setListData(sortedList);
		printData.setComponent(componentType);

		EgTable egTable = new EgTable();
		egTableAttributes = new EgTableAttributes();

		if (componentType.equals("All") && compDetails.size() > 1)
		{
			int total = 0;
			String sortByCountFlag = configTestsInfo.getSortTypeForComponentsView();
			boolean sortByCount = false;

			if (sortByCountFlag != null && sortByCountFlag.equalsIgnoreCase("true") || sortByCountFlag.equalsIgnoreCase("yes"))
			{
				sortByCount = true;
			}
			String color = "color";
			int colorCount = 0;
			if (sortByCount)
			{
				Iterator itForPie = resultMapForPie.keySet().iterator();
				
				Object[] objArr = resultMapForPie.keySet().toArray();
				int arrLen = objArr.length;
				int endLimit = 0;
				if (processData.isPieChartLimitCrossed())
				{
					endLimit = arrLen-pieChartLimit;
				}
				for (int j = arrLen-1; j >= endLimit; j--)
				{
					String tmpCompType = (String)objArr[j];
					ArrayList tmpCompList = (ArrayList)resultMapForPie.get(tmpCompType);
					tmpCompType = tmpCompType.substring(tmpCompType.indexOf("#@#")+3);
					colorCount++;
					colorValue += configTestsInfo.getServerDisplayValue("DASHBOARD_OS_COLOR",color+colorCount)+",";
					tmpCompType = mappingInfo.getComponentTypeDescription(tmpCompType);
					countValue += tmpCompList.size()+",";
					countName += tmpCompType+",";
					total += tmpCompList.size();
				}
			}
			else
			{
				ArrayList resultForPie = (ArrayList)resultMapForPie.get("result");
				int endLimit = resultForPie.size();
				if (processData.isPieChartLimitCrossed())
					endLimit = pieChartLimit;

				for (int j=0; j < endLimit; j++)
				{
					Hashtable ht = (Hashtable)resultForPie.get(j);
					Iterator htIt = ht.keySet().iterator();
					if (htIt.hasNext())
					{
						String compType = (String)htIt.next();
						ArrayList compsList = (ArrayList)ht.get(compType);
						colorCount++;
						colorValue += configTestsInfo.getServerDisplayValue("DASHBOARD_OS_COLOR",color+colorCount)+",";
						compType = mappingInfo.getComponentTypeDescription(compType);
						countValue += compsList.size()+",";
						countName += compType+",";
						total += compsList.size();
					}
				}
			}

			if (countValue.endsWith(","))
				countValue = countValue.substring(0,countValue.length()-1);
			if (countName.endsWith(","))
				countName = countName.substring(0,countName.length()-1);
			if (colorValue.endsWith(","))
				colorValue = colorValue.substring(0,colorValue.length()-1);

			titleName += " : "+total;

			ArrayList pieDataList = new ArrayList();//for legend
			ArrayList piecolorList = new ArrayList(); //color list for legend
			String legendLabel = "";
			String legendColor = "";

			StringTokenizer strColor =  new StringTokenizer(colorValue,",");
			while (strColor.hasMoreTokens())
			{
				String temp_pieColor = strColor.nextToken();
				piecolorList.add(temp_pieColor.substring(temp_pieColor.indexOf("#")+1,temp_pieColor.length()));
			}

			StringTokenizer strToken = new StringTokenizer(countName,",");
			while (strToken.hasMoreTokens())
			{
				String strOs = strToken.nextToken();
				pieDataList.add(strOs);
			}

			//Fusion Pie Chart Data starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("enablesmartLabels","0");
			mapChartAttributes.put("showToolTip","0");
			mapChartAttributes.put("showPercentValues","0");
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				mapChartAttributes.put("pieRadius","90");
			}
			else
			{
				mapChartAttributes.put("pieRadius","60");
			}
			mapChartAttributes.put("showBorder","0");

			HashMap mapChartData = new HashMap();//map for chart data
			mapChartData.put("pieLabels",countName);
			mapChartData.put("pieValues",countValue);
			mapChartData.put("pieColors",colorValue);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showLabels","false");
			mapProperties.put("showColors","true");
			mapProperties.put("enableLinks","false");

			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForPieChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Pie Chart Data ends

			//print data start
			printData.setChartTitle(titleName);
			printData.setSampleLabel(countName);
			printData.setSampleValue(countValue);
			printData.setSampleColor(colorValue);
			//print data end

			boolean flag = false;
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				flag = true;
			}
			if (flag)
			{
%>
										<tr>
											<td align="center" valign="top" height="265" class="white_bg">
												<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="265" bgcolor="#FFFFFF" valign="center">
													<tr>&nbsp;
														<td colspan="2" align="center" width="100%">
															<b><%=titleName%></b>
														</td>
													</tr>
													<tr>
														<td align="right" width="55%" bgcolor="white" nowrap>
															<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="300" height="125" id="Pie3D">
																<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
																<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" />
																<param name="quality" value="high" />
																<param name="wmode" value="transparent"/>
																<embed src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" quality="high" width="300" height="125" name="Pie3D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
															</object> -->
															<div id="chartPieView3DContainer"  style="height:100%;"></div>
															<script type="text/javascript">
																if  ( FusionCharts( "myPieView3DChartId" ) )
																		FusionCharts( "myPieView3DChartId" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","myPieView3DChartId", "300", "300","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("chartPieView3DContainer");
															</script>
														</td>
														<td width="45%" align="center" valign="middle">
															<table border="0" width="100%"  cellspacing="1" cellpadding="1">
<%
				for( int k = 0;k < pieDataList.size();k++)
				{
					legendLabel = (String)pieDataList.get(k);
					legendColor = (String)piecolorList.get(k);
%>
																<tr>
																	<td width ="3%">
																		<table  cellpadding="0" cellspacing="0" border="0" align="center">
																			<tr>
																				<td height="6px" align="right" valign="middle" width="6px" class="border" style="background-color:<%=legendColor%>">
																				</td>
																			</tr>
																		</table>
																	</td width="97%">
																	<td align="left" valign="middle" style="font-name:Verdana;font-size:9;font-weight:plain"><%=legendLabel%>
																	</td>
																</tr>
<%
				}
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
			}
			else
			{
%>
										<tr>
											<td align="center" valign="top" height="265" class="white_bg">
												<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="265" bgcolor="#FFFFFF" valign="center">
													<tr>&nbsp;
														<td colspan="2" align="center" width="100%">
															<b><%=titleName%></b>
														</td>
													</tr>
													<tr>
														<td align="right" width="55%" bgcolor="white" nowrap>
															<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="300" height="125" id="Pie2D">
																<param name="movie" value="/final/FusionCharts/swf/Pie2D.swf" />
																<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" />
																<param name="quality" value="high" />
																<param name="wmode" value="transparent"/>
																<embed src="/final/FusionCharts/swf/Pie2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" quality="high" width="300" height="125" name="Pie2D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
															</object> -->
															<div id="chartPieView2DContainer"  style="height:100%;"></div>
															<script type="text/javascript">
																if  ( FusionCharts( "myPieView2DChartId" ) )
																		FusionCharts( "myPieView2DChartId" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie2D.swf","myPieView2DChartId", "300", "300","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("chartPieView2DContainer");
															</script>
														</td>
														<td width="45%" align="center" valign="middle">
															<table border="0" width="100%"  cellspacing="1" cellpadding="1">
<%
				for( int k = 0;k < pieDataList.size();k++)
				{
					legendLabel = (String)pieDataList.get(k);
					legendColor = (String)piecolorList.get(k);
%>
																<tr>
																	<td width ="3%">
																		<table  cellpadding="0" cellspacing="0" border="0" align="center">
																			<tr>
																				<td height="6px" align="right" valign="middle" width="6px" class="border" style="background-color:<%=legendColor%>">
																				</td>
																			</tr>
																		</table>
																	</td width="97%">
																	<td align="left" valign="middle" style="font-name:Verdana;font-size:9;font-weight:plain"><%=legendLabel%>
																	</td>
																</tr>
<%
				}
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td  height="5" id="blank">&nbsp; </td>
										</tr>
<%
			}

			//pdf image
			egTableAttributes.setImageData(true);
			aListColumnNames.add("Image");
			aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=DASHBOARD_OS&chartType=PieChart&height=150&width=500&chartTitle="+URLEncoder.encode(titleName)+"&sampleValues="+URLEncoder.encode(countValue)+"&sampleLabels="+URLEncoder.encode(countName)+"&sampleColors="+URLEncoder.encode(colorValue)+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));
			////PDF work

			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);
			tableList.add(egTable);
			egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.inventory.view.List of componets under each component type"));
			egTableAttributes.setStartX(0);
		}
		session.setAttribute("print_comp_information",printData);

		for (int n =0 ; n<sortedList.size(); n++)
		{
			egTableAttributes = new EgTableAttributes();
			Hashtable ht = (Hashtable)sortedList.get(n);
			Iterator htIt = ht.keySet().iterator();
			String compType = "";
			if (htIt.hasNext())
			{
				compType = (String)htIt.next();
			}

			if (!componentType.equals("All") && !compType.equals(componentType))
			{
				continue;
			}
			ArrayList compList = (ArrayList)ht.get(compType);
%>
										<tr>
											<td align="center" width="100%" valign="top">
												<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" >
													<tr>
														<td >
															<table border="0" cellspacing="0" cellpadding="0" class="body_text linesquare" width="100%">
<%
			//PDF table data
			aListColumnNames = new ArrayList();
			aListData = new ArrayList();
			ArrayList userColumnNames = new ArrayList();

			aListColumnNames.add("C0");
			aListColumnNames.add("C1");
			aListColumnNames.add("C2");
			aListColumnNames.add("C3");

			userColumnNames.add("C0");
			if (selectedType.equals("External"))
			{
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Devices"));
			}
			else if (selectedType.equals("Virtual"))
			{
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Virtual Platforms"));
			}
			else if (selectedType.equals("Server"))
			{
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Servers"));
			}

			userColumnNames.add("");
			userColumnNames.add("");
%>
																<tr>
																	<td id="bglight" align="left" width="20%" height="20"> &nbsp;<b><%=mappingInfo.getComponentTypeDescription(compType)%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.view.Count"/>&nbsp;:&nbsp;<%=compList.size()%>)</b></td>
																</tr>
<%
			int count = compList.size();
			int j=0;
			if (count <=3)
			{
				count = 3;
			}
			else if(count %3 != 0)
			{
				count = count +3- count % 3;
			}
%>
																<tr>
																	<td width="100%">
																		<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
<%
			if (compList!= null)
			{
				for (j=0; (j<compList.size() || j < count); j++)
				{
					if (j%3 == 0)
					{
						aListData.add(mappingInfo.getComponentTypeDescription(compType)+" ("+mappingInfo.getTextDescription("configmgmt.inventory.view.Count")+" : "+compList.size()+")");
%>
																			<tr>
<%
					}
					if ( j <compList.size())
					{
						String compName=(String)compList.get(j);
						String tmpCompType = compName.substring(0,compName.indexOf(":"));
						String tmpCompName = compName.substring(compName.indexOf(":")+1);
						compName = tmpCompName +":"+ tmpCompType;
						if (tmpCompName.endsWith(":NULL"))
							tmpCompName = tmpCompName.substring(0,tmpCompName.indexOf(":"));
						aListData.add(tmpCompName);
%>
																				<td width="30%" id="cell_bg1"> <a href= "../servlet/com.eg.EcConfigurationServlet?ec_rtype=Current&request_from=<%=reqFrom%>&old_comptype=<%=compType%>&ec_comptype=<%=compType%>&ec_component=<%=EgURLEncoder.encode(compName,"UTF-8")%>&selectedType=<%=selectedType%>&cType=<%=componentType%>&requestFrom=<%=reqFrom%>&clickOn=<%=clickOn%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"> &nbsp;<%=tmpCompName%></a></td>
<%
					}
					else
					{
%>
																				<td width="30%" id="cell_bg1"><%aListData.add("");%>&nbsp;</td>
<%
					}
					if (j%3 == 2)
					{
%>
																			</tr>
<%
					}
				}
			}
%>
																		</table>
																	</td>
																</tr>
<%
			//PDF data
			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTableAttributes.setColumnNames(userColumnNames);
			egTableAttributes.setDataGrouping(true);
			egTableAttributes.setDataGroupingField(0);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);
			tableList.add(egTable);
			//PDF ends
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td  height="10" id="blank">&nbsp;</td>
										</tr>
<%
			pdfData.setData(tableList);
			session.setAttribute("pdfData",pdfData);
		}
%>
								</table>
								</td>
							</tr>
<%
	}
	else if ((compDetails == null || compDetails.isEmpty()) && submitOrNot.equals("true") && isDisplay)
	{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else if (submitOrNot.equals("false") || !isDisplay)
	{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else 
	{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center"> <img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'> </td>
													</tr>
													<tr>
														<td align="center"><b><egui:intnl text="configmgmt.inventory.view.No components available for this type" /></b></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>



