<%
/*****************************************************************************************************
*	Name		:	EgTopologyB.jsp
*	Purpose		:	To display the segment topology using Java Script & Raphael JS Library
******************************************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "egurkha.EgCrawlerAdmin" %>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ taglib prefix = "egui" uri="../../../WEB-INF/eg-taglib.tld" %>
<%@ page import = "java.util.*" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<%

try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	String ua = request.getHeader( "User-Agent" );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
	IniFile udTests=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");
	String segmentName = request.getParameter("segment");
	String zoomLevel = request.getParameter("zoom");
	String view = request.getParameter("view");
	String defaultPos = request.getParameter("default");

	String color = "A0A0A0";
	String dark = "150517";
	
	String topologySkin=_user.getAdminSkin();
	String bgColor = "";
	String compNameColor="";
	String fontFamily="LucidaGrandeRegular";
	String fontFamilyBold="LucidaGrandeBold";
	String mouseOverLineColor = "";
	String mouseOverTextColor="";
	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	
	if(topologySkin!=null && topologySkin.equalsIgnoreCase("Dark"))
	{
		bgColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","BgColor");
		compNameColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","ComponentNameColor");
		mouseOverLineColor = "";
		mouseOverTextColor=egUi.getValue("TOPOLOGY_DARK_BACKGROUND","MouseOverTextColor");
	}
	else
	{
		bgColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","BgColor");
		compNameColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","ComponentNameColor");
		mouseOverLineColor = "";
		mouseOverTextColor=egUi.getValue("TOPOLOGY_LIGHT_BACKGROUND","MouseOverTextColor");
	}

	if(zoomLevel == null)
	{
		zoomLevel = "100";
	}
	boolean isFull = false;
	if(view!=null && view.equals("full"))
		isFull = true;

	String site = request.getParameter("site");
	String phyTopology = request.getParameter("physical_topology");
	if(site == null)
		site = "egurkha.physical.topology";

	String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/js_topology.ini";
	IniFile jsTopoIniObj  = EgConfigFilesSync.getInstance(iniFileName);
	String subjectName = site+ "~|#|~"+segmentName;
	String[] allLines = jsTopoIniObj.getLinesUnderSubject(subjectName);
//	if(allLines == null || allLines.length == 0)
//	{
//		subjectName = segmentName;
//		allLines = jsTopoIniObj.getLinesUnderSubject(subjectName);
//	}

	String iniZoom = jsTopoIniObj.getValue(subjectName,"zoom");
	if(iniZoom != null && iniZoom.length() > 0 )
	{
		zoomLevel = iniZoom;
	}
	EgConfigFilesSync.releaseInstance(jsTopoIniObj);

	boolean isPosition = false;
	StringBuffer positionBuffer = new StringBuffer();
	if(allLines!=null)
	{
		List positionList = Arrays.asList(allLines);
		positionBuffer.append(positionList.toString().substring(1,positionList.toString().indexOf("]")));
		isPosition = true;
	}

	if(defaultPos !=null && defaultPos.equals("true"))
		isPosition = false;

%>
<html>
<head>

<meta charset="utf-8" http-equiv="X-UA-Compatible" content="IE=8,9,10" >
<title><%=segmentName%></title>
<script src="/final/scripts/map.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/scripts/raphael.js" type="text/javascript" charset="utf-8"></script>
<script src="/final/scripts/raphael.zoom.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="/final/extjs/ext-all.js"></script>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script type="text/javascript">

function bringToFront(obj)
{
	if (!document.getElementsByTagName)
		return;
	var divs = getAbsoluteDivs();  
	var max_index = 0;  
	var cur_index;  
	for (i = 0; i < divs.length; i++)
	{
		var item = divs[i];
		if (item == obj || item.style.zIndex == '')
			continue;
		cur_index = parseInt(item.style.zIndex);
		if (max_index < cur_index)
		{
			max_index = cur_index;
		}
	}
		obj.style.zIndex = max_index + 1;
}

function getAbsoluteDivs()  
{
	var arr = new Array();
	var all_divs = document.body.getElementsByTagName("DIV");
	var j = 0;
	for (i = 0; i < all_divs.length; i++)
		if (all_divs.item(i).style.position=='absolute')
		{
			arr[j] = all_divs.item(i);
			j++;
	}
	return arr;
}

function hideLoadImage ()
{
	var loading_image = parent.document.getElementById("loading_image");
	if (loading_image != null)
	{
		loading_image.style.visibility = "hidden";
		loading_image.style.display = "none";
	}
}

function getXMLObject()  //XML OBJECT
{
	var xmlHttp = false;
	try 
	{
		xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
	}
	catch (e) 
	{
		try 
		{
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch (e2) 
		{
			xmlHttp = false;
		}
	}
	if (!xmlHttp && typeof XMLHttpRequest != 'undefined') 
	{
		xmlHttp = new XMLHttpRequest();
	}
	return xmlHttp;
}

var xmlhttp;
function savePositions(str)
{
	var segmentname ='<%=segmentName%>';
	var siteName = '<%=site%>';

	segmentname = siteName+"~|#|~"+segmentname;

	var url = "/final/servlet/com.eg.SegmentPositionServlet";
	var zoomHidden = document.getElementById("zoom").value;
	var params;

	if(str == 'save')
	{
		var keys = compPosition.listKeys();
		params ="action="+str+"&segment="+segmentname+"&total="+keys.length+"&zoom="+zoomHidden;
		for(var k=0;k<keys.length;k++)
		{
			var key = keys[k];
			var val = compPosition.get(key);
			params = params+"&key"+k+"="+key+"&val"+k+"="+val;
		}
	}
	else if (str == 'zoom')
	{
		params = "action="+str+"&segment="+segmentname+"&zoom="+zoomHidden;
	}
	else if(str == 'delete')
	{
		params = "action="+str+"&segment="+segmentname;
	}

	xmlhttp = new getXMLObject();
	if(xmlhttp)
	{
		xmlhttp.open("POST",url,true);
		xmlhttp.onreadystatechange  = function()
		{
			if (xmlhttp.readyState == 4) 
			{
				if(xmlhttp.status == 200) 
				{
					if(str == 'save')
					{
						Ext.Msg.show({
							title : 'SERVICES',
							msg : 'Component positions have been saved successfully.',
							icon : 'iconInformation',
							buttons : Ext.Msg.OK
						});
					}
				}
				else 
				{
					Ext.Msg.show({
						title : 'SERVICES',
						msg : "Error occured. Please try again ...",
						icon : 'iconExclamation',
						buttons : Ext.Msg.Ok
					});
				}
			}
		}
		xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlhttp.send(params);
	}
}

function resetPositions()
{
	var segmentname ='<%=segmentName%>';
	var site ='<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	var zoom = document.getElementById('zoom').value;
	var isfull = '<%=isFull%>';
	var myUrl = "EgTopologyB.jsp?segment="+encodeURIComponent(segmentname)+"&default=true&zoom="+zoom+"&site="+encodeURIComponent(site)+"&physical_topology="+phyTopo;
	if(isfull == 'true')
		myUrl = myUrl + "&view=full";
		setTimeout(function(){
		window.location = myUrl;
	}, 0);
}

var $j = jQuery.noConflict();

Ext.onReady(function(){
		setSlider();
	});
	
function setSlider()
{
	Ext.define('AlwaysVisibleTip', {
		extend: 'Ext.slider.Tip',
		id:'mytip',
		cls: 'yellowTip',
		init: function(slider) {
			var me = this;
			me.callParent(arguments);
			slider.removeListener('dragend', me.hide);
			slider.on({
				scope: me,
				change: me.onSlide,
				afterrender: {
					fn: function() {
						me.onSlide(slider, null, slider.thumbs[0]);
						tip_hide_task.delay(2000);


					},
					delay: 100
				}
			});
		}
	});

	var tip_hide_task = new Ext.util.DelayedTask(function(){
		if (Ext.getCmp('mytip') != undefined)
		{
		  Ext.getCmp('mytip').hide();
		}
	});

	Ext.create("Ext.form.Panel", {
	//width:108,
	renderTo: Ext.getBody(),
	baseCls:'emptyCls',
	height:210,
	border:0,
	plain:true,
	bodyStyle:{'background':'transparent'},
	style:{'position':'absolute','top':'10px','left':'10px','background':'transparent'},
	items: [
		{
			xtype: 'container',
			items: [{
				xtype: 'button',
				cls:'zoomInbt',
				width:18,
				height:18,
			  handler: function() {
				var sliderValue=Ext.getCmp('sliderSingle').getValue();
				sliderValue=parseInt(sliderValue);
				if(sliderValue<150)
				{
					sliderValue=sliderValue+10;
					
				}
				if(sliderValue>150)
				{
					sliderValue=150;
				}
				Ext.getCmp('sliderSingle').setValue(sliderValue);
				tip_hide_task.delay(2000);
				setZoomLevel(sliderValue);
			  }
			   
			},
        Ext.create('Ext.slider.Single', {
        hideLabel: true,
		id:'sliderSingle',
        useTips: false,
		animate: false,
		plugins: [Ext.create('AlwaysVisibleTip')],
        height: 118,
		value: '<%=zoomLevel%>',
        vertical: true,
        minValue: 10,
        maxValue: 150,
		listeners : {
			
			'changecomplete' : function( slider, e, eOpts )
			{
				var sliderValue=Ext.getCmp('sliderSingle').getValue();
				setZoomLevel(sliderValue);
				
			}
		}
    }), 
			{
				xtype: 'button',
				width:18,
				height:18,
				style:{'margin-top':'-6px'},
				cls:'zoomOutbt',
			  handler: function() {
					var sliderValue=Ext.getCmp('sliderSingle').getValue();
					sliderValue=parseInt(sliderValue);
					if(sliderValue>10)
					{
						sliderValue=sliderValue-10;
					}
					if(sliderValue<10)
					{
						sliderValue=10;
					}
				  Ext.getCmp('sliderSingle').setValue(sliderValue);
				  tip_hide_task.delay(2000);
				  setZoomLevel(sliderValue);
			  }
			}
        ]
    }]
   });
}

function hideDivs(divId)
{
	var show_div = document.getElementById(divId);
	if(show_div!=null)
	{
		show_div.style.display="none";
	}
}

function showDivs(divId)
{
	var show_div = document.getElementById(divId);
	if(show_div!=null)
	{
		show_div.style.display = 'block';
		show_div.style.position = 'absolute';
		bringToFront(show_div);
	}
}

function openBigDiv()
{
	var mySegment = '<%=segmentName%>';
	var site ='<%=site%>';
	var phyTopo = '<%=phyTopology%>';
	var myUrl = "Services/data/EgTopologyB.jsp?segment="+encodeURIComponent(mySegment)+"&view=full&site="+encodeURIComponent(site)+"&physical_topology="+phyTopo;
	//newwindow=window.open(myUrl,'Topology','width='+screen.width+',height='+screen.height+', status=yes,scrollbars=no,resizable=yes');
	newwindow=window.open(myUrl,'Topology','width=800,height=600,left=10,top=10, status=yes,scrollbars=yes,resizable=yes');
	if (window.focus) {newwindow.focus()}
		return false;
}

</script>
<egui:skin ui="admin"/>
</head>
<%
	String finalTopoStr = getTopologyString(segmentName , site , phyTopology);
	String conPath = request.getContextPath();
	String contextPath1 = request.getContextPath()+"/images/component_icons/";
	String contextPath = request.getContextPath()+"/images/"+topologySkin+"/component_icons/";
	String ICImagePath=request.getContextPath()+"/images/"+topologySkin+"/ic_images/";
	//Get row & column spacing from eg_ui.ini .... (Begin)
	IniUI iniUI = IniUI.getInstance();
	String rs =	iniUI.getValue("TOPOLOGY_OPTIONS","Row_space");
	String cs = iniUI.getValue("TOPOLOGY_OPTIONS","Column_space");
	iniUI =  null;
	int rowspace = 50;
	int colspace = 50;
	try
	{
		if(rs!=null) rowspace = Integer.parseInt(rs);
	}
	catch(Exception e){
	}

	try
	{
		if(cs!=null) colspace = Integer.parseInt(cs);
	}
	catch(Exception e){
	}
	//Get row & column spacing from eg_ui.ini .... (End)

	EgNewTopology egNewTopo= new EgNewTopology(finalTopoStr,rowspace,colspace);
	ArrayList postionArrList = egNewTopo.getOutputValues();

	int divHeight = egNewTopo.getHeight();
	int divWidth  = egNewTopo.getWidth();

	StringBuffer outPutBuffer = new StringBuffer();
	if(postionArrList!=null)
	{
		outPutBuffer.append(postionArrList.toString().substring(1,postionArrList.toString().indexOf("]")));
	}
	//getting data from eg_lang_US.ini file
	/*ArrayList tokeList = new ArrayList();
	for(int i=0;i<postionArrList.size();i++)
	{
		String key =(String)postionArrList.get(i);
		
		StringTokenizer tokenizer = new StringTokenizer(key,",");
		String tokenVal=tokenizer.nextToken();
		tokeList.add(tokenVal);
	}
	ArrayList keyList= new ArrayList();
	for(int i=0;i<tokeList.size();i++)
	{
		String t_key=(String)tokeList.get(i);
		String key = t_key.substring(0,t_key.indexOf("="));
		keyList.add(key);
		
	}
	StringBuffer pnameBuffer = new StringBuffer();
	ArrayList valueList = new ArrayList();
	boolean isName = true;
	String delim="";
	String val="";
	for(int i=1;i<keyList.size();i++)
	{
		delim="=";
		String key1=(String)keyList.get(i);
		String keyValue=key1.substring(0,key1.indexOf(":"));
		String keyinValue="";
		if(keyValue.indexOf("Agg_")==0)
		{
			keyinValue=keyValue.substring(4);
			
		}
		else
		{
			keyinValue=keyValue;
		}
		String value=_mapping.getComponentTypeDescription(keyinValue);
		
			val+=(keyinValue+":"+value+""+delim);
		
	}
	
	valueList.add(val);
	
	if(valueList.size()>0)
	{
		
		pnameBuffer.append(valueList.toString().substring(1,valueList.toString().indexOf("]")));
		
		isName=true;
	}
	*/	
//end
	String compCategoryMapping="";
	String pnameBuffer="";
	eGComponentCategory compCategoryObj = eGComponentCategory.getInstance();
	for(int i=0;i<postionArrList.size();i++)
	{
		String line=(String)postionArrList.get(i);
		StringTokenizer tokenizer = new StringTokenizer(line,",");
		String var=tokenizer.nextToken();
		if(var.startsWith("egurkha.physical.topology"))
			continue;
		String comp_Type=var.substring(0,var.indexOf(":"));
		String category  ="";
		if(comp_Type.equals("Group"))
		{
			category="group";
		}
		else if(comp_Type.endsWith("_ex"))
		{
			if (comp_Type.toLowerCase().startsWith("agg_"))
			{
				category = "aggregate";
			}
			else
			{
				category = udTests.getValue("COMP_DISPLAYIMAGE_NICK",comp_Type);
			}
		}
		else if(comp_Type.toLowerCase().startsWith("agg_"))
		{
			category="AGGREGATES";
		}
		else
		{
			category=compCategoryObj.getCategoryforCompType(comp_Type);
		}
		compCategoryMapping+=(comp_Type+":"+category+"=");
		if(comp_Type.toLowerCase().indexOf("agg_")==0)
		{
			comp_Type=comp_Type.substring(4);
		}
		String value=_mapping.getComponentTypeDescription(comp_Type);
		pnameBuffer+=(comp_Type+":"+value+"=");
		
	}
	if(compCategoryMapping.endsWith("="))
	{
		compCategoryMapping=compCategoryMapping.substring(0,compCategoryMapping.lastIndexOf("="));
	}
	if(pnameBuffer.endsWith("="))
	{
		pnameBuffer=pnameBuffer.substring(0,pnameBuffer.lastIndexOf("="));
	}
	
%>
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="adminTopologyBg">
<form name="topologyForm" id="topologyForm" style="margin:0px;padding:0px;">
<div id="ZoomDiv" name="ZoomDiv" style="display:none;left:20px;top:6px;width:200px;border:0px solid #ff0000; position:absolute;z-Index:100;">

<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" >
		<tr>
			<td class="attach_left_curve"><img src="/final/monitor/eg_images/spacer.gif" width="4px" border="0px"></td>
			<td height="24px" class="attach_bg" align="left" valign="middle">
				<table  border="0" cellspacing="0" cellpadding="3">
					<tr>
						<td><a href="javascript:void(0);" class="topo_zoomOutImg" title="Zoom out" onclick="javascript:setZoomLevel('1');"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"></a></td>

						<td valign="top" style="padding:0px;margin:0px"><input type="text" name="zoomTxt" id="zoomTxt" value="100%" size="5" class="linesquare" readonly="readonly" disabled="disabled" style="margin-top:3px"></td>

						<td><a href="javascript:void(0);" class="topo_zoomInImg" title="Zoom in" onclick="javascript:setZoomLevel('-1');"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"></a></td>

						<td class="topo_divide" ><img src="/final/admin/eg_images/spacer.gif" width="2" height="19" border="0"></td>
<%
	if(isFull)
	{
%>
						<td><a href="javascript:void(0);" class="topo_newwindowImg" name='maxImage' id='maxImage' onclick="javascript:self.close();" title="Close"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"></a></td>
<%
	}
	else
	{
%>
						<td><a href="javascript:void(0);" class="topo_newwindowImg" name='maxImage' id='maxImage' onclick="javascript:openBigDiv();" title="New window"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"></a></td>
<%
	}
%>
						<td><a href="javascript:void(0);" class="topo_saveImg" onclick="javascript:savePositions('save');" title="Save position"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"></a></td>

						<td><a href="javascript:void(0);" class="topo_resetImg" onclick="javascript:resetPositions();" title="Reset position"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"></a></td>
					</tr>
				</table>
			</td>
			<td class="attach_right_curve"><img src="/final/monitor/eg_images/spacer.gif" width="4px"  border="0px"></td>
		</tr>
	</table> 
</div>

<%
	String savePosMsg = _mapping.getTextDescription("admin.zone.Component positions have been saved successfully");
	if(isFull)
	{
		String full_style = "width:100%;height:100%;border:0px solid #ff0000;position:absolute;top:0px;left:0px;";
		if(isMSIE)
		{
			full_style = "width:100%;height:100%;border:0px solid #ff0000;position:absolute;top:0px;left:0px;";
		}
%>
	<div id="container" class="div_scroll" style="<%=full_style%>">
<%
	}
	else
	{
%>
	<div id="container" class="div_scroll" style="width:100%;height:100%;border:0px solid blue">
<%
	}
%>
	<table  border="0" cellspacing="0" cellpadding="0" >
		<tr>
			<td >
				<div  id="paper"  name="paper" style="width:100%;height:100%;z-index:10;border:0px solid green"></div>
			</td>
		</tr>
	</table>
	</div>

	<div id="positionDiv" name = "positionDiv" style="display:none;left:50px;top:50px;width:193px;height:80px;border:0px solid #ff0000; position:absolute;z-Index:150">

	<table  border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
		<tr>
			<td class="alert_topleft"><img src="/final/admin/eg_images/spacer.gif" width="7" height="7"></td>
			<td class="alert_topbg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="1" height="7"></td>
			<td class="alert_topright" ><img src="/final/admin/eg_images/spacer.gif" width="13" height="7"></td>
		</tr>
		<tr>
			<td class="alert_leftbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="1"></td>
			<td class="eg_morelight" height="100%">
				<table cellspacing="0" cellpadding="0" border="0" width="100%">
					<tr>
						<td width="100%"> 
							<table cellpadding="2" cellspacing="0" border="0" width="100%">
								<tr>
									<td  align="center" class="eg_75bold"></td>
									<td align="right">
										<div style="display:block;text-align:right"><a id="closeLink" class="mouse" onclick="hideDivs('positionDiv');"><img src="/final/admin/eg_images/winclose.gif" border="1" class="mouse" title="close"></a>
										</div>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td align="center" nowrap width="160" valign="top"  style="padding:4px"><%=savePosMsg%><br>
						</td>
					</tr>
					<tr>
						<td  align="center" nowrap width="160" valign="top"  style="padding:4px"><input type="button" class="eg_lightbutton " name="okButton" id="okButton" value="OK" onclick="javascript:hideDivs('positionDiv');"style="padding-left:4px;padding-right:4px">
						</td>
					</tr>
				</table>
			</td>
			<td class="alert_rightbg"><img src="/final/admin/eg_images/spacer.gif" width="13" height="1"></td>
		</tr>
		<tr>
			<td class="alert_bottomleft"><img src="/final/admin/eg_images/spacer.gif" width="7" height="7"></td>
			<td class="alert_bottombg"><img src="/final/admin/eg_images/spacer.gif" width="1" height="14"></td>
			<td class="alert_bottomright"><img src="/final/admin/eg_images/spacer.gif" width="13" height="14"></td>
		</tr>
	</table>
	</div>

<script type="text/javascript">

var zom = parseInt('<%=zoomLevel%>')/100;
var width = 916;
var height = 520;

if('<%=isFull%>' == 'true')
{
	width = screen.width;
	height = screen.height;
}

var gifWidth = 48*zom;
var gifHeight = 48*zom;

var userWidth = 48*zom;
var userHeight = 48*zom;


var el;
var componentStateMap = new Map; 
var compPosition = new Map;
var mainComponent = new Array();
var connectionArr = new Array();
var arr = new Array();
var allCompNames = new Array();

var compIndexMap = new Map();
var topostring ='<%=finalTopoStr%>';
var positionString ='<%=outPutBuffer%>';
var iniMaxW = 0;
var iniMaxH = 0;
// addding
var aggrigateCompMap = new Map();
var egtop_iniMap = new Map();
var alltpNames = new Array();
//end
r = Raphael("paper", width, height);
r.initZoom();
var compCategoryMapping='<%=compCategoryMapping%>';
var compGroupMap = new Map();

r.customAttributes.CompType = function (compType) {
		return {CompType : compType};
};
// Zoom supports from 10% to 150%
function setZoomLevel(zoomHidden)
{
	var zInt = parseInt(zoomHidden);
	zInt = zInt.toFixed();
	document.getElementById("zoom").value = zInt;
	setZoom(zInt / 100);
	savePositions("zoom");
}

function setZoom(zoom)
{
	var holderDiv = document.getElementById("paper");
	var holderH = document.getElementById("paper").clientHeight;
	var holderW = document.getElementById("paper").clientWidth;
	zom = zoom;
	var regW = holderW>iniMaxW?holderW:iniMaxW;
	var regH = holderH>iniMaxH?holderH:iniMaxH;
	if(regW < 916) regW = 916;
	if(regH < 512) regH = 512;
	holderDiv.style.width = regW;
	holderDiv.style.height = regH;
	if(zoom <=1)
	{
		r.setSize(regW, regH);
	}
	else
	{
		r.setSize(1.2*regW*zoom,regH*zoom);
	}
	r.setZoom(zoom);
	if(parent.document.getElementById("zoomValue")!=null)
		parent.document.getElementById("zoomValue").value= (zom * 100).toFixed();
}

setZoom(zom);

function resizePaperDiv(w, h)
{
	var intW = w;
	var intH = h;
	var resize = "false";

	var holderDiv = document.getElementById("paper");
	var holderH = document.getElementById("paper").clientHeight;
	var holderW = document.getElementById("paper").clientWidth;
	
	if(intW > 916)
	{
		resize = "true";
	}
	else
	{
		intW = 916;
	}

	if(intH > 520)
	{
		resize ="true";
	}
	else
	{
		intH = 520;
	}
	if(resize == "true")
	{
		r.setSize(intW*zom,intH*zom);
	}
}

function getMapDetails(posString)
{
	var changeHeight = '<%=divHeight%>';
	var changeWidth = '<%=divWidth%>';

	var intW = parseInt(changeWidth);
	var intH = parseInt(changeHeight);
	resizePaperDiv(intW, intH);

	// Get Positions from ini File (Begin) , if it is already saved.
	var position = '<%=isPosition%>';
	var iniPositionArr = new Array();
	var iniMap = new Map();
	if(position == 'true')
	{
		var allvec = '<%=positionBuffer.toString()%>';
		iniPositionArr = allvec.split(", ");
	}

	for(var i=0; i<iniPositionArr.length;i++)
	{
		var arrElement =  iniPositionArr[i];
		var iniMapKey =  arrElement.substring(0,arrElement.indexOf("="));
		var iniMapValue = arrElement.substring(arrElement.indexOf("=")+1);
		iniMap.put(iniMapKey,iniMapValue);
	}
	// Get Positions from ini File (End)  
	//adding Data
		
		var inidataArr = new Array();
		var positionName = '<%=pnameBuffer.toString()%>';
		inidataArr=positionName.split("=");
		
		for(var i=0;i<inidataArr.length;i++)
		{
			var arrElement =  inidataArr[i];
			
			var iniMapKey =  arrElement.substring(0,arrElement.indexOf(":"));
			var iniMapValue = arrElement.substring(arrElement.indexOf(":")+1);
			
			egtop_iniMap.put(iniMapKey,iniMapValue);
			
			
		}
	//end
	var compGrpArr = new Array();
	if(compCategoryMapping!=null )
	{
		compGrpArr=compCategoryMapping.split("=")
		for(var i=0;i<compGrpArr.length;i++)
		{
			var arrElement =  compGrpArr[i];
			var iniMapKey =  arrElement.substring(0,arrElement.indexOf(":"));
			var iniMapValue = arrElement.substring(arrElement.indexOf(":")+1);
			compGroupMap.put(iniMapKey,iniMapValue);
		}
	}
	var tokens = posString.split(", ");
	var compInd = 0;
	var resize = "false";
	iniMaxW = intW;
	iniMaxH = intH;

	for(var i=0; i<tokens.length;i++)
	{
		var tokvalue = tokens[i];
		var key = tokvalue.substring(0,tokvalue.indexOf("="));
		var rhs = tokvalue.substring(tokvalue.indexOf("=")+1);

		if(key.indexOf(":")==0)
		{
			key = 'egurkha.physical.topology';
		}

		if(iniMap.contains(key)) // Load Position from INI File......
		{
			var iniXY  = iniMap.get(key);
			var iniX = parseInt(iniXY.substring(0,iniXY.indexOf("#")));
			var iniY = parseInt(iniXY.substring(iniXY.indexOf("#")+1));

			if(iniX >= iniMaxW)
			{
				resize = "true";
				iniMaxW = iniX + 200;
			}

			if(iniY >=iniMaxH)
			{
				resize = "true";
				iniMaxH = iniY + 100;
			}
			
			if(key == 'egurkha.physical.topology') // User Image
			{
				arr.push(r.image('<%=contextPath%>'+'user_image.png', iniX*zom, iniY*zom , userWidth , userHeight).attr({"CompType":"user_image",title :"User"}));
				compPosition.put(key,iniX*zom+"#"+iniY*zom);
			}
			else	// Other components....
			{
				var comptype = key.substring(0,key.indexOf(":")); 
				var compCategory=compGroupMap.get(comptype);
				var comptip = key.substring(key.indexOf(":")+1);
				if(comptip.indexOf(":NULL")>0)
					comptip = comptip.substring(0,comptip.indexOf(":NULL"));
				var compImage="";
				if(comptype!=null && (comptype.match("_ex$")=="_ex" || (comptype.indexOf("Agg_")==0)))
				{
					if(comptype == 'Group')
					{
						compImage = r.image('<%=contextPath1%>'+'group.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					}
					else if(comptype.match("_ex$")=="_ex")
					{
						compImage = r.image('<%=ICImagePath%>'+compCategory+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					}
					else
					{
						//if(comptype.indexOf('Agg_')==0)
						//{
							//aggrigateCompMap.put(comptip,comptype);
							//compImage = r.image('<%=contextPath%>aggregate.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({title : comptip});
						//}
						//else
						//{
							//compImage = r.image('<%=contextPath%>'+comptype+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({title : comptip});
						//}
						compImage = r.image('<%=contextPath%>'+compCategory+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					}
				}
				else
				{
					if(comptype == 'Group')
						compImage = r.image('<%=contextPath1%>'+'group.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					else
						compImage = r.image('<%=contextPath%>'+compCategory+'.png', iniX*zom, iniY*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
				}
				arr.push(compImage);
				compPosition.put(key, iniX*zom+"#"+iniY*zom);
			}
		}
		else
		{
			if(key == 'egurkha.physical.topology') //User
			{
				var xy = rhs;
				var xPos = parseInt(xy.substring(0,xy.indexOf("#")));
				var yPos = parseInt(xy.substring(xy.indexOf("#")+1));
				arr.push(r.image('<%=contextPath%>'+'user_image.png', xPos*zom, yPos*zom , userWidth , userHeight).attr({"CompType":"user_image",title :"User"}));
				compPosition.put(key, xPos*zom+"#"+yPos*zom);
			}
			else
			{
				var xy = rhs;
				var xPos = parseInt(xy.substring(0,xy.indexOf("#")));
				var ystate = xy.substring(xy.indexOf("#")+1);
				var yPos = parseInt(ystate.substring(0,ystate.indexOf("#")));
				var state = xy.substring(xy.lastIndexOf("#")+1);

				var comptype = key.substring(0,key.indexOf(":")); 
				var compCategory=compGroupMap.get(comptype);
				var comptip = key.substring(key.indexOf(":")+1);
				if(comptip.indexOf(":NULL")>0)
					comptip = comptip.substring(0,comptip.indexOf(":NULL"));
				var compImage="";
				if(comptype!=null && (comptype.match("_ex$")=="_ex" || comptype.indexOf("Agg_")==0))
				{
					if(comptype == 'Group')
					{
						compImage = r.image('<%=contextPath1%>'+'group.png', xPos*zom, yPos*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					}
					else if(comptype.match("_ex$")=="_ex")
					{
						compImage = r.image('<%=ICImagePath%>'+compCategory+'.png', xPos*zom, yPos*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					}
					else
					{
						//if(comptype.indexOf('Agg_')==0)
						//{
							//aggrigateCompMap.put(comptip,comptype);
							//compImage = r.image('<%=contextPath%>aggregate.png', xPos*zom, yPos*zom , gifWidth , gifHeight).attr({title : comptip});
						//}
						//else
						//{
							//compImage = r.image('<%=contextPath%>'+ comptype+'.png', xPos*zom, yPos*zom , gifWidth , gifHeight).attr({title : comptip});
						//}
						compImage = r.image('<%=contextPath%>'+ compCategory+'.png', xPos*zom, yPos*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					}
				}
				else
				{
					if(comptype == 'Group')
						compImage = r.image('<%=contextPath1%>'+'group.png', xPos*zom, yPos*zom , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
					else
						compImage = r.image('<%=contextPath%>'+ compCategory+'.png', xPos*zom, yPos*zom  , gifWidth , gifHeight).attr({"CompType":comptype,title : comptip});
				}
				arr.push(compImage);
				compPosition.put(key, xPos*zom+"#"+yPos*zom);
				componentStateMap.put(key,state);
			}
		}
		compIndexMap.put(key,compInd);
		compInd = compInd + 1;
	}

	/*for(var i = 0; i++ < compPosition.size; compPosition.next())
	{
		alert(compPosition.hash(compPosition.key()) + ' >> ' + compPosition.value() +"    "+i);
	}*/

	if(resize == "true")
	{
		resizePaperDiv(iniMaxW, iniMaxH);
	}
	// Creating connections between components.......
	createConnections(topostring);
}

function createConnections(topostr)
{
	var tokens = topostr.split("|");
	for(var i = 0;i<tokens.length;i++)
	{
		var tokvalue = tokens[i];
		var lhs = tokvalue.substring(0,tokvalue.indexOf("="));
		var rhs = tokvalue.substring(tokvalue.indexOf("=")+1);

		var key = lhs;

		if(i==0)
		{
			key = "egurkha.physical.topology";
		}
		var lhsInd = compIndexMap.get(key);
		if(rhs != 'null')
		{
			var rhsArr = rhs.split(",");
			for(var j=0;j<rhsArr.length;j++)
			{
				var element = rhsArr[j];
				element = element.substring(0,element.lastIndexOf(":"));
				var LorN = element.substring(element.lastIndexOf(":")+1);
				element = element.substring(0,element.lastIndexOf(":"));
				var elementInd = compIndexMap.get(element);
				connectionArr.push(lhsInd+":"+LorN+">"+elementInd);
			}
		}
	}
}

function newDrawMethod()
{
	return this.arr;
}

window.onload = mainFunction;

function mainFunction ()
{
	getMapDetails(positionString);
	var key;
	var thisIndex;
	var statesrc;
	var dragger = function () {
								
								//var src = this.attr("src");
								var src = this.attr("CompType");
								var title = this.attr("title");
								if(title.indexOf(":") < 0)
								{
									title = title+":NULL";
								}
								//if (src.indexOf(".gif")>0)
									//src = src.substring(src.lastIndexOf("/")+1,src.indexOf(".gif"));
								//else if (src.indexOf(".png")>0)
									//src = src.substring(src.lastIndexOf("/")+1,src.indexOf(".png"));

								if(src == 'user_image')
								{
									key ="egurkha.physical.topology";
								}
								//else if(src == 'aggregate')
								//{
									//var aggrigateCmp=title.substring(0,title.indexOf(":NULL"));
									//src=aggrigateCompMap.get(aggrigateCmp);
									//key = src+":"+title;
								//}
								else
								{
									if(src=='group')
									{
										src='Group';
									}
									key = src+":"+title;
								}
								
								thisIndex = compIndexMap.get(key);

								if(this.type == "image")
								{
									this.ox = this.attr("x");
									this.oy = this.attr("y");
								}
								if(thisIndex >0)
								{
									//statesrc = stateCircle[thisIndex].attr('src');
									//stateCircle[thisIndex].remove();
									imgNames[thisIndex].remove();
									compNames[thisIndex].remove();
								}
	},
	move = function (dx, dy) {
								if(this.type == "image")
								{
									var att =  {x: this.ox + dx, y: this.oy + dy};
									this.attr(att);
								}
								for (var i = connections.length; i--;) {
									r.connection('#<%=color%>',connections[i]);
								}
								r.safari();
	},
	up = function () {
						compPosition.put(key,this.attr("x")+"#"+this.attr("y"));
						if(key!="egurkha.physical.topology")
						{
							//stateCircle[thisIndex] = r.image(statesrc,this.attr("x"),this.attr("y"),50*zom,50*zom);
							//stateCircle[thisIndex].toBack();
							//adding component name
							var names=key;
							var msg;
							var textMsg=names.substring(0,names.indexOf(":"));
							
							if(textMsg.indexOf('Agg_') == 0)
							{
								textMsg=textMsg.substring(4);
								msg=egtop_iniMap.get(textMsg);
								msg=msg+" "+"Aggregate";
							}
							else
							{
								if(textMsg=='group')
								{
									textMsg='Group';
								}
								msg=egtop_iniMap.get(textMsg);
							}
							var typeFlag=false;
							var compTextname=msg;
							if(msg.length > 22)
							{
								var midval ;
								if(compTextname.length % 2 == 0)
									midval = compTextname.length / 2;
								else
									midval = (compTextname.length + 1) / 2;
								compTextname = msg.substring(0,midval)+"\n"+msg.substring(midval);
								typeFlag=true;
							}
							var compFlag=false;
							var textstr = this.attr("title");
							if(textstr.length > 22)
							{
								var mid ;
								if(textstr.length % 2 == 0)
									mid = textstr.length / 2;
								else
									mid = (textstr.length + 1) / 2;
								textstr = textstr.substring(0,mid)+"\n"+textstr.substring(mid);
								compFlag=true;
							}
							/*if((textstr.length > 22) || (msg.length > 22))
							{
								imgNames[thisIndex]=r.text(this.attr("x")+29*zom ,this.attr("y") + 63*zom , compTextname).attr({"font-size" : 11*zom,'font-weight': 'bold',"font-family":"Tahoma"});
							}
							else
							{
								imgNames[thisIndex]=r.text(this.attr("x")+29*zom ,this.attr("y") + 56*zom , compTextname).attr({"font-size" : 11*zom,'font-weight': 'bold',"font-family":"Tahoma"});
							}
							if((textstr.length > 22) || (msg.length > 22))
							{
								compNames[thisIndex] = r.text(this.attr("x")+29*zom ,this.attr("y") + 82*zom , textstr).attr({"font-size" : 11*zom});
							}
							else
							{
								compNames[thisIndex] = r.text(this.attr("x")+29*zom ,this.attr("y") + 72*zom , textstr).attr({"font-size" : 11*zom});
							}*/
							if(!typeFlag && !compFlag ) //1 1
							{
								imgNames[thisIndex]=r.text(this.attr("x")+23*zom,this.attr("y")+55*zom,compTextname).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"});

								compNames[thisIndex] = r.text(this.attr("x")+23*zom,this.attr("y")+70*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"});
							}
							else if(!typeFlag && compFlag) // 1 2
							{
								imgNames[thisIndex]=r.text(this.attr("x")+23*zom,this.attr("y")+60*zom,compTextname).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"});

								compNames[thisIndex] =r.text(this.attr("x")+23*zom,this.attr("y")+80*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"});
							}
							else if(typeFlag && !compFlag) // 2 1
							{
								imgNames[thisIndex]=r.text(this.attr("x")+23*zom,this.attr("y")+60*zom,compTextname).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"});

								compNames[thisIndex] =r.text(this.attr("x")+23*zom,this.attr("y")+80*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"});
							}
							else if(typeFlag && compFlag) // 2 2
							{
								imgNames[thisIndex]=r.text(this.attr("x")+23*zom,this.attr("y")+60*zom,compTextname).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"});

								compNames[thisIndex] =r.text(this.attr("x")+23*zom,this.attr("y")+88*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"});
							}
						}
						beatFunction(shapes, compNames , thisIndex,connections);
	},
	connections = [],
	shapes = newDrawMethod(),
	stateCircle = drawStateCircles(),
	compNames = drawCompNames(),
	imgNames= drawimgNames();
	for (var i = 0, ii = shapes.length; i < ii; i++) 
	{
		shapes[i].attr({cursor: "move"});
		shapes[i].drag(move, dragger, up);
		beatFunction(shapes, compNames, i, connections);
	}

	for(var k=0;k<connectionArr.length;k++)
	{
		var link = connectionArr[k];
		var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
		var ind1 = link.substring(0,link.indexOf(":"));
		var ind2 = link.substring(link.indexOf(">")+1);
		connections.push(r.connection('#<%=color%>',shapes[ind1], shapes[ind2], "#<%=color%>","#<%=color%>|1",lorn)); 
	}
	hideLoadImage();
	//if('<%=isFull%>' == 'true')
	//{
		setZoom(zom);
	//}
}


function beatFunction(shapesObj,compNamesObj, index, connectionObj)
{
	shapesObj[index].mouseover (function (event) {
		for(var k=0;k<connectionArr.length;k++)
		{
			var link = connectionArr[k];
			var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
			var ind1 = link.substring(0,link.indexOf(":"));
			var ind2 = link.substring(link.indexOf(">")+1);

			if(ind1 == index || ind2 == index)
			{
				if(connectionObj[k]!=null)
				{
					//connectionObj[k].line.toFront();
					//connectionObj[k].tri.toFront();
					connectionObj[k].line.animate({'stroke' : '#<%=dark%>', 'stroke-width' : 2*zom},500);
					connectionObj[k].tri.animate({'stroke' : '#<%=dark%>','fill' : '#<%=dark%>', 'stroke-width' : 2*zom},500);
				}
			}
		}
	});

	shapesObj[index].mouseout (function (event){
		for(var k=0;k<connectionArr.length;k++)
		{
			var link = connectionArr[k];
			var lorn = link.substring(link.indexOf(":")+1, link.indexOf(">"));
			var ind1 = link.substring(0,link.indexOf(":"));
			var ind2 = link.substring(link.indexOf(">")+1);

			if(ind1 == index || ind2 == index)
			{
				if(connectionObj[k]!=null)
				{
					//connectionObj[k].line.toBack();
					//connectionObj[k].tri.toBack();
					connectionObj[k].line.animate({'stroke' : '#<%=color%>', 'stroke-width' : 1*zom},500);
					connectionObj[k].tri.animate({'stroke' : '#<%=color%>','fill' : '#<%=color%>', 'stroke-width' : 1*zom},500);
				}
			}
		}
	});
}

function drawCompNames ()
{
	return allCompNames;
}
function drawimgNames ()
{
	return alltpNames;
}
function drawStateCircles()
{
	var cirArr = new Array();
	var keys = compPosition.listKeys();
	for(var k=0;k<keys.length;k++)
	{
		if(k==0)
		{
			cirArr.push("egurkha.physical.topology");
			alltpNames.push("egurkha.physical.topology");
			allCompNames.push("egurkha.physical.topology");
			continue;
		}
		var key = keys[k];
		var val = compPosition.get(key);
		var xpoint = parseInt(val.substring(0,val.indexOf("#")));
		var ypoint = parseInt(val.substring(val.indexOf("#")+1));

		//var scir = r.image('<%=contextPath%>'+'server_gray.png',xpoint,ypoint,gifWidth,gifHeight);
		//scir.toBack();
		//cirArr.push(scir);
		//getting component name
		var textMsg;
		var msg=key.substring(0,key.indexOf(":"));
		if(msg.indexOf('Agg_') == 0) {
			msg=msg.substring(4);
			textMsg=egtop_iniMap.get(msg);
			textMsg=textMsg+" "+"Aggregate";
		}
		else
		{
			textMsg=egtop_iniMap.get(msg);
		}
		var typeFlag=false;
		var comptextName=textMsg;
		if(textMsg.length > 22)
		{
			var midval ;
			if(comptextName.length % 2 == 0)
				midval = comptextName.length / 2;
			else
				midval = (comptextName.length + 1) / 2;
			comptextName = textMsg.substring(0,midval)+"\n"+textMsg.substring(midval);
			typeFlag=true;
		}
		//end
		var compName = key.substring(key.indexOf(":")+1);
		if(compName.indexOf(":NULL") > 0)
			compName = compName.substring(0,compName.indexOf(":NULL"));
		var textstr = compName;
		var compFlag=false;
		if(compName.length > 22)
		{
			var mid ;
			if(textstr.length % 2 == 0)
				mid = textstr.length / 2;
			else
				mid = (textstr.length + 1) / 2;
			textstr = compName.substring(0,mid)+"\n"+compName.substring(mid);
			compFlag=true;
		}
		//adding component name
		/*if((compName.length > 22) || (textMsg.length > 22))
		{
			alltpNames.push(r.text(xpoint+29*zom,ypoint+63*zom,comptextName).attr({"font-size" : 11*zom,'font-weight': 'bold',"font-family":"Tahoma"}));
		}
		else
		{
			alltpNames.push(r.text(xpoint+29*zom,ypoint+56*zom,comptextName).attr({"font-size" : 11*zom,'font-weight': 'bold',"font-family":"Tahoma"}));
		}
		if((compName.length > 22) || (textMsg.length > 22))
		{
			allCompNames.push(r.text(xpoint+29*zom,ypoint+88*zom,textstr).attr({"font-size" : 11*zom}));
		}
		else
		{
			allCompNames.push(r.text(xpoint+29*zom,ypoint+72*zom,textstr).attr({"font-size" : 11*zom}));
		}*/
		if(!typeFlag && !compFlag ) //1 1
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+55*zom,comptextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+70*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"}));
		}
		else if(!typeFlag && compFlag) // 1 2
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,comptextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+80*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"}));
		}
		else if(typeFlag && !compFlag) // 2 1
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,comptextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+80*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"}));
		}
		else if(typeFlag && compFlag) // 2 2
		{
			alltpNames.push(r.text(xpoint+23*zom,ypoint+60*zom,comptextName).attr({"font-size" : 10*zom,"fill": "<%=compNameColor%>","font-family":"<%=fontFamilyBold%>"}));

			allCompNames.push(r.text(xpoint+23*zom,ypoint+88*zom,textstr).attr({"font-size" : 10*zom , "fill": "<%=compNameColor%>", "font-family":"<%=fontFamily%>"}));
		}
	}
	return cirArr;
}

</script>
<input type="hidden" name="zoom" id="zoom" value='<%=zoomLevel%>'>

</form>
</body>
</html>

<%
}
catch(Exception e)
{
	System.out.println("Exception in EgTopologyB.jsp....");
	e.printStackTrace();
}
%>

<%!
	private String getTopologyString(String segmentName, String site , String phyTopology)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		EgCrawlerAdmin strBean = new EgCrawlerAdmin(iniFile);

		String str = null;

		if (phyTopology.equals("1"))
			str = strBean.getPhysicalTopology(segmentName);
		else
		{
			if (segmentName.equals("Independent_servers"))
			{
				str = strBean.getSiteString(site, site + "_INDEPENDENT");
			}
			else
			{
				str = strBean.getSiteString(site, segmentName);
			}
		}

		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str))
			newString = EgConstants.BLANK_SPACE;
		else
			newString = ap.getTopologyPriority(str, site);
		newString = sortTopoString(newString);
		return newString;
	}

	/*
	To sort the topology string so that the new topology applet will understand
	*/
	public String sortTopoString(String topoStr) 
	{
		if(topoStr==null)
			return null;
		Hashtable h = new Hashtable();

		String [] topoToks = StringUtils.getTokens(topoStr, "|");

		ArrayList finalLhs = new ArrayList();
		ArrayList finalRhs = new ArrayList();
		ArrayList leftOver = new ArrayList();
		boolean changesOccured = false;
		while (!changesOccured)	 //loop until sorted properly changesOccured becomes true
		{
			changesOccured = true;	
			for (int i=0;i<topoToks.length ;i++ )
			{
				String [] relation = StringUtils.getTokens(topoToks[i], "=");
				String thisLhs ="";
				String thisRhs ="";
				if(relation!=null && relation.length==2)
				{
				 thisLhs = relation[0];
				 thisRhs = relation[1];	//Network_node:Core_Switch_1:NULL:N:GOOD,Network_node:Core_Switch_2:NULL:N:GOOD
				}
				else if(relation!=null && relation.length==1)
				{
					thisLhs = relation[0];
				}
				//System.out.println("! thisLhs:"+thisLhs);
				if (i==0)
				{
					//add first component
					if (finalLhs.indexOf(thisLhs)==-1)	 //if lhs is already added, skip
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}
				}else
				{
					Object rhsObj = h.get(thisLhs);
					/*
						if rhsObj is null, it means that we get a wrong entry, i.e. the component comes in improper order. 
						a component which havnt come in rhs, has been given as lhs. so dont add it right now. wait until the 
						necessary rhs is getting added.
					*/
					if (rhsObj!=null && finalLhs.indexOf(thisLhs)==-1)
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}else
					{
						if (rhsObj==null)				//if rhsObj is null, it means that some component is not yet added
							changesOccured = false;
					}
				}
			}
		}

		StringBuffer sb = new StringBuffer();
		for (int i=0;i<finalLhs.size() ;i++ )
		{
			String thisStr = (String)finalLhs.get(i);
			ArrayList rhsList = (ArrayList) finalRhs.get(i);
			Iterator myIter = rhsList.iterator();
			StringBuffer sb2 = new StringBuffer();
			while (myIter.hasNext())
			{
				TopoRhsComp thisRhsComp = (TopoRhsComp) myIter.next();
				sb2.append(thisRhsComp.getComponent());
				if (myIter.hasNext())
					sb2.append(",");
			}
			sb.append(finalLhs.get(i));
			sb.append("=");
			sb.append(sb2.toString());
			sb.append("|");
		}
		String result = sb.toString();
		if (result.endsWith("|"))
		{
			result = result.substring(0, result.lastIndexOf("|"));
		}
		return result;
	}

	public ArrayList getRhsList(String thisRhs, String thisLhs, Hashtable h)
	{
		ArrayList result = new ArrayList();
		if(thisRhs!=null && !thisRhs.equals(""))
		{
			String [] toks = StringUtils.getTokens(thisRhs, ",");
			for (int i=0;i<toks.length ;i++ )
			{
				String thisStr = toks[i];
				TopoRhsComp rhsCmp = new TopoRhsComp(thisStr);
				result.add(rhsCmp);
				
				if (!rhsCmp.toString().equals("null"))
				{
					h.put(rhsCmp.toString(), thisLhs);
				}
			}
		}
		return result;
	}
%>