<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import="com.egurkha.util.*" %>
<%@ page import= "egurkha.EgUIUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setContentType("application/json");
	
	JSONObject rootJson = new JSONObject();
	
	String enableProxy = request.getParameter("enableProxy");
	String proxyHost = request.getParameter("proxyHost");
	proxyHost = EgUIUtils.decodeSecurityChar(proxyHost);
	String proxyPort = request.getParameter("proxyPort");
	proxyPort = EgUIUtils.decodeSecurityChar(proxyPort);
	String proxyUsername = request.getParameter("proxyUsername");
	proxyUsername = EgUIUtils.decodeSecurityChar(proxyUsername);
	String proxyPassword = request.getParameter("proxyPassword");
	proxyPassword = EgUIUtils.decodeSecurityChar(proxyPassword);
	
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Manager Settings");
	auditLogThread.setValue("Activity","Manager Proxy Settings");
	
	boolean isChangeFound = false;
	IniFile egMgrMiscIniFileWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_mgrmisc.ini",true);
	
	String managerProxyDetails = egMgrMiscIniFileWr.getValue("MANAGER_PROXY_DETAILS","ManagerProxy");
	String prevProxyEnabled = "false";
	String prevProxyAuthenticationEnabled = "false";
	String prevProxyHost = "-";
	String prevProxyPort = "-";
	String prevProxyUsername = "-";
	String prevProxyPassword = "-";
	if (managerProxyDetails != null && managerProxyDetails.trim().length() > 0)
	{
		if (managerProxyDetails.indexOf("^#^") > -1)
		{
			ArrayList valueList = new ArrayList(Arrays.asList(StringUtils.getTokens(managerProxyDetails,"^#^")));
			if (valueList.size() > 0)
			{
				prevProxyEnabled = "true";
				prevProxyHost = (String)valueList.get(0);
				prevProxyPort = (String)valueList.get(1);
				if (valueList.size() == 4)
				{
					prevProxyAuthenticationEnabled = "true";
					prevProxyUsername = (String)valueList.get(2);
					prevProxyPassword = (String)valueList.get(3);
					prevProxyPassword = EgCrypt.olddecrypt(prevProxyPassword);
				}
			}
		}
	}
	
	if (enableProxy != null && enableProxy.equalsIgnoreCase("true"))
	{
		if (!prevProxyEnabled.equals(enableProxy))
		{
			isChangeFound = true;
			auditLogThread.setPreviousValue("01~~Proxy Server enabled",prevProxyEnabled);
			auditLogThread.setCurrentValue("01~~Proxy Server enabled",enableProxy);
		}
		
		if (!prevProxyHost.equals(proxyHost))
		{
			isChangeFound = true;
			auditLogThread.setPreviousValue("02~~Proxy Server IP/Hostname",prevProxyHost);
			auditLogThread.setCurrentValue("02~~Proxy Server IP/Hostname",proxyHost);
		}
		
		if (!prevProxyPort.equals(proxyPort))
		{
			isChangeFound = true;
			auditLogThread.setPreviousValue("03~~Proxy Server Port",prevProxyPort);
			auditLogThread.setCurrentValue("03~~Proxy Server Port",proxyPort);
		}
		
		String isAuthenticationEnabled = request.getParameter("isAuthenticationEnabled");
		if (!StringUtils.isNull(isAuthenticationEnabled) && isAuthenticationEnabled.equalsIgnoreCase("true"))
		{
			if (prevProxyAuthenticationEnabled.equalsIgnoreCase("false"))
			{
				isChangeFound = true;
				auditLogThread.setPreviousValue("04~~Proxy Server authentication enabled","false");
				auditLogThread.setCurrentValue("04~~Proxy Server authentication enabled","true");
			}
		
			if (!prevProxyUsername.equals(proxyUsername))
			{
				isChangeFound = true;
				auditLogThread.setPreviousValue("05~~Proxy Server Username",prevProxyUsername);
				auditLogThread.setCurrentValue("05~~Proxy Server Username",proxyUsername);
			}
			
			if (!prevProxyPassword.equals(proxyPassword))
			{
				isChangeFound = true;
				auditLogThread.setPreviousValue("06~~Proxy Server Password","*****");
				auditLogThread.setCurrentValue("06~~Proxy Server Password","******");
			}
			
			egMgrMiscIniFileWr.setValue("MANAGER_PROXY_DETAILS","ManagerProxy",proxyHost+"^#^"+proxyPort+"^#^"+proxyUsername+"^#^"+EgCrypt.oldencrypt(proxyPassword));
		}
		else
		{
			egMgrMiscIniFileWr.setValue("MANAGER_PROXY_DETAILS","ManagerProxy",proxyHost+"^#^"+proxyPort);
			
			if (prevProxyAuthenticationEnabled.equalsIgnoreCase("true"))
			{
				isChangeFound = true;
				String displayName = "04~~Proxy Server authentication enabled";
				auditLogThread.setPreviousValue("04~~Proxy Server authentication enabled","true");
				auditLogThread.setCurrentValue("04~~Proxy Server authentication enabled","false");
			}
		}
	}
	else
	{
		egMgrMiscIniFileWr.setValue("MANAGER_PROXY_DETAILS","ManagerProxy","N/A");
		
		if (prevProxyEnabled.equalsIgnoreCase("true"))
		{
			isChangeFound = true;
			auditLogThread.setPreviousValue("01~~Proxy Server enabled","true");
			auditLogThread.setCurrentValue("01~~Proxy Server enabled","false");
		}
	}
	egMgrMiscIniFileWr.saveFile();
	EgConfigFilesSync.releaseInstance(egMgrMiscIniFileWr);
	
	auditLogThread.setValue("Description","Proxy server settings have been updated");
	if (isChangeFound)
	{
		auditLogThread.sendItToDB();
	}
	
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>



