<%
/*
	File			:	egAlertOptionsJson.jsp
	Purpose			:	UI to display/modify values in eg_services.ini file
*/
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgMemInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "net.sf.json.*"%>

<%
	JSONObject rootJson = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>
<%!
	String subject = "MISC_ARGS";
%>
	<jsp:useBean id="transBean" scope="page" class="egurkha.TransactionBean"/> 
<%
	transBean.createFile("eg_services.ini");

	String heartbeatFreq = transBean.getStrValue(subject,"HeartbeatFreq");
	if (StringUtils.isNull(heartbeatFreq))
	{
		heartbeatFreq = EgConstants.BLANK_STRING;
	}
	rootJson.put("heartbeatFreq",heartbeatFreq);
	String licenseCheck = "me";
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	boolean smsEnabled = false;
	synchronized(licenseCheck)
	{
		smsEnabled = EgMemInfo.smsEnabled;
	}
	String strmSub = transBean.getStrValue(subject,"MailSubject");
	String strsSub = transBean.getStrValue(subject,"SmsSubject");
	String strsFormat = transBean.getStrValue(subject,"SmsFormat");
	String strmailseparate=transBean.getStrValue(subject,"MailSeparate");
	String strsmsseparate=transBean.getStrValue(subject,"SeparateSms");
	String strmailFormat=transBean.getStrValue(subject,"MailFormat");
	String normalMail = transBean.getStrValue(subject,"MailNormal");
	String ddMail = transBean.getStrValue(subject,"ShowDDinMail");
	String mailAsAttachment = transBean.getStrValue(subject,"SendMailAlertAsAttachment");
	String configChangesInMail = transBean.getStrValue(subject,"SendConfigChangesInMail");
	String zoneWiseCertReport = transBean.getStrValue("ZoneAndUserCertUsage","ZoneWiseCertReport");
	
	if(zoneWiseCertReport != null && (zoneWiseCertReport.equalsIgnoreCase("yes") || zoneWiseCertReport.equalsIgnoreCase("true")))
	{
		rootJson.put("zoneWiseCertReport","Yes");
	}
	else
	{
		rootJson.put("zoneWiseCertReport","No");
	}
	rootJson.put("strmSub",strmSub);
	rootJson.put("strsSub",strsSub);
	rootJson.put("strsFormat",strsFormat);
	rootJson.put("strsmsseparate",strsmsseparate);

	String type1 = "";
	String type2 = "";
	String type3 = "";
	String type4 = "";
	String type5 = "";
	String type6 = "";
	String type7 = "";
	String type8 = "";
	String type9 = "";
	String type10 = "";
	String type11 = "";

	String mail1 = "";
	String mail2 = "";
	String mail3 = "";
	String mail4 = "";
	String mail5 = "";
	String mail6 = "";
	String mail7 = "";
	String mail8 = "";
	String mail9 = "";
	StringTokenizer st = new StringTokenizer(strsFormat, ",");
	while(st.hasMoreTokens())
	{
		String strTok = st.nextToken();
		if(strTok.equals("cname"))
			type1 = "true";
		else if(strTok.equals("ctype"))
			type2 = "true";
		else if(strTok.equals("desc"))
			type3 = "true";
		else if(strTok.equals("site"))
			type4 = "true";
		else if(strTok.equals("test"))
			type5 = "true";
		else if(strTok.equals("measure"))
			type6 = "true";
		else if(strTok.equals("mHost"))
			type7 = "true";
		else if(strTok.equals("layer"))
			type8 = "true";
		else if(strTok.equals("prior"))
			type9 = "true";
		else if(strTok.equals("problemtime"))
			type10 = "true";
		else if(strTok.equals("alarmIdsms"))
			type11 = "true";
	}

	rootJson.put("type1",type1);
	rootJson.put("type2",type2);
	rootJson.put("type3",type3);
	rootJson.put("type4",type4);
	rootJson.put("type5",type5);
	rootJson.put("type6",type6);
	rootJson.put("type7",type7);
	rootJson.put("type8",type8);
	rootJson.put("type9",type9);
	rootJson.put("type10",type10);
	rootJson.put("type11",type11);

	StringTokenizer stmail = new StringTokenizer(strmailFormat, ",");
	while(stmail.hasMoreTokens())
	{
		String strTok = stmail.nextToken();
		if(strTok.equals("cname"))
			mail1 = "true";
		else if(strTok.equals("ctype"))
			mail2 = "true";
		else if(strTok.equals("layer"))
			mail3 = "true";
		else if(strTok.equals("desc"))
			mail4 = "true";
		else if(strTok.equals("site"))
			mail5 = "true";
		else if(strTok.equals("test"))
			mail6 = "true";
		else if(strTok.equals("measure"))
			mail7 = "true";
		else if(strTok.equals("mHost"))
			mail8 = "true";
		if(strTok.equals("alarmIdMail"))
			mail9 = "true";
	}

	rootJson.put("mail1",mail1);
	rootJson.put("mail2",mail2);
	rootJson.put("mail3",mail3);
	rootJson.put("mail4",mail4);
	rootJson.put("mail5",mail5);
	rootJson.put("mail6",mail6);
	rootJson.put("mail7",mail7);
	rootJson.put("mail8",mail8);
	rootJson.put("mail9",mail9);

	String mailHomeUrl = transBean.getStrValue(subject,"MailHomeUrl");
	if (StringUtils.isNull(mailHomeUrl))
	{
		mailHomeUrl = EgConstants.BLANK_STRING;
	}
	rootJson.put("mailHomeUrl",mailHomeUrl);

	String mailCheckPeriod = transBean.getStrValue(subject,"MailCheckPeriod");
	if (StringUtils.isNull(mailCheckPeriod))
	{
		mailCheckPeriod = EgConstants.BLANK_STRING;
	}
	rootJson.put("mailCheckPeriod",mailCheckPeriod);

	String editMailId = transBean.getStrValue(subject,"EditMailId");
	rootJson.put("editMailId",editMailId);

	String alertAgentsNotRunning = transBean.getStrValue(subject,"AlertAgentsNotRunning");
	rootJson.put("alertAgentsNotRunning",alertAgentsNotRunning);

	String mailLastValue = transBean.getStrValue(subject,"MailLastValue");
	String smsLastValue = transBean.getStrValue(subject,"SMSLastValue");
	if (smsLastValue == null || smsLastValue.length() == 0)
	{
		smsLastValue = "No";
	}
	rootJson.put("mailLastValue",mailLastValue);
	rootJson.put("smsLastValue",smsLastValue);
	String stopEsconAckMail = transBean.getStrValue(subject,"StopEscalationOnAlarmAck");
	if(stopEsconAckMail != null && stopEsconAckMail.trim().length() > 0 && (stopEsconAckMail.equalsIgnoreCase("no") || stopEsconAckMail.equalsIgnoreCase("false"))){
		stopEsconAckMail = "No";
	}
	else
		stopEsconAckMail = "Yes";

	rootJson.put("stopEsconAckMail",stopEsconAckMail);

	String mailSubjectFormatToUse = transBean.getStrValue(subject,"MailSubjectFormatToUse");
	if (mailSubjectFormatToUse.equals(""))
		mailSubjectFormatToUse="CustomFormat";

	rootJson.put("mailSubjectFormatToUse",mailSubjectFormatToUse);

	String mailSubjectStart = transBean.getStrValue(subject,"MailSubjectStart");
	if (StringUtils.isNull(mailSubjectStart))
	{
		mailSubjectStart = EgConstants.BLANK_STRING;
	}
	rootJson.put("mailSubjectStart",mailSubjectStart);

	String mailSubjectFormat = transBean.getStrValue(subject,"MailSubjectFormat");
	if (StringUtils.isNull(mailSubjectFormat))
	{
		mailSubjectFormat = "CompName:Priority";
	}
	rootJson.put("mailSubjectFormat",mailSubjectFormat);

	String mailSubjectCFormat = transBean.getStrValue(subject,"MailSubjectCFormat");
	rootJson.put("mailSubjectCFormat",mailSubjectCFormat);

	String mailSubject_SV = "";
	String mailSubject_CN = "";
	String mailSubject_CT = "";
	String mailSubject_LY = "";
	String mailSubject_TN = "";
	String mailSubject_DC = "";
	String mailSubject_LM = "";
	String mailSubject_PT = "";
	String mailSubject_AID = "";
	String mailSubject_CPT = "";
	String mailSubject_CAID = "";

	if(mailSubjectCFormat!=null && !mailSubjectCFormat.equals(""))
	{
		StringTokenizer strTokens_c = new StringTokenizer(mailSubjectCFormat,":");
		while (strTokens_c.hasMoreTokens())
		{
			String strToken1 = strTokens_c.nextToken();
			if(strToken1.equalsIgnoreCase("Priority"))
			{
				mailSubject_CPT = "true";
			}
			else if(strToken1.equalsIgnoreCase("AlarmId"))
			{
				mailSubject_CAID = "true";
			}
		}
	}
	
	StringTokenizer strTokens = new StringTokenizer(mailSubjectFormat,":");
	while (strTokens.hasMoreTokens())
	{
		String strToken = strTokens.nextToken();
		if (strToken.equalsIgnoreCase("Service"))
		{
			mailSubject_SV = "true";
		}
		else if (strToken.equalsIgnoreCase("CompName"))
		{
			mailSubject_CN = "true";
		}
		else if (strToken.equalsIgnoreCase("CompType"))
		{
			mailSubject_CT = "true";
		}
		else if (strToken.equalsIgnoreCase("Layer"))
		{
			mailSubject_LY = "true";
		}
		else if (strToken.equalsIgnoreCase("Test"))
		{
			mailSubject_TN = "true";
		}
		else if (strToken.equalsIgnoreCase("Description"))
		{
			mailSubject_DC = "true";
		}
		else if (strToken.equalsIgnoreCase("LMV"))
		{
			mailSubject_LM = "true";
		}
		else if(strToken.equalsIgnoreCase("Priority"))
		{
			mailSubject_PT = "true";
		}
		else if(strToken.equalsIgnoreCase("AlarmId"))
		{
			mailSubject_AID = "true";
		}
	}

	rootJson.put("mailSubject_SV",mailSubject_SV);
	rootJson.put("mailSubject_CN",mailSubject_CN);
	rootJson.put("mailSubject_CT",mailSubject_CT);
	rootJson.put("mailSubject_LY",mailSubject_LY);
	rootJson.put("mailSubject_TN",mailSubject_TN);
	rootJson.put("mailSubject_DC",mailSubject_DC);
	rootJson.put("mailSubject_LM",mailSubject_LM);
	rootJson.put("mailSubject_PT",mailSubject_PT);
	rootJson.put("mailSubject_AID",mailSubject_AID);
	rootJson.put("mailSubject_CPT",mailSubject_CPT);
	rootJson.put("mailSubject_CAID",mailSubject_CAID);

	String mailSubjectLength = transBean.getStrValue(subject,"MailSubjectLength");
	if (StringUtils.isNull(mailSubjectLength))
	{
		mailSubjectLength = EgConstants.BLANK_STRING;
	}
	rootJson.put("mailSubjectLength",mailSubjectLength);
	rootJson.put("mailLastValue",mailLastValue);

	String idClass = "form_spacing";
	if(smsEnabled)
	{
		idClass = "form_border";
	}

	rootJson.put("strmailseparate",strmailseparate);
	rootJson.put("mailAsAttachment",mailAsAttachment);
	rootJson.put("normalMail",normalMail);
	rootJson.put("ddMail",ddMail);

	boolean isConfigSupported = EgInstallInfo.isConfigSupported;
	rootJson.put("isConfigSupported",isConfigSupported);
	if (EgInstallInfo.isConfigSupported)
	{
		rootJson.put("configChangesInMail",configChangesInMail);
	}
	rootJson.put("smsEnabled",smsEnabled);

	String heartbeatAlways = transBean.getStrValue(subject,"HeartbeatAlways");
	if(StringUtils.isNull(heartbeatAlways))
	{
		heartbeatAlways = "false";
	}
	rootJson.put("heartbeatAlways",heartbeatAlways);

	String heartbeatTo = transBean.getStrValue(subject,"HeartbeatTo");
	if (StringUtils.isNull(heartbeatTo))
	{
		heartbeatTo = EgConstants.BLANK_STRING;
	}
	rootJson.put("HeartbeatTo",heartbeatTo);

	String heartbeatMailMode = transBean.getStrValue(subject,"HeartbeatMailMode");
	if (StringUtils.isNull(heartbeatMailMode))
	{
		heartbeatMailMode = "html";
	}
	rootJson.put("heartbeatMailMode",heartbeatMailMode);

	String alarmEscalationPeriod = transBean.getStrValue(subject,"AlarmEscalationPeriod");
	if (StringUtils.isNull(alarmEscalationPeriod))
	{
		alarmEscalationPeriod = EgConstants.BLANK_STRING;
	}
	if (alarmEscalationPeriod.length() > 0)
		alarmEscalationPeriod = String.valueOf(Long.parseLong(alarmEscalationPeriod)/60);

		rootJson.put("alarmEscalationPeriod",alarmEscalationPeriod);

	String alarmEscalationType = transBean.getStrValue(subject,"AlarmEscalationType");
	if (StringUtils.isNull(alarmEscalationType))
	{
		alarmEscalationType ="High,Medium,Low";
	}
	rootJson.put("alarmEscalationType",alarmEscalationType);

	String shiftPeriodConfig = transBean.getStrValue(subject,"ShiftPeriodsEnabled");
	String maximumShifts = transBean.getStrValue(subject,"NoOfShiftPeriods");
	rootJson.put("shiftPeriodConfig",shiftPeriodConfig);
	rootJson.put("maximumShifts",maximumShifts);

	String mailLogDebug = transBean.getStrValue(subject,"MailManagerDebug");
	if(mailLogDebug == null || mailLogDebug.length() == 0)
	{
		mailLogDebug = "No";
	}
	rootJson.put("mailLogDebug",mailLogDebug);

	String mailLogMaxSize = transBean.getStrValue(subject,"MailmanagerLogMaxRollSize");
	if(mailLogMaxSize == null || mailLogMaxSize.length() == 0)
	{
		mailLogMaxSize = "";
	}
	rootJson.put("mailLogMaxSize",mailLogMaxSize);

	String mailLogMaxRollFile = transBean.getStrValue(subject,"Mailmanager_log_max_files");
	if(mailLogMaxRollFile == null || mailLogMaxRollFile.length() == 0)
	{
		mailLogMaxRollFile = "";
	}
	rootJson.put("mailLogMaxRollFile",mailLogMaxRollFile);

	String logPreference = transBean.getStrValue(subject,"MailManagerLogPreference");
	if(logPreference == null || logPreference.length() == 0)
	{
		logPreference = "cname,ctype,layer,test";
	}
	rootJson.put("logPreference",logPreference);

	StringTokenizer strToken = new StringTokenizer(logPreference,",");
	ArrayList aListToken = new ArrayList();
	while(strToken.hasMoreTokens())
	{
		String tok = strToken.nextToken();
		aListToken.add(tok.toLowerCase());
	}
	
	String filter_mailalerts = transBean.getStrValue(subject,"FilterMailAlerts");
	String filterconfig_nonadmins = transBean.getStrValue(subject,"AllowedForNonAdmins");

	if(filter_mailalerts == null || filter_mailalerts.length() == 0)
	{
		filter_mailalerts = "No";
	}
	rootJson.put("filter_mailalerts",filter_mailalerts);

	if(filterconfig_nonadmins == null || filterconfig_nonadmins.length() == 0)
	{
		filterconfig_nonadmins = "No";
	}
	rootJson.put("filterconfig_nonadmins",filterconfig_nonadmins);

	JSONObject hiddenObject = new JSONObject();
	hiddenObject.put("$_MailHomeUrl","Home page URL in mail messages$"+mailHomeUrl);
	hiddenObject.put("$_MailCheckPeriod","Maximum time between email alert checks (secs)$"+mailCheckPeriod);
	hiddenObject.put("$_EditMailId","Allow monitor users to edit mail IDs$"+editMailId);
	hiddenObject.put("$_AlertAgentsNotRunning","Alert if agent is not running$"+alertAgentsNotRunning);
	hiddenObject.put("$_MailLastValue","Show last measure value in alerts$"+mailLastValue);
	hiddenObject.put("$_StopEscalationOnAlarmAck","Stop acknowledgment on escalation mail alerts$"+stopEsconAckMail);

	if (mailLastValue!=null && (mailLastValue.equalsIgnoreCase("yes")||mailLastValue.equalsIgnoreCase("true")))	//skm (09/03/2006)
	{
		hiddenObject.put("measureFlag","true");
		//hiddenObject.put("smsMeasureFlag","true");
		hiddenObject.put("mailSubjectMeasureFlag","true");
	}
	else
	{
		hiddenObject.put("measureFlag","false");
		//hiddenObject.put("smsMeasureFlag","false");
		hiddenObject.put("mailSubjectMeasureFlag","false");
	}

	if (smsLastValue!=null && (smsLastValue.equalsIgnoreCase("yes")||smsLastValue.equalsIgnoreCase("true")))
	{
		hiddenObject.put("smsMeasureFlag","true");
	}
	else
	{
		hiddenObject.put("smsMeasureFlag","false");
	}

	if (mailSubjectFormatToUse.equalsIgnoreCase("DefinedFormat"))
	{
		hiddenObject.put("$_MailSubjectFormatToUse","Mail subject format$Descriptive");
	}
	else
	{
		hiddenObject.put("$_MailSubjectFormatToUse","Mail subject format$Concise");
	}
	hiddenObject.put("$_mailsub","Mail subject$"+strmSub);
	hiddenObject.put("$_MailSubjectStart","Start of mail subject$"+mailSubjectStart);

	if (mailSubject_SV.equals("true"))
	{
		hiddenObject.put("$_mailSubjectService","Contents of descriptive mail subject$Services");
	}
	else
	{
		hiddenObject.put("$_mailSubjectService","Contents of descriptive mail subject$");
	}

	if (mailSubject_CPT.equals("true"))
	{
		hiddenObject.put("$_mailSubjectCPrior","Contents of concise mail subject$priority");
	}
	else
	{
		hiddenObject.put("$_mailSubjectCPrior","Contents of concise mail subject$");
	}

	if (mailSubject_CAID.equals("true"))
	{
		hiddenObject.put("$_mailSubjectCAlarmId","Contents of concise mail subject$AlarmId");
	}
	else
	{
		hiddenObject.put("$_mailSubjectCAlarmId","Contents of concise mail subject$");
	}

	if (mailSubject_CN.equals("true"))
	{
		hiddenObject.put("$_mailSubjectCompName","Contents of descriptive mail subject$Component name");
	}
	else
	{
		hiddenObject.put("$_mailSubjectCompName","Contents of descriptive mail subject$");
	}

	if (mailSubject_CT.equals("true"))
	{
		hiddenObject.put("$_mailSubjectCompType","Contents of descriptive mail subject$Component type");
	}
	else
	{
		hiddenObject.put("$_mailSubjectCompType","Contents of descriptive mail subject$");
	}

	if (mailSubject_LY.equals("true"))
	{
		hiddenObject.put("$_mailSubjectLayer","Contents of descriptive mail subject$Layer");
	}
	else
	{
		hiddenObject.put("$_mailSubjectLayer","Contents of descriptive mail subject$");
	}

	if (mailSubject_TN.equals("true"))
	{
		hiddenObject.put("$_mailSubjectTest","Contents of descriptive mail subject$Test");
	}
	else
	{
		hiddenObject.put("$_mailSubjectTest","Contents of descriptive mail subject$");
	}

	if (mailSubject_DC.equals("true"))
	{
		hiddenObject.put("$_mailSubjectDesc","Contents of descriptive mail subject$Description");
	}
	else
	{
		hiddenObject.put("$_mailSubjectDesc","Contents of descriptive mail subject$");
	}

	if (mailSubject_LM.equals("true"))
	{
		hiddenObject.put("$_mailSubjectLMV","Contents of descriptive mail subject$Last measure value");
	}
	else
	{
		hiddenObject.put("$_mailSubjectLMV","Contents of descriptive mail subject$");
	}

	if (mailSubject_PT.equals("true"))
	{
		hiddenObject.put("$_mailSubjectPrior","Contents of descriptive mail subject$Priority");
	}
	else
	{
		hiddenObject.put("$_mailSubjectPrior","Contents of descriptive mail subject$");
	}

	if (mailSubject_AID.equals("true"))
	{
		hiddenObject.put("$_mailSubjectAlarmId","Contents of descriptive mail subject$AlarmId");
	}
	else
	{
		hiddenObject.put("$_mailSubjectAlarmId","Contents of descriptive mail subject$");
	}
	hiddenObject.put("$_MailSubjectLength","Max components in mail subject$"+mailSubjectLength);

	if (mail5.equals("true"))
	{
		hiddenObject.put("$_mailsite","Mail preferences$site");
	}
	else
	{
		hiddenObject.put("$_mailsite","Mail preferences$");
	}

	if (mail1.equals("true"))
	{
		hiddenObject.put("$_mailcname","Mail preferences$cname");
	}
	else
	{
		hiddenObject.put("$_mailcname","Mail preferences$");
	}

	if (mail2.equals("true"))
	{
		hiddenObject.put("$_mailctype","Mail preferences$ctype");
	}
	else
	{
		hiddenObject.put("$_mailctype","Mail preferences$");
	}

	if (mail3.equals("true"))
	{
		hiddenObject.put("$_maillayer","Mail preferences$layer");
	}
	else
	{
		hiddenObject.put("$_maillayer","Mail preferences$");
	}

	if (mail6.equals("true"))
	{
		hiddenObject.put("$_mailtest","Mail preferences$test");
	}
	else
	{
		hiddenObject.put("$_mailtest","Mail preferences$");
	}

	if (mail4.equals("true"))
	{
		hiddenObject.put("$_maildesc","Mail preferences$desc");
	}
	else
	{
		hiddenObject.put("$_maildesc","Mail preferences$");
	}

	if (mail7.equals("true"))
	{
		hiddenObject.put("$_mailmeasure","Mail preferences$measure");
	}
	else
	{
		hiddenObject.put("$_mailmeasure","Mail preferences$");
	}

	if (mail8.equals("true"))
	{
		hiddenObject.put("$_mailmhost","Mail preferences$mhost");
	}
	else
	{
		hiddenObject.put("$_mailmhost","Mail preferences$");
	}

	if (mail9.equals("true"))
	{
		hiddenObject.put("$_mailmhost","Mail preferences$alarmIdMail");
	}
	else
	{
		hiddenObject.put("$_mailmhost","Mail preferences$");
	}

	if (strmailseparate.equals("true"))
	{
		hiddenObject.put("$_separatemail","Send separate mails for each alert$Yes");
	}
	else
	{
		hiddenObject.put("$_separatemail","Send separate mails for each alert$No");
	}

	if (mailAsAttachment.equals("true"))
	{
		hiddenObject.put("$_mailAsAttachment","Send alert as attachment$Yes");
	}
	else
	{
		hiddenObject.put("$_mailAsAttachment","Send alert as attachment$No");
	}

	if (normalMail.equals("true"))
	{
		hiddenObject.put("$_normalmail","Send mails/sms when alarms are cleared$Yes");
	}
	else
	{
		hiddenObject.put("$_normalmail","Send mails/sms when alarms are cleared$No");
	}

	if (ddMail.equalsIgnoreCase("yes"))
	{
		hiddenObject.put("$_ddmail","Include detailed diagnosis(DD) in mail alerts$Yes");
	}
	else
	{
		hiddenObject.put("$_ddmail","Include detailed diagnosis(DD) in mail alerts$No");
	}

	if (configChangesInMail.equals("true"))
	{
		hiddenObject.put("$_ccmail","Include configuration changes in mail alerts$Yes");
	}
	else
	{
		hiddenObject.put("$_ccmail","Include configuration changes in mail alerts$No");
	}

	if (type4.equals("true"))
	{
		hiddenObject.put("$_site","SMS preferences$site");
	}
	else
	{
		hiddenObject.put("$_site","SMS preferences$");
	}

	if (type1.equals("true"))
	{
		hiddenObject.put("$_cname","SMS preferences$cname_sms");
	}
	else
	{
		hiddenObject.put("$_cname","SMS preferences$");
	}

	if (type2.equals("true"))
	{
		hiddenObject.put("$_ctype","SMS preferences$ctype");
	}
	else
	{
		hiddenObject.put("$_ctype","SMS preferences$");
	}

	if (type8.equals("true"))
	{
		hiddenObject.put("$_layer","SMS preferences$layer");
	}
	else
	{
		hiddenObject.put("$_layer","SMS preferences$");
	}

	if (type5.equals("true"))
	{
		hiddenObject.put("$_test","SMS preferences$test");
	}
	else
	{
		hiddenObject.put("$_test","SMS preferences$");
	}

	if (type3.equals("true"))
	{
		hiddenObject.put("$_desc","SMS preferences$desc");
	}
	else
	{
		hiddenObject.put("$_desc","SMS preferences$");
	}

	if (type6.equals("true"))
	{
		hiddenObject.put("$_measure","SMS preferences$measure");
	}
	else
	{
		hiddenObject.put("$_measure","SMS preferences$");
	}

	if (type7.equals("true"))
	{
		hiddenObject.put("$_mhost","SMS preferences$mhost");
	}
	else
	{
		hiddenObject.put("$_mhost","SMS preferences$");
	}

	if (type9.equals("true"))
	{
		hiddenObject.put("$_prior","SMS preferences$prior");
	}
	else
	{
		hiddenObject.put("$_prior","SMS preferences$");
	}

	if (type10.equals("true"))
	{
		hiddenObject.put("$_problemtime","SMS preferences$problemtime");
	}
	else
	{
		hiddenObject.put("$_problemtime","SMS preferences$");
	}

	if (type11.equals("true"))
	{
		hiddenObject.put("$_problemtime","SMS preferences$alarmIdsms");
	}
	else
	{
		hiddenObject.put("$_problemtime","SMS preferences$");
	}

	if (strsmsseparate.equalsIgnoreCase("yes"))
	{
		hiddenObject.put("$_separatesms","Send separate SMS for each alert$Yes");
	}
	else
	{
		hiddenObject.put("$_separatesms","Send separate SMS for each alert$No");
	}
	JSONObject hiddenHeartBeatObj = new JSONObject();
	//hiddenHeartBeatObj.put("$_HeartbeatFreq","Heartbeat mail frequency (mins)$"+heartbeatFreq);
	hiddenHeartBeatObj.put("$_HeartbeatFreq","Heartbeat mail frequency in mins$"+heartbeatFreq);
	hiddenHeartBeatObj.put("$_HeartbeatAlways","Always send heartbeats$"+heartbeatAlways);
	hiddenHeartBeatObj.put("$_HeartbeatTo","Send heartbeats to$"+heartbeatTo);
	hiddenHeartBeatObj.put("$_HeartbeatMailMode","Mode of heartbeat mails$"+heartbeatMailMode);
	rootJson.put("hiddenHeartBeatObj",hiddenHeartBeatObj);

	JSONObject hiddenAlarmEscObj = new JSONObject();
	//hiddenAlarmEscObj.put("$_AlarmEscalationPeriod","Escalate alarms after (mins)$"+alarmEscalationPeriod);
	hiddenAlarmEscObj.put("$_AlarmEscalationPeriod","Escalate alarms after in mins$"+alarmEscalationPeriod);
	hiddenAlarmEscObj.put("$_AlarmEscalationType","Escalate alarms of these priorities$"+alarmEscalationType);
	rootJson.put("hiddenAlarmEscObj",hiddenAlarmEscObj);

	JSONObject hiddenShiftPeriodObj = new JSONObject();
	if (shiftPeriodConfig.equals("true"))
	{
		hiddenShiftPeriodObj.put("$_shiftPeriodConfig","Allow shift period configuration$Yes");
	}
	else
	{
		hiddenShiftPeriodObj.put("$_shiftPeriodConfig","Allow shift period configuration$No");
	}
	
	hiddenShiftPeriodObj.put("$_MaximumShifts","Maximum number of day-shift combinations$"+maximumShifts);
	rootJson.put("hiddenShiftPeriodObj",hiddenShiftPeriodObj);

	JSONObject hiddenMailLogObj = new JSONObject();
	hiddenMailLogObj.put("$_maildebug","Log mail manager activity$"+mailLogDebug);
	//hiddenMailLogObj.put("$_LogMaxSize","Maximum size of log file (MB)$"+mailLogMaxSize);
	hiddenMailLogObj.put("$_LogMaxSize","Maximum size of log file in MB$"+mailLogMaxSize);
	hiddenMailLogObj.put("$_LogMaxFile","Maximum number of log files$"+mailLogMaxRollFile);
	hiddenMailLogObj.put("$_LogPreferance","Alarm details to be logged$"+logPreference);
	rootJson.put("hiddenMailLogObj",hiddenMailLogObj);

	JSONObject hiddenFilterObj = new JSONObject();
	hiddenFilterObj.put("$_mailalerts","Allow mail/sms filter configuration $"+filter_mailalerts);
	hiddenFilterObj.put("$_mail_NonAdmins","Allow non-admins to update  $"+filterconfig_nonadmins);
	rootJson.put("hiddenFilterObj",hiddenFilterObj);

	hiddenObject.put("$_smssub","SMS subject$"+strsSub);

	//license mail usage and validity starts...
	IniFile uiIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini",true);
	IniFile mgrmiscIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini",true);

	String licenseMailValidAlert = uiIni.getValue("LICENSE_EXPIRY_ALERT","MailAlert");
	String LicenseValidityChk = uiIni.getValue("LICENSE_EXPIRY_ALERT","LicenseValidityCheck");

	if(licenseMailValidAlert == null || licenseMailValidAlert.length() == 0)
	{
		licenseMailValidAlert = "No";
	}

	rootJson.put("licenseMailValidAlert",licenseMailValidAlert);
	rootJson.put("enableLicenseValidityChk","no");

	if (licenseMailValidAlert.equalsIgnoreCase("yes"))
	{
		rootJson.put("enableLicenseValidityChk","yes");
	}

	rootJson.put("LicenseValidityChk",LicenseValidityChk);

	String certUsageAlert = mgrmiscIni.getValue("EgCert_Usage","CertUsageMail");
	String zoneUsageAlert = mgrmiscIni.getValue("EgCert_Usage","ZoneUsageMail");
	String detailTypeAlert = mgrmiscIni.getValue("EgCert_Usage","DetailType");
	String enableDates = mgrmiscIni.getValue("EgCert_Usage","SendOnDates");
	String[] mailIDs = mgrmiscIni.getVariables("EgCert_Usage_MailID");
	String SelectedAttachmentType = mgrmiscIni.getValue("EgCert_Usage","SelectedAttachmentType");


	StringBuffer mailBuff = new StringBuffer();
	if (mailIDs != null && mailIDs.length > 0)
	{
		for (int i=0;i<mailIDs.length;i++)
		{
			mailBuff.append(mailIDs[i]);
			if (!(mailIDs.length==(i+1)))
			{
				mailBuff.append("\n");
			}
		}
	}

	if(certUsageAlert == null || certUsageAlert.length() == 0)
	{
		certUsageAlert = "No";
	}
	if(zoneUsageAlert == null || zoneUsageAlert.length() == 0)
	{
		zoneUsageAlert = "No";
	}
	if(detailTypeAlert == null || detailTypeAlert.length() == 0)
	{
		detailTypeAlert = "Concise";
	}
	if(SelectedAttachmentType.equalsIgnoreCase("null") ||  SelectedAttachmentType.length() == 0 || SelectedAttachmentType.equals(" "))
	{
		SelectedAttachmentType = "PDF";
	}


	rootJson.put("certUsageAlert",certUsageAlert);
	rootJson.put("SelectedAttachmentType",SelectedAttachmentType);
	rootJson.put("zoneUsageAlert",zoneUsageAlert);
	rootJson.put("detailTypeAlert",detailTypeAlert);
	rootJson.put("enableDates",enableDates);
	rootJson.put("enableMailID",mailBuff.toString());
	rootJson.put("enableLicenseUsage","no");
	rootJson.put("enableZoneUsage","no");

	if (certUsageAlert.equalsIgnoreCase("yes"))
	{
		rootJson.put("enableLicenseUsage","yes");
	}
	if (zoneUsageAlert.equalsIgnoreCase("yes"))
	{
		rootJson.put("enableZoneUsage","yes");
	}
	
	JSONObject hiddenLicenseUsageValidObj = new JSONObject();
	hiddenLicenseUsageValidObj.put("$_licenseMailValidAlert","Enable license mail validity $"+licenseMailValidAlert);
	//hiddenLicenseUsageValidObj.put("$_LicenseValidityChk","License validity check in Day(s)$"+LicenseValidityChk);
	hiddenLicenseUsageValidObj.put("$_LicenseValidityChk","License validity check in Days$"+LicenseValidityChk);
	hiddenLicenseUsageValidObj.put("$_certUsageAlert","License usage mail$"+certUsageAlert);
	hiddenLicenseUsageValidObj.put("$_zoneUsageAlert","Include zone usage in mail alert$"+zoneUsageAlert);
	hiddenLicenseUsageValidObj.put("$_detailTypeAlert","License information$"+detailTypeAlert);
	hiddenLicenseUsageValidObj.put("$_enableDates","Alerts on dates$"+enableDates);
	hiddenLicenseUsageValidObj.put("$_enableMailID","Send alert to$"+mailBuff.toString());
	hiddenLicenseUsageValidObj.put("$_enableAttachmentType","Attachment type$"+SelectedAttachmentType);
	rootJson.put("hiddenLicenseUsageValidObj",hiddenLicenseUsageValidObj);

	EgConfigFilesSync.releaseInstance(uiIni);
	EgConfigFilesSync.releaseInstance(mgrmiscIni);

	//license mail usage and validity ends...

	rootJson.put("hiddenObject",hiddenObject);
	
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/egAlertOptions.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/egAlertOptions.jsp");
	}

	// configuration mail alerts - starts here
	String enableConfigAlert = transBean.getStrValue(subject,"EnableConfigChangeAlert");
	String configMailCheckPeriod = transBean.getStrValue(subject,"ConfigMailCheckPeriod");
	String configMailSubject = transBean.getStrValue(subject,"ConfigMailSubject");
	String sendConfigMailAsAttachment = transBean.getStrValue(subject,"SendConfigMailAsAttachment");
	String configMailManagerDebug = transBean.getStrValue(subject,"ConfigMailManagerDebug");
	String configMailmanagerLogMaxFiles = transBean.getStrValue(subject,"ConfigMailmanager_log_max_files");
	String configMailmanagerLogMaxRollSize = transBean.getStrValue(subject,"ConfigMailmanagerLogMaxRollSize");
	String configSmsSubject = transBean.getStrValue(subject,"ConfigSmsSubject");

	rootJson.put("enableConfigAlert",enableConfigAlert);
	rootJson.put("configMailCheckPeriod",configMailCheckPeriod);
	rootJson.put("configMailSubject",configMailSubject);
	rootJson.put("sendConfigMailAsAttachment",sendConfigMailAsAttachment);
	rootJson.put("configMailManagerDebug",configMailManagerDebug);
	rootJson.put("configMailmanagerLogMaxFiles",configMailmanagerLogMaxFiles);
	rootJson.put("configMailmanagerLogMaxRollSize",configMailmanagerLogMaxRollSize);
	rootJson.put("configSmsSubject",configSmsSubject);
	// configuration mail alerts - ends here

	// Configuration WhatsApp alerts - Strating
	IniFile servicesIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini",true);
	String enableWhatsAppAlert = servicesIni.getValue("WhatsApp_General_Settings","enableWhatsAppAlert");
	String selectedGateWay = servicesIni.getValue("WhatsApp_General_Settings","selectedGateWay");
	if(enableWhatsAppAlert==null || enableWhatsAppAlert=="")
	{
		enableWhatsAppAlert = "No";
	}
	rootJson.put("enableWhatsAppAlert",enableWhatsAppAlert);
	rootJson.put("selectedGateWay",selectedGateWay);

	String chatURL = servicesIni.getValue("WhatsAppGateWay_Settings_ChatAPI","gateWayURL_CA");
	String chatToken = servicesIni.getValue("WhatsAppGateWay_Settings_ChatAPI","gateWayToken_CA");

	String whatsURL = servicesIni.getValue("WhatsAppGateWay_Settings_WhatsMate","gateWayURL_WA");
	String clientSecret = servicesIni.getValue("WhatsAppGateWay_Settings_WhatsMate","clientSecret");
	String instanceID = servicesIni.getValue("WhatsAppGateWay_Settings_WhatsMate","instanceID");
	String clientID = servicesIni.getValue("WhatsAppGateWay_Settings_WhatsMate","clientID");

	rootJson.put("chatURL",chatURL);
	rootJson.put("chatToken",chatToken);
	rootJson.put("whatsURL",whatsURL);
	rootJson.put("clientSecret",clientSecret);
	rootJson.put("instanceID",instanceID);
	rootJson.put("clientID",clientID);
	String MailSender = transBean.getStrValue(subject,"MailSender");
	String UserMailIds = transBean.getStrValue(subject,"UserMailIds");
	JSONObject agentNotRunning = new JSONObject();
	String agentReportMailId = null;
	if(UserMailIds!= null && UserMailIds.trim().length()>0)
		agentReportMailId=UserMailIds;
	else if(MailSender!= null && MailSender.trim().length()>0)
		agentReportMailId=MailSender;
	if(agentReportMailId == null){
		agentNotRunning.put("agentReportMailId","");
		agentNotRunning.put("agentNotRunningStatus","no");
	}else{
		agentNotRunning.put("agentReportMailId",agentReportMailId);
		agentNotRunning.put("agentNotRunningStatus","yes");
	}
	rootJson.put("agentNotRunning",agentNotRunning);
	EgConfigFilesSync.releaseInstance(servicesIni);
	// Configuration WhatsApp alerts - Ending

	out.println(rootJson.toString());
%>



