<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.ComponentAdd"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.UserAssociateComponent"%>

<%@ page import = "com.eg.EgLicenseInfo"%>
<%@ page import = "com.eg.EgStateManager"%>
<%@ page import = "com.egurkha.monitor.remotecontrol.PreAgentInfo"%>
<%@ page import = "com.eg.EgServerList"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>

<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String strDefaultTestConfigParams = "-Proxy_Port none -Domain_Password none -Domain_Name none -Proxy_Host none -Proxy_Password none -Proxy_User_Name none -Domain_User_Name none -O365_User_Name $unconfigured -O365_Password $unconfigured -Tenant_Name none";

%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	String from = request.getParameter("from");
	String hostname = request.getParameter("hostname");
	String remoteAgent = request.getParameter("remoteAgent");
	IniFile mgrIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
	String[] splCompArr = mgrIni.getVariables("Microsoft_Components");
	ArrayList splCompList = new ArrayList(Arrays.asList(splCompArr));
	
	String[] domainCompArr = mgrIni.getVariables("Microsoft_Domain_Types");
	ArrayList domainCompList = new ArrayList(Arrays.asList(domainCompArr));
	
	if (domainCompList != null && domainCompList.size() > 0)
	{
		splCompList.removeAll(domainCompList);
	}
	
	String[] excludeCompArr = mgrIni.getVariables("Microsoft_Exclude_Types");
	ArrayList excludeCompList = new ArrayList(Arrays.asList(excludeCompArr));
	
	if (excludeCompList != null && excludeCompList.size() > 0)
	{
		splCompList.removeAll(excludeCompList);
	}

	JSONObject O365ComptypeValueField = new JSONObject();
	JSONObject O365ComptypeDisplayField = new JSONObject();
	for (int c=0;c<splCompList.size();c++)
	{
		String tempCompType = (String) splCompList.get(c);
		O365ComptypeValueField.put(_mapping.getComponentTypeDescription(tempCompType),tempCompType);
		O365ComptypeDisplayField.put(tempCompType,_mapping.getComponentTypeDescription(tempCompType));
	}
	rootJSON.put("O365ComptypeValueField",O365ComptypeValueField);
	rootJSON.put("O365ComptypeDisplayField",O365ComptypeDisplayField);

	JSONObject hiddenParams = new JSONObject();
	Enumeration e = request.getParameterNames();
	while(e.hasMoreElements())
	{
		String name = (String) e.nextElement();
		String value = request.getParameter(name);
		hiddenParams.put(name,value);
	}

	rootJSON.put("hiddenParams",hiddenParams);

	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	ArrayList allCompsUnderSplTypes = egDiscInfo.getAllHostsOfTypes(splCompList);

	int unfinishOfficeServerCnt = 0;
	if (!com.egurkha.util.StringUtils.isNull(from) && from.equalsIgnoreCase("adminwizard"))
	{
		if (allCompsUnderSplTypes != null && allCompsUnderSplTypes.size() > 0)
		{
			JSONObject compDetailsObj = new JSONObject();

			Hashtable unfinishOfficeServers = new Hashtable();
			ArrayList unfinishOfficeNicks = new ArrayList();
			for (int m=0;m<allCompsUnderSplTypes.size();m++)
			{
				String strServer = allCompsUnderSplTypes.get(m).toString();
				if (!com.egurkha.util.StringUtils.isNull(strServer))
				{
					String strServerWithoutExt = strServer.substring(0,strServer.lastIndexOf("_"));
					if (unfinishOfficeNicks != null && !unfinishOfficeNicks.contains(strServerWithoutExt))
					{
						unfinishOfficeNicks.add(strServerWithoutExt);
					}

					String dispServername = "";
					if (strServer.endsWith("_365"))
					{
						dispServername = "MS_Office_365";
					}
					else if (strServer.endsWith("_spo"))
					{
						dispServername = "Microsoft_Sharepoint_Online";
					}
					else if (strServer.endsWith("_exo"))
					{
						dispServername = "MSExchangeOnline";
					}
					// else if (strServer.endsWith("_sbo"))
					// {
						// dispServername = "MS_Skype_Online";
					// }
					else if (strServer.endsWith("_mtm"))
					{
						dispServername = "Microsoft_Teams";
					}
					else if (strServer.endsWith("_odb"))
					{
						dispServername = "MS_OneDrive_Business";
					}
					else if (strServer.endsWith("_ymr"))
					{
						dispServername = "Microsoft_Yammer";
					}

					if (unfinishOfficeServers != null && unfinishOfficeServers.containsKey(strServerWithoutExt))
					{
						ArrayList tmpDispServerName = (ArrayList) unfinishOfficeServers.get(strServerWithoutExt);
						tmpDispServerName.add(dispServername);

						tmpDispServerName = getOffice365ApplicationSortOrder(tmpDispServerName);
						unfinishOfficeServers.put(strServerWithoutExt,tmpDispServerName);
					}
					else
					{
						ArrayList dispServernameArr = new ArrayList();
						dispServernameArr.add(dispServername);
						unfinishOfficeServers.put(strServerWithoutExt,dispServernameArr);
					}

					String strCompNameWithPort = strServer+":NULL";
					String strCompType = dispServername+":"+strCompNameWithPort;

					String componentIp = egDiscInfo.getComponentIP(dispServername,strCompNameWithPort);
					JSONArray compDetailsArr = new JSONArray();
					compDetailsArr.add(componentIp);
					compDetailsArr.add(strServerWithoutExt);
					compDetailsObj.put(strCompType,compDetailsArr);
				}
			}

			rootJSON.put("compDetailsObj",compDetailsObj);

			IniFile discParamsObj = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_discoveryParams.ini");
			rootJSON.put("unfinishServerCnt",unfinishOfficeServerCnt);
			if (unfinishOfficeServers != null && unfinishOfficeServers.size() > 0)
			{
				JSONArray compTypeSummaryArray = new JSONArray();
				JSONObject compTypeSummaryObject = new JSONObject();

				JSONObject testConfigParamsForServer = new JSONObject();
				JSONObject configuredO365CompsObj = new JSONObject();
				boolean hasAllManagedOfficeServers = true;
				unfinishOfficeServerCnt = 0;

				for (int u=0;u<unfinishOfficeNicks.size();u++)
				{
					String strCompName = (String) unfinishOfficeNicks.get(u);
					compTypeSummaryObject = new JSONObject();

					ArrayList defaultList = new ArrayList(splCompList);
					ArrayList configuredList = (ArrayList) unfinishOfficeServers.get(strCompName);
					if (configuredList != null && configuredList.size() >0)
					{
						String tmpServerName = configuredList.get(0).toString();
						String strValueField  = tmpServerName+":"+strCompName+"_"+getMsOfficeExtension(tmpServerName)+":NULL";
						
						JSONArray configuredO365Comps = getConfiguredAndUnconfiguredJSONData(_mapping,configuredList);
						configuredO365CompsObj.put(strValueField,configuredO365Comps);

						for (int con=0;con<configuredList.size();con++)
						{
							String serverName = (String) configuredList.get(con);
							String strExtension  = getMsOfficeExtension(serverName);

							if (!com.egurkha.util.StringUtils.isNull(strExtension))
							{
								String strFullCompName = serverName+":"+strCompName+"_"+strExtension+":NULL";

								String value = discParamsObj.getValue(serverName,strFullCompName);
								if (!com.egurkha.util.StringUtils.isNull(value))
								{
									JSONObject hiddenTestConfigParams = new JSONObject();
									ArrayList aListTemp = getParameterList(value,false);
									for (int i=0;i<aListTemp.size();i=i+2)
									{
										String strParamName = (String)aListTemp.get(i);
										String strParamValue = (String)aListTemp.get(i+1);
										hiddenTestConfigParams.put(strParamName,strParamValue);
									}

									testConfigParamsForServer.put(strFullCompName,hiddenTestConfigParams);
								}
								else
								{
									String nickname = strCompName+"_"+strExtension+":NULL";
									Hashtable configParams = getConfiguredParamsFromAgentsIni(serverName,nickname);
									JSONObject hiddenTestConfigParams = new JSONObject();
									ArrayList aListTemp = getParameterList(strDefaultTestConfigParams,false);
									for (int i=0;i<aListTemp.size();i=i+2)
									{
										String strParamName = (String)aListTemp.get(i);
										String strParamValue = (String)aListTemp.get(i+1);

										if (configParams != null && configParams.containsKey(strParamName))
										{
											strParamValue = (String)configParams.get(strParamName);
										}
										hiddenTestConfigParams.put(strParamName,strParamValue);
									}

									testConfigParamsForServer.put(strFullCompName,hiddenTestConfigParams);

								}
							}
						}

						defaultList.removeAll(configuredList);
						if (defaultList.size()  > 0)
						{
							hasAllManagedOfficeServers = false;
							
							EgExternalInfo egExternalInfo = new EgExternalInfo("manager");

							String agentNickName = egExternalInfo.getRemoteAgentForHost(strCompName+"_"+getMsOfficeExtension(tmpServerName));
							if (!agentNickName.equalsIgnoreCase(remoteAgent))
							{
								continue;
							}

							unfinishOfficeServerCnt++;

							compTypeSummaryObject.put("displayField",strCompName);
							compTypeSummaryObject.put("valueField",strValueField);
							compTypeSummaryObject.put("imageName","comp-server");
							compTypeSummaryObject.put("highLightCls","");
							compTypeSummaryObject.put("highLightCls","highlightBg");
							compTypeSummaryObject.put("configured",configuredList.size());
							compTypeSummaryObject.put("unconfigured",defaultList.size());
							compTypeSummaryArray.add(compTypeSummaryObject);
						}
					}
				}

				rootJSON.put("configuredO365Comps",configuredO365CompsObj);
				rootJSON.put("testConfigParamsForServer",testConfigParamsForServer);
				if (hasAllManagedOfficeServers)
				{
					compTypeSummaryArray = new JSONArray();
				}
				rootJSON.put("unfinishServerCnt",unfinishOfficeServerCnt);
				rootJSON.put("unfinishCompTypeSummary",compTypeSummaryArray);
			}
		}
	}


	String remainingComps = "";
	String strWithoutSuffix = hostname;
	String[] threeHostArr = new String[]{strWithoutSuffix+"_365",strWithoutSuffix+"_spo",strWithoutSuffix+"_exo",strWithoutSuffix+"_sbo",strWithoutSuffix+"_mtm",strWithoutSuffix+"_odb"};
	ArrayList threeHostList = new ArrayList(Arrays.asList(threeHostArr));

	if (!allCompsUnderSplTypes.contains(strWithoutSuffix+"_365"))
	{
		remainingComps = "MS_Office_365" + ",";
	}
	if (!allCompsUnderSplTypes.contains(strWithoutSuffix+"_spo"))
	{
		remainingComps += "Microsoft_Sharepoint_Online" + ",";
	}
	if (!allCompsUnderSplTypes.contains(strWithoutSuffix+"_exo"))
	{
		remainingComps += "MSExchangeOnline" + ",";
	}
	// if (!allCompsUnderSplTypes.contains(strWithoutSuffix+"_sbo"))
	// {
		// remainingComps += "MS_Skype_Online" + ",";
	// }
	if (!allCompsUnderSplTypes.contains(strWithoutSuffix+"_mtm"))
	{
		remainingComps += "Microsoft_Teams" + ",";
	}
	if (!allCompsUnderSplTypes.contains(strWithoutSuffix+"_odb"))
	{
		remainingComps += "MS_OneDrive_Business" + ",";
	}
	if (!allCompsUnderSplTypes.contains(strWithoutSuffix+"_ymr"))
	{
		remainingComps += "Microsoft_Yammer" + ",";
	}

	if (!remainingComps.equals(""))
	{
		remainingComps = remainingComps.substring(0,remainingComps.length()-1);
	}
	rootJSON.put("remainingTypes",remainingComps);
	rootJSON.put("hostname",hostname);
	rootJSON.put("Office365Components",_mapping.getComponentTypeDescription("MS_Office_365")+", "+_mapping.getComponentTypeDescription("Microsoft_Sharepoint_Online")+", "+_mapping.getComponentTypeDescription("MSExchangeOnline")+", "+_mapping.getComponentTypeDescription("Microsoft_Teams")+", "+_mapping.getComponentTypeDescription("MS_OneDrive_Business")+" and "+_mapping.getComponentTypeDescription("Microsoft_Yammer"));

	EgLicenseInfo licInfo = new EgLicenseInfo();
	EgServerList serverList = new EgServerList();
	List runningAgents = PreAgentInfo.getRunningAgents();
	Vector agentsNotRunning = EgStateManager.notRunningAgents;
	ArrayList allAgents=new ArrayList();
	ArrayList validationMsgs=new ArrayList();

	if(runningAgents!=null && !runningAgents.isEmpty())
		allAgents.addAll(runningAgents);

	if(agentsNotRunning!=null && !agentsNotRunning.isEmpty())
		allAgents.addAll(agentsNotRunning);

	//below condition checked to filter the agentsList for limited user

	EgUserRole userRoleObject = EgUserRole.getRoleObject(_user.getLoginType());
	if((userRoleObject!=null && !userRoleObject.hasAllComponentAccess()) && (allAgents!=null && !allAgents.isEmpty()))
	{
		//tells information about the corresponding authenticated user
		EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
		EgExternalInfo egExternalInfo=new EgExternalInfo("manager");

		Vector allServersWithoutTypeForUser=ri.getAllServersWithoutType();
		ArrayList agentListForUser=new ArrayList();
		if(allServersWithoutTypeForUser!=null && !allServersWithoutTypeForUser.isEmpty())
		{
			Iterator itrServs=allServersWithoutTypeForUser.iterator();
			while(itrServs.hasNext())
			{
				String serv=(String)itrServs.next();
				String nick=serv.substring(0,serv.indexOf(":"));
				List agentList=egExternalInfo.getAgentsForHost(nick);
				agentListForUser.addAll(agentList);
			}		
		}
		ArrayList tempAgents=new ArrayList();
		Iterator itrAllAgents=allAgents.iterator();
		while(itrAllAgents.hasNext())
		{
			String agent=(String)itrAllAgents.next();
			if(agentListForUser!=null && agentListForUser.contains(agent))
				tempAgents.add(agent);
		}
		allAgents=tempAgents;
	}

	ArrayList totalAgents=serverList.getAgentList(allAgents);
	
	ArrayList allExternalAndRemoteAgents=new ArrayList();
	ArrayList externalAgents=licInfo.getExternalAgents();
	ArrayList remoteAgents=licInfo.getRemoteAgents();
	if(externalAgents!=null && !externalAgents.isEmpty())
		allExternalAndRemoteAgents.addAll(externalAgents);
	if(remoteAgents!=null && !remoteAgents.isEmpty())
		allExternalAndRemoteAgents.addAll(remoteAgents);

	Vector finalAgents=new Vector();
	if(totalAgents!=null && totalAgents.size()>0)
	{
		for(int s=0;s<totalAgents.size();s=s+4)
		{
			String agentIPAdd=(String)totalAgents.get(s);
			if((agentIPAdd!=null && !agentIPAdd.equalsIgnoreCase(remoteAgent)) && (allExternalAndRemoteAgents!=null && !allExternalAndRemoteAgents.contains(agentIPAdd)))
					continue;
			String agentState=(String)totalAgents.get(s+1);
			if(agentState!=null && agentState.equalsIgnoreCase("installed-running"))
			{
				finalAgents.add(agentIPAdd);
			}
		}
	}
	
	
	String office365Model = mgrIni.getValue("MISC_ARGS","office365Model");
	if (office365Model == null || office365Model.trim().length() == 0)
	{
		office365Model = "standard";
	}

	if(finalAgents != null && finalAgents.size() > 0)
	{
		if (office365Model.equalsIgnoreCase("standard"))
		{
			rootJSON.put("showValidateButton",true);
		}
		else
		{
			if (finalAgents.contains(remoteAgent))
			{
				rootJSON.put("showValidateButton",true);
			}
			else
			{
				rootJSON.put("showValidateButton",false);
			}
		}
	}
	else
	{
		rootJSON.put("showValidateButton",false);
	}

	Object encodeParamObj= session.getAttribute("encodeParamJsonList");
	if(encodeParamObj == null)
	{
		JSONArray encodeParamArr = new JSONArray();
		encodeParamArr = getEncodeParamList();
		session.setAttribute("encodeParamJsonList",encodeParamArr);
		rootJSON.put("encodeParamList",encodeParamArr);
	}
	else
	{
		rootJSON.put("encodeParamList",(JSONArray)encodeParamObj);
	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());

	out.println(rootJSON.toString());
%>

<%!
	private JSONArray getEncodeParamList()
	{
		JSONArray encodeParamArr = new JSONArray();
		IniFile testParamFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testParam.ini");
		String[] encodeParamList = testParamFile.getVariables("TC_SECURITY_SUSPICIOUS_PARAMS");
		if(encodeParamList != null && encodeParamList.length >0)
		{
			for(int i=0;i<encodeParamList.length;i++)
			{
				String paramName = encodeParamList[i];
				encodeParamArr.add(paramName);
			}
		}
		return encodeParamArr;
	}

	private ArrayList getParameterList(String str,boolean needLowerCaseKey)
	{
		String delimiter = " -";
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		str = str.substring(str.indexOf("-"));
		int spaceHyphenIdx = str.indexOf(delimiter);
		while (spaceHyphenIdx != -1)
		{
			String cutString = str.substring(0,spaceHyphenIdx);

			//This check will be carried out when the cutString contains only the key
			//for e.g.:-
			//str : -admin_password -103:98:88:90:79:76:81:-110:52 -ssl false
			//cutString : -admin_password
			if (cutString.trim().indexOf(" ") == -1)
			{
				String strPart1 = str.substring(cutString.length()+1);
				String strPart2 = strPart1.substring(0,strPart1.indexOf(delimiter));
				cutString = cutString+" "+strPart2;
				spaceHyphenIdx = cutString.length();
			}

			if (cutString.indexOf("\"") != -1)
			{
				String strAfterDoubleQuotes = str.substring(spaceHyphenIdx);
				String remainingPiece = strAfterDoubleQuotes.substring(0,strAfterDoubleQuotes.indexOf("\"")+1);
				cutString = cutString + remainingPiece;
				String key = cutString.substring(0,cutString.indexOf(" "));
				String value = cutString.substring(cutString.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(key.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(key.trim());
				}
				aListResultant.add(value.trim());

				String remainingString = strAfterDoubleQuotes.substring(strAfterDoubleQuotes.indexOf("\"")+1);
				str = remainingString.trim();
				if (str.length() == 0)
				{
					spaceHyphenIdx = -1;
				}
				else
				{
					spaceHyphenIdx = str.indexOf(delimiter);
				}
			}
			else
			{
				if (cutString.startsWith("- "))
				{
					int idx = aListResultant.indexOf(prevKey);
					String strValue = (String)aListResultant.get(idx+1);
					strValue = strValue + " " + cutString;
					aListResultant.remove(idx+1);
					aListResultant.add(strValue);

					str = str.substring(cutString.length()+1);
				}
				else
				{
					String key = cutString.substring(0,cutString.indexOf(" "));
					String value = cutString.substring(cutString.indexOf(" ")+1);

					if (needLowerCaseKey)
					{
						aListResultant.add(key.trim().toLowerCase());
						prevKey = key.trim().toLowerCase();
					}
					else
					{
						aListResultant.add(key.trim());
						prevKey = key.trim();
					}
					aListResultant.add(value.trim());

					str = str.substring(spaceHyphenIdx+1);
				}
				spaceHyphenIdx = str.indexOf(delimiter);
			}
		}

		if (str.length() > 0)
		{
			if (str.startsWith("- "))
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + " " + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
			else
			{
				String lastKey = str.substring(0,str.indexOf(" "));
				String lastValue = str.substring(str.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(lastKey.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(lastKey.trim());
				}
				aListResultant.add(lastValue.trim());
			}
		}
		return aListResultant;
	}

	private String getMsOfficeExtension(String strServer)
	{
		String strResult = "";
		if (!com.egurkha.util.StringUtils.isNull(strServer))
		{
			if (strServer.equals("MS_Office_365"))
			{
				strResult = "365";
			}
			else if (strServer.equals("Microsoft_Sharepoint_Online"))
			{
				strResult = "spo";
			}
			else if (strServer.equals("MSExchangeOnline"))
			{
				strResult = "exo";
			}
			// else if (strServer.equals("MS_Skype_Online"))
			// {
				// strResult = "sbo";
			// }
			else if (strServer.equals("Microsoft_Teams"))
			{
				strResult = "mtm";
			}
			else if (strServer.equals("MS_OneDrive_Business"))
			{
				strResult = "odb";
			}
			else if (strServer.equals("Microsoft_Yammer"))
			{
				strResult = "ymr";
			}
		}

		return strResult;
	}
	private JSONArray getConfiguredAndUnconfiguredJSONData(EgMappingInfo _mapping, ArrayList configuredList)
	{
		JSONArray ManagedHostByThisAgntInner = new JSONArray();
		JSONObject ManagedHostByThisAgntInnerObj = new JSONObject();

		JSONArray ManagedHostByThisAgnt = new JSONArray();
		JSONObject ManagedHostByThisAgntObj = new JSONObject();

		int count = configuredList.size();
		if (count > 0)
		{
			//Collections.sort(configuredList,String.CASE_INSENSITIVE_ORDER);
			for(int j=0; j<count; j++)
			{
				ManagedHostByThisAgntInnerObj = new JSONObject();
				String str_temp = (String)configuredList.get(j);

				ManagedHostByThisAgntInnerObj.put("displayField",_mapping.getComponentTypeDescription(str_temp));
				ManagedHostByThisAgntInnerObj.put("valueField",str_temp);
				ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
			}

			if (!ManagedHostByThisAgntInner.isEmpty())
			{
				ManagedHostByThisAgntObj.put(_mapping.getTextDescription("admin.la.Enabled for monitoring"),ManagedHostByThisAgntInner);
			}

			if (!ManagedHostByThisAgntObj.isEmpty())
			{
				ManagedHostByThisAgnt.add(ManagedHostByThisAgntObj);
			}
		}

		ManagedHostByThisAgntObj = new JSONObject();
		ManagedHostByThisAgntInner = new JSONArray();
		IniFile mgrIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
		String[] splCompArr = mgrIni.getVariables("Microsoft_Components");
		ArrayList unconfiguredList = new ArrayList(Arrays.asList(splCompArr));
		
		String[] domainCompArr = mgrIni.getVariables("Microsoft_Domain_Types");
		ArrayList domainCompList = new ArrayList(Arrays.asList(domainCompArr));
		
		if (domainCompList != null && domainCompList.size() > 0)
		{
			unconfiguredList.removeAll(domainCompList);
		}
		
		String[] excludeCompArr = mgrIni.getVariables("Microsoft_Exclude_Types");
		ArrayList excludeCompList = new ArrayList(Arrays.asList(excludeCompArr));
		
		if (excludeCompList != null && excludeCompList.size() > 0)
		{
			unconfiguredList.removeAll(excludeCompList);
		}
		
		unconfiguredList.removeAll(configuredList);
		count = unconfiguredList.size();
		if (count > 0)
		{
			for(int j=0; j<count; j++)
			{
				ManagedHostByThisAgntInnerObj = new JSONObject();
				String str_temp = (String)unconfiguredList.get(j);

				ManagedHostByThisAgntInnerObj.put("displayField",_mapping.getComponentTypeDescription(str_temp));
				ManagedHostByThisAgntInnerObj.put("valueField",str_temp);
				ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
			}

			if (!ManagedHostByThisAgntInner.isEmpty())
			{
				ManagedHostByThisAgntObj.put(_mapping.getTextDescription("admin.la.Not enabled yet for monitoring"),ManagedHostByThisAgntInner);
			}

			if (!ManagedHostByThisAgntObj.isEmpty())
			{
				ManagedHostByThisAgnt.add(ManagedHostByThisAgntObj);
			}
		}

		return ManagedHostByThisAgnt;
	}

	private ArrayList getOffice365ApplicationSortOrder(ArrayList configuredList)
	{

		if (configuredList == null || configuredList.isEmpty())
		{
			return (new ArrayList());
		}

		int size = configuredList.size();
		if (size > 1)
		{
			if (configuredList.contains("MSExchangeOnline"))
			{
				configuredList.remove("MSExchangeOnline");
				configuredList.add(0,"MSExchangeOnline");
			}

			if (configuredList.contains("MS_Office_365"))
			{
				if (configuredList.contains("MSExchangeOnline"))
				{
					configuredList.remove("MS_Office_365");
					configuredList.add(1,"MS_Office_365");
				}
				else
				{
					configuredList.remove("MS_Office_365");
					configuredList.add(0,"MS_Office_365");
				}
			}

			if (configuredList.contains("Microsoft_Sharepoint_Online"))
			{
				if (configuredList.contains("MSExchangeOnline") && configuredList.contains("MS_Office_365"))
				{
					configuredList.remove("Microsoft_Sharepoint_Online");
					configuredList.add(2,"Microsoft_Sharepoint_Online");
				}
				else if (configuredList.contains("MSExchangeOnline") || configuredList.contains("MS_Office_365"))
				{
					configuredList.remove("Microsoft_Sharepoint_Online");
					configuredList.add(1,"Microsoft_Sharepoint_Online");
				}
				else 
				{
					configuredList.remove("Microsoft_Sharepoint_Online");
					configuredList.add(0,"Microsoft_Sharepoint_Online");
				}
			}
		}

		return configuredList;
	}

	private Hashtable getConfiguredParamsFromAgentsIni(String componentType, String nickname)
	{
		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		String configFileDir = EgInstallInfo.getInstallDir() + "/manager/config/";
		IniFile agentIni = new IniFile(configFileDir+"eg_agents.ini");

		Hashtable resultTable = new Hashtable();

		ArrayList aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		ArrayList excludedTestList = new ArrayList(getExcludedTestsForThisCompType(componentType, nickname,aListEnabledTestForCompType));

		if (excludedTestList != null && !excludedTestList.isEmpty())
		{
			aListEnabledTestForCompType.removeAll(excludedTestList);
		}

		String nickWithoutPort = nickname.substring(0,nickname.indexOf(":"));
		List aListAgents = getAgents(nickname);
		if (aListEnabledTestForCompType != null && !aListEnabledTestForCompType.isEmpty())
		{
			String testName = aListEnabledTestForCompType.get(0).toString();
			boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);

			String tempAgentNickName = null;
			if (isExternalTest)
			{
				tempAgentNickName = (String)aListAgents.get(1);
			}
			else
			{
				tempAgentNickName = (String)aListAgents.get(0);
			}

			if (tempAgentNickName == null)
			{
				return (new Hashtable());
			}

			String specificPattern_A = testName + ":" + componentType + ":" + nickname;
			String specificPattern_B = testName + ":" + componentType + ":" + nickWithoutPort;
			String defaultPattern_A = testName + "::" + nickname;
			String defaultPattern_B = testName + "::" + nickWithoutPort;
			String agentIniVariables[] = agentIni.getVariables(tempAgentNickName);
			List listAgentIniVariables = Arrays.asList(agentIniVariables);
			String resultantPattern = "";
			if (listAgentIniVariables.contains(specificPattern_A))
			{
				resultantPattern = specificPattern_A;
			}
			else if (listAgentIniVariables.contains(specificPattern_B))
			{
				resultantPattern = specificPattern_B;
			}
			else if (listAgentIniVariables.contains(defaultPattern_A))
			{
				resultantPattern = defaultPattern_A;
			}
			else if (listAgentIniVariables.contains(defaultPattern_B))
			{
				resultantPattern = defaultPattern_B;
			}

			if (resultantPattern.equalsIgnoreCase(""))
			{
				return (new Hashtable());
			}

			String agentVal =  agentIni.getValue(tempAgentNickName,resultantPattern);
			ArrayList aListTemp = getParameterList(strDefaultTestConfigParams,false);
			ArrayList aResultant = getParameterList(agentVal,false);
			ArrayList aListResultantTempInLowerCase = new ArrayList();
			for (int i=0;i<aResultant.size();i++)
			{
				String strResult = aResultant.get(i).toString();
				aListResultantTempInLowerCase.add(strResult.toLowerCase());
			}

			for (int i=0;i<aListTemp.size();i=i+2)
			{
				String strParamName = (String)aListTemp.get(i);
				int paramIdx = aListResultantTempInLowerCase.indexOf(strParamName.toLowerCase());

				String paramValue = null;
				if (paramIdx != -1)
				{
					paramValue = (String)aResultant.get(paramIdx+1);
				}

				if (paramValue != null)
				{
					resultTable.put(strParamName,paramValue);
				}
			}
		}

		return resultTable;
	}

	private ArrayList getExcludedTestsForThisCompType(String componentType, String componentName, ArrayList aListEnabledTestForCompType)
	{
		String configFileDir = EgInstallInfo.getInstallDir() + "/manager/config/";
		IniFile prgBean = new IniFile(configFileDir+"eg_disable.ini");
		ArrayList excludedTestList = new ArrayList();

		String componentNickName = componentName.substring(0,componentName.indexOf(":"));

		String excludedTestForComp = prgBean.getValue(componentType,componentType+":"+componentName);
		if (excludedTestForComp != null && !excludedTestForComp.equals(""))
		{
			StringTokenizer excludedTestTokens = new StringTokenizer(excludedTestForComp,",");
			while (excludedTestTokens.hasMoreElements())
			{
				String excludeTestComp = (String)excludedTestTokens.nextElement();
				boolean isCompHost = aListEnabledTestForCompType.contains(excludeTestComp);
				if (isCompHost)
				{
					if (excludedTestList != null && !excludedTestList.contains(excludeTestComp))
					{
						excludedTestList.add(excludeTestComp);
					}
				}
			}
		}

		String excludedTestForHost = prgBean.getValue("Default_server","Default_server"+":"+componentNickName);
		if (excludedTestForHost != null && !excludedTestForHost.equals(""))
		{
			StringTokenizer excludedTestTokens = new StringTokenizer(excludedTestForHost,",");
			while (excludedTestTokens.hasMoreElements())
			{
				String excludeTest = (String)excludedTestTokens.nextElement();
				boolean isComptypeTest = aListEnabledTestForCompType.contains(excludeTest);
				if (isComptypeTest)
				{
					if (excludedTestList != null && !excludedTestList.contains(excludeTest))
					{
						excludedTestList.add(excludeTest);
					}
				}
			}
		}

		return  excludedTestList;
	}

	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";

		boolean isRemote = false;

		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}
%>


