<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import= "egurkha.EgUIUtils"%>
<%@ page import = "com.eg.AzureSubscriptionDiscovery"%>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "java.sql.*" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	
	JSONObject rootJSON = new JSONObject();

	String from = request.getParameter("from");
	String remoteAgent = request.getParameter("remoteAgent");
	IniFile msAzureConfig = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_msazureconfig.ini");
	
	String user_id = _user.getLoginID();
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	
	ArrayList azureCompList = new ArrayList();
	ArrayList listOfComponents = new ArrayList(Arrays.asList(egRoleInfo.getAllServersOfType("MS_Azure_Cloud")));
	azureCompList = getAzureComponentsForUser(listOfComponents);
	
	if (StringUtils.isNull(from))
	{
		from = "";
	}
	
	if (from.equals("adminwizard"))
	{
		String[] tenantsArr = msAzureConfig.getVariables(remoteAgent);
		JSONArray jsonArr = new JSONArray();
		if (tenantsArr != null && tenantsArr.length > 0)
		{
			ArrayList eligibleTenantList = new ArrayList();
			int len = tenantsArr.length;
			for (int i=0; i<len; i++)
			{
				String tenantId = tenantsArr[i];
				String tenantNameStr = msAzureConfig.getValue(remoteAgent,tenantId);
				
				if (tenantNameStr != null && tenantNameStr.length() > 0)
				{
					ArrayList tenantNameList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantNameStr,"^#^")));
					int tenantSize = tenantNameList.size();
					for (int j=0; j<tenantSize; j++)
					{
						boolean hasCompoenent = false;
						String tenantName = (String) tenantNameList.get(j);
						String[] subscriptionArr = null;
						if (!StringUtils.isNull(tenantNameStr))
						{
							subscriptionArr = msAzureConfig.getVariables(remoteAgent+"^#^"+tenantId+"^#^"+tenantName);
						}
						
						if (subscriptionArr != null && subscriptionArr.length > 0)
						{
							int subscriptionLen = subscriptionArr.length;
							
							if (azureCompList != null && azureCompList.size() > 0)
							{
								for (int x=0; x<subscriptionLen; x++)
								{
									String tempVar = subscriptionArr[x];
									String nickName = tempVar.substring(tempVar.indexOf("^#^")+3);
									
									if (azureCompList.contains(nickName))
									{
										hasCompoenent = true;
									}
								}
							}
						}
						if (hasCompoenent)
						{
							JSONObject jsonObj = new JSONObject();
							jsonObj.put("displayField",tenantName);
							jsonObj.put("valueField",tenantId);
							jsonObj.put("content","");
							jsonObj.put("imageName","comp-cloud");
							jsonArr.add(jsonObj);
						}
					}
				}
			}
		}
		rootJSON.put("tenantsArr",jsonArr);
	}
	else if (from.equals("MSAzureGridView"))
	{
		JSONArray msAzureArr = new JSONArray();
		JSONObject columns = new JSONObject();
		columns.put("Subscription ID","Subscription ID");
		columns.put("Nick Name","Nick name for Subscription ID");
		columns.put("Client ID","Client ID");
		
		String tenant_id = request.getParameter("tenant_id");
		tenant_id = EgUIUtils.decodeSecurityChar(tenant_id);
		String tenant_name = request.getParameter("tenant_name");
		tenant_name = EgUIUtils.decodeSecurityChar(tenant_name);
		
		String tenantNamesStr = msAzureConfig.getValue(remoteAgent,tenant_id);
		String[] subscriptionArr = null;
		if (!StringUtils.isNull(tenantNamesStr))
		{
			subscriptionArr = msAzureConfig.getVariables(remoteAgent+"^#^"+tenant_id+"^#^"+tenant_name);
		}
		if (subscriptionArr != null && subscriptionArr.length > 0)
		{
			int subscriptionLen = subscriptionArr.length;
			ArrayList gridSubscriptionList = new ArrayList();
			if (azureCompList != null && azureCompList.size() > 0)
			{
				for (int x=0; x<subscriptionLen; x++)
				{
					String tempVar = subscriptionArr[x];
					String nickName = tempVar.substring(tempVar.indexOf("^#^")+3); 
					
					if (azureCompList.contains(nickName))
					{
						gridSubscriptionList.add(tempVar);
					}
				}
			}
			if (gridSubscriptionList != null && gridSubscriptionList.size() > 0)
			{
				EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
				ArrayList allManagedCompList = egDiscInfo.getAllManagedNames(true);
				
				int size = gridSubscriptionList.size();
				for (int x=0; x<size; x++)
				{
					String tempVar = (String) gridSubscriptionList.get(x);
					JSONObject msAzureObj = new JSONObject();
					String subscriptionStr = tempVar.substring(0,tempVar.indexOf("^#^"));
					String nickName = tempVar.substring(tempVar.indexOf("^#^")+3);
					if (allManagedCompList != null && allManagedCompList.contains("MS_Azure_Cloud:"+nickName+":NULL"))
					{
						String tempVal = msAzureConfig.getValue(remoteAgent+"^#^"+tenant_id+"^#^"+tenant_name,tempVar);
						ArrayList valueList = new ArrayList(Arrays.asList(StringUtils.getTokens(tempVal,"^#^")));
						String clientId = (String) valueList.get(0);
						//String clientPwd = (String) valueList.get(1);
						msAzureObj.put("Subscription ID",subscriptionStr);
						msAzureObj.put("Nick Name",nickName);
						msAzureObj.put("Client ID",clientId);
						msAzureArr.add(msAzureObj);
					}
				}
			}
		}
		String gridTitle = "Microsoft Azure Subscriptions";
		rootJSON.put("tenantName",tenant_name);
		rootJSON.put("columns",columns);
		rootJSON.put("gridData",msAzureArr);
		rootJSON.put("gridTitle",gridTitle);
	}
	else if (from.equals("getSubscriptionDetails"))
	{
		JSONArray subscriptionArr = new JSONArray();
		String tenant_id = request.getParameter("tenant_id");
		tenant_id = EgUIUtils.decodeSecurityChar(tenant_id);
		String tenant_name = request.getParameter("tenant_name");
		tenant_name = EgUIUtils.decodeSecurityChar(tenant_name);
		String subscriptionId = request.getParameter("subscriptionId");
		String nickName = request.getParameter("nickName");
		String tenantName = msAzureConfig.getValue(remoteAgent,tenant_id);
		String tenantDispName = "";
		String subscriptionDetailStr = "";
		if (!StringUtils.isNull(tenantName))
		{
			subscriptionDetailStr = msAzureConfig.getValue(remoteAgent+"^#^"+tenant_id+"^#^"+tenant_name,subscriptionId+"^#^"+nickName);
		}
		if (subscriptionDetailStr != null && subscriptionDetailStr.length() > 0)
		{
			JSONObject subscriptionObj = new JSONObject();
			ArrayList valueList = new ArrayList(Arrays.asList(StringUtils.getTokens(subscriptionDetailStr,"^#^")));
			String clientId = (String) valueList.get(0);
			String clientPwd = (String) valueList.get(1);
			clientPwd = EgCrypt.decrypt(clientPwd);
			
			subscriptionObj.put("tenantDispName",tenant_name);
			subscriptionObj.put("clientId",clientId);
			subscriptionObj.put("clientPwd",clientPwd);
			subscriptionArr.add(subscriptionObj);
		}
		rootJSON.put("subscriptionDetails",subscriptionArr);
	}
	else if (from.equals("updateSubscriptionDetails"))
	{
		String subscriptionId = request.getParameter("Subscription_ID");
		subscriptionId = EgUIUtils.decodeSecurityChar(subscriptionId);
		String nickname = request.getParameter("nickname");
		nickname = EgUIUtils.decodeSecurityChar(nickname);
		String tenant_name = request.getParameter("tenant_name");
		tenant_name = EgUIUtils.decodeSecurityChar(tenant_name);
		String tenant_id = request.getParameter("tenant_id");
		tenant_id = EgUIUtils.decodeSecurityChar(tenant_id);
		String client_id = request.getParameter("client_id");
		client_id = EgUIUtils.decodeSecurityChar(client_id);
		String client_password = request.getParameter("client_password");
		client_password = EgUIUtils.decodeSecurityChar(client_password);
		
		String tenantNameStr = msAzureConfig.getValue(remoteAgent,tenant_id);
		String prevSubscriptionArr = msAzureConfig.getValue(remoteAgent+"^#^"+tenant_id+"^#^"+tenant_name,subscriptionId+"^#^"+nickname);
		ArrayList prevSubscriptionList = new ArrayList(Arrays.asList(StringUtils.getTokens(prevSubscriptionArr,"^#^")));
		boolean isClientDetailsChanged = false;
		
		String prevClientId = (String) prevSubscriptionList.get(0);
		String prevClientPwd = (String) prevSubscriptionList.get(1);
		prevClientPwd = EgCrypt.decrypt(prevClientPwd);
		if (!prevClientId.equals(client_id) || !prevClientPwd.equals(client_password))
		{
			isClientDetailsChanged = true;
		}
		
		EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
		ArrayList allManagedCompList = egDiscInfo.getAllManagedNames(true);
		
		JSONArray clientDetailsGirdArr = new JSONArray();
		JSONObject clientDetailsGridColumns = new JSONObject();
		clientDetailsGridColumns.put("Subscription ID","Subscription ID");
		clientDetailsGridColumns.put("Nick Name","Nick name for Subscription ID");
		clientDetailsGridColumns.put("Tenant Name","Tenant Name");
		clientDetailsGridColumns.put("Remote Agent","Remote Agent");
		if (isClientDetailsChanged)
		{
			IniFile mgrmiscIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_mgrmisc.ini");
		
			String managerProxyDetails = mgrmiscIni.getValue("MANAGER_PROXY_DETAILS","ManagerProxy");
			String isProxyServerEnabled = "false";
			String isProxyAuthenticationEnabled = "false";
			String proxyHost = "";
			String proxyPort = "";
			String proxyUsername = "";
			String proxyPassword = "";
			
			if (managerProxyDetails != null && managerProxyDetails.trim().length() > 0)
			{
				if (managerProxyDetails.indexOf("^#^") > -1)
				{
					ArrayList valueList = new ArrayList(Arrays.asList(StringUtils.getTokens(managerProxyDetails,"^#^")));
					if (valueList.size() > 0)
					{
						isProxyServerEnabled = "true";
						proxyHost = (String)valueList.get(0);
						proxyPort = (String)valueList.get(1);
						if (valueList.size() == 4)
						{
							isProxyAuthenticationEnabled = "true";
							proxyUsername = (String)valueList.get(2);
							proxyPassword = (String)valueList.get(3);
						}
					}
				}
			}
			
			AzureSubscriptionDiscovery azureDiscovery = null;
			if (isProxyServerEnabled != null && isProxyServerEnabled.equalsIgnoreCase("true"))
			{
				proxyPassword = EgCrypt.olddecrypt(proxyPassword);
				
				azureDiscovery = new AzureSubscriptionDiscovery(tenant_id,client_id,client_password,proxyHost,proxyPort,proxyUsername,proxyPassword);
			}
			else
			{
				azureDiscovery = new AzureSubscriptionDiscovery(tenant_id,client_id,client_password);
			}
			
			ArrayList validateMsgList = azureDiscovery.getValidationMsgs();
			String validateMsg = (String) validateMsgList.get(0);
			if (!StringUtils.isNull(validateMsg))
			{
				String msg = validateMsg.substring(validateMsg.indexOf("$#$")+3).trim();
				if (msg.equalsIgnoreCase("OK"))
				{
					ArrayList allEligibleSubscriptionList = new ArrayList();
					ArrayList allSubscriptionWithNickList = getSubscriptionsForClientID(remoteAgent,prevClientId,client_id,client_password,tenant_id);
					if (allSubscriptionWithNickList !=null && allSubscriptionWithNickList.size() > 0)
					{
						int size = allSubscriptionWithNickList.size();
						for (int x=0; x<size; x++)
						{
							ArrayList subscriptionWithNickList = (ArrayList) allSubscriptionWithNickList.get(x);
							String nickStr = (String)subscriptionWithNickList.get(1);
							if (azureCompList.contains(nickStr))
							{
								allEligibleSubscriptionList.add(subscriptionWithNickList);
							}
						}
					}
					
					if (allEligibleSubscriptionList !=null && allEligibleSubscriptionList.size() > 0)
					{
						int size = allEligibleSubscriptionList.size();
						for (int x=0; x<size; x++)
						{
							JSONObject clientDetailsGirdObj = new JSONObject();
							ArrayList subscriptionWithNickList = (ArrayList) allEligibleSubscriptionList.get(x);
							String subscriptionStr = (String)subscriptionWithNickList.get(0);
							String nicknameStr = (String)subscriptionWithNickList.get(1);
							String tenantNameId = (String)subscriptionWithNickList.get(2);
							String remoteAgentStr = (String)subscriptionWithNickList.get(3);
							if (allManagedCompList != null && allManagedCompList.contains("MS_Azure_Cloud:"+nicknameStr+":NULL"))
							{
								clientDetailsGirdObj.put("subscriptionId",subscriptionStr);
								clientDetailsGirdObj.put("nicknameId",nicknameStr);
								clientDetailsGirdObj.put("tenantnameId",tenantNameId);
								clientDetailsGirdObj.put("remoteAgentId",remoteAgentStr);
								clientDetailsGirdArr.add(clientDetailsGirdObj);
							}
						}
					}
					rootJSON.put("resultMsg","success");
				}
				else
				{
					String resultMsg = msg.substring(msg.indexOf("-")+1).trim();
					rootJSON.put("resultMsg",resultMsg);
				}
			}
		}
		
		rootJSON.put("isClientDetailsChanged",isClientDetailsChanged);
		String clientDetailsGridTitle = "Microsoft Azure Subscriptions";
		rootJSON.put("clientDetailsGridColumns",clientDetailsGridColumns);
		rootJSON.put("clientDetailsGridData",clientDetailsGirdArr);
		rootJSON.put("clientDetailsGridTitle",clientDetailsGridTitle);
		
		JSONObject hiddenParams = new JSONObject();
		hiddenParams.put("remoteAgent",remoteAgent);
		hiddenParams.put("tenant_name",tenant_name);
		hiddenParams.put("tenant_id",tenant_id);
		hiddenParams.put("prevClientId",prevClientId);
		hiddenParams.put("prevClientPwd",EgCrypt.encrypt(prevClientPwd));
		hiddenParams.put("client_id",client_id);
		hiddenParams.put("client_password",client_password);
		rootJSON.put("hiddenParams",hiddenParams);
	}
	else if (from.equals("getTenantNames"))
	{
		String tenant_id = request.getParameter("tenant_id");
		tenant_id = EgUIUtils.decodeSecurityChar(tenant_id);
		String tenant_name = request.getParameter("tenant_name");
		tenant_name = EgUIUtils.decodeSecurityChar(tenant_name);
		boolean isTenantNameExist = isTenantNameExist(tenant_name, tenant_id);
		
		rootJSON.put("isTenantNameExist", isTenantNameExist);
		
		
		EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
		ArrayList allCompNicks = egDiscInfo.getAllComponentNicks();
		
		JSONObject allCompsArr = new JSONObject();
		if (allCompNicks != null && allCompNicks.size() > 0)
		{
			int size = allCompNicks.size();
			for (int x=0; x<size; x++)
			{
				String compName = (String) allCompNicks.get(x);
				if (StringUtils.isNull(compName))
				{
					continue;
				}
				allCompsArr.put(compName,compName);
			}
		}
		rootJSON.put("allCompNicks",allCompsArr);
	}
	else if (from.equals("checkTenantName"))
	{
		boolean isTenantNameExist = false;
		String tenant_id = request.getParameter("tenant_id");
		tenant_id = EgUIUtils.decodeSecurityChar(tenant_id);
		String[] tenantIdArr = msAzureConfig.getVariables(remoteAgent);
		if (tenantIdArr != null && tenantIdArr.length > 0)
		{
			int tntIdSize = tenantIdArr.length;
			for (int i=0; i<tntIdSize; i++)
			{
				String tenantId = tenantIdArr[i];
				String tenantNames = msAzureConfig.getValue(remoteAgent,tenantId);
				if (!StringUtils.isNull(tenantNames))
				{
					isTenantNameExist = true;
					break;
				}
			}
		}
		rootJSON.put("isTenantExistForRmtAgent", isTenantNameExist);
	}
	else if (from.equals("renameNickName"))
	{
		String tenant_id = request.getParameter("tenantId");
		tenant_id = EgUIUtils.decodeSecurityChar(tenant_id);
		String tenant_name = request.getParameter("tenantName");
		tenant_name = EgUIUtils.decodeSecurityChar(tenant_name);
		String subscriptionId = request.getParameter("subscriptionId");
		subscriptionId = EgUIUtils.decodeSecurityChar(subscriptionId);
		String oldNickName = request.getParameter("oldNickName");
		String newNickName = request.getParameter("newNickName");
		
		IniFile msAzureConfigWrt = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_msazureconfig.ini");
		String oldNickDetails = msAzureConfig.getValue(remoteAgent+"^#^"+tenant_id+"^#^"+tenant_name,subscriptionId+"^#^"+oldNickName);
		if (!StringUtils.isNull(oldNickDetails))
		{
			msAzureConfigWrt.setValue(remoteAgent+"^#^"+tenant_id+"^#^"+tenant_name,subscriptionId+"^#^"+newNickName,oldNickDetails);
			msAzureConfigWrt.deleteValue(remoteAgent+"^#^"+tenant_id+"^#^"+tenant_name,subscriptionId+"^#^"+oldNickName);
		}
		msAzureConfigWrt.saveFile();
		EgConfigFilesSync.releaseInstance(msAzureConfigWrt);
		
		IniFile discoverParamWrt = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_discoveryParams.ini");
		String oldNickParams = discoverParamWrt.getValue("MS_Azure_Cloud","MS_Azure_Cloud"+":"+oldNickName+":NULL");
		if (!StringUtils.isNull(oldNickParams))
		{
			discoverParamWrt.setValue("MS_Azure_Cloud","MS_Azure_Cloud"+":"+newNickName+":NULL",oldNickParams);
			discoverParamWrt.deleteValue("MS_Azure_Cloud","MS_Azure_Cloud"+":"+oldNickName+":NULL");
		}
		discoverParamWrt.saveFile();
		EgConfigFilesSync.releaseInstance(discoverParamWrt);
		
		rootJSON.put("updateStatus","success");
	}
	else if (from.equals("getExtRmtAgent"))
	{
		String nickName = request.getParameter("nickName");
		EgExternalInfo externalInfo = new EgExternalInfo("manager");
		String remoteAgentForHost = externalInfo.getRemoteAgentForHost(nickName);
		String[] extAgents = externalInfo.getExternalAgentsForHost(nickName);
		session.setAttribute("type","MS_Azure_Cloud");
		rootJSON.put("rmtAgentForNick",remoteAgentForHost);
		rootJSON.put("extAgentForNick",extAgents[0]);
	}
	else
	{
		String tenant_name = request.getParameter("tenant_name");
		tenant_name = EgUIUtils.decodeSecurityChar(tenant_name);
		String tenant_id = request.getParameter("tenant_id");
		tenant_id = EgUIUtils.decodeSecurityChar(tenant_id);
		String client_id = request.getParameter("client_id");
		client_id = EgUIUtils.decodeSecurityChar(client_id);
		String client_password = request.getParameter("client_password");
		client_password = EgUIUtils.decodeSecurityChar(client_password);
		
		IniFile mgrmiscIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_mgrmisc.ini");
		
		String managerProxyDetails = mgrmiscIni.getValue("MANAGER_PROXY_DETAILS","ManagerProxy");
		String isProxyServerEnabled = "false";
		String isProxyAuthenticationEnabled = "false";
		String proxyHost = "";
		String proxyPort = "";
		String proxyUsername = "";
		String proxyPassword = "";
		
		if (managerProxyDetails != null && managerProxyDetails.trim().length() > 0)
		{
			if (managerProxyDetails.indexOf("^#^") > -1)
			{
				ArrayList valueList = new ArrayList(Arrays.asList(StringUtils.getTokens(managerProxyDetails,"^#^")));
				if (valueList.size() > 0)
				{
					isProxyServerEnabled = "true";
					proxyHost = (String)valueList.get(0);
					proxyPort = (String)valueList.get(1);
					if (valueList.size() == 4)
					{
						isProxyAuthenticationEnabled = "true";
						proxyUsername = (String)valueList.get(2);
						proxyPassword = (String)valueList.get(3);
					}
				}
			}
		}
		
		AzureSubscriptionDiscovery azureDiscovery = null;
		if (isProxyServerEnabled != null && isProxyServerEnabled.equalsIgnoreCase("true"))
		{
			proxyPassword = EgCrypt.olddecrypt(proxyPassword);
			
			azureDiscovery = new AzureSubscriptionDiscovery(tenant_id,client_id,client_password,proxyHost,proxyPort,proxyUsername,proxyPassword);
		}
		else
		{
			azureDiscovery = new AzureSubscriptionDiscovery(tenant_id,client_id,client_password);
		}
		
		ArrayList validateMsgList = azureDiscovery.getValidationMsgs();
		String validateMsg = (String) validateMsgList.get(0);
		JSONArray subscriptionArray = new JSONArray();
		if (!StringUtils.isNull(validateMsg))
		{
			String msg = validateMsg.substring(validateMsg.indexOf("$#$")+3).trim();
			if (msg.equalsIgnoreCase("OK"))
			{
				ArrayList subscriptionList = azureDiscovery.getSubscriptionListDetail();
				if (subscriptionList != null && subscriptionList.size() > 0)
				{
					JSONObject subscriptionObj = new JSONObject();
					int subscriptionSize = subscriptionList.size ();
					for (int x=0; x<subscriptionSize; x++)
					{
						String subscriptionId = (String)subscriptionList.get(x);
						String nickName = subscriptionId.replace("-","");
						boolean isSubscriptionExist = isSubscriptionIdExists(remoteAgent, tenant_id, subscriptionId);
						if (isSubscriptionExist)
						{
							continue;
						}
						subscriptionObj.put("subscription",subscriptionId);
						subscriptionObj.put("nickname",nickName);
						subscriptionArray.add(subscriptionObj);
					}
				}
				rootJSON.put("resultMsg","success");
			}
			else
			{
				String resultMsg = msg.substring(msg.indexOf("-")+1).trim();
				rootJSON.put("resultMsg",resultMsg);
			}
			rootJSON.put("subscriptionList",subscriptionArray);
		}

		JSONObject hiddenParams = new JSONObject();
		hiddenParams.put("tenant_name",tenant_name);
		hiddenParams.put("tenant_id",tenant_id);
		hiddenParams.put("client_id",client_id);
		hiddenParams.put("client_password",client_password);
		rootJSON.put("hiddenParams",hiddenParams);
	}
	
	session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());
	
	out.println(rootJSON.toString());
%>

<%!
	private boolean isSubscriptionIdExists(String remoteAgentStr, String tenant_id,String subscriptionId)
	{
		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		String[] allremagents = egExternalInfo.getAllRemoteAgents();
		if (allremagents != null && allremagents.length > 0)
		{
			IniFile msAzureConfig = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_msazureconfig.ini");
			for (int i=0; i<allremagents.length; i++)
			{
				String remoteAgent = allremagents[i];
				String tenantId = msAzureConfig.getValue(remoteAgent,tenant_id);
				if (!StringUtils.isNull(tenantId))
				{
					ArrayList tenantNameList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantId,"^#^")));
					for (int x=0; x<tenantNameList.size(); x++)
					{
						String tenantName = (String) tenantNameList.get(x);
						
						String[] varArr =msAzureConfig.getVariables(remoteAgent+"^#^"+tenant_id+"^#^"+tenantName);
						if (varArr != null && varArr.length > 0)
						{
							for (int m=0; m<varArr.length; m++)
							{
								String subscriptionWithNick = varArr[m];
								if (subscriptionWithNick.startsWith(subscriptionId))
								{
									return true;
								}
							}
						}
					}
				}
			}
		}
		return false;
	}
	
	private ArrayList getAllTenantNames()
	{
		ArrayList allTenantNameList = new ArrayList();
		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		String[] allremagents = egExternalInfo.getAllRemoteAgents();
		if (allremagents != null && allremagents.length > 0)
		{
			IniFile msAzureConfig = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_msazureconfig.ini");
			for (int i=0; i<allremagents.length; i++)
			{
				String remoteAgent = allremagents[i];
				String[] tenantIdArr = msAzureConfig.getVariables(remoteAgent);
				if (tenantIdArr != null && tenantIdArr.length > 0)
				{
					int tntIdSize = tenantIdArr.length;
					for (int j=0; j<tntIdSize; j++)
					{
						String tenant_id = tenantIdArr[j];
						String tenantNames = msAzureConfig.getValue(remoteAgent,tenant_id);
						if (!StringUtils.isNull(tenantNames))
						{
							ArrayList tenantNameList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantNames,"^#^")));
							int size = tenantNameList.size();
							for (int k=0; k<size; k++)
							{
								String tenantName = (String) tenantNameList.get(k);
								//tenantNamesArr.add(tenantName);
								allTenantNameList.add(tenantName.toLowerCase());
							}
						}
					}
				}
			}
		}
		return allTenantNameList;
	}
	
	private boolean isTenantNameExist(String tenant_name, String tenant_id)
	{
		boolean isValidTenantName = true;
		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		String[] allremagents = egExternalInfo.getAllRemoteAgents();
		if (allremagents != null && allremagents.length > 0)
		{
			ArrayList tenantNamesForTenantId = new ArrayList();
			ArrayList allTenantNameList = getAllTenantNames();
			IniFile msAzureConfig = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_msazureconfig.ini");
			for (int i=0; i<allremagents.length; i++)
			{
				String remoteAgent = allremagents[i];
				String tenantNames = msAzureConfig.getValue(remoteAgent,tenant_id);
				if (!StringUtils.isNull(tenantNames))
				{
					ArrayList tenantNameList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantNames,"^#^")));
					int size = tenantNameList.size();
					for (int k=0; k<size; k++)
					{
						String tenantName = (String) tenantNameList.get(k);
						tenantNamesForTenantId.add(tenantName.toLowerCase());
					}
				}
			}
			if (tenantNamesForTenantId != null &&tenantNamesForTenantId.contains(tenant_name.toLowerCase()))
			{
				isValidTenantName = true; // tenant name exist for tenant id
			}
			else if (allTenantNameList != null && allTenantNameList.contains(tenant_name.toLowerCase()))
			{
				isValidTenantName = false; // tenant name exist for other tenant ids
			}
			else
			{
				isValidTenantName = true; // new tenant name
			}
		}
		return isValidTenantName;
	}
	
	private ArrayList getSubscriptionsForClientID(String remoteAgentStr,String prevClientId,String curClientId,String curClientPwd,String tenant_id)
	{
		ArrayList subscriptionWithNickList = new ArrayList();
		IniFile msAzureConfig = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_msazureconfig.ini");
		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		String[] allremagents = egExternalInfo.getAllRemoteAgents();
		if (allremagents != null && allremagents.length > 0)
		{
			for (int i=0; i<allremagents.length; i++)
			{
				String remoteAgent = allremagents[i];
				String tenantId = msAzureConfig.getValue(remoteAgent,tenant_id);
				if (!StringUtils.isNull(tenantId))
				{
					ArrayList tenantNameList = new ArrayList(Arrays.asList(StringUtils.getTokens(tenantId,"^#^")));
					for (int x=0; x<tenantNameList.size(); x++)
					{
						String tenantName = (String) tenantNameList.get(x);
						String[] subscriptionWithNick = msAzureConfig.getVariables(remoteAgent+"^#^"+tenant_id+"^#^"+tenantName);
						if (subscriptionWithNick != null && subscriptionWithNick.length > 0)
						{
							for (int y=0; y<subscriptionWithNick.length; y++)
							{
								String subscriptionStr = subscriptionWithNick[y];
								String subscriptionId = subscriptionStr.substring(0,subscriptionStr.indexOf("^#^"));
								String nickName = subscriptionStr.substring(subscriptionStr.indexOf("^#^")+3);
								String subscriptionDetailStr = msAzureConfig.getValue(remoteAgent+"^#^"+tenant_id+"^#^"+tenantName,subscriptionStr);
								ArrayList subscriptionDetailList = new ArrayList(Arrays.asList(StringUtils.getTokens(subscriptionDetailStr,"^#^")));
								String clientIdStr = (String)subscriptionDetailList.get(0);
								String clientPwdStr = (String)subscriptionDetailList.get(1);
								if (prevClientId.equals(clientIdStr))
								{
									if (!clientIdStr.equals(curClientId) || !clientPwdStr.equals(curClientPwd))
									{
										ArrayList tempList = new ArrayList();
										tempList.add(subscriptionId);
										tempList.add(nickName);
										tempList.add(tenantName);
										tempList.add(remoteAgent);
										subscriptionWithNickList.add(tempList);
									}
								}
							}
						}
					}
				}
			}
		}
		return subscriptionWithNickList;
	}
	
	private ArrayList getAzureComponentsForUser(ArrayList listOfComponents)
	{
		ArrayList azureCompList = new ArrayList();
		
		if (listOfComponents != null && listOfComponents.size() > 0)
		{
			int compSize = listOfComponents.size();
			for (int a=0; a<compSize; a++)
			{
				String componentTypeWithNick = (String) listOfComponents.get(a);
				String nickWithPort = componentTypeWithNick.substring(componentTypeWithNick.indexOf(":")+1);
				String nickName = nickWithPort.substring(0, nickWithPort.indexOf(":"));
				azureCompList.add(nickName);
			}
		}
		return azureCompList;
	}
%>



