<%
/**
 *	File name		:	LicenseUsageByOrgJson.jsp
 *	Purpose			:	This page provides overall report of organization/organizational unit license details
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "net.sf.json.JSONArray"%>
<%@ page import = "java.util.Calendar"%>
<%@ page import = "java.util.Date"%>
<%@ page import = "java.math.*"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgEndPointsInfo" %>
<%@ page import = "com.eg.EgMsUsersInfo" %>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "java.text.DateFormat"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
	
	JSONObject rootJson = new JSONObject();

	EgCertUsage certUsage = new EgCertUsage();
	EgUserRole usrRole = _user.getUserRole();
	EgUuidInfo uuidInfo = new EgUuidInfo();
	EgUsersInfo usersInfo = new EgUsersInfo();
	EgEndPointsInfo endPointNamesInfo = new EgEndPointsInfo();
	EgMsUsersInfo o365UsersInfoObj = new EgMsUsersInfo();
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	boolean isLimitedAdmin = !egRoleInfo.hasAllComponentAccess();
	boolean hasAllComponentAccess = usrRole.hasAllComponentAccess();
	boolean isMspModel = EgUuidInfo.isMspModel();
	boolean isEndPointNames = EgInstallInfo.isEUCEndPointsLicense;
	String session_userid = (String)session.getAttribute("sess_userid");
	String loginId = _user.getLoginID();
	String isMgrUsedBased = "false";
	String isO365License = "false";
	String isEndPointsLicense = "false";
	GroupCertValidator grpCert = null;

	boolean isCCUserCertEnabled = EgInstallInfo.isconcurrentUserLicense;
	boolean isNamedUserEnabled = EgInstallInfo.isnamedUserLicense;
	boolean isUserCertMgr = usersInfo.isUserBasedLicense();
	boolean isO365UsrLic = EgInstallInfo.isO365UsersLicense;

	String searchStr = request.getParameter("searchStr");
	if (isCCUserCertEnabled || isNamedUserEnabled)
	{
		isMgrUsedBased = "true";
	}
	rootJson.put("isMgrUsedBased",isMgrUsedBased);
	if (isEndPointNames)
	{
		isEndPointsLicense = "true";
	}
	rootJson.put("isEndPointsLicense",isEndPointsLicense);
	if (isO365UsrLic)
	{
		isO365License = "true";
	}
	rootJson.put("isO365License",isO365License);

	//Named or CC users
	HashMap userCertInfo = new HashMap();
	HashMap userCertInfo1 = new HashMap();
	HashMap o365UsersInfo = new HashMap();
	ArrayList aListData = null;
	ArrayList aListData1 = null;
	if(isUserCertMgr)
	{
		userCertInfo = certUsage.getCertUsersDetailsForUsers();
		
		aListData = usersInfo.getRemoteUserCount();
		if (aListData == null || aListData.size() ==0)
		{
			aListData = usersInfo.getRemoteUserCount(true);
		}		
	}
	if(isEndPointNames)
	{
		userCertInfo1 = endPointNamesInfo.getUsersDetailsForType("User");
		aListData1 = endPointNamesInfo.getEndPointNamesCount();
		if (aListData1 == null || aListData1.size() ==0)
		{
			aListData1 = endPointNamesInfo.getEndPointNamesCount(true);
		}
	}

	if(isO365UsrLic)
	{
		o365UsersInfo = o365UsersInfoObj.getUsersDetailsForType("User");
	}

	//for CSV Report Date
	String userDateFormat = _user.getUserDateFormat();
	String userDateTimeFormat = userDateFormat+" HH:mm:ss";
	Date currDate = new Date();
	SimpleDateFormat smdf = new SimpleDateFormat(userDateTimeFormat);
	String currDateStr = smdf.format(currDate); 

	//For CSV
	List csvData = new ArrayList();
	String csvRow = "";
	String repTitle = (isMspModel) ? "License usage report by Organization/Organizational unit" : "License usage report by Organizational unit";
	String repDate = "Report generated on"+",\""+currDateStr+"\"";
	String colHeads =  (isMspModel) ? "Organization/Organizational unit" : "Organizational unit";
	String colSubHd = "";
	colHeads += ",,Total Monitors,,,Basic Monitors,,,Premium Monitors,,,";
	colSubHd += ",Allowed,Used,Available,Allowed,Used,Available,Allowed,Used,Available";
	if (isUserCertMgr)
	{
		if (EgInstallInfo.isnamedUserLicense)
		{
			if (isEndPointNames && isO365UsrLic)
			{
				colHeads += "Named Users,,,,,EndPointNames,,,,,O365 Users,,,,,Network Devices,,,Monitor Users";
				colSubHd += ",Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Available,Allowed,Used,Available";
			}
			else if (isEndPointNames)
			{
				colHeads += "Named Users,,,,,EndPointNames,,,,,Network Devices,,,Monitor Users";
				colSubHd += ",Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Available,Allowed,Used,Available";
			}
			else if(isO365UsrLic)
			{
				colHeads += "Named Users,,,,,O365 Users,,,,,Network Devices,,,Monitor Users";
				colSubHd += ",Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Available,Allowed,Used,Available";
			}
			else 
			{
				colHeads += "Named Users,,,,,Network Devices,,,Monitor Users";
				colSubHd += ",Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Available,Allowed,Used,Available";
			}
		}
		else
		{
			if (isEndPointNames && isO365UsrLic)
			{
				colHeads += "Concurrent Users/Machines,,,,,EndPointNames,,,,,O365 Users,,,,,Network Devices,,,Monitor Users";
				colSubHd += ",Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Available,Allowed,Used,Available";
			}
			else if (isEndPointNames)
			{
				colHeads += "Concurrent Users/Machines,,,,,EndPointNames,,,,,Network Devices,,,Monitor Users";
				colSubHd += ",Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Available,Allowed,Used,Available";
			}
			else if(isO365UsrLic)
			{
				colHeads += "Concurrent Users/Machines,,,,,O365 Users,,,,,Network Devices,,,Monitor Users";
				colSubHd += ",Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Available,Allowed,Used,Available";
			}
			else
			{
				colHeads += "Concurrent Users/Machines,,,,,Network Devices,,,Monitor Users";
				colSubHd += ",Allowed,Used,Last month peak usage,Date of peak usage,Violations in last 14 days,Allowed,Used,Available,Allowed,Used,Available";
			}
		}
	}
	else
	{
		if (isEndPointNames)
		{
			colHeads += "EndPointNames,,,,";
			colSubHd += ",Allowed,Used,Last month peak usage,Date of peak usage";
		}
		if (isO365UsrLic)
		{
			colHeads += "O365 Users,,,,";
			colSubHd += ",Allowed,Used,Last month peak usage,Date of peak usage";
		}
		colHeads += "Network Devices,,,Monitor Users";
		colSubHd += ",Allowed,Used,Available,Allowed,Used,Available";
	}

	csvData.add(repTitle);
	csvData.add(repDate);
	csvData.add("");
	csvData.add(colHeads);
	csvData.add(colSubHd);


	List csvDataList = new ArrayList();
	JSONArray exportDataArr = new JSONArray();
	JSONObject exportDataObj = new JSONObject();
	IniFile uiIni = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_ui.ini");
	String currDateFormat = uiIni.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	if (currDateFormat == null || currDateFormat.trim().length() == 0)
	{
		currDateFormat = "MMM dd, yyyy";
	}

	IniFile userCompMapIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_usercompmapping.ini");
	String[] userNameVars = userCompMapIni.getVariables("Users_Allowed_Count");
	ArrayList availUsersList = new ArrayList(Arrays.asList(userNameVars));

	//Manager License count
	CertValidator cert = new CertValidator();
	int mgrAllowedTotalCnt = cert.getAllowedTotalCount();
	int mgrAllowedBasicCnt = cert.getAllowedBasicCount();
	int mgrAllowedPremuCnt = cert.getAllowedPremiumCount();
	int mgrAllowedNwDevCnt = cert.getAllowedNetworkDevicesCount();
	int mgrAllowedMonUserCount = EgMemInfo.users;
	int mgrAllowedUserCount = 0;
	int mgrEndPointAllowedUserCount = 0;
	int mgrO365UsersAllowedUserCount = 0;
	if(isCCUserCertEnabled)
	{
		mgrAllowedUserCount = (int)EgInstallInfo.allowedConcUsers;
	}
	else
	{
		mgrAllowedUserCount = (int)EgInstallInfo.allowedNamedUsers;
	}

	ArrayList mgrLicDetails = new ArrayList();
	GroupCertValidator grpCertVal = new GroupCertValidator("");
	mgrLicDetails.add(String.valueOf(mgrAllowedTotalCnt));
	mgrLicDetails.add(String.valueOf(mgrAllowedBasicCnt));
	mgrLicDetails.add(String.valueOf(mgrAllowedPremuCnt));
	mgrLicDetails.add(String.valueOf(mgrAllowedNwDevCnt));
	mgrLicDetails.add(String.valueOf(mgrAllowedUserCount));
	mgrLicDetails.add(String.valueOf(mgrAllowedMonUserCount));

	if (isEndPointNames)
	{
		mgrEndPointAllowedUserCount =(int)EgInstallInfo.allowedEndPointUsersCount;
		mgrLicDetails.add(String.valueOf(mgrEndPointAllowedUserCount));
	}

	if (isO365UsrLic)
	{
		mgrO365UsersAllowedUserCount =(int)EgInstallInfo.allowedO365Users;
		mgrLicDetails.add(String.valueOf(mgrO365UsersAllowedUserCount));
	}

	egurkha.UserBean user = new egurkha.UserBean();
	int used_total = user.getBasicMonitorsCount() + user.getPremiumMonitorsCount(); // Total used agents
	//If basic comps exceeds the allowed count then it will consume premium license if exist.
	int used_basic = user.getBasicMonitorsCount();
	int used_Premium = user.getPremiumMonitorsCount();
	if (mgrAllowedBasicCnt != -1)
	{
		int allowedBasic = mgrAllowedBasicCnt;
		if (used_basic > allowedBasic)
		{
			used_Premium += (used_basic-allowedBasic);
			used_basic  = allowedBasic;
		}
	}
	int used_network = user.getNetDeviceCount();
	int used_monUserCount = 0;
	if(user.setConnection().equalsIgnoreCase("CONNECTED"))
	{
		used_monUserCount = user.monUserCount();
	}
	user.releaseConnection(false);

	ArrayList mgrArrListData = null;
	ArrayList mgrArrListDataForEndpoint = null;
	ArrayList mgrArrListDataForO365Users = null;
	String mgr_allowed_userBasedCount = "0",mgr_allowed_O365UserCount = "0", mgr_used_userBasedCount = "0", mgr_avail_userBasedCount = "0",mgr_used_endPointNamesCount ="0",mgr_used_O365Count ="0";
	String mgrPeakUsgCnt = "-", mgrPeakUsgDate = "-",mgrPeakUsgDateInfo = "-";
	String mgrPeakUsgCntForEndPoint = "-", mgrPeakUsgDateForEndPoint = "-",mgrPeakUsgDateForEndPointInfo = "-";
	String mgrPeakUsgCntForO365Users = "-", mgrPeakUsgDateForO365Users = "-";
	IniFile egUI = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String tmpValue = egUI.getValue("User_Cert","ShowUsersCountInUI");
	boolean showUsersCountInUI = (tmpValue != null && (tmpValue.equalsIgnoreCase("yes") || tmpValue.equalsIgnoreCase("true")));
	if (usersInfo.isUserBasedLicense() || showUsersCountInUI)
	{
		mgrArrListData = usersInfo.getRemoteUserCount();
		if (mgrArrListData == null || mgrArrListData.size() ==0)
		{
			mgrArrListData = usersInfo.getRemoteUserCount(true);
		}
	}

	if (isEndPointNames)
	{
		mgrArrListDataForEndpoint = endPointNamesInfo.getEndPointNamesCount();
		if (mgrArrListDataForEndpoint == null || mgrArrListDataForEndpoint.size() ==0)
		{
			mgrArrListDataForEndpoint = endPointNamesInfo.getEndPointNamesCount(true);
		}
	}

	if (isO365UsrLic)
	{
		mgrArrListDataForO365Users = o365UsersInfoObj.getO365UsersCount();
		if (mgrArrListDataForO365Users == null || mgrArrListDataForO365Users.size() ==0)
		{
			mgrArrListDataForO365Users = o365UsersInfoObj.getO365UsersCount(true);
		}
	}

	ArrayList peakUsageData = usersInfo.getPeakUsageValuesForPreviusMonth();
	ArrayList peakUsageDataForEndPoint = endPointNamesInfo.getPeakUsageValuesForPreviusMonth();
	ArrayList peakUsageDataForO365 = o365UsersInfoObj.getPeakUsageValuesForPreviusMonth();
	if (peakUsageData != null && peakUsageData.size() >= 2)
	{
		String peakUsgCnt = peakUsageData.get(0).toString();
		String peakUsgDate = peakUsageData.get(1).toString();
		if (peakUsgCnt != null && peakUsgCnt.trim().length() > 0 && peakUsgDate != null && peakUsgDate.trim().length() > 0)
		{
			int dotIdx = peakUsgCnt.indexOf(".");
			if (dotIdx > -1)
			{
				peakUsgCnt = peakUsgCnt.substring(0,dotIdx);
			}
			mgrPeakUsgDateInfo = peakUsgDate;
			peakUsgDate = com.egurkha.util.DateUtil.changeDateFormat(peakUsgDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
			mgrPeakUsgCnt = peakUsgCnt;
			mgrPeakUsgDate = peakUsgDate;
		}
	}

	if (peakUsageDataForEndPoint != null && peakUsageDataForEndPoint.size() >= 2)
	{
		String peakUsgCnt = peakUsageDataForEndPoint.get(0).toString();
		String peakUsgDate = peakUsageDataForEndPoint.get(1).toString();
		if (peakUsgCnt != null && peakUsgCnt.trim().length() > 0 && peakUsgDate != null && peakUsgDate.trim().length() > 0)
		{
			int dotIdx = peakUsgCnt.indexOf(".");
			if (dotIdx > -1)
			{
				peakUsgCnt = peakUsgCnt.substring(0,dotIdx);
			}
			mgrPeakUsgDateForEndPointInfo = peakUsgDate;
			peakUsgDate = com.egurkha.util.DateUtil.changeDateFormat(peakUsgDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
			mgrPeakUsgCntForEndPoint = peakUsgCnt;
			mgrPeakUsgDateForEndPoint = peakUsgDate;
		}
	}

	if (peakUsageDataForO365 != null && peakUsageDataForO365.size() >= 2)
	{
		String peakUsgCnt = peakUsageDataForO365.get(0).toString();
		String peakUsgDate = peakUsageDataForO365.get(1).toString();
		if (peakUsgCnt != null && peakUsgCnt.trim().length() > 0 && peakUsgDate != null && peakUsgDate.trim().length() > 0)
		{
			int dotIdx = peakUsgCnt.indexOf(".");
			if (dotIdx > -1)
			{
				peakUsgCnt = peakUsgCnt.substring(0,dotIdx);
			}
			peakUsgDate = com.egurkha.util.DateUtil.changeDateFormat(peakUsgDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
			mgrPeakUsgCntForO365Users = peakUsgCnt;
			mgrPeakUsgDateForO365Users = peakUsgDate;
		}
	}

	if(mgrArrListData!=null && mgrArrListData.size()>0)
	{
		String count = (String)mgrArrListData.get(0);
		String AllowedCount = (String)mgrArrListData.get(1);
		double count_user = 0;
		double count_AllowedCount = 0;

		String count_user_str = "-";
		String count_AllowedCount_str = "-";
		String avail_str = "-";
		count_user = Double.parseDouble(count);
		count_user_str = Math.round(count_user)+"";
		if (!AllowedCount.equals("-"))
		{
			count_AllowedCount = Double.parseDouble(AllowedCount);
			count_AllowedCount_str = Math.round(count_AllowedCount)+"";
		}
		double avail = 0.0;
		if (!AllowedCount.equals("-"))
		{
			try{
				avail = Double.parseDouble(AllowedCount) - Double.parseDouble(count);
			}catch(Exception e){e.printStackTrace();}
			if (avail < 0.0)
			avail = 0.0;
			avail_str = Math.round(avail)+"";
		}
		mgr_allowed_userBasedCount = count_AllowedCount_str;
		mgr_used_userBasedCount = String.valueOf(count_user_str);
		mgr_avail_userBasedCount = String.valueOf(avail_str);
	}
	else if (usersInfo.isUserBasedLicense())
	{
		long getUserAllowedCount = usersInfo.getUserAllowedCount();
		mgr_allowed_userBasedCount = String.valueOf(getUserAllowedCount);
		mgr_used_userBasedCount = "0";
		mgr_avail_userBasedCount = String.valueOf(getUserAllowedCount);
	}

	if(mgrArrListDataForEndpoint!=null && mgrArrListDataForEndpoint.size()>0)
	{
		String endPointNamescount = (String)mgrArrListDataForEndpoint.get(0);
		String AllowedCount = (String)mgrArrListDataForEndpoint.get(1);
		double count_user = 0;
		double count_AllowedCount = 0;

		String count_user_str = "-";
		String count_AllowedCount_str = "-";
		String avail_str = "-";
		count_user = Double.parseDouble(endPointNamescount);
		count_user_str = Math.round(count_user)+"";
		mgr_allowed_userBasedCount = count_AllowedCount_str;
		mgr_used_endPointNamesCount = String.valueOf(count_user_str);
		mgr_avail_userBasedCount = String.valueOf(avail_str);
	}

	if(mgrArrListDataForO365Users!=null && mgrArrListDataForO365Users.size()>0)
	{
		String o365Userscount = (String)mgrArrListDataForO365Users.get(0);
		String o365UsersAllowedCount = (String)mgrArrListDataForO365Users.get(1);
		double count_user = 0;
		double count_AllowedCount = 0;

		String count_user_str = "-";
		String count_AllowedCount_str = "-";
		count_user = Double.parseDouble(o365Userscount);
		count_user_str = Math.round(count_user)+"";
		count_AllowedCount_str = o365UsersAllowedCount;
		mgr_allowed_O365UserCount = count_AllowedCount_str;
		mgr_used_O365Count = String.valueOf(count_user_str);
	}

	//To show organization/organizational unit tree grid
	
	//If logged in as full admin access user, then following block will be executed.
	if (hasAllComponentAccess)
	{
		//If it is 'saas' model, then the following block will be executed.
		if(isMspModel)
		{
			exportDataArr = new JSONArray();
			IniFile inifile1 = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_uuid.ini");
			String topLevelOrgs[] = inifile1.getVariables("ORG_UUID");
			ArrayList superOrgs = new ArrayList();
			if(topLevelOrgs != null && topLevelOrgs.length>0)
			{
				superOrgs.addAll(Arrays.asList(topLevelOrgs));
			}
			java.util.Date today = new java.util.Date();
			for(int i=0;i<superOrgs.size();i++)
			{
				exportDataObj = new JSONObject();
				String optVar = "";
				String optVal = "";

				String orgname = (String)superOrgs.get(i);
				String uvalidtill = uuidInfo.getExpiryDateOfUser(orgname);
				if (uvalidtill != null)
				{
					if (uvalidtill.trim().length() == 0)
					{
						continue;
					}
					if (uvalidtill.indexOf("9999-12-12 23:59:59") == -1)
					{
						uvalidtill = uvalidtill.substring(0,10);
						uvalidtill = com.egurkha.util.DateUtil.changeDateFormat(uvalidtill,"yyyy-MM-dd","MM/dd/yyyy");
					}
					else
					{
						uvalidtill = "12/12/9999";
					}

					SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
					java.util.Date uvalidtilldate = new java.util.Date();
					
					try
					{
						uvalidtilldate = formatter.parse(uvalidtill+" 23:59:59");
					}
					catch(Exception e){}
					if (!uvalidtill.equalsIgnoreCase("12/12/9999") && uvalidtilldate.compareTo(today) < 0)
					{
						continue;
					}
				}
				optVar = (String)superOrgs.get(i);
				optVal = (String)superOrgs.get(i);

				String displayName = optVal;
				if (optVal.startsWith("samlsso/"))
				{
					int idx = optVal.indexOf("/");
					displayName = optVal.substring(idx+1) + " (SAML)";
				}
				else if (optVal.indexOf("/") != -1)
				{
					if (optVal.indexOf("/Grp/") != -1)
					{
						String grpDelimiter = "/Grp/";
						int idx = optVal.indexOf(grpDelimiter);
						String str_uname_A = optVal.substring(0,idx);
						int nextIdx = idx + grpDelimiter.length();
						String str_uname_B = optVal.substring(nextIdx);
						displayName = str_uname_A + "/" + str_uname_B + " (Group)";
					}
				}
				//for super org datas (Organization)
				if (optVar.equalsIgnoreCase("egenterprise"))
				{
					exportDataObj.put("UserID",_mapping.getTextDescription("admin.user.egenterprise"));
				}
				else
				{
					exportDataObj.put("UserID",displayName);
				}
				exportDataObj.put("id",optVar);
				exportDataObj.put("iconCls","iconDomain");
				exportDataObj.put("expanded",true);

				//Getting allowed license count values of organization/organizational unit.
				String totMonOrg = String.valueOf(mgrAllowedTotalCnt);
				String basicMonOrg = String.valueOf(mgrAllowedBasicCnt);
				String premiumMonOrg = String.valueOf(mgrAllowedPremuCnt);
				String networkDevOrg = String.valueOf(mgrAllowedNwDevCnt);
				String userBasedOrg = String.valueOf(mgrAllowedUserCount);
				String userCntOrg = String.valueOf(mgrAllowedMonUserCount);
				String userBased_OrgCunt1 = String.valueOf(mgrEndPointAllowedUserCount);
				String userBased_OrgCunt2 = String.valueOf(mgrO365UsersAllowedUserCount);
				ArrayList userAllowedLimits = getValidLicenseCount(availUsersList,userCompMapIni,uuidInfo,orgname);
				if (userAllowedLimits != null && userAllowedLimits.size() > 0)
				{
					totMonOrg = userAllowedLimits.get(0).toString();
					basicMonOrg = userAllowedLimits.get(1).toString();
					networkDevOrg = userAllowedLimits.get(2).toString();
					if (isMgrUsedBased.equalsIgnoreCase("true") || userAllowedLimits.size()==5)
					{
						userBasedOrg = userAllowedLimits.get(3).toString();
						userCntOrg = userAllowedLimits.get(4).toString();
					}
					else
					{
						userBasedOrg = "0";
						userCntOrg = userAllowedLimits.get(3).toString();
					}

					if (isEndPointNames && userAllowedLimits.size()>=6)
					{
						userBased_OrgCunt1 = userAllowedLimits.get(5).toString();
					}
					else 
					{
						userBased_OrgCunt1 = "-";
					}
					if (isO365UsrLic && userAllowedLimits.size()>=7)
					{
						userBased_OrgCunt2 = userAllowedLimits.get(6).toString();
					}
					else 
					{
						userBased_OrgCunt2 = "-";
					}

					int allowedTotalCnt = Integer.parseInt(totMonOrg);
					int allowedBasicCnt = Integer.parseInt(basicMonOrg);
					int allowedPremuCnt = (allowedTotalCnt > -1 && allowedBasicCnt > -1) ? allowedTotalCnt - allowedBasicCnt : -1;
					premiumMonOrg = String.valueOf(allowedPremuCnt);
				}

				//Getting used and available license count values of organizational unit/organization.
				certUsage.setUserName(orgname);
				HashMap detailsMap = new HashMap();
				csvRow = orgname;

				//Total monitors
				int totCnt = Integer.parseInt(totMonOrg);
				int usedCnt = 0;
				String used = "0";
				if (orgname.equalsIgnoreCase("egenterprise"))
				{
					usedCnt = used_total;
					used = String.valueOf(usedCnt);
				}
				else
				{
					detailsMap = certUsage.getTotalMonitorsDetailsForUser();
					used = (String)detailsMap.get("Used");
					usedCnt = Integer.parseInt(used);
				}
				int available = totCnt-usedCnt;
				if(available < 0) available=0;
				String availCnt = totMonOrg.equals("-1") ? "-" :String.valueOf(available);
				totMonOrg = totMonOrg.equals("-1") ? "-" : totMonOrg;
				exportDataObj.put("totMons_TotalCnt",totMonOrg);
				exportDataObj.put("totMons_UsedCnt",used+"@#@"+orgname+"@#@Total Monitors");
				exportDataObj.put("totMons_AvailCnt",availCnt);
				csvRow += ","+totMonOrg+","+used+","+availCnt;

				//Premium monitors and Basic monitors
				int usedPremium = 0, usedBasic = 0;
				String usedPrem = "0", usedBas = "0";
				if (orgname.equalsIgnoreCase("egenterprise"))
				{
					usedPremium = used_Premium;
					usedPrem = String.valueOf(usedPremium);
					usedBasic = used_basic;
					usedBas = String.valueOf(usedBasic);
				}
				else
				{
					detailsMap = certUsage.getPremiumMonitorsDetailsForUser();
					usedPrem = (String)detailsMap.get("Used");
					usedPremium = Integer.parseInt(usedPrem);
					detailsMap = certUsage.getBasicMonitorsDetailsForUser();
					usedBas = (String)detailsMap.get("Used");
					usedBasic = Integer.parseInt(usedBas);
				}
				//If basic comps exceeds the allowed count then it will consume premium license if exist.
				if (!basicMonOrg.equals("-1"))
				{
					int allowedBas = Integer.parseInt(basicMonOrg);
					if (usedBasic > allowedBas)
					{
						usedPremium += (usedBasic-allowedBas);
						usedBasic  = allowedBas;
						usedPrem = String.valueOf(usedPremium);
						usedBas = String.valueOf(usedBasic);
					}
				}
				int basCnt = Integer.parseInt(basicMonOrg);
				int basicAvail = basCnt-usedBasic;
				if (basicAvail < 0)
				{
					basicAvail = 0;
				}
				availCnt = basicMonOrg.equals("-1") ? "-" : String.valueOf(basicAvail);
				basicMonOrg = basicMonOrg.equals("-1") ? "-" : basicMonOrg;
				exportDataObj.put("basMons_TotalCnt",basicMonOrg);
				exportDataObj.put("basMons_UsedCnt",usedBas+"@#@"+orgname+"@#@Basic Monitors");
				exportDataObj.put("basMons_AvailCnt",availCnt);
				csvRow += ","+basicMonOrg+","+usedBas+","+availCnt;

				int premCnt = totCnt - basCnt;
				int PremAvailable = premCnt-usedPremium;
				if(PremAvailable < 0) PremAvailable=0;
				availCnt = premiumMonOrg.equals("-1") ? "-" :String.valueOf(PremAvailable);
				premiumMonOrg = premiumMonOrg.equals("-1") ? "-" : premiumMonOrg;
				if(totCnt > -1 && basCnt == -1) //special case : when total monitor is given an Limited count, but basic monitor have -1 in licnese .
				{
					premiumMonOrg = "-";
					availCnt = "-";
				}
				exportDataObj.put("premMons_TotalCnt",premiumMonOrg);
				exportDataObj.put("premMons_UsedCnt",usedPrem+"@#@"+orgname+"@#@Premium Monitors");
				exportDataObj.put("premMons_AvailCnt",availCnt);
				csvRow += ","+premiumMonOrg+","+usedPrem+","+availCnt;

				//User based (named or concurrent)
				if (isUserCertMgr)
				{
					used = "0";
					String peakCnt = "-", peakDate = "-";
					String peakDateVal ="";
					String peakDateInfo = "-";
					int userBasedVilotionCnt = 0;
					boolean checkUserBasedViolation = false;
					String licUserGraph = "-";
					if (orgname.equalsIgnoreCase("egenterprise"))
					{
						int windowSize = usersInfo.getWindowValue();
						userBasedVilotionCnt  = usersInfo.getNumberOfViolationForLast(windowSize);
						checkUserBasedViolation = usersInfo.isUserViolationOccured();

						int idx = mgr_used_userBasedCount.indexOf(".");
						if(idx > -1)
						{
							mgr_used_userBasedCount = mgr_used_userBasedCount.substring(0,idx);
						}
						used = mgr_used_userBasedCount;
						userBasedOrg =  mgr_allowed_userBasedCount;
						peakCnt = mgrPeakUsgCnt;
						peakDate = mgrPeakUsgDate;
						String temp = mgrPeakUsgDateInfo+"^"+mgrPeakUsgDate;
						
						if(isNamedUserEnabled)
						{
							if(used.equals("-") || used.equals("0"))
							{
								licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph1()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";	
							}
							else
							{
								String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
								String certParams = "NULL:" + "NamedUsers";
								certParams += "|"+orgname+"@#@Organization@#@"+currentUsageDate;
								String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
								licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph1()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
							}
							peakDateInfo = peakDate;
						}
						else if(isCCUserCertEnabled)
						{							
							if(used.equals("-") || used.equals("0"))
							{
								licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph2()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";	
							}
							else
							{
								String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
								String certParams = "NULL:" + "ConcurrentUser";
								certParams += "|"+orgname+"@#@Organization@#@"+currentUsageDate;
								String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
								licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph2()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
							}
							peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraph(\""+temp+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
						}
					}
					else
					{
						//	used = (aListData != null && aListData.size() > 0) ? (String)aListData.get(0) : "0";
						//	used = (used.startsWith("0.")) ? used.substring(0,used.indexOf(".")) : "0";
						//	usedCnt = Integer.parseInt(used);
						//int usrBsdCnt = Integer.parseInt(userBasedOrg);
						userBasedOrg = userBasedOrg.equals("-1") ? "-" : userBasedOrg;

						//peakusage
						HashMap userMap = (userCertInfo != null) ? (HashMap)userCertInfo.get(orgname) : new HashMap();
						if (userMap != null)
						{
							Iterator it = userMap.keySet().iterator();
							while (it.hasNext())
							{
								String type = (String)it.next();
								String cnt = (String)userMap.get(type);
								if (type.equalsIgnoreCase("peakCount"))
								{
									peakCnt = cnt;
								}
								else if (type.equalsIgnoreCase("peakDate"))
								{
									peakDate = cnt;
								}
								else if(type.equalsIgnoreCase("Total"))
								{
									used = cnt;
								}
								int dotCnt = used.indexOf(".");
								if (dotCnt > -1)
								{
									used = used.substring(0,dotCnt);
								}
								int dotIdx = peakCnt.indexOf(".");
								if (dotIdx > -1)
								{
									peakCnt = peakCnt.substring(0,dotIdx);
								}
								if (peakDate!=null && !peakDate.trim().equals("-"))
								{
									int peakDatedotIdx = peakDate.lastIndexOf(".");
									if (peakDatedotIdx > -1)
									{
										peakDate = peakDate.substring(0,peakDatedotIdx);
									}
									peakDate = getCorrectDateForLicInfo(peakDate);
									peakDateVal = peakDate+"^";
									peakDate = com.egurkha.util.DateUtil.changeDateFormat(peakDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
									peakDateVal += peakDate;
									if(isCCUserCertEnabled)
									{
										peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraphForGroup(\""+peakDateVal+"\",\"User\",\""+orgname+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
									}
									else
									{
										peakDateInfo = peakDate;
									}
								}	
							}
						}						
						ArrayList userBasedviolationDetails = usersInfo.getUserBasedviolationCount(orgname);
						if (userBasedviolationDetails != null && userBasedviolationDetails.size() > 0)
						{
							userBasedVilotionCnt = (Integer)userBasedviolationDetails.get(0);
							checkUserBasedViolation = (Boolean)userBasedviolationDetails.get(1);
						}
					}
					exportDataObj.put("userBased_TotalCnt",userBasedOrg);
					if(used.equals("-") || used.equals("0"))
					{
						licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfo(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
					else
					{
						String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
						String certParams = "NULL:" + (isNamedUserEnabled ? "NamedUsers" : isCCUserCertEnabled ? "ConcurrentUser" : "NotApplicable");
						certParams += "|"+orgname+"@#@Organization@#@"+currentUsageDate;
						String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
						licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfo(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
					exportDataObj.put("userBased_UsedCnt",licUserGraph);
					if(peakCnt.equals("-") || peakCnt.equals("0"))
					{
						exportDataObj.put("userBased_PeakCnt",peakCnt);
					}
					else
					{
						String certFlag = "NULL:"+(isNamedUserEnabled ? "NamedUsers" : isCCUserCertEnabled ? "ConcurrentUser" : "NotApplicable");
						exportDataObj.put("userBased_PeakCnt",peakCnt+"~"+certFlag+"|"+orgname+"@#@Organization@#@"+peakDate);
					}
					exportDataObj.put("userBased_PeakDate",peakDateInfo);
					if (checkUserBasedViolation)
					{
						exportDataObj.put("userBased_license_violation","<span style='color:red;font-weight:bold'>"+userBasedVilotionCnt+"</span>");
					}
					else
					{
						exportDataObj.put("userBased_license_violation",userBasedVilotionCnt);
					}
					csvRow += ","+userBasedOrg+","+used+","+peakCnt+",\""+peakDate+"\""+","+userBasedVilotionCnt;
				}

				if (isEndPointNames)
				{
					long endPointNamesAllowedCount = EgInstallInfo.allowedEndPointUsersCount;
					String mgr_allowed_endPointNames = String.valueOf(endPointNamesAllowedCount);
					String licUserGraph = "0";
					String peakDateInfo = "-";

					used = "0";
					int userVilotionCnt = 0;
					boolean checkUserViolation = false;
					String peakCnt = "-", peakDate = "-";
					if (orgname.equalsIgnoreCase("egenterprise"))
					{
						int windowSize = endPointNamesInfo.getWindowValue();
						userVilotionCnt  = endPointNamesInfo.getNumberOfViolationForLast(windowSize);
						checkUserViolation = endPointNamesInfo.isEUCUsersViolationOccured();

						int idx = mgr_used_userBasedCount.indexOf(".");
						if(idx > -1)
						{
							mgr_used_userBasedCount = mgr_used_userBasedCount.substring(0,idx);
						}
						used = mgr_used_endPointNamesCount;
						userBased_OrgCunt1 =  mgr_allowed_endPointNames;
						peakCnt = mgrPeakUsgCntForEndPoint;
						peakDate = mgrPeakUsgDateForEndPoint;
						
						String temp = mgrPeakUsgDateForEndPointInfo+"^"+peakDate;
						peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraphforEndpoint(\""+temp+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
						if(used.equals("-") || used.equals("0"))
						{
							licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph3()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
						}
						else
						{
							String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
							String certParams = "endpointname:EndpointNames|"+orgname+"@#@Organization@#@"+currentUsageDate;
							String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
							licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph3()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
						}
					}
					else
					{
						userBased_OrgCunt1 = userBased_OrgCunt1.equals("-1") ? "-" : userBased_OrgCunt1;
						//peakusage
						HashMap userMap = (userCertInfo1 != null) ? (HashMap)userCertInfo1.get(orgname) : new HashMap();
						if (userMap != null)
						{
							Iterator it = userMap.keySet().iterator();
							while (it.hasNext())
							{
								String type = (String)it.next();
								String cnt = (String)userMap.get(type);
								if (type.equalsIgnoreCase("peakCount"))
								{
									peakCnt = cnt;
								}
								else if (type.equalsIgnoreCase("peakDate"))
								{
									peakDate = cnt;
								}
								else if(type.equalsIgnoreCase("Total"))
								{
									used = cnt;
								}
								int dotCnt = used.indexOf(".");
								if (dotCnt > -1)
								{
									used = used.substring(0,dotCnt);
								}
								int dotIdx = peakCnt.indexOf(".");
								if (dotIdx > -1)
								{
									peakCnt = peakCnt.substring(0,dotIdx);
								}
								if (peakDate!=null && !peakDate.trim().equals("-"))
								{	
									String peakDateVal = peakDate+"^";
									peakDate = com.egurkha.util.DateUtil.changeDateFormat(peakDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
									peakDateVal += peakDate;
									peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraphForendPointsGroup(\""+peakDateVal+"\",\"User\",\""+orgname+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
								}
							}
						}
						//License violation
						ArrayList userviolationDetails = endPointNamesInfo.getUserviolationCount(orgname);
						if (userviolationDetails != null && userviolationDetails.size() > 0)
						{
							userVilotionCnt = (Integer)userviolationDetails.get(0);
							checkUserViolation = (Boolean)userviolationDetails.get(1);
						}	
						if(used.equals("-") || used.equals("0"))
						{
							licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfoForEndpoint(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
						}
						else
						{
							String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
							String certParams = "endpointname:EndpointNames|"+orgname+"@#@Organization@#@"+currentUsageDate;
							String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
							licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfoForEndpoint(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
						}
					}
					if(userBased_OrgCunt1.equals("-") || userBased_OrgCunt1.equals("0"))
					{
						exportDataObj.put("userBased_TotalCnt1",userBased_OrgCunt1);
					}
					else
					{
						exportDataObj.put("userBased_TotalCnt1",userBased_OrgCunt1);
					}
					exportDataObj.put("userBased_UsedCnt1",licUserGraph);

					if(peakCnt.equals("-") || peakCnt.equals("0"))
					{
						exportDataObj.put("userBased_PeakCnt1",peakCnt);
					}
					else
					{
						String certFlag = "endpointname:EndpointNames";
						exportDataObj.put("userBased_PeakCnt1",peakCnt+"~"+certFlag+"|"+orgname+"@#@Organization@#@"+peakDate);
					}
					exportDataObj.put("userBased_PeakDate1",peakDateInfo);

					if (checkUserViolation)
					{
						exportDataObj.put("endPoint_license_violation","<span style='color:red;font-weight:bold'>"+userVilotionCnt+"</span>");
					}
					else
					{
						exportDataObj.put("endPoint_license_violation",userVilotionCnt);
					}
					csvRow += ","+userBased_OrgCunt1+","+used+","+peakCnt+",\""+peakDate+"\""+","+userVilotionCnt;
				}
				
				if (isO365UsrLic)
				{
					used = "0";
					String peakCnt = "-", peakDate = "-";
					int o365userVilotionCnt = 0;
					String licUserGraph = "0";
					boolean checko365UserViolation = false;
					if (orgname.equalsIgnoreCase("egenterprise"))
					{
						long o365userAllowedCount = EgInstallInfo.allowedO365Users;
						userBased_OrgCunt2 = String.valueOf(o365userAllowedCount);
						int windowSize = o365UsersInfoObj.getWindowValue();
						o365userVilotionCnt  = o365UsersInfoObj.getNumberOfViolationForLast(windowSize);
						checko365UserViolation = o365UsersInfoObj.isMsUserViolationOccured();

						int idx = mgr_used_userBasedCount.indexOf(".");
						if(idx > -1)
						{
							mgr_used_userBasedCount = mgr_used_userBasedCount.substring(0,idx);
						}
						used = mgr_used_O365Count;
						peakCnt = mgrPeakUsgCntForO365Users;
						peakDate = mgrPeakUsgDateForO365Users;
						
						if(used.equals("-") || used.equals("0"))
						{
							licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph4()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
						}
						else
						{
							String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
							String certParams = "msusername:MSUser|"+orgname+"@#@Organization@#@"+currentUsageDate;
							String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
							licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph4()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
						}
					}
					else
					{
						userBased_OrgCunt2 = userBased_OrgCunt2.equals("-1") ? "-" : userBased_OrgCunt2;
						//peakusage
						HashMap userMap = (o365UsersInfo != null) ? (HashMap)o365UsersInfo.get(orgname) : new HashMap();
						if (userMap != null)
						{
							Iterator it = userMap.keySet().iterator();
							while (it.hasNext())
							{
								String type = (String)it.next();
								String cnt = (String)userMap.get(type);
								if (type.equalsIgnoreCase("peakCount"))
								{
									peakCnt = cnt;
								}
								else if (type.equalsIgnoreCase("peakDate"))
								{
									peakDate = cnt;
								}
								else if(type.equalsIgnoreCase("Total"))
								{
									used = cnt;
								}
								int dotCnt = used.indexOf(".");
								if (dotCnt > -1)
								{
									used = used.substring(0,dotCnt);
								}
								int dotIdx = peakCnt.indexOf(".");
								if (dotIdx > -1)
								{
									peakCnt = peakCnt.substring(0,dotIdx);
								}
								if (peakDate!=null && !peakDate.trim().equals("-"))
								{
									peakDate = com.egurkha.util.DateUtil.changeDateFormat(peakDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
								}
							}
						}
						//License violation
						ArrayList o365userviolationDetails = o365UsersInfoObj.getO365UserviolationCount(orgname);
						if (o365userviolationDetails != null && o365userviolationDetails.size() > 0)
						{
							o365userVilotionCnt = (Integer)o365userviolationDetails.get(0);
							checko365UserViolation = (Boolean)o365userviolationDetails.get(1);
						}
						
						if(used.equals("-") || used.equals("0"))
						{
							licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfoForMsUsers(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
						}
						else
						{
							String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
							String certParams = "msusername:MSUser|"+orgname+"@#@Organization@#@"+currentUsageDate;
							String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
							licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfoForMsUsers(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
						}
					}
					exportDataObj.put("userBased_TotalCnt2",userBased_OrgCunt2);
					exportDataObj.put("userBased_UsedCnt2",licUserGraph);
					
					if(peakCnt.equals("-") || peakCnt.equals("0"))
					{
						exportDataObj.put("userBased_PeakCnt2",peakCnt);
					}
					else
					{
						String certFlag = "msusername:MSUser";
						exportDataObj.put("userBased_PeakCnt2",peakCnt+"~"+certFlag+"|"+orgname+"@#@Organization@#@"+peakDate);
					}
					exportDataObj.put("userBased_PeakDate2",peakDate);
					if (checko365UserViolation)
					{
						exportDataObj.put("o365_license_violation","<span style='color:red;font-weight:bold'>"+o365userVilotionCnt+"</span>");
					}
					else
					{
						exportDataObj.put("o365_license_violation",o365userVilotionCnt);
					}
					csvRow += ","+userBased_OrgCunt2+","+used+","+peakCnt+",\""+peakDate+"\""+","+o365userVilotionCnt;
				}
				
				//Network devices
				if (orgname.equalsIgnoreCase("egenterprise"))
				{
					usedCnt = used_network;
					used = String.valueOf(usedCnt);
				}
				else
				{
					detailsMap = certUsage.getNetworkDevicesDetailsForUser();
					used = (String)detailsMap.get("Used");
					usedCnt = Integer.parseInt(used);
				}
				int nwDevCnt = Integer.parseInt(networkDevOrg);
				int nwtAvail = nwDevCnt-usedCnt;
				if(nwtAvail < 0) nwtAvail=0;
				availCnt = networkDevOrg.equals("-1") ? "-" :String.valueOf(nwtAvail);
				networkDevOrg = networkDevOrg.equals("-1") ? "-" : networkDevOrg;
				exportDataObj.put("nwDev_TotalCnt",networkDevOrg);
				exportDataObj.put("nwDev_UsedCnt",used+"@#@"+orgname+"@#@Network device");
				exportDataObj.put("nwDev_AvailCnt",availCnt);
				csvRow += ","+networkDevOrg+","+used+","+availCnt;

				//Monitor users
				if (orgname.equalsIgnoreCase("egenterprise"))
				{
					usedCnt = used_monUserCount;
					used = String.valueOf(usedCnt);
				}
				else 
				{
					used = "0";
					ArrayList usersUnderOU = uuidInfo.getAllSubOrgsAndUsers(orgname);
					if (usersUnderOU != null && usersUnderOU.size() > 0)
					{
						usersUnderOU.remove(orgname);
						used = String.valueOf(usersUnderOU.size());
					}
				}
				usedCnt = Integer.parseInt(used);
				int monUsrCnt = Integer.parseInt(userCntOrg);
				int monAvail = monUsrCnt-usedCnt;
				if(monAvail < 0) monAvail =0;
				availCnt = userCntOrg.equals("-1") ? "-" :String.valueOf(monAvail);
				userCntOrg = userCntOrg.equals("-1") ? "-" : userCntOrg;
				exportDataObj.put("userCnt_TotalCnt",userCntOrg);
				exportDataObj.put("userCnt_UsedCnt",used+"@#@"+orgname+"@#@Monitor users");
				exportDataObj.put("userCnt_AvailCnt",availCnt);
				csvRow += ","+userCntOrg+","+used+","+availCnt;
				csvData.add(csvRow);

				//for sub org datas (Organizational unit)
				JSONArray rootUserObjectArray = new JSONArray();
				if (isUserCertMgr && isEndPointNames && isO365UsrLic)
				{
					rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,userCertInfo1,o365UsersInfo,mgrLicDetails);
				}
				else if (isUserCertMgr && isEndPointNames )
				{
					rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,userCertInfo1,mgrLicDetails);
				}
				else if (isUserCertMgr && isO365UsrLic)
				{
					rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,o365UsersInfo,mgrLicDetails);
				}
				else
				{
					if (isUserCertMgr)
					{
						rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,mgrLicDetails);
					}
					else if(isEndPointNames) 
					{
						rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,userCertInfo1,mgrLicDetails);
					}
					else if(isO365UsrLic) 
					{
						rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,o365UsersInfo,mgrLicDetails);
					}
					else
					{
						rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,mgrLicDetails);
					}
					
				}

				if (!rootUserObjectArray.isEmpty())
				{
					exportDataObj.put("children",rootUserObjectArray);

					csvDataList = uuidInfo.getCsvDataForLicenseUsage();
					if (csvDataList != null)
					{
						for(int j=0; j<csvDataList.size(); j++)
						{
							List t1 = (List)csvDataList.get(j);
							String tempStr = t1.toString();
							tempStr = tempStr.substring(1,tempStr.length()-1);
							String[] strTkns = StringUtils.getTokens(tempStr,"#");
							for (int k=0; k<strTkns.length; k++)
							{
								String tStr = strTkns[k];
								if(searchStr != null && tStr.indexOf(searchStr) == -1)
								{
									continue;
								}
								if (tStr.startsWith(","))
								{
									tStr = tStr.substring(1);
									tStr = tStr.trim();
								}
								csvData.add(tStr);
							}
						}
						uuidInfo.clearCsvDataForLicenseUsage();
					}
				}

				exportDataArr.add(exportDataObj);
			}
			rootJson.put("exportDataArr",exportDataArr);
		}
		else //If it is 'enterprise' model, then the following block will be executed.
		{
			exportDataArr = new JSONArray();
			exportDataObj = new JSONObject();
			String orgname = "egenterprise";

			//for super org datas (Organization)
			if (orgname.equalsIgnoreCase("egenterprise"))
			{
				exportDataObj.put("UserID",_mapping.getTextDescription("admin.user.egenterprise"));
			}
			else
			{
				exportDataObj.put("UserID",orgname);
			}
			exportDataObj.put("id",orgname);
			exportDataObj.put("iconCls","iconDomain");
			exportDataObj.put("expanded",true);

			//Getting license count values of user/organizational unit.
			String totMonOrg = String.valueOf(mgrAllowedTotalCnt);
			String basicMonOrg = String.valueOf(mgrAllowedBasicCnt);
			String premiumMonOrg = String.valueOf(mgrAllowedPremuCnt);
			String networkDevOrg = String.valueOf(mgrAllowedNwDevCnt);
			String userBasedOrg = String.valueOf(mgrAllowedUserCount);
			String userCntOrg = String.valueOf(mgrAllowedMonUserCount);

			//Getting used and available license count values of organizational unit/organization.
			csvRow = orgname;

			//Total monitors
			int totCnt = Integer.parseInt(totMonOrg);
			int usedCnt = used_total;
			String used = String.valueOf(usedCnt);
			int available = totCnt-usedCnt ; 
			if(available < 0 ) available=0;
			String availCnt = totMonOrg.equals("-1") ? "-" :String.valueOf(available);
			totMonOrg = totMonOrg.equals("-1") ? "-" : totMonOrg;
			exportDataObj.put("totMons_TotalCnt",totMonOrg);
			exportDataObj.put("totMons_UsedCnt",used+"@#@"+orgname+"@#@Total Monitors");
			exportDataObj.put("totMons_AvailCnt",availCnt);
			csvRow += ","+totMonOrg+","+used+","+availCnt;

			//Basic monitors
			usedCnt = used_basic;
			used = String.valueOf(usedCnt); 
			int basCnt = Integer.parseInt(basicMonOrg);
			int basicAvail = basCnt-usedCnt;
			if (basicAvail < 0)
			{
				basicAvail = 0;
			}
			availCnt = basicMonOrg.equals("-1") ? "-" : String.valueOf(basicAvail);
			basicMonOrg = basicMonOrg.equals("-1") ? "-" : basicMonOrg;
			exportDataObj.put("basMons_TotalCnt",basicMonOrg);
			exportDataObj.put("basMons_UsedCnt",used+"@#@"+orgname+"@#@Basic Monitors");
			exportDataObj.put("basMons_AvailCnt",availCnt);
			csvRow += ","+basicMonOrg+","+used+","+availCnt;

			//Premium monitors
			usedCnt = used_Premium;
			used = String.valueOf(usedCnt); 
			int premCnt = totCnt - basCnt;
			int PremAvail = premCnt-usedCnt;
			if(PremAvail < 0) PremAvail=0;
			availCnt = premiumMonOrg.equals("-1") ? "-" : String.valueOf(PremAvail);
			premiumMonOrg = premiumMonOrg.equals("-1") ? "-" : premiumMonOrg;
			if(totCnt > -1 && basCnt == -1) //special case : when total monitor is given an Limited count, but basic monitor have -1 in licnese .
			{
				premiumMonOrg = "-";
				availCnt = "-";
			}
			exportDataObj.put("premMons_TotalCnt",premiumMonOrg);
			exportDataObj.put("premMons_UsedCnt",used+"@#@"+orgname+"@#@Premium Monitors");
			exportDataObj.put("premMons_AvailCnt",availCnt);
			csvRow += ","+premiumMonOrg+","+used+","+availCnt;

			//User based (named or concurrent)
			if (isUserCertMgr)
			{
				String licUserGraph = "-";
				int windowSize = usersInfo.getWindowValue();
				int userBasedVilotionCnt = 0;
				used = "0";
				boolean checkUserBasedViolation = false;

				userBasedVilotionCnt = usersInfo.getNumberOfViolationForLast(windowSize);
				checkUserBasedViolation = usersInfo.isUserViolationOccured();

				int idx = mgr_used_userBasedCount.indexOf(".");
				if(idx > -1)
				{
					mgr_used_userBasedCount = mgr_used_userBasedCount.substring(0,idx);
				}
				used = mgr_used_userBasedCount;
				userBasedOrg = mgr_allowed_userBasedCount;
				String peakCnt = mgrPeakUsgCnt;
				String peakDate = mgrPeakUsgDate;
				
				String temp = mgrPeakUsgDateInfo+"^"+mgrPeakUsgDate;
				String peakDateInfo ="-";
				if(isCCUserCertEnabled)
				{
					peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraph(\""+temp+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
				}
				else
				{
					peakDateInfo = peakDate;
				}
				
				exportDataObj.put("userBased_TotalCnt",userBasedOrg);
				
				if(used.equals("-") || used.equals("0"))
				{
					if(isNamedUserEnabled)
					{
						licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph1()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
					else if(isCCUserCertEnabled)
					{
						licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph2()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
				}
				else
				{
					String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
					if(isNamedUserEnabled)
					{
						String certParams = "NULL:NamedUsers|"+orgname+"@#@Organization@#@"+currentUsageDate;
						String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
						licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph1()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
					else if(isCCUserCertEnabled)
					{
						String certParams = "NULL:ConcurrentUser|"+orgname+"@#@Organization@#@"+currentUsageDate;
						String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
						licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph2()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
				}
				exportDataObj.put("userBased_UsedCnt",licUserGraph);
				if(peakCnt.equals("-") || peakCnt.equals("0"))
				{
					exportDataObj.put("userBased_PeakCnt",peakCnt);
				}
				else
				{
					String certFlag = "NULL:"+(isNamedUserEnabled ? "NamedUsers" : isCCUserCertEnabled ? "ConcurrentUser" : "NotApplicable");
					exportDataObj.put("userBased_PeakCnt",peakCnt+"~"+certFlag+"|"+orgname+"@#@Organization@#@"+peakDate);
				}
				exportDataObj.put("userBased_PeakDate",peakDateInfo);

				if (checkUserBasedViolation)
				{
					exportDataObj.put("userBased_license_violation","<span style='color:red;font-weight:bold'>"+userBasedVilotionCnt+"</span>");
				}
				else
				{
					exportDataObj.put("userBased_license_violation",userBasedVilotionCnt);
				}
				csvRow += ","+userBasedOrg+","+used+","+peakCnt+",\""+peakDate+"\","+userBasedVilotionCnt+"";
			}

			if (isEndPointNames)
			{
				long endPointNamesAllowedCount = EgInstallInfo.allowedEndPointUsersCount;
				String mgr_allowed_endPointNames = String.valueOf(endPointNamesAllowedCount);

				used = "0";
				int userVilotionCnt = 0;
				boolean checkUserViolation = false;
				String peakCnt = "-", peakDate = "-";
				String licUserGraph = "0";
				String peakDateInfo = "-";
				//if (orgname.equalsIgnoreCase("egenterprise"))
				//{
					int windowSize = endPointNamesInfo.getWindowValue();
					userVilotionCnt  = endPointNamesInfo.getNumberOfViolationForLast(windowSize);
					checkUserViolation = endPointNamesInfo.isEUCUsersViolationOccured();

					int idx = mgr_used_endPointNamesCount.indexOf(".");
					if(idx > -1)
					{
						mgr_used_endPointNamesCount = mgr_used_endPointNamesCount.substring(0,idx);
					}
					used = mgr_used_endPointNamesCount;
					peakCnt = mgrPeakUsgCntForEndPoint;
					peakDate = mgrPeakUsgDateForEndPoint;
										
					String temp = mgrPeakUsgDateForEndPointInfo+"^"+peakDate;
					peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraphforEndpoint(\""+temp+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
				//}
				//This else block is not used for enterprise model
				/* else
				{
					mgr_allowed_endPointNames = mgr_allowed_endPointNames.equals("-1") ? "-" : mgr_allowed_endPointNames;
					//peakusage
					HashMap userMap = (userCertInfo1 != null) ? (HashMap)userCertInfo1.get(orgname) : new HashMap();
					if (userMap != null)
					{
						Iterator it = userMap.keySet().iterator();
						while (it.hasNext())
						{
							String type = (String)it.next();
							String cnt = (String)userMap.get(type);
							if (type.equalsIgnoreCase("peakCount"))
							{
								peakCnt = cnt;
							}
							else if (type.equalsIgnoreCase("peakDate"))
							{
								peakDate = cnt;
							}
							else if(type.equalsIgnoreCase("Total"))
							{
								used = cnt;
							}
							int dotCnt = used.indexOf(".");
							if (dotCnt > -1)
							{
								used = used.substring(0,dotCnt);
							}
							int dotIdx = peakCnt.indexOf(".");
							if (dotIdx > -1)
							{
								peakCnt = peakCnt.substring(0,dotIdx);
							}
							if (peakDate!=null && !peakDate.trim().equals("-"))
							{
								String peakDateVal = peakDate+"^";
								peakDate = com.egurkha.util.DateUtil.changeDateFormat(peakDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
								peakDateVal += peakDate;
								peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraphForendPointsGroup(\""+peakDateVal+"\",\"User\",\""+orgname+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
							}
						}
					}
					//License violation
					ArrayList userviolationDetails = endPointNamesInfo.getUserviolationCount(orgname);
					if (userviolationDetails != null && userviolationDetails.size() > 0)
					{
						userVilotionCnt = (Integer)userviolationDetails.get(0);
						checkUserViolation = (Boolean)userviolationDetails.get(1);
					}
				} */
				exportDataObj.put("userBased_TotalCnt1",mgr_allowed_endPointNames);
				
				if(used.equals("-") || used.equals("0"))
				{
					exportDataObj.put("userBased_UsedCnt1","<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph3()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>");
				}
				else
				{
					String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
					String certParams = "endpointname:EndpointNames|"+orgname+"@#@Organization@#@"+currentUsageDate;
					String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
					exportDataObj.put("userBased_UsedCnt1","<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph3()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>");
				}
				if(peakCnt.equals("-") || peakCnt.equals("0"))
				{
					exportDataObj.put("userBased_PeakCnt1",peakCnt);
				}
				else
				{
					String certFlag = "endpointname:EndpointNames";
					exportDataObj.put("userBased_PeakCnt1",peakCnt+"~"+certFlag+"|"+orgname+"@#@Organization@#@"+peakDate);				
				}
				exportDataObj.put("userBased_PeakDate1",peakDateInfo);
				if (checkUserViolation)
				{
					exportDataObj.put("endPoint_license_violation","<span style='color:red;font-weight:bold'>"+userVilotionCnt+"</span>");
				}
				else
				{
					exportDataObj.put("endPoint_license_violation",userVilotionCnt);
				}
				csvRow += ","+mgr_allowed_endPointNames+","+used+","+peakCnt+",\""+peakDate+"\""+","+userVilotionCnt;
			}


			if (isO365UsrLic)
			{
				used = "0";
				int o365userVilotionCnt = 0;
				boolean checko365UserViolation = false;
				String peakCnt = "-", peakDate = "-";
				String licUserGraph = "0";
				if (orgname.equalsIgnoreCase("egenterprise"))
				{
					long o365userAllowedCount = EgInstallInfo.allowedO365Users;
					mgr_allowed_O365UserCount = String.valueOf(o365userAllowedCount);
					int windowSize = o365UsersInfoObj.getWindowValue();
					o365userVilotionCnt  = o365UsersInfoObj.getNumberOfViolationForLast(windowSize);
					checko365UserViolation = o365UsersInfoObj.isMsUserViolationOccured();

					int idx = mgr_used_userBasedCount.indexOf(".");
					if(idx > -1)
					{
						mgr_used_userBasedCount = mgr_used_userBasedCount.substring(0,idx);
					}
					used = mgr_used_O365Count;
					peakCnt = mgrPeakUsgCntForO365Users;
					peakDate = mgrPeakUsgDateForO365Users;
					
					if(used.equals("-") || used.equals("0"))
					{
						licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph4()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
					else
					{
						String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
						String certParams = "msusername:MSUser|"+orgname+"@#@Organization@#@"+currentUsageDate;
						String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
						licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph4()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
				}
				else
				{
					mgr_allowed_O365UserCount = mgr_allowed_O365UserCount.equals("-1") ? "-" : mgr_allowed_O365UserCount;
					//peakusage
					HashMap userMap = (o365UsersInfo != null) ? (HashMap)o365UsersInfo.get(orgname) : new HashMap();
					if (userMap != null)
					{
						Iterator it = userMap.keySet().iterator();
						while (it.hasNext())
						{
							String type = (String)it.next();
							String cnt = (String)userMap.get(type);
							if (type.equalsIgnoreCase("peakCount"))
							{
								peakCnt = cnt;
							}
							else if (type.equalsIgnoreCase("peakDate"))
							{
								peakDate = cnt;
							}
							else if(type.equalsIgnoreCase("Total"))
							{
								used = cnt;
							}
							int dotCnt = used.indexOf(".");
							if (dotCnt > -1)
							{
								used = used.substring(0,dotCnt);
							}
							int dotIdx = peakCnt.indexOf(".");
							if (dotIdx > -1)
							{
								peakCnt = peakCnt.substring(0,dotIdx);
							}
							if (peakDate!=null && !peakDate.trim().equals("-"))
							{
								peakDate = com.egurkha.util.DateUtil.changeDateFormat(peakDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
							}
						}
					}
					//License violation
					ArrayList o365userviolationDetails = o365UsersInfoObj.getO365UserviolationCount(orgname);
					if (o365userviolationDetails != null && o365userviolationDetails.size() > 0)
					{
						o365userVilotionCnt = (Integer)o365userviolationDetails.get(0);
						checko365UserViolation = (Boolean)o365userviolationDetails.get(1);
					}
					
					if(used.equals("-") || used.equals("0"))
					{
						licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfoForMsUsers(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
					else
					{
						String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
						String certParams = "msusername:MSUser|"+orgname+"@#@Organization@#@"+currentUsageDate;
						String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
						licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfoForMsUsers(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
				}
				exportDataObj.put("userBased_TotalCnt2",mgr_allowed_O365UserCount);
				exportDataObj.put("userBased_UsedCnt2",licUserGraph);

				if(peakCnt.equals("-") || peakCnt.equals("0"))
				{
					exportDataObj.put("userBased_PeakCnt2",peakCnt);
				}
				else
				{
					String certFlag = "msusername:MSUser";
					exportDataObj.put("userBased_PeakCnt2",peakCnt+"~"+certFlag+"|"+orgname+"@#@Organization@#@"+peakDate);
				}
				exportDataObj.put("userBased_PeakDate2",peakDate);
				if (checko365UserViolation)
				{
					exportDataObj.put("o365_license_violation","<span style='color:red;font-weight:bold'>"+o365userVilotionCnt+"</span>");
				}
				else
				{
					exportDataObj.put("o365_license_violation",o365userVilotionCnt);
				}
				csvRow += ","+mgr_allowed_O365UserCount+","+used+","+peakCnt+",\""+peakDate+"\""+","+o365userVilotionCnt;
			}

			//Network devices
			usedCnt = used_network;
			used = String.valueOf(usedCnt);
			int nwDevCnt = Integer.parseInt(networkDevOrg);
			int nwtAvail = nwDevCnt-usedCnt;
			if(nwtAvail < 0 ) nwtAvail=0;
			availCnt = networkDevOrg.equals("-1") ? "-" : String.valueOf(nwtAvail);
			networkDevOrg = networkDevOrg.equals("-1") ? "-" : networkDevOrg;
			exportDataObj.put("nwDev_TotalCnt",networkDevOrg);
			exportDataObj.put("nwDev_UsedCnt",used+"@#@"+orgname+"@#@Network device");
			exportDataObj.put("nwDev_AvailCnt",availCnt);
			csvRow += ","+networkDevOrg+","+used+","+availCnt;

			//Monitor users
			usedCnt = used_monUserCount;
			used = String.valueOf(usedCnt);
			int monUsrCnt = Integer.parseInt(userCntOrg);
			int monAvail = monUsrCnt-usedCnt;
			if(monAvail < 0) monAvail = 0;
			availCnt = userCntOrg.equals("-1") ? "-" : String.valueOf(monAvail);
			userCntOrg = userCntOrg.equals("-1") ? "-" : userCntOrg;
			exportDataObj.put("userCnt_TotalCnt",userCntOrg);
			exportDataObj.put("userCnt_UsedCnt",used+"@#@"+orgname+"@#@Monitor users");
			exportDataObj.put("userCnt_AvailCnt",availCnt);
			csvRow += ","+userCntOrg+","+used+","+availCnt;
			csvData.add(csvRow);
			JSONArray rootUserObjectArray = new JSONArray();
			//for sub org datas (Organizational unit)
			if (isUserCertMgr && isEndPointNames && isO365UsrLic)
			{
				rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,userCertInfo1,o365UsersInfo,mgrLicDetails);
			}
			else if (isUserCertMgr && isEndPointNames )
			{
				rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,userCertInfo1,mgrLicDetails);
			}
			else if (isUserCertMgr && isO365UsrLic)
			{
				rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,o365UsersInfo,mgrLicDetails);
			}
			else
			{
				if (isUserCertMgr)
				{
					rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,mgrLicDetails);
				}
				else if(isEndPointNames) 
				{
					rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,userCertInfo1,mgrLicDetails);
				}
				else if(isO365UsrLic) 
				{
					rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,o365UsersInfo,mgrLicDetails);
				}
				else
				{
					rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,mgrLicDetails);
				}
			}

			if (!rootUserObjectArray.isEmpty())
			{
				exportDataObj.put("children",rootUserObjectArray);

				csvDataList = uuidInfo.getCsvDataForLicenseUsage();
				if (csvDataList != null)
				{
					for(int j=(csvDataList.size()-1); j>=0; j--)
					{
						List t1 = (List)csvDataList.get(j);
						String tempStr = t1.toString();
						tempStr = tempStr.substring(1,tempStr.length()-1);
						StringTokenizer strTkns = new StringTokenizer(tempStr,"#");
						while(strTkns.hasMoreTokens())
						{
							String tStr = strTkns.nextToken();
							if(searchStr != null && tStr.indexOf(searchStr) == -1)
							{
								continue;
							}
							if (tStr.startsWith(","))
							{
								tStr = tStr.substring(1);
								tStr = tStr.trim();
							}
							csvData.add(tStr);
						}
					}
					uuidInfo.clearCsvDataForLicenseUsage();
				}
			}

			exportDataArr.add(exportDataObj);
			rootJson.put("exportDataArr",exportDataArr);
		}
	}
	else //If logged in as limited admin access user, then following block will be executed.
	{
		exportDataArr = new JSONArray();
		exportDataObj = new JSONObject();

		String orgname = "";
		boolean isSuperOrg = uuidInfo.isSuperOrg(session_userid);
		boolean isOrg = uuidInfo.isOrg(session_userid);
		if (isSuperOrg)
		{
			orgname = session_userid;
		}
		else if (isOrg)
		{
			orgname = session_userid;
		}
		else
		{
			orgname = uuidInfo.getDirectDependentOU(session_userid);
		}

		String displayName = orgname;
		if (orgname.startsWith("samlsso/"))
		{
			int idx = orgname.indexOf("/");
			displayName = orgname.substring(idx+1) + " (SAML)";
		}
		else if (orgname.indexOf("/") != -1)
		{
			if (orgname.indexOf("/Grp/") != -1)
			{
				String grpDelimiter = "/Grp/";
				int idx = orgname.indexOf(grpDelimiter);
				String str_uname_A = orgname.substring(0,idx);
				int nextIdx = idx + grpDelimiter.length();
				String str_uname_B = orgname.substring(nextIdx);
				displayName = str_uname_A + "/" + str_uname_B + " (Group)";
			}
		}

		//for super org datas (Organization)
		if (orgname.equalsIgnoreCase("egenterprise"))
		{
			exportDataObj.put("UserID",_mapping.getTextDescription("admin.user.egenterprise"));
		}
		else
		{
			exportDataObj.put("UserID",displayName);
		}
		exportDataObj.put("id",orgname);

		if (isSuperOrg)
		{
			exportDataObj.put("iconCls","iconDomain");
		}
		else
		{
			exportDataObj.put("iconCls","iconOtherUsers");
		}
		exportDataObj.put("expanded",true);

		//Getting license count values of user/organizational unit.
		String totMonOrg = String.valueOf(mgrAllowedTotalCnt);
		String basicMonOrg = String.valueOf(mgrAllowedBasicCnt);
		String premiumMonOrg = String.valueOf(mgrAllowedPremuCnt);
		String networkDevOrg = String.valueOf(mgrAllowedNwDevCnt);
		String userBasedOrg = String.valueOf(mgrAllowedUserCount);
		String userCntOrg = String.valueOf(mgrAllowedMonUserCount);
		String orgEndPointCunt = String.valueOf(mgrEndPointAllowedUserCount);
		String orgO365usersCunt = String.valueOf(mgrO365UsersAllowedUserCount);
		ArrayList userAllowedLimits = getValidLicenseCount(availUsersList,userCompMapIni,uuidInfo,orgname);
		if (userAllowedLimits != null && userAllowedLimits.size() > 0)
		{
			totMonOrg = userAllowedLimits.get(0).toString();
			basicMonOrg = userAllowedLimits.get(1).toString();
			networkDevOrg = userAllowedLimits.get(2).toString();
			if (isMgrUsedBased.equalsIgnoreCase("true") || userAllowedLimits.size()==5)
			{
				userBasedOrg = userAllowedLimits.get(3).toString();
				userCntOrg = userAllowedLimits.get(4).toString();
			}
			else
			{
				userBasedOrg = "0";
				userCntOrg = userAllowedLimits.get(3).toString();
			}

			if (isEndPointNames && userAllowedLimits.size()>=6)
			{
				orgEndPointCunt = userAllowedLimits.get(5).toString();
			}
			else 
			{
				orgEndPointCunt = "-";
			}
			if (isO365UsrLic && userAllowedLimits.size()>=7)
			{
				orgO365usersCunt = userAllowedLimits.get(6).toString();
			}
			else 
			{
				orgO365usersCunt = "-";
			}

			int allowedTotalCnt = Integer.parseInt(totMonOrg);
			int allowedBasicCnt = Integer.parseInt(basicMonOrg);
			int allowedPremuCnt = (allowedTotalCnt > -1 && allowedBasicCnt > -1) ? allowedTotalCnt - allowedBasicCnt : -1;
			premiumMonOrg = String.valueOf(allowedPremuCnt);
		}

		//Getting used and available license count values of organizational unit/organization.
		certUsage.setUserName(orgname);
		HashMap detailsMap = new HashMap();
		List orgNames = uuidInfo.getOrgNames(orgname);
		if (orgNames != null)
		{
			String reverseStr = "";
			for (int k=(orgNames.size()-1); k>=0; k--)
			{
				String str = (String)orgNames.get(k);
				reverseStr += str + "->";
			}
			if (reverseStr.length()>0)
			{
				reverseStr = (reverseStr.endsWith("->")) ? reverseStr.substring(0,reverseStr.length()-2) : reverseStr;
				csvRow = reverseStr;
			}
			else
			{
				csvRow = orgname;
			}
		}
		else
		{
			csvRow = orgname;
		}

		//Total monitors
		int totCnt = Integer.parseInt(totMonOrg);
		int usedCnt = 0;
		String used = "0";
		if (orgname.equalsIgnoreCase("egenterprise"))
		{
			usedCnt = used_total;
			used = String.valueOf(usedCnt);
		}
		else
		{
			detailsMap = certUsage.getTotalMonitorsDetailsForUser();
			used = (String)detailsMap.get("Used");
			usedCnt = Integer.parseInt(used);
		}
		String availCnt = totMonOrg.equals("-1") ? "-" : String.valueOf(totCnt-usedCnt);
		totMonOrg = totMonOrg.equals("-1") ? "-" : totMonOrg;
		exportDataObj.put("totMons_TotalCnt",totMonOrg);
		exportDataObj.put("totMons_UsedCnt",used+"@#@"+orgname+"@#@Total Monitors");
		exportDataObj.put("totMons_AvailCnt",availCnt);
		csvRow += ","+totMonOrg+","+used+","+availCnt;

		//Premium monitors and Basic monitors
		int usedPremium = 0, usedBasic = 0;
		String usedPrem = "0", usedBas = "0";
		if (orgname.equalsIgnoreCase("egenterprise"))
		{
			usedPremium = used_Premium;
			usedPrem = String.valueOf(usedPremium);
			usedBasic = used_basic;
			usedBas = String.valueOf(usedBasic);
		}
		else
		{
			detailsMap = certUsage.getPremiumMonitorsDetailsForUser();
			usedPrem = (String)detailsMap.get("Used");
			usedPremium = Integer.parseInt(usedPrem);
			detailsMap = certUsage.getBasicMonitorsDetailsForUser();
			usedBas = (String)detailsMap.get("Used");
			usedBasic = Integer.parseInt(usedBas);
		}
		//If basic comps exceeds the allowed count then it will consume premium license if exist.
		if (!basicMonOrg.equals("-1"))
		{
			int allowedBas = Integer.parseInt(basicMonOrg);
			if (usedBasic > allowedBas)
			{
				usedPremium += (usedBasic-allowedBas);
				usedBasic  = allowedBas;
				usedPrem = String.valueOf(usedPremium);
				usedBas = String.valueOf(usedBasic);
			}
		}
		int basCnt = Integer.parseInt(basicMonOrg);
		int basicAvail = basCnt-usedBasic;
		if (basicAvail < 0)
		{
			basicAvail = 0;
		}
		availCnt = basicMonOrg.equals("-1") ? "-" : String.valueOf(basicAvail);
		basicMonOrg = basicMonOrg.equals("-1") ? "-" : basicMonOrg;
		exportDataObj.put("basMons_TotalCnt",basicMonOrg);
		exportDataObj.put("basMons_UsedCnt",usedBas+"@#@"+orgname+"@#@Basic Monitors");
		exportDataObj.put("basMons_AvailCnt",availCnt);
		csvRow += ","+basicMonOrg+","+usedBas+","+availCnt;

		int premCnt = totCnt - basCnt;
		availCnt = premiumMonOrg.equals("-1") ? "-" : String.valueOf(premCnt-usedPremium);
		premiumMonOrg = premiumMonOrg.equals("-1") ? "-" : premiumMonOrg;
		if(totCnt > -1 && basCnt == -1) //special case : when total monitor is given an Limited count, but basic monitor have -1 in licnese .
		{
			premiumMonOrg = "-";
			availCnt = "-";
		}
		exportDataObj.put("premMons_TotalCnt",premiumMonOrg);
		exportDataObj.put("premMons_UsedCnt",usedPrem+"@#@"+orgname+"@#@Premium Monitors");
		exportDataObj.put("premMons_AvailCnt",availCnt);
		csvRow += ","+premiumMonOrg+","+usedPrem+","+availCnt;

		//User based (named or concurrent)
		if (isUserCertMgr)
		{
			String peakCnt = "-", peakDate = "-";
			int userBasedVilotionCnt = 0;
			used = "0";
			String peakDateInfo = "-";
			String peakDateVal = "";
			boolean checkUserBasedViolation = false;
			String licUserGraph = "0";

			if (orgname.equalsIgnoreCase("egenterprise"))
			{
				int windowSize = usersInfo.getWindowValue();
				userBasedVilotionCnt  = usersInfo.getNumberOfViolationForLast(windowSize);
				checkUserBasedViolation = usersInfo.isUserViolationOccured();

				used = mgr_used_userBasedCount;
				userBasedOrg =  mgr_allowed_userBasedCount;
				peakCnt = mgrPeakUsgCnt;
				peakDate = mgrPeakUsgDate;
				String temp = mgrPeakUsgDateInfo+"^"+mgrPeakUsgDate;				
				if(isNamedUserEnabled)
				{
					peakDateInfo = peakDate;
					if(used.equals("-") || used.equals("0"))
					{
						licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph1()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
					else
					{
						String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
						String certParams = "NULL:" + (isNamedUserEnabled ? "NamedUsers" : isCCUserCertEnabled ? "ConcurrentUser" : "NotApplicable");
						certParams += "|"+orgname+"@#@Organization@#@"+currentUsageDate;
						String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
						licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph1()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
				}
				else if(isCCUserCertEnabled)
				{
					peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraph(\""+temp+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
					if(used.equals("-") || used.equals("0"))
					{
						licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph2()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
					else
					{
						String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
						String certParams = "NULL:" + (isNamedUserEnabled ? "NamedUsers" : isCCUserCertEnabled ? "ConcurrentUser" : "NotApplicable");
						certParams += "|"+orgname+"@#@Organization@#@"+currentUsageDate;
						String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
						licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph2()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
					}
				}
			}
			else
			{
				//used = (aListData != null && aListData.size() > 0) ? (String)aListData.get(0) : "0";
				//used = (used.startsWith("0.")) ? used.substring(0,used.indexOf(".")) : "0";
				//usedCnt = Integer.parseInt(used);
				//int usrBsdCnt = Integer.parseInt(userBasedOrg);
				//availCnt = userBasedOrg.equals("-1") ? "-" : String.valueOf(usrBsdCnt-usedCnt);
				//userBasedOrg = userBasedOrg.equals("-1") ? "-" : userBasedOrg;

				//peakusage
				HashMap userMap = (userCertInfo != null) ? (HashMap)userCertInfo.get(orgname) : new HashMap();
				if (userMap != null)
				{
					Iterator it = userMap.keySet().iterator();
					while (it.hasNext())
					{
						String type = (String)it.next();
						String cnt = (String)userMap.get(type);
						if (type.equalsIgnoreCase("peakCount"))
						{
							peakCnt = cnt;
						}
						else if (type.equalsIgnoreCase("peakDate"))
						{
							peakDate = cnt;
						}
						else if(type.equalsIgnoreCase("Total"))
						{
							used = cnt;
						}
						int dotIdx = peakCnt.indexOf(".");
						if (dotIdx > -1)
						{
							peakCnt = peakCnt.substring(0,dotIdx);
						}
						if (peakDate!=null && !peakDate.trim().equals("-"))
						{
							peakDate = getCorrectDateForLicInfo(peakDate);
							peakDateVal = peakDate+"^";	
							peakDate = com.egurkha.util.DateUtil.changeDateFormat(peakDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
							peakDateVal += peakDate;
							if(isCCUserCertEnabled)
							{
								peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraphForGroup(\""+peakDateVal+"\",\"User\",\""+orgname+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
							}
							else
							{
								peakDateInfo = peakDate;
							}
						}
					}
				}
								
				if(used.equals("-") || used.equals("0"))
				{
					licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfo(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
				}
				else
				{
					String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
					String certParams = "NULL:" + (isNamedUserEnabled ? "NamedUsers" : isCCUserCertEnabled ? "ConcurrentUser" : "NotApplicable");
					certParams += "|"+orgname+"@#@Organization@#@"+currentUsageDate;
					String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
					licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfo(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
				}
				ArrayList userBasedviolationDetails = usersInfo.getUserBasedviolationCount(orgname);
				if (userBasedviolationDetails != null && userBasedviolationDetails.size() > 0)
				{
					userBasedVilotionCnt = (Integer)userBasedviolationDetails.get(0);
					checkUserBasedViolation = (Boolean)userBasedviolationDetails.get(1);
				}
			}
			int idxDec = used.indexOf(".");
			if (idxDec > -1)
			{
				used = used.substring(0,idxDec);
			}
			exportDataObj.put("userBased_TotalCnt",userBasedOrg);
			exportDataObj.put("userBased_UsedCnt",licUserGraph);
			
			if(peakCnt.equals("-") || peakCnt.equals("0"))
			{
				exportDataObj.put("userBased_PeakCnt",peakCnt);
			}
			else
			{
				String certFlag = "NULL:"+(isNamedUserEnabled ? "NamedUsers" : isCCUserCertEnabled ? "ConcurrentUser" : "NotApplicable");
				exportDataObj.put("userBased_PeakCnt",peakCnt+"~"+certFlag+"|"+orgname+"@#@Organization@#@"+peakDate);
			}
			exportDataObj.put("userBased_PeakDate",peakDateInfo);
			if (checkUserBasedViolation)
			{
				exportDataObj.put("userBased_license_violation","<span style='color:red;font-weight:bold'>"+userBasedVilotionCnt+"</span>");
			}
			else
			{
				exportDataObj.put("userBased_license_violation",userBasedVilotionCnt);
			}
			csvRow += ","+userBasedOrg+","+used+","+peakCnt+",\""+peakDate+"\""+","+userBasedVilotionCnt;
		}

		if (isEndPointNames)
		{
			long endPointNamesAllowedCount = EgInstallInfo.allowedEndPointUsersCount;
			String mgr_allowed_endPointNames = String.valueOf(endPointNamesAllowedCount);

			used = "0";
			int userVilotionCnt = 0;
			boolean checkUserViolation = false;
			String peakCnt = "-", peakDate = "-",peakDateInfo = "-";
			String licUserGraph = "0";
			if (orgname.equalsIgnoreCase("egenterprise"))
			{
				int windowSize = endPointNamesInfo.getWindowValue();
				userVilotionCnt  = endPointNamesInfo.getNumberOfViolationForLast(windowSize);
				checkUserViolation = endPointNamesInfo.isEUCUsersViolationOccured();

				int idx = mgr_used_userBasedCount.indexOf(".");
				if(idx > -1)
				{
					mgr_used_userBasedCount = mgr_used_userBasedCount.substring(0,idx);
				}
				used = mgr_used_endPointNamesCount;
				orgEndPointCunt =  mgr_allowed_endPointNames;
				peakCnt = mgrPeakUsgCntForEndPoint;
				peakDate = mgrPeakUsgDateForEndPoint;
				String temp = mgrPeakUsgDateForEndPointInfo+"^"+peakDate;
				peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraphforEndpoint(\""+temp+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
				
				if(used.equals("-") || used.equals("0"))
				{
					licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph3()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
				}
				else
				{
					String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
					String certParams = "endpointname:EndpointNames|"+orgname+"@#@Organization@#@"+currentUsageDate;
					String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
					licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph3()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
				}
			}
			else
			{
				orgEndPointCunt = orgEndPointCunt.equals("-1") ? "-" : orgEndPointCunt;
				//peakusage
				HashMap userMap = (userCertInfo1 != null) ? (HashMap)userCertInfo1.get(orgname) : new HashMap();
				if (userMap != null)
				{
					Iterator it = userMap.keySet().iterator();
					while (it.hasNext())
					{
						String type = (String)it.next();
						String cnt = (String)userMap.get(type);
						if (type.equalsIgnoreCase("peakCount"))
						{
							peakCnt = cnt;
						}
						else if (type.equalsIgnoreCase("peakDate"))
						{
							peakDate = cnt;
						}
						else if(type.equalsIgnoreCase("Total"))
						{
							used = cnt;
						}
						int dotCnt = used.indexOf(".");
						if (dotCnt > -1)
						{
							used = used.substring(0,dotCnt);
						}
						int dotIdx = peakCnt.indexOf(".");
						if (dotIdx > -1)
						{
							peakCnt = peakCnt.substring(0,dotIdx);
						}
						if (peakDate!=null && !peakDate.trim().equals("-"))
						{		
							String peakDateVal = peakDate+"^";
							peakDate = com.egurkha.util.DateUtil.changeDateFormat(peakDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
							peakDateVal += peakDate;
							peakDateInfo = "<a id='mouse' onClick='ctrler.showHourlyGraphForendPointsGroup(\""+peakDateVal+"\",\"User\",\""+orgname+"\")'>"+peakDate+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
						}
					}
				}
				//License violation
				ArrayList userviolationDetails = endPointNamesInfo.getUserviolationCount(orgname);
				if (userviolationDetails != null && userviolationDetails.size() > 0)
				{
					userVilotionCnt = (Integer)userviolationDetails.get(0);
					checkUserViolation = (Boolean)userviolationDetails.get(1);
				}
				
				if(used.equals("-") || used.equals("0"))
				{
					licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfoForEndpoint(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
				}
				else
				{
					String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
					String certParams = "endpointname:EndpointNames|"+orgname+"@#@Organization@#@"+currentUsageDate;
					String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
					licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfoForEndpoint(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
				}
			}
			exportDataObj.put("userBased_TotalCnt1",orgEndPointCunt);
			exportDataObj.put("userBased_UsedCnt1",licUserGraph);
			
			if(peakCnt.equals("-") || peakCnt.equals("0"))
			{
				exportDataObj.put("userBased_PeakCnt1",peakCnt);
			}
			else
			{
				String certFlag = "endpointname:EndpointNames";
				exportDataObj.put("userBased_PeakCnt1",peakCnt+"~"+certFlag+"|"+orgname+"@#@Organization@#@"+peakDate);
			}
			exportDataObj.put("userBased_PeakDate1",peakDateInfo);
			if (checkUserViolation)
			{
				exportDataObj.put("endPoint_license_violation","<span style='color:red;font-weight:bold' >"+userVilotionCnt+"</span>");
			}
			else
			{
				exportDataObj.put("endPoint_license_violation",userVilotionCnt);
			}
			csvRow += ","+orgEndPointCunt+","+used+","+peakCnt+",\""+peakDate+"\""+","+userVilotionCnt;
		}

		if (isO365UsrLic)
		{
			used = "0";
			String peakCnt = "-", peakDate = "-";
			String licUserGraph = "0";
			int o365userVilotionCnt = 0;
			boolean checko365UserViolation = false;

			if (orgname.equalsIgnoreCase("egenterprise"))
			{
				int windowSize = o365UsersInfoObj.getWindowValue();
				o365userVilotionCnt  = o365UsersInfoObj.getNumberOfViolationForLast(windowSize);
				checko365UserViolation = o365UsersInfoObj.isMsUserViolationOccured();

				int idx = mgr_used_userBasedCount.indexOf(".");
				if(idx > -1)
				{
					orgO365usersCunt = mgr_used_userBasedCount.substring(0,idx);
				}
				used = mgr_used_O365Count;
				peakCnt = mgrPeakUsgCntForO365Users;
				peakDate = mgrPeakUsgDateForO365Users;
				
				if(used.equals("-") || used.equals("0"))
				{
					licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph4()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
				}
				else
				{
					String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
					String certParams = "msusername:MSUser|"+orgname+"@#@Organization@#@"+currentUsageDate;
					String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
					licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraph4()'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
				}
			}
			else
			{
				orgO365usersCunt = orgO365usersCunt.equals("-1") ? "-" : orgO365usersCunt;
				//peakusage
				HashMap userMap = (o365UsersInfo != null) ? (HashMap)o365UsersInfo.get(orgname) : new HashMap();
				if (userMap != null)
				{
					Iterator it = userMap.keySet().iterator();
					while (it.hasNext())
					{
						String type = (String)it.next();
						String cnt = (String)userMap.get(type);
						if (type.equalsIgnoreCase("peakCount"))
						{
							peakCnt = cnt;
						}
						else if (type.equalsIgnoreCase("peakDate"))
						{
							peakDate = cnt;
						}
						else if(type.equalsIgnoreCase("Total"))
						{
							used = cnt;
						}
						int dotCnt = used.indexOf(".");
						if (dotCnt > -1)
						{
							used = used.substring(0,dotCnt);
						}
						int dotIdx = peakCnt.indexOf(".");
						if (dotIdx > -1)
						{
							peakCnt = peakCnt.substring(0,dotIdx);
						}
						if (peakDate!=null && !peakDate.trim().equals("-"))
						{
							peakDate = com.egurkha.util.DateUtil.changeDateFormat(peakDate,"yyyy-MM-dd HH:mm:ss",currDateFormat);
						}
					}
				}
				//License violation
				ArrayList o365userviolationDetails = o365UsersInfoObj.getO365UserviolationCount(orgname);
				if (o365userviolationDetails != null && o365userviolationDetails.size() > 0)
				{
					o365userVilotionCnt = (Integer)o365userviolationDetails.get(0);
					checko365UserViolation = (Boolean)o365userviolationDetails.get(1);
				}
				
				if(used.equals("-") || used.equals("0"))
				{
					licUserGraph = "<table><tr><td style='width:50%'>"+used+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfoForMsUsers(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
				}
				else
				{
					String currentUsageDate = com.egurkha.util.DateUtil.changeDateFormat(getPreviousTime(),"yyyy-MM-dd HH:mm:ss",currDateFormat);
					String certParams = "msusername:MSUser|"+orgname+"@#@Organization@#@"+currentUsageDate;
					String link = "<a id='mouse' onClick='ctrler.showOrgCurrentUsageDetails(\""+certParams+"\")'>"+used+"<img src='/final/images/spacer.gif' style='cursor:hand'/></a>";
					licUserGraph = "<table><tr><td style='width:50%'>"+link+"</td><td style='width:50%'>&nbsp;&nbsp;&nbsp;&nbsp;<a id='mouse' onClick='ctrler.showGraphOrgOUInfoForMsUsers(\""+orgname+"\")'><img src='/final/images/spacer.gif' style='cursor:hand;vertical-align:text-bottom;' class='iconLineChart' title='Graph'/></a></td></tr></table>";
				}
			}
			exportDataObj.put("userBased_TotalCnt2",orgO365usersCunt);
			exportDataObj.put("userBased_UsedCnt2",licUserGraph);
			
			if(peakCnt.equals("-") || peakCnt.equals("0"))
			{
				exportDataObj.put("userBased_PeakCnt2",peakCnt);
			}
			else
			{
				String certFlag = "msusername:MSUser";
				exportDataObj.put("userBased_PeakCnt2",peakCnt+"~"+certFlag+"|"+orgname+"@#@Organization@#@"+peakDate);
			}
			exportDataObj.put("userBased_PeakDate2",peakDate);
			if (checko365UserViolation)
			{
				exportDataObj.put("o365_license_violation","<span style='color:red;font-weight:bold'>"+o365userVilotionCnt+"</span>");
			}
			else
			{
				exportDataObj.put("o365_license_violation",o365userVilotionCnt);
			}
			csvRow += ","+orgO365usersCunt+","+used+","+peakCnt+",\""+peakDate+"\""+","+o365userVilotionCnt;
		}
		
		//Network devices
		if (orgname.equalsIgnoreCase("egenterprise"))
		{
			usedCnt = used_network;
			used = String.valueOf(usedCnt);
		}
		else
		{
			detailsMap = certUsage.getNetworkDevicesDetailsForUser();
			used = (String)detailsMap.get("Used");
			usedCnt = Integer.parseInt(used);
		}
		int nwDevCnt = Integer.parseInt(networkDevOrg);
		availCnt = networkDevOrg.equals("-1") ? "-" : String.valueOf(nwDevCnt-usedCnt);
		networkDevOrg = networkDevOrg.equals("-1") ? "-" : networkDevOrg;
		exportDataObj.put("nwDev_TotalCnt",networkDevOrg);
		exportDataObj.put("nwDev_UsedCnt",used+"@#@"+orgname+"@#@Network device");
		exportDataObj.put("nwDev_AvailCnt",availCnt);
		csvRow += ","+networkDevOrg+","+used+","+availCnt;

		//Monitor users
		if (orgname.equalsIgnoreCase("egenterprise"))
		{
			usedCnt = used_monUserCount;
			used = String.valueOf(usedCnt);
		}
		else
		{
			used = "0";
			ArrayList usersUnderOU = uuidInfo.getAllSubOrgsAndUsers(orgname);
			if (usersUnderOU != null && usersUnderOU.size() > 0)
			{
				usersUnderOU.remove(orgname);
				used = String.valueOf(usersUnderOU.size());
			}
		}
		usedCnt = Integer.parseInt(used);
		int monUsrCnt = Integer.parseInt(userCntOrg);
		availCnt = userCntOrg.equals("-1") ? "-" : String.valueOf(monUsrCnt-usedCnt);
		userCntOrg = userCntOrg.equals("-1") ? "-" : userCntOrg;
		exportDataObj.put("userCnt_TotalCnt",userCntOrg);
		exportDataObj.put("userCnt_UsedCnt",used+"@#@"+orgname+"@#@Monitor users");
		exportDataObj.put("userCnt_AvailCnt",availCnt);
		csvRow += ","+userCntOrg+","+used+","+availCnt;
		csvData.add(csvRow);

		//for sub org datas (Organizational unit)
		JSONArray rootUserObjectArray = new JSONArray();
		if (isUserCertMgr && isEndPointNames && isO365UsrLic)
		{
			rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,userCertInfo1,o365UsersInfo,mgrLicDetails);
		}
		else if (isUserCertMgr && isEndPointNames )
		{
			rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,userCertInfo1,mgrLicDetails);
		}
		else if (isUserCertMgr && isO365UsrLic)
		{
			rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,o365UsersInfo,mgrLicDetails);
		}
		else
		{
			if (isUserCertMgr)
			{
				rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,mgrLicDetails);
			}
			else if(isEndPointNames) 
			{
				rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,userCertInfo1,mgrLicDetails);
			}
			else if(isO365UsrLic) 
			{
				rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,o365UsersInfo,mgrLicDetails);
			}
			else
			{
				rootUserObjectArray = uuidInfo.buildOULicenseUsageTreeJson(orgname,false,aListData,userCertInfo,mgrLicDetails);
			}
		}
		
		if (!rootUserObjectArray.isEmpty())
		{
			exportDataObj.put("children",rootUserObjectArray);

			csvDataList = uuidInfo.getCsvDataForLicenseUsage();
			if (csvDataList != null)
			{
				for(int j=(csvDataList.size()-1); j>=0; j--)
				{
					List t1 = (List)csvDataList.get(j);
					String tempStr = t1.toString();
					tempStr = tempStr.substring(1,tempStr.length()-1);
					StringTokenizer strTkns = new StringTokenizer(tempStr,"#");
					while(strTkns.hasMoreTokens())
					{
						String tStr = strTkns.nextToken();
						if(searchStr != null && tStr.indexOf(searchStr) == -1)
						{
							continue;
						}
						if (tStr.startsWith(","))
						{
							tStr = tStr.substring(1);
							tStr = tStr.trim();
						}
						csvData.add(tStr);
					}
				}
				uuidInfo.clearCsvDataForLicenseUsage();
			}
		}

		exportDataArr.add(exportDataObj);
		rootJson.put("exportDataArr",exportDataArr);
	}

	if (exportDataArr.isEmpty())
	{
		rootJson.put("isUsersCreated",new Boolean(false));
		out.println(rootJson);
		return;
	}

	rootJson.put("isMgrConcUserBased",isCCUserCertEnabled);
	rootJson.put("isMgrNamedUserBased",isNamedUserEnabled);

	session.setAttribute("list",csvData);
	session.setAttribute("isAuditlogCSV","true");
	out.println(rootJson);

	
%>

<%!
	public ArrayList getValidLicenseCount(ArrayList availUsersList, IniFile userCompMapIni, EgUuidInfo uuidInfo, String orgname)
	{
		ArrayList userAllowedLimits = new ArrayList();
		if (availUsersList.contains(orgname))
		{
			String value = userCompMapIni.getValue("Users_Allowed_Count",orgname);
			value = EgCrypt.decrypt(value);
			userAllowedLimits = StringUtils.egTokenizer(value,"#");
		}
		else
		{
			List orgNames = uuidInfo.getOrgNames(orgname,false);
			for (int i=0; i<orgNames.size(); i++)
			{
				String orgName = orgNames.get(i).toString().trim();
				String value = userCompMapIni.getValue("Users_Allowed_Count",orgName);
				if (value != null && value.length()>0)
				{
					value = EgCrypt.decrypt(value);
					userAllowedLimits = StringUtils.egTokenizer(value,"#");
					break;
				}
			}
		}
		return userAllowedLimits;
	}
	public String getCorrectDateForLicInfo(String olddate)
	{
		String new_date = "";
		try
		{
			DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			Date date_1 = df.parse(olddate);
			Calendar cal_temp_date = new GregorianCalendar();
			cal_temp_date.setTime(date_1);
			cal_temp_date.add(Calendar.DATE,-1);
			java.util.Date dt_temp = cal_temp_date.getTime();
			new_date = df.format(dt_temp);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return new_date;
	}
	
	private String getPreviousTime()
	{
		EgDateInfo dateinfo = new EgDateInfo();
		Calendar cal = Calendar.getInstance();
		cal.clear();
		cal.setTime(new java.util.Date(dateinfo.egetUTCDate(false)-EgConfigInfo.msecPerDay));
		cal.setTimeZone(dateinfo.getRealTimeZone());
		cal.set(cal.HOUR_OF_DAY,0);
		cal.set(cal.MINUTE,0);
		cal.set(cal.SECOND,0);
		java.util.Date date = cal.getTime();
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return df.format(date);
	}
%>



