<%
/*
 *		Name			:	EgDelUDLayerJson.jsp
 *		Purpose			:
 *		CreationDate	:	01/10/2001
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "egurkha.*"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "net.sf.json.JSONObject"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	egurkha.ServiceBean serviceBean = new egurkha.ServiceBean();

	String server = request.getParameter("server");
	server = server.trim();
	String aggServer = "Agg_" + server;
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Component");
	/* code for auditlog ends */
	ServerBean serverBean = new ServerBean(true);
	DbBean dbBean = new DbBean();
	if(!serverBean.isServerUserDefined(server))
	{
		rootJSON.put("AlertType","Error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Delete Component"));
		rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.error.You are trying to delete a Component which is not User-Defined")+".");
			
		/* code for auditlog starts */
		if(server.endsWith("_ex"))
			auditLogThread.setValue("Description","Only user defined components can be deleted" +". "+ server+" server has not been deleted");
		else
			auditLogThread.setValue("Description","Only user defined components can be deleted" +". "+ "$ctype$:"+server +" " +"server has not been deleted");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		out.println(rootJSON);
		return;
	}
	else if(serverBean.doesCompExistForServer(server))
	{
		rootJSON.put("AlertType","Error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Delete Component"));
		String msg = _mapping.getTextDescription("admin.error.You are trying to delete a Component Type one or more of whose components are managed")+".";
		msg += _mapping.getTextDescription("admin.error.Please unmanage all components under this component type and try again")+".";
		rootJSON.put("AlertMsg",msg);

		/* code for auditlog starts */
		if(server.endsWith("_ex"))
			auditLogThread.setValue("Description","One or more components have been managed"+". " +server+" server has not been deleted");
		else
			auditLogThread.setValue("Description","One or more components have been managed"+". " + "$ctype$:"+server+" server has not been deleted");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
	
		out.println(rootJSON);
		return;
	}
	else if(serverBean.doesCompExistForServer(aggServer))
	{
		String aggServerDesc = _mapping.getComponentTypeDescription(aggServer);
		rootJSON.put("AlertType","Error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Delete Component"));
		String msg = _mapping.getTextDescription("admin.error.You are trying to delete a component type one or more of whose components are managed")+".";
		msg += _mapping.getTextDescription("admin.error.Please unmanage all aggregate components under")+" "+aggServerDesc+" "+_mapping.getTextDescription("admin.error.component type and try again")+".";
		rootJSON.put("AlertMsg",msg);

		/* code for auditlog starts */
		if(aggServer.endsWith("_ex"))
			auditLogThread.setValue("Description","One or more aggregate components have been managed"+". " +aggServer+" server has not been deleted");
		else
			auditLogThread.setValue("Description","One or more aggregate components have been managed"+". " + "$ctype$:"+aggServer+" server has not been deleted");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
		
		out.println(rootJSON);
		return;
	}
	else
	{
		//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
		IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
		serviceBean.stopDiscovery();
		serverBean.deleteServer(server);
		serverBean.deleteServer(aggServer);
		UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo();
		updateICInfo.removeServer(server);
		updateICInfo.removeServer(aggServer);
		serverBean.removeServerFromAutoAssociates(server);
		serverBean.removeServerFromAutoAssociates(aggServer);
		serviceBean.startDiscovery("1");
		EgConfigFilesSync.releaseInstance(infraIni);

		/*if(dbBean.getConnection())
			dbBean.removeServer(server);
		dbBean.releaseConnection();*/
		//response.sendRedirect("EgUDServer.jsp");

		//skm
		IniFile aggregateInfoSync = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate.ini",true);
		aggregateInfoSync.deleteValue(EgAggregateInfo.aggType,aggServer);
		aggregateInfoSync.deleteValue("COMPONENT_TYPE_MAPPING",aggServer);
		aggregateInfoSync.saveFile();
		EgConfigFilesSync.releaseInstance(aggregateInfoSync);
		//skm

		/* code for auditlog starts */
		if(server.endsWith("_ex"))
			auditLogThread.setValue("Description",server+" component type has been deleted");
		else
			auditLogThread.setValue("Description","$ctype$:"+server+" component type has been deleted");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
		ArrayList siteServers = new EgDiscInfo("manager").getSiteServers();
		if(siteServers != null && siteServers.size()>0)
		{		
			if(siteServers.contains(server))
			{
				IniFile discoverIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini",true);
				discoverIni.deleteValue("Site_servers",server);
				discoverIni.deleteValue("Site_servers",aggServer);
				discoverIni.saveFile();
				EgConfigFilesSync.releaseInstance(discoverIni);
			}
		}
		rootJSON.put("AlertType","Result");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Delete Component"));
		rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Component deleted successfully"));
		out.println(rootJSON);
	}
%>

