
<%
/***************************************************************
 *  File         : 	EgGroupThreshPolicies.jsp
 *  Purpose      : Configure threshold for a test.
 ***************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgServerGroupBean" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import = "com.eg.EgTesterInfo" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgTesterInfo testerInfo = new EgTesterInfo("manager");
	EgThresholdInfo egThresh = new EgThresholdInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
%>

<%
	JSONObject rootJson= new JSONObject();
	JSONObject screenLabels= new JSONObject();
	JSONObject hiddenObj= new JSONObject();
	JSONObject measureDataObj = new JSONObject();

	screenLabels.put("title","AGENT - THRESHOLDS");

	EgRoleInfo egRoleInfo=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listManagedComponents = egRoleInfo.getAllServers();

	String pg = request.getParameter("page");
	String server=request.getParameter("server");
	String serv=request.getParameter("serv"); 

	StringTokenizer st = null;
	StringTokenizer st1 = null;
	StringTokenizer st2 = null;
	String strIniVar[];
	String strIniVal = null;
	String measure = "";
	String policy = "";
	String min = "";
	String max = ""; 
	String entry = "first";
	Vector v_temp = new Vector();

	String absA = "";
	String absB = "";
	String relA = "";
	String relB = "";
	String strTok = "";
	ArrayList tmpList = new ArrayList();
	String userLanguage = _user.getLanguage();
	String loginId = _user.getLoginID();

	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	final String subject2 = "GROUP_THRESHOLD_MAPPING";
	EgServerGroupBean descGrpp = new EgServerGroupBean();
	String Threshsubject = "THRESHOLDPOLICIES";

	String s_testName = "";
	String s_compType = "";
	String s_policyName = "";

	// from EgSpecificThresh.jsp operation for find policyname
	String action=request.getParameter("actionFrom");
	String specsThreshPage=request.getParameter("specthreshpage");
	String strServer = request.getParameter("strServer");
	String component = request.getParameter("component");
	String strComeFrom = request.getParameter("comeFrom");
	String test = request.getParameter("testName");

	session.setAttribute("componentType",strServer);
	session.setAttribute("componentName",component);
	session.setAttribute("testName",test);

	action = (action!=null && action.length()>0 ? action:"");
	specsThreshPage = (specsThreshPage!=null && specsThreshPage.length()>0 ? specsThreshPage:"");
	component = (component!=null && component.length()>0 ? component:"");
	test = (test!=null && test.length()>0 ? test:"");
	if(specsThreshPage != null && specsThreshPage.equalsIgnoreCase("yes"))
	{
		String descName = request.getParameter("descName");
		boolean portRelevant_grpTest = egSpecs.isPortRelevantForTest(test);
		Vector serverGroup = descGrpp.getServerGroupUI(component,test,portRelevant_grpTest);

		if (!StringUtils.isNull(descName))
		{
			descName = StringUtils.decodeSecurityChar(descName);

			if (serverGroup != null && serverGroup.size() > 0)
			{
				s_policyName = descGrpp.getPolicyForTest((String)serverGroup.get(0),test,descName);

				if (StringUtils.isNull(s_policyName))
				{
					s_policyName = descGrpp.getPolicyForTest((String) serverGroup.get(0),test);
				}
			}
		}
		else
		{
			String policyName = "";
			Vector _vec = new Vector();
			TreeSet set = null;
			if (serverGroup != null && serverGroup.size() > 0)
			{
				set = descGrpp.getManagedInfos((String)serverGroup.get(0),test);
			}
			if (set != null && set.size() > 0)
			{
				Iterator u = set.iterator();
				while (u.hasNext())
				{
					policyName = (String)u.next();
					_vec.add(policyName);
				}
			}
			s_policyName = policyName;
		}

		//action value define
		String tmpTestName = descGrpp.getTestNameForPolicy(s_policyName);
		Vector tmpVec = descGrpp.getServerGroupForPolicy(s_policyName);

		if(tmpVec == null || tmpVec.size() == 0)
		{
			action = "modify";
		}
		else
		{
			Vector allCompWithType = new Vector();
			for(int j=0;j<tmpVec.size();j++)
			{
				String strGrpName = (String) tmpVec.get(j);
				Vector allComps = descGrpp.getComponentNames(strGrpName);
				String serverName = descGrpp.getServerType(strGrpName);
				if(allComps != null && allComps.size() > 0)
				{
					for(int ac= 0;ac<allComps.size();ac++)
					{
						String tmpComp = (String) allComps.get(ac);
						String strCompWithType = serverName+":"+tmpComp;
						if(!allCompWithType.contains(strCompWithType))
						{
							allCompWithType.add(strCompWithType);
						}
					}
				}
			}

			if(listManagedComponents.containsAll(allCompWithType))
			{
				action = "modify";
			}
			else
			{
				action = "view";
			}
		}
	}
	else
	{
		s_policyName = request.getParameter("policyName");
	}

	if(s_policyName != null && !s_policyName.equals(""))
	{
		s_testName = descGrpp.getTestNameForPolicy(s_policyName);
	}
	else
	{
		s_testName = request.getParameter("testName");
		s_policyName = "";
	}

	if (!StringUtils.isNull(s_policyName))
	{
		s_policyName = StringUtils.decodeSecurityChar(s_policyName);
	}

	// Group name for process page
	session.setAttribute("PolicyName",s_policyName);
	String testName = s_testName;
	String serverName= "";//s_compType;
	session.setAttribute("server",serverName);

	String reqFrom = request.getParameter("from");
//	String action=request.getParameter("action");
//	action = (action!=null && action.length()>0 ? action:"");
	String[] arr_Threshgroup = {""};
	if(reqFrom != null && !reqFrom.equals(""))
	{
		Vector vec_pol = descGrpp.getAllPolicyName(Threshsubject);
		String[] arr_len = new String[vec_pol.size()];
		arr_Threshgroup = (String[]) vec_pol.toArray(arr_len);
		String threshGrpString = StringUtils.getArrayAsString(arr_Threshgroup); 
		rootJson.put("groupNames",threshGrpString);

	}
	if(action != null && action.equals("modify"))
	{
		entry="notFirst";
	}

	hiddenObj.put("server",strServer);
	hiddenObj.put("component",component);
	hiddenObj.put("action",action);
	hiddenObj.put("reqFrom",reqFrom);
	hiddenObj.put("entry",entry);
	hiddenObj.put("strPolicyName",s_policyName);
	hiddenObj.put("serv",serv);

	String reqCompType = request.getParameter("compType");
	String reqTest = request.getParameter("testName");
	reqTest = (reqTest != null && !reqTest.equals("null") && reqTest.length()>0 ? reqTest:"");
	reqCompType = (reqCompType != null && !reqCompType.equals("null") && reqCompType.length()>0 ? reqCompType:"");
	String[] compTypesArray = egRoleInfo.getServerTypes(); //get the comp types for the specified User

	if(compTypesArray.length > 0)
	{
		rootJson.put("isManagedCompAvailable",true);
		if(StringUtils.isNull(action) && (!action.equalsIgnoreCase("modify") && !action.equalsIgnoreCase("view")))
		{
			ArrayList compTypes = new ArrayList();
			ArrayList testForServer = new ArrayList();
			ArrayList globalThresholds = testerInfo.getGlobalThresholds(); // get the global threshold tests 
			if (globalThresholds == null || globalThresholds.isEmpty())
			{
				globalThresholds = new ArrayList();
			}

			for(int i=0;i<compTypesArray.length;i++)
			{
				String tempTestList[] = egSpecs.getTestsForServer(compTypesArray[i]);
				if(tempTestList != null && tempTestList.length > 0)
				{
					ArrayList tests = new ArrayList();
					for(int j=0;j<tempTestList.length;j++)
					{
						String tmp = tempTestList[j];
						if(!tests.contains(tmp))
							tests.add(tmp);
					}
					if(!globalThresholds.containsAll(tests) && !compTypes.contains(compTypesArray[i])) 
					{
						//remove the global threshold tests from the "tests" List 
						compTypes.add(compTypesArray[i]);
						if(reqCompType.equalsIgnoreCase(compTypesArray[i]))
						{
							testForServer = tests;
							testForServer.removeAll(globalThresholds);
						}
					}
				}
			}
			ArrayList configTests = egSpecs.getConfigTestsForServer(reqCompType);
			if(configTests != null)
				testForServer.removeAll(configTests);
			screenLabels.put("admin.groups.Component type",_mapping.getTextDescription("admin.groups.Component type"));
			JSONArray grpCompTypeArr = new JSONArray();
			JSONObject grpCompTypeObj = new JSONObject();
			if(compTypes.size()>0)
			{
				grpCompTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a server type"));
				grpCompTypeObj.put("valueField","-1");
				grpCompTypeArr.add(grpCompTypeObj);
			}
			tmpList = sorter.getSortedCompTypeList(compTypes);

			for(int i=0;i<tmpList.size();i++)
			{
				grpCompTypeObj = new JSONObject();
				EgName nameObj = (EgName)tmpList.get(i);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();
				grpCompTypeObj.put("displayField",tmpDis);
				grpCompTypeObj.put("valueField",tmpVal);
				grpCompTypeArr.add(grpCompTypeObj);
				if(tmpVal.equalsIgnoreCase(reqCompType))
				{
					rootJson.put("selectedCType",reqCompType);
				}
			}

			rootJson.put("grpCompTypeArr",grpCompTypeArr);
			JSONArray grpTestNameArr = new JSONArray();
			JSONObject grpTestNameObj = new JSONObject();
			if(reqCompType.equalsIgnoreCase("Groups"))
			{
				grpTestNameObj.put("displayField",_mapping.getTextDescription("admin.groups.Not Applicable"));
				grpTestNameObj.put("valueField","-1");
				grpTestNameArr.add(grpTestNameObj);
			}
			else if(testForServer != null && testForServer.size()>0)
			{
				grpTestNameObj.put("displayField",_mapping.getTextDescription("admin.groups.Choose a test  name"));
				grpTestNameObj.put("valueField","-1");
				grpTestNameArr.add(grpTestNameObj);
				tmpList = sorter.getSortedTestList(testForServer);	
				for(int i=0;i<tmpList.size();i++)
				{
					grpTestNameObj = new JSONObject();
					EgName nameObj = (EgName)tmpList.get(i);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					if(EgInstallInfo.isConfigTest(tmpVal))
					{
						continue;
					}
					grpTestNameObj.put("displayField",tmpDis);
					grpTestNameObj.put("valueField",tmpVal);
					grpTestNameArr.add(grpTestNameObj);
					if (tmpVal.equalsIgnoreCase(reqTest))
					{
						rootJson.put("selectedTestName",reqTest);
					}
				}
			}
			else if(testForServer != null && testForServer.size() == 0)
			{
				grpTestNameObj.put("displayField",_mapping.getTextDescription("admin.groups.Not Applicable"));
				grpTestNameObj.put("valueField","-1");
				grpTestNameArr.add(grpTestNameObj);
			}
			rootJson.put("grpTestNameArr",grpTestNameArr);
			if((!StringUtils.isNull(reqCompType) && !reqCompType.equals("Groups")) && (!StringUtils.isNull(reqTest) && !reqTest.equals("Groups")))
			{
				rootJson.put("text_box","true");
			}
		}

		/* threshold values for the selected test */
		if(!reqCompType.equalsIgnoreCase("Groups") && !reqTest.equalsIgnoreCase("Groups"))
		{
			//serverName = reqCompType;
			//String[] alarmPolicies= egThresh.getAllAlarmPolicies();
			strIniVar = egThresh.getDefaultThresholds();
			boolean multiThresh = false;
			for(int i=0; i<strIniVar.length; i++)
			{
				if(strIniVar[i].startsWith(";"))
				{
					continue;
				}
				if(strIniVar[i].equals(testName))
				{
					Vector vec = descGrpp.getAllPolicyName(Threshsubject);
					if(vec != null && vec.size() > 0 && vec.contains(s_policyName))
					{
						strIniVal = descGrpp.getPolicyValue(s_policyName);
					}
					else
					{
						strIniVal = egThresh.getDefaultThresholdValue(strIniVar[i]);
					}
				}
			}
			
			if(pg != null)
			{
				rootJson.put("fieldSetTitle",_mapping.getTextDescription("admin.threshold.Test Name")+"&nbsp;&nbsp;:&nbsp;"+_mapping.getTestDescription(s_testName));
				screenLabels.put("admin.threshold.Test Name",_mapping.getTextDescription("admin.threshold.Test Name"));
				rootJson.put("testName",_mapping.getTestDescription(s_testName));
				rootJson.put("displayTestName","<b>"+_mapping.getTestDescription(s_testName)+"</b>");
			}
			else
			{
				if(s_policyName != null && !s_policyName.equals(""))
				{
					rootJson.put("fieldSetTitle",_mapping.getTextDescription("admin.threshold.Test Name")+"&nbsp;&nbsp;:&nbsp;"+_mapping.getTestDescription(s_testName)+"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_mapping.getTextDescription("admin.threshold.Rule Name")+"&nbsp;&nbsp;:&nbsp;"+s_policyName);

					screenLabels.put("admin.threshold.Test Name",_mapping.getTextDescription("admin.threshold.Test Name"));
					rootJson.put("testName",_mapping.getTestDescription(s_testName));
					rootJson.put("displayTestName","<b>"+_mapping.getTestDescription(s_testName)+"</b>");

				}
				else
				{
					rootJson.put("fieldSetTitle",_mapping.getTextDescription("admin.threshold.Test Name")+"&nbsp;&nbsp;:&nbsp;"+_mapping.getTestDescription(s_testName));

					screenLabels.put("admin.threshold.Test Name",_mapping.getTextDescription("admin.threshold.Test Name"));
					rootJson.put("testName",_mapping.getTestDescription(s_testName));
					rootJson.put("displayTestName","<b>"+_mapping.getTestDescription(s_testName)+"</b>");
				}
			}

			if(s_policyName.length() > 0)
			{
				screenLabels.put("admin.threshold.Rule Name",_mapping.getTextDescription("admin.threshold.Rule Name"));
				rootJson.put("policyName",s_policyName);
				rootJson.put("displayPolicyName","<b>"+s_policyName+"</b>");
			}


			if (!StringUtils.isNull(action) && action.equalsIgnoreCase("view"))
			{
				boolean heading_flag = false;
				ArrayList aListTestWithNoThresholds = new ArrayList();
				boolean cellFlag = false;
				boolean isTestWithThresholds = false;
				st = new StringTokenizer(strIniVal,",");
				JSONArray threshTableArray = new JSONArray();
				JSONArray noThreshTableArray = new JSONArray();
				JSONArray measureValArr = new JSONArray();
				JSONObject hiddenDataObj = new JSONObject();
				JSONArray threshValArr = new JSONArray();
				JSONObject toolTipMsg = new JSONObject();

				while (st.hasMoreTokens())
				{
					JSONObject threshValObj = new JSONObject();
					strTok = st.nextToken();
					st1 = new StringTokenizer(strTok,":");
					while (st1.hasMoreTokens())
					{
						JSONObject tmpObject = new JSONObject();
						measure = st1.nextToken();
						policy = st1.nextToken();
						min = st1.nextToken();
						max = st1.nextToken();
						String alarmPolicy = st1.nextToken();
						String lastToken = st1.nextToken();
						threshValObj.put("AlarmPolicy",alarmPolicy);
						hiddenObj.put("alarmPolicy", alarmPolicy);
						hiddenObj.put("testName", s_testName);
						hiddenObj.put("measure", measure);

						String criticalMsg = mappingInfo.getThresholdPriorityDescription(s_testName+":"+measure+":Critical");
						
						if (!StringUtils.isNull(criticalMsg))
						{
							threshValObj.put("isToolTip",true);

							toolTipMsg.put("toolTipCritical",criticalMsg);
							criticalMsg = mappingInfo.getThresholdPriorityDescription(s_testName+":"+measure+":Major");

							toolTipMsg.put("toolTipMajor",criticalMsg);
						}
						else
						{
							threshValObj.put("isToolTip",false);
						}

						String absMinCritical = "-";
						String relMinCritical = "-";

						String absMinMajor = "-";
						String relMinMajor = "-";

						String absMinMinor = "-";
						String relMinMinor = "-";

						String absMaxCritical = "-";
						String relMaxCritical = "-";

						String absMaxMajor = "-";
						String relMaxMajor = "-";

						String absMaxMinor = "-";
						String relMaxMinor = "-";

						if (policy.equalsIgnoreCase("none"))
						{
							policy = "mix";
						}
						else if (policy.equalsIgnoreCase("absolute"))
						{
							if (!min.equals("-1"))
							{
								StringTokenizer stAbsMin = new StringTokenizer(min,"/");
								absMinCritical = stAbsMin.nextToken();
								absMinMajor = stAbsMin.nextToken();
								absMinMinor = stAbsMin.nextToken();
							}

							if (!max.equals("-1"))
							{
								StringTokenizer stAbsMax = new StringTokenizer(max,"/");
								absMaxCritical = stAbsMax.nextToken();
								absMaxMajor = stAbsMax.nextToken();
								absMaxMinor = stAbsMax.nextToken();
							}
						}
						else if (policy.equalsIgnoreCase("relative"))
						{
							if (!min.equals("-1"))
							{
								StringTokenizer stRelMin = new StringTokenizer(min,"/");
								relMinCritical = stRelMin.nextToken();
								relMinMajor = stRelMin.nextToken();
								relMinMinor = stRelMin.nextToken();
							}

							if (!max.equals("-1"))
							{
								StringTokenizer stRelMax = new StringTokenizer(max,"/");
								relMaxCritical = stRelMax.nextToken();
								relMaxMajor = stRelMax.nextToken();
								relMaxMinor = stRelMax.nextToken();
							}
						}
						else if (policy.equalsIgnoreCase("mix"))
						{
							Vector vec = getAbsAndRel(min);
							absA = (String) vec.get(0);
							relA = (String) vec.get(1);
							Vector vec1 = getAbsAndRel(max);
							absB = (String) vec1.get(0);
							relB = (String) vec1.get(1);

							if (!absA.equals("none"))
							{
								StringTokenizer stmixMin = new StringTokenizer(absA,"/");
								absMinCritical = stmixMin.nextToken();
								absMinMajor = stmixMin.nextToken();
								absMinMinor = stmixMin.nextToken();
							}

							if (!absB.equals("none"))
							{
								StringTokenizer stmixMax = new StringTokenizer(absB,"/");
								absMaxCritical = stmixMax.nextToken();
								absMaxMajor = stmixMax.nextToken();
								absMaxMinor = stmixMax.nextToken();
							}

							if (!relA.equals("none"))
							{
								StringTokenizer stRelMin = new StringTokenizer(relA,"/");
								relMinCritical = stRelMin.nextToken();
								relMinMajor = stRelMin.nextToken();
								relMinMinor = stRelMin.nextToken();
							}

							if (!relB.equals("none"))
							{
								StringTokenizer stmixMax = new StringTokenizer(relB,"/");
								relMaxCritical = stmixMax.nextToken();
								relMaxMajor = stmixMax.nextToken();
								relMaxMinor = stmixMax.nextToken();
							}
						}
						hiddenObj.put("absMinCritical", absMinCritical);
						hiddenObj.put("relMinCritical", relMinCritical);
						hiddenObj.put("absMinMajor", absMinMajor);
						hiddenObj.put("relMinMajor", relMinMajor);
						hiddenObj.put("absMinMinor", absMinMinor);
						hiddenObj.put("relMinMinor", relMinMinor);
						hiddenObj.put("absMaxCritical", absMaxCritical);
						hiddenObj.put("relMaxCritical", relMaxCritical);
						hiddenObj.put("absMaxMajor", absMaxMajor);
						hiddenObj.put("relMaxMajor", relMaxMajor);
						hiddenObj.put("absMaxMinor", absMaxMinor);
						hiddenObj.put("relMaxMinor", relMaxMinor);
						hiddenDataObj.put(measure,hiddenObj);

						String minCritical = getThresholdValue("min",absMinCritical,relMinCritical);
						String minMajor = getThresholdValue("min",absMinMajor,relMinMajor);
						String minMinor = getThresholdValue("min",absMinMinor,relMinMinor);

						String maxCritical = getThresholdValue("max",absMaxCritical,relMaxCritical);
						String maxMajor = getThresholdValue("max",absMaxMajor,relMaxMajor);
						String maxMinor = getThresholdValue("max",absMaxMinor,relMaxMinor);
						
						String unit = tablesInfo.getUnitForMeasure(s_testName,measure);

						if (minCritical.equals("-")  && minMajor.equals("-") && minMinor.equals("-") && 
						maxCritical.equals("-") && maxMajor.equals("-") && maxMinor.equals("-"))
						{
							aListTestWithNoThresholds.add(measure);
							cellFlag = !cellFlag;
							continue;
						}
						else
						{
							isTestWithThresholds = true;
						}
						
						String tempThresh = "";
						boolean isMinData = false;
						if(!minCritical.equals("-")  || !minMajor.equals("-") || !minMinor.equals("-"))
						{
							tempThresh += "Min|"+minCritical+"|"+minMajor+"|"+minMinor;
							isMinData = true;
						}

						if(!maxCritical.equals("-") || !maxMajor.equals("-") || !maxMinor.equals("-"))
						{
							if (isMinData)
							{
								tempThresh += "#Max|"+maxCritical+"|"+maxMajor+"|"+maxMinor;
							}
							else
							{
								tempThresh += "Max|"+maxCritical+"|"+maxMajor+"|"+maxMinor;
							}
						}
						measureDataObj.put(mappingInfo.getMeasureDescription(s_testName,measure),measure);
						threshValObj.put("Measure",mappingInfo.getMeasureDescription(s_testName,measure)+"  ("+unit+")");
						threshValObj.put("Threshold",tempThresh);
						threshValObj.put("action",action);
						measureValArr.add(threshValObj);

						if (!heading_flag)
						{
							heading_flag = true;
						}
					}

					cellFlag = !cellFlag;
				}

				rootJson.put("toolTipMsg",toolTipMsg);
				rootJson.put("hiddenDataObj",hiddenDataObj);
				rootJson.put("measureValArr",measureValArr);

				if (aListTestWithNoThresholds != null && !aListTestWithNoThresholds.isEmpty())
				{
					JSONArray noMeasureValArr = new JSONArray();
					int d=0;
					while(d<aListTestWithNoThresholds.size())
					{
						JSONObject noMeasureThreshValObj = new JSONObject();
						String strMeasure1 = "";
						String strMeasure2 = "";
						String strMeasure = (String)aListTestWithNoThresholds.get(d);
						int count = d;
						if(!StringUtils.isNull(strMeasure))
						{
							measureDataObj.put(mappingInfo.getMeasureDescription(s_testName,strMeasure),strMeasure);
							strMeasure = mappingInfo.getMeasureDescription(s_testName,strMeasure);
						}
						else
							strMeasure = "";
						count = d+1;
						if(count < aListTestWithNoThresholds.size())
						{
							strMeasure1 = (String)aListTestWithNoThresholds.get(count);
							if(!StringUtils.isNull(strMeasure1))
							{
								measureDataObj.put(mappingInfo.getMeasureDescription(s_testName,strMeasure1),strMeasure1);
								strMeasure1 = mappingInfo.getMeasureDescription(s_testName,strMeasure1);
							}
						}
						count = d+2;
						if(count < aListTestWithNoThresholds.size())
						{
							strMeasure2 = (String)aListTestWithNoThresholds.get(count);
							if(!StringUtils.isNull(strMeasure2))
							{
								measureDataObj.put(mappingInfo.getMeasureDescription(s_testName,strMeasure2),strMeasure2);
								strMeasure2 = mappingInfo.getMeasureDescription(s_testName,strMeasure2);
							}
						}

						noMeasureThreshValObj.put("Measure1",strMeasure);
						noMeasureThreshValObj.put("Measure2",strMeasure1);
						noMeasureThreshValObj.put("Measure3",strMeasure2);
						noMeasureThreshValObj.put("action",action);
						noMeasureValArr.add(noMeasureThreshValObj);
						d = count+1;
					}
					rootJson.put("noMeasureValArr",noMeasureValArr);
				}
			}
			else
			{
				boolean heading_flag = false;
				ArrayList aListTestWithNoThresholds = new ArrayList();
				boolean cellFlag = false;
				boolean isTestWithThresholds = false;
				st = new StringTokenizer(strIniVal,",");
				JSONArray threshTableArray = new JSONArray();
				JSONArray noThreshTableArray = new JSONArray();
				JSONArray measureValArr = new JSONArray();
				JSONObject hiddenDataObj = new JSONObject();
				JSONObject toolTipMsg = new JSONObject();

				while (st.hasMoreTokens())
				{
					strTok = st.nextToken();
					st1 = new StringTokenizer(strTok,":");
					while (st1.hasMoreTokens())
					{
						JSONObject threshValObj = new JSONObject();
						measure = st1.nextToken();
						policy = st1.nextToken();
						min = st1.nextToken();
						max = st1.nextToken();
						String alarmPolicy = st1.nextToken();
						String lastToken = st1.nextToken();
						threshValObj.put("AlarmPolicy",alarmPolicy);
						hiddenObj.put("alarmPolicy", alarmPolicy);
						hiddenObj.put("measure", measure);
						hiddenObj.put("testName", s_testName);

						String criticalMsg = mappingInfo.getThresholdPriorityDescription(s_testName+":"+measure+":Critical");
						
						if (!StringUtils.isNull(criticalMsg))
						{
							threshValObj.put("isToolTip",true);
							toolTipMsg.put("toolTipCritical",criticalMsg);
							criticalMsg = mappingInfo.getThresholdPriorityDescription(s_testName+":"+measure+":Major");

							toolTipMsg.put("toolTipMajor",criticalMsg);
						}
						else
						{
							threshValObj.put("isToolTip",false);
						}

						String absMinCritical = "-";
						String relMinCritical = "-";

						String absMinMajor = "-";
						String relMinMajor = "-";

						String absMinMinor = "-";
						String relMinMinor = "-";

						String absMaxCritical = "-";
						String relMaxCritical = "-";

						String absMaxMajor = "-";
						String relMaxMajor = "-";

						String absMaxMinor = "-";
						String relMaxMinor = "-";

						if (policy.equalsIgnoreCase("none"))
						{
							policy = "mix";
						}
						else if (policy.equalsIgnoreCase("absolute"))
						{
							if (!min.equals("-1"))
							{
								StringTokenizer stAbsMin = new StringTokenizer(min,"/");
								absMinCritical = stAbsMin.nextToken();
								absMinMajor = stAbsMin.nextToken();
								absMinMinor = stAbsMin.nextToken();
							}

							if (!max.equals("-1"))
							{
								StringTokenizer stAbsMax = new StringTokenizer(max,"/");
								absMaxCritical = stAbsMax.nextToken();
								absMaxMajor = stAbsMax.nextToken();
								absMaxMinor = stAbsMax.nextToken();
							}
						}
						else if (policy.equalsIgnoreCase("relative"))
						{
							if (!min.equals("-1"))
							{
								StringTokenizer stRelMin = new StringTokenizer(min,"/");
								relMinCritical = stRelMin.nextToken();
								relMinMajor = stRelMin.nextToken();
								relMinMinor = stRelMin.nextToken();
							}

							if (!max.equals("-1"))
							{
								StringTokenizer stRelMax = new StringTokenizer(max,"/");
								relMaxCritical = stRelMax.nextToken();
								relMaxMajor = stRelMax.nextToken();
								relMaxMinor = stRelMax.nextToken();
							}
						}
						else if (policy.equalsIgnoreCase("mix"))
						{
							Vector vec = getAbsAndRel(min);
							absA = (String) vec.get(0);
							relA = (String) vec.get(1);
							Vector vec1 = getAbsAndRel(max);
							absB = (String) vec1.get(0);
							relB = (String) vec1.get(1);

							if (!absA.equals("none"))
							{
								StringTokenizer stmixMin = new StringTokenizer(absA,"/");
								absMinCritical = stmixMin.nextToken();
								absMinMajor = stmixMin.nextToken();
								absMinMinor = stmixMin.nextToken();
							}

							if (!absB.equals("none"))
							{
								StringTokenizer stmixMax = new StringTokenizer(absB,"/");
								absMaxCritical = stmixMax.nextToken();
								absMaxMajor = stmixMax.nextToken();
								absMaxMinor = stmixMax.nextToken();
							}

							if (!relA.equals("none"))
							{
								StringTokenizer stRelMin = new StringTokenizer(relA,"/");
								relMinCritical = stRelMin.nextToken();
								relMinMajor = stRelMin.nextToken();
								relMinMinor = stRelMin.nextToken();
							}

							if (!relB.equals("none"))
							{
								StringTokenizer stmixMax = new StringTokenizer(relB,"/");
								relMaxCritical = stmixMax.nextToken();
								relMaxMajor = stmixMax.nextToken();
								relMaxMinor = stmixMax.nextToken();
							}
						}
						
						hiddenObj.put("absMinCritical", absMinCritical);
						hiddenObj.put("relMinCritical", relMinCritical);
						hiddenObj.put("absMinMajor", absMinMajor);
						hiddenObj.put("relMinMajor", relMinMajor);
						hiddenObj.put("absMinMinor", absMinMinor);
						hiddenObj.put("relMinMinor", relMinMinor);
						hiddenObj.put("absMaxCritical", absMaxCritical);
						hiddenObj.put("relMaxCritical", relMaxCritical);
						hiddenObj.put("absMaxMajor", absMaxMajor);
						hiddenObj.put("relMaxMajor", relMaxMajor);
						hiddenObj.put("absMaxMinor", absMaxMinor);
						hiddenObj.put("relMaxMinor", relMaxMinor);
						hiddenDataObj.put(measure,hiddenObj);

						String minCritical = getThresholdValue("min",absMinCritical,relMinCritical);
						String minMajor = getThresholdValue("min",absMinMajor,relMinMajor);
						String minMinor = getThresholdValue("min",absMinMinor,relMinMinor);

						String maxCritical = getThresholdValue("max",absMaxCritical,relMaxCritical);
						String maxMajor = getThresholdValue("max",absMaxMajor,relMaxMajor);
						String maxMinor = getThresholdValue("max",absMaxMinor,relMaxMinor);
						String unit = tablesInfo.getUnitForMeasure(s_testName,measure);

						if (minCritical.equals("-")  && minMajor.equals("-") && minMinor.equals("-") && 
						maxCritical.equals("-") && maxMajor.equals("-") && maxMinor.equals("-"))
						{
							aListTestWithNoThresholds.add(measure);
							cellFlag = !cellFlag;
							continue;
						}
						else
						{
							isTestWithThresholds = true;
						}

						if (!heading_flag)
						{
							heading_flag = true;
						}

						String tempThresh = "";
						boolean isMinData = false;
						if(!minCritical.equals("-")  || !minMajor.equals("-") || !minMinor.equals("-"))
						{
							tempThresh += "Min|"+minCritical+"|"+minMajor+"|"+minMinor;
							isMinData = true;
						}

						if(!maxCritical.equals("-") || !maxMajor.equals("-") || !maxMinor.equals("-"))
						{
							if (isMinData)
							{
								tempThresh += "#Max|"+maxCritical+"|"+maxMajor+"|"+maxMinor;
							}
							else
							{
								tempThresh += "Max|"+maxCritical+"|"+maxMajor+"|"+maxMinor;
							}
						}
						measureDataObj.put(mappingInfo.getMeasureDescription(s_testName,measure),measure);
						threshValObj.put("Measure",mappingInfo.getMeasureDescription(s_testName,measure)+"  ("+unit+")");
						threshValObj.put("Threshold",tempThresh);
						threshValObj.put("action",action);
						measureValArr.add(threshValObj);
					}
					cellFlag = !cellFlag;
				}

				rootJson.put("toolTipMsg",toolTipMsg);
				rootJson.put("hiddenDataObj",hiddenDataObj);
				rootJson.put("measureValArr",measureValArr);

				if (aListTestWithNoThresholds != null && !aListTestWithNoThresholds.isEmpty())
				{
					JSONArray noMeasureValArr = new JSONArray();
					for (int d=0; d<aListTestWithNoThresholds.size(); d=d+3)
					{
						int k = 1;
						for (int e=d; e<d+3; e++)
						{
							if (e<aListTestWithNoThresholds.size())
							{
								String strMeasure = (String)aListTestWithNoThresholds.get(e);
								String tmpStyple="";
								if(k==1)
								{
								tmpStyple="border-left-width:1px";
								k++;
								}

							}
							else
							{
							}
						}
					}
					int d=0;
					while(d<aListTestWithNoThresholds.size())
					{
						JSONObject noMeasureThreshValObj = new JSONObject();
						String strMeasure1 = "";
						String strMeasure2 = "";
						String strMeasure = (String)aListTestWithNoThresholds.get(d);
						int count = d;
						if(!StringUtils.isNull(strMeasure))
						{
							measureDataObj.put(mappingInfo.getMeasureDescription(s_testName,strMeasure),strMeasure);
							strMeasure = mappingInfo.getMeasureDescription(s_testName,strMeasure);
						}
						else
							strMeasure = "";
						count = d+1;
						if(count < aListTestWithNoThresholds.size())
						{
							strMeasure1 = (String)aListTestWithNoThresholds.get(count);
							if(!StringUtils.isNull(strMeasure1))
							{
								measureDataObj.put(mappingInfo.getMeasureDescription(s_testName,strMeasure1),strMeasure1);
								strMeasure1 = mappingInfo.getMeasureDescription(s_testName,strMeasure1);
							}
						}
						count = d+2;
						if(count < aListTestWithNoThresholds.size())
						{
							strMeasure2 = (String)aListTestWithNoThresholds.get(count);
							if(!StringUtils.isNull(strMeasure2))
							{
								measureDataObj.put(mappingInfo.getMeasureDescription(s_testName,strMeasure2),strMeasure2);
								strMeasure2 = mappingInfo.getMeasureDescription(s_testName,strMeasure2);
							}
						}

						noMeasureThreshValObj.put("Measure1",strMeasure);
						noMeasureThreshValObj.put("Measure2",strMeasure1);
						noMeasureThreshValObj.put("Measure3",strMeasure2);
						noMeasureThreshValObj.put("action",action);
						noMeasureValArr.add(noMeasureThreshValObj);
						d = count+1;
					}
					rootJson.put("noMeasureValArr",noMeasureValArr);
				}
			}
			session.setAttribute("strTestName",s_testName);
			session.setAttribute("v_compare",v_temp);
		}
	}
	else
	{
		rootJson.put("isManagedCompAvailable",false);
		rootJson.put("NoData",_mapping.getTextDescription("admin.threshold.No Managed Components"));
	}
%>

<%!
	public String getArrayString (String [] a)
	{
		String s = "[ ";
		for (int i = 0; a.length>i; i++)
		{
			if (i != 0)
			{
				s += ", ";
			}
			s+="\""+a[i]+"\"";
		}
		s+=" ];";
		return s;
	}

	int alarmPolicyLength = 15;

	private String get1(String H)
	{
		String h;
		if (!(H.equals("-")))
		{
			if (H.indexOf("&") > -1)
			{
				StringTokenizer st = new StringTokenizer(H,"&");
				H = st.nextToken();
				h = st.nextToken();
			}
			else
			{
				if (H.indexOf("sqc") > -1)
				{
					h = H;
					H = "-";
				}
				else
				{
					h = "-";
				}
			}
		}
		else
		{
			h = "-";
		}
		return(H+"_"+h);
	}

	private Vector getAbsAndRel(String format)
	{
		Vector vect = new Vector();
		StringTokenizer stok1 = new StringTokenizer(format,"/");
		if (!format.equals("-1") && stok1.countTokens() == 3)
		{
			String H1 = stok1.nextToken();
			String h2=get1(H1);
			String M = stok1.nextToken();
			String m1=get1(M);
			String L = stok1.nextToken();
			String l1=get1(L);
			StringTokenizer h1 = new StringTokenizer(h2,"_");
			String High= h1.nextToken();
			String high = h1.nextToken();
			StringTokenizer m = new StringTokenizer(m1,"_");
			String Mid = m.nextToken();
			String mid = m.nextToken();
			StringTokenizer l = new StringTokenizer(l1,"_");
			String Low = l.nextToken();
			String low = l.nextToken();
			StringBuffer sb2 = new StringBuffer();
			StringBuffer sb1 = new StringBuffer();
			String s1 = null;
			if (High.equals("-") && Mid.equals("-") && Low.equals("-"))
			{
				s1 = "none";
			}
			else
			{
				sb1.append(High);
				sb1.append("/");
				sb1.append(Mid);
				sb1.append("/");
				sb1.append(Low);
				s1 = sb1.toString();
			}
			String s2 = null;
			if (high.equals("-") && mid.equals("-") && low.equals("-"))
			{
				vect.add(s1);
				vect.add("none");
			}
			else
			{
				sb2.append(high);
				sb2.append("/");
				sb2.append(mid);
				sb2.append("/");
				sb2.append(low);
				s2 = sb2.toString();
				vect.add(s1);
				vect.add(s2);
			}
		}
		else
		{
			vect.add("none");
			vect.add("none");
		}
		return vect;
	}

	private String getThresholdValue(String grpFunction, String absValue,String relValue)
	{
		String strValue = "-";

		if (absValue.equals("-") && relValue.equals("-"))
		{
			strValue = "-";
		}
		else if (!absValue.equals("-") && !relValue.equals("-"))
		{
			strValue = grpFunction+"("+absValue+", "+getRelativeThreshold(relValue)+")";
		}
		else if (!absValue.equals("-"))
		{
			strValue = changeFormat(absValue);
		}
		else if (!relValue.equals("-"))
		{
			strValue = getRelativeThreshold(relValue);
		}

		return strValue;
	}

	private String getRelativeThreshold(String relValue)
	{
		//relValue: 3*sqc
		String strValue = "";
		if (relValue.indexOf("*") != -1)
		{
			int idx = relValue.indexOf("*");
			String s1 = relValue.substring(0,idx);
			double d_value = Double.valueOf(s1.trim()).doubleValue();
			d_value = d_value * 100;
			int i_value = (new Double(d_value)).intValue();
			strValue = Integer.toString(i_value) + "% of auto";
		}
		else
		{
			strValue = "auto";
		}
		return strValue;
	}
	private String changeFormat(String value){
		String strValue = value;
		if(value !=null && value.trim().length()>0 && value.indexOf("*") != -1){
			int idx = value.indexOf("*");
			String s1 = value.substring(0,idx);
			double d_value = Double.valueOf(s1.trim()).doubleValue();
			d_value = d_value * 100;
			int i_value = (new Double(d_value)).intValue();
			strValue = Integer.toString(i_value) + "% of auto";
		}
		return strValue;
	}
%>

<%
	rootJson.put("screenlabels",screenLabels);
	rootJson.put("hiddenObj",hiddenObj);
	rootJson.put("measureDataObj",measureDataObj);

	out.println(rootJson.toString());
	//if(request.getQueryString()!=null)
	//{
	//	//session.setAttribute("adminLastAccessedURL","/final/admin/EgGroupThreshold.jsp?"+request.getQueryString());
	//}
%>



