<%
/*
 *   File		:	EgEnableDisableTestsJson.jsp
 *   Purpose	:	To build screenlabels,component types and tests
 *   Author		:	Saranya (2013)
*/
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgRoleInfo" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgUsersInfo"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%@ page import = "net.sf.json.*"%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String componentType = request.getParameter("componentType");
	String testType = request.getParameter("testType");
	testType = (testType == null)?"PerformanceTest":testType;

	String pfSelected = "";
	String cfSelected = "";
	String checkEnabledTests = "";//getActualName() of the tests
	String checkDisabledTests = "";//getActualName() of the tests
	if (testType.equalsIgnoreCase("PerformanceTest"))
	{
		pfSelected = "selected";
	}
	else
	{
		cfSelected = "selected";
	}

	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgUsersInfo usersInfo = new EgUsersInfo();
	String usrBasedTests = "";
	if (usersInfo.isUserBasedLicense())
	{
		if(componentType!= null && !componentType.equals(""))
		{
			ArrayList userBasedTests = usersInfo.getUserBasedTests(componentType);
			for (int i=0; i<userBasedTests.size(); i++)
			{
				String test = userBasedTests.get(i).toString();
				if(usrBasedTests.equals(""))
				{
					usrBasedTests += test;
				}
				else
				{
					usrBasedTests += ","+test;
				}
			}
		}
	}
	rootJson.put("usrBasedTests",usrBasedTests);

	boolean IGELLicensingSupported = EgInstallInfo.isEUCEndPointsLicense;
	String igelLicenseBasedTests = "";
	if (IGELLicensingSupported)
	{
		EgEndPointsInfo endPntUserInfo = new EgEndPointsInfo();
		if(componentType!= null && !componentType.equals(""))
		{
			HashMap typeNTests = (HashMap) endPntUserInfo.getEUCEEndPointTypesAndTests();
			String testNames = (String)typeNTests.get(componentType);
			if (!com.egurkha.util.StringUtils.isNull(testNames))
			{
				ArrayList igelLicenseTests = com.egurkha.util.StringUtils.egTokenizer(testNames,",");
				for (int i=0; i<igelLicenseTests.size(); i++)
				{
					String test = igelLicenseTests.get(i).toString();
					if(igelLicenseBasedTests.equals(""))
					{
						igelLicenseBasedTests += test;
					}
					else
					{
						igelLicenseBasedTests += ","+test;
					}
				}
			}
		}		
	}
	rootJson.put("igelLicenseBasedTests",igelLicenseBasedTests);

	//O365 Licensing starts
	boolean O365LicensingSupported = EgInstallInfo.isO365UsersLicense;
	ArrayList msTests = new ArrayList();
	String o365LicenseBasedTests = "";
	if (O365LicensingSupported)
	{
		EgMsUsersInfo msUserInfo = new EgMsUsersInfo();
		if(componentType!= null && !componentType.equals(""))
		{
			HashMap typeNTests = (HashMap) msUserInfo.getO365TypesAndTests();
			String testNames = (String)typeNTests.get(componentType);
			if (!com.egurkha.util.StringUtils.isNull(testNames))
			{
				ArrayList o365LicenseTests = com.egurkha.util.StringUtils.egTokenizer(testNames,",");
				for (int i=0; i<o365LicenseTests.size(); i++)
				{
					String test = o365LicenseTests.get(i).toString();
					if(o365LicenseBasedTests.equals(""))
					{
						o365LicenseBasedTests += test;
					}
					else
					{
						o365LicenseBasedTests += ","+test;
					}
				}
			}			
		}
	}
	else
	{
		EgMsUsersInfo msUsers = new EgMsUsersInfo();
		ArrayList msTypes = msUsers.getMsTypes();
		if (componentType != null && msTypes.contains(componentType))
		{
			msTests = msUsers.getMSTestsForAgentGenerator();
		}
	}
	rootJson.put("o365LicenseBasedTests",o365LicenseBasedTests);
	//O365 Licensing  ends

	//tell whether _cf test enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}
	rootJson.put("isConfigSupported",isConfigSupported);

	String[] componentTypes = ri.getServerTypes();
	ArrayList serverList = null;
	if (componentTypes != null && componentTypes.length > 0)
	{
		serverList = new ArrayList(Arrays.asList(componentTypes));
		serverList.remove("Site_servers");
	}

	IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
	String defaultTestMappingSection = "DEFAULT_TEST_MAPPING";
	String testMappingSection = "TEST_MAPPING";

	ArrayList aListTests = new ArrayList();
	ArrayList aListEnabledTests = new ArrayList();
	ArrayList aListDisabledTests = new ArrayList();

	if (componentType != null && !componentType.equalsIgnoreCase("null"))
	{
		String strTests = egSpecsIni.getValue(defaultTestMappingSection,componentType);
		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		if (testType.equalsIgnoreCase("PerformanceTest"))
		{
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (EgInstallInfo.isConfigTest(strToken)) continue;
				aListTests.add(strToken);
			}
		}
		else
		{
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (EgInstallInfo.isConfigTest(strToken))
				{
					aListTests.add(strToken);
				}
			}
		}

		String strEnabledTests = egSpecsIni.getValue(testMappingSection,componentType);
		strTokens = new StringTokenizer(strEnabledTests,",");
		if (testType.equalsIgnoreCase("PerformanceTest"))
		{
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (EgInstallInfo.isConfigTest(strToken)) continue;
				if (msTests.contains(strToken))
				{
					continue;
				}
				aListEnabledTests.add(strToken);
			}
		}
		else
		{
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (EgInstallInfo.isConfigTest(strToken))
				{
					aListEnabledTests.add(strToken);
				}
			}
		}

		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			if (aListEnabledTests.contains(strTest)) continue;
			if (msTests.contains(strTest))
			{
				continue;
			}
			aListDisabledTests.add(strTest);
		}
	}

	rootJson.put("updateUrl","EnableDisableTests/data/EgEnableDisableTestsp.jsp?");

	screenLabels.put("NamedUserAlert",_mapping.getTextDescription("admin.test.The following test(s) cannot be disabled as these tests are required for validating named user counts for eG licensing")+".");
	screenLabels.put("O365LicenseAlert",_mapping.getTextDescription("admin.test.The following test(s) cannot be disabled as these tests are required for validating O365 user counts for eG licensing")+".");
	screenLabels.put("IGELLicenseAlert",_mapping.getTextDescription("admin.test.The following test(s) cannot be disabled as these tests are required for validating endpoints user counts for eG licensing")+".");
	screenLabels.put("NamedUserAlertName",_mapping.getTextDescription("admin.test.Test name(s)")+":");
	screenLabels.put("admin.server.Component type",_mapping.getTextDescription("admin.server.Component type"));
	screenLabels.put("admin.test.Test type",_mapping.getTextDescription("admin.test.Test type"));
	screenLabels.put("admin.test.Please choose a component type",_mapping.getTextDescription("admin.test.Please choose a component type"));
	screenLabels.put("admin.test.Please choose atleast one test to enable or disable",_mapping.getTextDescription("admin.test.Please choose atleast one test to enable or disable"));

	JSONArray CompType = new JSONArray();
	JSONObject compTypeObj = new JSONObject();

	if (isConfigSupported)
	{
		if (componentTypes != null && componentTypes.length > 0)
		{
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component type"));
			compTypeObj.put("valueField","-1");
			CompType.add(compTypeObj);

			serverList = sorter.getSortedCompTypeList(serverList);
			//get the actual and display names of component types
			for (int j=0;j<serverList.size();j++)
			{
				EgName nameObj = (EgName)serverList.get(j);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();

				compTypeObj.put("displayField",tmpDis);
				compTypeObj.put("valueField",tmpVal);
				CompType.add(compTypeObj);
			}
			rootJson.put("ComponentType",CompType);
		}
		else
		{
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			compTypeObj.put("valueField","-1");
			CompType.add(compTypeObj);

			rootJson.put("ComponentType",CompType);
		}
		JSONArray testTypeVal = new JSONArray();
		JSONObject testTypeObj = new JSONObject();

		testTypeObj.put("displayField",_mapping.getTextDescription("admin.test.Performance"));
		testTypeObj.put("valueField","PerformanceTest");
		testTypeVal.add(testTypeObj);

		testTypeObj.put("displayField",_mapping.getTextDescription("admin.test.Configuration"));
		testTypeObj.put("valueField","ConfigurationTest");
		testTypeVal.add(testTypeObj);

		rootJson.put("TestType",testTypeVal);
	}
	else
	{
		if (componentTypes != null && componentTypes.length > 0)
		{
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component type"));
			compTypeObj.put("valueField","-1");
			CompType.add(compTypeObj);

			serverList = sorter.getSortedCompTypeList(serverList);
			//get the actual and display names of component types
			for (int j=0;j<serverList.size();j++)
			{
				EgName nameObj = (EgName)serverList.get(j);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();

				compTypeObj.put("displayField",tmpDis);
				compTypeObj.put("valueField",tmpVal);
				CompType.add(compTypeObj);
			}
		}
		else
		{
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			compTypeObj.put("valueField","-1");
			CompType.add(compTypeObj);
		}
		rootJson.put("ComponentType",CompType);
	}

	if (componentType != null && !componentType.equalsIgnoreCase("null") && !componentType.equals("-1") && 
		aListEnabledTests.isEmpty() && aListDisabledTests.isEmpty())
	{
		screenLabels.put("No Configuration Tests Available",_mapping.getTextDescription("admin.test.No configuration tests are available for this component type"));
	}
	else
	{
		screenLabels.put("admin.test.ENABLED TESTS",_mapping.getTextDescription("admin.test.Enabled Tests"));

		JSONArray allTests = new JSONArray();
		JSONObject allObj = new JSONObject();
		aListEnabledTests=sorter.getSortedTestList(aListEnabledTests);
		for (int i=0;i<aListEnabledTests.size();i++)
		{
			EgName name = (EgName)aListEnabledTests.get(i);
			String enableVal = name.getActualName();
			String enableDis = name.getLocalName();
			checkEnabledTests = checkEnabledTests+","+enableVal;

			allObj.put("displayField",enableDis);
			allObj.put("valueField",enableVal);
			allTests.add(allObj);
		}

		screenLabels.put("admin.test.DISABLED TESTS",_mapping.getTextDescription("admin.test.Disabled Tests"));

		JSONArray disabledTests = new JSONArray();
		aListDisabledTests = sorter.getSortedTestList(aListDisabledTests);
		for (int j=0;j<aListDisabledTests.size();j++)
		{
			EgName name = (EgName)aListDisabledTests.get(j);
			String disableVal = name.getActualName();
			String disableDis = name.getLocalName();
			checkDisabledTests = checkDisabledTests+","+disableVal;
			disabledTests.add(disableVal);

			allObj.put("displayField",disableDis);
			allObj.put("valueField",disableVal);
			allTests.add(allObj);
		}
		rootJson.put("disabledTests",disabledTests);
		rootJson.put("allTests",allTests);

		if(!(checkEnabledTests.equalsIgnoreCase("") || checkEnabledTests.equalsIgnoreCase("null")))
		{
			if(checkEnabledTests.startsWith(","))
			{

				checkEnabledTests = checkEnabledTests.substring(1,checkEnabledTests.length());
			}
		}
		rootJson.put("checkEnabledTests",checkEnabledTests);

		if(!(checkDisabledTests.equalsIgnoreCase("") || checkDisabledTests.equalsIgnoreCase("null")))
		{
			if(checkDisabledTests.startsWith(","))
			{
				checkDisabledTests = checkDisabledTests.substring(1,checkDisabledTests.length());
			}
		}
		rootJson.put("checkDisabledTests",checkDisabledTests);

		screenLabels.put("admin.common.Update",_mapping.getTextDescription("admin.common.Update"));

	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgEnableDisableTests.jsp?componentType="+componentType+"&testType="+testType+"&hideBtn=true");

	rootJson.put("screenLabels",screenLabels);
//	System.out.println("rootJson____"+rootJson);
	out.println(rootJson.toString());
%>



