<%
/**
 *	File name	:	Egconfigremoteagentsp.jsp
 *	Author		:	Babu S
 *	Purpose		:	Process page for EgConfigRemoteAgents.jsp
 *	Version		:	3.0
 *	Created		:	10/18/2003
 *	Modified	:	16/07/2004	Arun	Allows an associated host to be associated to another remote agent
 *										and removed existing association from the DB.
 */
 %>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import = "com.eg.RemoveExtAgent" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.IniHelper" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.EgDBConnectUI" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.UpdateAndTransmitTrendInfo" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<html>
<body>
<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>
<jsp:useBean id="servicer" scope="page" class="egurkha.ServiceBean"/>


<%!
	String newValues = "None,None,None,None,22";
	//com.eg.IniFile iniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_testinfo.ini",true);
%>

<%
	/*
	 * Will contain hosts to be disassociated.
	 */
	String s_eghosts = request.getParameter("fmanage");
	/*
	 * Will contain hosts to be associated.
	 */
	String s_newagenthosts = request.getParameter("funmanage");
	String existingAgents = request.getParameter("existingAgents");
	/*
	 * The selected remote agent.
	 */
	String selectedRemAgent = request.getParameter("eagent");

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Remote Agents");
	auditLogThread.setValue("Activity","Assign");

	ArrayList lostComponentsList = null;
	String lostComponents[] = null;
	lostComponents = StringUtils.getTokens(s_eghosts,",");
	if(lostComponents != null && lostComponents.length>0)
		lostComponentsList = new ArrayList(Arrays.asList(lostComponents));
	else
		lostComponentsList = new ArrayList();

	ArrayList lostList = new ArrayList();
	for (int r=0; r<lostComponentsList.size(); r++)
	{
		String me = (String) lostComponentsList.get(r);
		if (me == null || me.trim().length() == 0)
			continue;
		if (!lostList.contains(me))
			lostList.add(me);
	}

	ArrayList newlyAddedComponentsList = null;
	String newlyAddedComponents[] = null;
	newlyAddedComponents = StringUtils.getTokens(s_newagenthosts,",");
	if(newlyAddedComponents != null && newlyAddedComponents.length>0)
		newlyAddedComponentsList = new ArrayList(Arrays.asList(newlyAddedComponents));	
	else
		newlyAddedComponentsList = new ArrayList();
		
	ArrayList newList = new ArrayList();
	for (int r=0; r<newlyAddedComponentsList.size(); r++)
	{
		String me = (String) newlyAddedComponentsList.get(r);
		if (me == null || me.trim().length() == 0)
			continue;
		if (!newList.contains(me))
			newList.add(me);
	}
	
	List disAssocHosts = new LinkedList();
	//String[] disAssocHostTokens = StringUtils.getTokens(s_eghosts, EgConstants.COMMA);
	String[] disAssocHostTokens = StringUtils.getTokens(s_newagenthosts, EgConstants.COMMA);

	disAssocHosts.addAll(Arrays.asList(disAssocHostTokens));

	List assocHosts = new LinkedList();
	String[] assocHostTokens = StringUtils.getTokens(s_newagenthosts, EgConstants.COMMA);
	assocHosts.addAll(Arrays.asList(assocHostTokens));

	trans.createFile("eg_external.ini");

	/*
	 * Go through list of associated hosts and see if any of them are associated to
	 * any other remote agent. If so, add that host to the disassociated list also.
	 */
	Map oldConfig = new HashMap();
	Map oldAgents = new HashMap();
	for (Iterator i=assocHosts.iterator(); i.hasNext(); )
	{
		String host = (String)i.next();
		String prevAgent = trans.getStrValue("Remote_Agent_Mapping_Section", host);
		String prevConfig = trans.getStrValue("Agentless_Infos_Section", host);
		if (!StringUtils.isNull(prevConfig))
			oldConfig.put(host, prevConfig);
		if (!StringUtils.isNull(prevAgent))
			oldAgents.put(host, prevAgent);
	}

	if (assocHosts.indexOf(selectedRemAgent) > -1)
	{
		Vector sess_vec = new Vector();
		sess_vec.addElement(_mapping.getTextDescription("admin.common.Remote Agents Configuration"));
		sess_vec.addElement("EgConfigRemoteAgents.jsp?eagent=" + selectedRemAgent);
		sess_vec.addElement(_mapping.getTextDescription("admin.common.Remote Agents Configuration"));
		sess_vec.addElement(_mapping.getTextDescription("admin.common.A host cannot be associated to a remote agent of the same name")+"-<br>");
		sess_vec.addElement(selectedRemAgent);
		session.setAttribute("vec_Errors", sess_vec);
%>
	<jsp:forward page="EgErrors.jsp" />
<%
	}

	/*
	 * Now disassociate hosts from eg_external.ini and the DB.
	 */
	IniFile externalWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_external.ini");
	for (Iterator i=disAssocHosts.iterator(); i.hasNext(); )
	{
		String host = (String)i.next();
		externalWr.deleteValue("Remote_Agent_Mapping_Section", host);
		externalWr.deleteValue("Agentless_Infos_Section", host);
	}
	externalWr.saveFile();
	EgConfigFilesSync.releaseInstance(externalWr);

	/*
	 * Stop discovery so that eg_agents.ini is not overwritten while db activity takes place
	 */
	servicer.stopDiscovery();
	boolean completed = false;
	Vector v_pair = new Vector();
	Vector pair = new Vector();
	try
	{
		com.eg.IniFile iniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_testinfo.ini",true);
		for (Iterator i=disAssocHosts.iterator(); i.hasNext(); )
		{
			String host = (String)i.next();
			String prevAgent = (String)oldAgents.get(host);

			/*
			 * If a previous agent does not exist,
			 * disassociate from the currently selected remote agent
			 */
			if (StringUtils.isNull(prevAgent))
			{
				prevAgent = selectedRemAgent;
			}
			String[] disabledInfos = iniFile.getVariables(prevAgent);
			if (disabledInfos!=null)
			{
				for (int zz = 0; zz < disabledInfos.length; zz++ )
				{
					//System.out.println("Alagu coming here disabled descriptors "+disabledInfos[zz]);
					String var = disabledInfos[zz];
					if (var.indexOf(host) < 0)
						continue;
					String val=iniFile.getValue(prevAgent,var);
					var = var.substring(0,var.indexOf("#")+1);
					
					ArrayList tokens = StringUtils.egTokenizer(var,":");
					int size =tokens.size();
					if (size == 3)
					{
						if (var.endsWith(":"+host+"#"))
						{
							iniFile.setValue(selectedRemAgent,disabledInfos[zz],val);
							iniFile.deleteValue(prevAgent,disabledInfos[zz]);
						}
					}else if (size == 4)
					{
						String hostName=(String)tokens.get(2);
						if (hostName.equals(host))
						{
							iniFile.setValue(selectedRemAgent,disabledInfos[zz],val);
							iniFile.deleteValue(prevAgent,disabledInfos[zz]);
						}
					}
				}
			}
			iniFile.saveFile();
			EgConfigFilesSync.releaseInstance(iniFile);
			pair.add(prevAgent);
			pair.add(host);
			v_pair.add(pair);
		}
		UpdateAndTransmitTrendInfo trendInfo = new UpdateAndTransmitTrendInfo();
		Vector param = new Vector();
		param.add("Egconfigremoteagentsp");
		param.add(v_pair);
	//	System.out.println("V_PAIR is "+ v_pair);
		completed = trendInfo.removeAgentForTarget(param);
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}

	if (completed)
	{
		/*
		 * Now associate the new hosts
		 */
		EgExternalInfo externalInfo = new EgExternalInfo("manager");
		IniFile agentsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
		List iniEntriesList = new ArrayList();
		IniFile extWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_external.ini");
		for (Iterator i=assocHosts.iterator(); i.hasNext(); )
		{
			String host = (String)i.next();
			// Fix starts to retain the test configuration details while changing the remoteagent
			String remAgent = externalInfo.getRemoteAgentForHost(host);
			String vars[] = agentsIni.getVariables(remAgent);
			
			for (int v=0;v < vars.length; v++)
			{
				String variable = vars[v];
				if (variable.indexOf(":"+host+":") > -1 || variable.endsWith(":"+host))
				{
					String value = agentsIni.getValue(remAgent,variable);
					if (value.startsWith("-manual"))
					{
						iniEntriesList.add(new IniHelper(selectedRemAgent,variable,value));							
					}
				}
			}
			// Fix ends
			extWr.setValue("Remote_Agent_Mapping_Section", host, selectedRemAgent);

			String prevConfig = (String)oldConfig.get(host);
			if (StringUtils.isNull(prevConfig))
			{
				prevConfig = newValues;
			}
			
			extWr.setValue("Agentless_Infos_Section", host, prevConfig);
			extWr.deleteValue("Internal_Agent_Mapping", host);
		}
		extWr.saveFile();
		EgConfigFilesSync.releaseInstance(extWr);
		if (iniEntriesList.size() > 0)
		{
			//IniFile agentsFileWr  = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini",true);
			IniFile agentsFileWr  = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
			for(int ii=0; ii<iniEntriesList.size(); ii++)
			{
				IniHelper iniHr = (IniHelper)iniEntriesList.get(ii);
				String sub = iniHr.getSubject();
				String var = iniHr.getVariable();
				String val = iniHr.getValue();
				agentsFileWr.setValue(sub,var,val);
			}
			agentsFileWr.saveFile();
			EgConfigFilesSync.releaseInstance(agentsFileWr);
		}
		boolean done = false;
		if (lostList.size() > 0)
		{
			String s = "";
			for (int i=0; i<lostList.size(); i++)
			{ 
				String me = (String) lostList.get(i);
				s+=me+",";
			}
			if (s.length() > 0)
				s = s.substring(0,s.length()-1);
			done = true;
			auditLogThread.setCurrentValue("Disassociated component(s)",s);
		}
		if (newList.size() > 0)
		{
			String s = "";
			for (int i=0; i<newList.size(); i++)
			{ 
				String me = (String)newList.get(i);
				String old = (String) oldAgents.get(me);
			//	System.out.println("OLD "+ old);
				s+=me;
				if (old != null)
					s +=" (Previous remote agent:"+ old+")";
				s+=",";
			}
		//	System.out.println("S is "+ s);
			if (s.length() > 0)
				s = s.substring(0,s.length()-1);
			done = true;
			auditLogThread.setCurrentValue("Associated component(s)",s);
		}
		auditLogThread.setValue("Description","Hosts are associated to remote agent " + selectedRemAgent);
		if (done)
			auditLogThread.sendItToDB();
		/* code for auditlog ends */

		//trans.saveFile();
		//iniFile.saveFile();
		servicer.startDiscovery("1");
%>
	<jsp:forward page="EgConfigRemoteAgents.jsp">
		<jsp:param name="eagent" value="<%=selectedRemAgent%>" />
	</jsp:forward>
<%
	}
	else
	{
		servicer.startDiscovery("1");

		Vector sess_vec = new Vector();
		sess_vec.addElement(_mapping.getTextDescription("admin.common.Remote Agents Configuration"));
		sess_vec.addElement("EgConfigRemoteAgents.jsp?eagent=" + selectedRemAgent);
		sess_vec.addElement(_mapping.getTextDescription("admin.common.Remote Agents Configuration"));
		sess_vec.addElement(_mapping.getTextDescription("admin.common.The association/disassociation of hosts could not be completed")+".");
		session.setAttribute("vec_Errors", sess_vec);
%>
	<jsp:forward page="EgErrors.jsp" />
<%
	}

%>
</body>
</html>






