<%
/***********************************************************************************
*	Name			:EgSettingsTreeUI.jsp
*   Purpose			:This page shows Monitor ,Manager , Logo and Messages all these activities in the Settings page
*	Version			:5.2
*	CreationDate	:20/3/2012
*	Author			:Chittibabu.k
***********************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.egurkha.EgUserPermission"%>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	boolean hasMonitorTab = userRole.hasAnyMonitorRole(EgUserPermission.MONITOR);
	boolean hasReporterTab = userRole.hasAnyReporterRole(EgUserPermission.REPORTER);
	boolean hasConfigTab = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	String highLightNode =request.getParameter("highLightNode").trim();
	if(highLightNode == null || highLightNode.equalsIgnoreCase("null"))
	{
		highLightNode="";
	}
%>

<html>
<head>
<title>
</title>
<egui:skin ui="admin"/>
<script language="javascript" src="../scripts/<%=script_src%>"></script>
<script language="javascript" src="/final/admin/eg_scripts/MonitorTree.js"></script>
</head>
<body style="overflow:auto;" class="padding4" scrolling="auto" >
	<div id="treeDiv">
		<script type="text/javascript">
		var d = new dTree('d');
		d.add('0','-1','<egui:intnl text="admin.settings.Settings"/>','','SETTINGS','MonitorView','','',true,-1);

		//maintree
		d.add('1','0',"Monitor Settings",'','Monitor Settings','MonitorView','','',true,-1);
		d.add('2','0',"Manager Settings",'','Manager Settings','MonitorView','','',true,-1);
		d.add('3','0',"Logo Messages",'','Logo Messages','MonitorView','','',true,-1);

		//monitree
		d.add('4','1',"General",'','General','MonitorView','','',true,-1);
		d.add('5','4','Refresh','./egui.jsp?process=refresh&from=monitree','Refresh','MonitorView');
		d.add('6','4','Alarms','./egui.jsp?process=alarms&from=monitree','Alarms','MonitorView');
		d.add('7','4','Graphs','./egui.jsp?process=graphs&from=monitree','Graphs','MonitorView');
		d.add('8','4','Other Display Settings','./egui.jsp?process=othersettings&from=monitree','Other Display Settings','MonitorView');
		d.add('9','1',"Measures At A Glance",'','Measures At A Glance','MonitorView','','',true,-1);
		d.add('10','9','Enable/Disable Metrics','./minmaxConfig.jsp?process=enable/disable&from=monitree&from=monitree','Enable/Disable Metrics','MonitorView');
		d.add('11','9','Add a New Measure','./minmaxConfig.jsp?process=new&from=monitree','Add a New Measure Metrics','MonitorView');
		d.add('12','9','Configured Measures','./minmaxConfig.jsp?process=existingmeasure&from=monitree','Configured Measures','MonitorView');

		//mgrstree
		d.add('13','2','General','./managerSettings.jsp?process=general&from=mgrstree','General','MonitorView');
		d.add('14','2','Discovered Components Pop-up','./managerSettings.jsp?process=discompopup&from=mgrstree','Discovered Components pop_up','MonitorView');
		d.add('15','2','Test Configuration','./managerSettings.jsp?process=testconfig&from=mgrstree','Test Configuration','MonitorView');
		d.add('16','2','Threshold Configuration','./managerSettings.jsp?process=thresholdconfig&from=mgrstree','Threshold Configuration','MonitorView');
		d.add('17','2','Command Execution','./managerSettings.jsp?process=commandexecution&from=mgrstree','Command Execution','MonitorView');
		d.add('18','2','TT Manager','./managerSettings.jsp?process=ttmanagercli&from=mgrstree','TT Manager','MonitorView');
		d.add('19','2','Log Settings','./managerSettings.jsp?process=logsettings&from=mgrstree','Log Settings','MonitorView');
		d.add('20','2','Auditing','./managerSettings.jsp?process=auditing&from=mgrstree','Auditing','MonitorView');
		d.add('21','2','Advanced Settings','./managerSettings.jsp?process=advancedmgrsettings&from=mgrstree','Advanced Manager Settings','MonitorView');
		d.add('22','2','Capacity Planning','./managerSettings.jsp?process=capacityplanning&from=mgrstree','Capacity Planning','MonitorView');
		d.add('28','2','Virtual Topology','./managerSettings.jsp?process=virtualtopology&from=mgrstree','Virtual Topology','MonitorView');

		//logotree
		d.add('22','3','Login Screen','./EgConfigLogoMsg.jsp?process=loginscreen&from=logotree','Login Screen','MonitorView');
<%
	if(hasMonitorTab)
	{
%>
		d.add('23','3','Monitor Interface','./EgConfigLogoMsg.jsp?process=monitorinterface&from=logotree','Monitor Interface','MonitorView');
<%	
	}

	if(EgInstallInfo.isReporterSupported)
	{
		if(hasReporterTab)
		{
%>
		d.add('24','3','Reporter Interface','./EgConfigLogoMsg.jsp?process=reporterinterface&from=logotree','Reporter Interface','MonitorView');
<%
		}
	}
	if(EgInstallInfo.isConfigSupported)
	{
		if(hasConfigTab)
		{
%>
		d.add('25','3','Configuration Management Interface','./EgConfigLogoMsg.jsp?process=configmanageinterface&from=logotree','Configration Management Interface','MonitorView');
<%
		}
	}
%>
		d.add('26','3','Audible Alerts','./EgConfigLogoMsg.jsp?process=audiblealerts&from=logotree','Audible Alerts','MonitorView');
		d.add('27','3','Messages','./EgConfigLogoMsg.jsp?process=messages&from=logotree','Messages','MonitorView');
		document.write(d);
		d.closeAll();
		d.highlightNodeByProcess("<%=highLightNode%>");
		
		</script>
		<table border="0" cellpadding="2" cellspacing="0">
			<tr>
				<td><a class="eg_adminlink" href="javascript:void(0);" onclick="d.oAll(true);">
				    <egui:intnl text="admin.settings.Expand All"/></a></td>
				<td>&nbsp;|&nbsp;</td>
				<td><a class="eg_adminlink" href="javascript:void(0);" onclick="d.oAll(false);">
				     <egui:intnl text="admin.settings.Close All"/></a></td>
			</tr>
		</table>
	</div>
</body>
</html>



