<%
/*******************************************************************************
*
*	Name			:	EgReplicateUserp.jsp
*	Purpose			:	This jsp is used for processing replicating users.
*	Version			:	
*	CreationDate	:	12/05/2012
*	LastModified	:	
*	Author			:	Abdul Khader
*	Design Changes	:	
*******************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file = "EgTrackerA.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.*"%>
<%@ page import = "egurkha.UserBean"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@	page import="com.egurkha.util.StringUtils"%>

<%
	String uname = request.getParameter("uname");
	String password = request.getParameter("password");
	String expiry_date = request.getParameter("expiry_date");
	expiry_date = request.getParameter("dateforpro");
	String never = request.getParameter("Never");
	String tomailid = request.getParameter("mailidormobile");
	String mailid = "";
	if(tomailid != null && !tomailid.equals(""))
	{
		mailid = "To:" + tomailid;
	}
	else
	{
		tomailid = "&nbsp";
	}
	String timezone = request.getParameter("timeZone");
	String language = request.getParameter("languageName");
	String userAuthentication = request.getParameter("authentication");
	String operationType = request.getParameter("operation");
	String grpName = request.getParameter("grpname");
	String domainName = request.getParameter("domain");
	String existingUser = request.getParameter("uid");
	String mappedUI = "";
	String languageName = "";

	int usersCount = 1;
	if (grpName.indexOf("|#|") > 0)
	{
		ArrayList usersToAdd = StringUtils.myTokenizer(grpName,"|#|");
		usersCount = usersToAdd.size();
	}
	

	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	Object langCodes[] = egUi.getVariables("COUNTRY_AND_LANGUAGE_CODE");
	for(int i=0;i<langCodes.length;i++)
	{
		String countryName=egUi.getValue("COUNTRY_AND_LANGUAGE_CODE",(String)langCodes[i]);
		if (language.equals(countryName))
		{
			languageName = (String)langCodes[i];
		}
	}

	ArrayList aListUserAttributes = new ArrayList();
	ArrayList aListCategoriesForReplication = new ArrayList();
	HashMap mapToUI = new HashMap();

	if ((never != null) && (never.equals("Never")))
	{
		expiry_date = "12/12/9999";
	}

	if (domainName==null || domainName.equals("null"))
	{
		domainName="";
	}

	if (userAuthentication==null || userAuthentication.equalsIgnoreCase("Eg"))
	{
		domainName="";
		if (existingUser.indexOf("(Group)") != -1)
		{
			String modifiedGroup = existingUser.substring(0,existingUser.indexOf('/'))+"/Grp";
			String onlyName = (existingUser.substring(existingUser.indexOf('/'),existingUser.indexOf("(Group)"))).trim();
			existingUser = modifiedGroup+onlyName;
		}
	}
	else
	{
		if (operationType != null && operationType.equalsIgnoreCase("Group"))
		{
			if (grpName != null && grpName.length() > 0)
			{
				//uname = domainName + "/Grp/" + grpName;
				if (existingUser.indexOf("(Group)") != -1)
				{
					String modifiedGroup = existingUser.substring(0,existingUser.indexOf('/'))+"/Grp";
					String onlyName = (existingUser.substring(existingUser.indexOf('/'),existingUser.indexOf("(Group)"))).trim();
					existingUser = modifiedGroup+onlyName;
				}
			}
		}
		else
		{
			uname=domainName+"/"+uname;
			password="NONE";
			if (existingUser.indexOf("(Group)") != -1)
			{
				String modifiedGroup = existingUser.substring(0,existingUser.indexOf('/'))+"/Grp";
				String onlyName = (existingUser.substring(existingUser.indexOf('/'),existingUser.indexOf("(Group)"))).trim();
				existingUser = modifiedGroup+onlyName;
			}
		}
	}
	String categoryArray[] = {"User Info & Preference","Infrastructure Elements","Live Graph","Quick Insights","Favorite Measures","Favorites","Schedules","Configuration","Custom Dashboards","Quick Menus","Mail Alerts(Exclude)"};
	
	mapToUI.put("User_Preferences","User Information & Preferences");
	mapToUI.put("Infrastructure_Elements","Infrastructure Elements");
	mapToUI.put("Exclude_Mail_Alerts","Exclude Mail Alerts");
	mapToUI.put("Live_Graph","Live Graph");
	mapToUI.put("Quick_Insights","Quick Insights");
	mapToUI.put("Favorite_Measures","Favorite Measures");
	mapToUI.put("Custom_Dashboards","Custom Dashboards");
	mapToUI.put("Favorites","Favorites");
	mapToUI.put("Schedules","Schedules");
	mapToUI.put("Configuration_Data","Configuration Settings");
	mapToUI.put("Quick_Menus","Quick Links");

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","User Management");

	// License check starts
	UserBean userBean = new UserBean();
	String str_usercon = "";
	boolean userFlag = false;
	Vector sess_vec = new Vector();
	try
	{
		str_usercon=userBean.setConnection();
		userFlag=userBean.checkMonitorUser(usersCount);
		if(!userFlag)
		{
			userBean.releaseConnection(false);
			sess_vec.removeAllElements();
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Delete User Page"));
			sess_vec.addElement("EgDeleteUser.jsp");
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Add new user"));
			sess_vec.addElement(_mapping.getTextDescription("admin.error.You have exceeded the number of users allowed by your license")+".<BR>");
			sess_vec.addElement(_mapping.getTextDescription("admin.error.To support additional users")+", "+_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>");
			session.putValue("vec_Errors",sess_vec);

			auditLogThread.setValue("Description","You have exceeded the number of users allowed by your license!");
			auditLogThread.setValue("Activity","Clone User");		
			auditLogThread.sendItToDB();
%>
			<jsp:forward page="EgErrors.jsp" />
<%
			return;
		}
	}
	catch(Exception ee)
	{
		/* code for auditlog starts */
		auditLogThread.setValue("Description","Problem while adding user");
		auditLogThread.setValue("Activity","Clone User");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		ee.printStackTrace();


		if(!(str_usercon.equals("CONNECTED")))
		{
%>
			<jsp:forward page="EgProbs.jsp" />
<%
		}
		out.println(ee.getMessage());
		
	}finally
	{
		try
		{
			if (userBean != null)
			userBean.releaseConnection(true);
		}
		catch(Exception ec)
		{}
	}
	//License check ends

	auditLogThread.setCurrentValue("01~~Existing User",existingUser);

	if (operationType != null && operationType.equalsIgnoreCase("Group"))
	{
		if (grpName != null && grpName.length() > 0)
		{
			IniFile ini_write = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini",true);
			ArrayList tempList = StringUtils.myTokenizer(grpName,"|#|");
			Iterator it = tempList.iterator();
			while(it.hasNext())
			{
				String tempGrpName = (String)it.next();
				if (tempGrpName == null || tempGrpName.equals(""))
				{
					continue;
				}
				
				uname = domainName + "/Grp/" + tempGrpName.trim();
				if (uname != null && uname.indexOf("'") != -1)
				{
					String tempUser = uname;
					uname = StringUtils.replace(uname,"'","^");
					ini_write.setValue("USER_DBUSER_MAP",tempUser,uname);
					ini_write.setValue("DBUSER_USER_MAP",uname,tempUser); // reverse user mapping
				}

				if(userAuthentication == null || userAuthentication.equals("Eg"))
				{
					auditLogThread.setCurrentValue("02~~User Authentication","Local");
				}
				else
				{
					auditLogThread.setCurrentValue("02~~User Authentication","Domain");
					auditLogThread.setCurrentValue("03~~Domain",domainName);
				}
				
				auditLogThread.setCurrentValue("04~~New User ID",uname);

				if(never != null && never.equals("Never"))
				{
					auditLogThread.setCurrentValue("05~~Expiry Date","Never");
				}
				else
				{
					auditLogThread.setCurrentValue("05~~Expiry Date",request.getParameter("expiry_date"));
				}

				auditLogThread.setCurrentValue("06~~Mail ID/Mobile Number",tomailid);
				auditLogThread.setCurrentValue("07~~Time Zone",timezone);
				auditLogThread.setCurrentValue("08~~Language",languageName);

				aListUserAttributes.add(uname);
				aListUserAttributes.add(password);
				aListUserAttributes.add(expiry_date);
				aListUserAttributes.add(mailid);
				aListUserAttributes.add(timezone);
				aListUserAttributes.add(language);
				
				String[] categories = new String[11];
				categories = request.getParameterValues("categoryCheck");
				aListCategoriesForReplication.add("User_Preferences");
				mappedUI = "User Information & Preferences";
				auditLogThread.setCurrentValue("09~~Categories for Replication",mappedUI);
				
				if (categories != null)
				{
					for (int i=0;i<categories.length;i++)
					{
						aListCategoriesForReplication.add(categories[i]);
						mappedUI = (String)mapToUI.get(categories[i]);
						auditLogThread.setCurrentValue("09~~Categories for Replication",mappedUI);
					}
				}

				aListUserAttributes.add(existingUser);

				EgCloneUser EgCloneUserObj = new EgCloneUser(existingUser,uname,password);
				EgCloneUserObj.setAttributes(aListUserAttributes,aListCategoriesForReplication);
				ArrayList clonedResults = EgCloneUserObj.cloneUser();

				auditLogThread.setValue("Description","User "+uname+" has been cloned from existing user "+ existingUser);
				auditLogThread.setValue("Activity","Clone User");
				auditLogThread.sendItToDB();

				aListUserAttributes = new ArrayList();
				aListCategoriesForReplication = new ArrayList();
			}
			ini_write.saveFile();
			EgConfigFilesSync.releaseInstance(ini_write);
		}
	}
	else
	{
		if (uname != null && uname.indexOf("'") != -1)
		{
			String tempUser = uname;
			uname = StringUtils.replace(uname,"'","^");
			IniFile ini_write = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini",true);
			ini_write.setValue("USER_DBUSER_MAP",tempUser,uname);
			ini_write.setValue("DBUSER_USER_MAP",uname,tempUser); // reverse user mapping
			ini_write.saveFile();
			EgConfigFilesSync.releaseInstance(ini_write);
		}

		if(userAuthentication == null || userAuthentication.equals("Eg"))
		{
			auditLogThread.setCurrentValue("02~~User Authentication","Local");
		}
		else
		{
			auditLogThread.setCurrentValue("02~~User Authentication","Domain");
			auditLogThread.setCurrentValue("03~~Domain",domainName);
		}
		
		auditLogThread.setCurrentValue("04~~New User ID",uname);

		if(never != null && never.equals("Never"))
		{
			auditLogThread.setCurrentValue("05~~Expiry Date","Never");
		}
		else
		{
			auditLogThread.setCurrentValue("05~~Expiry Date",request.getParameter("expiry_date"));
		}

		auditLogThread.setCurrentValue("06~~Mail ID/Mobile Number",tomailid);
		auditLogThread.setCurrentValue("07~~Time Zone",timezone);
		auditLogThread.setCurrentValue("08~~Language",languageName);

		aListUserAttributes.add(uname);
		aListUserAttributes.add(password);
		aListUserAttributes.add(expiry_date);
		aListUserAttributes.add(mailid);
		aListUserAttributes.add(timezone);
		aListUserAttributes.add(language);
		
		String[] categories = new String[11];
		categories = request.getParameterValues("categoryCheck");
		aListCategoriesForReplication.add("User_Preferences");
		mappedUI = "User Information & Preferences";
		auditLogThread.setCurrentValue("09~~Categories for Replication",mappedUI);
		
		if (categories != null)
		{
			for (int i=0;i<categories.length;i++)
			{
				aListCategoriesForReplication.add(categories[i]);
				mappedUI = (String)mapToUI.get(categories[i]);
				auditLogThread.setCurrentValue("09~~Categories for Replication",mappedUI);
			}
		}

		aListUserAttributes.add(existingUser);

		EgCloneUser EgCloneUserObj = new EgCloneUser(existingUser,uname,password);
		EgCloneUserObj.setAttributes(aListUserAttributes,aListCategoriesForReplication);
		ArrayList clonedResults = EgCloneUserObj.cloneUser();

		auditLogThread.setValue("Description","User "+uname+" has been cloned from existing user "+ existingUser);
		auditLogThread.setValue("Activity","Clone User");
		auditLogThread.sendItToDB();
	}

	Vector sessVec = new Vector();
	sessVec.add(_mapping.getTextDescription("admin.user.Add new user"));
	sessVec.add("EgAddUser.jsp");
	sessVec.add(_mapping.getTextDescription("admin.user.Clone user"));
	sessVec.add(_mapping.getTextDescription("admin.user.The user(s) has been cloned successfully")+".");
	session.putValue("vec_Results", sessVec);
	String url = "EgResults.jsp";
%>
<jsp:forward page="<%=url%>" />



