<%@ include file="EgTrackerA.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.IniFile"%> 
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgUsersInfo"%>
<%@ page errorPage = "EgProbs.jsp" %>

<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");

	private String getResultantPattern(String componentType,String componentName,String testName,String[] testVariables)
	{
		String tempResultantPattern = null;
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String specificPattern_A = testName + ":" + componentType + ":" + componentName;
		String specificPattern_B = testName + ":" + componentType + ":" + componentNickName;
		String defaultPattern_A = testName + "::" + componentName;
		String defaultPattern_B = testName + "::" + componentNickName;

		List listTestVariables = Arrays.asList(testVariables);
		if (listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if (listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if (listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if (listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}
		return tempResultantPattern;
	}

	//Will provide the right agent (subject) for a component and its test
	private String getAgentNickName(String componentType,String componentName,String testName)
	{
		boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
		List aListTempAgentsForComponent = getAgents(componentName);
		String agentName = null;
		if (isExternalTest)
		{
			//external agent for external test
			agentName = (String)aListTempAgentsForComponent.get(1);
		}
		else
		{
			//internal agent or remote agent for host level test and application level test.
			agentName = (String)aListTempAgentsForComponent.get(0);
		}
		return agentName;
	}

	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";
		boolean isRemote = false;

		//To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends
		return agentsList;
	}

	public boolean hasUnConfiguredParam(String paramValue)
	{
		boolean hasUnconfiguredParam = false;
		StringTokenizer st = new StringTokenizer(paramValue,",");
		st.nextToken();
		StringTokenizer st1 = new StringTokenizer(st.nextToken());
		ArrayList aListParamNameValue = new ArrayList();

		StringBuffer eachStr = null;
		while (st1.hasMoreTokens())
		{
			String token = st1.nextToken();
			token = token.trim();
			if (token.startsWith("-"))
			{
				if (eachStr != null && eachStr.toString().length() > 0)
				{
					aListParamNameValue.add((eachStr.toString()).substring(0,(eachStr.toString()).length()-1));
				}
				aListParamNameValue.add(token.toLowerCase());
				eachStr = new StringBuffer();
			}
			else
			{
				eachStr.append(token + " ");
			}
		}
		aListParamNameValue.add((eachStr.toString()).trim());
		String snmpVersion = null;
		boolean isSnmp = aListParamNameValue.contains("-snmpversion");

		if (isSnmp)
		{
			//put snmp version before snmp community.
			int snmpCommunityIdx = aListParamNameValue.indexOf("-snmpcommunity");
			String snmpCommunityVal = (String)aListParamNameValue.get(snmpCommunityIdx+1);
			aListParamNameValue.remove(snmpCommunityIdx);
			aListParamNameValue.remove(snmpCommunityIdx);

			int snmpVerIdx = aListParamNameValue.indexOf("-snmpversion");
			snmpVersion = (String)aListParamNameValue.get(snmpVerIdx+1);

			aListParamNameValue.add(snmpVerIdx+2,"-snmpcommunity");
			aListParamNameValue.add(snmpVerIdx+3,snmpCommunityVal);
		}

		for (int i=0;i < aListParamNameValue.size();i=i+2)
		{
			String strParamName = (String)aListParamNameValue.get(i);
			String strParamValue = (String)aListParamNameValue.get(i+1);

			if (strParamName.equalsIgnoreCase("-password") || 
				strParamName.equalsIgnoreCase("-proxypassword") || 
				strParamName.equalsIgnoreCase("-authpass") || 
				strParamName.equalsIgnoreCase("-encryptpassword") || 
				strParamName.equalsIgnoreCase("-admin_password") || 
				strParamName.equalsIgnoreCase("-vc_password") || 
				strParamName.equalsIgnoreCase("-esx_password") || 
				strParamName.equalsIgnoreCase("-sendpassword") || 
				strParamName.equalsIgnoreCase("-receivepassword") || 
				strParamName.equalsIgnoreCase("-xen_password") || 
				strParamName.equalsIgnoreCase("-From_User_Password"))
			{
				continue;
			}

			if (isSnmp && snmpVersion != null)
			{
				if (snmpVersion.equalsIgnoreCase("v3"))
				{
					if (strParamName.equalsIgnoreCase("-snmpcommunity"))
					{
						continue;
					}
				}
			}

			strParamValue = strParamValue.trim();
			if (strParamValue.startsWith("$"))
			{
				hasUnconfiguredParam = true;
				break;
			}
		}
		return hasUnconfiguredParam;
	}
%>

<%
	IniFile agentIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_agents.ini");
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);

	String componentType = request.getParameter("componentType");
	componentType = (componentType != null)?componentType:"";

	String previousComponentType = request.getParameter("previousComponentType");
	previousComponentType = (previousComponentType != null)?previousComponentType:"";

	String testType = request.getParameter("testType");
	testType = (testType == null)?"PerformanceTest":testType;

	String perviousTestType = request.getParameter("previousTestType");
	perviousTestType = (perviousTestType == null)?"PerformanceTest":perviousTestType;

	String pfSelected = "";
	String cfSelected = "";
	if (testType.equalsIgnoreCase("PerformanceTest"))
	{
		pfSelected = "selected";
	}
	else
	{
		cfSelected = "selected";
	}

	String testName = "";
	String strSelectedTestsInList = request.getParameter("selectedTest");
	if (strSelectedTestsInList == null || strSelectedTestsInList.equals("-1"))
	{
		strSelectedTestsInList = "";
	}

	boolean isConfigSupport = EgInstallInfo.isConfigSupported;
	if (isConfigSupport)
	{
		if (!previousComponentType.equalsIgnoreCase(componentType))
		{
			strSelectedTestsInList = "";
		}
	}

	Vector aListselectedTests = new Vector();
	StringTokenizer stk = new StringTokenizer(strSelectedTestsInList,",");
	while (stk.hasMoreTokens())
	{
		String tname = stk.nextToken();
		if (!aListselectedTests.contains(tname))
		{
			aListselectedTests.add(tname);
		}
	}

	EgUsersInfo usersInfo = new EgUsersInfo();
	String selectedUsrTests = "";
	if (usersInfo.isUserBasedLicense())
	{
		if(!componentType.equals(""))
		{
			ArrayList userBasedTests = usersInfo.getUserBasedTests(componentType);
			for (int i=0; i < userBasedTests.size(); i++)
			{
				String usrTest = (String)userBasedTests.get(i).toString();
				if (aListselectedTests.contains(usrTest))
				{
					aListselectedTests.remove(usrTest);
					if (selectedUsrTests.equals(""))
						selectedUsrTests += _mapping.getTestDescription(usrTest);
					else
						selectedUsrTests += ","+ _mapping.getTestDescription(usrTest);				
				}
			}
		}
	}


	String previousTestName = request.getParameter("previousTestName");
	previousTestName = (previousTestName != null)?previousTestName:"";

	ArrayList aListEnabledTestForCompType = null;
	ArrayList aListResultantIncludedComponents = null;
	ArrayList aListResultantExcludedComponents = null;

	//contains enabled test for a component type
	if (!componentType.equals("") && !componentType.equals("-1"))
	{
		if (testType.equals("PerformanceTest"))
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		}
		else
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,true);
		}
		aListEnabledTestForCompType = sorter.getSortedTestList(aListEnabledTestForCompType);
	}

	Hashtable htableTestWithExcludedComponents = new Hashtable();
	Hashtable htableTestWithIncludedComponents = new Hashtable();
	ArrayList aListIncludedTest = new ArrayList();
	ArrayList aListExcludedTest = new ArrayList();

	boolean isPageRefresh = false;
	String pageRefresh = request.getParameter("refreshed");
	if (pageRefresh != null)
	{
		isPageRefresh = pageRefresh.equals("true")?true:false;
	}

	if (isPageRefresh)
	{
		String strIncluCompList = request.getParameter("enabledCompList");
		String strExcluCompList = request.getParameter("disabledCompList");

		if (strExcluCompList != null && strExcluCompList.length() > 1)
		{
			StringTokenizer st = new StringTokenizer(strExcluCompList,",");
			while (st.hasMoreTokens())
			{
				String token = st.nextToken();
				String strCompName = token.substring(0,token.indexOf("$"));
				String strTestWithState = token.substring(token.indexOf("$")+1);
				String strTestName = strTestWithState.substring(0,strTestWithState.indexOf(" - ")).trim();
				if(!aListExcludedTest.contains(strTestName))
				{
					aListExcludedTest.add(strTestName);
				}
				ArrayList aListTemp = (ArrayList)htableTestWithExcludedComponents.get(strTestWithState);
				if (aListTemp == null)
				{
					aListTemp = new ArrayList();
					aListTemp.add(strCompName);
					htableTestWithExcludedComponents.put(strTestWithState,aListTemp);
				}
				else
				{
					aListTemp.add(strCompName);
				}
			}
		}

		if (strIncluCompList != null && strIncluCompList.length() > 1)
		{
			StringTokenizer st = new StringTokenizer(strIncluCompList,",");
			while (st.hasMoreTokens())
			{
				String token = st.nextToken();
				String strCompName = token.substring(0,token.indexOf("$"));
				String strTestWithState = token.substring(token.indexOf("$")+1);
				ArrayList aListTemp = (ArrayList)htableTestWithIncludedComponents.get(strTestWithState);
				String strTestName = strTestWithState.substring(0,strTestWithState.indexOf(" - ")).trim();
				if(!aListIncludedTest.contains(strTestName))
				{
					aListIncludedTest.add(strTestName);
				}
				if (aListTemp == null)
				{
					aListTemp = new ArrayList();
					aListTemp.add(strCompName);
					htableTestWithIncludedComponents.put(strTestWithState,aListTemp);
				}
				else
				{
					aListTemp.add(strCompName);
				}
			}
		}
	}
	else
	{
		if (componentType != null && !componentType.equals("-1"))
		{
			String[] componentsList = ri.getAllServersOfType(componentType);
			boolean isPortRelevantForTest ;
			IniFile disableIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_disable.ini");
			for (int i=0;i < componentsList.length;i++)
			{
				String strComponent = componentsList[i];
				strComponent = strComponent.substring(strComponent.indexOf(":")+1);

				for (int k=0;k < aListselectedTests.size();k++)
				{
					testName = aListselectedTests.get(k).toString();
					isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);

					String strTestPattern1 = "#" + testName + "#";
					String strTestPattern2 = "#" + testName + ",";
					String strTestPattern3 = "," + testName + ",";
					String strTestPattern4 = "," + testName + "#";

					String tempAgentNickName = getAgentNickName(componentType,strComponent,testName);
					String[] tempTestVariables = agentIni.getVariables(tempAgentNickName);
					String tempResultantPattern = getResultantPattern(componentType,strComponent,testName,tempTestVariables);
					String tempTestValue = agentIni.getValue(tempAgentNickName,tempResultantPattern);

					String strTestStatus = "Excluded component(s)";
					if (tempTestValue.indexOf("-auto") > -1 && 
						tempTestValue.indexOf(" $") > -1 && hasUnConfiguredParam(tempTestValue))
					{
						strTestStatus = "Unconfigured component(s)";
					}
					else if (tempTestValue.indexOf("-auto") > -1 || tempTestValue.indexOf("-manual") > -1)
					{
						strTestStatus = "Configured component(s)";
					}

					if (isPortRelevantForTest)
					{
						String pattern = componentType + ":" + strComponent;
						String value = disableIni.getValue(componentType,pattern);
						if (value == null || value.length() == 0)
						{
							if (tempTestValue.length() == 0)
							{
								continue;
							}
							if (aListResultantIncludedComponents == null )
							{
								aListResultantIncludedComponents = new ArrayList();
							}
							strTestStatus = StringUtils.replace(strTestStatus,"Excluded","Configured");
							aListResultantIncludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
						}
						else
						{
							value = "#" + value + "#";
							if (value.indexOf(strTestPattern1) > -1 || 
								value.indexOf(strTestPattern2) > -1 || 
								value.indexOf(strTestPattern3) > -1 || 
								value.indexOf(strTestPattern4) > -1)
							{
								if (aListResultantExcludedComponents == null )
								{
									aListResultantExcludedComponents = new ArrayList();
								}
								aListResultantExcludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
							}
							else
							{
								if (tempTestValue.length() == 0)
								{
									continue;
								}
								if (aListResultantIncludedComponents == null )
								{
									aListResultantIncludedComponents = new ArrayList();
								}
								strTestStatus = StringUtils.replace(strTestStatus,"Excluded","Configured");
								aListResultantIncludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
							}
						}
					}
					else
					{
						String pattern = "Default_server" + ":" + strComponent.substring(0,strComponent.indexOf(":"));
						String value = disableIni.getValue("Default_server",pattern);
						if (value == null || value.length() == 0)
						{
							if (tempTestValue.length() == 0)
							{
								continue;
							}
							if (aListResultantIncludedComponents == null )
							{
								aListResultantIncludedComponents = new ArrayList();
							}
							strTestStatus = StringUtils.replace(strTestStatus,"Excluded","Configured");
							aListResultantIncludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
						}
						else
						{
							value = "#" + value + "#";
							if (value.indexOf(strTestPattern1) > -1 || 
								value.indexOf(strTestPattern2) > -1 || 
								value.indexOf(strTestPattern3) > -1 || 
								value.indexOf(strTestPattern4) > -1)
							{
								if (aListResultantExcludedComponents == null )
								{
									aListResultantExcludedComponents = new ArrayList();
								}
								aListResultantExcludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
							}
							else
							{
								if (tempTestValue.length() == 0)
								{
									continue;
								}
								if (aListResultantIncludedComponents == null )
								{
									aListResultantIncludedComponents = new ArrayList();
								}
								strTestStatus = StringUtils.replace(strTestStatus,"Excluded","Configured");
								aListResultantIncludedComponents.add(strComponent+"||"+testName+" - "+strTestStatus);
							}
						}
					}
				}
			}
		}

		if (aListResultantExcludedComponents != null && aListResultantExcludedComponents.size() > 0)
		{
			for (int i=0;i < aListResultantExcludedComponents.size();i++)
			{
				String strcompTest = aListResultantExcludedComponents.get(i).toString();
				String strTestWithState = strcompTest.substring(strcompTest.indexOf("||")+2);
				String strTestName = strTestWithState.substring(0,strTestWithState.indexOf(" - ")).trim();
				if(!aListExcludedTest.contains(strTestName))
				{
					aListExcludedTest.add(strTestName);
				}
				ArrayList aListcomponents = (ArrayList)htableTestWithExcludedComponents.get(strTestWithState);
				if(aListcomponents == null)
				{
					aListcomponents = new ArrayList();
					aListcomponents.add(strcompTest.substring(0,strcompTest.indexOf("||")));
					htableTestWithExcludedComponents.put(strTestWithState,aListcomponents);
				}
				else
				{
					aListcomponents.add(strcompTest.substring(0,strcompTest.indexOf("||")));
				}
			}
		}

		if (aListResultantIncludedComponents != null && aListResultantIncludedComponents.size() > 0)
		{
			for (int i=0;i < aListResultantIncludedComponents.size();i++)
			{
				String strcompTest = aListResultantIncludedComponents.get(i).toString();
				String strTestWithState = strcompTest.substring(strcompTest.indexOf("||")+2);
				String strTestName = strTestWithState.substring(0,strTestWithState.indexOf(" - ")).trim();
				if(!aListIncludedTest.contains(strTestName))
				{
					aListIncludedTest.add(strTestName);
				}
				ArrayList aListcomponents = (ArrayList)htableTestWithIncludedComponents.get(strTestWithState);
				if(aListcomponents == null)
				{
					aListcomponents = new ArrayList();
					aListcomponents.add(strcompTest.substring(0,strcompTest.indexOf("||")));
					htableTestWithIncludedComponents.put(strTestWithState,aListcomponents);
				}
				else
				{
					aListcomponents.add(strcompTest.substring(0,strcompTest.indexOf("||")));
				}
			}
		}

		session.setAttribute("htableInitialExcludedComponents",htableTestWithExcludedComponents);
		session.setAttribute("htableInitialIncludedComponents",htableTestWithIncludedComponents);
	}

	// - Code Start -  To filter the component list which actually included/excluded in the UI design
	String strIncludedMovedComp = request.getParameter("strIncludedMovedComp");
	if (strIncludedMovedComp ==null )
	{
		strIncludedMovedComp = "";
	}

	String strExcludedMovedComp = request.getParameter("strExcludedMovedComp");
	if (strExcludedMovedComp ==null )
	{
		strExcludedMovedComp = "";
	}

	Hashtable htableSessionTestWithExcludedComponents = (Hashtable)session.getAttribute("htableSessionTestWithExcludedComponents");
	if (htableSessionTestWithExcludedComponents == null)
	{
		htableSessionTestWithExcludedComponents = new Hashtable();
	}

	Hashtable htableSessionTestWithIncludedComponents = (Hashtable)session.getAttribute("htableSessionTestWithIncludedComponents");
	if (htableSessionTestWithIncludedComponents == null)
	{
		htableSessionTestWithIncludedComponents = new Hashtable();
	}

	Hashtable htableInitialExcludedComponents = (Hashtable)session.getAttribute("htableInitialExcludedComponents");
	if (htableInitialExcludedComponents == null)
	{
		htableInitialExcludedComponents = new Hashtable();
	}

	Hashtable htableInitialIncludedComponents = (Hashtable)session.getAttribute("htableInitialIncludedComponents");
	if (htableInitialIncludedComponents == null)
	{
		htableInitialIncludedComponents = new Hashtable();
	}

	String strPrevSelectedTestList = request.getParameter("strPrevSelectedTestList");
	if (strPrevSelectedTestList == null)
	{
		strPrevSelectedTestList = "";
	}
	if (!strSelectedTestsInList.equals(strPrevSelectedTestList))
	{
		htableSessionTestWithExcludedComponents.clear();
		htableSessionTestWithIncludedComponents.clear();
	}

	if (strExcludedMovedComp.length()>0)
	{
		StringTokenizer stObj = new StringTokenizer(strExcludedMovedComp,",");
		while (stObj.hasMoreTokens())
		{
			String token = stObj.nextToken().toString();
			String comps =token.substring(0,token.indexOf("$"));
			String strTestNameWithState =token.substring(token.indexOf("$")+1);

			ArrayList aListTemp = (ArrayList)htableInitialExcludedComponents.get(strTestNameWithState);
			if (aListTemp == null)
			{
				aListTemp = new ArrayList();
			}
			if (strTestNameWithState.indexOf(" - ")>-1)
			{
				strTestNameWithState = strTestNameWithState.substring(0,strTestNameWithState.indexOf(" - "));
			}

			ArrayList aListSessExcludedComp = (ArrayList)htableSessionTestWithExcludedComponents.get(strTestNameWithState);
			if (aListSessExcludedComp == null)
			{
				aListSessExcludedComp = new ArrayList();
			}

			ArrayList aListCheckIncludeList = (ArrayList)htableSessionTestWithIncludedComponents.get(strTestNameWithState);
			if (aListCheckIncludeList == null)
			{
				aListCheckIncludeList = new ArrayList();
			}

			if (aListCheckIncludeList.contains(comps) && aListCheckIncludeList.size() > 0)
			{
				aListCheckIncludeList.remove(comps);
				if (aListCheckIncludeList.size() > 0)
				{
					htableSessionTestWithIncludedComponents.put(strTestNameWithState,aListCheckIncludeList);
				}
				else
				{
					htableSessionTestWithIncludedComponents.remove(strTestNameWithState);
				}
			}
			if (!aListSessExcludedComp.contains(comps) && !aListTemp.contains(comps))
			{
				aListSessExcludedComp.add(comps);
			}
			if (aListSessExcludedComp.size() > 0)
			{
				htableSessionTestWithExcludedComponents.put(strTestNameWithState,aListSessExcludedComp);
			}
			else
			{
				htableSessionTestWithExcludedComponents.remove(strTestNameWithState);
			}
		}
	}

	if (strIncludedMovedComp.length() > 0)
	{
		StringTokenizer stObj = new StringTokenizer(strIncludedMovedComp,",");
		while (stObj.hasMoreTokens())
		{
			String token = stObj.nextToken();
			String comps =token.substring(0,token.indexOf("$"));
			String strTestNameWithState = token.substring(token.indexOf("$")+1);

			ArrayList aListTemp = (ArrayList)htableInitialIncludedComponents.get(strTestNameWithState);
			if (aListTemp == null)
			{
				aListTemp = new ArrayList();
			}
			if (strTestNameWithState.indexOf(" - ") > -1)
			{
				strTestNameWithState = strTestNameWithState.substring(0,strTestNameWithState.indexOf(" - "));
			}

			ArrayList aListSessIncludedComp = (ArrayList)htableSessionTestWithIncludedComponents.get(strTestNameWithState);
			if (aListSessIncludedComp == null)
			{
				aListSessIncludedComp = new ArrayList();
			}

			ArrayList aListCheckExcludeList = (ArrayList)htableSessionTestWithExcludedComponents.get(strTestNameWithState);
			if (aListCheckExcludeList == null)
			{
				aListCheckExcludeList = new ArrayList();
			}

			if (aListCheckExcludeList.contains(comps) && aListCheckExcludeList.size() > 0)
			{
				aListCheckExcludeList.remove(comps);
				if (aListCheckExcludeList.size() > 0)
				{
					htableSessionTestWithExcludedComponents.put(strTestNameWithState,aListCheckExcludeList);
				}
				else
				{
					htableSessionTestWithExcludedComponents.remove(strTestNameWithState);
				}
			}
			if (!aListSessIncludedComp.contains(comps) && !aListTemp.contains(comps))
			{
				aListSessIncludedComp.add(comps);
			}
			if (aListSessIncludedComp.size() > 0)
			{
				htableSessionTestWithIncludedComponents.put(strTestNameWithState,aListSessIncludedComp);
			}
			else
			{
				htableSessionTestWithIncludedComponents.remove(strTestNameWithState);
			}
		}
	}

	session.setAttribute("htableSessionTestWithExcludedComponents",htableSessionTestWithExcludedComponents);
	session.setAttribute("htableSessionTestWithIncludedComponents",htableSessionTestWithIncludedComponents);

	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgIncludeExcludeComponents.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgIncludeExcludeComponents.jsp?reqfrom=navlink");
	}
	// - Code Ends -  To filter the component list which actually included/excluded in the UI design
%>

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui = "admin"/>
<script>
function showCompTypeTestList()
{
	var thisForm = document.topology;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	thisForm.testName.value = "";
	thisForm.method = "post";
	thisForm.action = "EgIncludeExcludeComponents.jsp?componentType="+componentType+"&testType="+thisForm.testType.value;
	thisForm.submit();
}

function changeValue()
{
	var thisForm = document.topology;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	var testName = "";
	if (thisForm.testName != null && thisForm.testName != undefined)
	{
		testName = thisForm.testName.value;
	}
	var testNameObj = thisForm.testName;
	var selectedTest="";
	for (var i=0; i < testNameObj.length; i++)
	{
		if (testNameObj.options[i].selected == true)
		{
			var testTxt = testNameObj.options[i].text;
			var testVal = testNameObj.options[i].value;
			selectedTest+=testVal+",";
		}
	}
	selectedTest = selectedTest.substring(0,selectedTest.length-1);

	thisForm.method = "post";
	thisForm.action = "EgIncludeExcludeComponents.jsp?selectedTest="+selectedTest+"&componentType="+componentType+"&testType="+thisForm.testType.value;;
	thisForm.submit();
}

function addToDisabled()
{
	var thisForm = document.topology;
	var enableLen = thisForm.enabledComponents.options.length;
	var disableLen = thisForm.disabledComponents.options.length;
	var enableList = thisForm.enabledComponents;
	var disableList = thisForm.disabledComponents;
	var strExcludedMovedComp = "";

	for (i = 0;i < enableLen;i++)
	{
		if (enableList.options[i].selected == true)
		{
			testTxt = enableList.options[i].text;
			testVal = enableList.options[i].value;
			disableList.options[disableLen++]=new Option(testTxt,testVal);
			strExcludedMovedComp+=testVal+",";
		}
	}
	for (i = enableLen;i > 0;i--)
	{
		if (enableList.options[i-1].selected == true)
		{
			enableList.options[i-1]=null;
		}
	}

	var vEnabledComp="";
	for (i=0;i < thisForm.enabledComponents.options.length;i++)
	{
		vEnabledComp+=thisForm.enabledComponents.options[i].value+",";
	}
	var vDisabledComp="";
	for (var i=0;i < thisForm.disabledComponents.options.length;i++)
	{
		vDisabledComp+=thisForm.disabledComponents.options[i].value+",";
	}
	thisForm.enabledCompList.value = vEnabledComp;
	thisForm.disabledCompList.value = vDisabledComp;

	var testNameObj = thisForm.testName;
	var selectedTest="";
	for (var i=0; i < testNameObj.length; i++)
	{
		if (testNameObj.options[i].selected == true)
		{
			var testTxt = testNameObj.options[i].text;
			var testVal = testNameObj.options[i].value;
			selectedTest+=testVal+",";
		}
	}
	selectedTest = selectedTest.substring(0,selectedTest.length-1);
	thisForm.seletedTestList.value=selectedTest;
	thisForm.strExcludedMovedComp.value = strExcludedMovedComp;
	thisForm.refreshed.value="true";
	thisForm.method = "post";
	thisForm.action = "EgIncludeExcludeComponents.jsp?selectedTest="+selectedTest;

	if(strExcludedMovedComp!="")
	{
		thisForm.submit();
	}
	else
	{
		alert('<egui:intnl text="admin.test.Please select the component(s) to exclude"/>.');
		return;
	}
}

function addToEnabled()
{
	var thisForm = document.topology;
	var enableLen = thisForm.enabledComponents.options.length;
	var disableLen = thisForm.disabledComponents.options.length;
	var enableList = thisForm.enabledComponents;
	var disableList = thisForm.disabledComponents;
	var strIncludedMovedComp = "";

	for (i=0;i < disableLen;i++)
	{
		if (disableList.options[i].selected == true)
		{
			testTxt = disableList.options[i].text;
			testVal = disableList.options[i].value;
			enableList.options[enableLen++]=new Option(testTxt,testVal);
			strIncludedMovedComp+=testVal+",";
		}
	}
	for (i=disableLen;i > 0;i--)
	{
		if (disableList.options[i-1].selected == true)
		{
			disableList.options[i-1]=null;
		}
	}

	var vEnabledComp="";
	for (i=0;i < thisForm.enabledComponents.options.length;i++)
	{
		vEnabledComp+=thisForm.enabledComponents.options[i].value+",";
	}
	var vDisabledComp="";
	for (var i=0;i < thisForm.disabledComponents.options.length;i++)
	{
		vDisabledComp+=thisForm.disabledComponents.options[i].value+",";
	}
	thisForm.enabledCompList.value = vEnabledComp;
	thisForm.disabledCompList.value = vDisabledComp;

	var testNameObj = thisForm.testName;
	var selectedTest="";
	for (var i=0; i < testNameObj.length; i++)
	{
		if (testNameObj.options[i].selected == true)
		{
			var testTxt = testNameObj.options[i].text;
			var testVal = testNameObj.options[i].value;
			selectedTest+=testVal+",";
		}
	}
	selectedTest = selectedTest.substring(0,selectedTest.length-1);

	thisForm.seletedTestList.value=selectedTest;
	thisForm.strIncludedMovedComp.value = strIncludedMovedComp;
	thisForm.refreshed.value="true";
	thisForm.method = "post";
	thisForm.action = "EgIncludeExcludeComponents.jsp?selectedTest="+selectedTest;

	if(strIncludedMovedComp!="")
	{
		thisForm.submit();
	}
	else
	{
		alert('<egui:intnl text="admin.test.Please select the component(s) to include"/>.');
		return;
	}
}

function updateData()
{
	var thisForm = document.topology;
	var enableLen = thisForm.enabledComponents.options.length;
	var enableList = thisForm.enabledComponents;
	var enableComp_arr = new Array();
	var disableLen = thisForm.disabledComponents.options.length;
	var disableList = thisForm.disabledComponents;
	var disableComp_arr = new Array();
	var componentType = thisForm.componentType.value;
	var testName = thisForm.testName.value;
	var vSeletedTestList = thisForm.seletedTestList;
	var testNameObj = thisForm.testName;
	var strSeletedTestList = "";

	if (componentType == "-1")
	{
		alert('<egui:intnl text="admin.test.Please choose a component type"/>.');
		return;
	}
	else if (testName == "-1")
	{
		alert('<egui:intnl text="admin.test.Please choose a test"/>.');
		return;
	}

	for (var i=0;i < testNameObj.length;i++)
	{
		if (testNameObj.options[i].selected == true)
		{
			strSeletedTestList += testNameObj.options[i].value+",";
		}
	}
	strSeletedTestList = strSeletedTestList.substring(0,strSeletedTestList.length-1);
	vSeletedTestList.value = strSeletedTestList;

	for (var i=0;i < enableLen;i++)
	{
		enableComp_arr[i] = enableList.options[i].value;
	}
	for (var i=0;i < disableLen;i++)
	{
		disableComp_arr[i] = disableList.options[i].value;
	}
	thisForm.enabledCompList.value = enableComp_arr;
	thisForm.disabledCompList.value = disableComp_arr;

	if (vSeletedTestList.value != "")
	{
		if (thisForm.includedCompCount.value == "0" && thisForm.excludedCompCount.value == "0")
		{
			alert('<egui:intnl text="admin.test.Please include/exclude component(s)"/>.');
		}
		else
		{
			thisForm.submit();
		}
	}
	else
	{
		alert('<egui:intnl text="admin.test.Please select the test"/>.');
		return;
	}
}
function alertForUserTests(tests)
{
	if (tests != null && tests != 'undifined' && tests != "")
	{		
		alert ('<egui:intnl text="admin.test.The following test(s) cannot be excluded as these tests are required for validating named user counts for eG licensing"/>. '+'<egui:intnl text="admin.test.Test name(s)"/>: '+ tests);
	}	
}
</script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
</head>
<body style="overflow:auto;" id="space6" scroll="auto" onload="alertForUserTests('<%=selectedUsrTests%>')">
<form name="topology" method="post" action="EgIncludeExcludeComponentsp.jsp">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=AGENTS - TESTS - INCLUDE / EXCLUDE COMPONENTS&subtitle=false&backButton=false"/>
<%
	if (isConfigSupport)
	{
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="15%" align="right"><egui:intnl text="admin.server.Component type"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="35%">
									<select name="componentType" id="componentType" style="width:230px" onchange="javascript:showCompTypeTestList()">
<%
		if (listComponentTypes != null && listComponentTypes.size() > 0)
		{
%>
										<option value="-1"><egui:intnl text="admin.common.Choose a component type"/></option>
<%
		}
		else
		{
%>
										<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}
		//EgName class is used to hold name and its localised name.
		for (int j=0; j < listComponentTypes.size(); j++)
		{
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			if (actualname.equals(componentType))
			{
%>
										<option value="<%=actualname%>" selected><%=localname%></option>
<%
			}
			else
			{
%>
										<option value="<%=actualname%>"><%=localname%></option>
<%
			}
		}
%>
									</select>
								</td>
								<td width="20%" align="right"><egui:intnl text="admin.server.Test type"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="30%"><select name="testType" style="width:230px" onchange="javascript:showCompTypeTestList()">
								<option value="PerformanceTest" <%=pfSelected%>><egui:intnl text="admin.server.Performance"/></option>
								<option value="ConfigurationTest" <%=cfSelected%>><egui:intnl text="admin.server.Configuration"/></option>
								</select></td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td>&nbsp;</td>
				</tr>
				<tr>
					<td width="7" align="left" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="15%" align="right">&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="35%">&nbsp;</td>
								<td width="20%" align="right" valign="top"><egui:intnl text="admin.server.Test name"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="30%"> <select name="testName" style="width:230px" onchange="javascript:changeValue()" size="5" multiple>
<%
		if (aListEnabledTestForCompType == null || aListEnabledTestForCompType.size()==0)
		{
%>
									<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}
		else
		{
			for (int i=0; i < aListEnabledTestForCompType.size(); i++)
			{
				EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
				String strTestName = nameObj.getActualName();
				String strTestDisplayValue = nameObj.getLocalName();
				if (aListselectedTests != null && aListselectedTests.contains(strTestName))
				{
%>
									<option value="<%=strTestName%>" selected><%=strTestDisplayValue%></option>
<%
				}
				else
				{
%>
									<option value="<%=strTestName%>"><%=strTestDisplayValue%></option>
<%
				}
			}
		}
%>
							</select>
							</td>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	else
	{
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td width="7" align="left"class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" id="eg_subcontentbg" nowrap colspan="3">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="15%" align="right" valign="top" ><egui:intnl text="admin.server.Component type"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" valign="top"  class="paddingright" width="35%">
								<select name="componentType" id="componentType" style="width:230px" onchange="javascript:changeValue()">
<%
		if (listComponentTypes != null && listComponentTypes.size() > 0)
		{
%>
									<option value="-1"><egui:intnl text="admin.common.Choose one"/></option>
<%
		}
		else
		{
%>
									<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}
		//EgName class is used to hold name and its localised name.
		for (int j=0; j < listComponentTypes.size(); j++)
		{
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			if (actualname.equals(componentType))
			{
%>
									<option value="<%=actualname%>" selected><%=localname%></option>
<%
			}
			else
			{
%>
									<option value="<%=actualname%>"><%=localname%></option>
<%
			}
		}
%>
								</select>
								</td>
								<td width="20%"  align="right" valign="top" ><egui:intnl text="admin.server.Test name"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left"  width="30%"> <select name="testName" style="width:230px" onchange="javascript:changeValue()" size="5" multiple>
<%
		if (aListEnabledTestForCompType == null)
		{
%>
										<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}
		else
		{
			for (int i=0; i < aListEnabledTestForCompType.size(); i++)
			{
				EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
				String strTestName = nameObj.getActualName();
				String strTestDisplayValue = nameObj.getLocalName();
				if (aListselectedTests != null && aListselectedTests.contains(strTestName))
				{
%>
										<option value="<%=strTestName%>" selected><%=strTestDisplayValue%></option>
<%
				}
				else
				{
%>
										<option value="<%=strTestName%>"><%=strTestDisplayValue%></option>
<%
				}
			}
		}
%>
									</select>
								</td>
							</tr>
						</table><input type="hidden" name="testType" value="<%=testType%>">
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
%>
	<tr>
		<td id="eg_blankspace" height="10" class="eg_whitebg">&nbsp;</td>
	</tr>

	<tr>
		<td width="100%" align="center">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr>
					<td colspan="3" id="eg_subcontentbg" class="padding4">
						<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%">
							<tr>

								<td width="45%" valign="top">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4"><strong><egui:intnl text="admin.test.Included Components"/></strong></td>
										</tr>
										<tr>
											<td align="center" valign="top">
												<select id ="enabledComponents" name="enabledComponents" size="20" multiple width="320" style="width:320px;margin:0px;">
<%
	aListIncludedTest = sorter.getSortedTestList(aListIncludedTest);
	for (int k=0;k<aListIncludedTest.size();k++)
	{
		String strIncludedComponentGroup = "";
		EgName nameObj = (EgName)aListIncludedTest.get(k);
		String strTestName = nameObj.getActualName();
%>
													<optgroup label="<%=_mapping.getTestDescription(strTestName)%>">
<%
		for (int m=0;m < 3;m++)
		{
			if (m == 0)
			{
				strIncludedComponentGroup = strTestName + " - Unconfigured component(s)";
			}
			else if (m == 1)
			{
				strIncludedComponentGroup = strTestName + " - Configured component(s)";
			}
			else
			{
				strIncludedComponentGroup = strTestName + " - Excluded component(s)";
			}
			ArrayList aListOfIncludedComp = (ArrayList)htableTestWithIncludedComponents.get(strIncludedComponentGroup);
			if (aListOfIncludedComp != null && !aListOfIncludedComp.isEmpty())
			{
				String testMap = strIncludedComponentGroup.substring(0,strIncludedComponentGroup.indexOf(" - "));
				String testStatus  = StringUtils.replace(strIncludedComponentGroup,testMap,"");
				testStatus = testStatus.substring(3);

				if(aListOfIncludedComp.size()!=1)
				{
%>
													<optgroup label="&nbsp;&nbsp;<%=testStatus.substring(0,testStatus.length()-3)%>s">
<%
				}
				else
				{
%>
													<optgroup label="&nbsp;&nbsp;<%=testStatus.substring(0,testStatus.length()-3)%>">
<%
				}
				for (int i=0;i < aListOfIncludedComp.size();i++)
				{
					String strComponent = (String)aListOfIncludedComp.get(i);
					String displayName = strComponent;
					if (displayName.endsWith(":NULL"))
					{
						displayName = displayName.substring(0,displayName.indexOf(":NULL"));
					}
%>
													<option value="<%=strComponent%>$<%=strIncludedComponentGroup%>"><%=displayName%></option>
<%
				}
			}
		}
%>
													<optgroup label="&nbsp;">
<%
	}
%>
												</select>
											</td>
										</tr>
									</table>
								</td>

								<td width="10%" align="center" valign="middle" >
									<input type="button" value='&rsaquo;&rsaquo;' class="eg_lightbutton" name="unman" style="width: 85px; letter-spacing: 0px; font-size:13px; height:20px" onclick="javascript:addToDisabled()">
									<br><br><br>
									<input type="button" value='&lsaquo;&lsaquo;' class="eg_lightbutton" name="man" style="width: 85px; letter-spacing: 0px; font-size:13px; height:20px" onclick="javascript:addToEnabled()">
								</td>

								<td width="45%" valign="top">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-left-width:1px"><strong><egui:intnl text="admin.test.Excluded Components"/></strong></td>
										</tr>
										<tr>
											<td align="center" valign="top">
												<select id="disabledComponents" name="disabledComponents" size="20" multiple width="300" style="width:320px;margin:0px;">
<%
	aListExcludedTest = sorter.getSortedTestList(aListExcludedTest);
	for (int k=0;k<aListExcludedTest.size();k++)
	{
		String strExcludedComponentGroup = "";
		EgName nameObj = (EgName)aListExcludedTest.get(k);
		String strTestName = nameObj.getActualName();
%>
													<optgroup label="<%=_mapping.getTestDescription(strTestName)%>">
<%
		for (int m=0;m < 3;m++)
		{
			if (m == 0)
			{
				strExcludedComponentGroup = strTestName + " - Unconfigured component(s)";
			}
			else if (m == 1)
			{
				strExcludedComponentGroup = strTestName + " - Configured component(s)";
			}
			else
			{
				strExcludedComponentGroup = strTestName + " - Excluded component(s)";
			}

			ArrayList aListOfExcludedComp = (ArrayList)htableTestWithExcludedComponents.get(strExcludedComponentGroup);

			if (aListOfExcludedComp != null && !aListOfExcludedComp.isEmpty())
			{
				String testMap = strExcludedComponentGroup.substring(0,strExcludedComponentGroup.indexOf(" - "));
				String testStatus  = StringUtils.replace(strExcludedComponentGroup,testMap,"");
				testStatus = testStatus.substring(3);
				if(aListOfExcludedComp.size()!=1)
				{
%>
													<optgroup label="&nbsp;&nbsp;<%=testStatus.substring(0,testStatus.length()-3)%>s">
<%
				}
				else
				{
%>
													<optgroup label="&nbsp;&nbsp;<%=testStatus.substring(0,testStatus.length()-3)%>">
<%
				}
				for (int i=0;i < aListOfExcludedComp.size();i++)
				{
					String strComponent = (String)aListOfExcludedComp.get(i);
					String displayName = strComponent;
					if (displayName.endsWith(":NULL"))
					{
						displayName = displayName.substring(0,displayName.indexOf(":NULL"));
					}
%>
													<option value="<%=strComponent%>$<%=strExcludedComponentGroup%>"><%=displayName%></option>
<%
				}
			}
		}
%>
													<optgroup label="&nbsp;">
<%
	}
%>
												</select>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" width="100%" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td align="center" height="40" valign="middle">
			<input type="button" name="updateButton" value='Update' class="eg_back" style="width: 90px;" onClick="javascript:updateData()">
		</td>
	</tr>
</table>
<input type="hidden" name="previousTestType" value="<%=testType%>">
<input type="hidden" name="previousComponentType" value="<%=componentType%>">
<input type="hidden" name="previousTestName" value="<%=testName%>">
<input type="hidden" name="strPrevSelectedTestList" value="<%=strSelectedTestsInList%>">
<input type="hidden" name="enabledCompList" value="">
<input type="hidden" name="disabledCompList" value="">
<input type="hidden" name="seletedTestList" value="">
<input type="hidden" name="refreshed" value="false">
<input type="hidden" name="includedCompCount" value="<%=htableSessionTestWithIncludedComponents.size()%>">
<input type="hidden" name="excludedCompCount" value="<%=htableSessionTestWithExcludedComponents.size()%>">
<input type="hidden" name="strIncludedMovedComp" value="">
<input type="hidden" name="strExcludedMovedComp" value="">
</form>
</body>
</html>



