<%
/*
 *   File		:	EgEnableAndDisableTests.jsp
 *   Purpose	:	UI to enable and disable performance/configuration tests for a component type
 *   Author		:	Vaathsalya (2008)
 *   UI Design	:	Krishnamurthi
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgUsersInfo"%>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String componentType = request.getParameter("componentType");
	String testType = request.getParameter("testType");
	testType = (testType == null)?"PerformanceTest":testType;

	String pfSelected = "";
	String cfSelected = "";
	String checkEnabledTests = "";//getActualName() of the tests
	String checkDisabledTests = "";//getActualName() of the tests
	if (testType.equalsIgnoreCase("PerformanceTest"))
	{
		pfSelected = "selected";
	}
	else
	{
		cfSelected = "selected";
	}

	String showBackButton = request.getParameter("showBackButton");
	if (showBackButton == null || showBackButton.equals(""))
	{
		showBackButton = "false";
	}

	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgUsersInfo usersInfo = new EgUsersInfo();
	String usrBasedTests = "";
	if (usersInfo.isUserBasedLicense())
	{
		if(componentType!= null && !componentType.equals(""))
		{
			ArrayList userBasedTests = usersInfo.getUserBasedTests(componentType);
			for (int i=0; i<userBasedTests.size(); i++)
			{
				String test = userBasedTests.get(i).toString();
				if(usrBasedTests.equals(""))
				{
					usrBasedTests += test;
				}
				else
				{
					usrBasedTests += ","+test;
				}
			}
		}
	}
	//tell whether _cf test enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	String[] componentTypes = ri.getServerTypes();
	ArrayList serverList = null;
	if (componentTypes != null && componentTypes.length > 0)
	{
		serverList = new ArrayList(Arrays.asList(componentTypes));
		serverList.remove("Site_servers");
	}

	IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
	String defaultTestMappingSection = "DEFAULT_TEST_MAPPING";
	String testMappingSection = "TEST_MAPPING";

	ArrayList aListTests = new ArrayList();
	ArrayList aListEnabledTests = new ArrayList();
	ArrayList aListDisabledTests = new ArrayList();

	if (componentType != null && !componentType.equalsIgnoreCase("null"))
	{
		String strTests = egSpecsIni.getValue(defaultTestMappingSection,componentType);
		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		if (testType.equalsIgnoreCase("PerformanceTest"))
		{
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (EgInstallInfo.isConfigTest(strToken)) continue;
				aListTests.add(strToken);
			}
		}
		else
		{
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (EgInstallInfo.isConfigTest(strToken))
				{
					aListTests.add(strToken);
				}
			}
		}

		String strEnabledTests = egSpecsIni.getValue(testMappingSection,componentType);
		strTokens = new StringTokenizer(strEnabledTests,",");
		if (testType.equalsIgnoreCase("PerformanceTest"))
		{
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (EgInstallInfo.isConfigTest(strToken)) continue;
				aListEnabledTests.add(strToken);
			}
		}
		else
		{
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				if (EgInstallInfo.isConfigTest(strToken))
				{
					aListEnabledTests.add(strToken);
				}
			}
		}

		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			if (aListEnabledTests.contains(strTest)) continue;
			aListDisabledTests.add(strTest);
		}
	}
	String strComponentType = request.getParameter("componentType");
	String strTestType = request.getParameter("testType");
	String componentName = request.getParameter("componentName");



%>

<html>
<head>
<egui:skin ui="admin"/>
<SCRIPT LANGUAGE="JavaScript">

function addToDisabled()
{
	var thisForm = document.tests;
	var enableLen = thisForm.enabledTests.options.length;
	var disableLen = thisForm.disabledTests.options.length;
	var enableList = thisForm.enabledTests;
	var disableList = thisForm.disabledTests;
	//User License - starts
	var userTests = '<%=usrBasedTests%>';
	var userTestsArr = new Array();
	var findings = '';
	if (userTests != null && userTests != "")
	{
		userTestsArr = userTests.split(",");
	}
	for(i=0;i<enableLen;i++)
	{
		if(enableList.options[i].selected==true)
		{
			testTxt = enableList.options[i].text;
			testVal = enableList.options[i].value;
			//user license  starts
			var needToContinue = false;
			for (var u=0; u<userTestsArr.length; u++)
			{
				var userTest = userTestsArr[u];
				if(userTest == testVal)
				{
					if (findings == '')
					{
						findings += testTxt;
					}else
					{
						findings += ','+testTxt;
					}
					needToContinue = true;
					break;
				}
			}
			if (needToContinue)
			{
				continue;
			}
			//ends
			disableList.options[disableLen++]=new Option(testTxt,testVal);
		}
	}
	if (findings != "")
	{
		alert("<egui:intnl text='admin.test.The following test(s) cannot be disabled as these tests are required for validating named user counts for eG licensing'/>. <egui:intnl text='admin.test.Test name(s)'/>: "+findings);
	}
	for(i=enableLen;i>0;i--)
	{
		if(enableList.options[i-1].selected==true)
		{
			//User license -starts
			var testVal = enableList.options[i-1].value;
			var needToContinue = false;
			for (var u=0; u<userTestsArr.length; u++)
			{
				var userTest = userTestsArr[u];
				if(userTest == testVal)
				{
					needToContinue = true;
					break;
				}
			}
			if (needToContinue)
			{
				continue;
			}
			//User license -ends
			enableList.options[i-1]=null;
		}
	}
}

function addToEnabled()
{
	var thisForm = document.tests;
	var enableLen = thisForm.enabledTests.options.length;
	var disableLen = thisForm.disabledTests.options.length;
	var enableList = thisForm.enabledTests;
	var disableList = thisForm.disabledTests;
	for(i=0;i<disableLen;i++)
	{
		if(disableList.options[i].selected==true)
		{
			testTxt = disableList.options[i].text;
			testVal = disableList.options[i].value;
			enableList.options[enableLen++]=new Option(testTxt,testVal);
		}
	}
	for(i=disableLen;i>0;i--)
	{
		if(disableList.options[i-1].selected==true)
		{
			disableList.options[i-1]=null;
		}
	}
}

function updateData()
{
	var thisForm = document.tests;
	var enableLen = thisForm.enabledTests.options.length;
	var enableList = thisForm.enabledTests;
	var enableTest_arr = new Array();
	var disableLen = thisForm.disabledTests.options.length;
	var disableList = thisForm.disabledTests;
	var disableTest_arr = new Array();
	var componentType = thisForm.componentType.value;

	if (componentType == "-1")
	{
		alert('<egui:intnl text="admin.test.Please choose a component type"/>');
		return;
	}

	for (var i=0;i<enableLen;i++)
	{
		enableTest_arr[i] = enableList.options[i].value;
	}

	for (var i=0;i<disableLen;i++)
	{
		disableTest_arr[i] = disableList.options[i].value;
	}

	thisForm.enabledTestList.value = enableTest_arr;
	thisForm.disabledTestList.value = disableTest_arr;
	
	var flagEnable = false;
	var enableTests_Only = new Array();
	var newlyEnabledStr = thisForm.enabledTestList.value;
	var EnabledStr = thisForm.checkEnabledTests.value;
	EnabledStr = ","+EnabledStr+",";
	var newlyEnabledTest="";
	var newlyEnabledTestTokens = newlyEnabledStr.split(",");
	for(i = 0; i < newlyEnabledTestTokens.length; i++)
	{
		newlyEnabledTest = newlyEnabledTestTokens[i];
		if(EnabledStr.indexOf(","+newlyEnabledTest+",") == -1)
		{
			enableTests_Only[i] = newlyEnabledTest;
			flagEnable = true;
		}
	}
	
	
	var flagDisable = false;
	var disableTests_Only = new Array();
	var newlyDisabledStr = thisForm.disabledTestList.value;
	var DisabledStr = thisForm.checkDisabledTests.value;
	var newlyDisabledTest="";
	var newlyDisabledTestTokens = newlyDisabledStr.split(",");
	DisabledStr = ","+DisabledStr+",";
	for(i = 0; i < newlyDisabledTestTokens.length; i++)
	{
		newlyDisabledTest = newlyDisabledTestTokens[i];
		if(DisabledStr.indexOf(","+newlyDisabledTest+",") == -1)
		{
			disableTests_Only[i] = newlyDisabledTest;
			flagDisable = true;
		}
	}
	thisForm.enableTests_Only.value = enableTests_Only;
	thisForm.disableTests_Only.value = disableTests_Only;

	
	if(flagEnable || flagDisable)
	{
		thisForm.submit();
	}
	else
	{
		alert('<egui:intnl text="admin.test.Please choose atleast one test to enable or disable"/>');
		return;
	}
}

function showTests()
{
	var thisForm = document.tests;
	thisForm.method = "post";
	thisForm.action = "EgEnableAndDisableTests.jsp";
	thisForm.submit();
}
</SCRIPT>
</head>

<body style="overflow:auto" id="space6">
<jsp:useBean id="testlist" scope ="page" class ="egurkha.TestConfigSpecsBean"/>

<form name="tests" method="post" action="EgEnableAndDisableTestsp.jsp" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
<%
	if (showBackButton.equalsIgnoreCase("true"))
	{
%>
	<jsp:include page="listSearch.jsp?title=ENABLE / DISABLE TESTS&subtitle=false&backButton=true"/>
<%
	}
	else
	{
%>
	<jsp:include page="listSearch.jsp?title=ENABLE / DISABLE TESTS&subtitle=false"/>
<%
	}
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
<%
	if (isConfigSupported)
	{
%>
				<tr>
					<td width="7" align="left" class="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" nowrap colspan="3" class="form_border">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td width="15%" align="right"><egui:intnl text="admin.server.Component type"/>&nbsp;:&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="35%">&nbsp;&nbsp;<select name="componentType" id="componentType" style="width:230px" onchange="javascript:showTests()">
<%
		if (componentTypes != null && componentTypes.length > 0)
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Choose a component type" /></option>
<%
			serverList = sorter.getSortedCompTypeList(serverList);
			//get the actual and display names of component types
			for (int j=0;j<serverList.size();j++)
			{
				EgName nameObj = (EgName)serverList.get(j);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();
				if(tmpVal.equals(componentType))
				{
%>
					<option value="<%=tmpVal%>" selected><%=tmpDis%></option>
<%
				}
				else
				{
%>
					<option value="<%=tmpVal%>"><%=tmpDis%></option>
<%
				}
			}
		}
		else
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}
%>
								</select>
								</td>
								<td width="20%" align="right"><egui:intnl text="admin.test.Test Type"/> : </td>
								<td id="eg_subcontentbg" align="left" class="paddingright" width="30%">&nbsp;&nbsp;<select name="testType" style="width:220px" onchange="javascript:showTests()">
								<option value="PerformanceTest" <%=pfSelected%>><egui:intnl text="admin.test.Performance" /></option>
								<option value="ConfigurationTest" <%=cfSelected%>><egui:intnl text="admin.test.Configuration" /></option>
								</select></td>
							</tr>
						</table>
					</td>
					<td width="7" class="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
<%
	}
	else
	{
%>
				<tr>
					<td width="7" align="left" class="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td align="center" class="form_border" nowrap colspan="3">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td width="35%" align="right" nowrap> <egui:intnl text="admin.server.Component type"/></td>
								<td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright"><select name="componentType" onchange="javascript:showTests()">
<%
		if (componentTypes != null && componentTypes.length > 0)
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Choose one" /></option>
<%
			serverList = sorter.getSortedCompTypeList(serverList);
			//get the actual and display names of component types
			for (int j=0;j<serverList.size();j++)
			{
				EgName nameObj = (EgName)serverList.get(j);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();
				if(tmpVal.equals(componentType))
				{
%>
					<option value="<%=tmpVal%>" selected><%=tmpDis%></option>
<%
				}
				else
				{
%>
					<option value="<%=tmpVal%>"><%=tmpDis%></option>
<%
				}
			}
		}
		else
		{
%>
			<option value="-1"><egui:intnl text="admin.common.Not Applicable"/></option>
<%
		}
%>
									</select>
								</td>
							</tr>
						</table>
					</td>
					<td width="7" class="form_border"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
<%
	}

	if (componentType != null && !componentType.equalsIgnoreCase("null") && !componentType.equals("-1") && 
		aListEnabledTests.isEmpty() && aListDisabledTests.isEmpty())
	{
%>
				<tr>
					<td colspan="5" id="eg_subcontentbg" class="padding4">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%" height="100%">
										<tr>
											<td align="center" height="350" valign="middle">
												<table border="0" align="center" width="100%" class="body_text">
													<tr>
														<td align="center" valign="bottom"><img src="/final/config/images/exclamation-icon.gif"></td>
													</tr>
													<tr>
														<td align="center" valign="top"><egui:intnl text="admin.test.No configuration tests are available for this component type" /></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" width="100%" colspan="3" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	else
	{
%>
				<tr>
					<td colspan="5" id="eg_subcontentbg" class="padding4"><br>
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td width="45%" valign="top">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4"><strong><egui:intnl text="admin.test.Enabled Tests"/></strong></td>
										</tr>
										<tr>
											<td align="center" valign="top">
												<select name="enabledTests" size="22" multiple width="320" style="width:320px;margin:0px;">
<%
		aListEnabledTests=sorter.getSortedTestList(aListEnabledTests);
		for (int i=0;i<aListEnabledTests.size();i++)
		{
			EgName name = (EgName)aListEnabledTests.get(i);
			String enableVal = name.getActualName();
			String enableDis = name.getLocalName();
			checkEnabledTests = checkEnabledTests+","+enableVal;
%>
			<option value="<%=enableVal%>"><%=enableDis%></option>
<%
		}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
								<td id="tablebg2"  nowrap>&nbsp;&nbsp;&nbsp;</td>
								<td width="10%" align="center" valign="middle" id="head_padding2">
									<input type="button" value='&rsaquo;&rsaquo;' class="eg_lightbutton" name="unman" style="width: 85px; letter-spacing: 0px; font-size:13px; height:20px" onclick="javascript:addToDisabled()">
									<br><br><br>
									<input type="button" value='&lsaquo;&lsaquo;' class="eg_lightbutton" name="man" style="width: 85px; letter-spacing: 0px; font-size:13px; height:20px" onclick="javascript:addToEnabled()">
								</td>
								<td id="tablebg2"  nowrap>&nbsp;&nbsp;&nbsp;</td>
								<td width="45%" valign="top">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-left-width:1px"><strong><egui:intnl text="admin.test.Disabled tests"/></strong></td>
										</tr>
										<tr>
											<td align="center" valign="top">
												<select name="disabledTests" size="22" multiple width="320" style="width:320px;margin:0px;">
<%
		aListDisabledTests = sorter.getSortedTestList(aListDisabledTests);
		for (int j=0;j<aListDisabledTests.size();j++)
		{
			EgName name = (EgName)aListDisabledTests.get(j);
			String disableVal = name.getActualName();
			String disableDis = name.getLocalName();
			checkDisabledTests = checkDisabledTests+","+disableVal;
%>
			<option value="<%=disableVal%>"><%=disableDis%></option>
<%
		}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" width="100%" colspan="3" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
<%
	
	if(!(checkEnabledTests.equalsIgnoreCase("") || checkEnabledTests.equalsIgnoreCase("null")))
	{
		if(checkEnabledTests.startsWith(","))
		{

			checkEnabledTests = checkEnabledTests.substring(1,checkEnabledTests.length());
		}
	}
	if(!(checkDisabledTests.equalsIgnoreCase("") || checkDisabledTests.equalsIgnoreCase("null")))
	{
		if(checkDisabledTests.startsWith(","))
		{
			checkDisabledTests = checkDisabledTests.substring(1,checkDisabledTests.length());
		}
	}

%>
	<tr>
		<td align="center" height="40" valign="middle">
			<input type="button" name="updateButton" value='<egui:intnl text="admin.common.Update"/>' class="eg_back" style="width: 90px;" onClick="javascript:updateData()">
		</td>
	</tr>
<%
	}
%>

</table>
<input type="hidden" name="enabledTestList" value="">
<input type="hidden" name="disabledTestList" value="">
<input type="hidden" name="showBackButton" value="<%=showBackButton%>">
<input type="hidden" name="checkEnabledTests" value="<%=checkEnabledTests%>">
<input type="hidden" name="checkDisabledTests" value="<%=checkDisabledTests%>">
<input type="hidden" name="enableTests_Only" value="">
<input type="hidden" name="disableTests_Only" value="">

</form>
<%
	session.setAttribute("adminLastAccessedURL","/final/admin/EgEnableAndDisableTests.jsp?componentType="+componentType+"&testType="+testType);
%>
</body>
</html>



