<%
/**
 *	File name       :	EgChangePorts.jsp
 *  Purpose			:	To serve as a template for all the jsp's to be written
 *						in the project
 *	Version			:	0.0
 *	Creation Date	:	25-07-2000
 *  Last Date		:	
 *		09/07/2004	Arun		Allows servers to have NULL ports
 *		04/03/2002 //sandhya - commented code which checks for unique port number.
		05/11/2001 //sandhya - To check for special characters. 	
		01/11/2001 //sandhya - To check for unique port number. 
		26/07/2001 //sandhya - To check for ',' in consecutive positions. 
		17/07/2001 //sandhya - To fix servertypes with '#'
		04/07/2001 //Sandhya - To hide servers with 'NULL' port 
		11/06/2001 //Sandhya - Check for snmpcommunity string
		28-05-2001 //Sandhya - To fix servertypes with '#'
		23-05-2001 //Sandhya - Layout 
		27-04-2001 //Sandhya - Included validation for SNMP Community Strings to enter blank values.
		26-04-2001 //Sandhya - To include Port Settings & SNMP Settings
		24-02-2001 //Sandhya - Validation for space & port number before and after comma
		14-02-2001 //Krishna to add client side validations
		29-01-2001 //Sandhya - Ports 
		31-07-2000
 *	Author			:	Ravi.N
 *	Design Changes	:	Jaiwin
	Design Changes  :	Vijaykumar 4.1.2007
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.eg.*"%>
<%@ page import = "com.egurkha.util.*" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);
	String refferalURL = request.getParameter("refferalURL");
	String showModify = request.getParameter("showModify");
	String actionType = request.getParameter("actionType");
	String platform = request.getParameter("platform");
	String frmLocation = request.getParameter("frmLocation");
	String discovery_state = "";
	discovery_state = (String) session.getValue("discovery_state");
	String isRedirected = request.getParameter("isRedirected");
	if (actionType == null || actionType.equalsIgnoreCase("null"))
	{
		actionType = "";
	}

	String eg_inifile = "eg_ui.ini";
	String egUIDir = EgInstallInfo.getInstallDir() + "/manager/config/";
	String updateValue = request.getParameter("updateValue");
	if (updateValue != null && updateValue.equalsIgnoreCase("yes"))
	{
		String discovery_val = request.getParameter("discovery_val");
		IniFile discoveryIniFileWr = null;
		discoveryIniFileWr = EgConfigFilesSync.getInstance(egUIDir + eg_inifile,true);
		discoveryIniFileWr.setValue("EASE_OF_USE","managerDiscovery",discovery_val);
		discoveryIniFileWr.saveFile();
		EgConfigFilesSync.releaseInstance(discoveryIniFileWr);
	}
	IniFile discoveryUI = new IniFile(egUIDir + eg_inifile);
	String managerDiscovery = discoveryUI.getValue("EASE_OF_USE","managerDiscovery");
	if (managerDiscovery == null || managerDiscovery.length() == 0)
	{
		managerDiscovery = "enabled";
	}
	//String envIPRange = EgIPv4Range.getIPv4Range();
	String envIPRange = EgIPAddressStack.fetchLocalIPRange();
	if (envIPRange == null) envIPRange = "";
%>
<%!
	String[] icmpoptions = new String[2];
	public void jspInit()
	{
		icmpoptions[0] = "Yes";
		icmpoptions[1] = "No";
	}
%>
<%
	String discBase,periodIndex,discTimeoutIndex,icmpfordiscovery;
%>
	<jsp:useBean id="DiscBean" scope="page" class="egurkha.ServiceBean"/>
<%
	DiscBean.createAdmin();
	discBase = DiscBean.getDiscBase();
	periodIndex = DiscBean.getRdperiod();
	String thisIsDHCP = DiscBean.getDHCPInfo();
	//String needFQDN = DiscBean.getFQDNInfo();
	String select0="";
	String select30="";
	String select60="";
	String select180="";
	String select360="";
	String select1440="";
	String select10080="";
	if(periodIndex.equals("0"))
		select0="selected";
	else if (periodIndex.equals("30"))
		select30="selected";
	else if (periodIndex.equals("60"))
		select60="selected";
	else if (periodIndex.equals("180"))
		select180="selected";
	else if (periodIndex.equals("360"))
		select360="selected";
	else if (periodIndex.equals("1440"))
		select1440="selected";
	else if (periodIndex.equals("10080"))
		select10080="selected";

	discTimeoutIndex = DiscBean.getdiscTimeout();
	int discovery_timeout = 250;
	if(discTimeoutIndex !=null && discTimeoutIndex.length() > 0){
		try{
			discovery_timeout = Integer.parseInt(discTimeoutIndex);
		}
		catch(Exception e){
			discovery_timeout = 250;
		}
	}
	icmpfordiscovery = DiscBean.getIcmpForDiscovery();
	String from="";
	from=request.getParameter("from");
	String sub = "";
	if ( from != null && from.startsWith("hmc"))
		sub = "HMC";
	else if (from != null && from.startsWith("cloud"))
		sub = "PUBLIC_CLOUDS";
	else 
		sub = "VIRTUAL_CENTER";
	String uiFile = "eg_services.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	IniFile testIniFile = new IniFile(s_iniFile_dir + uiFile);
	String memory=testIniFile.getValue("EXEC","VcDiscover_Mem");
	if(memory!=""&&memory.length()>0)
	memory = memory.substring(0,memory.indexOf("M"));
	else
	memory="";
	String[] allValues = testIniFile.getLinesUnderSubject(sub);
	String[] allVCs = testIniFile.getVariables(sub);
	String un = "";
	String pw = "";
	String hn = "";
	String ssl = "";
	String isdis = "";
	String ip="";
	String isSsl="";
	String isDiscovery="";
	String uName="";
	String uPass="";
	String webPort = "";
	String hName = "";
	String account = "";
	Hashtable allData = new Hashtable();
	if(from.equals("add")||from.equals("delete")||from.equals("modify") || from.equals("view")||from.equals("hmcAdd")||from.equals("hmcDelete")||from.equals("hmcModify") || from.equals("hmcView"))
	{
		ip=request.getParameter("ipAdd");
		StringTokenizer st = null;
		StringTokenizer st1 = null;
		//Hashtable allData = new Hashtable();
		
		if(allValues!=null&&allValues.length>0)
		{
			for(int i=0;i<allValues.length;i++)
			{
				String str = allValues[i];
				st = new StringTokenizer(str,"=");
				String s1 = st.nextToken();
				String s2 = st.nextToken();
				ArrayList content =new ArrayList();
				if(s2!=null)
				{
					st1 = new StringTokenizer(s2,"#");
					if (st1.hasMoreTokens() && st1.countTokens() == 5)
					{
						ssl = st1.nextToken();
						un = st1.nextToken();
						pw = st1.nextToken();
						isdis = st1.nextToken();
						if(from.startsWith("hmc"))
							hn = st1.nextToken();
						else
							webPort = st1.nextToken();
					}
				}
				pw = EgCrypt.decrypt(pw);
				content.add(ssl);
				content.add(isdis);
				content.add(un);
				content.add(pw);
				if(from.startsWith("hmc"))
					content.add(hn);
				else
				content.add(webPort);
				allData.put(s1,content);
			}
		}
		

		if(ip!=null&&!from.equals("add") && !from.equals("hmcAdd"))
		{
			ArrayList content = (ArrayList)allData.get(ip);
			if(from.startsWith("hmc"))
			{
				isSsl=(String)content.get(0);
				isDiscovery=(String)content.get(1);
				uName=(String)content.get(2);
				uPass=(String)content.get(3);
				hName = (String)content.get(4);
			}
			else
			{
				isSsl=(String)content.get(0);
				isDiscovery=(String)content.get(1);
				uName=(String)content.get(2);
				uPass=(String)content.get(3);
				webPort = (String)content.get(4);
			}
		}
	}
	else if (from.startsWith("cloud"))//Added by karthika 
	{
		account=request.getParameter("account");
		StringTokenizer st = null;
		StringTokenizer st1 = null;
		//Hashtable allData = new Hashtable();
		
		if(allValues!=null&&allValues.length>0)
		{
			for(int i=0;i<allValues.length;i++)
			{
				String str = allValues[i];
				st = new StringTokenizer(str,"=");
				String s1 = st.nextToken();
				String s2 = st.nextToken();
				ArrayList content =new ArrayList();
				if(s2!=null)
				{
					st1 = new StringTokenizer(s2,"#");
					if (st1.hasMoreTokens() && st1.countTokens() == 3)
					{
						un = st1.nextToken();
						pw = st1.nextToken();
						isdis = st1.nextToken();
					}
				}
				un = EgCrypt.decrypt(un);
				pw = EgCrypt.decrypt(pw);
				content.add(un);
				content.add(pw);
				content.add(isdis);
				allData.put(s1,content);
			}
		}
		

		if(account!=null)
		{
			ArrayList content = (ArrayList)allData.get(account);
			uName=(String)content.get(0);
			uPass=(String)content.get(1);
			isDiscovery=(String)content.get(2);
		}
	}//cloud ends here
	if (uPass != null && uPass.length() > 0)
	{
		uPass = StringUtils.replace(uPass,"\"","&#34;");
	}

	String[] ip_sec=DiscBean.getIpranges();
	StringBuffer IPBuffer = new StringBuffer(ip_sec.length*30);
	if(ip_sec.length > 2)
	{
		for(int x=1;x<ip_sec.length;x++)
		{
			IPBuffer.append(ip_sec[x].trim());
			IPBuffer.append(",");
		}
	}
	else if(ip_sec.length > 1)
	{
		IPBuffer.append(ip_sec[1].trim());
	}
	String cfgIP = IPBuffer.toString().trim();

	IniFile infraPtr = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
	String DiscOptions = request.getParameter("DiscOptions");
	if(DiscOptions==null || DiscOptions.length()==0) DiscOptions = "all";	
	String categoryOptions="";
	StringBuffer categoryBuff = new StringBuffer();
	StringTokenizer stz = new StringTokenizer(DiscOptions,",");
	while(stz.hasMoreTokens())
	{
		String tok = stz.nextToken();
		if(tok.equalsIgnoreCase("all"))
		{
			DiscOptions = "all";
			break;
		}
	}
	if(DiscOptions.equalsIgnoreCase("all"))
	{
		String[] categVar = infraPtr.getSubjects();
		if(categVar!=null && categVar.length>0)
		{
			for(int i=0;i<categVar.length;i++)
			{
				String var = (String)categVar[i];
				categoryBuff.append(var);
				categoryBuff.append(",");				
			}
		}
		categoryBuff.append("OTHERS");
		categoryOptions = categoryBuff.toString();
	}
	else categoryOptions=DiscOptions;
%>

<html>
<head>
<title>Change Preferences</title>
<meta name="created" content="28/6/2k">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" />  -->
<egui:skin ui="admin"/>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script src="eg_scripts/validate.js"></script>
<script language="JavaScript" src="eg_scripts/eg_validate.js"></script>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="eg_scripts/eg_configtest.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script type="text/javascript" src="/final/monitor/eg_scripts/prototype-1.6.0.3.js"></script>
<script src="/final/scripts/DD_roundies_0.0.2a-min.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/common.js"></script>
<script  src="/final/jquery/jquery.js"></script>
<script  src="/final/jquery/ui/jquery.ui.core.js"></script>
<script language="Javascript1.2">
var $j = jQuery.noConflict();
var validationLoadingMsg="<table width='540' border='0' bgcolor='white' height='170px'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center vlaign=top><egui:intnl text='admin.common.Trying to get validation information from the agent'/>...<br><egui:intnl text='admin.common.This may take a few minutes'/>...</td></tr></table>";
function checkcons(val)
{
	for(var k=0;k < val.length;k++)
	{
		if(val.charAt(k) == ',' && val.charAt(k + 1) == ',')
		{
			alert("<egui:intnl text='admin.discovery.Cannot have \' , \' in consecutive positions'/>.");
			return false;
		}
		else
		{
			continue;
		}
	}
	return true;
}


function isNetscape() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for Navigator ver 4+. 
   if ((appName == "Netscape") && (appVer >= 4)) return true;
   return false;
}

function isIE() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for IE ver 4+. 
   if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
   return false;
}

function valform()
{
	var thisForm = document.changeports;
	var flag = true;
	var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
	var where='<%=from%>';
	if(where == 'changeSettings')
	{
		flag = true;
	}
	else if(where=='changePorts')
	{
		var count= thisForm.Ports.length;

		for(var i=0;i < count ;i++)
		{
			var serverport = thisForm.Ports[i];
			var serverportvalue = thisForm.Ports[i].value;

			for(var k=0;k < serverportvalue.length;k++)
			{
				if(serverportvalue.charAt(k) == ',' && serverportvalue.charAt(k + 1) == ',')
				{
					alert("<egui:intnl text='admin.discovery.Cannot have \' , \' in consecutive positions'/>.");
					thisForm.Ports[i].focus();
					flag=false;
					break;
				}
				else
				{
					continue;
				}
			}

			if(!checkblank(serverport))
			{
				alert('<egui:intnl text="admin.discovery.Blank values are not allowed"/>');
				thisForm.Ports[i].focus();
				flag=false;
				break;
			}
			else if(!checkspace(serverport))
			{
				thisForm.Ports[i].focus();
				flag=false;
				break;
			}
			else if(!checkcomma(serverport))
			{
				alert('<egui:intnl text="admin.discovery.Please enter a port number"/>');
				thisForm.Ports[i].focus();
				flag=false;
				break;
			}
			else if (serverport.value.indexOf(",") > -1)
			{
				var splittedVal = serverport.value.split(",");
				for (n=0;n<splittedVal.length;n++)
				{
					var element = splittedVal[n];
					if (element > 99999)
					{
						alert('<egui:intnl text="admin.common.Invalid port number"/>');
						thisForm.Ports[i].focus();
						flag=false;
						break;
					}
				}
			}
			else if (((!checknumber("+",serverport) && serverportvalue.indexOf(',') == -1) || serverportvalue == 0 || serverportvalue.indexOf('.') > -1) && (serverportvalue != 'NULL'))
			{
				alert('<egui:intnl text="admin.discovery.Port number can consist of only valid numbers"/>');
				thisForm.Ports[i].focus();
				flag=false;
				break;
			}
			else if(!checkspecialnomess(serverport,splChar) && (serverportvalue != 'NULL'))
			{
				alert('<egui:intnl text="admin.discovery.Special characters not allowed"/>');
				thisForm.Ports[i].focus();
				flag = false;
				break;
			}
		}
	}
	else if(where=='changeSnmp')
	{
		if(thisForm.Community.value.length == 0)
		{
			if(flag != false)
			{
				flag = true;
			}
		}
		else if(!validateSingleByte(thisForm.Community.value))
		{
			alert('<egui:intnl text="admin.discovery.SNMP community string is not allowed in DBL(Chinese,Korean,Japanese)"/>');
			thisForm.Community.focus();
			flag=false;
		}
		//else if(!checkspecial(thisForm.Community,"`~!@#$%^&*()=+{}[]|\\:;\"\'<>?\/"))
		//{
		//	thisForm.Community.focus();
		//	flag=false;
		//}
		else if (thisForm.Community.value.indexOf(">") > -1 || 
			thisForm.Community.value.indexOf("<") > -1 || 
			thisForm.Community.value.indexOf("|") > -1 || 
			thisForm.Community.value.indexOf("\"") > -1)
		{
			alert(_snmpcomma);
			thisForm.Community.focus();
			flag=false;
		}
		//else if(!checkspace(thisForm.Community))
		//{
		//	thisForm.Community.focus();
		//	flag=false;
		//}
		//else if(!checkcomma(thisForm.Community))
		//{
		//	alert('<egui:intnl text="admin.discovery.Please enter a community string"/>');
		//	thisForm.Community.focus();
		//	flag=false;
		//}
		else if (thisForm.Community!= null && 
				(thisForm.Community.value.indexOf("-")== 0 || 
				thisForm.Community.value.charAt(thisForm.Community.value.length-1) == '-'))
		{
			alert('<egui:intnl text="admin.snmp.First and last character should not be a hyphen symbol"/>');
			thisForm.Community.focus();
			flag=false;
		}
		var snmpString = window.parent.document.getElementById("snmpString");
		if (snmpString != null && snmpString != 'undefined')
		{
			snmpString.innerHTML = thisForm.Community.value;
		}
	}
	else
	{
		if(!isNumber("+",thisForm.memory.value)||thisForm.memory.value.length == 0)
		{
			alert('<egui:intnl text="admin.discovery.Please enter a number"/>');
			thisForm.memory.focus();
			flag=false;
		}
		else if(!checkspecial(thisForm.memory,"`~!@#$%^&*()=+{}[]|\\:;\"\'<>?\/"))
		{
			thisForm.memory.focus();
			flag=false;
		}
		else if(!checkspace(thisForm.memory))
		{
			thisForm.memory.focus();
			flag=false;
		}
		else if(!checkcomma(thisForm.memory))
		{
			alert('<egui:intnl text="admin.discovery.Please enter a memory range"/>');
			thisForm.memory.focus();
			flag=false;
		}
		if (parseInt(thisForm.memory.value) < 256)
		{
			if (confirm('Memory range should be greater than or equal to 256 MB. Do you want to proceed?'))
			{
				flag = true;
			}
			else
			{
				flag = false;
			}
		}
	}

	if(flag == true)
	{
		if (isNetscape()) targetObj = document.changeports.update;
		if (isIE()) targetObj = document.changeports.update;
		//targetObj.disabled = true;
		thisForm.action="./Egchangeportsp.jsp?from="+where;
		document.changeports.submit();
	}
}
function call()
{
	window.location.href = "./EgDiscovery.jsp";
}

function validateFormVC(check)
{
	var thisForm = document.esxDiscovery;
	var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
	var webPortValue = thisForm.webport.value;
	var where='<%=from%>';
	if(thisForm.ipAdd.value == 'Choose vCenter')
	{
		alert('<egui:intnl text="admin.discovery.Please choose a vCenter identity"/>');
		thisForm.ipAdd.focus();
		return;
	}
	if(!checkblank(thisForm.ipAdd)||thisForm.ipAdd.value == 'none'||thisForm.ipAdd.value == 'None'||thisForm.ipAdd.value == 'other'||thisForm.ipAdd.value == 'Other')
	{
		alert('<egui:intnl text="admin.discovery.Please enter the vCenter identity"/>');
		thisForm.ipAdd.focus();
		return;
	}
	if (where != "modify")
	{
		if(!validateIpOrHName(thisForm.ipAdd.value))
		{
			thisForm.ipAdd.focus();
			return;
		}
	}
	var hostLen = thisForm.ipAdd.value;
	if (hostLen != null && hostLen.length > 32)
	{
		alert('<egui:intnl text="admin.discovery.Maximum host name length is 32 characters"/>');
		thisForm.ipAdd.focus();
		return;
	}
	if(!checkblank(thisForm.uname))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the username"/>');
		thisForm.uname.focus();
		return;
	}
	else if(!checkspecial(thisForm.uname,"	@#$%^&*+={}|:;\"\'<>,\/"))
	{
		thisForm.uname.focus();
		return;
	}
	else if(!checkHyphenText(thisForm.uname.value,thisForm.uname.name))
	{
		thisForm.uname.focus();
		return;
	}

	if(thisForm.pass.value == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the password"/>');
		thisForm.pass.focus();
		sub = false;
		return;
	}
	else if(!checkspecialnomess(thisForm.pass,"|"))
	{
		alert("<egui:intnl text='admin.test.Password data should not contain pipe'/>");
		thisForm.pass.focus();
		sub = false;
		return;
	}
	else if(!checkForPassValidity(thisForm.pass.value))
	{
		thisForm.pass.focus();
		sub = false;
		return;
	}
	else if(thisForm.confpasswd.value == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the confirm password"/>');
		thisForm.confpasswd.focus();
		sub = false;
		return;
	}
//	else if(!checkloginpass(thisForm.confpasswd))
//	{
//		thisForm.confpasswd.focus();
//		sub = false;
//		return;
//	}
	else if(!checkspace(thisForm.confpasswd))
	{
		thisForm.confpasswd.focus();
		sub = false;
		return;
	}
	else if(thisForm.pass.value != thisForm.confpasswd.value)
	{
		alert('<egui:intnl text="admin.discovery.Passwords do not match"/>');
		thisForm.confpasswd.focus();
		sub = false;
		return;
	}
	else if(!checkblank(thisForm.webport))
	{
		alert('<egui:intnl text="admin.discovery.Blank values are not allowed"/>');
		thisForm.webport.focus();
		sub = false;
		return;
	}
	else if(!checkspace(thisForm.webport))
	{
		thisForm.webport.focus();
		sub = false;
		return;
	}
	else if (thisForm.webport.value > 99999)
	{
		alert('<egui:intnl text="admin.discovery.Webport should be less than 99999"/>');
		thisForm.webport.focus();
		sub = false;
		return;
	}
	else if(!checkcomma(thisForm.webport))
	{
		alert('<egui:intnl text="admin.discovery.Please enter a port number"/>');
		thisForm.webport.focus();
		sub = false;
		return;
	}
	else if (((!checknumber("+",thisForm.webport) && webPortValue.indexOf(',') == -1) || webPortValue == 0 || webPortValue.indexOf('.') > -1) && (webPortValue == 'NULL') || (webPortValue.indexOf(',') > -1))
	{
		alert('<egui:intnl text="admin.discovery.Port number can consist of only valid numbers"/>');
		thisForm.webport.focus();
		sub = false;
		return;
	}
	else if(!checkspecialnomess(thisForm.webport,splChar) && (webPortValue != 'NULL'))
	{
		alert('<egui:intnl text="admin.discovery.Special characters not allowed"/>');
		thisForm.webport.focus();
		sub = false;
		return;
	}

	var valFrom = '<%=from%>';
	if(thisForm.isDiscovery.value == 'Yes')
	{
		if ("<%=refferalURL%>" == "EgFrame")
		{
			
			thisForm.action = "./Egchangeportsp.jsp?from="+valFrom;
			thisForm.submit();
		}
		else
		{
			var ans = confirm('<egui:intnl text="admin.discovery.Do you want to discover VMware ESX servers"/>?');
			if(ans == true)
			{
				thisForm.StartDiscovery.value = '<egui:intnl text="admin.discovery.Discovery"/>'+"...";
				var checkVal = valFrom+'EsxDiscovery';
				thisForm.action = "./Egchangeportsp.jsp?from="+checkVal;
				thisForm.submit();
			}
			else
			{
				thisForm.action = "./Egchangeportsp.jsp?from="+valFrom;
				thisForm.submit();
			}
		}
		
	}
	else
	{
		thisForm.action = "./Egchangeportsp.jsp?from="+valFrom;
		thisForm.submit();
	}
	
}

function validateFormHMC(check)
{
	var thisForm = document.hmcDiscovery;
	var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
	var where='<%=from%>';
	if(thisForm.ipAdd.value == 'Choose HMC')
	{
		alert('<egui:intnl text="admin.discovery.Please choose a HMC IP"/>');
		thisForm.ipAdd.focus();
		return;
	}
	if(!checkblank(thisForm.ipAdd))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the HMC IP"/>');
		thisForm.ipAdd.focus();
		return;
	}
	if (where != "hmcModify")
	{
		if(!validateIp(thisForm.ipAdd.value))
		{
			thisForm.ipAdd.focus();
			return;
		}
	}
	if(!checkblank(thisForm.hName))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the Host name"/>');
		thisForm.hName.focus();
		return;
	}
	var hostLen = thisForm.hName.value;
	if (hostLen != null && hostLen.length > 32)
	{
		alert('<egui:intnl text="admin.discovery.Maximum host name length is 32 characters"/>');
		thisForm.hName.focus();
		return;
	}
	else if(!checkspace(thisForm.hName.value))
	{
		thisForm.hName.focus();
		return;
	}
	else if(!checkspecial(thisForm.hName,"	`~!@#$%^&*()+={}[]|:\"\'<>,\/;"))
	{
		thisForm.hName.focus();
		return;
	}
	if(!checkblank(thisForm.uname))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the username"/>');
		thisForm.uname.focus();
		return;
	}
	else if(!checkspecial(thisForm.uname,"	`~!@#$%^&*()+={}[]|;\"\'<>,?\/"))
	{
		thisForm.uname.focus();
		return;
	}
	else if(!checkHyphenText(thisForm.uname.value, thisForm.uname.name))
	{
		thisForm.uname.focus();
		return;
	}
	
	if(thisForm.pass.value == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the password"/>');
		thisForm.pass.focus();
		sub = false;
		return;
	}
	else if(thisForm.confpasswd.value == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the confirm password"/>');
		thisForm.confpasswd.focus();
		sub = false;
		return;
	}
	else if(!checkspace(thisForm.pass))
	{
		thisForm.pass.focus();
		sub = false;
		return;
	}
	else if(!checkspecialnomess(thisForm.pass,"|"))
	{
		alert("<egui:intnl text='admin.test.Password data should not contain pipe'/>");
		thisForm.pass.focus();
		sub = false;
		return;
	}
	else if(!checkForPassValidity(thisForm.pass.value))
	{
		thisForm.pass.focus();
		sub = false;
		return;
	}
	else if(!checkblank(thisForm.confpasswd))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the confirm password"/>');
		thisForm.confpasswd.focus();
		sub = false;
		return;
	}
//	else if(!checkloginpass(thisForm.confpasswd))
//	{
//		thisForm.confpasswd.focus();
//		sub = false;
//		return;
//	}
	else if(!checkspace(thisForm.confpasswd))
	{
		thisForm.confpasswd.focus();
		sub = false;
		return;
	}
	else if(thisForm.pass.value != thisForm.confpasswd.value)
	{
		alert('<egui:intnl text="admin.discovery.Passwords do not match"/>');
		thisForm.confpasswd.focus();
		sub = false;
		return;
	}
	
	
	var valFrom = '<%=from%>';
	if(thisForm.isDiscovery.value == 'Yes')
	{
		if ("<%=refferalURL%>" == "EgFrame")
		{
			thisForm.action = "./Egchangeportsp.jsp?from="+valFrom;
			thisForm.submit();
		}
		else
		{
			var ans = confirm('<egui:intnl text="admin.discovery.Do you want to discover pSeries Servers"/>?');
			if(ans == true)
			{
				thisForm.StartDiscovery.value = '<egui:intnl text="admin.discovery.Discovery"/>'+"...";
				var checkVal = valFrom+'HmcDiscovery';
				thisForm.action = "./Egchangeportsp.jsp?from="+checkVal;
				thisForm.submit();
			}
			else
			{
				thisForm.action = "./Egchangeportsp.jsp?from="+valFrom;
				thisForm.submit();
			}
		}
		
	}
	else
	{
		thisForm.action = "./Egchangeportsp.jsp?from="+valFrom;
		thisForm.submit();
	}
}


function validateFormCloud(check)//for cloud
{
	var thisForm = document.cloudDiscovery;
	var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
	var where='<%=from%>';
	if(thisForm.account.value == 'Choose account')
	{
		alert('<egui:intnl text="admin.discovery.Please choose a AWS account"/>');
		thisForm.account.focus();
		return;
	}
	if(!checkblank(thisForm.account))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the AWS account"/>');
		thisForm.account.focus();
		return;
	}
	
	
	if(!checkblank(thisForm.accessKey))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the accessKey"/>');
		thisForm.accessKey.focus();
		return;
	}
	else if(!checkspecial(thisForm.accessKey,"	`~!@#$%^&*()+={}[]|;\"\'<>,?\/"))
	{
		thisForm.accessKey.focus();
		return;
	}
	else if(!checkHyphenText(thisForm.accessKey.value, thisForm.accessKey.name))
	{
		thisForm.accessKey.focus();
		return;
	}
	
	if(thisForm.accessKey.value == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the accessKey"/>');
		thisForm.accessKey.focus();
		sub = false;
		return;
	}
	else if(thisForm.confAccessKey.value == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the confirm accessKey"/>');
		thisForm.confAccessKey.focus();
		sub = false;
		return;
	}
	else if(!checkspace(thisForm.accessKey))
	{
		thisForm.accessKey.focus();
		sub = false;
		return;
	}
	
	else if(!checkForPassValidity(thisForm.accessKey.value))
	{
		thisForm.accessKey.focus();
		sub = false;
		return;
	}
	else if(!checkblank(thisForm.confAccessKey))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the confirm accessKey"/>');
		thisForm.confAccessKey.focus();
		sub = false;
		return;
	}
	else if(!checkspace(thisForm.confAccessKey))
	{
		thisForm.confAccessKey.focus();
		sub = false;
		return;
	}
	else if(thisForm.accessKey.value != thisForm.confAccessKey.value)
	{
		alert('<egui:intnl text="admin.discovery.Access keys do not match"/>');
		thisForm.confAccessKey.focus();
		sub = false;
		return;
	}



	if(!checkblank(thisForm.secretKey))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the accessKey"/>');
		thisForm.secretKey.focus();
		return;
	}
	else if(!checkspecial(thisForm.secretKey,"	`~!@#$%^&*()+={}[]|;\"\'<>,?\/"))
	{
		thisForm.secretKey.focus();
		return;
	}
	else if(!checkHyphenText(thisForm.secretKey.value, thisForm.secretKey.name))
	{
		thisForm.secretKey.focus();
		return;
	}
	
	if(thisForm.secretKey.value == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the accessKey"/>');
		thisForm.secretKey.focus();
		sub = false;
		return;
	}
	else if(thisForm.confSecretKey.value == "")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the confirm accessKey"/>');
		thisForm.confSecretKey.focus();
		sub = false;
		return;
	}
	else if(!checkspace(thisForm.secretKey))
	{
		thisForm.secretKey.focus();
		sub = false;
		return;
	}
	
	else if(!checkForPassValidity(thisForm.secretKey.value))
	{
		thisForm.secretKey.focus();
		sub = false;
		return;
	}
	else if(!checkblank(thisForm.confSecretKey))
	{
		alert('<egui:intnl text="admin.discovery.Please enter the confirm accessKey"/>');
		thisForm.confSecretKey.focus();
		sub = false;
		return;
	}
	else if(!checkspace(thisForm.confSecretKey))
	{
		thisForm.confSecretKey.focus();
		sub = false;
		return;
	}
	else if(thisForm.secretKey.value != thisForm.confSecretKey.value)
	{
		alert('<egui:intnl text="admin.discovery.Secret keys do not match"/>');
		thisForm.confSecretKey.focus();
		sub = false;
		return;
	}
	
	
	var valFrom = '<%=from%>';
	if(thisForm.isDiscovery.value == 'Yes')
	{
		if ("<%=refferalURL%>" == "EgFrame")
		{
			thisForm.action = "./Egchangeportsp.jsp?from="+valFrom;
			thisForm.submit();
		}
		else
		{
			var ans = confirm('<egui:intnl text="admin.discovery.Do you want to discover AWS EC2 cloud regions"/>?');
			if(ans == true)
			{
				thisForm.StartDiscovery.value = '<egui:intnl text="admin.discovery.Discovery"/>'+"...";
				var checkVal = valFrom+'CloudDiscovery';
				thisForm.action = "./Egchangeportsp.jsp?from="+checkVal;
				thisForm.submit();
			}
			else
			{
				thisForm.action = "./Egchangeportsp.jsp?from="+valFrom;
				thisForm.submit();
			}
		}
		
	}
	else
	{
		thisForm.action = "./Egchangeportsp.jsp?from="+valFrom;
		thisForm.submit();
	}
}//cloud ends here

function clearForm()
{
	var thisForm ="";
	if ('<%=from%>'=='add')
		thisForm=window.document.esxDiscovery;
	else if('<%=from%>'=='hmcAdd')
	{
		thisForm=window.document.hmcDiscovery;
		thisForm.hName.value="";
	}
	thisForm.ipAdd.value="";
	thisForm.uname.value="";
	thisForm.pass.value="";
	thisForm.confpasswd.value="";
}

function clearFormCloud() //for cloud
{
	var thisForm ="";
	thisForm=window.document.cloudDiscovery;
	thisForm.account.value="";
	thisForm.accessKey.value="";
	thisForm.confAccessKey.value="";
	thisForm.secretKey.value="";
	thisForm.confSecretKey.value="";

}
function vc_onChange()
{
	var value=document.esxDiscovery.ipAdd.options[document.esxDiscovery.ipAdd.selectedIndex].value;
	if(value=='Choose vCenter')
	{
		//document.esxDiscovery.uname.value="$unconfigured";
		//document.esxDiscovery.pass.value="$unconfigured";
		//document.esxDiscovery.confpasswd.value="$unconfigured";

		document.esxDiscovery.uname.value="";
		document.esxDiscovery.pass.value="";
		document.esxDiscovery.confpasswd.value="";
		document.esxDiscovery.ssl.value='True';
		document.esxDiscovery.webport.value="443";
		return;
	}
	var valFrom = '<%=from%>';
	if ("<%=refferalURL%>" == "EgFrame")
	{
		//calling();
		//alert(parent.EgNewDiscoveryTree);
		//alert(parent.parent.EgNewDiscoveryTree.document.group);
		//parent.frames[0].d.highlightNodeByProcess(" Start ");
		//parent.EgNewDiscoveryTree.call();
		window.location.href = "EgDiscServers.jsp?ipAdd="+value+"&from="+valFrom+"&opt=vCenters&action=modify";
	}
	else
	{
		window.location.href = "EgChangePorts.jsp?ipAdd="+value+"&from="+valFrom;
	}
}

function hmc_onChange()
{
	var value=document.hmcDiscovery.ipAdd.options[document.hmcDiscovery.ipAdd.selectedIndex].value;
	if(value=='Choose HMC IP address')
	{
		document.hmcDiscovery.hName.value="";
		document.hmcDiscovery.uname.value="";
		document.hmcDiscovery.pass.value="";
		document.hmcDiscovery.confpasswd.value="";
		document.hmcDiscovery.ssl.value='True';
		return;
	}
	var valFrom = '<%=from%>';
	if ("<%=refferalURL%>" == "EgFrame")
	{
		window.location.href = "EgDiscServers.jsp?ipAdd="+value+"&from="+valFrom+"&opt=HMCs&action=modify";
	}
	else
	{
		window.location.href = "EgChangePorts.jsp?ipAdd="+value+"&from="+valFrom;
	}
}

function cloudOnChange() // karthika for cloud
{
	var value=document.cloudDiscovery.account.options[document.cloudDiscovery.account.selectedIndex].value;
	if(value=='Choose account')
	{
		document.cloudDiscovery.uname.value="";
		document.cloudDiscovery.pass.value="";
		document.cloudDiscovery.confpasswd.value="";
		return;
	}
	var valFrom = '<%=from%>';
	if ("<%=refferalURL%>" == "EgFrame")
	{
		window.location.href = "EgDiscServers.jsp?account="+value+"&from="+valFrom+"&opt=cloud&action=modify";
	}
	else
	{
		window.location.href = "EgChangePorts.jsp?account="+value+"&from="+valFrom;
	}
}
function checkAll()
{
	var thisForm ="";
	if ('<%=from%>'=='delete')
		thisForm=window.document.esxDiscoveryDel;
	else if('<%=from%>'=='hmcDelete')
		thisForm=window.document.hmcDiscoveryDel;
	else
		thisForm=window.document.cloudDiscoveryDel;
	var select = thisForm.vcAll.checked;
	for(i=0;i<thisForm.elements.length;i++)
	{
		if(thisForm[i].type=="checkbox" && thisForm[i].name!="vcAll")
			thisForm[i].checked =select;
		
	}
}

function checkAllSelected(thisForm)
{
	for(i=0;i<thisForm.elements.length;i++)
	{
		
		if(thisForm[i].type=="checkbox" && thisForm[i].name!="vcAll" && !thisForm[i].checked)
			return false;
	}
	return true;
}

function checkAnySelected(thisForm)
{
	for(i=0;i<thisForm.elements.length;i++)
	{
		if(thisForm[i].type == "checkbox" && thisForm[i].name != "vcAll" && thisForm[i].checked)
			return true;
	}
	return false;
}

function checkItem(ctrl)
{
	var thisForm ="";
	if ('<%=from%>'=='delete')
		thisForm=window.document.esxDiscoveryDel;
	else if('<%=from%>'=='hmcDelete')
		thisForm=window.document.hmcDiscoveryDel;
	else
		thisForm=window.document.cloudDiscoveryDel;
	var flag = ctrl.checked;
	if(flag)
	{
		thisForm.vcAll.checked = checkAllSelected(thisForm);
	}
	else
		thisForm.vcAll.checked = false;
}

function validateFormDelete(entity)
{
	var thisForm ="";
	if (entity=='delete')
		thisForm=window.document.esxDiscoveryDel;
	else if (entity=='hmcDelete')
		thisForm=window.document.hmcDiscoveryDel;
	else
		thisForm=window.document.cloudDiscoveryDel;
	if(!checkAnySelected(thisForm))
	{
		alert('<egui:intnl text="admin.discovery.No Items selected!"/>');
		return;
	}
	else if('<%=from%>' == 'delete' && !confirm('<egui:intnl text="admin.discovery.Are you sure you want to delete this vCenter"/> ?'))
	{
		return;
	}
	else if('<%=from%>' == 'hmcDelete' && !confirm('<egui:intnl text="admin.discovery.Are you sure you want to delete this HMC server"/> ?'))
	{
		return;
	}
	else if('<%=from%>' == 'cloudDelete' && !confirm('<egui:intnl text="admin.discovery.Are you sure you want to delete this AWS EC2 cloud account"/> ?'))
	{
		return;
	}

	var str="";
	var len=thisForm.vc.length;
	
	if(len==undefined)
	{
		if(thisForm.$vc.value!=null)
		{
			var xxx=thisForm.$vc.value;
			str+=xxx+",";
		}
	}
	else
	{
		for (var i=0; i<len;i++) 
		{
			if(thisForm.vc[i].checked)
			{
				var xxx=thisForm.$vc[i].value;
				str+=xxx+",";
			}
		}
	}
	var s='<%=from%>';
	if (entity=='delete')
		thisForm.action = "Egchangeportsp.jsp?from="+s+"&vc="+str;
	else
		thisForm.action = "Egchangeportsp.jsp?from="+s+"&hmc="+str;
	thisForm.submit();
}

function validateCloudDelete(entity) // Added by karthika
{
	var thisForm=window.document.cloudDiscoveryDel;
	if(!checkAnySelected(thisForm))
	{
		alert('<egui:intnl text="admin.discovery.No Items selected!"/>');
		return;
	}
	else if('<%=from%>' == 'cloudDelete' && !confirm('<egui:intnl text="admin.discovery.Are you sure you want to delete this AWS EC2 cloud account"/> ?'))
	{
		return;
	}

	var str="";
	var len=thisForm.account.length;
	
	if(len==undefined)
	{
		if(thisForm.$account.value!=null)
		{
			var xxx=thisForm.$account.value;
			str+=xxx+",";
		}
	}
	else
	{
		for (var i=0; i<len;i++) 
		{
			if(thisForm.account[i].checked)
			{
				var xxx=thisForm.$account[i].value;
				str+=xxx+",";
			}
		}
	}
	var s='<%=from%>';
	thisForm.action = "Egchangeportsp.jsp?from="+s+"&account="+str;
	thisForm.submit();
}
function init()
{
	var from='<%=from%>';
	if(from=="add" || from=="modify" || from=="delete")
	{
		var treeIframe=window.parent.document.getElementById("DiscoveryTree");
		if(treeIframe!=null)
		{
			treeIframe.src="/final/admin/EgDiscoveryTreeUI.jsp?linkFrom=<%=from%>";
		}
	}
}

function setPort(obj)
{
	var thisForm = document.esxDiscovery;
	if (obj != null && thisForm != null && thisForm != 'undefined')
	{
		if (obj.value == 'True')
		{
			thisForm.webport.value="443";
		}
		else
		{
			thisForm.webport.value="80";
		}
	}
}

var validationDragStarted=false;
var startX=0;
var startY=0;
var windowWidth="";
var windowHeight=""
var customizedPopupDiv="customizedPopupDiv";
function startValidationDivDrag(event,divId)
{
	if(divId!=null && divId!='undefined')
	{
		customizedPopupDiv=document.getElementById(divId);
		if(!isIE())
		{
			windowHeight = window.innerHeight;
			windowWidth = window.innerWidth;
		}
		else
		{
			windowWidth=document.body.clientWidth;
			windowHeight=document.body.clientHeight;
		}
		document.body.style.cursor="move";
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event=window.event;
		}
		if(customizedPopupDiv!=null)
		{
			startX=event.clientX-parseInt(customizedPopupDiv.style.left);
			startY=event.clientY-parseInt(customizedPopupDiv.style.top);
		}
		validationDragStarted=true;
	}
}
function dragValidationDiv(event)
{
	var iframe1=document.getElementById("iframe1");
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
	}
	if(validationDragStarted)
	{
		if(customizedPopupDiv!=null)
		{
			var clickXPos=event.clientX;
			var clickYPos=event.clientY;
			var rightMaxPos=windowWidth;
			var leftMaxPos=0;
			var customizedDivXStartPos=(clickXPos-startX);

			if(customizedDivXStartPos<=0)
			{
				customizedPopupDiv.style.left="0";
				if(iframe1!=null)
					iframe1.style.left="0";

			}	
			else if((customizedDivXStartPos+580)<=rightMaxPos)
			{
				
				customizedPopupDiv.style.left=customizedDivXStartPos;
				if(iframe1!=null)
					iframe1.style.left=customizedDivXStartPos;
			}

			var customizedDivYStartPos=(clickYPos-startY);

			if(customizedDivYStartPos<=0)
			{
				customizedPopupDiv.style.top="0";
				if(iframe1!=null)
					iframe1.style.top="0";

			}	
			else if((customizedDivYStartPos+200)<=windowHeight)
			{
				customizedPopupDiv.style.top=(customizedDivYStartPos-50);
				if(iframe1!=null)
					iframe1.style.top=(customizedDivYStartPos-50);
			}
		}
	}
}

function endValidationDivDrag(event)
{
	document.body.style.cursor="default";
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
	}

	startX=0;
	startY=0;
	validationDragStarted=false;
}

function hideMsgDiv()
{
	document.getElementById("discoveryMessage").style.display = "none";
}

function doModify(action)
{
	if (action == "vCenters")
	{
		window.location.href = "EgDiscServers.jsp?autoRefresh=false&startDiscThread=no&showComponent=no&opt=vCenters&action=modify";
	}
	else if (action == "hmc")
	{
		window.location.href = "EgDiscServers.jsp?autoRefresh=false&startDiscThread=no&showComponent=no&opt=HMCs&action=hmcModify";
	}
	else if (action == "cloud")
	{
		window.location.href = "EgDiscServers.jsp?autoRefresh=false&startDiscThread=no&showComponent=no&opt=cloud&action=cloudModify";
	}
}

function scrollWindow()
{
	window.scroll(0,5000); // horizontal and vertical scroll targets
}

function discoveryCheck(val)
{
	window.location.href = "./EgChangePorts.jsp?from=changeSettings&useADDiscovery="+val;
}

function showCredentialSettings(val)
{
	window.location.href = "./EgChangePorts.jsp?from=changeSettings&showCredential="+val;
}

function showMoreSelectedComps()
{
	var selectedComponetsInfo = document.getElementById("selectedComponetsInfo");
	var componets_list = document.getElementById("componets_list");
	var comList = document.getElementById("c_types");
	var len = comList.options.length;
	var strGroups = "<table align=\"center\" name=\"adgroups1\" id=\"adgroups1\" border=\"0\" width=\"100%\" class=\"tableborder_ad\" cellpadding=\"4\" cellspacing=\"0\"><col width=\"33%\"><col width=\"33%\"><col width=\"34%\"><tr>";
	var count = 1;
	var innerTbl = "";
	for (var i=0;i<len;i++)
	{
		if (comList.options[i].selected == true)
		{
			var val = comList.options[i].text;
			if (count <= 3)
			{
				strGroups = strGroups + "<td class=\"tdborder_ad\" valign=\"top\" style=\"width:250px\">&nbsp;"+val+"</td>";
				count = count + 1;
			}
			if (count > 3)
			{
				strGroups = strGroups + "</tr>";
				innerTbl = innerTbl + strGroups;
				strGroups = "<tr>";
				count = 1;
			}
		}
	}
	if (strGroups != "<tr>")
	{
		if (count <= 3)
		{
			strGroups = strGroups;
			count=3-count;
			for (var j=0;j<=count;j++)
			{
				strGroups = strGroups + "<td class=\"tdborder_ad\" valign=\"top\" style=\"width:250px\">&nbsp;</td>";
			}
			strGroups = strGroups + "</tr>";
			innerTbl = innerTbl + strGroups;
		}
		else
		{
			strGroups = strGroups + "</tr>";
			innerTbl = innerTbl + strGroups;
		}
	}
	innerTbl = innerTbl + "</table>";
	componets_list.innerHTML = innerTbl;
	selectedComponetsInfo.style.display = "block";
}

function hideComponets()
{
	var actionDiv = document.getElementById("selectedComponetsInfo");
	actionDiv.style.display = "none";
}

function showComponents()
{
	document.getElementById("compDiv").style.display = "block";
}

function hideCompList()
{
	var comList = document.getElementById("c_types");
	var len = comList.options.length;
	var indexValue = "";
	var isAllChecked = "true";
	var count = 0;
	for (var i=0;i<len;i++)
	{
		if (comList.options[i].selected == true)
		{
			count = count + 1;
			if (count <= 2)
			{
				indexValue = indexValue + comList.options[i].text + ", ";
			}
		}
	}
	if (count == 0)
	{
		return false;
	}

	if (indexValue.length > 0)
	{
		indexValue = indexValue.substring(0,indexValue.length - 2);
	}

	//if (isAllChecked == "false")
	//{
		if (count == 1)
		{
			document.getElementById("dis_comp").innerHTML = indexValue;
		}
		else
		{
			document.getElementById("dis_comp").innerHTML = indexValue+" <span id='moreComp'  title='Show more selected components' style='cursor:pointer;'><a href='javascript:void(0)' onclick='javascript:showMoreSelectedComps()'  class='more_link'>...</a></span>";
		}
	//}
	//else
	//{
	//	document.getElementById("dis_comp").innerHTML = "All";
	//}
	indexValue = "";
	count = 0;
	document.getElementById("compDiv").style.display = "none";
}

function showPortSummary()
{
	document.getElementById('AgentSummaryHeading_2').style.display = 'none';
	if (isNetscape())
	{
		document.getElementById('AgentSummaryHeading_1').style.display = 'table-row';
		document.getElementById('serverPorts').style.display = 'table-row';
	}
	else if (isIE())
	{
		document.getElementById('AgentSummaryHeading_1').style.display = 'block';
		document.getElementById('serverPorts').style.display = 'block';
	}
}

function hidePortSummary()
{
	document.getElementById('AgentSummaryHeading_1').style.display = 'none';
	if (isNetscape())
	{
		document.getElementById('AgentSummaryHeading_2').style.display = 'table-row';
		document.getElementById('serverPorts').style.display = 'table-row';
	}
	else if (isIE())
	{
		document.getElementById('AgentSummaryHeading_2').style.display = 'block';
		document.getElementById('serverPorts').style.display = 'block';
	}
	document.getElementById('serverPorts').style.display = 'none';
}

//function moveToRelative(findChar)
//{
//	ScrollToRelated(findChar);
//}

function populate(selectedItem)
{
	var url;
	var thisForm = document.changeports;
	var isDomainEmpty = false;
	var isSiteEmpty = false;
	var isSubnetEmpty = false;
	selectedDomainName = thisForm.ADdomain.options[thisForm.ADdomain.selectedIndex].value;
	selectedSiteName = thisForm.ADSite.options[thisForm.ADSite.selectedIndex].value;
	selectedSubnets = "";
	if(thisForm.ADSubnet != null)
	{
		for(i=0;i<thisForm.ADSubnet.length;i++)
		{
			if(thisForm.ADSubnet.options[i].selected)
			{
				if(selectedSubnets.length==0)
				{
					selectedSubnets = thisForm.ADSubnet.options[i].value;
				}
				else
				{
					selectedSubnets += ","+ thisForm.ADSubnet.options[i].value;
				}
			}
		}
	}

	if (selectedItem == 'domain')
	{
		if (selectedDomainName == null || selectedDomainName == "none" || selectedDomainName == "undefined")
		{
			isDomainEmpty = true;
		}
		else
		{
			url = '/final/servlet/com.eg.ADDiscoveryHelperServlet?selectedItem=domain&domainName='+selectedDomainName;
		}
	}
	else if (selectedItem == 'site')
	{
		if (selectedSiteName == null || selectedSiteName == "none" || selectedSiteName == "undefined")
		{
			isSiteEmpty = true;
		}
		else
		{
			url = '/final/servlet/com.eg.ADDiscoveryHelperServlet?selectedItem=site&siteName='+selectedSiteName;
			
		}
	}
	else if (selectedItem == 'subnet')
	{
		if (selectedSubnets == null || selectedSubnets == "none" || selectedSubnets == "undefined")
		{
			isSubnetEmpty = true;
		}
		else
		{
			url = '/final/servlet/com.eg.ADDiscoveryHelperServlet?selectedItem=subnet&subnet='+selectedSubnets;
		}
	}
	
	var httpObj = createRequestObject();
	if(httpObj == null)
	{
		alert('error : request object is null');
	}
	else
	{
		httpObj.open("GET", url,true);
		httpObj.onreadystatechange =function()
		{
			if(httpObj.readyState == 4)
			{
				var response = httpObj.responseText;
				if (selectedItem == 'domain')
				{
					if (!isDomainEmpty && response.length>0)
					{
						var arrOptions = response.split(',');
						thisForm.ADSite.options[0] = new Option('<egui:intnl text="admin.discovery.Choose a site"/>','none');
						var i=1;
						for (var k=0;k<arrOptions.length;k++)
						{
							thisForm.ADSite.options[i] = new Option(arrOptions[k],arrOptions[k]);
							i++;
						}
					}
					else
					{
						thisForm.ADSite.options.length=0;
						thisForm.ADSite.options[0] = new Option('<egui:intnl text="admin.discovery.Not Applicable"/>','none');
						isDomainEmpty = true;
						isSiteEmpty = true;
					}
					thisForm.ADSubnet.options.length=0;
					thisForm.ADSubnet.options[0] = new Option('<egui:intnl text="admin.discovery.Not Applicable"/>','none');
					thisForm.ADSubnet.options[0].selected=true;
					//document.getElementById("iprange").innerHTML='<egui:intnl text="admin.discovery.Not Applicable"/>';
				}
				else if (selectedItem == 'site')
				{
					if (!isSiteEmpty && response.length>0)
					{
						var arrOptions = response.split(',');
						for (var k=0;k<arrOptions.length;k++)
						{
							thisForm.ADSubnet.options[k] = new Option(arrOptions[k],arrOptions[k]);
						}
					}
					else if(isDomainEmpty || isSiteEmpty)
					{
						thisForm.ADSubnet.options.length=0;
						thisForm.ADSubnet.options[0] = new Option('<egui:intnl text="admin.discovery.Not Applicable"/>','none');
						thisForm.ADSubnet.options[0].selected=true;
					}
					//document.getElementById("iprange").innerHTML='<egui:intnl text="admin.discovery.Not Applicable"/>';
				}
				else if (selectedItem == 'subnet')
				{
					if (!isSubnetEmpty && response.length>0)
					{
						if (response != null && response.indexOf(",") != -1)
						{
							response  = response.replace(",","\n");
						}
						document.getElementById("iprange").innerHTML=response;
					}
					else 
					{
						//document.getElementById("iprange").innerHTML='<egui:intnl text="admin.discovery.Not Applicable"/>';
					}
				}
			}
		}
		httpObj.send(null);
	}
}

function createRequestObject()
{
	var req = null;
	if(window.XMLHttpRequest)
	{
		req = new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{
		try
		{
			req = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch(e)
		{
			req=null;
		}
	}
	if(req == null)
	{
		var browser = navigator.appName;
		if(browser == "Microsoft Internet Explorer")
		{
			alert('ActiveXObject is not initialized');
		}
		else
		{
			alert('XMLHttpRequest object is not initialized');
		}
	}
	return req;
}

function showResultSets(platform,frmlocation)
{
	frmlocation = frmlocation.toUpperCase();
	//parent.frames[0].location.href = "Eg.jsp?linkFrom=general&date="+new Date();
	if (platform == "virtual")
	{
		parent.frames[0].location.href = "EgLeftDiscoveryPane.jsp?linkFrom=virtual&date="+new Date();
		var resultContainer = window.parent.document.getElementById("resultContainer2");
		resultContainer.innerHTML = "<i><b>The virtual platform settings of your environment for discovery have been updated successfully.</b></i>";
		if (frmlocation.indexOf("MODIFY") != -1)
		{
			var rowID1 = window.parent.document.getElementById("rowID1");
			var rowID2 = window.parent.document.getElementById("rowID2");
			if (!isNetscape())
			{
				rowID1.style.display = "none";
				rowID2.style.display = "block";
			}
			else
			{
				rowID1.style.display = "none";
				rowID2.style.display = "table-row";
			}
		}
		else
		{
			var rowID1 = window.parent.document.getElementById("rowID1");
			var rowID2 = window.parent.document.getElementById("rowID2");
			if (!isNetscape())
			{
				rowID1.style.display = "block";
				rowID2.style.display = "none";
			}
			else
			{
				rowID1.style.display = "table-row";
				rowID2.style.display = "none";
			}
		}
	}
	else
	{
		parent.frames[0].location.href = "EgLeftDiscoveryPane.jsp?linkFrom=cloud&date="+new Date();
		var resultContainer = window.parent.document.getElementById("resultContainer2");
		resultContainer.innerHTML = "<i><b>The cloud settings of your environment for discovery have been updated successfully.</b></i>";
		if (frmlocation.indexOf("MODIFY") != -1)
		{
			var rowID1 = window.parent.document.getElementById("rowID1");
			var rowID2 = window.parent.document.getElementById("rowID2");
			if (!isNetscape())
			{
				rowID1.style.display = "none";
				rowID2.style.display = "block";
			}
			else
			{
				rowID1.style.display = "none";
				rowID2.style.display = "table-row";
			}
		}
		else
		{
			var rowID1 = window.parent.document.getElementById("rowID1");
			var rowID2 = window.parent.document.getElementById("rowID2");
			if (!isNetscape())
			{
				rowID1.style.display = "block";
				rowID2.style.display = "none";
			}
			else
			{
				rowID1.style.display = "table-row";
				rowID2.style.display = "none";
			}
		}
	}
	var divID = window.parent.document.getElementById("resultDiv");
	divID.style.display = "block";
}

function updateDiscSettings()
{
	var thisForm = document.changeports;
	var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_+=[]{}|\\:;\"\'<>.?\/";
	var flag ="<%=discovery_state%>";
	var selectflag = "false";
	var ipr = thisForm.iprange.value;

	while (ipr.charAt(0) == ' ')
	{
		ipr = ipr.substring(1,ipr.length);
	}

	while (ipr.charAt(ipr.length-1)==' ')
	{
		ipr = ipr.substring(0,ipr.length-1);
	}

	var allowToUpdate = true;
	thisForm.iprange.value = ipr;
	if (ipr == "")
	{
		//alert('<egui:intnl text="admin.discovery.Please enter the IP range"/>');
		//thisForm.iprange.focus();
		//return;
	}
	else if (!checkspecialnomess(thisForm.iprange,"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz~!@#$%^&*()'<>,"))
	{
		alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>');
		thisForm.iprange.focus();
		return;
	}
	else if (ipr.indexOf(" ") > -1)
	{
		alert('<egui:intnl text="admin.discovery.Space is not allowed"/>');
		thisForm.iprange.focus();
		return;
	}
	else if (ipr.indexOf("..") > -1 || 
			ipr.indexOf(".,") > -1 || 
			ipr.indexOf(",.") > -1 || 
			ipr.charAt(0) == "," || 
			ipr.charAt(0) == "-" || 
			ipr.charAt(ipr.length - 1) == "-" || 
			ipr.indexOf("--") > -1 || 
			ipr.indexOf('-') < 0)
	{
		alert('<egui:intnl text="admin.discovery.IP range is not valid"/>');
		thisForm.iprange.focus();
		return;
	}
	else if(ipr.charAt(ipr.length - 1) == ",")
	{
		alert('<egui:intnl text="admin.discovery.Please enter the next IP range"/>');
		thisForm.iprange.focus();
		return;
	}
	else if(!validateSingleByte(ipr))
	{
		alert('<egui:intnl text="admin.discovery.IP range not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.iprange.focus();
		return;
	}
	else
	{
		var singleIp = false;
		var comma_array = ipr.replace("\r","").split("\n");
		//var comma_array = ipr.split(',');
		if (comma_array.length == 1)
		{
			singleIp = true;
		}
		for(var i =0;i < comma_array.length;i++)
		{
			var hypen_array = comma_array[i].split('-');
			var caughtInvalidData = false;
			if(hypen_array.length != 2)
			{
				if (singleIp)
				{
					alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>');
				}
				else
				{
					alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>'+" "+(i+1));
				}
				thisForm.iprange.focus();
				caughtInvalidData = true;
				break;
			}
			else
			{
				var ipValid = true;
				var checkIpStatus = checkIp(hypen_array[0]);
				if (checkIpStatus != "success")
				{
					if (singleIp)
					{
						alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>');
					}
					else
					{
						alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>'+" "+(i+1));
					}
					thisForm.iprange.focus();
					caughtInvalidData = true;
					ipValid = false;
					break;
				}

				checkIpStatus = checkIp(hypen_array[1]);
				if (checkIpStatus != "success")
				{
					if (singleIp)
					{
						alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>');
					}
					else
					{
						alert('<egui:intnl text="admin.discovery.Invalid IP in IP range"/>'+" "+(i+1));
					}
					thisForm.iprange.focus();
					caughtInvalidData = true;
					ipValid = false;
					break;
				}

				if (ipValid)
				{
					var colon_array1 = hypen_array[0].split('.');
					var colon_array2 = hypen_array[1].split('.');
					var colonArr1, colonArr2;
					
					for(var m=0;m < colon_array1.length;m++)
					{
						colonArr1 = parseInt(colon_array1[m],10);
						colonArr2 = parseInt(colon_array2[m],10); 
						
						if ( colonArr2 > colonArr1 )
						{
							break;
						}
						else if( colonArr2 < colonArr1 )
						{
							if (singleIp)
							{
								alert('<egui:intnl text="admin.discovery.Second IP should be greater than the first IP"/>');
							}
							else
							{
								alert('<egui:intnl text="admin.discovery.Second IP should be greater than the first IP in IP range "/> '+ (i + 1));
							}
							thisForm.iprange.focus();
							caughtInvalidData = true;
							break;
						}
					}
					if (caughtInvalidData)
					{
						break;
					}
				}
			}
		}

		if (caughtInvalidData)
		{
			allowToUpdate = false;
		}
	}

	//SNMP String validation starts

	if(!validateSingleByte(thisForm.Community.value))
	{
		alert('<egui:intnl text="admin.discovery.SNMP community string is not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.Community.focus();
		flag=false;
	}
	else if (thisForm.Community.value.indexOf(">") > -1 || 
		thisForm.Community.value.indexOf("<") > -1 || 
		thisForm.Community.value.indexOf("|") > -1 || 
		thisForm.Community.value.indexOf("\"") > -1)
	{
		alert(_snmpcomma);
		thisForm.Community.focus();
		flag=false;
	}
	else if (thisForm.Community!= null && 
			(thisForm.Community.value.indexOf("-")== 0 || 
			thisForm.Community.value.charAt(thisForm.Community.value.length-1) == '-'))
	{
		alert('<egui:intnl text="admin.snmp.First and last character should not be a hyphen symbol"/>');
		thisForm.Community.focus();
		flag=false;
	}
	//SNMP String validation ends

	// Port validation starts
	var count= thisForm.Ports.length;
	for(var i=0;i < count ;i++)
	{
		var serverport = thisForm.Ports[i];
		var serverportvalue = thisForm.Ports[i].value;

		for(var k=0;k < serverportvalue.length;k++)
		{
			if(serverportvalue.charAt(k) == ',' && serverportvalue.charAt(k + 1) == ',')
			{
				alert("<egui:intnl text='admin.discovery.Cannot have \' , \' in consecutive positions'/>.");
				showPortSummary();
				thisForm.Ports[i].focus();
				flag=false;
				break;
			}
			else
			{
				continue;
			}
		}

		if(!checkblank(serverport))
		{
			alert('<egui:intnl text="admin.discovery.Blank values are not allowed"/>');
			showPortSummary();
			thisForm.Ports[i].focus();
			flag=false;
			break;
		}
		else if(!checkspace(serverport))
		{
			showPortSummary();
			thisForm.Ports[i].focus();
			flag=false;
			break;
		}
		else if(!checkcomma(serverport))
		{
			alert('<egui:intnl text="admin.discovery.Please enter a port number"/>');
			showPortSummary();
			thisForm.Ports[i].focus();
			flag=false;
			break;
		}
		else if (serverport.value.indexOf(",") > -1)
		{
			var splittedVal = serverport.value.split(",");
			for (n=0;n<splittedVal.length;n++)
			{
				var element = splittedVal[n];
				if (element > 65535)
				{
					alert('<egui:intnl text="admin.common.Invalid port number"/>');
					showPortSummary();
					thisForm.Ports[i].focus();
					flag=false;
					break;
				}
			}
		}
		else if (((!checknumber("+",serverport) && serverportvalue.indexOf(',') == -1) || serverportvalue == 0 || serverportvalue.indexOf('.') > -1) && (serverportvalue != 'NULL'))
		{
			alert('<egui:intnl text="admin.discovery.Port number can consist of only valid numbers"/>');
			showPortSummary();
			thisForm.Ports[i].focus();
			flag=false;
			break;
		}
		else if(!checkspecialnomess(serverport,splChar) && (serverportvalue != 'NULL'))
		{
			alert('<egui:intnl text="admin.discovery.Special characters not allowed"/>');
			showPortSummary();
			thisForm.Ports[i].focus();
			flag = false;
			break;
		}
	}
	// Port validation ends
	if(!flag)
	{
		return true;
	}
	else
	{
		if (allowToUpdate)
		{
			if (isNetscape()) targetObj = document.changeports.startdisc.disabled=true;
			if (isIE()) targetObj = document.changeports.startdisc.disabled=true;
			thisForm.startdisc.value='<egui:intnl text="admin.discovery.Updating"/>'+"...";
			thisForm.action = "Egchangeportsp.jsp?from=changeSettings";
			thisForm.submit();
		}
	}
}

function showDiscoveryAction()
{
	parent.frames[0].location.href = "EgLeftDiscoveryPane.jsp?linkFrom=general&date="+new Date();
	var divID = window.parent.document.getElementById("discoveryPopUP");
	window.parent.document.getElementById("chkConfig2").checked = true;

	if ("<%=cfgIP%>" == "null" || "<%=cfgIP%>" == "" || "<%=cfgIP%>".length == 0)
	{
		window.parent.document.getElementById("ip_cfg").value = 'No';
	}
	else
	{
		window.parent.document.getElementById("ip_cfg").value = 'Yes';
	}

	if (isIE())
	{
		window.parent.document.getElementById('rowDiscovery').style.display = 'block';
		window.parent.document.getElementById('rowConfig').style.display = 'none';
	}
	else
	{
		window.parent.document.getElementById('rowDiscovery').style.display = 'table-row';
		window.parent.document.getElementById('rowConfig').style.display = 'none';
	}
	divID.style.display = "block";
}

function enableDisableDiscovery(from)
{
	if (from == "tree")
	{
		var val = document.getElementById("discoveryOpt").value;
		window.location.href = "EgChangePorts.jsp?from=EnableDisableDiscovery&updateValue=yes&discovery_val="+val;
	}
	else
	{
		window.location.href = "EgChangePorts.jsp?from="+from+"&updateValue=yes&discovery_val=Enable";
	}
}

function fetchNewIP()
{
	var thisForm = document.changeports;
	if ('<%=envIPRange%>' == "" || '<%=envIPRange%>'.length == 0)
	{
		alert("Could not find IP range for this environment.");
	}
	else
	{
		thisForm.iprange.value = '<%=envIPRange%>';
	}
}

function Clear(opt)
{
	var thisForm = document.changeports;
	if (opt == "snmpString")
	{
		thisForm.Community.value = "";
	}
	else
	{
		thisForm.iprange.value = "";
	}
}

function scollWindowTop()
{
	window.scroll(0,0); // horizontal and vertical scroll targets
}

function selectCategory()
{
	var thisForm = document.changeports;
	var list = thisForm.ComponentCategory;
	var listlen = thisForm.ComponentCategory.options.length;
	var category='';
	for (var y = 0 ; y < listlen ; y++ )
	{
		if(list.options[y].selected == true)
		{
			var cat = list.options[y].value;
			category = category+","+cat;
		}
	}
	category = category.substring(category.indexOf(",")+1);	
	
	var  from = '<%=from%>';	
	$j.ajax({
		type: "GET",
		url: "EgChangePorts.jsp",
		data:"DiscOptions="+category+"&from="+from,
		success: function(msg) { 		
			
			var selectContent = $j(msg).find('#c_types').html();		
			$j("#c_types").html(selectContent);			
		}
	});
	
}

</script>
</head>

<!-- <body leftmargin="0" topmargin="20" marginwidth="0" marginheight="20" bgcolor="#FFFFFF"> -->
<body style="overflow:auto" id="space6" onload="javascript:init()"  onmousemove="javascript:dragValidationDiv(event);" onmouseup="javascript:endValidationDivDrag(event);">
<%
	//String title=egMappingInfo.getTextDescription("admin.title.START DISCOVERY >> CHANGE PREFERENCE");
	String title=egMappingInfo.getTextDescription("admin.title.MANAGER DISCOVERY - GENERAL SETTINGS");
	String Qs="";
	if(from.equals("changeSettings"))
	{
		Qs="&from=changeSettings";
	}
	else if(from.equals("changePorts"))
	{
		Qs="&from=changePorts";
	}else if(from.equals("changeSnmp"))
	{
		Qs="&from=changeSnmp";
	}
	else if(from.equals("add")||from.equals("modify") || from.equals("delete") || from.equals("view"))
	{
		Qs="&from=VcSettings";
	}
	else if(from.equals("hmcAdd")||from.equals("hmcModify") || from.equals("hmcDelete") || from.equals("hmcView"))
	{
		Qs="&from=HmcSettings";
	}
	else if(from.equalsIgnoreCase("EnableDisableDiscovery"))
	{
		title=egMappingInfo.getTextDescription("admin.title.MANAGER DISCOVERY - ENABLE / DISABLE");
		Qs="&from=EnableDisableDiscovery";
	}
	else if(from.equals("cloudModify")||from.equals("cloudAdd") || from.equals("cloudView") || from.equals("cloudDelete"))
	{
		Qs="&from=cloudSettings";
	}
%>
<jsp:useBean id="port" scope="page" class="egurkha.ServiceBean"/>
<jsp:useBean id="configTopo" scope="page" class="egurkha.ConfigTopology"/>
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
<%
	String isbackButtonNeeded = request.getParameter("isbackButtonNeeded");
	if (refferalURL == null || refferalURL.equals("null") || refferalURL.length() == 0)
	{
		if (isbackButtonNeeded != null && isbackButtonNeeded.equalsIgnoreCase("yes"))
		{
%>
			<jsp:include page='<%="listSearch.jsp?title="+title+"&leftString=Add User&backButton=true&uriContainer=mainFrame&subtitle=false"+Qs%>'/>
<%
		}
		else
		{
%>
			<jsp:include page='<%="listSearch.jsp?title="+title+"&leftString=Add User&backButton=false&subtitle=false"+Qs%>'/>
<%
		}
	}

String tmpVar = managerDiscovery;
if (from != null && from.equalsIgnoreCase("EnableDisableDiscovery"))
{
	managerDiscovery = "enable";
}
if (managerDiscovery.equalsIgnoreCase("enable"))
{
	if (from != null && from.equalsIgnoreCase("EnableDisableDiscovery"))
	{
		managerDiscovery = tmpVar;
	}

	if(from.equals("changeSettings")||from.equals("changePorts")||from.equals("changeSnmp")||from.equals("memory"))
	{
		ArrayList srvTypeList = new ArrayList();
		ArrayList portList = new ArrayList();

	configTopo.createFile("eg_services.ini");
	String[] servers = configTopo.getVariables("DISCOVERY_SPECIFICATION");

	if (servers != null)
	{
		for (int i=0; i<servers.length; i++)
		{
			String varServer = servers[i];
			if (varServer.startsWith("Format:"))
			{
				continue;
			}
			String val = configTopo.getValues("DISCOVERY_SPECIFICATION", varServer);
			val = val.toLowerCase();
			if (val.startsWith("nodiscovery,") || val.endsWith("-port null"))
			{
				continue;
			}
			if (varServer.startsWith("#"))
			{
				varServer = varServer.substring(1);
			}
			srvTypeList.add(varServer);

			String tmpPort = val.substring(val.indexOf("-port")+5).trim();
			if (tmpPort.indexOf(":") > 0)
			{
				tmpPort = tmpPort.replace(':',',');
			}
			portList.add(tmpPort);
		}
	}

	port.createAdmin();
	String strCommunityStrings = port.getCommunityStrings();
	if(strCommunityStrings != null && strCommunityStrings.indexOf(":") >= 0)
	{
		strCommunityStrings = strCommunityStrings.replace(':',',');
	}


	ArrayList serverList = new ArrayList();
	
	String userLanguage = _user.getLanguage();
	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();

		MappingNameSorter sorter = new MappingNameSorter(userLanguage);
		serverList = sorter.getSortedCompTypeList(srvTypeList);

		// Active Direcotry Subnets or manual IP range

		IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_authenticate.ini");
		String[] domains=iniFile.getSubjects();
		String useADDiscovery = "no";
		useADDiscovery = request.getParameter("useADDiscovery");
		String actDomain = request.getParameter("sDomain");
		String actSite = request.getParameter("sSite");
		String actSubnet = request.getParameter("sSubnet");
		if(useADDiscovery == null || useADDiscovery.length() == 0)
		{
			useADDiscovery = "no";
		}
		boolean isDomainConfigured = false;
		if(domains.length == 0)
		{
			isDomainConfigured = false;
		}
		else
		{
			isDomainConfigured = true;
		}
		boolean usingADDiscovery = (useADDiscovery.equals("yes"));

		String showCredential = request.getParameter("showCredential");
		if(showCredential == null || showCredential.length() == 0)
		{
			showCredential = "no";
		}
		boolean showCredentialSettings = (showCredential.equals("yes"));

		// Finding IP ranges
		String[] ipranges=port.getIpranges();
		StringBuffer ipRange = new StringBuffer(ipranges.length*30);
		String range = null;
		String readOnly = "";

		if (!usingADDiscovery)
		{
			if(ipranges.length > 2)
			{
				for(int x=1;x<ipranges.length;x++)
				{
					ipRange.append(ipranges[x].trim());
					ipRange.append("\n");
				}
			}
			else if(ipranges.length > 1)
			{
				ipRange.append(ipranges[1].trim());
			}
			range = ipRange.toString().trim();
		}
		else
		{
			range = "";
			readOnly = "readonly";
		}
		// To remove the aggregate comp types from the servers List
		EgAggregateInfo aggInfo = new EgAggregateInfo("manager");
		Vector aggTypes = aggInfo.getAggregateTypes();
		aggInfo = null;

		String[] server_types=port.getValidServerTypesForDiscovery();
		ArrayList compList = new ArrayList();

		ArrayList server_list = new ArrayList();
		ArrayList server_list_disp = new ArrayList();
		if(categoryOptions!=null)
		{
			categoryOptions = categoryOptions.trim();
			StringTokenizer st = new StringTokenizer(categoryOptions,",");
			while(st.hasMoreTokens())
			{
				String token = (String)st.nextToken();
				String[] filteredServerTypes= getServerTypesBasedOnPriority(token,server_types,infraPtr);
				for(int j=0;j<filteredServerTypes.length;j++)
				{
					if(filteredServerTypes[j] == null) continue;
					if(filteredServerTypes[j].startsWith("#"))
					{
						compList.add(filteredServerTypes[j].substring(1));
					}
					else
					{
						compList.add(filteredServerTypes[j]);
						server_list.add(filteredServerTypes[j]);
						server_list_disp.add(filteredServerTypes[j]);
					}
				}
			}			
		}
		
		/*String[] server_types=port.getValidServerTypesForDiscovery();
		ArrayList compList = new ArrayList();

		for(int j=1;j<server_types.length;j++)
		{
			if(server_types[j].startsWith("#"))
			{
				compList.add(server_types[j].substring(1));
			}
			else
			{
				compList.add(server_types[j]);
			}
		}

		if(aggTypes != null && compList != null)
		{
			compList.removeAll(aggTypes);
		}

		ArrayList server_list = new ArrayList();
		server_types = null;
		server_types=port.getServertypes();
		for(int k=1;k<server_types.length;k++)
		{
			if(server_types[k].startsWith("#"))
			{
				server_types[k]=new String(server_types[k].substring(1));
				continue;
			}
			else
			{
				server_types[k]=new String(server_types[k]);
				if(server_types[k] != null)
				{
					server_list.add(server_types[k]);
				}
			}
		}*/
		//Collections.sort(compList,String.CASE_INSENSITIVE_ORDER);
		//Collections.sort(server_list,String.CASE_INSENSITIVE_ORDER);
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<form name="changeports" method="post" action="./Egchangeportsp.jsp" >
			<input type="hidden" name="refferalURL" value="<%=refferalURL%>" />
			<input type="hidden" name="actionType" value="<%=actionType%>" />
			<div id="treeDiv" style="border:0px solid #ff0000;z-index:0;">
			<table align="center" width="95%" cellspacing="0" cellpadding="4" border="0">
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
<%
	if(from.equals("changeSettings"))
	{
%>
			<tr id="generalSettings">
				<td>
					<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
						<tr>
							<td class="eg_subcontent" colspan="5" nowrap>
								<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
									<tr>
										<td id="subhead_left" width="7">
											<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
											<egui:intnl text="admin.discovery.MANAGER DISCOVERY SETTINGS OF YOUR ENVIRONMENT"/>
										</td>
										<td id="subhead_right" width="7">
											<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
							<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						</tr>
						<tr>
							<th id="eg_subcontentbg" class="form_border" width="300" nowrap valign="top">
								<egui:intnl text="admin.discovery.Discover infrastructure components using"/><br/><egui:intnl text="admin.discovery.Active Directory"/>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%" valign="top">
								<table cellspacing="0" cellpadding="0" border="0" width="30%">
									<tr>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px"><input class="eg_input" type="radio" value="Domain" name="ADDiscovery" class="eg_input" onClick="javascript:discoveryCheck('yes');" <%=useADDiscovery.equals("yes")?"checked":""%>></td>
										<td id="eg_subcontentbg"  nowrap width="41" ><egui:intnl text="admin.common.Yes" /></td>
										<td id="eg_subcontentbg"  width="2%" style="padding-right:3px"><input class="eg_input" type="radio" value="Eg" name="ADDiscovery" onClick="javascript:discoveryCheck('no');" <%=useADDiscovery.equals("no")?"checked":""%>></td></td>
										<td id="eg_subcontentbg" ><egui:intnl text="admin.common.No"/></td>
									</tr>
								</table>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr>
<%
	if(usingADDiscovery)
	{
%>
						</tr>
							<th id="eg_subcontentbg" class="form_border" width="300" nowrap valign="top">
								<egui:intnl text="admin.discovery.Active Directory Domain"/>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%">
								<select name="ADdomain" onChange="javascript:populate('domain')" width=250 style="width:300px">
<%
		
		ArrayList allDomains=new ArrayList();
		if(domains!=null)
		{
%>
									<option value="none" selected><egui:intnl text="admin.user.Choose a domain"/></option>
<%	
			for(int i=0;i<domains.length;i++)
			{
				String domain = domains[i];
				allDomains.add(domain);
				
			}
		}
		Collections.sort(allDomains,String.CASE_INSENSITIVE_ORDER);
		if(allDomains!=null && allDomains.size() > 0)
		{
			for(int i=0;i<allDomains.size();i++)
			{
				String domain = (String) allDomains.get(i);
				
%>
									<option value="<%=domain%>" ><%=domain%></option>
<%
			}
		}
%>
								</select>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr>
						</tr>
							<th id="eg_subcontentbg" class="form_border" width="300" nowrap valign="top">
								<egui:intnl text="admin.discovery.Select an Active Directory Site"/>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%">
								<select name='ADSite' onChange="javascript:populate('site')" width=250 style="width:300px">
									<option value="none" ><egui:intnl text="admin.user.Not Applicable"/></option>
								</select>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr>
						</tr>
							<th id="eg_subcontentbg" class="form_border" width="300" nowrap valign="top">
								<egui:intnl text="admin.discovery.Select Subnets(s) From Site"/>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%">
								<select name="ADSubnet" onChange="javascript:populate('subnet')" size="3" multiple width=250 style="width:300px">
									<!-- <option value="subnet" ><egui:intnl text="admin.user.Choose a subnet(s)"/></option> -->
									<option value="none" selected><egui:intnl text="admin.user.Not Applicable"/></option>
								</select>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr>
<%
	}
%>
						<tr>							
							<th id="eg_subcontentbg" class="form_border" width="250" nowrap valign="top" >
								<table border="0" width="100%" cellspacing="0" cellpadding="0">
									<tr><td nowrap  style="border-top-width:1px;border-bottom-width:0px"><egui:intnl text = "admin.discovery.IP range"/></td></tr>
									<tr><td class ="eg_7" style="border-top-width:1px;border-bottom-width:0px;"><egui:intnl text="admin.mail.[Provide multiple IP ranges, one row at a time]"/></td></tr>
								</table>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
							<td id="eg_subcontentbg" class="form_border" align="left" nowrap>
								<div style="float:left;"><textarea name="iprange" id="iprange" rows='5' cols='30' wrap='virtual' style="width: 300px;"><%=range%></textarea></div>
								<div style="float:left;width:50px">
								<img align="" onclick="javascript:fetchNewIP()" src="/final/images/icon_getip.png" title="Fetch IP range for this environment." class="mouse"/>
						<br/>
								
								<img align="" onclick="javascript:Clear('IP')" class="mouse" src="/final/images/icon_eraser.png" title="Clear the IP range."></div>
								
								<br/>
							</td>
							<td class="mouse form_border" id="eg_subcontentbg" valign="top">
								
							</td>
							<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
						</tr>
						<tr>
							<th id="eg_subcontentbg" class="form_border" width="250" nowrap>
								<egui:intnl text="admin.discovery.Type of network"/>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%"  align="left" nowrap>
								<select name="disctimeout" style="width:300px">
									<option value="250"<%=discovery_timeout<=250?"selected":""%>><egui:intnl text="admin.discovery.LAN"/></option>
									<option value="2000"<%=discovery_timeout > 250?"selected":""%>><egui:intnl text="admin.discovery.WAN"/></option>
								</select>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr>
						
						<tr>
							<th id="eg_subcontentbg" class="form_border" width="250" nowrap>
								<egui:intnl text="admin.discovery.ICMP enabled"/>
							</td>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg" class="form_border"  align="left">
								<table width="20%" cellpadding="0" cellspacing="0" border="0">
									<tr>
					
<%
	for(int i=0;i<icmpoptions.length;i++)
	{
		if(icmpoptions[i].equalsIgnoreCase(icmpfordiscovery))
		{
%>
										<td  width="2%"  style="padding-right:3px">
											<input type="radio" value="<%=icmpoptions[i]%>" name="icmp" checked class="eg_input"></td><td>
											<egui:intnl text='<%="admin.common."+icmpoptions[i]%>'/>
										</td>
<%
		}
		else
		{
%>
										<td  width="2%"  style="padding-right:3px">
											<input type="radio" value="<%=icmpoptions[i]%>" name="icmp" class="eg_input">
										</td>
										<td><egui:intnl text='<%="admin.common."+icmpoptions[i]%>'/> </td>
<%
		}
%>
										<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
<%
	}
%>
									</tr>
								</table>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr>
						<!-- <tr>
							<th id="eg_subcontentbg" class="form_border" width="250" nowrap>
								<egui:intnl text="admin.discovery.Index components using"/>
							</td>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%">
								<select name="discbase" style="width:300px">
									<option value="IP"<%=discBase.equalsIgnoreCase("IP")?"selected":""%>><egui:intnl text="admin.discovery.IP address"/></option>
									<option value="DNS"<%=discBase.equalsIgnoreCase("DNS")?"selected":""%>><egui:intnl text="admin.discovery.Host name"/> </option>
								</select>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr> -->
						<tr>
							<th id="eg_subcontentbg" class="form_border" width="250" nowrap>
								<egui:intnl text="admin.discovery.Re-discovery period"/>
							</td>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg"  width="100%" class="form_border">
								<select name="period" style="width:300px">
									<option value="30" <%=select30%>>30&nbsp;<egui:intnl text="admin.common.Mins"/></option>
									<option value="60" <%=select60%>>1&nbsp;<egui:intnl text="admin.common.Hour"/></option>
									<option value="180" <%=select180%>>3&nbsp;<egui:intnl text="admin.common.Hours"/></option>
									<option value="360" <%=select360%>>6&nbsp;<egui:intnl text="admin.common.Hours"/></option>
									<option value="1440" <%=select1440%>>1&nbsp;<egui:intnl text="admin.common.Day"/></option>
									<option value="10080" <%=select10080%>>1&nbsp;<egui:intnl text="admin.common.Week"/></option> 
									<option value="0" <%=select0%>><egui:intnl text="admin.common.None"/></option> 
								</select>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr>
						<tr>
							<th id="eg_subcontentbg" class="form_border" width="250" nowrap><egui:intnl text="admin.discovery.Is your environment DHCP enabled"/>? </th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg" class="form_border"  align="left">
							<table width="20%" cellpadding="0" cellspacing="0" border="0">
								<tr>
				
<%
if(thisIsDHCP != null && thisIsDHCP.equalsIgnoreCase("yes"))
{
%>
									<td  width="2%"  style="padding-right:0px">
										<input type="radio" value="yes" name="dhcp" checked class="eg_input"></td><td>
										&nbsp;<egui:intnl text='admin.common.Yes'/>
									</td>
									<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
									<td  width="2%"  style="padding-right:0px">
										<input type="radio" value="no" name="dhcp" class="eg_input"></td><td>
										&nbsp;<egui:intnl text='admin.common.No'/>
									</td>
<%
}
else
{
%>
									<td  width="2%"  style="padding-right:0px">
										<input type="radio" value="yes" name="dhcp" class="eg_input"></td><td>
										&nbsp;<egui:intnl text='admin.common.Yes'/>
									</td>
									<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
									<td  width="2%"  style="padding-right:0px">
										<input type="radio" value="no" name="dhcp" checked class="eg_input"></td><td>
										&nbsp;<egui:intnl text='admin.common.No'/>
									</td>
<%
}	
%>
								</tr>
							</table>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr>
						<tr>
							<th id="eg_subcontentbg" class="form_border" width="250" nowrap>
								<egui:intnl text="admin.discovery.SNMP community strings"/>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%"  align="left" nowrap>
								<div style="float:left"><input type="text" name="Community"  value="<%=strCommunityStrings%>"  maxlength="100" style="width: 300px;">
								</div>
								<div style="float:left"><img align="left" onclick="javascript:Clear('snmpString')" src="/final/images/icon_eraser.png" title="Clear the SNMP String."></div>
							</td>
							<td class="mouse form_spacing" id="eg_subcontentbg" valign="top">
								
							</td>
							<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
						</tr>

	<!-- Start credential settings	 -->
<%
	String className = "";
	if(showCredentialSettings)
		className="form_border";
	else
		className="form_spacing";
%>
						<tr>
							<th id="eg_subcontentbg" class="<%=className%>" width="300" nowrap valign="top">
								<egui:intnl text="admin.discovery.Credentials [Optional]"/>
							</th>
							<td id="eg_subcontentbg" class="<%=className%>" width="20" align="center" nowrap valign="top">:</td>
							<td id="eg_subcontentbg" class="<%=className%>" width="100%" valign="top">
								<table cellspacing="0" cellpadding="0" border="0" width="30%">
									<tr>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px"><input class="eg_input" type="radio" value="yes" name="credential" class="eg_input" onClick="javascript:showCredentialSettings('yes');" <%=showCredential.equals("yes")?"checked":""%>></td>
										<td id="eg_subcontentbg"  nowrap width="41" ><egui:intnl text="admin.common.Yes" /></td>
										<td id="eg_subcontentbg"  width="2%" style="padding-right:3px"><input class="eg_input" type="radio" value="no" name="credential" onClick="javascript:showCredentialSettings('no');" <%=showCredential.equals("no")?"checked":""%>></td></td>
										<td id="eg_subcontentbg" nowrap><egui:intnl text="admin.common.No"/></td>
									</tr>
								</table>
							</td>
							<td id="eg_subcontentbg" class="<%=className%>" colspan="2">&nbsp;</td>
						</tr>
<%
	if(showCredentialSettings)
	{
		String winCredentials=testIniFile.getValue("DISCOVERY_CREDENTIAL","Windows");	
		String winuserName = winCredentials.substring(0,winCredentials.indexOf(","));
		String userName="";
		String domainName="none";
		if(winuserName.indexOf("\\")>-1)
		{
			domainName = winuserName.substring(0,winuserName.indexOf("\\"));
			userName = winuserName.substring(winuserName.indexOf("\\")+1);
		}
		else userName=winuserName;
		String winpassword = winCredentials.substring(winCredentials.indexOf(",")+1);
		if(!winpassword.equals("none"))
			winpassword = EgCrypt.decrypt(winpassword);

		String sshCredentials=testIniFile.getValue("DISCOVERY_CREDENTIAL","SSH");
		String sshuserName = sshCredentials.substring(0,sshCredentials.indexOf(","));
		String sshpassword = sshCredentials.substring(sshCredentials.indexOf(",")+1);
		if(!sshpassword.equals("none"))
			sshpassword = EgCrypt.decrypt(sshpassword);


%>						<tr>
							<th id="eg_subcontentbg" class="form_border" width="300" nowrap valign="top">
								<egui:intnl text="admin.discovery.Windows"/>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap valign="top">:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%" valign="top">
								<table cellspacing="0" cellpadding="0" border="0" width="30%">
									<tr>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<egui:intnl text="admin.common.User Name"/>&nbsp;</td>					
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<input type="text" name="winuser" id="winuser" value="<%=userName%>" size="35"></td>
									</tr>
									<tr>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<egui:intnl text="admin.common.Password"/>&nbsp;</td>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<input type="password" name="winpass" id="winpass" value="<%=winpassword%>" size="35"></td>
									</tr>
									<!-- <tr>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<egui:intnl text="admin.common.Confirm Password"/>&nbsp;</td>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<input type="password" name="wincpass" id="wincpass" size="35"></td>
									</tr> -->
									<tr>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<egui:intnl text="admin.common.Domain"/>&nbsp;</td>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<input type="text" name="windomain" id="windomain" value="<%=domainName%>" size="35"></td>
									</tr>
								</table>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr>
						<tr>
							<th id="eg_subcontentbg" class="form_spacing" width="300" nowrap valign="top">
								<egui:intnl text="admin.discovery.SSH"/>
							</th>
							<td id="eg_subcontentbg" class="form_spacing" width="20" align="center" nowrap valign="top">:</td>
							<td id="eg_subcontentbg" class="form_spacing" width="100%" valign="top">
								<table cellspacing="0" cellpadding="0" border="0" width="30%">
									<tr>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<egui:intnl text="admin.common.User Name"/>&nbsp;</td>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<input type="text" name="sshuser" id="sshuser" value="<%=sshuserName%>" size="35"></td>
									</tr>
									<tr>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<egui:intnl text="admin.common.Password"/>&nbsp;</td>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<input type="password" name="sshpass" id="sshpass" value="<%=sshpassword%>" size="35"></td>
									</tr>
									<!-- <tr>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<egui:intnl text="admin.common.Confirm Password"/>&nbsp;</td>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px">
										<input type="password" name="sshcpass" id="sshcpass" size="35"></td>
									</tr> -->
								</table>
							</td>
							<td id="eg_subcontentbg" class="form_spacing" colspan="2">&nbsp;</td>
						</tr>
<%	
	}
%>


<!-- END credential settings --->

						<tr>
							<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
							<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
							<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
						</tr>
						<tr>
							<td colspan="5">&nbsp;</td>
						</tr>
						<tr>
							<td class="eg_subcontent" colspan="5" nowrap>
								<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
									<tr>
										<td id="subhead_left" width="7">
										<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
										</td>
										<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
										<egui:intnl text="admin.discovery.COMMON DISCOVERY SETTINGS OF YOUR ENVIRONMENT"/>*
										</td>
										<td id="subhead_right" width="7">
										<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
							<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						</tr>
						<tr>
							<th id="eg_subcontentbg" class="form_border" width="250" nowrap>
								<egui:intnl text="admin.discovery.Component types"/>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%"  align="left" nowrap ><div id="dis_comp" style="float:left">
<%
		if (server_list.size() == 0)
		{
			server_list.addAll(compList);
		}

		List tmpServerList = sorter.getSortedCompTypeList(server_list);
		if (server_list.size() ==1)
		{
			EgName tmpName = (EgName)tmpServerList.get(0);
			out.print(tmpName.getLocalName());
		}
		else
		{
			EgName tmpName = (EgName)tmpServerList.get(0);
			EgName tmpName2 = (EgName)tmpServerList.get(1);
			String strTemp =tmpName.getLocalName() + ", "+ tmpName2.getLocalName()+" <span id='moreComp'  title='Show more selected components' style='cursor:pointer;'><a href='javascript:void(0)' onclick='javascript:showMoreSelectedComps()'  class='more_link'>...</a></span>";
			out.print(strTemp);
		}
%>
							</div>
							<div style="float:left;margin-left:5px"><img align="left" onclick="javascript:showComponents()" src="/final/images/pencil_gray.png" title="Select components for discovery"></div>
							<style>
								.more_link{ padding:3px;background:#E2e2e2;color:#000;text-decoration:none!important}
								.more_link:hover{background:#e6e6e6}
							</style>
							</td>
							<td class="mouse form_border" id="eg_subcontentbg">
								
							</td>
							<td id="eg_subcontentbg" class="form_border">&nbsp;</td>
						</tr>
						<tr>
							<th id="eg_subcontentbg" class="form_border" width="250" nowrap>
								<egui:intnl text="admin.discovery.Index components using"/>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%">
								<select name="discbase" style="width:300px">
									<option value="IP"<%=discBase.equalsIgnoreCase("IP")?"selected":""%>><egui:intnl text="admin.discovery.IP address"/></option>
									<option value="DNS"<%=discBase.equalsIgnoreCase("DNS")?"selected":""%>><egui:intnl text="admin.discovery.Host name"/> </option>
								</select>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr>
<%
	String duplicates=testIniFile.getValue("DISCOVERY_SETTINGS","allowDuplicates");	
%>
						 <tr>
							<th id="eg_subcontentbg" class="form_border" width="250" nowrap>
								<egui:intnl text="admin.discovery.Discover multiple components in the same system"/>
							</th>
							<td id="eg_subcontentbg" class="form_border" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg" class="form_border" width="100%" valign="top">
								<table cellspacing="0" cellpadding="0" border="0" width="30%">
									<tr>
										<td id="eg_subcontentbg"  nowrap width="2%" style="padding-right:3px"><input class="eg_input" type="radio" value="true" name="allowDuplicates" class="eg_input" <%=duplicates.equalsIgnoreCase("true")?"checked":""%>></td>
										<td id="eg_subcontentbg"  nowrap width="41" ><egui:intnl text="admin.common.Yes" /></td>
										<td id="eg_subcontentbg"  width="2%" style="padding-right:3px"><input class="eg_input" type="radio" value="false" name="allowDuplicates" <%=duplicates.equalsIgnoreCase("false")?"checked":""%>></td></td>
										<td id="eg_subcontentbg" ><egui:intnl text="admin.common.No"/></td>
									</tr>
								</table>
							</td>
							<td id="eg_subcontentbg" class="form_border" colspan="2">&nbsp;</td>
						</tr> 

						<tr id="AgentSummaryHeading_1" style="display:none">
							<th id="eg_subcontentbg" class="form_spacing" width="250" nowrap>
								<egui:intnl text="admin.test.TCP ports for application discovery"/>
							</th>
							<td id="eg_subcontentbg" class="form_spacing" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg" class="form_spacing" width="100%">
								<span class="mouse" onclick="javascript:hidePortSummary();"><b>Click here</b></span> to hide port settings
							</td>
							<td class="mouse form_spacing" id="eg_subcontentbg">&nbsp;
							</td>
							<td id="eg_subcontentbg" class="form_spacing">&nbsp;</td>
						</tr>

						<tr id="AgentSummaryHeading_2">
							<th id="eg_subcontentbg" class="form_spacing" width="250" nowrap>
								<egui:intnl text="admin.test.TCP ports for application discovery"/>
							</th>
							<td id="eg_subcontentbg" class="form_spacing" width="20" align="center" nowrap>:</td>
							<td id="eg_subcontentbg" class="form_spacing" width="100%">
								<span class="mouse" onclick="javascript:showPortSummary();"><b>Click here</b></span> to view/modify ports
							</td>
							<td class="mouse form_spacing" id="eg_subcontentbg">
								&nbsp;
							</td>
							<td id="eg_subcontentbg" class="form_spacing">&nbsp;</td>
						</tr>
						<tr id="serverPorts" style="display:none">
							<td colspan="5" align="center" width="100%" >
								<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
									<tr>
										<td colspan="4">&nbsp;</td>
									</tr>
<%
	for(int k=0;k<serverList.size();k++)
	{
		//out.print(k);
		boolean space=(k+1)<serverList.size();
		EgName nameObj = (EgName)serverList.get(k);
		String tmpVal = nameObj.getActualName();	
		String tmpDis = nameObj.getLocalName();	
		int index = srvTypeList.indexOf(tmpVal);
		String portNo = (String)portList.get(index); 
%>
									<tr>
										<th  id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" nowrap><%=tmpDis%>
										</th>
										<td id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" width="20" align="center" nowrap>:</td>
										<td id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" width="100%" height="21" > <input type="text" name="Ports" maxlength="32" style="width: 350px; " value="<%=portNo%>" class="list" maxlength="100">
										</td>
										<td id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" >&nbsp;</td>
										<input type="hidden" name="serverName" value="<%=tmpVal%>">
									</tr>
									<input type="hidden" name="$_Ports" value="<%=tmpVal%>$<%=portNo%>">
<%
	}
%>
								</table>
							</td>
						</tr>
						<tr>
							<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
							<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
							<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
						</tr>
						<tr>
							<td colspan="5" style="padding-top:5px;">* Indicates that these settings are also applicable for agent discovery.</td>
						</tr>
						<tr>
							<td colspan="5" id="eg_blankspace" height="12" nowrap>&nbsp;</td>
						</tr>
						<tr>
							<td colspan="5" align="center"><input type="button" name="startdisc" value='<egui:intnl text="admin.discovery.Update"/>' style="width:150px;" class="eg_back" onClick="javascript:updateDiscSettings()"/></td>
						</tr>
					<table>
				</td>
			</tr>
<%
		if (isRedirected != null && isRedirected.equalsIgnoreCase("true"))
		{
%>
			<script type="text/javascript">
				showDiscoveryAction();
			</script>
<%
		}
	}
	else if(from.equals("changePorts"))
	{
%>
							<tr>
								<td class="eg_subcontent" colspan="4" nowrap>
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7">
											<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
											<egui:intnl text="admin.discovery.PORT SETTINGS"/>
											</td>
											<td id="subhead_right" width="7">
											<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
<%
	for(int k=0;k<serverList.size();k++)
	{
		//out.print(k);
		boolean space=(k+1)<serverList.size();
		EgName nameObj = (EgName)serverList.get(k);
		String tmpVal = nameObj.getActualName();	
		String tmpDis = nameObj.getLocalName();	
		int index = srvTypeList.indexOf(tmpVal);
		String portNo = (String)portList.get(index); 
		//String thisType = (String)srvTypeList.get(k);
		//out.print(space);
	/*	if(v_comp.indexOf(thisType) > -1)
		{
			continue;
		}
		else
		{
	*/		
	/*	if(thisType.endsWith("_server"))
			{
				dispType = thisType.substring(0,thisType.lastIndexOf("_"));
			}
			else
			{
				dispType = thisType;
			}
	*/
%>
							<tr>
								<th  id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" nowrap><%=tmpDis%>
<%
	//	}
%>
								</th>
								<td id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" width="20" align="center" nowrap>:</td>
								<td id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>" width="100%" height="21" > <input type="text" name="Ports" maxlength="32" style="width: 350px; " value="<%=portNo%>" class="list" maxlength="100">
								</td>
								<td id="eg_subcontentbg" class="<%=space?"form_border":"form_spacing"%>">&nbsp;</td>
								<input type="hidden" name="serverName" value="<%=tmpVal%>">
							</tr>
							<input type="hidden" name="$_Ports" value="<%=tmpVal%>$<%=portNo%>">
<%
	}

// Throws UnsupportedOperationException for some strange reason:	
//v_comp.clear();
%>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<tr>
								<td colspan="4" id="eg_blankspace" height="20" nowrap>&nbsp;</td>
							</tr>
<%							
							}
							else if(from.equals("changeSnmp"))
							{
%>
							<tr>
								<td class="eg_subcontent" colspan="4" nowrap>
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7">
											<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
											<egui:intnl text="admin.discovery.SNMP SETTINGS"/>
											</td>
											<td id="subhead_right" width="7">
											<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>
								<!-- <tr>
								<td background="eg_images/in_titleshadowbg.gif" nowrap colspan="4" height="2" id="eg_blankspace">&nbsp;</td>
							</tr> -->
							<tr>
								<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr>
								<th id="eg_subcontentbg" class="form_spacing" width="250" nowrap>
								<egui:intnl text="admin.discovery.SNMP community strings"/>
								</th>
								<td id="eg_subcontentbg" class="form_spacing" width="20" align="center" nowrap>:</td>
								<td id="eg_subcontentbg" class="form_spacing" width="100%"  align="left" nowrap>
								<input type="text" name="Community"  value="<%=strCommunityStrings%>"  maxlength="100" style="width: 250px;">
								</td>
								<td id="eg_subcontentbg" >&nbsp;</td>
							</tr>
							<input type="hidden" name="$_Community" value="<%=strCommunityStrings%>">
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<tr>
								<td colspan="4" id="eg_blankspace" class="eg_whitebg" height="20" nowrap>&nbsp;</td>
							</tr>
<%
	}
	else
	{
%>

							<tr>
								<td class="eg_subcontent" colspan="4" nowrap>
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7">
											<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
											<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
											<egui:intnl text="admin.discovery.Memory SETTINGS"/>
											</td>
											<td id="subhead_right" width="7">
											<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
											</td>
										</tr>
									</table>
								</td>
							</tr>
								<!-- <tr>
								<td background="eg_images/in_titleshadowbg.gif" nowrap colspan="4" height="2" id="eg_blankspace">&nbsp;</td>
							</tr> -->
							<tr>
								<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr>
								<th id="eg_subcontentbg" class="form_spacing" width="250" nowrap>
								<egui:intnl text="admin.discovery.Memory Range (MB)"/>
								</th>
								<td id="eg_subcontentbg" class="form_spacing" width="20" align="center" nowrap>:</td>
								<td id="eg_subcontentbg" class="form_spacing" width="100%"  align="left" nowrap>
								<input type="text" name="memory"  value="<%=memory%>"  maxlength="100" style="width: 350px;">
								</td>
								<td id="eg_subcontentbg" >&nbsp;</td>
							</tr>
								<input type="hidden" name="$_memory" value="<%=memory%>">

							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<tr>
								<td colspan="4" id="eg_blankspace" class="eg_whitebg" height="20" nowrap>&nbsp;</td>
							</tr>
							<tr>
								<td colspan="5" align="center"><input type="button" name="startdisc" value='<egui:intnl text="admin.discovery.Update"/>' style="width:150px;" class="eg_back" onClick="javascript:valform()"/></td>
							</tr>
<%
	}
%>
						</table>
					</td>
				</tr>
			</table>
			<div id="selectedComponetsInfo" style="display:none;width:620px;height:50px;left:86px;right:200px;top:62px;position:absolute;border:0px solid #ff0000;z-index:1000;">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td colspan="3">
							<table border="0" cellpadding="0" cellspacing="0" width="100%">
								<tr>
									<td width="5" height="22" class="panel_top_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="22" border="0"></td>
									<td class="panel_top_bg whitefont" height="22px" width="80%" id="setTitle"><egui:intnl text="admin.common.Selected components" /></td>
									<td align="left" class="panel_top_bg" style="padding-right:4px"></td>
									<td align="right" class="panel_top_bg" style="padding-top:2px">
									<img class="mouse" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" title="Close" onclick="javascript:hideComponets();"></td>
									<td width="9" height="22" class="panel_top_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="22" border="0"></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td class="panel_left_bg eg_blankspace" width="5px"><img src="/final/admin/eg_images/spacer.gif"></td>
						<td style="background:#EEEEEE">
							<div id="componets_list" class='div_scroll panelbg'  style='overflow-x: auto; overflow-y:auto;width:100%;height:300px;padding-top:5px;padding-bottom:5px'>
							</div>
						</td>
						<td class="panel_right_bg" width="9px"><img src="/final/admin/eg_images/spacer.gif" width="9"></td>
					</tr>
					<tr>
						<td class="panel_bottom_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="10"></td>
						<td class="panel_bottom_bg" height="10"><img src="/final/admin/eg_images/spacer.gif"></td>
						<td class="panel_bottom_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="10"></td>
					</tr>
				</table>
			</div>
			<div id="compDiv" style="display:none;width:500px;height:50px;left:180px;right:200px;top:71px;position:absolute;border:0px solid #ff0000;z-index:1000;">
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td colspan="3">
							<table border="0" cellpadding="0" cellspacing="0" width="100%">
								<tr>
									<td width="5" height="22" class="panel_top_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="22" border="0"></td>
									<td class="panel_top_bg whitefont" height="22px" width="55%" id="setTitle"><egui:intnl text="admin.common.Select components to be discovered" /></td>
									<td align="left" class="panel_top_bg" style="padding-right:55px"></td>
									<td align="right" class="panel_top_bg" style="padding-top:2px">
									<img class="mouse" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" title="Close" onclick="javascript:hideCompList();"></td>
									<td width="9" height="22" class="panel_top_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="22" border="0"></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td class="panel_left_bg eg_blankspace" width="5px"><img src="/final/admin/eg_images/spacer.gif"></td>
						<td align="center" valign="middle" style="padding:8px 4px 4px 4px;" class="panelbg" >
							<table border="0" cellpadding="0" cellspacing="0" width="100%">
								<tr>
									<td id="errMsg" style="" width="100%" align="center" valign="middle">
										<table border="0" cellpadding="0" cellspacing="0" width="100%">
											<tr>
												<th align="center">
												<egui:intnl text="admin.discovery.Category"/></th>
												<th align="center">
												<egui:intnl text="admin.discovery.Components"/></th>
											</tr>
										</table>
										<table border="0" cellpadding="0" cellspacing="0" width="100%">			
										<tr>
											<td>
												<select name="ComponentCategory" id="ComponentCategory" size="20" multiple style="width:250px" onchange="javascript:selectCategory();">
<%
		String sel="";
		if(DiscOptions.equalsIgnoreCase("all")) sel="selected";	
%>
						<option value="all" <%=sel%>><egui:intnl text="admin.discovery.ALL"/></option>
<%
		String[] servertypes=DiscBean.getValidServerTypesForDiscovery();
		ArrayList serverGrps = getAllServerGroups(servertypes);
		for(int i=0; i<serverGrps.size(); i++)
		{
			String tmpServerGrp = (String)serverGrps.get(i);			
			
%>				<option value="<%=tmpServerGrp%>"><%=getCapitalizedCategory(tmpServerGrp)%></option>
<%		}
%>

												</select>
											</td>
											<td class="eg_subcontentbg" colspan="6">&nbsp;&nbsp;</td>
											<td>
											<select name="c_types" id="c_types" multiple style="width:250px;" size="20">
<%
					int count = 0;
					compList = sorter.getSortedCompTypeList(compList);
					for (int i=0;i<compList.size();i++)
					{
						EgName tmpServer = (EgName)compList.get(i);
						String actualName = (String)tmpServer.getActualName();
						String displayName = (String)tmpServer.getLocalName();
						if (server_list_disp.contains(actualName))
						{
%>
							<option SELECTED value="<%=actualName%>"><%=displayName%></option>
<%
						}
						else
						{
%>
							<option value="<%=actualName%>"><%=displayName%></option>
<%
						}
					}
%>
											</select>
											</td></tr>
										</table>
										<table border="0" cellpadding="0" cellspacing="0" width="100%">
											<tr>
												<td height="30" align="center">&nbsp;
												<input type="button" value='<egui:intnl text="admin.common.Apply"/>' style="width: 90px;" class="eg_back" onClick="javascript:hideCompList();">
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
						<td class="panel_right_bg" width="9px"><img src="/final/admin/eg_images/spacer.gif" width="9"></td>
					</tr>
					<tr>
						<td class="panel_bottom_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="10"></td>
						<td class="panel_bottom_bg" height="10"><img src="/final/admin/eg_images/spacer.gif"></td>
						<td class="panel_bottom_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="10"></td>
					</tr>
				</table>
			</div>
			<input type="hidden" name="$_discBase" value="<%=discBase%>">
			<input type="hidden" name="$_periodIndex" value="<%=periodIndex%>">
			<input type="hidden" name="$_discTimeoutIndex" value="<%=discTimeoutIndex%>">
			<input type="hidden" name="$_icmpfordiscovery" value="<%=icmpfordiscovery%>">
			<input type="hidden" name="$_dhcpEnv" value="<%=thisIsDHCP%>">
		</form>
		</td>
	</tr>
<%
		//if(request.getQueryString()!=null)
		//session.setAttribute("adminLastAccessedURL","/final/admin/EgChangePorts.jsp?"+request.getQueryString()+"&showtree=discoverytree");
		//else 
			//session.setAttribute("adminLastAccessedURL","/final/admin/EgChangePorts.jsp?showtree=discoverytree");
	}

	if(from.equals("hmcAdd")||(from.equals("hmcModify") && allVCs.length > 0))
	{
%>
	<tr>
		<td>
		<FORM name="hmcDiscovery" method="post" style="margin:0px" >
			<input type="hidden" name="refferalURL" value="<%=refferalURL%>" />
			<div class="div_scroll" style="height:320px; border:0px solid #ff0000;">
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
								
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
								<egui:intnl text="admin.discovery.Hardware management console (HMC) Preferences"/>
<%
		}
		else
		{
%>
								<egui:intnl text="admin.discovery.Hardware management console (HMC) Discovery"/>

<%
		}

%>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td  align="center">
						<table  width="100%" cellspacing="0" cellpadding="0" border="0" >
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.IP address of Hardware management console"/></th>
								<td class="form_border eg_subcontentbg">:</td>
<%
		if(from.equals("hmcAdd"))
		{
%>
								<td class="form_border eg_subcontentbg"><input type="text" name="ipAdd" value="" style="width:150px"></td>
<%
		}
		else if(from.equals("hmcModify"))
		{
%>
								<td class="form_border eg_subcontentbg">
									<SELECT name=ipAdd style="width:150px;" onChange="javascript:hmc_onChange()">
									<option value="Choose HMC IP address"><egui:intnl text="admin.discovery.Choose HMC IP address"/></option>
<%
			if(allVCs!=null&&allVCs.length>0)
			{
				for(int i=0;i<allVCs.length;i++)
				{
%>
									<option value="<%=allVCs[i]%>"<%=allVCs[i].equals(ip)?"selected":""%>><%=allVCs[i]%> </option>
<%
				}
			}
%>
									</SELECT>
								</td>
<%
		}
%>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Host Name of Hardware management console"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="text" name="hName" value="<%=hName%>" style="width:150px">
								<input type="hidden" name="$_hName" value="<%=hName%>"></td>
							</tr>
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Use SSL to connect to HMC"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg">
									<SELECT name=ssl onChange="javaScript:setPort(this)">
									<option value="False" <%=isSsl.equalsIgnoreCase("False")?"selected":""%>><egui:intnl text="admin.discovery.No"/></option>
									<option value="True" <%=isSsl.equalsIgnoreCase("True")?"selected":""%>><egui:intnl text="admin.discovery.Yes"/></option>
									</SELECT>
									<input type = "hidden" name="$_ssl" value="<%=isSsl.equalsIgnoreCase("True")?"Yes":"No"%>">
								</td>
							</tr>
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Discover pSeries servers using this HMC"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg">
									<SELECT name=isDiscovery>
									<option value="Yes" <%=isDiscovery.equalsIgnoreCase("Yes")?"selected":""%>><egui:intnl text="admin.discovery.Yes"/></option>
									<option value="No" <%=isDiscovery.equalsIgnoreCase("No")?"selected":""%>><egui:intnl text="admin.discovery.No"/></option>
									</SELECT>
									<input type = "hidden" name="$_isDiscovery" value = "<%=isDiscovery.equalsIgnoreCase("Yes")?"Yes":"No"%>">
								</td>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Username to connect to HMC"/> ( i.e hscroot )</th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="text" name="uname" value="<%=uName%>" style="width:150px">
								<input type="hidden" name="$_uname" value="<%=uName%>"></td>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Password for the user"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="password" name="pass" value="<%=uPass%>" style="width:150px"></td>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<tr>
								<th class="form_spacing eg_subcontentbg"><egui:intnl text="admin.discovery.Confirm password for the user"/></th>
								<td class="form_spacing eg_subcontentbg">:</td>
								<td class="form_spacing eg_subcontentbg"><input type="password" name="confpasswd" value="<%=uPass%>" style="width:150px">
								<input type="hidden" name="$_confpasswd" value="<%=uPass%>">
								</td>
							</tr>
							<tr>
								<td colspan="3">
									<table width="100%" cellpadding="0" cellspacing="0" border="0">
										<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
										<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
										<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" class="eg_whitebg" height="10" nowrap>&nbsp;</td>
				</tr>
				<tr>
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" name = 'StartDiscovery' id="discoverAct" value='<egui:intnl text="admin.common.Update"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateFormHMC('update');">&nbsp;&nbsp;
<%
		}
		else
		{
%>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" name = 'StartDiscovery' value='<egui:intnl text="admin.common.Update"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateFormHMC('update');">&nbsp;&nbsp;
<%		
		}
		if(from.equalsIgnoreCase("hmcAdd"))
		{
%>
					<input type="button" value='<egui:intnl text="admin.common.Clear"/>' style="width: 90px;" class="eg_back" onClick="javascript:clearForm();" >&nbsp;&nbsp;
<%		
		}
%>
					
					</td>
				</tr>
			</table>
			</div>
			</FORM>
		</td>
	</tr>
<%
}

else if(from.equals("add")||(from.equals("modify")&&(allVCs.length>0)))
{
	String componentType = "VmEsx_i_server";
	String testName = request.getParameter("testName");
	testName = (testName == null)?"":testName;
	String validationTitle=_mapping.getTextDescription("admin.common.Validating monitoring settings for")+" ";

	String validationURL="/final/admin/validateApplicationServerCredentails.jsp";

	String paramsForValidationURL="action=pickAgentToValidate&taskName=VmEsx_i_server&componentType="+componentType;


	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	IniFile egTestParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
	String requiredParamNames="";
	String paramForDisplayingValidateButton="";
	requiredParamNames=egTestParamIni.getValue("VALIDATIONS_FIELDS","VmEsx_i_server:Default");
	String specificValidationFieldsForTest=egTestParamIni.getValue("VALIDATIONS_FIELDS",testName);
	if(specificValidationFieldsForTest!=null && (!specificValidationFieldsForTest.equals("") && !specificValidationFieldsForTest.equalsIgnoreCase("null")))
	{
		requiredParamNames=requiredParamNames+","+specificValidationFieldsForTest;
	}
	StringBuffer sbreqValsForValidation=new StringBuffer(256);
	if(requiredParamNames!=null && !requiredParamNames.equals(""))
	{
		StringTokenizer stkvFields=new StringTokenizer(requiredParamNames,",");
		while(stkvFields.hasMoreTokens())
		{
			String fieldName=stkvFields.nextToken();
			fieldName=fieldName.toLowerCase();
			sbreqValsForValidation.append(fieldName+",");
		}
	}
	requiredParamNames=sbreqValsForValidation.toString()+"componentcredentialsneededtodovalidation";
	if(requiredParamNames!=null && requiredParamNames.endsWith(","))
		requiredParamNames=requiredParamNames.substring(0,(requiredParamNames.length()-1));

	paramForDisplayingValidateButton=egTestParamIni.getValue("VALIDATION_BUTTON_LOCATION",testName);
	if(paramForDisplayingValidateButton!=null && (paramForDisplayingValidateButton.equals("") || paramForDisplayingValidateButton.equalsIgnoreCase("null")))
	{
		paramForDisplayingValidateButton=egTestParamIni.getValue("VALIDATION_BUTTON_LOCATION",componentType+":Default");
	}
	requiredParamNames=requiredParamNames+",passwordconfirmpassword";


	String allowedParams = egTestParamIni.getValue("SPECIAL_CHARACTERS","Parameters");
	String[] tcKeywords = new String[0];
	ArrayList aListTcKeywordsLowerCase = new ArrayList();
	tcKeywords=egTestParamIni.getVariables("TEST_CONFIGURATION_PARAM_VALUE_KEYWORDS");
	String strTcKeywords = "";
	List listTcKeywords = Arrays.asList(tcKeywords);
	strTcKeywords = listTcKeywords.toString();
	strTcKeywords = strTcKeywords.substring(1,strTcKeywords.length()-1);
	strTcKeywords = StringUtils.replace(strTcKeywords,", ",",");
	String componentCredentialsNeededToDoValidation="";
%>
	<tr>
		<td>
		<input type="hidden" id="allowedParams" name="allowedParams" value="<%=allowedParams%>">
		<input type="hidden" name="strTcKeywords" value="<%=strTcKeywords%>">
		<input type="hidden" id="componentcredentialsneededtodovalidation" name="componentcredentialsneededtodovalidation" value="<%=componentCredentialsNeededToDoValidation%>">
		<FORM name="esxDiscovery" method="post" style="margin:0px" >
			<input type="hidden" name="refferalURL" value="<%=refferalURL%>" />

		<!-- changes for esx validation in discovery-->
			<div id="customizedPopupDiv" name="customizedPopupDiv" style="z-index:1000;display:none;left:50px;top:10px;width:580px;height:200px;border:0px solid #ff0000; position:absolute;">
				<table border="0" cellspacing="0" cellpadding="0" width="100%">
					<tr>
						<td class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
						<td class="pop2_top_bg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
						<td class="pop2_righttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
					</tr>
					<tr>
						<td class="pop2_left_bg" class="eg_whitebg" onmousedown="javascript:startValidationDivDrag(event,'customizedPopupDiv');" onmouseover='document.body.style.cursor="move"' onmouseout='document.body.style.cursor="default"'><img src="/final/admin/eg_images/spacer.gif" width="11" height="2"></td>
						<td class="eg_whitebg" onmousedown="javascript:startValidationDivDrag(event,'customizedPopupDiv');" onmouseover='document.body.style.cursor="move"' onmouseout='document.body.style.cursor="default"'>
							<table cellspacing="1" cellpadding="0" border="0" width="100%">
								<tr>
									<td>
										<table cellpadding="0" cellspacing="0" border="0" width="100%">
											<tr>
												<td width="100%" align="center" class="eg_subcontentbg" id="form_spacing" style="border-right-width:0px"><div id="AppValidationTitle"></div></td>
												<td style="width:20px" class="eg_subcontentbg" id="form_spacing" style="border-left-width:0px">
													<img src="/final/admin/eg_images/winclose.gif" onclick="hideDivs('customizedPopupDiv');" border="1" class="mouse" title="close">
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
						<td class="pop2_right_bg" class="eg_whitebg" onmousedown="javascript:startValidationDivDrag(event,'customizedPopupDiv');" onmouseover='document.body.style.cursor="move"' onmouseout='document.body.style.cursor="default"'><img src="/final/admin/eg_images/spacer.gif" width="11" height="2"></td>
					</tr>
					<tr>
						<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11"></td>
						<td class="eg_whitebg">
							<div id='customizedLinkInnerDiv' name='customizedLinkInnerDiv' class="div_scroll" style="z-index:1000;height:190px;border:0px solid #ff00ff;"></div>
						</td>
						<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11"></td>
					</tr>
					<tr>
						<td class="pop2_leftbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
						<td class="pop2_bottom_bg"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
						<td class="pop2_rightbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
					</tr>
				</table>
			</div>
			<!-- changes for esx validation in discovery ends -->


			<div class="div_scroll" style="height:320px; border:0px solid #ff0000;">
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
								<egui:intnl text="admin.discovery.Virtual Center Preferences"/>
<%
		}
		else
		{
%>
								<egui:intnl text="admin.discovery.Virtual Center Discovery"/>
<%
		}

%>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td  align="center">
						<table  width="100%" cellspacing="0" cellpadding="0" border="0" >
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.vCenter identity (IP or Host name)"/></th>
								<td class="form_border eg_subcontentbg">:</td>
<%
		if(from.equals("add"))
		{
%>
								<td class="form_border eg_subcontentbg"><input type="text" id="ipAdd" name="ipAdd" value="" style="width:150px"></td>
<%
		}
		else if(from.equals("modify"))
		{
%>
								<td class="form_border eg_subcontentbg">
									<SELECT id=ipAdd name=ipAdd style="width:150px;" onChange="javascript:vc_onChange()">
									<option value="Choose vCenter"><egui:intnl text="admin.discovery.Choose vCenter"/></option>
<%
			if(allVCs!=null&&allVCs.length>0)
			{
				for(int i=0;i<allVCs.length;i++)
				{
%>
									<option value="<%=allVCs[i]%>"<%=allVCs[i].equals(ip)?"selected":""%>><%=allVCs[i]%> </option>
<%
				}
			}
%>
									</SELECT>
								</td>
<%
		}
%>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Use SSL to connect to vCenter"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg">
									<SELECT id=ssl name=ssl onChange="javaScript:setPort(this)">
									<option value="True" <%=isSsl.equalsIgnoreCase("True")?"selected":""%>><egui:intnl text="admin.discovery.Yes"/></option>
									<option value="False" <%=isSsl.equalsIgnoreCase("False")?"selected":""%>><egui:intnl text="admin.discovery.No"/></option>
									</SELECT>
									<input type = "hidden" name="$_ssl" value="<%=isSsl.equalsIgnoreCase("True")?"Yes":"No"%>">
								</td>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<!-- Webport -->
<%
		if (webPort != null)//For Initial loading
		{
			if (isSsl != null && isSsl.equals(""))
			{
				webPort = "443";
			}
		}
%>
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Web Port"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="text" id="webport" name="webport" value="<%=webPort%>" style="width:150px"></td>
								<input type="hidden" name="$_webport" value="<%=webPort%>"></td>
							</tr>
							<!-- Webport -->
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Discover ESX hosts using this vCenter"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg">
									<SELECT id=isDiscovery name=isDiscovery>
									<option value="Yes" <%=isDiscovery.equalsIgnoreCase("Yes")?"selected":""%>><egui:intnl text="admin.discovery.Yes"/></option>
									<option value="No" <%=isDiscovery.equalsIgnoreCase("No")?"selected":""%>><egui:intnl text="admin.discovery.No"/></option>
									</SELECT>
									<input type = "hidden" name="$_isDiscovery" value = "<%=isDiscovery.equalsIgnoreCase("Yes")?"Yes":"No"%>">
								</td>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Username to connect to vCenter"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="text" id="uname" name="uname" value="<%=uName%>" style="width:150px">
								<input type="hidden" name="$_uname" value="<%=uName%>"></td>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Password for the user"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="password" id="pass" name="pass" value="<%=uPass%>" style="width:150px"></td>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<tr>
								<th class="form_spacing eg_subcontentbg"><egui:intnl text="admin.discovery.Confirm password for the user"/></th>
								<td class="form_spacing eg_subcontentbg">:</td>
								<td class="form_spacing eg_subcontentbg"><input type="password" id="confpasswd" name="confpasswd" value="<%=uPass%>" style="width:150px">
									<input class="eg_back" type="button" id="validateButton" name="validateButton" value='<egui:intnl text="admin.common.Validate"/>' onclick="javascript:setAppServerValidationTitle('<%=validationTitle%>','vCenter');javascript:validateAppServerCredentails('specificConfiguration','<%=validationURL%>','<%=paramsForValidationURL%>','pickAgentToValidate','vCenter','','false','<%=isAllowHostName%>','<%=requiredParamNames%>','descovery',event);"> 
								<input type="hidden" name="$_confpasswd" value="<%=uPass%>">
								</td>
							</tr>
							<tr>
								<td colspan="3">
									<table width="100%" cellpadding="0" cellspacing="0" border="0">
										<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
										<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
										<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" class="eg_whitebg" height="10" nowrap>&nbsp;</td>
				</tr>
				<tr>
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" name = 'StartDiscovery' id="discoverAct" value='<egui:intnl text="admin.common.Update"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateFormVC('update');">&nbsp;&nbsp;
<%
		}
		else
		{
%>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" name = 'StartDiscovery' value='<egui:intnl text="admin.common.Update"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateFormVC('update');">&nbsp;&nbsp;
<%
		}
		if(from.equalsIgnoreCase("add"))
		{
%>
					<input type="button" value='<egui:intnl text="admin.common.Clear"/>' style="width: 90px;" class="eg_back" onClick="javascript:clearForm();" >&nbsp;&nbsp;
<%		
		}
%>
					
					</td>
				</tr>
			</table>
			</div>
			</FORM>
		</td>
	</tr>
<%
	}
%>
<%
	if((from.equalsIgnoreCase("view") || from.equalsIgnoreCase("delete"))  && allVCs.length>0)
	{
%>
	<tr>
		<td>
			<FORM name="esxDiscoveryDel" method="post" style="margin:0px" >
				<input type="hidden" name="refferalURL" value="<%=refferalURL%>" />
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><egui:intnl text="admin.discovery.vCenters"/>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td class="eg_subcontentbg">
						<table  width="100%" cellspacing="0" cellpadding="4" border="0" height="22" >
<%
				if (from.equalsIgnoreCase("delete"))
				{

%>
						<col width=30><col width=250><col width=120><col width=120><col width=100>
							<tr>
<%
				}else
				{
%>
						<col width=250><col width=120><col width=120><col width=100>
							<tr>
<%
				}
				if (from.equalsIgnoreCase("delete"))
				{

%>

								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><input type="checkbox" id="eg_input" name="vcAll" onClick="javascript:checkAll()"> </td>
<%
				}
%>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.vCenter IP/Host"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.SSL"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.Web Port"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.Discovery"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;"><b><egui:intnl text="admin.discovery.User"/></b></td>
							</tr>
<%
			for(int v=0;v<allVCs.length;v++)
			{
					String vCenterIP=allVCs[v];
					ArrayList content = (ArrayList)allData.get(vCenterIP);
					isSsl= (String)content.get(0);
					if(isSsl.equalsIgnoreCase("True"))
						isSsl="Yes";
					else
						isSsl="No";
					isDiscovery=(String)content.get(1);
					uName=(String)content.get(2);
					if(from.startsWith("hmc"))
						hName = (String)content.get(4);
					else
						webPort = (String)content.get(4);


%>	
							<tr>
<%
				if (from.equalsIgnoreCase("delete"))
				{
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><input type="checkbox" id="eg_input" name="vc" onClick="javascript:checkItem(this)"> </td>
<%
				}
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><%=vCenterIP%> </td>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><%=isSsl%></td>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><%=webPort%></td>
<%								
								
					if(isDiscovery.equalsIgnoreCase("yes"))
					{
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;" ><img src="/final/admin/eg_images/right.gif">
								</td>
								
<%					}
					else
					{
%>								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;" ><img									src="/final/admin/eg_images/wrong.gif">
								</td>
<%								
					}
%>
								<td id="cell_border4" style="border-left-width:1px;"><%=uName%></td>
									<input type="hidden" id="eg_input" name="$vc" value='<%=vCenterIP%>'>
							</tr>
<%
			}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td  id="eg_blankspace" class="eg_whitebg" height="10" nowrap>&nbsp;</td>
				</tr>
<%
			if (from.equalsIgnoreCase("delete"))
			{
%>
				<tr>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" value='<egui:intnl text="admin.common.Delete"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateFormDelete('delete');">&nbsp;&nbsp
					</td>
				</tr>
<%
			}
%>
			</table>
			</FORM>
		</td>
	</tr>
<%
	}
	if((from.equalsIgnoreCase("hmcView") || from.equalsIgnoreCase("hmcDelete"))  && allVCs.length>0)
	{
%>
	<tr>
		<td>
			<FORM name="hmcDiscoveryDel" method="post" style="margin:0px" >
				<input type="hidden" name="refferalURL" value="<%=refferalURL%>" />
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><egui:intnl text="admin.discovery.Hardware management console (HMC)"/>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td class="eg_subcontentbg">
						<table  width="100%" cellspacing="0" cellpadding="4" border="0" height="22" >
<%
				if (from.equalsIgnoreCase("hmcDelete"))
				{

%>
						<col width=30><col width=250><col width=120><col width=120><col width=100>
							<tr>
<%
				}else
				{
%>
						<col width=250><col width=120><col width=120><col width=100>
							<tr>
<%
				}
				if (from.equalsIgnoreCase("hmcDelete"))
				{

%>

								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><input type="checkbox" id="eg_input" name="vcAll" onClick="javascript:checkAll()"> </td>
<%
				}
%>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.HMC IP"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.HMC Host Name"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.SSL"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.Discovery"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;"><b><egui:intnl text="admin.discovery.User"/></b></td>
							</tr>
<%
			for(int v=0;v<allVCs.length;v++)
			{
					String vCenterIP=allVCs[v];
					ArrayList content = (ArrayList)allData.get(vCenterIP);
					isSsl= (String)content.get(0);
					if(isSsl.equalsIgnoreCase("True"))
						isSsl="Yes";
					else
						isSsl="No";
					isDiscovery=(String)content.get(1);
					uName=(String)content.get(2);
					if(from.startsWith("hmc"))
						hName = (String)content.get(4);
					else
						webPort = (String)content.get(4);
%>
							<tr>
<%
				if (from.equalsIgnoreCase("hmcDelete"))
				{
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><input type="checkbox" id="eg_input" name="vc" onClick="javascript:checkItem(this)"> </td>
<%
				}
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><%=vCenterIP%> </td>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><%=hName%> </td>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><%=isSsl%></td>
							
<%								
								
					if(isDiscovery.equalsIgnoreCase("yes"))
					{
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;" ><img src="/final/admin/eg_images/right.gif">
								</td>
								
<%					}
					else
					{
%>								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;" ><img									src="/final/admin/eg_images/wrong.gif">
								</td>
<%								
					}
%>
								<td id="cell_border4" style="border-left-width:1px;"><%=uName%></td>
								<input type="hidden" id="eg_input" name="$vc" value='<%=vCenterIP%>'>
							</tr>
<%
			}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td  id="eg_blankspace" class="eg_whitebg" height="10" nowrap>&nbsp;</td>
				</tr>
<%
			if ( from.equalsIgnoreCase("hmcDelete"))
			{
%>
				<tr>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" value='<egui:intnl text="admin.common.Delete"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateFormDelete('hmcDelete');">&nbsp;&nbsp
					</td>
				</tr>
<%
			}
%>
			</table>
			</FORM>
		</td>
	</tr>
<%
	}
	if(allVCs.length==0&&(from.equalsIgnoreCase("delete")||from.equalsIgnoreCase("view")||from.equalsIgnoreCase("modify")))
	{
%>

	<tr>
		<td>
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td  align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><egui:intnl text="admin.discovery.vCenters"/>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" align="center">&nbsp;</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" align="center" valign="middle"><img src="/final/admin/eg_images/exclamation-icon.gif" border="0"><br><egui:intnl text="admin.discovery.No vCenter servers are available currently"/>.
					</td>
				</tr>
				<tr>
					<td>
						<table width="100%" cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
				<tr>
					<td align="center"><BR>
						<a href="EgDiscServers.jsp?autoRefresh=false&startDiscThread=no&showComponent=no&opt=vCenters&action=add" class="eg_monlink" id="mouse"><b><egui:intnl text="admin.discovery.Click here"/></b></a>
							to add a new vCenter server.
					</td>
				</tr>
<%
		}
%>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	
	if(allVCs.length==0&&(from.equalsIgnoreCase("hmcDelete")||from.equalsIgnoreCase("hmcView")||from.equalsIgnoreCase("hmcModify")))
	{
%>

	<tr>
		<td>
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td  align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><egui:intnl text="admin.discovery.Hardware management console (HMC)"/>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" align="center">&nbsp;</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" align="center" valign="middle"><img src="/final/admin/eg_images/exclamation-icon.gif" border="0"><br><egui:intnl text="admin.discovery.No HMC servers are available currently"/></td>
				</tr>
				<tr>
					<td>
						<table width="100%" cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
				<tr>
					<td align="center"><BR>
						<a href="EgDiscServers.jsp?autoRefresh=false&startDiscThread=no&showComponent=no&opt=HMCs&action=add" class="eg_monlink" id="mouse"><b><egui:intnl text="admin.discovery.Click here"/></b></a>
							to add a new HMC server.
					</td>
				</tr>
<%
		}
%>
			</table>
		</td>
	</tr>
<%
	}
	if(allVCs.length==0&&(from.equalsIgnoreCase("cloudDelete")||from.equalsIgnoreCase("cloudView")||from.equalsIgnoreCase("cloudModify")))
	{
%>

	<tr>
		<td>
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td  align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><egui:intnl text="admin.discovery.AWS EC2 Cloud"/>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" align="center">&nbsp;</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" align="center" valign="middle"><img src="/final/admin/eg_images/exclamation-icon.gif" border="0"><br><egui:intnl text="admin.discovery.No AWS EC2 Cloud account are available currently"/></td>
				</tr>
				<tr>
					<td>
						<table width="100%" cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
				<tr>
					<td align="center"><BR>
						<a href="EgDiscServers.jsp?autoRefresh=false&startDiscThread=no&showComponent=no&opt=Cloud&action=add" class="eg_monlink" id="mouse"><b><egui:intnl text="admin.discovery.Click here"/></b></a>
							to add a new cloud account.
					</td>
				</tr>
<%
		}
%>
			</table>
		</td>
	</tr>
<%
	}

if(from.equals("cloudAdd")|| (from.equals("cloudModify")&&(allVCs.length>0)))
{
%>
	<tr>
		<td>
		<FORM name="cloudDiscovery" method="post" style="margin:0px" >
			<input type="hidden" name="refferalURL" value="<%=refferalURL%>" />
			<div class="div_scroll" style="height:320px; border:0px solid #ff0000;">
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><egui:intnl text="admin.discovery.AWS EC2 cloud Preferences"/>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td  align="center">
						<table  width="100%" cellspacing="0" cellpadding="0" border="0" >
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.AWS EC2 cloud account name"/></th>
								<td class="form_border eg_subcontentbg">:</td>
<%
		if(from.equals("cloudAdd"))
		{
%>
								<td class="form_border eg_subcontentbg"><input type="text" name="account" value="" style="width:150px"></td>
<%
		}
		else if(from.equals("cloudModify"))
		{
%>
								<td class="form_border eg_subcontentbg">
									<SELECT name=account style="width:150px;" onChange="javascript:cloudOnChange()">
									<option value="Choose account"><egui:intnl text="admin.discovery.Choose account"/></option>
<%
			if(allVCs!=null&&allVCs.length>0)
			{
				for(int i=0;i<allVCs.length;i++)
				{
%>
									<option value="<%=allVCs[i]%>"<%=allVCs[i].equals(account)?"selected":""%>><%=allVCs[i]%> </option>
<%
				}
			}
%>
									</SELECT>
								</td>
<%
		}
%>
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Discover AWS EC2 cloud regions"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg">
									<SELECT name=isDiscovery>
									<option value="Yes" <%=isDiscovery.equalsIgnoreCase("Yes")?"selected":""%>><egui:intnl text="admin.discovery.Yes"/></option>
									<option value="No" <%=isDiscovery.equalsIgnoreCase("No")?"selected":""%>><egui:intnl text="admin.discovery.No"/></option>
									</SELECT>
									<input type = "hidden" name="$_isDiscovery" value = "<%=isDiscovery.equalsIgnoreCase("Yes")?"Yes":"No"%>">
								</td>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Access key to connect to AWS EC2"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="password" name="accessKey" value="<%=uName%>" style="width:150px">
								<input type="hidden" name="$_accessKey" value="<%=uName%>"></td>
							</tr>

							<tr>
								<th class="form_spacing eg_subcontentbg"><egui:intnl text="admin.discovery.Confirm access key to connect to AWS EC2"/></th>
								<td class="form_spacing eg_subcontentbg">:</td>
								<td class="form_spacing eg_subcontentbg"><input type="password" name="confAccessKey" value="<%=uName%>" style="width:150px">
								</td>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							<tr>
								<th class="form_border eg_subcontentbg"><egui:intnl text="admin.discovery.Secret key to connect to AWS EC2"/></th>
								<td class="form_border eg_subcontentbg">:</td>
								<td class="form_border eg_subcontentbg"><input type="password" name="secretKey" value="<%=uPass%>" style="width:150px">
								<input type="hidden" name="$_secretKey" value="<%=uPass%>">
								</td>
							</tr>
							<!-- <tr>
								<td colspan="3" id="eg_blankspace" class="eg_whitebg" height="1px" ></td>
							</tr> -->
							
							<tr>
								<th class="form_spacing eg_subcontentbg"><egui:intnl text="admin.discovery.Confirm secret key to connect to AWS EC2"/></th>
								<td class="form_spacing eg_subcontentbg">:</td>
								<td class="form_spacing eg_subcontentbg"><input type="password" name="confSecretKey" value="<%=uPass%>" style="width:150px">
								</td>
							</tr>
							<tr>
								<td colspan="3">
									<table width="100%" cellpadding="0" cellspacing="0" border="0">
										<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
										<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
										<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" class="eg_whitebg" height="10" nowrap>&nbsp;</td>
				</tr>
				<tr>
<%
		if (refferalURL != null && refferalURL.equalsIgnoreCase("EgFrame"))
		{
%>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" name = 'StartDiscovery' id="discoverAct" value='<egui:intnl text="admin.common.Update"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateFormCloud('update');">&nbsp;&nbsp;
<%
		}
		else
		{
%>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" name = 'StartDiscovery' value='<egui:intnl text="admin.common.Update"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateFormCloud('update');">&nbsp;&nbsp;
<%	
		}
		if(from.equalsIgnoreCase("cloudAdd"))
		{
%>
					<input type="button" value='<egui:intnl text="admin.common.Clear"/>' style="width: 90px;" class="eg_back" onClick="javascript:clearFormCloud();" >&nbsp;&nbsp;
<%		
		}
%>
					
					</td>
				</tr>
			</table>
			</div>
			</FORM>
		</td>
	</tr>
<%
	}
	if((from.equalsIgnoreCase("cloudView") || from.equalsIgnoreCase("cloudDelete"))  && allVCs.length>0)
	{
%>
	<tr>
		<td>
			<FORM name="cloudDiscoveryDel" method="post" style="margin:0px" >
				<input type="hidden" name="refferalURL" value="<%=refferalURL%>" />
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td align="center">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
							<tr>
								<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><egui:intnl text="admin.discovery.AWS EC2 Cloud Accounts"/>
								</td>
								<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td class="eg_subcontentbg">
						<table  width="100%" cellspacing="0" cellpadding="4" border="0" height="22" >
<%
				if (from.equalsIgnoreCase("cloudDelete"))
				{

%>
						<col width=30><col width=250><col width=120>
							<tr>
<%
				}else
				{
%>
						<col width=250><col width=120>
							<tr>
<%
				}
				if (from.equalsIgnoreCase("cloudDelete"))
				{

%>

								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><input type="checkbox" id="eg_input" name="vcAll" onClick="javascript:checkAll()"> </td>
<%
				}
%>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.AWS EC2 Cloud account"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:1px;"><b><egui:intnl text="admin.discovery.Discovery"/></b></td>
							</tr>
<%
			for(int v=0;v<allVCs.length;v++)
			{
					String vCenterIP=allVCs[v];
					ArrayList content = (ArrayList)allData.get(vCenterIP);
					isDiscovery=(String)content.get(2);
					uName=(String)content.get(0);
%>
							<tr>
<%
				if (from.equalsIgnoreCase("cloudDelete"))
				{
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><input type="checkbox" id="eg_input" name="account" onClick="javascript:checkItem(this)"> </td>
<%
				}
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><%=vCenterIP%> </td>
							
<%								
								
					if(isDiscovery.equalsIgnoreCase("yes"))
					{
%>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:1px;" ><img src="/final/admin/eg_images/right.gif">
								</td>
								
<%					}
					else
					{
%>								<td id="cell_border4" style="border-left-width:1px;border-right-width:1px;" ><img									src="/final/admin/eg_images/wrong.gif">
								</td>
<%								
					}
%>
								<input type="hidden" id="eg_input" name="$account" value='<%=vCenterIP%>'>
							</tr>
<%
			}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td  id="eg_blankspace" class="eg_whitebg" height="10" nowrap>&nbsp;</td>
				</tr>
<%
			if ( from.equalsIgnoreCase("cloudDelete"))
			{
%>
				<tr>
					<td height="30" valign="middle" id="eg_whitebg" align="center">&nbsp;
					<input type="button" value='<egui:intnl text="admin.common.Delete"/>' style="width: 90px;" class="eg_back" onClick="javascript:validateCloudDelete('cloudDelete');">&nbsp;&nbsp
					</td>
				</tr>
<%
			}
%>
			</table>
			</FORM>
		</td>
	</tr>
<%
	}

	if (from.equalsIgnoreCase("EnableDisableDiscovery"))
	{
		String strMsg = "disable";
		String message = "Manager discovery is currently enabled for your environment.";
		if (!managerDiscovery.equalsIgnoreCase("enable"))
		{
			strMsg = "enable";
			message = "Manager discovery is currently disabled for your environment.";
		}
%>
	<tr>
		<td>
			<table cellspacing="0" cellpadding="0" border="0" width="82%" align="center">
				<tr>
					<td class="eg_subcontentbg">
						<table  width="100%" cellspacing="0" cellpadding="4" border="0" height="22" >
								<col width=250><col width=100><col width=120>
							<tr>
								<td id="cell_border3" style="border-left-width:1px;border-right-width:0px;border-top-width:1px;" align="center"><b><egui:intnl text="admin.discovery.Discovery Option"/></b></td>
								<td id="cell_border3" style="border-left-width:1px;border-top-width:1px;" align="center"><b><egui:intnl text="admin.discovery.Current Status"/></b></td>
								<td id="cell_border3" style="border-right-width:1px;border-top-width:1px;" align="center"><b><egui:intnl text="admin.discovery.Action"/></b></td>
							</tr>
							<tr>
								<td id="cell_border4" style="border-left-width:1px;border-right-width:0px;"><b><egui:intnl text="admin.discovery.Manager discovery"/></b></td>
								<td id="cell_border4" style="border-left-width:1px;" align="center">
<%
					if(managerDiscovery.equalsIgnoreCase("yes") || managerDiscovery.equalsIgnoreCase("enable"))
					{
%>
									<b>Enabled</b>
								
<%					}
					else
					{
%>
									<b>Disabled</b>
<%								
					}
%>
								</td>
								<td id="cell_border4" style="border-right-width:1px;" align="center"><input type="button" name='discoveryOpt' id="discoveryOpt" value='<%=managerDiscovery.equalsIgnoreCase("enable")?"Disable":"Enable"%>' style="width: 90px;" class="eg_back" onClick="javascript:enableDisableDiscovery('tree');"></td>
							</tr>
						</table>
					</td>
				<tr>
			</table>
		</td>
	</tr>
<%
	}
%>
	<input type="hidden" id="platform" value="<%=platform%>">
	<input type="hidden" id="frmLocation" value="<%=frmLocation%>">
<%
	if (isRedirected != null && isRedirected.equalsIgnoreCase("true") && !from.equals("changeSettings"))
	{
%>
		<script type="text/javascript">
			showResultSets('<%=platform%>','<%=frmLocation%>');
		</script>
<%
	}
}
else
{
	String message = "Manager discovery is currently disabled for your environment.";
%>
	<tr>
		<td height="400px;">
			<table align="center" width="75%" cellspacing="0" cellpadding="0" border="0" style="table-layout:collapse">
				<colgroup><col width="7"><col width="175"><col width="40"><col width="100%"><col width="7"></colgroup>
				<tbody>
					<tr>
						<td height="6" id="inner_top_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
						<td height="6" id="inner_top_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					</tr>
					<tr>
						<td colspan="5" height="100" nowrap="" align="center" id="eg_subcontentbg" class="form_spacing">
							<table border="0" cellspacing="0" cellpadding="5">
								<tbody>
									<tr>
										<td><b><%=message%></b></td>
									</tr>
									<tr>
										<td align="center" style="padding-top:3px;">
											<b>Would you like to enable it?</b>&nbsp;&nbsp;<input type="button" name='discoveryOpt' id="discoveryOpt" value='Enable' style="width: 90px;" class="eg_back" onClick="javascript:enableDisableDiscovery('<%=from%>');">
										</td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
					<tr>
						<td height="6" class="inner_bott_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
						<td id="eg_subcontentbg" width="100%" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
						<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
					</tr>
				</tbody>
			</table>
		</td>
	</tr>
<%
}
%>
</table>
<iframe id="iframe1" name="iframe1" frameborder="0" style="background-color:transprent;display:none;position:absolute;z-index:10"></iframe>
</body>
</html>
<%
//session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscoveryTree.jsp?treeViewSrc="+from+"&showtree=discoverytree");
session.setAttribute("adminLastAccessedURL","/final/admin/EgDiscoveryPane.jsp");
%>


<%!
	public ArrayList udServers = new ArrayList();
	public ArrayList tempServers = new ArrayList();


	public String[] getServerTypesBasedOnPriority(String categoryOption,String [] validServerTypes,IniFile infraPtr)
	{
		String [] result= null;
		if(categoryOption.equalsIgnoreCase("others"))
		{
			ArrayList serversGrpList = getOtherServers(validServerTypes);
			result=new String[serversGrpList.size()];
			for(int j=0;j<serversGrpList.size();j++)
			{
				String otherServer=(String)serversGrpList.get(j);
				result[j]=new String(otherServer);
			}
		}
		else
		{
			//String [] validServerTypes = getValidServerTypesForDiscovery();
			List validServerList = Arrays.asList(validServerTypes);			
			String [] thisvars=infraPtr.getVariables(categoryOption);		
			if(thisvars!=null)
			{
				result=new String[thisvars.length];
				for(int t=0; t<thisvars.length; t++)
				{
					String thisComp = (String)thisvars[t];		
					if(validServerList.contains(thisComp)){
						result[t]=new String(thisComp);					
					}
					else if(validServerList.contains("#"+thisComp)){
						result[t]=new String("#"+thisComp);
					}
				}
			}
		}
		return result;			
	}

	public ArrayList allServerTypes(String[] validServerTypes)
	{
		IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
		ArrayList resultList=new ArrayList();
		ArrayList allServerGrps = getAllServerGroups(validServerTypes);
		for(int a=0;a<allServerGrps.size();a++)
		{
			String categoryOption = (String)allServerGrps.get(a);
			String[] result = getServerTypesBasedOnPriority(categoryOption,validServerTypes,iniFile);
			for(int r=0;r<result.length;r++)
			{
				resultList.add(result[r]);
			}
		}
		return resultList;
	}
	
	public ArrayList getAllServerGroups(String[] servertypes)
	{
		List validServerList = Arrays.asList(servertypes);	
		ArrayList grp = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects = iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				String subject = Subjects[i];
				String[] allVariables = iniFile.getVariables(subject);
				if(allVariables==null || allVariables.length==0)
					continue;
				
				boolean hasVar = false;
				for(int g=0;g<allVariables.length;g++)
				{
					String variable = allVariables[g];
					if(validServerList.contains(variable) || validServerList.contains("#"+variable))
						hasVar = true;
				}
				if(!hasVar) continue;
				grp.add(subject);
			}
			Collections.sort(grp,String.CASE_INSENSITIVE_ORDER);
			grp.remove("AGGREGATES");
			ArrayList otherServers = getOtherServers(servertypes);
			if(otherServers!=null && otherServers.size()>0)
				grp.add("OTHERS");
			return grp;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return new ArrayList();
		}
	}
	public String getCapitalizedCategory(String categoryName)
	{
		StringBuffer buff = new StringBuffer();
		int j = 0;
		if (categoryName != null)
		{
			//for (int i = 0;i<grps.size();i++ )
			//{
				//String val = (String)grps.get(i);
				if (categoryName.indexOf("_") != -1)
				{
					categoryName = StringUtils.replace(categoryName,"_"," ");
				}
				StringTokenizer tokens = new StringTokenizer(categoryName," ");
				while(tokens.hasMoreTokens())
				{
					String token = tokens.nextToken();
					token = token.trim();
					token = token.toLowerCase();
					String sub = token.substring(1);
					String initial = (token.substring(0,1)).toUpperCase();
					initial = initial + sub;
					if (j == 0)
					{
						buff.append(initial);
					}
					else
					{
						buff.append(" ");
						buff.append(initial);
					}
					j++;
				}
			//}
		}
		return buff.toString();
	}
	
	public void getAllInfraServers()
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				if (Subjects[i] != null && Subjects[i].equalsIgnoreCase("AGGREGATES"))
				{
					continue;
				}

				String [] variables = iniFile.getVariables(Subjects[i]);
				for (int j = 0;j<variables.length;j++)
				{
					if(!tempServers.contains(variables[j]))
						tempServers.add(variables[j]);
				}
			}
		}
		catch (Exception e)
		{
		}
	}
	public ArrayList getOtherServers(String[] servertypes)
	{
		List validServerList = Arrays.asList(servertypes);
		getAllInfraServers();
		ArrayList serverList = new ArrayList();
		EgDiscInfo egDisc = new EgDiscInfo("manager");
		String[] otherServers = egDisc.getComponentTypes();
		if (otherServers == null || otherServers.length == 0)
		{
			return new ArrayList();
		}
		for(int i=0; i<otherServers.length; i++)
		{
			String otherServer = otherServers[i];
			if (!otherServer.equals("Site_servers"))
			{
				if (!tempServers.contains(otherServer))
				{
					if(validServerList.contains(otherServer))
						serverList.add(otherServer);
					else if(validServerList.contains("#"+otherServer))
						serverList.add("#"+otherServer);
				}
			}
		}
		return serverList;
	}	
	

%>