<%
/***********************************************************************************************************
*	Name			:	renamep.jsp
*	Purpose			:	Process page for rename.jsp
*	Version			:	5.5
*	CreationDate	:	17-Feb-2012
*	Author			:	James Thomas P
***********************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.Rename"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	boolean doesOldnameExist(String current_name[],String old_name,String new_name, Vector nameConflict)
	{
		boolean success = false;
		if(current_name != null && current_name.length>0)
		{
			for(int i=0;i<current_name.length;i++)
			{
				if(current_name[i].equals(old_name))
				{
					success = true;
				}
				if(current_name[i].equals(new_name))
				{
					nameConflict.add("true");
					return false;
				}
			}
		}
		return success;
	}
%>
<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	screenLabels.put("isValid","true");

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String rename = request.getParameter("rename");
	String old_name = EgURLDecoder.decode(request.getParameter("old_name"),"UTF-8");
	String new_name = EgURLDecoder.decode(request.getParameter("new_name"),"UTF-8");
	
	if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name) || StringUtils.isNull(rename))
	{
		Vector sess_vec = new Vector();
		if(StringUtils.isNull(rename))
		{
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Admin Home Page"));
			sess_vec.addElement("EgAdminOperations.jsp");
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Rename"));
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Some error occurs")+". " + _mapping.getTextDescription("admin.error.Try again!"));
		}
		else
		{
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Rename"));
			if(rename.equalsIgnoreCase("Segment"))
			{
				sess_vec.addElement("EgDispSegments.jsp?reqfrom=navlink");
			}
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming"));
			if(StringUtils.isNull(new_name))
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.error.You can not proceed renaming as new name for the selected zone is null")+". ");
				screenLabels.put("isValid","false");
				screenLabels.put("admin.common.ErroInRenamingSegment",_mapping.getTextDescription("admin.error.You can not proceed renaming as new name for the selected segment is null")+". ");
			}
			else
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.error.You can not proceed renaming as current name of the selected zone is null")+". ");
				screenLabels.put("isValid","false");
				screenLabels.put("admin.common.ErroInRenamingSegment",_mapping.getTextDescription("admin.error.You can not proceed renaming as current name of the selected segment is null")+". ");
			}
		}
		session.setAttribute("vec_Errors",sess_vec);
		
		rootJson.put("screenLabels",screenLabels);
		out.println(rootJson.toString());
		return;
	}
	else
	{
		if(IniUI.isEgReservedKeyword(new_name))
		{
			Vector sess_vec = new Vector();
			if(rename.equalsIgnoreCase("Segment"))
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a segment"));
				sess_vec.addElement("rename.jsp?from=segment&old_name="+EgURLEncoder.encode(old_name,"UTF-8"));
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a segment"));
			}
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Possible reason")+":");
			sess_vec.addElement("'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name"));
			session.setAttribute("vec_Errors",sess_vec);

			screenLabels.put("isValid","false");
			screenLabels.put("admin.common.ErroInRenamingSegment","'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name")+".");
		
			rootJson.put("screenLabels",screenLabels);
			out.println(rootJson.toString());
			return;
		}

		boolean oldNameExist = false;
		boolean isSite = false;
		String auditlogLabel = null;
		String nameConflictLabel = null;
		String update_msmt_table = request.getParameter("update_msmt_table");
		Vector nameConflict = new Vector();//dont add anything into this vector

		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Activity","Rename");

		String targetPageURL = null;
		if(rename.equalsIgnoreCase("Segment"))
		{
			auditLogThread.setValue("Module","Segments");
			targetPageURL="EgDispSegments.jsp?reqfrom=navlink";
			oldNameExist = doesOldnameExist(new EgTopoInfo("manager").getSegmentNames(),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a segment with a name which is already assigned to another segment";
			auditlogLabel=old_name + " segment can not be renamed to "+new_name +" as this is name already assigned to some to some other segment";
		}
		if(!nameConflict.isEmpty())
		{
			auditLogThread.setValue("Description",auditlogLabel);
			auditLogThread.sendItToDB();
			Vector errors = new Vector();
			errors.addElement(_mapping.getTextDescription("admin.error.Rename a " + rename));
			errors.addElement(targetPageURL);
			errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
			errors.addElement(_mapping.getTextDescription(nameConflictLabel)+".");
			session.putValue("vec_Errors", errors);

			screenLabels.put("isValid","false");
			screenLabels.put("admin.common.ErroInRenamingSegment",_mapping.getTextDescription(nameConflictLabel)+".");
		
			rootJson.put("screenLabels",screenLabels);
			out.println(rootJson.toString());
			return;
		}
		if(oldNameExist)
		{
			boolean success = false;
			if(rename.equalsIgnoreCase("Segment"))
			{
				Rename renameObj = new Rename(u_rs,"Segment",old_name,new_name,update_msmt_table,isSite);
				success = renameObj.executeDefaultQueries();
				if(!success)
				{
					auditLogThread.setPreviousValue("Segment name",old_name);
					auditLogThread.setCurrentValue("Segment name",new_name);
					auditLogThread.setValue("Description","Database tables have not been updated with new segment name");
					auditLogThread.sendItToDB();

					Vector sess_vec = new Vector();
					sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
					sess_vec.addElement(targetPageURL);
					sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
					sess_vec.addElement("Problem while updating database tables. Please try again!");
					session.putValue("vec_Errors",sess_vec);

					screenLabels.put("isValid","false");
					screenLabels.put("admin.common.ErroInRenamingSegment",_mapping.getTextDescription("admin.error.Problem while updating database tables")+". "+_mapping.getTextDescription("admin.error.Please try again"));
				
					rootJson.put("screenLabels",screenLabels);
					out.println(rootJson.toString());
					return;
				}
				else
				{
					session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp");
					session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=dashboard");
					session.setAttribute("reportLastAccessedURL","/final/monitor/EgReporter.jsp");
					session.setAttribute("configLastAccessedURL","/final/servlet/com.eg.EcConfigurationServlet?cmd=Home");

					IniFile topologyIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
					IniFile topologySync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_topology.ini");
					topologySync.deleteValue("TOPOLOGY_SEGMENTS",old_name);
					topologySync.setValue("TOPOLOGY_SEGMENTS",new_name,new_name);
					Vector vars = topologyIni.getVariables(old_name,true);
					Vector vals = topologyIni.getAllValues(old_name);
					topologySync.deleteSubject(old_name);
					if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
					{
						for(int i=0;i<vars.size();i++)
						{
							topologySync.setValue(new_name,(String)vars.get(i),(String)vals.get(i));
						}
					}
					vars = topologyIni.getVariables("WEB_SITE_SEGMENTS",true);
					vals = topologyIni.getAllValues("WEB_SITE_SEGMENTS");
					if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
					{
						for(int i=0;i<vals.size();i++)
						{
							String val = (String)vals.get(i);
							String temp = ","+val+",";
							int index = temp.indexOf((","+old_name+","));
							if(index>-1)
							{
								String new_name_str = StringUtils.replace(temp,(","+old_name+","),(","+new_name+","));
								new_name_str=new_name_str.substring(1,new_name_str.length()-1);
								topologySync.setValue("WEB_SITE_SEGMENTS",(String)vars.get(i),new_name_str);
							}
						}
					}
					IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
					IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
					vars = groupsIni.getVariables("ZONE_DETAILS",true);
					vals = groupsIni.getAllValues("ZONE_DETAILS");
					if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
					{
						for(int i=0;i<vars.size();i++)
						{
							if(vars.get(i).toString().startsWith("Segment:"+old_name+":NULL#"))
							{
								String var = vars.get(i).toString();
								String val = vals.get(i).toString();
								groupSync.deleteValue("ZONE_DETAILS",var);
								String associated_zone = var.substring(var.lastIndexOf("#")+1);
								var = "Segment:"+new_name+":NULL#"+associated_zone;
								groupSync.setValue("ZONE_DETAILS",var,val);
							}
						}
					}
					vars = null;
					vals = null;
					// Rename segment_display_image
					String imageValue = topologyIni.getValue("SEGMENT_DISPLAY_IMAGE",old_name);
					topologySync.deleteValue("SEGMENT_DISPLAY_IMAGE",old_name);
					topologySync.setValue("SEGMENT_DISPLAY_IMAGE",new_name,imageValue);

					topologySync.saveFile();
					groupSync.saveFile();
					registry.updateAllUserMaps();
					EgStateZone.updateZoneGroupStatus();
					EgConfigFilesSync.releaseInstance(topologySync);
					EgConfigFilesSync.releaseInstance(groupSync);
					if(update_msmt_table != null && update_msmt_table.equals("true"))
					{
						success = renameObj.executeOtherQueries();
						if(!success)
						{
							auditLogThread.setPreviousValue("Segment name",old_name);
							auditLogThread.setCurrentValue("Segment name",new_name);
							auditLogThread.setValue("Description","Report and measurement tables have not been updated with new segment name");
							auditLogThread.sendItToDB();

							Vector sess_vec = new Vector();
							sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
							sess_vec.addElement(targetPageURL);
							sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
							sess_vec.addElement("Problem while updating report and measurement tables.");
							session.putValue("vec_Errors",sess_vec);
							
							screenLabels.put("isValid","false");
							screenLabels.put("admin.common.ErroInRenamingSegment",_mapping.getTextDescription("admin.error.Problem while updating report and measurement tables. Please try again"));
						
							rootJson.put("screenLabels",screenLabels);
							out.println(rootJson.toString());
							return;
						}
					}
					auditLogThread.setPreviousValue("Segment name",old_name);
					auditLogThread.setCurrentValue("Segment name",new_name);
					auditLogThread.setValue("Description","Segment has been renamed");
					auditLogThread.sendItToDB();
				}
			}
			String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
			Vector sess_vec = new Vector();
			sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
			sess_vec.addElement(targetPageURL);
			sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
			sess_vec.addElement(old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".");
			session.putValue("vec_Results",sess_vec);

			screenLabels.put("isValid","true");
			screenLabels.put("successMsg",_mapping.getTextDescription("Segment has been renamed successfully"));

		}
		else
		{
			String errorLabel = rename + " name";
			auditLogThread.setPreviousValue(errorLabel,old_name);
			auditLogThread.setCurrentValue(errorLabel,new_name);
			auditLogThread.setValue("Description",rename+" was not renamed as it had already been deleted");
			auditLogThread.sendItToDB();

			String label = "admin.common."+rename.toLowerCase()+" was not renamed to";
			Vector sess_vec = new Vector();
			sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
			sess_vec.addElement(targetPageURL);
			sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
			sess_vec.addElement(old_name + " " +_mapping.getTextDescription(label) + " " + new_name +".");
			session.putValue("vec_Errors",sess_vec);
			
			screenLabels.put("isValid","false");
			screenLabels.put("admin.common.ErroInRenamingSegment",_mapping.getTextDescription("Segment was not renamed as it had already been deleted"));
		}
	}

	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());
%>
