<%
/***********************************************************************************************************
*
*       Name            :       EgManageCommandsRCJson.jsp 
*       Purpose         :       To Add Commands by admin to execute it from remote. 
		
***********************************************************************************************************/
%>
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	 response.setContentType("application/json");
     response.setHeader("Cache-Control","no-store");
     response.setHeader("Pragma","no-cache");
     response.setDateHeader("Expires", -1);
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	String process = request.getParameter("process");
	String osSelected = request.getParameter("osName");
	boolean isValidOS = !StringUtils.isNull(osSelected) && !osSelected.equals("-1");
	String nickNameTxt = request.getParameter("nickNameTxt");
	String existCommand = request.getParameter("existingcommand");
	boolean isDouble=EgDbInfo.doubleByteEnabled;
%>

<%
	IniFile iniUi = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini", true);
	String msg = request.getParameter("msg");
	java.util.HashMap hm = new java.util.HashMap();
	existCommand = com.egurkha.util.StringUtils.decodeSecurityChar(existCommand);
	String cmdExist = "false";
	
	JSONObject existingCommand = new JSONObject();
	JSONArray existingCommandArray = new JSONArray();
	JSONObject existingCmdtodelete = new JSONObject();
	JSONArray existingCmdtodeleteArray = new JSONArray();

	String defaultSelCmd = isValidOS ? "Choose a command" : "Not Applicable";
	existingCommand.put("displayField",_mapping.getTextDescription("admin.remote."+defaultSelCmd));
	existingCommand.put("valueField","-1");
	existingCommandArray.add(existingCommand);

	if (process != null && isValidOS)
	{
		if (process.equalsIgnoreCase("add"))
		{
			if(nickNameTxt != null && (nickNameTxt = nickNameTxt.trim()).length()>0)
			{
				Vector cmdList = iniUi.getAllValues(osSelected);
				if(cmdList != null && !cmdList.isEmpty())
				{
					for(int i=0; i<cmdList.size();i++)
					{
						String cmdName = ((String)cmdList.get(i)).trim();
						int pipeIdx = cmdName.indexOf("|");
						if(pipeIdx >-1)
						{
							cmdName = cmdName.substring(0,pipeIdx);
						}
						if(cmdName.equalsIgnoreCase(nickNameTxt))
						{
							cmdExist = "true";
							break;
						}
					}
				}
				rootJson.put("cmdExist",cmdExist);
			}
		}
		else if (process.equalsIgnoreCase("modify"))
		{
			String commandSynt = iniUi.getValue(osSelected,existCommand);
			rootJson.put("commandSynt",commandSynt.substring(commandSynt.indexOf("|")+1));
		}
	}

	screenLabels.put("admin.remote.Please select an operating system",_mapping.getTextDescription("admin.remote.Please select an operating system"));
	screenLabels.put("admin.common.Update",_mapping.getTextDescription("admin.common.Update"));
	screenLabels.put("admin.remote.Please select a command",_mapping.getTextDescription("admin.remote.Please select a command"));
	screenLabels.put("admin.common.Delete",_mapping.getTextDescription("admin.common.Delete"));
	screenLabels.put("admin.remote.Command display name cannot be empty",_mapping.getTextDescription("admin.remote.Command display name cannot be empty"));
	screenLabels.put("admin.remote.This Command name already exists",_mapping.getTextDescription("admin.remote.This Command name already exists"));
	screenLabels.put("admin.remote.Command syntax cannot be empty",_mapping.getTextDescription("admin.remote.Command syntax cannot be empty"));
	screenLabels.put("admin.remote.Please select a command to delete",_mapping.getTextDescription("admin.remote.Please select a command to delete"));
	screenLabels.put("admin.remote.Are you sure you want to delete?",_mapping.getTextDescription("admin.remote.Are you sure you want to delete?"));
	screenLabels.put("admin.remote.Processing",_mapping.getTextDescription("admin.remote.Processing"));
	screenLabels.put("admin.common.Add",_mapping.getTextDescription("admin.common.Add"));
	screenLabels.put("admin.common.Update",_mapping.getTextDescription("admin.common.Update"));
	screenLabels.put("admin.remote.Operating system",_mapping.getTextDescription("admin.remote.Operating system"));
	screenLabels.put("admin.remote.Choose an operating system",_mapping.getTextDescription("admin.remote.Choose an operating system"));
	screenLabels.put("admin.remote.Existing commands",_mapping.getTextDescription("admin.remote.Existing commands"));
	screenLabels.put("admin.remote.Choose a command",_mapping.getTextDescription("admin.remote."+defaultSelCmd));
	screenLabels.put("admin.remote.Command display name",_mapping.getTextDescription("admin.remote.Command display name"));
	screenLabels.put("admin.remote.Command syntax",_mapping.getTextDescription("admin.remote.Command syntax"));

	JSONObject operaCommand = new JSONObject();
	JSONArray operaCommandArray = new JSONArray();

	operaCommand.put("displayField",_mapping.getTextDescription("admin.remote.Choose an operating system"));
	operaCommand.put("valueField","-1");
	operaCommandArray.add(operaCommand);

	String osNames = iniUi.getValue("OS_LIST","osnames");
	if(osNames != null && (osNames=osNames.trim()).length()>0)
	{
		String[] osSubjects = StringUtils.getTrimmedTokens(osNames,",");
		Arrays.sort(osSubjects,String.CASE_INSENSITIVE_ORDER);
		int oscount=osSubjects.length;
		for(int i=0;i<oscount;i++)
		{
			String osName=osSubjects[i];
			if((osName=osName.trim()).length()>0)
			{
				String actualOSSubject = osName + "_COMMANDS";
				actualOSSubject = actualOSSubject.toUpperCase();
				operaCommand.put("valueField",actualOSSubject);
				operaCommand.put("displayField",osName);
				operaCommandArray.add(operaCommand);
			}
		}
	}
	rootJson.put("operaCommandArray",operaCommandArray);

	boolean dataFound = false;
	if(isValidOS)
	{
		Vector variables = iniUi.getVariables(osSelected,true);
		if(variables != null)
		{
			int vcount=variables.size();
			if(vcount>0)
			{
				dataFound = true;
				Collections.sort(variables,String.CASE_INSENSITIVE_ORDER);
				for(int i=0;i<vcount;i++)
				{
					String cmd_key = (String)variables.get(i);
					if(!cmd_key.startsWith("U"))
					{
						//we don't consider pre-defined remote control actions to modify/delete operations
						continue;
					}
					String value = iniUi.getValue(osSelected,cmd_key);
					if(value != null && (value=value.trim()).length()>0)
					{
						hm.put(cmd_key,value);
						String display_cmd = value.substring(0,value.indexOf("|"));
						String actual_cmd = value.substring(value.indexOf("|")+1);
						existingCommand.put("displayField",display_cmd);
						existingCommand.put("valueField",cmd_key);
						existingCommandArray.add(existingCommand);

						existingCmdtodelete.put("displayField",display_cmd);
						existingCmdtodelete.put("valueField",cmd_key);//For Deleting existing Commands
						existingCmdtodeleteArray.add(existingCmdtodelete);
					}
				}
			}
		}
	}
	rootJson.put("dataFound",dataFound);
	rootJson.put("existingCommandArray",existingCommandArray);
	if(dataFound)
	{
		rootJson.put("existingCmdtodeleteArray",existingCmdtodeleteArray);//For deleting existing commands
	}
	else
	{
		String message = "<div class='egFlexCenterByColumnWise' style='height:95%;margin-top:100px'><div class='iconExclamation'></div><div class='commonErrorMsgText' id='noCompAlrtDiv'>"+_mapping.getTextDescription("admin.remote.No user defined commands found")+".</div></div>";
		rootJson.put("message",message);
	}

	session.setAttribute("cmds",hm);
	rootJson.put("cmds",hm);
	if(request.getQueryString()!=null)
	{
		String str = request.getQueryString();
		String temp = "process=add";
		if (str.indexOf(temp) > -1)
		{
			String strPart1 = str.substring(0,str.indexOf(temp));
			String strPart2 = str.substring(str.indexOf(temp)+temp.length());
			strPart1 = strPart1 + "process=" + strPart2;
			str = strPart1;
		}
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAgentSettings.jsp?"+str);
	}
	else 
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAgentSettings.jsp");
	}
	rootJson.put("screenLabels",screenLabels);

	//System.out.println("rootJson___________"+rootJson);
	out.println(rootJson.toString());
%>



