;(function(){
    new function() {
        if (!window.EGRUM) {
/*
 Copyright 2010 Google Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 See the source code here:
 http://code.google.com/p/episodes/
 */
/**
 * @description For Debug purpose. These values will be changed by rumcollector at runtime dynamically.
 */
window['egrum-debug-nav']=false;
window['egrum-debug-rsrc']=false;
window['egrum-debug']=false;
/**
 * @description In old browser String.trim() is not supported. Custom util function to trim the string.
 */
function removeSpace(str){
 	return str.replace(/^\s+|\s+$/g, '');;
}

var EGRUM = EGRUM || {};
var EGRUMSPA = EGRUMSPA || {};
/**
 * @description Input configuration data from eGRUM code snippet Beacon URL, Site Name GUID and Resource Max Limit.
 */
EGRUM["beacon-url"] = window["beacon-url"] || "";
EGRUM["site"] = window["Site_Name"] || "";
EGRUM["rsrc_limit"] = parseInt(window["eg_rsrc_max_limit"]) || 500; // Default Resource Max Limit is 5000

/**
 * @description Additional configuration details such as user name scraping will be available in this.
 */
EGRUM.config = window['egrum-config'] || {};

EGRUM.q = EGRUM.q || [];

/**
 * @description To collect the JavaScript error details in an array.
 */
EGRUM.error = [];
EGRUM.status = '';

/**
 * @description To disable navigation API metric collection, can set it to false.
 */
EGRUM.autorun = ( "undefined" != typeof(EGRUM.autorun) ? EGRUM.autorun : true );

/**
 * @description Get the value for debug level settings and assign to a variable.
 */
var debug = window['egrum-debug'] || false;

/**
 * @description Default RUM & BTM Integration Cookie Name, Do Not Changes this. 
 */
var rumBtmCookieKey = "EGRUM_BTM";

/**
 * @description Collect & store the complete cookie details in an variable that can be used later in the code. 
 */
var cookieInfo= document.cookie;


if (!window.EGRUM)
{
    window.EGRUM = EGRUMSPA || {} ;
}
var s=window.EGRUM;

/**
 * @description The function generates a GUID string with 32 char 
 * @refer https://stackoverflow.com/a/2117523/3000082 
 * @returns {string} GUID
 */ 
EGRUM.generateGUID = "undefined" !== typeof window.crypto && "undefined" !== typeof window.crypto.getRandomValues ?
	function() { // GUID Generated using Crypto Random values
		return ([1e7]+-1e3+-4e3+-8e3+-1e11).replace(/[018]/g, function c(){
					return (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)}
				)
	} : function(a,b) { // GUID Generated using Match random values
			for(b=a='';a++<36;b+=a*51&52?(a^15?8^Math.random()*(a^20?16:4):4).toString(16):'-');
		return b;
	};

/**
 * @description To make the GUID more unique, we manually append the current timestamp in milliseconds. 
 * 
 * @returns {string} GUID-TIMESTAMP
 */
EGRUM.getGUID=function(){
	return EGRUM.generateGUID()+"-"+new Date().getTime();
}

/**
 * @description Check current window is IFRAME or BASE PAGE
 * 
 * @returns {boolean} Is IFrame
 *  - true - If current window is IFRAME
 *  - false - If current window is Base Page
 */
EGRUM.isIframe = function() {
		return top != window;
}

/**
 * @description This function decides for what scenarios GUIDs need to be created.
 * also, generates GUIDs for the interdepended page views such as a IFRAME, AJAX.
 * Creates and assigns (a) current page GUID (b) Immediate parent GUID (c) Top most parent (base).
 * For each page view, there will be 3 GUIDs always.
 */
EGRUM.initGUIDs = function() {
	var rumGUID = EGRUM.getGUID();
	if (!EGRUM.isIframe()) {
		window.EGRUM["rum_guid"] = rumGUID;
		window.EGRUM["rum_base_guid"] = rumGUID;
	} else {
		window.EGRUM["rum_guid"]= rumGUID;
		var parentObj=EGRUM.getParentObj();
		if(!parentObj.baseWin) 
			parentObj.baseWin = window;
		window.EGRUM["rum_base_guid"] = parentObj.baseWin.EGRUM["rum_guid"];
		if(parentObj.parentWin)
			window.EGRUM["rum_parent_guid"] = parentObj.parentWin.EGRUM["rum_guid"];
		
	}
}

/**
 * @description Getting Base Page Ref (window) and Parent Page Ref (window)
 * 
 * @returns Both Base Page window and Parant Page window 
 *  - baseWin - Base page window reference
 *  - parentWin - Parent page window reference 
 */
EGRUM.getParentObj=function(){
	var parent,base;
	for(var currentWindow=window;currentWindow.parent && !(currentWindow.parent==currentWindow);){
		currentWindow=currentWindow.parent;
		try{
			if(currentWindow.EGRUM){
				if(!parent) parent=currentWindow;
				base=currentWindow;
			}
		}catch(err){}
		
	}
	return {baseWin:base,parentWin:parent};
}
EGRUM.initGUIDs();

/**
 * @description To get the current page GUID, if not available, creates a fresh one. 
 * 
 * @returns {string} current window GUID
 */
EGRUM.getPageGUID = function() {
	if(!window.EGRUM["rum_guid"]){
		window.EGRUM["rum_guid"]=EGRUM.getGUID();
	}
	return window.EGRUM["rum_guid"];
}

/**
 * @description To get the base(top most parent) page GUID, if not available, returns empty string. 
 * 
 * @returns {string} Base Page GUID if exist
 *  - GUID - If Available
 *  - empty string - Not Available or Not able to access the Base Page GUID in CORS iframe
 */
EGRUM.getBaseGUID = function() {
	return window.EGRUM["rum_base_guid"] || "";
}

/**
 * @description To get the immediate parent page GUID, if not available, returns empty string.
 * 
 * @returns {string} Parent Page GUID
 *  - GUID - if Parent window GUID available
 *  - empty string - Not Available or Not able to access the Base Page GUID in CORS iframe
 */
EGRUM.getParentGUID = function() {
	return window.EGRUM["rum_parent_guid"] || "";
}

/**
 * @description EGRUM object constructor with key fields.
 */
EGRUM.init = function() {
    EGRUM.bDone = false;
    EGRUM.marks = {};
    EGRUM.measures = {};
    EGRUM.errors = {};
    EGRUM.errors["errors"] = 0;
    EGRUM.starts = {};
    EGRUM.findStartTime();
    EGRUM.contentLoadFired = false;
    EGRUM.mark("firstbyte",window["egrum-start_time"]);
    EGRUM.addEventListener("beforeunload", EGRUM.beforeUnload, false);
    if ("complete" === document.readyState){
        EGRUM.domContentLoaded(); // If script loaded after DOM complete then need to call this explicitly
    }else if ("undefined" !== typeof document.addEventListener){
        document.addEventListener("DOMContentLoaded", EGRUM.domContentLoaded, false);
    }else if ("undefined" !== typeof document.attachEvent){
        document.attachEvent("onreadystatechange", EGRUM.readyStateChange);
    }
	EGRUM.setResourceLimit();
    EGRUM.findError();
    EGRUM.AjaxMes();
    EGRUM.addEventListener("load", EGRUM.onload, false);
	EGRUM.postSendBeacon();
	window.EGRUM["onerror"] = EGRUM.errFn;
};

/**
 * @description Find the DOM Element using XPath
 * 
 * @param {string} xpath 
 * @param {Window} parent 
 * 
 * @returns {Array} DOMElements[]
 */
	function getElementsByXPath(xpath, parent)
	{
		var results = [];
		var query = document.evaluate(xpath,parent || document, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
		for (var i=0, length=query.snapshotLength; i<length; ++i) {
			results.push(query.snapshotItem(i));
		}
		return results;
    }

/**
 * @description Extract the UserName using XPATH, CSS Path or DOM ID
 * 
 * @returns {string} userName
 */
EGRUM.getUN = function(){
		var userName ='';
	try{
		var userNameObj = EGRUM && EGRUM.config && EGRUM.config.username;
		if(!userNameObj) return userName;
		var userNameEnabled = userNameObj['username_enabled'];
		var selectorType = userNameObj['selectortype'];
		var selectoridorpath = userNameObj['selectoridorpath'];
		var cleanupRegex = userNameObj['cleanupregex'];
		var cleanupRegexObj = new RegExp(cleanupRegex);
		var selectorIndex = userNameObj['selectorindex'] || 1;
		if(userNameEnabled && selectorType && selectoridorpath){
			selectorType = selectorType.toLowerCase();
			var domArr;
			if(selectorType == 'css'){
				domArr = document.querySelectorAll(selectoridorpath);
			}else if(selectorType == 'xpath'){
				domArr = getElementsByXPath(selectoridorpath);
			}else if(selectorType == 'dom'){
				domArr = document.querySelectorAll("#"+selectoridorpath);
			}
			if(domArr){
				var domLen = domArr.length;
				if(domLen && selectorIndex <= domLen){
					var node = domArr[selectorIndex-1];
					if(node){
						var extText = node.innerText || node.value;
						extText = removeSpace(extText);
						if(cleanupRegex && extText){
							var matchResult = extText.match(cleanupRegexObj);
							var matchText = (matchResult && matchResult[1]) || '';
							userName =  removeSpace(new String(matchText));
						}else{
							userName = extText;
						}
					}
				}
			}
		}
		if(!userName){ userName=''};
	}catch(e){
	}
	return userName;
}

/**
 * @description Window Error Event Listener. When error occures, capture the error and push to array.
 */
EGRUM.onerror=function(e){
    EGRUM.errFn(e);
};

/**
 * @description Adding Event Listener for window.error
 */
EGRUM.findError= function()
{
	var captureConf = EGRUM.config && EGRUM.config.capture;
	var toCaptureJSError  = captureConf && captureConf.jsError;
	if(typeof toCaptureJSError !== 'undefined' && (!toCaptureJSError || toCaptureJSError == 'false')){
		return;
	}
    var isIE=(EGRUM.getBrowserName().indexOf("Internet Explorer") != -1);
    var isFireFox=(EGRUM.getBrowserName().indexOf("Firefox") != -1);
    if((window.addEventListener || window.attachEvent) && !isFireFox && !isIE){
        EGRUM.addEventListener("error", EGRUM.onerror, false);
    }
    else{
        var oldErr=window.onerror;
        window.onerror=function(msg, fn, line, col, e){
            EGRUM.errFn(e);
            if(oldErr){
                return oldErr(msg, fn, line, col, e);
            }
            return false;
        };
    }
};


EGRUM.errFn = function(err, fn, line, col, stack, meta, parentGUID){
	if(err){
		var msg = '';
		if(typeof err === 'object') {
			msg = err.message || err.description;
			fn = fn || err.fileName || err.filename;
			line = line || err.lineNumber || err.lineno;
			col = col || err.columnNumber || err.colno;
			stack = stack || err.stack;
			meta = meta || err.meta;
		}
		else {
			msg = err;
		}
		msg = msg || '';
		if (typeof msg !== 'string') msg += '';
		fn = fn || '';
		if (typeof fn !== 'string') fn += '';
		line = line || '';
		col = col || '';
		stack = stack || '';
		if (typeof stack !== 'string') stack += '';
		msg = msg.replace(/(?:\r\n|\r|\n)/g, '<br>');
		stack = stack.replace(/(?:\r\n|\r|\n)/g, '<br>');
        meta = meta || {};
        var metaStr ="";
        for (var key in meta) {
            if (meta.hasOwnProperty(key)){ 
                var value = meta[key];
                value = value.replace(/(?:\r\n|\r|\n)/g, '<br>');
                metaStr +=  key+"="+value+",";
            }
        }
        metaStr = metaStr.slice(0, -1);
        // EGRUM.error.push([msg, url, line, col, stack, meta]);
        EGRUM.sendError(msg, fn, line, col, stack, metaStr, parentGUID);
	}
}

EGRUM.sendError = function(msg, fn, line, col, stack, meta, parentGUID){
	if(document.readyState !== "complete"){
		EGRUM.status = "error";
	}
    var errGUID = EGRUM.getGUID();
    var rumParentGUID = parentGUID || EGRUM.getPageGUID();
    var rumBaseGUID = EGRUM.getBaseGUID();
    var beaconUrl = EGRUM["beacon-url"];
    var serviceName = EGRUM["site"];
    if(beaconUrl && removeSpace(beaconUrl).length !=0 ) {
        beaconUrl = beaconUrl + "/rumcollector/rdr";
        if (EGRUM.isJSONSupport()) {
            var params = {
                "srn": serviceName,
                "rbgd": rumBaseGUID,
                "errgd": errGUID,
                "rpgd": rumParentGUID,
                "iserr": "true",
                "errmsg": msg,
                "errfn": fn,
                "errln": line,
                "errcol": col,
                "errstack": stack,
                "errmeta": meta
            }
            var xhr = new XMLHttpRequest();
            var paramStr = JSON.stringify(params);
            if (!window.XMLHttpRequest)
                xhr = new ActiveXObject("Microsoft.XMLHTTP");
            xhr.open("POST", beaconUrl, true);
            xhr.setRequestHeader("Content-type", "text/plain; charset=UTF-8");
            xhr.send(paramStr);
        }
        else {
            var params = "srn="+serviceName+"&iserr=true"+"&rbgd="+rumBaseGUID+"&errgd="+errGUID+"&rpgd="+rumParentGUID
                            +"&errmsg="+"&errfn="+errfn+"&errln="+errln
                            +"&errcol="+col+"&errstack="+errstack+"&errmeta="+errmeta;
            beaconUrl = beaconUrl +"?"+ params;
            var img = new Image();
            img.src = beaconUrl;
        }
    }
}


/**
 * @description Collecting the Network information from Browser API
 * 
 * @returns {object} downlink, effectiveType, rtt
 */
EGRUM.netInfo = function(){
	var info = {downlink:-5, effectiveType:'-', rtt:-5};
	try{
		if(window.navigator && window.navigator.connection){
			var connInfo = window.navigator.connection;
			info.downlink = connInfo.downlink || info.downlink;
			info.effectiveType = connInfo.effectiveType || info.effectiveType;
			info.rtt = connInfo.rtt || info.rtt;
		}
	}
	catch(err){}
	return info;
}

EGRUM.now = function(){
    return new Date().getTime();
}

EGRUMSPA.reportVpage = function(vMetrics){
    var vEvents = vMetrics.perf;
    var metricPLT = Math.max(0, vEvents.virtualPageEnd - vEvents.virtualPageStart) || 0;
    var metricDDT = Math.max(0, vEvents.viewChangeEnd - vEvents.viewChangeStart) || 0;
    var metricDRT = Math.max(0, vEvents.viewDOMLoaded - vEvents.viewChangeStart) || 0;
    var metricDPT = Math.max(0, vEvents.viewDOMLoaded - vEvents.viewChangeEnd) || 0;
    var spaTimes = "plt:"+ metricPLT+",ddt:"+ metricDDT+",drt:"+ metricDRT+",dpt:"+ metricDPT;
    var netInfo = EGRUM.netInfo();
    var error = vMetrics.err; 
    var err = "";
    var errCount = 0;
    
    var metaObj = vMetrics.metaObj;
    var pageStatus = vMetrics.status;
    var pageName = vMetrics.pageName;
    var metaStr ="";
    for (var key in metaObj) {
        if (metaObj.hasOwnProperty(key)){ 
            metaStr +=  key+"="+metaObj[key]+",";
        }
    }
    metaStr = metaStr.slice(0, -1);
    var url = vMetrics.url;
	if(EGRUM.isExcludeURL(url,false) || !EGRUM.isIncludeURL(url)){
		return;
	}

    var rumVpageGUID = EGRUM.getGUID();//To Generate New vPage GUID
	var rumBaseGUID = EGRUM.getBaseGUID();
    var rumParentGUID =  EGRUM.getPageGUID();

    if(error){
        EGRUM.errFn(error.message, '', '', '', error.stack, metaObj, rumVpageGUID);
    }

    var isNav=EGRUM.isNavSupport();
    var isRsrc=EGRUM.isRsrcSupport();
    
    var isIFrame = EGRUM.isIframe()+'';

    var browserDetails = EGRUM.getBrowserName();
    var deviceDetails = EGRUM.getDeviceDetails();
    var OSDetails = EGRUM.getOSDetails();
    var nAgt= navigator.userAgent;
    var referrer = document.referrer;
    referrer = referrer.split('?')[0];
    var sid = EGRUM.getCookieVal('JSESSIONID');
    var beaconUrl = EGRUM["beacon-url"];
    if(beaconUrl && removeSpace(beaconUrl).length !=0 ) {
        var serviceName = EGRUM["site"];
        beaconUrl = beaconUrl + "/rumcollector/rdr";
        if (EGRUM.isJSONSupport()) {
            var params = {"sid":sid, "prm":spaTimes,"url":url,
                            "vpg":"true","ifr": isIFrame,"bdt":browserDetails, "osd":OSDetails,
                            "dvdt":deviceDetails,"srn":serviceName, "agt":nAgt, "ref":referrer,
                            "erc":errCount,"err":err, "btet":"",  "btgd":"", "btno":"",
                            "rbgd":rumBaseGUID, "rgd":rumVpageGUID, "rpgd":rumParentGUID,
                            "isNav":isNav,"isRsrc":isRsrc, "nwDownlink":netInfo.downlink,
                            "nwEffectiveType": netInfo.effectiveType, "nwRTT":netInfo.rtt,
                            "meta": metaStr, "status":pageStatus, "pgnm":pageName
                            };

            var xhr = new XMLHttpRequest();
            var paramStr = JSON.stringify(params);
            if (!window.XMLHttpRequest)
                xhr = new ActiveXObject("Microsoft.XMLHTTP");
            xhr.open("POST", beaconUrl, true);
            xhr.setRequestHeader("Content-type", "text/plain; charset=UTF-8");
            xhr.send(paramStr);
        }
        else{
            var params = "sid="+encodeURIComponent(sid)+"&prm="+spaTimes+"&url="+encodeURIComponent(url)
                            +"&vpg=true&bdt="+encodeURIComponent(browserDetails)+"&ifr="+isIFrame
                            +"&erc="+errCount+"&err="+encodeURIComponent(err)+"&osd="+encodeURIComponent(OSDetails)+"&dvdt="+encodeURIComponent(deviceDetails)
                            +"&agt="+encodeURIComponent(nAgt)+"&srn="+encodeURIComponent(serviceName)
                            +"&ref="+encodeURIComponent(referrer)+"&btet=&btgd=&btno="
                            +"&rbgd="+rumBaseGUID+ "&rgd="+rumVpageGUID+ "&rpgd="+rumParentGUID
                            +"&isNav="+isNav+"&isRsrc="+isRsrc+"&nwDownlink="+netInfo.downlink
                            +"&nwEffectiveType="+ netInfo.effectiveType+"&nwRTT="+netInfo.rtt
                            +"&status="+pageStatus+"&meta="+encodeURIComponent(metaStr)+"&pgnm="+encodeURIComponent(pageName);
            beaconUrl = beaconUrl +"?"+ params;
            var img = new Image();
            img.src = beaconUrl;
            return img.src;
        }
    }
}

function vEvents(vo){
    this.perf = {};
    this.url = (vo && vo.url) || document.location.href;
    this.status = '';
    this.metaObj = {};
    this.expl = '';
    this.pageName = '';
}

vEvents.prototype.page = function(info){
    this.pageName = info || '';
}
vEvents.prototype.meta = function(infoObj){
    for (var  key in infoObj) {
        if (infoObj.hasOwnProperty(key)){ 
            this.metaObj[key] = infoObj[key];
        }
      }
}
vEvents.prototype.markVirtualPageStart = function(ts){
    this.perf.virtualPageStart = ts || EGRUM.now();
}
vEvents.prototype.markViewChangeStart = function(ts){
    this.perf.viewChangeStart = ts || EGRUM.now();
}
vEvents.prototype.markViewChangeEnd = function(ts){
    this.perf.viewChangeEnd = ts || EGRUM.now();
}
vEvents.prototype.markViewDOMLoaded = function(ts){
    this.perf.viewDOMLoaded = ts || EGRUM.now();
}
vEvents.prototype.markXhrRequestsCompleted = function(ts){
    this.perf.xhrRequestsCompleted = ts || EGRUM.now();
}
vEvents.prototype.markViewResourcesLoaded = function(ts){
    this.perf.viewResourcesLoaded = ts || EGRUM.now();
}
vEvents.prototype.markVirtualPageEnd = function(trnsObj){
    this.perf.virtualPageEnd = (trnsObj && trnsObj.time) || EGRUM.now();
    this.url = (trnsObj && trnsObj.url) || document.location.href;
    this.status = (trnsObj && trnsObj.status) || 'completed';
    this.err = (trnsObj && trnsObj.explanation) || '';
    EGRUMSPA.reportVpage(this);
}

var spaTrans;
EGRUMSPA.vPage=function(cmd, info, cntrlName){
                switch (cmd){
                    case 'page':
                        if(document.readyState !== "complete") return;
                        var transEvt = new vEvents();
                        transEvt.page(info);
                        spaTrans = transEvt;
                        break;
                    case 'meta':
                        var obj = {};
                        obj[info]=cntrlName;
                        spaTrans && spaTrans.meta(obj);
                        break;
                    default:
                        var spaMethod = spaTrans && spaTrans[cmd];
                        if(spaMethod) spaMethod.call(spaTrans, info, cntrlName);
                        break;
                }
            }


/**
 * @description Ajax Wrapping function.
 *  Wraps the methods of XMLHttpRequest
 *  - open function
 *  - send function
 *  - onreadystatechange 
 *  - load Event Listener 
 *  - error Event Listener 
 *  - readystatechange Event Listener
 */
EGRUM.AjaxMes = function()
{
	var captureConf = EGRUM.config && EGRUM.config.capture;
	var toCaptureAjax  = captureConf && captureConf.ajax;
	if(typeof toCaptureAjax !== 'undefined' && (!toCaptureAjax || toCaptureAjax == 'false')){
		return;
	}
    var h = null;
    if(window.XMLHttpRequest){
        var ajaxReq=window.XMLHttpRequest.prototype;
        if(ajaxReq){
            if(ajaxReq.open||ajaxReq.send){
                var firstByte=function(xhr){ // First Byte call back function
                    var metrics=xhr.s;
                    if(metrics){
                        var d=(new Date).getTime();
                        if(2 == xhr.readyState){
                            metrics.firstByteTime=metrics.firstByteTime||d;
                        }else{
                            if(4==xhr.readyState){
                                metrics.respAvailTime=metrics.respAvailTime||d;
                                metrics.firstByteTime=metrics.firstByteTime||d;
                            }
                        }
                    }
                },sendAjax=function(xhr,metrics){ // XHR.send call back function
                    var d=xhr.getAllResponseHeaders(),f=xhr.status;
					metrics["pageName"]=xhr.pageName||'';
					setTimeout(function(){
						EGRUM.reportAjaxReq(metrics,d,f,400<=f?xhr.responseText:h);
					}, 1000);
                },reponseProcessTimeEnd=function(xhr){
                    var metrics=xhr.s;
                    if(metrics && 4==xhr.readyState){
                        metrics.respProcTime=metrics.respProcTime||(new Date).getTime();
                        sendAjax(xhr,metrics);
                        delete xhr.s;
                    }
                },xhrReadyStateWrap=function(xhrsc,xhr,d){ // Response Process call back function
					
                    return EGRUM.findAjax(xhrsc,function(){
                        firstByte(this)
                    },function(){
                        reponseProcessTimeEnd(this);
                    },d);
                },rptCompute = function (xhr) {
                    if (xhr.s) {
                        var now_30000 = (new Date()).getTime() + 3E4,
                            recursive = function () {
                                firstByte(xhr);
                                var metrics = xhr.s;
                                if (metrics) {
                                    var now = (new Date()).getTime();
                                    if(4 == xhr.readyState) {
                                        metrics.respProcTime = metrics.respProcTime || now;
                                        sendAjax(xhr, metrics);
                                    }else{
                                        if(now < now_30000){
                                            setTimeout(recursive, 50);
                                        }
                                        else{
                                            delete xhr.s;
                                        }
                                    }
                                }
                            };
                        recursive();
                    }
                };
                ajaxReq.open=EGRUM.findAjax(ajaxReq.open,function(){ // Wrapping XHR.open function
				var isAsy = true;	
				var xhrURL = 2<=arguments.length?String(arguments[1]):"";
					if(arguments[2] || arguments[2] === false){
						isAsy = arguments[2];
					}
                     this.s={url:xhrURL,sendTime:h,firstByteTime:h,respAvailTime:h,respProcTime:h, method:String(arguments[0])||'', offset:0,asynchronous:isAsy}					
					   if(EGRUM.isDefined(this)){
                            if(4 === this.readyState){
                                var now = (new Date()).getTime();
                                var metrics = this.s;
                                metrics.firstByteTime = metrics.firstByteTime || now;
                                metrics.respAvailTime = metrics.respAvailTime || now;
                                metrics.respProcTime = metrics.respProcTime || now;
								var perform =  EGRUM.getPerformance();
								if("undefined" !== typeof(perform)){
									metrics.offset = perform.now();
								}
                                sendAjax(this, this.s);
                            }
					}
                },h,"ajaxReq.open");
				ajaxReq.setRequestHeader = EGRUM.findAjax(ajaxReq.setRequestHeader, function(){
					var metrics=this.s;
					if(metrics){
						var url = metrics.url;
						var beaconUrl = EGRUM["beacon-url"];
						beaconUrl = beaconUrl + "/rumcollector/rdr";
						var args=Array.prototype.slice.call(arguments)
						var headerName = args[0] || "";
						if(url === beaconUrl && headerName !== "Content-type" ){
							return ["", ""];
						}
					}
				},h,"ajaxReq.setRequestHeader");
                ajaxReq.send=EGRUM.findAjax(ajaxReq.send,function(){ // Wrapping XHR.send function
                    var xhr=this,metrics=xhr.s;
					var ajaxURL = xhr.s.url;
					if(EGRUM.isExcludeURL(ajaxURL,true)){
						return;
					}
                    if(metrics){
						var perf = EGRUM.getPerformance();
						if("undefined" !== typeof(perf)){
							metrics.offset = perf.now();
						}
                        metrics.sendTime=metrics.sendTime||(new Date).getTime();
                        var d=metrics.url,f=document.createElement("a");
                        f.href=d;d=document.location;
                        if (":"===f.protocol && "" === f.hostname && "" === f.port || f.protocol === d.protocol && f.hostname === d.hostname && f.port === d.port){
                            xhr.setRequestHeader("EGRUM","isAjax:true")
                        }
                        
                        var loopCount = 0, isFinished=false;
                        var recursiveFn=function(){
                            if(4 == xhr.readyState){
                                if(!isFinished){
                                    rptCompute(xhr);
                                }
                            }
                            else{
                                var rsc= null;
                                try{
                                    rsc = xhr.onreadystatechange;
                                }
                                catch(err){
                                    if (isFinished) {                                       
                                        return;
                                    }
                                    rptCompute(xhr);
                                    return;
                                }
                                loopCount++;
                                if(rsc){
                                    if(EGRUM.isApply(rsc)){
                                        xhr.onreadystatechange = xhrReadyStateWrap(rsc,xhr,"ajaxReq.onReadyStateChange");
                                        if(isEventListenerSupport){
                                            removeEventListenerFn.call(xhr, "readystatechange", function(){
                                                firstByte(xhr);
                                                reponseProcessTimeEnd(xhr);
                                            });
                                        }
                                    }
                                    else{
                                        rptCompute(xhr);
                                    }
                                } else {
                                    if(loopCount < 5){
                                        setTimeout(recursiveFn);
                                    }else{
                                        if(!isFinished){
                                            rptCompute(xhr);
                                        }
                                    }
                                }
                            };
                        }
                        if(isEventListenerSupport){
                            try{
                                if(addEventListenerFn){
                                    addEventListenerFn.call(xhr, "readystatechange", function(){
                                        firstByte(xhr);
                                        reponseProcessTimeEnd(xhr);
                                    });
                                }
                                isFinished = true;
                            }
                            catch(err){}
                        }
                        recursiveFn();
                    }
                    
                },h,"ajaxReq.send");
                
                var isEventListenerSupport = "addEventListener" in ajaxReq && "removeEventListener" in ajaxReq && EGRUM.isApply(ajaxReq.addEventListener) && EGRUM.isApply(ajaxReq.removeEventListener);
                var addEventListenerFn = null;
                var removeEventListenerFn = null;
                if (isEventListenerSupport){ // If they handled the XHR events with Event Listener need to wrap that also
                    var rootObj = EGRUM.getRoot(ajaxReq, "addEventListener");
                    addEventListenerFn = rootObj.addEventListener;
                    rootObj.addEventListener=EGRUM.findAjax(addEventListenerFn,function(event,listnerFn){ // Wrapping XHR.addeventListener
						var d=Array.prototype.slice.call(arguments);
                        if (listnerFn&&("load"===event||"error"===event||"readystatechange"===event))
                        {
                            listnerFn.ajaxReq||(listnerFn.ajaxReq=xhrReadyStateWrap(listnerFn,this,"ajaxReq.invokeEventListener")); // Setting call back
                            d[1]=listnerFn.ajaxReq;
                        }
                        return d;
                    },h,"ajaxReq.addEventListener");
                    removeEventListenerFn = rootObj.removeEventListener;
                    rootObj.removeEventListener=EGRUM.findAjax(removeEventListenerFn,function(event,listnerFn) // While removing event listeners returning actual function
                    {
                        if(this.s){
                            var d=Array.prototype.slice.call(arguments);
                            if (listnerFn.ajaxReq){
                                d[1]=listnerFn.ajaxReq;
                            }
                            return d
                        }
                    },h,"ajaxReq.removeEventListener");
                }
            }
        }
    }
};

EGRUM.getRoot= function(obj, method) {
    if (EGRUM.isFunction(Object.getPrototypeOf))
    for (; EGRUM.isDefined(obj) && !EGRUM.hasOwnPropertyCheck(obj, method);)
        obj = Object.getPrototypeOf(obj);
    return obj;
}
EGRUM.hasOwnPropertyCheck = function (a, b) {
    return Object.prototype.hasOwnProperty.call(a, b) && EGRUM.isDefined(a[b])
}
EGRUM.isFunction = function(fn) {
    return "function" == typeof fn || !1;
}
EGRUM.isDefined = function(a) {
    return "undefined" !== typeof a && null !== a
}
/**
 * @description Checks the Object which supports 'apply' function or not
 * 
 * @returns {boolean} Two values
 *  - true - Supports
 *  - false - Not Supports
 */
EGRUM.isApply= function(a) {
        return !a || "apply" in a;
    };

/**
 * @description AOP wrapping for given function. Wrapping done on begin and end.
 * 
 * @param {XMLHttpRequest} xhr - XMLHTTPRequest
 * @param {function} r - Function Called at start of the actual function 
 * @param {function} d - Function Called at end of the actual function 
 * @param {string} f - Wrapper name
 * 
 * @returns {function} Wrapped function
 */
EGRUM.findAjax = function(xhr,r,d,f)
{
    r=r||function(){};
    xhr=xhr||function(){};
    d=d||function(){};
    return function() // Function returned which contains wrapped functions
    {
        var g=Array.prototype.slice.call(arguments),l;
        try
        {
            l=r.apply(this,g); // Begin callback function get called
        }catch(m)
        {
            EGRUM.dprint("Failure in interceptor ["+f+"] entry: "+m);
        }
        var p=void 0;
        try
        {
            p=xhr.apply(this,l||g) // Actual function get called
        }
        catch(e){
            EGRUM.dprint("Failure in interceptor error:"+e);
        }
        finally
        {
            try
            {
                d.apply(this,g); // End callback function get called
            }catch(q){
                EGRUM.dprint("Failure in interceptor ["+f+"] exit:"+q);
            }
        }
        return p;
    }
};

/**
 * @description URL parser using Regex pattern
 * 
 * @param {URL} a - Input URL
 * 
 * @returns {Object}
 *  - href
 *  - protocal
 *  - I
 *  - host
 *  - hostname
 *  - port
 *  - pathname
 *  - search
 *  - hash
 */
EGRUM.splitXHRURL = function (a) {
    return (a = String(a).replace(/^\s+|\s+$/g, "").match(/^([^:\/?#]+:)?(\/\/(?:[^:@]*(?::[^:@]*)?@)?(([^:\/?#]*)(?::(\d*))?))?([^?#]*)(\?[^#]*)?(#[\s\S]*)?/)) ? {
        href: a[0] || "",
        protocol: a[1] || "",
        I: a[2] || "",
        host: a[3] || "",
        hostname: a[4] || "",
        port: a[5] || "",
        pathname: a[6] || "",
        search: a[7] || "",
        hash: a[8] || ""
    } : null
};

/**
 * @description Checks the AJAX URL is relative or absolute.\n
 *         if it is relative URL then this function will make the abosulte URL
 * @param {URL} a - Page URL
 * @param {URL} b - Ajax URL
 * 
 * @returns {string} Absolute AJAX URL
 */
EGRUM.findXHRURL = function (a, b) {
    b = EGRUM.splitXHRURL(b || "");
    a = EGRUM.splitXHRURL(a || "");
    var c;
    if (!b || !a) c = null;
    else {
        c = (b.protocol || a.protocol) + (b.protocol || b.I ? b.I : a.I);
        var f;
        f = b.protocol || b.I || "/" === b.pathname.charAt(0) ? b.pathname : b.pathname ? (a.I && !a.pathname ? "/" : "") + a.pathname.slice(0, a.pathname.lastIndexOf("/") + 1) + b.pathname : a.pathname;
        var g = [];
        f.replace(/^(\.\.?(\/|$))+/, "").replace(/\/(\.(\/|$))+/g, "/").replace(/\/\.\.$/, "/../").replace(/\/?[^\/]*/g, function (a) {
            "/.." ===
            a ? g.pop() : g.push(a)
        });
        f = g.join("").replace(/^\//, "/" === f.charAt(0) ? "/" : "");
        c = c + f + (b.protocol || b.I || b.pathname ? b.search : b.search || a.search) + b.hash
    }
    return c
};

/**
 * @description Send the AJAX metrics to the RUM Collector.
 * 
 * @param {object} a - Collected Ajax Metrics
 * @param {Headers} b - XMLHTTPRequest Headers
 * @param {number} d - XMLHTTPRequest status
 * @param {string} f - XMLHTTPRequest Response Text
 * 
 */
EGRUM.reportAjaxReq = function(a, b, d, f)
{
	var rumAjaxGUID = EGRUM.getGUID();//To Generate New Ajax GUID
	var rumBaseGUID = EGRUM.getBaseGUID();
	var rumParentGUID =  EGRUM.getPageGUID();
    var g = b.split("\r\n");
	var btValues = {btgd: '', btno: '', btet:'', btsid:'', btndid:''};
    for (var i = 0; i < g.length; i++) {
		var header = g[i];
		if (header) {
			var colonIndx = header.indexOf(": ");
			var headerKey = header.substring(0, colonIndx);
			if (headerKey == rumBtmCookieKey.toLowerCase()) {
				rumBtmGuid =   removeSpace(header.substring(colonIndx+1));
				btValues = EGRUM.parseBtInfo(rumBtmGuid);
			}
        }
	}
    /*b = [];
    for (var l = 0; l < g.length; l++)
        if (g[l].indexOf("BTMTIME") > -1) {
            var m = g[l].split(": ");
            2 === m.length && b.push(m[1]);
        }
        else if (g[l].indexOf("EGGUID") > -1)
        {
            var m = g[l].split(": ");
            2 === m.length && b.push(m[1]);
        }*/
    var FBT = a.firstByteTime - a.sendTime;
    var DDT = a.respAvailTime - a.firstByteTime;
    var DPT = a.respProcTime - a.respAvailTime;
    var ERP = a.respProcTime - a.sendTime;
    var browserDetails = EGRUM.getBrowserName();
    var deviceDetails = EGRUM.getDeviceDetails();
    var isNav=EGRUM.isNavSupport();
    var isRsrc=EGRUM.isRsrcSupport();
    var OSDetails = EGRUM.getOSDetails();
    var nAgt= navigator.userAgent;
    //var strCookies = document.cookie;
    var referrer = document.referrer;
    referrer = referrer.split('?')[0];
	var sid = EGRUM.getCookieVal('JSESSIONID');
   // var cookiearray = strCookies.split(';');
    /*var sid = "";
    for(var i=0; i<cookiearray.length; i++){
        var name = cookiearray[i].split('=')[0];
        var value = cookiearray[i].split('=')[1];
        if(name == 'JSESSIONID')
            sid = value;
    }*/
	var btmSID = '';
	if(btValues.btsid && btValues.btndid){
		btmSID = btValues.btsid +"||"+btValues.btndid;
	}
	var username = EGRUM.getUN();
	var captureConf = EGRUM.config && EGRUM.config.capture;
	if(username){
		if(!btmSID){
			username = window.encodeURIComponent(username);
			if(sid){
				btmSID = window.btoa(sid+'#|#'+username)+'||-';
			}
			else{
				btmSID = window.btoa('-#|#'+username)+'||-';
			}
		}
		else{
			var overwriteBtmUName  = captureConf && captureConf.overwriteBtmUName;
			if(typeof overwriteBtmUName !== 'undefined' && (!overwriteBtmUName || overwriteBtmUName == 'false')){
				overwriteBtmUName = false;
			}
			if(overwriteBtmUName){
				try{
					var btmSIDArr = btmSID.split('||');
					var sIDDecoded = window.atob(btmSIDArr[0]);
					var sIDArr = sIDDecoded.split('#|#');
					var btmUN = sIDArr[1];
					if(!btmUN || btmUN == '-'){
						btmSID = window.btoa(sIDArr[0]+'#|#'+username)+'||'+btmSIDArr[1];
					}
				}
				catch(err){}
			}
		}
	}
	sid = btmSID || sid;
	var netInfo = EGRUM.netInfo();
    var url = a.url;
    var path = location.pathname;
    if(url.indexOf("http://") == -1 || url.indexOf("https://") == -1)
    {
        try
        {
            url = EGRUM.findXHRURL(document.location.href, url);
        }
        catch (err)
        {
            EGRUM.dprint("Error in getting AJAX absolute URL.");
        }
    }
	if(EGRUM.isExcludeURL(url,true) || !EGRUM.isIncludeURL(url)){
		return;
	}
	var pageName = a.pageName || '';
	var isAsy = a.asynchronous ;
	var reqMethod = a.method || '';
	var metaObj = {method:a.method};
	var metaStr ="";
    for (var key in metaObj) {
        if (metaObj.hasOwnProperty(key)){ 
            metaStr +=  key+"="+metaObj[key]+",";
        }
    }
	metaStr = metaStr.slice(0, -1);
	metaStr ="";
	var captureConf = EGRUM.config && EGRUM.config.capture;
	var ajaxCorrelationFlag  = captureConf && captureConf.ajaxCorrelation;
	if(typeof ajaxCorrelationFlag !== 'undefined' && (!ajaxCorrelationFlag || ajaxCorrelationFlag == 'false')){
		ajaxCorrelationFlag = false;
	}
	var rt;
	var ajaxNtMeasure;
	if(ajaxCorrelationFlag){
		var rsrcXhrArr = EGRUM.getRsrcByTimeURL(a.offset, FBT, url);
	
		var xhrRsrcTime;
		if(rsrcXhrArr.length > 0){
			if(rsrcXhrArr.length === 1){
				xhrRsrcTime = rsrcXhrArr[0];
			}
			else if(btValues.btgd){
				xhrRsrcTime = EGRUM.getRsrcByBtGUID(btValues.btgd, btValues.btno, rsrcXhrArr);
			}
			if(xhrRsrcTime){
				rsrcXhrArr = [xhrRsrcTime];
			}
			var rsrcTimes = EGRUM.computeRT(rsrcXhrArr);
			if(rsrcTimes.rsrc && rsrcTimes.rsrc.length > 0){
				rt = rsrcTimes;
			}
		}
		if(xhrRsrcTime){
			var formatType = EGRUM.getFormatType(xhrRsrcTime);
			if(formatType === "1"){
				ajaxNtMeasure = EGRUM.computeNT(xhrRsrcTime);
				ajaxNtMeasure["prt"] = DPT;
				ajaxNtMeasure["fet"] = ajaxNtMeasure["fet"] + DPT; 
				ajaxNtMeasure["plt"] = ajaxNtMeasure["plt"] + DPT;
			}
		}
	}

    var beaconUrl = EGRUM["beacon-url"];
    beaconUrl = beaconUrl + "/rumcollector/rdr";
    var isBeaconUrl=EGRUM.isBeaconUrl(url);
    if(removeSpace(beaconUrl).length !=0 && !isBeaconUrl){
        var serviceName = EGRUM["site"];
        var ajaxMes = "";
		var ajaxMesOld = "fbt="+FBT+",ddt="+DDT+",dpt="+DPT+",plt="+ERP;
		if(ajaxNtMeasure){
			for ( var key in ajaxNtMeasure ) {
				ajaxMes += "," + encodeURIComponent(key) + "=" + ajaxNtMeasure[key];
			}
			if(ajaxMes)
				ajaxMes = ajaxMes.substring(1);
		} else{
			ajaxMes = ajaxMesOld;
		}
        if(EGRUM.isJSONSupport()){
            var params = {"am":ajaxMes,"amold":ajaxMesOld,"aju":url,"isaj":true,"bdt":browserDetails, "sid":sid,"osd":OSDetails,"dvdt":deviceDetails,"srn":serviceName, "agt":nAgt,"ref":referrer,"erc":"","err":"","isNav":isNav,"isRsrc":isRsrc,"rgd":rumAjaxGUID,"rpgd":rumParentGUID,"rbgd":rumBaseGUID,"btgd":btValues.btgd,"btno":btValues.btno,"btet":btValues.btet, "nwDownlink":netInfo.downlink, "nwEffectiveType": netInfo.effectiveType, "nwRTT":netInfo.rtt, "status":d,"meta":metaStr,"pgnm":pageName,"rmd":reqMethod,"isAsy":isAsy};
			if(rt){
				params["rt"] = rt;
			}
			//beaconUrl = beaconUrl +"?q="+ JSON.stringify(params);
			EGRUM.dprint("beaconUrl : " + beaconUrl);
            if (beaconUrl) {
                var xhr = new XMLHttpRequest();
                var paramStr = JSON.stringify(params);
                if (!window.XMLHttpRequest)
                    xhr = new ActiveXObject("Microsoft.XMLHTTP");
                xhr.open("POST", beaconUrl, true);
                //xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                //xhr.send("q=" + paramStr);
				xhr.setRequestHeader("Content-type", "text/plain; charset=UTF-8");
                xhr.send(paramStr);
            }
        }else{
            var params = "am="+encodeURIComponent(ajaxMes)+"&aju="+encodeURIComponent(url)+"&isaj=true&bdt="+encodeURIComponent(browserDetails)+"&sid="+encodeURIComponent(sid)+"&osd="+encodeURIComponent(OSDetails)+"&dvdt="+encodeURIComponent(deviceDetails)+"&srn="+encodeURIComponent(serviceName)+"&agt="+encodeURIComponent(nAgt)+"&ref="+encodeURIComponent(referrer)+"&erc=&err="+"&isNav="+isNav+"&isRsrc="+isRsrc+"&rgd="+rumAjaxGUID+"&rpgd="+rumParentGUID+"&rbgd="+rumBaseGUID+"&btgd="+btValues.btgd+"&btno="+btValues.btno+"&btet="+btValues.btet+"&nwDownlink="+netInfo.downlink+"&nwEffectiveType="+ netInfo.effectiveType+"&nwRTT="+netInfo.rtt+"&status="+d+"&meta"+metaStr+"&pgnm="+encodeURIComponent(pageName)+"&rmd="+reqMethod+"&isAsy="+isAsy;
            beaconUrl = beaconUrl +"?"+ params;
			var i = new Image;
			i.src = beaconUrl;
        }
    }
    EGRUM.dprint(beaconUrl);
};

EGRUM.getRsrcByTimeURL = function(offset, FBT, url){
	var rsrcXhrArr = [];
	if(!offset || !FBT || !url){
		return rsrcXhrArr;
	}
	var performance=EGRUM.getPerformance();
    if ("undefined" !== typeof(performance) && "undefined" !== typeof(performance.getEntriesByType)){
		var rsrcArr = performance.getEntriesByType("resource");
		var minOffset = offset;		
		var maxOffset = offset + FBT;		
		for (var i = 0; i < rsrcArr.length; i++) {
			var fetchStart = rsrcArr[i]['fetchStart'];
			var rsrcURL = rsrcArr[i]['name'];
			var rsrcURLDecoded = decodeURI(rsrcURL);
			if(fetchStart > minOffset && fetchStart < maxOffset && (url == rsrcURL || url == rsrcURLDecoded)){
				rsrcXhrArr.push(rsrcArr[i]);
			}
		}
	}
	return rsrcXhrArr;
}

 EGRUM.getRsrcByBtGUID = function(btgd, nodeOrder, rsrcXhrArr){
	var matchedRsrcTiming;
	if(!btgd || !nodeOrder || !rsrcXhrArr){
		return matchedRsrcTiming;
	} 
	for(var i = 0; i < rsrcXhrArr.length; i++){
		var rsrcObj = rsrcXhrArr[i];
		var serverTiming = rsrcObj['serverTiming'];
		var isMatched = false;
		if(serverTiming){
			for(var j = 0; j < serverTiming.length; j++){
				var stObj = serverTiming[j];
				var name = stObj['name'];
				if(name && name === 'eg-btm-guid'){
					var rtBTMGUID = stObj['description'];
					if(rtBTMGUID && rtBTMGUID === (btgd+'#~#'+nodeOrder)){
						isMatched = true;
						break;
					}
				}
			}
		}
		if(isMatched){
			matchedRsrcTiming = rsrcObj;
			break;
		}
	}
	return matchedRsrcTiming;
 }

/**
 * @description Checks the browser is JSON supported or not.
 * 
 * @returns {boolean} JSON Supports or not
 *  - true - Browser supports JSON
 *  - false - Browser NOT supports JSON
 */
EGRUM.isJSONSupport=function(){
    if (typeof JSON === 'object' && typeof JSON.parse === 'function' && typeof JSON.stringify === 'function') {
        return true;
    }
    return false;
}

/**
 * @description To check the URL is secure or not.
 * 
 * @returns {boolean} Secure or not
 *  - true - URL is secure(https).
 *  - false - URL is NOT secure(http).
 */
EGRUM.isSecureURL = function(url){
	var result = false;
	var isHttps = String(url) || "";
	isHttps = isHttps.indexOf("https");
	
	if(isHttps > -1){
		result = true;
	}
	return result;
}

/**
 * @description  Process any commands in the queue.
 * The command queue is used to store calls to the API before the full script
 * has been loaded.
 */
EGRUM.processQ = function() {
    var len = EGRUM.q.length;
    for ( var i = 0; i < len; i++ ) {
        var aParams = EGRUM.q[i];
        var cmd = aParams[0];
        if ( "mark" === cmd ) {
            EGRUM.mark(aParams[1], aParams[2]);
        }
        else if ( "measure" === cmd ) {
            EGRUM.measure(aParams[1], aParams[2], aParams[3]);
        }
        else if ( "done" === cmd ) {
        }
    }
};

EGRUM.computeNT = function(rawTimeObj){
	var startTime = parseInt(rawTimeObj["startTime"]),
		redirectStart = parseInt(rawTimeObj["redirectStart"]),
		redirectEnd = parseInt(rawTimeObj["redirectEnd"]),
		fetchStart = parseInt(rawTimeObj["fetchStart"]),
		domainLookupStart = parseInt(rawTimeObj["domainLookupStart"]),
		domainLookupEnd = parseInt(rawTimeObj["domainLookupEnd"]),
		connectStart = parseInt(rawTimeObj["connectStart"]),
		secureConnectionStart = parseInt(rawTimeObj["secureConnectionStart"]),
		secureConnectionEnd = 0,
		connectEnd = parseInt(rawTimeObj["connectEnd"]),
		requestStart = parseInt(rawTimeObj["requestStart"]),
		responseStart = parseInt(rawTimeObj["responseStart"]),
		responseEnd = parseInt(rawTimeObj["responseEnd"]),
		reqURL = rawTimeObj["name"],
		entryType =  rawTimeObj["entryType"]; // navigation or resource

	
	if( connectEnd > requestStart) connectEnd = requestStart;

	var isSecure = EGRUM.isSecureURL(reqURL);
	if(!isSecure || isNaN(secureConnectionStart) || secureConnectionStart == 0) {
		secureConnectionStart = 0;
		secureConnectionEnd = 0;
	} else {
		if(secureConnectionStart < connectStart || secureConnectionStart > connectEnd){
			secureConnectionStart = 0;
			secureConnectionEnd = 0;
		}
		else{
			secureConnectionEnd = connectEnd;
			connectEnd = secureConnectionStart;
		}
	}

	var	plt = 0, bwait = 0,
		rdir = redirectEnd - redirectStart,
		appc = domainLookupStart - fetchStart,
		dlt = domainLookupEnd - domainLookupStart,
		tct = connectEnd - connectStart,
		ssl = secureConnectionEnd - secureConnectionStart,
		rat = responseStart - requestStart,
		ddt = responseEnd - responseStart,
		dpt = 0,
		drt = ddt + dpt,
		prt = 0,
		fbt = responseStart - startTime,
		sct = dlt + tct + ssl,
		fet = drt + prt;
		
	if(entryType === "resource"){
		plt =  responseEnd - startTime;
	}
		
	var bwBeforeConnect = connectStart- domainLookupEnd;
	var bwAfterConnect = requestStart - connectEnd;

	if(redirectStart && redirectEnd) {
		var bwBeforeRedirct = redirectStart- startTime;
		var bwAfterRedirct = fetchStart - redirectEnd;
		bwait = bwBeforeRedirct + bwAfterRedirct + bwBeforeConnect + bwAfterConnect;

	} else {
		var bwWithoutRdir = fetchStart - startTime;
		bwait = bwWithoutRdir + bwBeforeConnect + bwAfterConnect;
	}

	return {plt:plt, bwait:bwait, rdir:rdir, appc:appc, dlt:dlt, tct:tct, ssl:ssl, rat:rat, drt:drt, ddt:ddt, dpt:dpt, prt:prt, sct:sct, fbt:fbt, fet: fet};
}

/**
 * @description Marks the Nav and Non-Nav Timing Events  
 */ 
EGRUM.mark = function(markName, markTime) {
    EGRUM.dprint("EGRUM.mark: " + markName + ", " + markTime);

    if ( ! markName) {
        EGRUM.dprint("Error: markName is undefined in EGRUM.mark.");
        return;
    }

    EGRUM.marks[markName] = parseInt(markTime || new Date().getTime());

    if ( EGRUM.bPostMessage ) {
        window.postMessage("EGRUM:mark:" + markName + ":" + markTime, EGRUM.targetOrigin);
    }

    // Special marks that we look for:
    if ("navtiming" === markName)
    {
        EGRUM.measures = {};
        EGRUM.measure("plt", "starttime", "loadEventEnd");
        EGRUM.measure("fbt", "starttime", "responseStart");
        EGRUM.measure("sct", "starttime", "requestStart");
        EGRUM.measure("rat", "requestStart", "responseStart");
        EGRUM.measure("fet", "responseStart", "loadEventEnd");
        EGRUM.measure("drt", "responseStart", "domContentLoadedEventStart");
        EGRUM.measure("ddt", "responseStart", "responseEnd");
        EGRUM.measure("dpt", "responseEnd", "domContentLoadedEventStart");
        EGRUM.measure("prt", "domContentLoadedEventStart", "loadEventEnd");
        EGRUM.measure("dlt", "domainLookupStart", "domainLookupEnd");
        EGRUM.measure("tct", "connectStart", "connectEnd");
		EGRUM.measure("ssl", "secureConnectionStart", "secureConnectionEnd");
		EGRUM.measure("appc", "fetchStart", "domainLookupStart");
		EGRUM.measure("rdir", "redirectStart", "redirectEnd");

    }
    else
    {
        if ( "firstbyte" === markName ) {
            EGRUM.measure("fbt", "starttime", "firstbyte");
        }
        else if ( "onload" === markName ) {
            EGRUM.measure("fet", "firstbyte", "onload");
        }
        else if ("domContent" === markName)
        {
            EGRUM.measure("drt", "firstbyte", "domContent");
        }
        else if ( "done" === markName ) {
            EGRUM.measure("plt", "starttime", "done");
	    EGRUM.measure("prt", "domContent", "done");
        }
    }
};

/**
 * @description Measure an episode. It will measure the timings for marked timing events
 */
EGRUM.measure = function(episodeName, startNameOrTime, endNameOrTime) {
    try
    {
        EGRUM.dprint("EGRUM.measure: " + episodeName + ", " + startNameOrTime + ", " + endNameOrTime);

        if ( ! episodeName) {
            EGRUM.dprint("Error: episodeName is undefined in EGRUM.measure.");
            return;
        }
        var startEpochTime;
        if ( "undefined" === typeof(startNameOrTime) ) {
            if ( "number" === typeof(EGRUM.marks[episodeName]) ) {
                // If no startName is specified, then use the episodeName as the
				// start mark.
                startEpochTime = EGRUM.marks[episodeName];
            }
            else {
                // Create a "measure" that is this exact point in time?
                startEpochTime = new Date().getTime();
            }
        }
        else if ( "number" === typeof(EGRUM.marks[startNameOrTime]) ) {
            // If a mark with this name exists, use that.
            startEpochTime = EGRUM.marks[startNameOrTime];
        }
        else if ( "number" === typeof(startNameOrTime) ) {
            // Assume a specific epoch time is provided.
            startEpochTime = startNameOrTime;
        }
        else {
            EGRUM.dprint("Error: unexpected startNameOrTime in EGRUM.measure: " + startNameOrTime);
            return;
        }

        var endEpochTime;
        if ( "undefined" === typeof(endNameOrTime) ) {
            endEpochTime = new Date().getTime();
        }
        else if ( "number" === typeof(EGRUM.marks[endNameOrTime]) ) {
            // If a mark with this name exists, use that.
            endEpochTime = EGRUM.marks[endNameOrTime];
        }
        else if ( "number" === typeof(endNameOrTime) ) {
            endEpochTime = endNameOrTime;
        }
        else {
            EGRUM.dprint("Error: unexpected endNameOrTime in EGRUM.measure: " + endNameOrTime);
            return;
        }

        EGRUM.starts[episodeName] = parseInt(startEpochTime);
		var diff = Math.round(endEpochTime - startEpochTime);
        EGRUM.measures[episodeName] =  diff < 0 ? 0 : diff;
        if ( EGRUM.bPostMessage ) {
            window.postMessage("EGRUM:measure:" + episodeName + ":" + startEpochTime + ":" + endEpochTime, EGRUM.targetOrigin);
        }
    }
    catch (err)
    {
        EGRUM.dprint("Error in Measures "+ err);
    }
};

/**
 * @description Checks whether beacon send or not. If not send, it will trigger to send.
 */
EGRUM.postSendBeacon = function(){
	var isNavSupport = EGRUM.isNavSupport();
	var domLoadState = document.readyState;
	if(domLoadState === "complete" && isNavSupport){		
		setTimeout(function(){
			if(!EGRUM.bDone){
				EGRUM.sendBeacon();
			}
		}, 1000);
	}
}

/**
 * @description In the case of Ajax or post-onload EGRUM, call done to signal the end of EGRUM.
 *  
 */
EGRUM.done = function(callback) {
    EGRUM.bDone = true;


    EGRUM.mark("done");

    if ( EGRUM.autorun ) {
        EGRUM.sendBeacon();
    }

    if ( EGRUM.bPostMessage ) {
        window.postMessage("EGRUM:done", EGRUM.targetOrigin);
    }

    if ( "function" === typeof(callback) ) {
        callback();
    }
};

/**
 * @description Return an object of mark names and their corresponding times.
 * 
 * @returns {object} maked timings
 */ 
EGRUM.getMarks = function() {
    return EGRUM.marks;
};

/**
 * @description Return an object of episode names and their corresponding durations.
 * 
 * @returns {Object} Computed measures
 */
EGRUM.getMeasures = function() {
    return EGRUM.measures;
};

/**
 * @description Return an object of episode names and their corresponding durations.
 * 
 * @returns {Object} AjaxMeasures
 */
EGRUM.getAjaxMeasures = function() {
    return EGRUM.AjaxMeasures;
};

/**
 * @description Return an object of episode names and their corresponding start times.
 * This is needed so that we can determine the start and end time of a duration.
 * 
 * @return {number} StartTime marked by the code snippet or browser API
 */
EGRUM.getStarts = function() {
    return EGRUM.starts;
};

/**
 * @description Calculate the BrowserWait Timing using Navigation API metrics. 
 */
EGRUM.measureBWait = function(){
	 var perform = EGRUM.getPerformance();
    if ("undefined" != typeof(perform) && "undefined" != typeof(perform.timing))
    {
		if ("undefined" != typeof(perform.timing["requestStart"]))
        {
			var timing = perform.timing;
			var navStart = timing["navigationStart"];
			var rdirStart = timing["redirectStart"];
			var rdirEnd = timing["redirectEnd"];
			var fetchStart = timing["fetchStart"];
			var dnsEnd = timing["domainLookupEnd"];
			var connectStart = timing["connectStart"];
			var connectEnd = timing["connectEnd"];
			var requestStart = timing["requestStart"];
			// Issue in chrome browser 78.0.3904.108
			if( connectEnd > requestStart) connectEnd = requestStart;
			
			var bwBeforeRedirct = 0;
			var bwAfterRedirct = 0;

			var bwBeforeConnect = parseInt(connectStart) - parseInt(dnsEnd);
			var bwAfterConnect = requestStart - connectEnd;
			/*console.log('bwBeforeConnect : '+bwBeforeConnect);
			console.log('bwAfterConnect : '+bwAfterConnect);*/
			
			var bwWithoutRdir = 0;

			var browserWait = 0;

			if(rdirStart && rdirEnd) {
				bwBeforeRedirct = parseInt(rdirStart) - parseInt(navStart);
				bwAfterRedirct = parseInt(fetchStart) - parseInt(rdirEnd);
				/*console.log('bwBeforeRedirct : '+bwBeforeRedirct);
				console.log('bwAfterRedirct : '+bwAfterRedirct);*/
				browserWait = bwBeforeRedirct + bwAfterRedirct + bwBeforeConnect + bwAfterConnect;

			} else {
				bwWithoutRdir = parseInt(fetchStart) - parseInt(navStart);
				//console.log('bwWithoutRdir : '+bwWithoutRdir);
				browserWait = bwWithoutRdir + bwBeforeConnect + bwAfterConnect;
			}
			EGRUM.measures["bwait"] = browserWait;
		}
	}
}

/** 
 * @description Construct a querystring of episodic time measurements and send it to the
 * specified URL.
 * url The URL to which to send the beacon request.
 * This is the full path including filename, but without querystring params.
 * Example: "http://yourdomain.com/gen204"
 * A best practice is to return a 204 "No Content" response.
 * If not specified then EGRUM.beaconUrl is used.
 *
 * params - An object of key|value pairs that are added to the URL's
 * querystring.
 * Example: { "pageType": "login", "dataCenter": "Wash DC" }
 * That example would add this to the querystring:
 * &pageType=login&dataCenter=Wash%20DC
 * 
 */
EGRUM.sendBeacon = function(url, params) {

    EGRUM.dprint("sendbeacon called");
    url = url || EGRUM.beaconUrl;
    var perform = EGRUM.getPerformance();
    if ("undefined" != typeof(perform) && "undefined" != typeof(perform.timing))
    {
        if ("undefined" != typeof(perform.timing["requestStart"]))
        {
			var connectEndPerf = perform.timing["connectEnd"];
			var requestStartPerf = perform.timing["requestStart"];
			// Issue in chrome browser 78.0.3904.108
			if(connectEndPerf > requestStartPerf) connectEndPerf = requestStartPerf;

            EGRUM.mark("requestStart",perform.timing["requestStart"]);
            EGRUM.mark("responseStart",perform.timing["responseStart"]);
            EGRUM.mark("responseEnd",perform.timing["responseEnd"]);
            EGRUM.mark("domContentLoadedEventStart",perform.timing["domContentLoadedEventStart"]);
            EGRUM.mark("loadEventEnd",perform.timing["loadEventEnd"]);
            EGRUM.mark("domainLookupStart",perform.timing["domainLookupStart"]);
            EGRUM.mark("domainLookupEnd",perform.timing["domainLookupEnd"]);
            EGRUM.mark("connectStart",perform.timing["connectStart"]);
			/*
			 * If secureConnectionStart is zero or undefined than for measuring the SSL time
			 * we are marking secureConnectionStart and secureConnectionEnd as connectEnd, then ssl will be zero.
			 *
			 * else secureConnectionStart is greater than zero than for measuring the SSL time
			 * we are marking secureConnectionStart as secureConnectionStart and secureConnectionEnd as connectEnd.
			 */
			 var isHttps = String(document.URL) || "";
			 isHttps = isHttps.indexOf("https");
			if(perform.timing["secureConnectionStart"] == 0 || "undefined" == typeof(perform.timing["secureConnectionStart"]) || isHttps <= -1) {
				EGRUM.mark("secureConnectionStart", connectEndPerf);
				EGRUM.mark("secureConnectionEnd", connectEndPerf);
				EGRUM.mark("connectEnd",connectEndPerf);
			} else {
				var sslStart = parseInt(perform.timing["secureConnectionStart"]);
				var connectStart = parseInt(perform.timing["connectStart"]);
				if(sslStart < connectStart || sslStart > connectEndPerf){
					EGRUM.mark("secureConnectionStart", connectStart);
					EGRUM.mark("secureConnectionEnd", connectStart);
					EGRUM.mark("connectEnd", connectEndPerf);
				}
				else{
					EGRUM.mark("secureConnectionStart", perform.timing["secureConnectionStart"]);
					EGRUM.mark("secureConnectionEnd", connectEndPerf);
					EGRUM.mark("connectEnd", perform.timing["secureConnectionStart"]);
				}
			}
			EGRUM.mark("fetchStart",perform.timing["fetchStart"]);
			EGRUM.mark("redirectStart",perform.timing["redirectStart"]);
			EGRUM.mark("redirectEnd",perform.timing["redirectEnd"]);
            EGRUM.mark("navtiming");
			EGRUM.measureBWait();
        }
    }
    var measures = EGRUM.getMeasures();
    var browserDetails = EGRUM.getBrowserName();
    var isNav=EGRUM.isNavSupport();
    if(isNav){
    	measures['sct'] = measures['dlt'] + measures['tct'] + measures['ssl'];
    }
    var isRsrc=EGRUM.isRsrcSupport();
    var deviceDetails = EGRUM.getDeviceDetails();
    var OSDetails = EGRUM.getOSDetails();
    var pageUrl = document.URL;
	if(EGRUM.isExcludeURL(pageUrl,false) || !EGRUM.isIncludeURL(pageUrl)){
		return;
	}
    //var strCookies = document.cookie;
    var nAgt= navigator.userAgent;
    var referrer = document.referrer;
    referrer = referrer.split('?')[0];
    //var cookiearray = strCookies.split(';');
    var errorCount = EGRUM.error.length;
    var errorMsg = "";
    for (var i = 0;i<errorCount;i++ )
    {
        var error=EGRUM.error[i].toString();
        if((errorMsg.length+error.length+3) < 2000 ) {
            errorMsg = errorMsg + "[" + error + "],";
        }
        else{
            break;
        }
    }
    if(errorMsg.lastIndexOf(',') == (errorMsg.length -1))
        errorMsg = errorMsg.substring(0,errorMsg.length-1);
    var iFrame = false;
    if (top == window)
    {
        iFrame = "false";
    }
    else
    {
        iFrame = "true";
    }
	var sid = EGRUM.getCookieVal('JSESSIONID');
	var btValues = EGRUM.getBTMInfo();
	if(!btValues.btgd){
    var rumBtmGuidCookie = EGRUM.getCookieVal(rumBtmCookieKey);
		btValues = EGRUM.parseBtInfo(rumBtmGuidCookie);
	}
	var btmSID = '';
	if(btValues.btsid && btValues.btndid){
		btmSID = btValues.btsid +"||"+btValues.btndid;
	}
	var username = EGRUM.getUN();
	var captureConf = EGRUM.config && EGRUM.config.capture;
	if(username){
		if(!btmSID){
			username = window.encodeURIComponent(username);
			if(sid){
				btmSID = window.btoa(sid+'#|#'+username)+'||-';
			}
			else{
				btmSID = window.btoa('-#|#'+username)+'||-';
			}
		}
		else{
			var overwriteBtmUName  = captureConf && captureConf.overwriteBtmUName;
			if(typeof overwriteBtmUName !== 'undefined' && (!overwriteBtmUName || overwriteBtmUName == 'false')){
				overwriteBtmUName = false;
			}
			if(overwriteBtmUName){
				try{
					var btmSIDArr = btmSID.split('||');
					var sIDDecoded = window.atob(btmSIDArr[0]);
					var sIDArr = sIDDecoded.split('#|#');
					var btmUN = sIDArr[1];
					if(!btmUN || btmUN == '-'){
						btmSID = window.btoa(sIDArr[0]+'#|#'+username)+'||'+btmSIDArr[1];
					}
				}
				catch(err){}
			}
		}
	}
	sid = btmSID || sid;
	var netInfo = EGRUM.netInfo();
	// Here AppCache, RedirectionTime, Browser Wait Time values are Hardcoded as -5
	//measures["appc"]=-5;
	//measures["rdir"]=-5;
	//measures["bwait"]=-5;
    /* var sid = "";
	for(var i=0; i<cookiearray.length; i++){
        var name = cookiearray[i].split('=')[0];
        var value = cookiearray[i].split('=')[1];
        if(name == 'JSESSIONID')
            sid = value;
    }*/
    var sTimes = "";
    for ( var key in measures ) {
    	if (EGRUM.isJSONSupport()) {
			sTimes += "," + key + ":" + measures[key];
		} else {
			sTimes += "," + encodeURIComponent(key) + ":" + measures[key];
		}
        EGRUM.dprint(key+"    "+measures[key]);
    }
    if(sTimes)
        sTimes = sTimes.substring(1);

    var rumGUID = EGRUM.getPageGUID();
    var rumParentGUID = EGRUM.getParentGUID();
    var rumBaseGUID = EGRUM.getBaseGUID();
	var pageName= document.title ||'';
	if(pageName.length > 100){
		pageName = pageName.substring(99);
	}
    var beaconUrl = EGRUM["beacon-url"];
    if(removeSpace(beaconUrl).length !=0 ) {
        var serviceName = EGRUM["site"];
        beaconUrl = beaconUrl + "/rumcollector/rdr";

        EGRUM.dprint(sTimes);
        if (EGRUM.isJSONSupport()) {
            var rt = EGRUM.getResourceTiming();
            var params = {
                "sid": sid,
                "prm": sTimes,
                "url": pageUrl,
                "bdt": browserDetails,
                "ifr": iFrame,
                "erc": errorCount,
                "err": errorMsg,
                "osd": OSDetails,
                "dvdt": deviceDetails,
                "agt": nAgt,
                "srn": serviceName,
                "ref": referrer,
                "rt": rt,
				"isNav":isNav,
				"isRsrc":isRsrc,
				"rgd":rumGUID,
				"rpgd":rumParentGUID,
				"rbgd":rumBaseGUID,
				"btgd":btValues.btgd,
				"btno":btValues.btno,
				"btet":btValues.btet,
				"nwDownlink":netInfo.downlink,
				"nwEffectiveType": netInfo.effectiveType,
				"nwRTT":netInfo.rtt,
				"status": EGRUM.status,
				"pgnm": pageName
            };

            var isNavDebugEnabled = window['egrum-debug-nav'] || false;
            var isRsrcDebugEnabled = window['egrum-debug-rsrc'] || false;
            if(isNavDebugEnabled){
                params.rawNav = {};
                if(perform){
                    params.rawNav = JSON.parse(JSON.stringify(perform.timing));
                }
            }
            if(isRsrcDebugEnabled){
                params.rawRsrc = {}; 
                if(perform){
                    var resourceObj = perform.getEntriesByType("resource");
                    params.rawRsrc = JSON.parse(JSON.stringify(resourceObj)); 
                }
            }

            var url = beaconUrl;
            EGRUM.dprint("beaconUrl : " + beaconUrl);
            if (url) {
                var xhr = new XMLHttpRequest();
                var paramStr = JSON.stringify(params);
                if (!window.XMLHttpRequest)
                    xhr = new ActiveXObject("Microsoft.XMLHTTP");
                xhr.open("POST", beaconUrl, true);
                //xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
				//xhr.send("q=" + paramStr);
                xhr.setRequestHeader("Content-type", "text/plain; charset=UTF-8");
                xhr.send(paramStr);
            }
        }else{
            var params = "sid="+encodeURIComponent(sid)+"&prm="+sTimes+"&url="+encodeURIComponent(pageUrl)+"&bdt="+encodeURIComponent(browserDetails)+"&ifr="+iFrame+"&erc="+errorCount+"&err="+encodeURIComponent(errorMsg)+"&osd="+encodeURIComponent(OSDetails)+"&dvdt="+encodeURIComponent(deviceDetails)+"&agt="+encodeURIComponent(nAgt)+"&srn="+encodeURIComponent(serviceName)+"&ref="+encodeURIComponent(referrer)+"&isNav="+isNav+"&isRsrc="+isRsrc+"&rgd="+rumGUID+"&rpgd="+rumParentGUID+"&rbgd="+rumBaseGUID+"&btgd="+btValues.btgd+"&btno="+btValues.btno+"&btet="+btValues.btet+"&nwDownlink="+netInfo.downlink+"&nwEffectiveType="+ netInfo.effectiveType+"&nwRTT="+netInfo.rtt+"&status="+EGRUM.status+"&pgnm="+encodeURIComponent(pageName);
            var url = beaconUrl +"?"+ params;
            EGRUM.dprint("beaconUrl : "+beaconUrl);
            if (url)
            {
                var img = new Image();
                img.src = url;
                return img.src;
            }
        }
    }
    return "";
};

/**
 * @description Get the window performance Object if avalable
 * 
 * @returns {Object} Performance , undefined - for not supported browsers
 */
EGRUM.getPerformance = function () {
    var perf = window.performance || window.mozPerformance || window.msPerformance || window.webkitPerformance;
    if ( "undefined" != typeof(perf) && "undefined" != typeof(perf.timing))
    {
        return perf;
    }
};

/**
 * @description This function is to check whether the browser supports the Navigation API or not.
 * 
 * @returns {number} Supports or Not 
 *  - 0 - Nav API Not supported
 *  - 1 - Nav API Supported
 */
EGRUM.isNavSupport=function(){
	var isNav=0;
	var perf = EGRUM.getPerformance();
	if("undefined" != typeof(perf) && "undefined" != typeof(perf.timing)){
		isNav=1;
	}
	return isNav;
};

/**
 * @description This function is to check whether the browser supports the Resource API or not.
 * 
 * @returns {number} Supports or not
 *  - 0 - Nav API Not supported
 *  - 1 - Nav API Supported
 */
EGRUM.isRsrcSupport=function(){
	var isRsrc=0;
	var perf = EGRUM.getPerformance();
	if("undefined" != typeof(perf) && "undefined" != typeof(perf.getEntriesByType)){
		isRsrc=1;
	}
	return isRsrc;
};

/**
 * @description Use various techniques to determine the time at which this page started.
 */ 
EGRUM.findStartTime = function() {
    var startTime = EGRUM.findStartWebTiming() || EGRUM.findStartGToolbar() || EGRUM.findStartCookie();
    if ( startTime ) {
        EGRUM.mark("starttime", startTime);
    }
};

/**
 * @description Find the start time from the Web Timing "performance" object.
 * 
 * @references Links
 *  - http://test.w3.org/webperf/specs/NavigationTiming/
 *  - http://blog.chromium.org/2010/07/do-you-know-how-slow-your-web-page-is.html
 * 
 * @returns {number} starttime
 */
EGRUM.findStartWebTiming = function() {
    var startTime = undefined;
    var perf = EGRUM.getPerformance();
    if ( "undefined" != typeof(perf) && "undefined" != typeof(perf.timing) && "undefined" != typeof(perf.timing["navigationStart"]) ) {
        startTime = perf.timing["navigationStart"];
        EGRUM.dprint("EGRUM.findStartWebTiming: startTime = " + startTime);
    }
    return startTime;
};

/**
 * @description Find the start time from the Google Toolbar.
 * 
 * @references Links
 *  - http://ecmanaut.blogspot.com/2010/06/google-bom-feature-ms-since-pageload.html
 * 
 * @returns {number} starttime
 */
EGRUM.findStartGToolbar = function() {
    var startTime = undefined;

    if ( "undefined" != typeof(window.external) && "undefined" != typeof(window.external.pageT) ) {
        startTime = (new Date().getTime()) - window.external.pageT;
    }
    else if ( "undefined" != typeof(window.gtbExternal) && "undefined" != typeof(window.gtbExternal.pageT) ) {
        startTime = (new Date().getTime()) - window.gtbExternal.pageT();
    }
    else if ( "undefined" != typeof(window.chrome) && "undefined" != typeof(window.chrome.csi) ) {
        startTime = (new Date().getTime()) - window.chrome.csi().pageT;
    }

    if ( startTime ) {
        EGRUM.dprint("EGRUM.findStartGToolbar: startTime = " + startTime);
    }

    return startTime;
};

/**
 * @description Find the start time based on a cookie set by EGRUM in the unload handler.
 * 
 * @returns {number} starttime
 */ 
EGRUM.findStartCookie = function() {
    var aCookies = document.cookie.split(' ');
    for ( var i = 0; i < aCookies.length; i++ ) {
        if ( 0 === aCookies[i].indexOf("EGRUM=") ) {
            var aSubCookies = aCookies[i].substring("EGRUM=".length).split('&');
            var startTime, bReferrerMatch;
            for ( var j = 0; j < aSubCookies.length; j++ ) {
                if ( 0 === aSubCookies[j].indexOf("s=") ) {
                    startTime = aSubCookies[j].substring(2);
                }else if ( 0 === aSubCookies[j].indexOf("r=") ) {
                    var startPage = aSubCookies[j].substring(2);
                    bReferrerMatch = ( encodeURIComponent(document.referrer) == startPage );
                }
                else if (0 === aSubCookies[j].indexOf("BTMTIME="))
                {
                    var btmTime = aSubCookies[j].substring(2);
                }
            }
            if (startTime ) {
                EGRUM.dprint("EGRUM.findStartCookie: startTime = " + startTime);
                return startTime;
            }
        }
    }
    return undefined;
};

/**
 * @description Find the in which below devices the browser is running.
 *  - iphone
 *  - android
 *  - windowsPhone
 *  - androidTablet
 *  - ipad
 * 
 * @returns {string} Device Name
 *  - Tablet
 *  - Mobile
 *  - Desktop
 */
EGRUM.getDeviceDetails = function() {
    var nAgt= navigator.userAgent;
    var iphone = false;
    var android = false;
    var windowsPhone = false;
    var androidTablet = false;
    var ipad = false;
    if((nAgt.indexOf("Mobile")) != -1)
    {
        iphone = true;
    }
    if((nAgt.indexOf("Android")) != -1)
    {
        android = true;
        if((nAgt.indexOf("Mobile")) == -1){ // If there is no ''mobile' in
											// user-agent (Android have that on
											// their phones, but not tablets)
            androidTablet = true;
        }
    }
    if((nAgt.indexOf("Phone")) != -1)
    {
        windowsPhone = true;
    }
    if((nAgt.indexOf("iPad")) != -1)
    {
        ipad = true;
    }

    if(androidTablet || ipad){ // If it's a tablet (iPad / Android)
        return 'Tablet';
    }
    else if((iphone && !ipad) || (android && !androidTablet) || windowsPhone){ // If
																				// it's
																				// a
																				// phone
																				// and
																				// NOT
																				// a
																				// tablet
        return "Mobile";
    }
    else{ // If it's not a mobile device
        return 'Desktop';
    }
};

/**
 * @description Find the OS details using User Agent
 * 
 * @returns {string} OS Name
 *  - iOS - iPad
 *  - iOS - iPhone
 *  - Android
 *  - Windows
 *  - Mac
 */
EGRUM.getOSDetails = function()
{
    var navPlatform = navigator.userAgent;
    if((navPlatform.indexOf("iPad")) != -1)
    {
        return 'iOS - iPad';
    }
    else if((navPlatform.indexOf("iPhone")) != -1 || (navPlatform.indexOf("iPod")) != -1)
    {
        return 'iOS - iPhone';
    }
    else if ((navPlatform.indexOf("Android")) != -1)
    {
        return 'Android';
    }
    else if ((navPlatform.indexOf("win")) != -1 || (navPlatform.indexOf("Win")) != -1 || (navPlatform.indexOf("Windows")) != -1)
    {
        return 'Windows';
    }
    else if((navPlatform.indexOf("mac")) != -1 || (navPlatform.indexOf("Mac")) != -1)
    {
        return 'Mac';
    }
	else if((navPlatform.indexOf("linux")) != -1 || (navPlatform.indexOf("Linux")) != -1)
    {
        return 'Linux';
    }
	else if((navPlatform.indexOf("unix")) != -1 || (navPlatform.indexOf("Unix")) != -1)
    {
        return 'Unix';
    }
	else
    {
        return 'Others';
    }
};

/**
 * @description Find the Browser Name with Browser Version using User Agent
 * 
 * @returns {string} BroswerName Version
 *  - Microsoft Edge
 *  - Internet Explorer
 *  - Opera
 *  - Chrome
 *  - IOS Mobile
 *  - Firefox 
 *  - Android Mobile
 *  - Safari
 *  - Other - _If nothing matches_
 */
EGRUM.getBrowserName = function()
{
    var nAgt= navigator.userAgent;
    var nVer = navigator.appVersion;
    var browserName  = navigator.appName;
    var fullVersion  = ''+parseFloat(navigator.appVersion);
    var majorVersion = parseInt(navigator.appVersion,10);
    var nameOffset,verOffset,ix;
    var isIE11=!!navigator.userAgent.match(/Trident.*rv[ :]*11\./);
    var edgeMatched=nAgt.match(/(edge)\/((\d+)?[\w\.]+)/i);
    if(edgeMatched){
        browserName = "Microsoft Edge";
        fullVersion = edgeMatched[3];
    }
    else if(isIE11){
        browserName = "Internet Explorer";
        fullVersion = "11.0";
        var ua = navigator.userAgent;
        var re  = new RegExp("Trident/.*rv:([0-9]{1,}[\.0-9]{0,})");
        if (re.exec(ua) != null)
            fullVersion = RegExp.$1 ;
    }        
    else if ((verOffset=nAgt.indexOf("Opera"))!=-1 || (verOffset=nAgt.indexOf("OPR"))!=-1)
    {
        browserName = "Opera";
        fullVersion = nAgt.substring(verOffset+6);
        if ((verOffset=nAgt.indexOf("Version"))!=-1)
            fullVersion = nAgt.substring(verOffset+8);
    }
    // In MSIE, the true version is after "MSIE" in userAgent
    else if ((verOffset=nAgt.indexOf("MSIE"))!=-1)
    {
        browserName = "Internet Explorer";
        fullVersion = nAgt.substring(verOffset+5);
    }
    // In Chrome, the true version is after "Chrome"
    else if ((verOffset=nAgt.indexOf("Chrome"))!=-1)
    {
        browserName = "Chrome";
        fullVersion = nAgt.substring(verOffset+7);
    }
    // In iPhone OS, the true version in after "iPhone OS"
    else if ((verOffset=nAgt.indexOf("iPad")) != -1 || (verOffset=nAgt.indexOf("iPhone")) != -1 || (verOffset=nAgt.indexOf("iPod")) != -1)
    {
        browserName = "iOS Mobile";
        if ((verOffset=nAgt.indexOf("Version"))!=-1)
            fullVersion = nAgt.substring(verOffset+8);
        // fullVersion =
		// nAgt.substring(nAgt.indexOf("Version")+9,nAgt.indexOf("Version")+12);
    }
    // In Firefox, the true version is after "Firefox"
    else if ((verOffset=nAgt.indexOf("Firefox"))!=-1)
    {
        browserName = "Firefox";
        fullVersion = nAgt.substring(verOffset+8);
    }
    // In Android Browser, the true version in after "Andriod"
    else if ((verOffset=nAgt.indexOf("Android"))!=-1)
    {
        browserName = "Android Mobile";
        fullVersion = nAgt.substring(verOffset+8);
    }
    // In Safari, the true version is after "Safari" or after "Version"
    else if ((verOffset=nAgt.indexOf("Safari"))!=-1)
    {
        browserName = "Safari";
        fullVersion = nAgt.substring(verOffset+7);
        if ((verOffset=nAgt.indexOf("Version"))!=-1)
            fullVersion = nAgt.substring(verOffset+8);
    }
    // In most other browsers, "name/version" is at the end of userAgent
    else if ((nameOffset=nAgt.lastIndexOf(' ')+1) < (verOffset=nAgt.lastIndexOf('/')))
    {
        browserName = "Others";// nAgt.substring(nameOffset,verOffset);
        /*
		 * fullVersion = nAgt.substring(verOffset+1); if
		 * (browserName.toLowerCase()==browserName.toUpperCase()) { browserName =
		 * navigator.appName; }
		 */
    }
    if ((ix=fullVersion.indexOf(";"))!=-1)
        fullVersion=fullVersion.substring(0,ix);
    if ((ix=fullVersion.indexOf(" "))!=-1)
        fullVersion=fullVersion.substring(0,ix);

    majorVersion = parseInt(''+fullVersion,10);
    if (isNaN(majorVersion))
    {
        fullVersion  = ''+parseFloat(navigator.appVersion);
        majorVersion = parseInt(navigator.appVersion,10);
    }
    return browserName + " " + fullVersion;
};

/**
 * @description Set a cookie when the page unloads. Consume this cookie on the next page to get a "start time".
 * Doesn't work in some browsers (Opera).
 * 
 * @param {Event} e - event
 */
 
EGRUM.beforeUnload = function(e) {
    EGRUM.beforeUnload = function () {};
    EGRUM.setCookie(document.location.href,
        document.domain, "https:" === document.location.protocol, function () {
            return document.cookie
        }, function (a) {
            document.cookie = a
        })

};

/**
 * @description Setting Cookie with Time and Current URL
 * 
 * @param {string} a - Page URL
 */
EGRUM.setCookie = function (a, b, c, f, g) {
    a = "EGRUM=s=" + Number(new Date) + "&r=" + encodeURIComponent(a);
    var l = a + ";path=/";
    c && (l += ";secure");
    if (!window.EGRUM.useStrictDomainCookies) {
        c = f();
        b = b.split(".");
        for (var k = "", p = b.length - 1; 0 <= p; p--) {
            k = "." + b[p] + k;
            g(l + ";domain=" + k);
            var r = f();
            if (r != c && 0 <= r.indexOf(a)) {
                return
            }
        }
    }
    g(l);
};

/**
 * @description In Non Nav browser, need to calc the metrics manually.
 * The domcontentLoaded Event Callback function used to mark the event.
 * 
 */
EGRUM.domContentLoaded = function () {
    if(!EGRUM.contentLoadFired)
    {
        EGRUM.mark("domContent", (new Date).getTime());
        EGRUM.contentLoadFired = true;
    }
};
/**
 * @description readystatechange event callback function.
 *  If document's readystate is complete then call the domcontentloaded function
 */
EGRUM.readyStateChange = function () {
    "complete" === document.readyState && EGRUM.domContentLoaded();
};

/**
 * @description When the page is done do final wrap-up.
 * onload Event callback function
 * 
 */
EGRUM.onload = function() {
    var perf = EGRUM.getPerformance();
    if ( "undefined" != typeof(perf) && "undefined" != typeof(perf.timing) && "undefined" != typeof(perf.timing["navigationStart"]) ) {
        setTimeout(function () {
            EGRUM.mark("onload");
            // var perform = EGRUM.getPerformance();
            if ( EGRUM.autorun ) {
                EGRUM.done();
            }
        }, 1000);
    }
    else
    {
        EGRUM.mark("onload");
        if ( EGRUM.autorun ) {
            EGRUM.done();
        }
    }
};

/**
 * @description Generic wrapper function for any event related functions.
 */
EGRUM.addEventListener = function(sType, callback, bCapture) {
    try
    {
        EGRUM.dprint("window.addEventListener  "+typeof(window.addEventListener));
        if ( "undefined" != typeof(window.attachEvent) ) {
            return window.attachEvent("on" + sType, callback);
        }
        else if ("undefined" != typeof(window.addEventListener)){
            return window.addEventListener(sType, callback, bCapture);
        }
    }
    catch (err)
    {
        EGRUM.dprint("Error in addEventListener "+ err);
    }
};

/**
 *  @description To print the log messages in the JavaScript console
 */ 
if ( "undefined" != typeof(console) && "undefined" != typeof(console.log) ) {
    /**
     * @description Print in the console
     * @param {string} msg - Log Message 
     */
    EGRUM.dprint = function(msg) {
        if(debug == true)
            console.log(msg);
    };
}
else {
    EGRUM.dprint = function(msg) { };
}
/**
 * @description To get all available cookies & split, store in Array
 * 
 * @return {Array} Array of all Document Cookies
 */
EGRUM.getCookie = function(){
	var strCookies =  cookieInfo || document.cookie;
	var cookiearray = strCookies.split(';');
	return cookiearray;
};

/**
 * @description To get the associated cookie value for a given cookie name.
 * 
 * @returns {string} CookieValue 
 *  - value - If exist
 *  - empty string - If not exist
 */
EGRUM.getCookieVal = function(cookieName){
	var cookieArray = EGRUM.getCookie();
	var cookieValue;
	for(var i=0; i<cookieArray.length; i++){
	   var cooky=cookieArray[i];
	   var eqIdx = cooky.indexOf('=');
	   if (eqIdx < 0) {
		   continue;
	   }
       var name =  removeSpace(cooky.substr(0, eqIdx));
	   var value =  removeSpace(cooky.substr(++eqIdx, cooky.length));
       if(name == cookieName) {
           cookieValue = value;
		   break;
	   }
    }
	return cookieValue || "";
};

/**
 * @description If RUM & BTM Integration enabled. Parse the BTM info from window Object.
 * if the details available in the window object itself - will not parse using cookies. 
 * 
 * @return {object} BTM Transaction Info
 *  - btgd - Business Transaction GUID
 *  - btno - Business Transaction NODE Order
 *  - btet - Business Transaction Execution Time
 *  - btsid - Business Transaction Session ID
 *  - btndid - Business Transaction Node ID
 */
EGRUM.getBTMInfo = function(){
	var btmExecTime = window['eg_btm_exe_time'];
	var btmGuid = "";
	var btmNodeOrder = "";
	var btmGuidAndNodeOrder = window['eg_btm_guid'];
	if(btmGuidAndNodeOrder){
		var nodeIndex = btmGuidAndNodeOrder.indexOf("#~#");
		if (nodeIndex > -1)
		{
			btmGuid = btmGuidAndNodeOrder.substring(0,nodeIndex);
			btmNodeOrder = btmGuidAndNodeOrder.substring(nodeIndex+3);
		}
	}
	
	var sessionID = window['eg_btm_session_id'];
	var nodeID = window['eg_btm_node_guid'];
	btmGuid = btmGuid ||"";
	btmNodeOrder = btmNodeOrder || "";
	btmExecTime = btmExecTime==0 ? 0 : ( btmExecTime || "");
	sessionID = sessionID || "";
	nodeID = nodeID || "";
	return {btgd: btmGuid, btno: btmNodeOrder, btet:btmExecTime, btsid:sessionID, btndid:nodeID};
}

/**
 * @description If RUM & BTM Integration enabled. Parse the BTM info from Browser Cookie
 * 
 * @return BTM Transaction Info
 *  - btgd - Business Transaction GUID
 *  - btno - Business Transaction NODE Order
 *  - btet - Business Transaction Execution Time
 *  - btsid - Business Transaction Session ID
 *  - btndid - Business Transaction Node ID
 */
EGRUM.parseBtInfo = function(rumBtmGuidInfo) {
	var btmExecTime;
	var btmGuid;
	var btmNodeOrder;

	var sessionID;
	var nodeID;

	if (rumBtmGuidInfo)
	{
		if(rumBtmGuidInfo.indexOf('"') === 0){
			rumBtmGuidInfo = rumBtmGuidInfo.substr(1, rumBtmGuidInfo.length-1);
		}
		if(rumBtmGuidInfo.indexOf('"') === rumBtmGuidInfo.length-1){
			rumBtmGuidInfo = rumBtmGuidInfo.substr(0, rumBtmGuidInfo.length-1);
		}
		var pipeIndex = rumBtmGuidInfo.indexOf("||");
		if(pipeIndex > -1)
		{
			var arrBtmValues = rumBtmGuidInfo.split("||");
			
			var btmGuidAndNodeOrder =arrBtmValues[0];
			var nodeIndex = btmGuidAndNodeOrder.indexOf("#~#");
			if (nodeIndex > -1)
			{
				btmGuid = btmGuidAndNodeOrder.substring(0,nodeIndex);
				btmNodeOrder = btmGuidAndNodeOrder.substring(nodeIndex+3);
			}
			btmExecTime = arrBtmValues[1];
			nodeID = arrBtmValues[2];
			sessionID = arrBtmValues[3];
		}
	}
	btmGuid = btmGuid ||"";
	btmNodeOrder = btmNodeOrder || "";
	btmExecTime = btmExecTime==0 ? 0 : ( btmExecTime || "");
	sessionID = sessionID || "";
	nodeID = nodeID || "";
	return {btgd: btmGuid, btno: btmNodeOrder, btet:btmExecTime, btsid:sessionID, btndid:nodeID};
};

/**
 * @description Set the limit for Number of Resources metrics caputured by the Browser.
 * 
 */
EGRUM.setResourceLimit = function(){
	var perf = EGRUM.getPerformance();
	if(perf){
		var supported = typeof perf.setResourceTimingBufferSize == "function";
		if (supported) {
			var resourceLimit = EGRUM["rsrc_limit"];
			perf.setResourceTimingBufferSize(resourceLimit);
		}
	}
}

/**
 * @description Collect the resource timing api metrics and store them in an object
 * 
 * @return Resource Timing Metric data as an object
 */
EGRUM.getResourceTiming=function(){
	var captureConf = EGRUM.config && EGRUM.config.capture;
	var toCaptureResource  = captureConf && captureConf.resourceDetails;
	if(typeof toCaptureResource !== 'undefined' && (!toCaptureResource || toCaptureResource == 'false')){
		return {};
	}
    var performance=EGRUM.getPerformance();
    if ( "undefined" == typeof(performance) || "undefined" == typeof(performance.getEntriesByType))
        return {};
    var rsrcArr = performance.getEntriesByType("resource");
    if(rsrcArr){
		rsrcArr.splice(0,0, performance.getEntries("navigation")[0]);	
		return EGRUM.computeRT(rsrcArr);
    }
    else{
		return {};
    }
}
EGRUM.computeRT=function(rsrcArr){
	EGRUM.resourceTypeCount={};
	EGRUM.initiatorTypeCount={};
	var pageObj=window.performance.timing;
    var originTime=pageObj.navigationStart;
    var rsrcData=[];

    for (var i = 0; i < rsrcArr.length; i++) {
        var pfmObj=rsrcArr[i];
        var formatType=EGRUM.getFormatType(pfmObj);
        var rsrcNetworkTime=[0];
        var startTime=pfmObj.startTime;
        var mdata=EGRUM.formatTypes[formatType];
        var isBeacon=EGRUM.isBeaconUrl(pfmObj.name);

		var encodedBodySize = pfmObj.encodedBodySize > -1 ? pfmObj.encodedBodySize: -1;
		var decodedBodySize = pfmObj.decodedBodySize > -1 ? pfmObj.decodedBodySize: -1;
		var transferSize = pfmObj.transferSize > -1 ? pfmObj.transferSize: -1;

		var nextHopProtocol = pfmObj.nextHopProtocol || "-";
		var workerStart = pfmObj.workerStart > -1 ? pfmObj.workerStart: -1;
		var redirectCount = pfmObj.redirectCount > -1 ? pfmObj.redirectCount: -1;
		var navType = pfmObj.type ? pfmObj.type :"-";
		var entryType = pfmObj.entryType ? pfmObj.entryType :"-";
		var duration = pfmObj.duration ? pfmObj.duration :-1;
		duration = Math.round(duration * 100) / 100;

        if(!isBeacon) {
			var sslTime = 0;
            for (var j = 1; j < mdata.length; j++) {
				var mTimeName = mdata[j];
				var timeValue = pfmObj[mTimeName];
				if(mTimeName === 'connectEnd'){
					var nxtTime = pfmObj['requestStart']; 
					// Issue in chrome browser 78.0.3904.108
					if(timeValue > nxtTime){
						timeValue = nxtTime;
					}
					var sslStart = pfmObj.secureConnectionStart;
                    if(sslStart > 0){
                        sslTime = timeValue - sslStart;
                        sslTime = Math.round(sslTime * 100) / 100;
                    }
				}
				var diff =-1;
				if(timeValue !== 0){
					diff = Math.max(-1, Math.round(timeValue - startTime));
				}
				rsrcNetworkTime.push(diff);
            }
			var serverTiming = [];
			var stObj = pfmObj.serverTiming || [];
			if(stObj){
				for(var s = 0; s < stObj.length; s++){
					serverTiming.push(stObj[s].toJSON());
				}
			}
            rsrcData.push({
                "tm": rsrcNetworkTime,
                "ofst": Math.round(pfmObj.startTime) || 0,
                "init": EGRUM.getInitiatorType(pfmObj.initiatorType, pfmObj.name),
		//"url":EGRUM.urlShortner(pfmObj.name),
                "url":pfmObj.name,
                "rsrctyp": EGRUM.getResourceType(pfmObj.name),
                "frmt": formatType,
				"ssl": sslTime,
				"enbdsize": encodedBodySize,
				"debdsize": decodedBodySize,
				"trnssize": transferSize,
				"nexthop": nextHopProtocol,
				"workerstart": workerStart,
				"rdirtcnt": redirectCount,
				"navtype": navType,
				"entrytype": entryType,
				"duration": duration,
				"serverTiming":serverTiming
            });
        }
    }
    return {"rsrc":rsrcData, "timeOrigin":originTime, "initType":"", "initTypeCount":EGRUM.initiatorTypeCount,
                "rsrcType":"", "rsrcTypeCount":EGRUM.resourceTypeCount};
};

/**
 * @description Resource Type mapped to number to reduce the beacon payload
 */
EGRUM.resourceTypes = {"other": "0", "css": "1", "script": "2", "img": "3", "svg": "4", "html": "5", "font": "6", "video":"0", "audio":"0", "document": "7"};
EGRUM.resourceTypeCount = {};
EGRUM.confConst={
    urlln:"140",
    prtclln:"10",
    hostln:"30",
    portln:"10",
    srchln:"30",
    hashln:"30",
    fileln:"20"
};
EGRUM.shortner=function (str, limit) {
    if (3 >= limit)return "...";
    str.length > limit && (str = str.substring(0, limit - 3) + "...");
    return str;
};
/**
 * @description Construct the URL from individual url segments
 * 
 * @returns {URL} - constructed URL
 */
EGRUM.urlMake=function(host, path, file, srch, hash) {
    return 0 == path.length ? (host + file + srch + hash) : (host + path.join("/") + "/" + file + srch + hash);
};
/*EGRUM.urlShortner=function(url){
    var a=EGRUM.splitXHRURL(url),
    host=EGRUM.urlShortner.host(a.protocol, a.hostname, a.port),
    search = EGRUM.shortner(a.search, this.confConst.srchln),
    hash = EGRUM.shortner(a.hash, this.confConst.hashln),
    pathArr=a.pathname.split("/");
    file=pathArr.length > 0 ? pathArr.pop():"";
    file=EGRUM.urlShortner.file(file, EGRUM.confConst.fileln);

    for(a=EGRUM.urlMake(host, pathArr, file, search, hash); a.length > EGRUM.confConst.urlln;){
        pathArr.pop();
        pathArr.push("...");
        a=EGRUM.urlMake(host, pathArr, file, search, hash);
        pathArr.pop();
    }
    return a;
};
EGRUM.urlShortner.file=function (a, b) {
    if (3 >= b)return "...";
    a.length > b && (a = a.substring(0, (b - 3) / 2) + "..." + a.substring(a.length - (b - 3) / 2, a.length));
    return a
};
EGRUM.urlShortner.host=function(protcl, hostName, port){
    protcl.length <= EGRUM.confConst.prtclln || (protcl = EGRUM.shortner(protcl, EGRUM.confConst.prtclln - 1), protcl += ":");
    hostName = EGRUM.shortner(hostName, EGRUM.confConst.hostln);
    port = EGRUM.shortner(port, EGRUM.confConst.portln);
    return 0 < port.length ? protcl + "//" + hostName + ":" + port : protcl + "//" +hostName;
};*/

/**
 * @description To get the type of resource by parsing the URL.
 * 
 * @return {number} Resource Type mapped name
 *  
 */
EGRUM.getResourceType=function(url){
    var fontExt=["ttf", "otf", "woff", "woff2", "eot", "cff", "afm", "lwfn", "ffil", "fon", "pfm", "pfb", "std", "pro", "xsf"];

    var imgExt=["jpg", "jpeg", "jpe", "jif", "jfif", "jfi", "jp2", "j2k", "jpf", "jpx", "jpm", "jxr",
                "hdp", "wdp", "mj2", "webp", "gif", "png", "apng", "mng", "tiff", "tif", "xbm", "bmp","dib"];

    var svgExt=["svg", "svgz"];

    var mmVideo=["mpg", "mpeg", "mpeg2", "avi", "wmv", "mov", "rm", "ram", "swf", "flv", "ogg", "webm", "mp4", "ts"];

    var mmAudio=["mid", "midi", "rm", "ram", "wma", "aac", "wav", "ogg", "mp3", "mp4"];

    var htmlExt=["html", "htm", "shtml", "xhtml"];

    var scriptExt=["js"];
    var cssExt=["css"];

    var pathName=EGRUM.splitXHRURL(url).pathname;
    var extension=pathName.split('\\').pop().split('/').pop().split('.').pop();
	  extension =  removeSpace(extension);
    var type=EGRUM.resourceTypes[extension];

    if(!type){ type = htmlExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["html"] : ""; }
    if(!type){ type = cssExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["css"] : ""; }
    if(!type){ type = scriptExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["script"] : ""; }
    if(!type){ type = fontExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["font"] : ""; }
    if(!type){ type = imgExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["img"] : ""; }
    if(!type){ type = svgExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["svg"] : ""; }
    if(!type){ type = mmVideo.indexOf(extension) >=0 ? EGRUM.resourceTypes["video"] : ""; }
    if(!type){ type = mmAudio.indexOf(extension) >=0 ? EGRUM.resourceTypes["audio"] : ""; }
    if(!type){ type=EGRUM.resourceTypes["other"];}

    EGRUM.resourceTypeCount[type] = ( EGRUM.resourceTypeCount[type] ? EGRUM.resourceTypeCount[type] : 0 ) + 1;
    return type;
};

/**
 * @description Initiator Type Mapping with number to reduce beacon payload
 */
EGRUM.initiatorTypes={"other":"0", "link":"1", "css":"2", "script":"3", "img":"4", "object":"5", "frame":"6",
    "iframe":"7", "xmlhttprequest":"8", "embed":"9", "audio":"0", "video":"0", "svg":"12", "navigation":"13", "input":"14", "beacon":"15", "fetch":"16"};
EGRUM.initiatorTypeCount={};

/**
 * @description Get the mapped number for Initiator Type
 * 
 * @param {string} initType - Initiator Type
 * @param {URL} url - Resource URL
 * 
 * @return {number} - Initiator Type Number
 */
EGRUM.getInitiatorType=function(initType, url){
    var num=EGRUM.initiatorTypes[initType];
	if(!num) num = "0";
    EGRUM.initiatorTypeCount[num] = (EGRUM.initiatorTypeCount[num]?EGRUM.initiatorTypeCount[num]:0) + 1;
    return num;
};

/**
 * @description - Two Formats of Metrics
 *  - 1 - All Metrics will be there.
 *  - 2 - For CORS Resource few metrics will not be available
 */
EGRUM.formatTypes={"1":["startTime", "redirectStart", "redirectEnd", "fetchStart", "domainLookupStart", "domainLookupEnd",
                            "connectStart", "connectEnd", "requestStart", "responseStart", "responseEnd"],
                    "2": ["startTime", "fetchStart", "responseEnd"]};

/**
 * @description Resource API metric type 
 * 
 * @param {PerformanceResourceTiming} perfmObj - Performance Metrics Object of a Resource
 * 
 * @returns {number} Metric Format
 *  - 1 - Format Type 1 All Metrics
 *  - 2 - Format Type 2 CORS Resource Metrics
 */
EGRUM.getFormatType=function(perfmObj){
    return perfmObj.fetchStart <= perfmObj.domainLookupStart ? "1" : "2";
};

/**
 * @description Checks wherther the given URL is eG RUM Beacon URL or not
 * if eG RUM beacon will not be considered as tracking, otherwise we will endup in infinite loop for tracing Ajax calls.
 * @param url - Input URL
 * 
 * @returns {Boolean}
 *  - true - Its a beacon URL
 *  - false - Not a beacon URL
 */
EGRUM.isBeaconUrl=function(url) {
    var beaconUrl = EGRUM["beacon-url"];
    beaconUrl = beaconUrl + "/rumcollector/rdr";
    //var beaconRegex = new RegExp(beaconUrl);
	// return return url.match(beaconRegex);
	url = url.split("?")[0];
    return url === beaconUrl;
}

/**
 * @description EGRUM starts here ....
 */
EGRUM.init();
/**
 * @description Creates a RegExp from the given string, converting asterisks to .* expressions,
 * and escaping all other characters.
 * @param s - pattern
 * @return RegExp
 */
function wildcardToRegExp (s) {
  return new RegExp('^' + s.split(/\*+/).map(regExpEscape).join('.*') + '$');
}

/**
 * @description RegExp-escapes all characters in the given string.
 * @param s - input string
 * @return Escaped String
 */
function regExpEscape (s) {
  return s.replace(/[|\\{}()[\]^$+*?.]/g, '\\$&');
}

/**
 * @description Match the URL with each exclude pattern.
 * @param url - input URL
 * @return {boolean} - Is exclude URL
 */
EGRUM.isExcludeURL  = function(url,isAjax){
	var captureConf = EGRUM.config && EGRUM.config.capture;
	var excludePatterns;
	if(isAjax){
		excludePatterns  = captureConf && captureConf.ajaxExcludeURLPattern;
	}
	else{
		 excludePatterns  = captureConf && captureConf.excludeURLPattern;
	}
	var isExclude = false;
	if(excludePatterns){
		var patArr = excludePatterns.split(',');
		if(patArr && patArr.length > 0){
			var regxArr = patArr.map(function(e, i){
				return wildcardToRegExp(e);
			});
			for(var i =0; i < regxArr.length; i++){
				var regxPat = regxArr[i];
				var isMatch = regxPat && regxPat.test && regxPat.test(url);
				if(isMatch){
					isExclude=isMatch;
					break;
				}
			}
		}
	}
	return isExclude;
}

/**
 * @description Match the URL with each include pattern.
 * @param url - input URL
 * @return {boolean} - Is include URL
 */
EGRUM.isIncludeURL  = function(url){
	var captureConf = EGRUM.config && EGRUM.config.capture;
	var includePatterns  = captureConf && captureConf.includeURLPattern || "*";
	var isInclude = false;
	if(includePatterns){
		var patArr = includePatterns.split(',');
		if(patArr && patArr.length > 0){
			var regxArr = patArr.map(function(e, i){
				return wildcardToRegExp(e);
			});
			for(var i =0; i < regxArr.length; i++){
				var regxPat = regxArr[i];
				var isMatch = regxPat && regxPat.test && regxPat.test(url);
				if(isMatch){
					isInclude=isMatch;
					break;
				}
			}
		}
	}
	return isInclude;
}

}
};
})();