#!/bin/bash

while true; do
    read -p "Do you have any other PHP profiler installed on this system, besides eG Enterprise? (Yes/No)?" yn
    case $yn in
        [Yy]* ) exit;;
        [Nn]* ) break;;
        * ) echo "Please answer yes or no.";;
    esac
done

#Arguments e indicates - php|phpfpm, p indicates path of the binary file, a indicates the eGurkha installed directory

usage() { 	echo "**** eG_PHP_BTM installation failed ****"
		echo "Usage: $0 [-e <1-php|2-php-fpm>] [(optional) -p <Path of php|php-fpm executable>] [(optional) -a <Path of eGurkha installed directory>]" 1>&2; exit 1; }

while getopts ":e:p:a:" o; do
    case "${o}" in
        e)
            e=${OPTARG}
            ((e == 1 || e == 2)) || usage
            ;;
        p)
            p=${OPTARG}
            ;;
	a)
	   a=${OPTARG}
            ;;

        *)
            usage
            ;;
    esac
done
shift $((OPTIND-1))

if [ -z "${e}" ]; then
    usage
fi

#check the argument to install php or php-fpm
if [ "$e" == 1 ] ; then
	phpProgram="php"
else
 	phpProgram="php-fpm"
fi

#Reads the PHP binary location from the arguments - p 
configpath="/opt/egurkha/"
extensionpath=""
isubuntu=$(cat /etc/*-release | grep "ID_LIKE" | sed -n 's/ID_LIKE=//p')

if [ -z "${p}" ] ; then
	phpProgram=${phpProgram}
else
	if [ "$isubuntu" == "debian" ]; then
		phpProgram="${p}"
	else
	        phpProgram="${p}/${phpProgram}"
	fi
fi

#Reads the PHPBTM log & configuration file location from the arguments
if [ -z "${a}" ] ; then
	configpath="/opt/egurkha/"
else
        configpath=${a}
fi

#Get the PHP extension based on the system architecture
is64=`uname -m | grep "64" | wc -l`
if [[ $is64 -eq 1 ]]; then
   	extensionpath="${configpath}/lib/lib64/phpBTM/"
else
	extensionpath="${configpath}/lib/phpBTM/"
fi

#Checking the Machine type Redhat | Debian
if [ "$isubuntu" == "debian" ]; then
	extensionpath="${extensionpath}debian/"
fi

versionsuppot=0
#Get the PHP version
__vers=$(${phpProgram} -v 2> /dev/null)

if [ -z "$__vers" ] || [ ! -n "$__vers" ] ; then
    	echo "*** PHP Installation NOT FOUND ***"
    	echo "Setup Aborted"
    	exit
else
	if [ "$e" == 1 ] ; then
        	phpversn=$(${phpProgram} -dagent.cli_enabled=0 -r 'print PHP_VERSION_ID; print "\n";' 2>/dev/null)
        	phpversn=(${phpversn[@]})
        	versn=50400
        	if [ $phpversn -ge $versn ] ; then
                	versionsuppot=1
        	fi
	else
        	phpversn=$(${phpProgram} -v | head -n 1 |  awk 'NR==1 {print $2}' | cut -d'-' -f1)
       		versn=5.6
        	
        	versionsuppot=$(awk 'BEGIN{ print "'$versn'"<"'$phpversn'" }')
	fi

if [ $versionsuppot -eq 1 ] 
then
	echo ".... PHP version "$phpversn" Found ...."
	majorversion=""
	minorversion=""
	if [ "$e" == 1 ] ; then
		majorversion=$(${phpProgram} -dagent.cli_enabled=0 -r 'print PHP_MAJOR_VERSION; print "\n";' 2>/dev/null)
  		majorversion=(${majorversion[@]})
  		minorversion=$(${phpProgram} -dagent.cli_enabled=0 -r 'print PHP_MINOR_VERSION; print "\n";' 2>/dev/null)
  		minorversion=(${minorversion[@]})
	else
		majorversion="$(cut -d'.' -f1 <<<"$phpversn")"
		minorversion="$(cut -d'.' -f2 <<<"$phpversn")"
	fi
	__threadsfty=$(${phpProgram} -i 2> /dev/null | grep "Thread Safety => enabled")
	__debugbld=$(${phpProgram} -i 2> /dev/null | grep "Debug Build => yes")
	if [ "$__threadsfty" != "" ] ; then
    		echo "*** Disable Thread Safety and run the Script again ***"
    		echo "Setup Aborted"
    		exit
	fi
	if [ "$__debugbld" != "" ] ; then
   		echo "*** PHP as Debug build is not Supported ***"
    		echo "Setup Aborted"
    		exit
	else
		# Getting additional .ini files location
  		additnlIniDir=$(${phpProgram} -i 2> /dev/null | grep "Scan this dir for additional .ini files")
  		additnlIniDir="$(cut -d'>' -f2 <<<"$additnlIniDir")"
  		additnlIniDir="${additnlIniDir// /}"
		egextension="${extensionpath}eG_phpBTM_${majorversion}.${minorversion}.so"
  		echo ""
  		if [ "$additnlIniDir" != "" ]; then
        		eginifile="/eG_phpBTM.ini"
			file="$additnlIniDir$eginifile"
			echo "	Creating eG_phpBTM.ini in ""${additnlIniDir}/"
			rm -f "$file"
        		echo "extension=eG_phpBTM.so" >> "$file"
			echo "egagent.configpath=""$configpath" >> "$file"
  		else
			#Get the (php.ini) location
			iniPath=$(${phpProgram} -i 2> /dev/null | grep "Configuration File (php.ini) Path")
        		iniPath="$(cut -d'>' -f2 <<<"$iniPath")"
			iniPath="${iniPath// /}"
			phpinifile="/php.ini"
			file="$iniPath$phpinifile"
			if [ ! -f "$file" ]
			then
	  			echo "*** PHP Configuration file not found ($file) ***"
				echo "Setup Aborted"
				exit
			else
				echo "	Adding extension in ""${file}"
				echo "$configpath"
				#sed -i "/\b\(.*eG_phpBTM\)\b/d" "${file}"
				#sed -i "/\b\(egagent.configpath*\)\b/d" "${file}"
				echo "egagent.configpath=""$configpath" >> "$file"
				echo "extension=eG_phpBTM.so" >> "$file"
			fi
  		fi
		#Get the extension directory location
  		extDir=$(${phpProgram} -i 2> /dev/null | grep -w "extension_dir" | head -n 1)
		extDir="$(cut -d'>' -f3 <<<"$extDir")"
		extDir="${extDir// /}"
  		echo "	Copying the PHP BTM module to ""${extDir}/"
	  
  		if cp -f "$egextension" "$extDir/eG_phpBTM.so"
  		then
   			echo ""
   			echo "-----------------------------------------------------"
   			echo "	eG PHP BTM Installed Successfully"
   			echo "-----------------------------------------------------"
		else
			echo "Setup Aborted"
		fi
  
	fi
else
 	echo "*** PHP version not supported *** "
 	echo $phpversn 
fi
fi


