/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart.ext;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.LineChart;
import java.awt.IllegalComponentStateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TimeLineChart
extends LineChart {
    private SimpleDateFormat cO;
    private SimpleDateFormat cL = new SimpleDateFormat();
    private String cM = "ms";
    private long cR = 0L;
    private long cJ = 0L;
    private double cQ = 1.0;
    private boolean cN;
    private String[] cK;
    private double[] cP = new double[1000];
    private int cI;

    public TimeLineChart() {
        try {
            this.cO = new SimpleDateFormat(this.cM, this.getLocale());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            this.cO = new SimpleDateFormat(this.cM);
        }
        this.cO.setLenient(false);
        this.setSampleLabelsOn(true);
    }

    public void reset() {
        this.cQ = 1.0;
        this.cM = "ms";
        super.reset();
        try {
            this.cO = new SimpleDateFormat(this.cM, this.getLocale());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            this.cO = new SimpleDateFormat(this.cM);
        }
        this.cO.setLenient(false);
        this.setSampleLabelsOn(true);
    }

    public void setTimeFormatInput(String string) {
        if (string != null && string.trim().length() > 0) {
            this.cO.applyPattern(string);
            this.cM = string;
        } else {
            this.cO.applyPattern(this.cM);
        }
    }

    public String getTimeFormatInput() {
        return this.cM;
    }

    public void setTimeFormatInputLocale(String string) {
        StringTokenizer stringTokenizer;
        Locale locale = null;
        if (string != null && string.length() > 0 && (stringTokenizer = new StringTokenizer(string, ", ")).hasMoreTokens()) {
            String string2;
            String string3 = string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreElements()) {
                string3 = stringTokenizer.nextToken();
            }
            locale = new Locale(string2.toUpperCase(), string3.toUpperCase());
        }
        if (locale != null) {
            this.cO = new SimpleDateFormat(this.cM, locale);
        } else {
            try {
                this.cO = new SimpleDateFormat(this.cM, this.getLocale());
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                this.cO = new SimpleDateFormat(this.cM);
            }
        }
    }

    public void setTimeFormatOut(String string) {
        if (string != null && string.trim().length() > 0) {
            this.cL.applyPattern(string);
        } else {
            this.cL.applyPattern(this.cM);
        }
        try {
            this.cL.format(new Date());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Invalid pattern " + string);
        }
    }

    public void setTimeFormatOutLocale(String string) {
        StringTokenizer stringTokenizer;
        Locale locale = null;
        if (string != null && string.length() > 0 && (stringTokenizer = new StringTokenizer(string, ", ")).hasMoreTokens()) {
            String string2;
            String string3 = string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreElements()) {
                string3 = stringTokenizer.nextToken();
            }
            locale = new Locale(string2.toUpperCase(), string3.toUpperCase());
        }
        if (locale != null) {
            this.cL = new SimpleDateFormat(this.cL.toPattern(), locale);
        } else {
            try {
                this.cL = new SimpleDateFormat(this.cL.toPattern(), this.getLocale());
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                this.cL = new SimpleDateFormat(this.cL.toPattern());
            }
        }
    }

    public String getTimeFormatOut() {
        return this.cL.toPattern();
    }

    public void setLowerTime(String string) {
        if (string != null && string.trim().length() > 0) {
            this.cR = this.try(string);
        }
        this.cJ = Math.max(this.cR, this.cJ);
    }

    public String getLowerTime() {
        return this.cL.format(new Date(this.cR));
    }

    public void setUpperTime(String string) {
        if (string != null && string.trim().length() > 0) {
            this.cJ = this.try(string);
        }
        this.cR = Math.min(this.cR, this.cJ);
    }

    public String getUpperTime() {
        return this.cL.format(new Date(this.cJ));
    }

    public void setTimeScale(double d) {
        this.cQ = d;
        double d2 = this.cJ - this.cR;
        int n = (int)Math.round(d2 / (this.cQ * 1000.0));
        this.setSampleCount(n + 1);
        this.setSampleAxisRange(0.0, n);
    }

    public double getTimeScale() {
        return this.cQ;
    }

    public void setAutoTimeLabelsOn(boolean bl) {
        this.cN = bl;
    }

    public boolean isAutoTimeLabelsOn() {
        return this.cN;
    }

    public void setTimePlots(int n, String[] stringArray) {
        if (n >= 0 && stringArray != null && stringArray.length > 0) {
            if (this.cP.length < this.cI + stringArray.length) {
                double[] dArray = new double[this.cI + stringArray.length + 1000];
                System.arraycopy(this.cP, 0, dArray, 0, this.cP.length);
                this.cP = dArray;
            }
            if (this.cK == null || this.cK.length < this.getSampleCount()) {
                this.cK = new String[this.getSampleCount()];
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                String[] stringArray2 = Chart.getStringValues(stringArray[i], "|");
                long l = Long.MIN_VALUE;
                if (stringArray2 != null && stringArray2.length >= 1) {
                    l = this.try(stringArray2[0]);
                }
                double d = Double.NaN;
                if (stringArray2 != null && stringArray2.length >= 2) {
                    try {
                        d = Double.valueOf(stringArray2[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid plot: " + stringArray[i]);
                    }
                }
                if (l < this.cR || l > this.cJ) continue;
                int n2 = (int)Math.round((double)(l - this.cR) / (this.cQ * 1000.0));
                try {
                    this.setSampleValue(n, n2, d);
                    String string = this.cL.format(new Date(l));
                    this.cK[n2] = new String(string);
                    if (this.cN) {
                        this.setSampleLabel(n2, string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (!this.cN) continue;
                this.cP[this.cI++] = n2;
            }
        }
    }

    public void setTimeLabels(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray != null && this.cP.length < this.cI + stringArray.length) {
                double[] dArray = new double[this.cI + stringArray.length + 1000];
                System.arraycopy(this.cP, 0, dArray, 0, this.cP.length);
                this.cP = dArray;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                long l;
                if (stringArray[i] == null || (l = this.try(stringArray[i])) < this.cR || l > this.cJ) continue;
                int n = (int)Math.round((double)(l - this.cR) / (this.cQ * 1000.0));
                try {
                    this.setSampleLabel(n, this.cL.format(new Date(l)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.cP[this.cI++] = n;
            }
        }
    }

    public void setDefaultGridLinesOn(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.cP.length && i < this.cI; ++i) {
                this.setGridLine(i, this.cP[i]);
            }
        } else {
            this.setGridLines(null);
        }
    }

    long try(String string) {
        long l = 0L;
        String string2 = this.cO.toPattern();
        if (string != null && string.length() > 0 && string2 != null && string2.trim().equalsIgnoreCase("ms")) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Invalid milliseconds time: " + string);
            }
        } else if (string != null && string.trim().length() > 0 && this.cO != null) {
            try {
                Date date = this.cO.parse(string.trim());
                if (date != null) {
                    l = date.getTime();
                }
            }
            catch (ParseException parseException) {
                System.out.println("Invalid date and time pattern match: " + string + " " + this.cO.toPattern());
            }
        }
        return l;
    }

    private void int() {
        int n = this.getSampleCount();
        double d = (double)(this.cJ - this.cR) / (double)n;
        double d2 = this.cR;
        for (int i = 0; i < n; ++i) {
            String string = this.a(Math.round(d2));
            this.setSampleLabel(i, string);
            d2 += d;
        }
    }

    private String a(long l) {
        String string;
        try {
            string = this.cL.format(new Date(l));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = new Date(l).toString();
        }
        return string;
    }

    public String createTimeLabelBySample(int n) {
        String string;
        long l = (long)((double)n * this.cQ * 1000.0) + this.cR;
        try {
            string = this.cO.format(new Date(l));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = new Date(l).toString();
        }
        return string;
    }

    protected String constructLabel(int n, int n2, boolean bl, int n3) {
        String string;
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount()) {
            return "";
        }
        boolean bl2 = bl && this.isSeriesLabelsOn() && this.getSeriesLabelStyle() == n3;
        int n4 = this.getSampleLabelStyle();
        if (this.getSampleLabelStyle() == 4) {
            n4 = 3;
        }
        boolean bl3 = this.isSampleLabelsOn() && n4 == n3;
        boolean bl4 = this.isValueLabelsOn(n) && this.getValueLabelStyle() == n3;
        String string2 = n3 == 3 ? " : " : ":";
        String string3 = "";
        if (bl2 && (string = this.getSeriesLabel(n)) != null) {
            string3 = string3 + string;
            if (!string.endsWith("\n") && bl3 && this.getSampleLabel(n2) != null) {
                string3 = string3 + string2;
            }
        }
        if (bl3 && n2 < this.cK.length && this.cK[n2] != null) {
            string3 = string3 + this.cK[n2];
        }
        if (bl4) {
            String string4;
            string = this.getLabel("valueLabelPrefix_" + n);
            if (string == null) {
                string = this.getLabel("valueLabelPrefix");
            }
            if ((string4 = this.getLabel("valueLabelPostfix_" + n)) == null) {
                string4 = this.getLabel("valueLabelPostfix");
            }
            if (string3.length() > 0) {
                String string5 = this.formatSeriesNumber(n, this.getSampleValue(n, n2));
                string5 = string != null ? string + string5 : string5;
                String string6 = string5 = string4 != null ? string5 + string4 : string5;
                string3 = string3.endsWith("\n") || string5.startsWith("\n") ? string3 + string5 : string3 + string2 + string5;
            } else {
                string3 = this.formatSeriesNumber(n, this.getSampleValue(n, n2));
                string3 = string != null ? string + string3 : string3;
                string3 = string4 != null ? string3 + string4 : string3;
            }
        }
        return string3;
    }
}

