/*
 * Decompiled with CFR 0.152.
 */
package eGTTIntegration;

import com.eg.EgInstallInfo;
import com.eg.EgMappingInfo;
import com.eg.EgSSL;
import com.eg.EgTablesInfo;
import com.eg.IniFile;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import com.egurkha.ini.IniUI;
import com.egurkha.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eGTTIntegration.TTIntegrationWrapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ZendeskIntegrator
extends TTIntegrationWrapper {
    private String subjectFormat = "";
    private String commentFormat = "";
    private String apiUrl = "";
    private String username = "";
    private String password = "";
    private String zone = "";
    private String criticalPriorityName = "";
    private String majorPriorityName = "";
    private String minorPriorityName = "";
    private String normalPriorityName = "";
    private String closedStatusName = "";
    private String newStatusName = "";
    private String type = "";
    private String enableDetailedLog = "";
    private String enableUserLog = "";
    private String enableOrganizationLog = "";
    private String enableticketfieldsLog = "";
    private Hashtable zendeskZonelist = new Hashtable();
    private Hashtable organizationMap = new Hashtable();
    private Hashtable userMap = new Hashtable();
    private Hashtable userIdMap = new Hashtable();
    private ArrayList configuredUsers = new ArrayList();
    private EgTablesInfo tablesInfo = new EgTablesInfo("manager");
    private Gson gson = null;
    private EgMappingInfo mappingInfo = null;
    private String thisLanguage = "";
    private IniFile servicesIni = null;
    public String fileSeparator = System.getProperty("file.separator");
    private String servicesFile = "";
    private String customPayload = "";
    private ArrayList customFieldList = new ArrayList();
    private int CONNECTION_TIMEOUT_MS = 30000;

    public ZendeskIntegrator(Hashtable hashtable) {
        try {
            this.subjectFormat = "";
            this.commentFormat = "";
            this.apiUrl = "";
            this.username = "";
            this.password = "";
            this.zone = "";
            this.type = "";
            this.criticalPriorityName = "";
            this.majorPriorityName = "";
            this.minorPriorityName = "";
            this.normalPriorityName = "";
            this.closedStatusName = "";
            this.newStatusName = "";
            this.enableDetailedLog = "false";
            this.enableUserLog = "false";
            this.enableOrganizationLog = "false";
            this.enableticketfieldsLog = "false";
            this.zendeskZonelist.clear();
            this.gson = new GsonBuilder().setPrettyPrinting().create();
            this.updateInitParams(hashtable);
            IniUI iniUI = IniUI.getInstance();
            this.thisLanguage = iniUI.getDefaultLanguage();
            this.mappingInfo = new EgMappingInfo(this.thisLanguage);
            this.servicesFile = EgInstallInfo.getInstallDir() + this.fileSeparator + "manager" + this.fileSeparator + "config" + this.fileSeparator + "eg_services.ini";
            this.servicesIni = new IniFile(this.servicesFile);
            this.organizationMap = this.getOrganizationMap();
            this.configuredUsers = this.getConfiguredUsers();
            this.userMap = this.getUserMap();
            this.zendeskZonelist = this.getZendeskZoneList();
            this.customFieldList = this.getCustomFieldList();
        }
        catch (Throwable throwable) {
            System.out.println("Error: Exception in updateInitParams() method -ConnectwiseIntegrator.java ");
            throwable.printStackTrace();
        }
    }

    @Override
    public void updateInitParams(Hashtable hashtable) {
        if (hashtable != null) {
            String string;
            if (hashtable.get("enableDetailedLog") != null) {
                this.enableDetailedLog = (String)hashtable.get("enableDetailedLog");
            }
            if (hashtable.get("enableUserLog") != null) {
                this.enableUserLog = (String)hashtable.get("enableUserLog");
            }
            if (hashtable.get("enableOrganizationLog") != null) {
                this.enableOrganizationLog = (String)hashtable.get("enableOrganizationLog");
            }
            if (hashtable.get("enableticketfieldsLog") != null) {
                this.enableticketfieldsLog = (String)hashtable.get("enableticketfieldsLog");
            }
            if (hashtable.get("TitleFormat") != null) {
                this.subjectFormat = (String)hashtable.get("TitleFormat");
            }
            if (hashtable.get("DescriptionFormat") != null) {
                this.commentFormat = (String)hashtable.get("DescriptionFormat");
            }
            if (hashtable.get("priority") != null) {
                string = (String)hashtable.get("priority");
                this.extractPriority(string);
            }
            if (hashtable.get("status") != null) {
                string = (String)hashtable.get("status");
                this.extractStatus(string);
            }
            if (hashtable.get("type") != null) {
                this.type = (String)hashtable.get("type");
            }
            if (hashtable.get("apiUrl") != null) {
                this.apiUrl = (String)hashtable.get("apiUrl");
            }
            if (hashtable.get("user") != null) {
                this.username = (String)hashtable.get("user");
            }
            if (hashtable.get("password") != null) {
                this.password = (String)hashtable.get("password");
            }
            if (hashtable.get("customPayload") != null) {
                this.customPayload = (String)hashtable.get("customPayload");
            }
            if (!this.logEnabled && this.enableDetailedLog != null && this.enableDetailedLog.equalsIgnoreCase("true") && hashtable.get("enableLogging") != null && (string = (String)hashtable.get("enableLogging")) != null && string.equalsIgnoreCase("yes")) {
                this.logEnabled = true;
                this.logMaxFiles = (String)hashtable.get("logMaxFiles");
                this.logMaxSize = (String)hashtable.get("LogFileMaxSize");
                this.logFileName = "ZENDESK.log";
                this.initLog();
            }
            if (this.timeoutVal != null && !this.timeoutVal.equals("")) {
                try {
                    int n = Integer.parseInt(this.timeoutVal);
                    this.CONNECTION_TIMEOUT_MS = n * 1000;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public void extractPriority(String string) {
        if (!StringUtils.isNull((String)string)) {
            if (string.indexOf("#") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!StringUtils.isNull((String)string2) && string2.indexOf(":") > 0) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
                        arrayList = new ArrayList();
                        while (stringTokenizer2.hasMoreTokens()) {
                            arrayList.add(stringTokenizer2.nextToken());
                        }
                        if (arrayList.isEmpty() || arrayList.size() != 2) continue;
                        String string3 = arrayList.get(1).toString();
                        String string4 = arrayList.get(0).toString();
                        if (string3.equalsIgnoreCase("critical")) {
                            this.criticalPriorityName = string4;
                            continue;
                        }
                        if (string3.equalsIgnoreCase("major")) {
                            this.majorPriorityName = string4;
                            continue;
                        }
                        if (string3.equalsIgnoreCase("minor")) {
                            this.minorPriorityName = string4;
                            continue;
                        }
                        if (!string3.equalsIgnoreCase("normal")) continue;
                        this.normalPriorityName = string4;
                        continue;
                    }
                    this.sop("Warning: Ticket Priority Configuration is invalid. It must be in this format(priority=$Name:Critical#$Name:Major#$Name:Minor#$Name:Normal)");
                }
            } else {
                this.sop("Warning: Ticket Priority Configuration is invalid. It must be in this format(priority=$Name:Critical#$Name:Major#$Name:Minor#$Name:Normal)");
            }
        } else {
            this.sop("Warning: Ticket Priority Configuration is empty");
        }
    }

    public void extractStatus(String string) {
        if (!StringUtils.isNull((String)string)) {
            if (string.indexOf("#") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!StringUtils.isNull((String)string2) && string2.indexOf(":") > 0) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
                        arrayList = new ArrayList();
                        while (stringTokenizer2.hasMoreTokens()) {
                            arrayList.add(stringTokenizer2.nextToken());
                        }
                        if (arrayList.isEmpty() || arrayList.size() != 2) continue;
                        String string3 = arrayList.get(1).toString();
                        String string4 = arrayList.get(0).toString();
                        if (string3.equalsIgnoreCase("OpenTicket")) {
                            this.newStatusName = string4;
                            continue;
                        }
                        if (!string3.equalsIgnoreCase("ResolvedTicket")) continue;
                        this.closedStatusName = string4;
                        continue;
                    }
                    this.sop("Warning: Ticket Status Configuration is invalid. It must be in this format(status=$Name:NewTicket#$Name:ResolvedTicket)");
                }
            } else {
                this.sop("Warning: Ticket Status Configuration is invalid. It must be in this format(status=$Name:NewTicket#$Name:ResolvedTicket)");
            }
        } else {
            System.out.println("Error: Ticket Status Configuration is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createTicket(Object[] objectArray) throws Exception {
        String string = "";
        String string2 = "";
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        try {
            block29: {
                block30: {
                    String string3;
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    block27: {
                        block28: {
                            this.zone = (String)objectArray[1];
                            string8 = (String)objectArray[0];
                            string7 = (String)objectArray[3];
                            string6 = (String)objectArray[4];
                            string5 = (String)objectArray[5];
                            Hashtable hashtable = this.getFormattedData(objectArray);
                            string4 = hashtable.get("subject").toString();
                            string3 = hashtable.get("comment").toString();
                            string4 = string4.replace("\n", "");
                            string3 = string3.replace("\n", "");
                            if (StringUtils.isNull((String)this.zone)) break block27;
                            if (this.zone.indexOf(",") > -1) break block28;
                            String string9 = "";
                            if (this.zendeskZonelist != null && this.zendeskZonelist.containsKey(this.zone)) {
                                CloseableHttpClient closeableHttpClient;
                                block25: {
                                    string9 = this.zendeskZonelist.get(this.zone).toString();
                                    string2 = this.apiUrl;
                                    int n = string2.indexOf(":");
                                    String string10 = "https";
                                    if (string2 != null && n > 0 && string2.length() > n + 3) {
                                        string10 = string2.substring(0, n);
                                    }
                                    if (string10 != null && string10.equalsIgnoreCase("https")) {
                                        this.doTheSSL();
                                    }
                                    closeableHttpClient = HttpClientBuilder.create().build();
                                    try {
                                        String string11 = this.username + ":" + this.password;
                                        byte[] byArray = Base64.encodeBase64((byte[])string11.getBytes(Charset.forName("US-ASCII")));
                                        String string12 = "Basic " + new String(byArray);
                                        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.CONNECTION_TIMEOUT_MS).setConnectTimeout(this.CONNECTION_TIMEOUT_MS).setSocketTimeout(this.CONNECTION_TIMEOUT_MS).build();
                                        HttpPost httpPost = new HttpPost(string2);
                                        httpPost.setHeader("Authorization", string12);
                                        httpPost.setConfig(requestConfig);
                                        if (this.logEnabled && this.enableDetailedLog.equalsIgnoreCase("true")) {
                                            this.sop("JSON Data Sent for create ticket:\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)this.getTicketData(objectArray, string9, false))));
                                        }
                                        StringEntity stringEntity = new StringEntity(this.getTicketData(objectArray, string9, false));
                                        stringEntity.setContentType("application/json");
                                        httpPost.setEntity((HttpEntity)stringEntity);
                                        HttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
                                        int n2 = httpResponse.getStatusLine().getStatusCode();
                                        String string13 = this.getResponseData(httpResponse);
                                        if (n2 == 201 || n2 == 200) {
                                            if (!StringUtils.isNull((String)string13) && string13.startsWith("{")) {
                                                jSONObject = JSONObject.fromObject((Object)string13);
                                            }
                                            if (jSONObject != null && jSONObject.get("ticket") != null) {
                                                jSONObject2 = (JSONObject)jSONObject.get("ticket");
                                                string = jSONObject2.get("id").toString();
                                                if (this.logEnabled) {
                                                    this.sop("INFO: Ticket has been created successfully...Details-> Ticket Number: " + string + " Priority: " + string8 + " Component Type: " + string7 + " Component Name: " + string6 + " Layer: " + string5 + " Zone: " + this.zone + " Comment: " + string3 + " Subject: " + string4);
                                                }
                                            } else if (this.logEnabled) {
                                                this.sop("Error: Failed to create Ticket...|API URL: " + string2 + " Details-> Priority: " + string8 + " Component Type: " + string7 + " Component Name: " + string6 + " Layer: " + string5 + " Zone: " + this.zone + " Comment: " + string3 + " Subject: " + string4);
                                            }
                                            break block25;
                                        }
                                        if (!StringUtils.isNull((String)string13) && string13.startsWith("{")) {
                                            jSONObject = JSONObject.fromObject((Object)string13);
                                        }
                                        if (jSONObject != null) {
                                            string13 = this.gson.toJson((Object)jSONObject);
                                        }
                                        if (!this.logEnabled) break block25;
                                        this.sop("Error: Failed to create Ticket...|API URL: " + string2 + " Details-> Priority: " + string8 + " Component Type: " + string7 + " Component Name: " + string6 + " Layer: " + string5 + " Zone: " + this.zone + " Comment: " + string3 + " Subject: " + string4);
                                        if (!this.enableDetailedLog.equalsIgnoreCase("true")) break block25;
                                        this.sop("Status Code:" + n2 + "\n");
                                        this.sop("Response:\n" + string13);
                                    }
                                    catch (Exception exception) {
                                        block26: {
                                            try {
                                                if (!this.logEnabled) break block26;
                                                this.sop("Error ->  Failed to send :" + string2 + " Reason :" + exception.toString());
                                            }
                                            catch (Throwable throwable) {
                                                closeableHttpClient.getConnectionManager().shutdown();
                                                throw throwable;
                                            }
                                        }
                                        closeableHttpClient.getConnectionManager().shutdown();
                                    }
                                }
                                closeableHttpClient.getConnectionManager().shutdown();
                            }
                            if (this.logEnabled) {
                                this.sop("ERROR:  Organization mapping in INI is incorrect...Details-> Priority: " + string8 + " Component Type: " + string7 + " Component Name: " + string6 + " Layer: " + string5 + " Zone: " + this.zone + " Comment: " + string3 + " Subject: " + string4);
                            }
                            break block29;
                        }
                        if (this.logEnabled) {
                            this.sop("ERROR:  Multiple Zones associated with the component...Details-> Priority: " + string8 + " Component Type: " + string7 + " Component Name: " + string6 + " Layer: " + string5 + " Zone: " + this.zone + " Comment: " + string3 + " Subject: " + string4);
                        }
                        break block30;
                    }
                    if (this.logEnabled) {
                        this.sop("ERROR:  Zone not associated with the alarm...Details-> Priority: " + string8 + " Component Type: " + string7 + " Component Name: " + string6 + " Layer: " + string5 + " Zone: " + this.zone + " Comment: " + string3 + " Subject: " + string4);
                    }
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            if (this.logEnabled) {
                this.sop("ERROR:  Exception in createTicket()  method -ZendeskIntegrator ");
            }
            throwable.printStackTrace();
        }
        finally {
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTicket(String string, Object[] objectArray) throws Exception {
        String string2 = "";
        boolean bl = false;
        String string3 = "";
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        try {
            block31: {
                block30: {
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    String string9;
                    block28: {
                        block29: {
                            this.zone = (String)objectArray[1];
                            string9 = (String)objectArray[0];
                            string8 = (String)objectArray[3];
                            string7 = (String)objectArray[4];
                            string6 = (String)objectArray[5];
                            Hashtable hashtable = this.getFormattedData(objectArray);
                            string5 = hashtable.get("subject").toString();
                            string4 = hashtable.get("comment").toString();
                            string5 = string5.replace("\n", "");
                            string4 = string4.replace("\n", "");
                            String string10 = "";
                            if (StringUtils.isNull((String)this.zone)) break block28;
                            if (this.zone.indexOf(",") > -1) break block29;
                            if (this.zendeskZonelist != null && this.zendeskZonelist.containsKey(this.zone)) {
                                CloseableHttpClient closeableHttpClient;
                                block26: {
                                    string10 = this.zendeskZonelist.get(this.zone).toString();
                                    string3 = this.apiUrl;
                                    string3 = string3.substring(0, string3.indexOf("tickets") + 7) + "/" + string + ".json";
                                    String string11 = "https";
                                    int n = string3.indexOf(":");
                                    if (string3 != null && n > 0 && string3.length() > n + 3) {
                                        string11 = string3.substring(0, n);
                                    }
                                    if (string11 != null && string11.equalsIgnoreCase("https")) {
                                        this.doTheSSL();
                                    }
                                    closeableHttpClient = HttpClientBuilder.create().build();
                                    try {
                                        String string12 = this.username + ":" + this.password;
                                        byte[] byArray = Base64.encodeBase64((byte[])string12.getBytes(Charset.forName("US-ASCII")));
                                        String string13 = "Basic " + new String(byArray);
                                        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.CONNECTION_TIMEOUT_MS).setConnectTimeout(this.CONNECTION_TIMEOUT_MS).setSocketTimeout(this.CONNECTION_TIMEOUT_MS).build();
                                        HttpPut httpPut = new HttpPut(string3);
                                        httpPut.setHeader("Authorization", string13);
                                        httpPut.setConfig(requestConfig);
                                        StringEntity stringEntity = null;
                                        if (this.logEnabled && this.enableDetailedLog.equalsIgnoreCase("true")) {
                                            this.sop("JSON Data Sent for update ticket:\n" + this.gson.toJson((Object)JSONObject.fromObject((Object)this.getTicketData(objectArray, string10, true))));
                                        }
                                        stringEntity = new StringEntity(this.getTicketData(objectArray, string10, true));
                                        stringEntity.setContentType("application/json");
                                        httpPut.setEntity((HttpEntity)stringEntity);
                                        HttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPut);
                                        int n2 = httpResponse.getStatusLine().getStatusCode();
                                        String string14 = this.getResponseData(httpResponse);
                                        if (n2 == 201 || n2 == 200) {
                                            if (!StringUtils.isNull((String)string14) && string14.startsWith("{")) {
                                                jSONObject = JSONObject.fromObject((Object)string14);
                                            }
                                            if (jSONObject.get("ticket") != null) {
                                                jSONObject2 = (JSONObject)jSONObject.get("ticket");
                                                if (jSONObject2.get("id") != null) {
                                                    bl = true;
                                                    string2 = jSONObject2.get("id").toString();
                                                }
                                                if (this.logEnabled) {
                                                    this.sop("INFO: Ticket has been updated successfully...Details-> Ticket Number: " + string2 + " Priority: " + string9 + " Component Type: " + string8 + " Component Name: " + string7 + " Layer: " + string6 + " Zone: " + this.zone + " Comment: " + string4 + " Subject: " + string5);
                                                }
                                            } else if (this.logEnabled) {
                                                this.sop("Error: Failed to update Ticket...|API URL: " + string3 + " Details-> Priority: " + string9 + " Component Type: " + string8 + " Component Name: " + string7 + " Layer: " + string6 + " Zone: " + this.zone + " Comment: " + string4 + " Subject: " + string5);
                                            }
                                            break block26;
                                        }
                                        if (!StringUtils.isNull((String)string14) && string14.startsWith("{")) {
                                            jSONObject = JSONObject.fromObject((Object)string14);
                                        }
                                        if (jSONObject != null) {
                                            string14 = this.gson.toJson((Object)jSONObject);
                                        }
                                        if (!this.logEnabled) break block26;
                                        this.sop("Error: Failed to update Ticket...|API URL: " + string3 + " Details-> Priority: " + string9 + " Component Type: " + string8 + " Component Name: " + string7 + " Layer: " + string6 + " Zone: " + this.zone + " Comment: " + string4 + " Subject: " + string5);
                                        if (!this.enableDetailedLog.equalsIgnoreCase("true")) break block26;
                                        this.sop("Status Code:" + n2 + "\n");
                                        this.sop("Response:\n" + string14);
                                    }
                                    catch (Exception exception) {
                                        block27: {
                                            try {
                                                if (!this.logEnabled) break block27;
                                                this.sop("Error ->  Failed to send :" + string3 + " Reason :" + exception.toString());
                                            }
                                            catch (Throwable throwable) {
                                                closeableHttpClient.getConnectionManager().shutdown();
                                                throw throwable;
                                            }
                                        }
                                        closeableHttpClient.getConnectionManager().shutdown();
                                    }
                                }
                                closeableHttpClient.getConnectionManager().shutdown();
                            }
                            if (this.logEnabled) {
                                this.sop("ERROR:  Organization mapping in INI is incorrect...Details-> Priority: " + string9 + " Component Type: " + string8 + " Component Name: " + string7 + " Layer: " + string6 + " Zone: " + this.zone + " Comment: " + string4 + " Subject: " + string5);
                            }
                            break block30;
                        }
                        if (this.logEnabled) {
                            this.sop("ERROR:  Multiple Zones associated with the component...Details-> Priority: " + string9 + " Component Type: " + string8 + " Component Name: " + string7 + " Layer: " + string6 + " Zone: " + this.zone + " Comment: " + string4 + " Subject: " + string5);
                        }
                        break block31;
                    }
                    if (this.logEnabled) {
                        this.sop("ERROR:  Zone not associated with the alarm...Details-> Priority: " + string9 + " Component Type: " + string8 + " Component Name: " + string7 + " Layer: " + string6 + " Zone: " + this.zone + " Comment: " + string4 + " Subject: " + string5);
                    }
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            if (this.logEnabled) {
                this.sop("ERROR: Exception in UpdateTicket()  method -ZendeskIntegrator.java ");
            }
            throwable.printStackTrace();
        }
        finally {
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getFormattedData(Object[] objectArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = (String)objectArray[0];
        String string6 = (String)objectArray[2];
        String string7 = (String)objectArray[3];
        String string8 = (String)objectArray[4];
        String string9 = (String)objectArray[5];
        String string10 = "";
        String string11 = "";
        int n = 1;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        String string12 = (String)objectArray[7];
        String string13 = (String)objectArray[8];
        String string14 = (String)objectArray[11];
        if (!StringUtils.isNull((String)string14)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string14, ",");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2;
                String string15 = stringTokenizer.nextToken();
                if (StringUtils.isNull((String)string15) || (stringTokenizer2 = new StringTokenizer(string15, "|")).countTokens() < 5) continue;
                string4 = stringTokenizer2.nextToken();
                string3 = stringTokenizer2.nextToken();
                if (!StringUtils.isNull((String)string3) && string3.length() > 1) {
                    string3 = string3.substring(1).trim();
                }
                String string16 = string2 = stringTokenizer2.nextToken();
                string2 = this.mappingInfo.getTestDescription(string16);
                String string17 = stringTokenizer2.nextToken();
                String string18 = string8.substring(string8.indexOf(":") + 1);
                hashtable2.put("$componentType", this.mappingInfo.getComponentTypeDescription(string7));
                hashtable2.put("$componentName", string8);
                hashtable2.put("$info", string3);
                hashtable2.put("$port", string18);
                hashtable2.put("appendTag", new Boolean(false));
                String string19 = this.tablesInfo.getMeasureAlert(string16 + ":" + string17, this.thisLanguage, hashtable2);
                if (string19 != null && string19.indexOf("~!~") != -1) {
                    string19 = string19.substring(0, string19.indexOf("~!~"));
                }
                String string20 = stringTokenizer2.nextToken();
                if (!StringUtils.isNull((String)string3)) {
                    string11 = string11 + "\n\n* " + string19 + " / " + string2;
                    if (string3.equalsIgnoreCase("+")) {
                        string11 = string11 + " \n ";
                        continue;
                    }
                    string11 = string11 + " \n\n Descriptor :";
                    int n2 = 1;
                    String string21 = "";
                    StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ";");
                    while (stringTokenizer3.hasMoreTokens()) {
                        string21 = stringTokenizer3.nextToken().toString();
                        string11 = string11 + " \n " + n2 + ". " + string21;
                        ++n2;
                    }
                } else {
                    string11 = string11 + " \n " + n + ". " + string19 + " / " + string2;
                }
                ++n;
            }
        }
        string10 = string11;
        try {
            for (int i = 0; i < 2; ++i) {
                string = i == 0 ? this.subjectFormat : this.commentFormat;
                if (!StringUtils.isNull((String)string)) {
                    if (string.indexOf("$cname") > -1) {
                        string = !StringUtils.isNull((String)string8) ? this.replace(string, "$cname", string8 + " \n") : this.replace(string, "$cname", "- \n");
                    }
                    if (string.indexOf("$ctype") > -1) {
                        string = !StringUtils.isNull((String)string7) ? this.replace(string, "$ctype", string7 + " \n") : this.replace(string, "$ctype", "- \n");
                    }
                    if (string.indexOf("$prior") > -1) {
                        string = !StringUtils.isNull((String)string5) ? this.replace(string, "$prior", string5 + " \n") : this.replace(string, "$prior", "- \n");
                    }
                    if (string.indexOf("$pdesc") > -1) {
                        string = !StringUtils.isNull((String)string10) ? this.replace(string, "$pdesc", string10 + " \n") : this.replace(string, "$pdesc", "- \n");
                    }
                    if (string.indexOf("$layer") > -1) {
                        string = !StringUtils.isNull((String)string9) ? this.replace(string, "$layer", string9 + " \n") : this.replace(string, "$layer", "- \n");
                    }
                    if (string.indexOf("$starttime") > -1) {
                        string = !StringUtils.isNull((String)string12) ? this.replace(string, "$starttime", string12 + " \n") : this.replace(string, "$starttime", "- \n");
                    }
                    if (string.indexOf("$service") > -1) {
                        string = !StringUtils.isNull((String)string6) ? this.replace(string, "$service", string6 + " \n") : this.replace(string, "$service", "- \n");
                    }
                    if (string.indexOf("$zone") > -1) {
                        string = !StringUtils.isNull((String)this.zone) ? this.replace(string, "$zone", this.zone + " \n") : this.replace(string, "$zone", "- \n");
                    }
                    if (string.indexOf("$user") > -1) {
                        string = !StringUtils.isNull((String)string13) ? this.replace(string, "$user", string13 + " \n") : this.replace(string, "$user", "- \n");
                    }
                    if (string.indexOf("$test") > -1) {
                        string = !StringUtils.isNull((String)string2) ? this.replace(string, "$test", string2 + " \n") : this.replace(string, "$test", "- \n");
                    }
                    if (string.indexOf("$info") > -1) {
                        string = !StringUtils.isNull((String)string3) ? this.replace(string, "$info", string3 + " \n") : this.replace(string, "$info", "- \n");
                    }
                }
                if (i == 0) {
                    hashtable.put("subject", string);
                    continue;
                }
                hashtable.put("comment", string);
            }
        }
        catch (Exception exception) {
            if (this.logEnabled) {
                this.sop("ERROR: Exception in getFormattedData method -ConnectwiseIntegrator.java-->" + exception);
            }
            exception.printStackTrace();
        }
        finally {
            return hashtable;
        }
    }

    private String getResponseData(HttpResponse httpResponse) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            if (this.logEnabled) {
                this.sop("ERROR: Exception in getResponseData()  method -ConnectwiseIntegrator.java-->" + exception);
            }
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    @Override
    public void doTheSSL() {
        try {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
        }
        catch (Exception exception) {
            System.out.println("ERROR: Exception in doTheSSL method -ZendeslIntegrator.java-->" + exception);
            exception.printStackTrace();
        }
    }

    private String getTicketData(Object[] objectArray, String string, boolean bl) {
        Object object;
        String string2 = (String)objectArray[0];
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        Hashtable hashtable = this.getFormattedData(objectArray);
        String string10 = hashtable.get("subject").toString();
        String string11 = hashtable.get("comment").toString();
        if (!StringUtils.isNull((String)string) && string.indexOf("#") > 0) {
            object = new StringTokenizer(string, "#");
            if (((StringTokenizer)object).hasMoreTokens()) {
                string6 = ((StringTokenizer)object).nextToken().toString().trim();
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                string7 = ((StringTokenizer)object).nextToken().toString().trim();
            }
        }
        if (!StringUtils.isNull((String)string2)) {
            if (string2.equalsIgnoreCase("Critical")) {
                string4 = this.criticalPriorityName;
                string5 = this.newStatusName;
            } else if (string2.equalsIgnoreCase("Major")) {
                string4 = this.majorPriorityName;
                string5 = this.newStatusName;
            } else if (string2.equalsIgnoreCase("Minor")) {
                string4 = this.minorPriorityName;
                string5 = this.newStatusName;
            } else if (string2.equalsIgnoreCase("Normal")) {
                string4 = this.normalPriorityName;
                string5 = this.closedStatusName;
            }
        }
        object = new JSONObject();
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject2.put((Object)"body", (Object)string11);
        jSONObject.put((Object)"subject", (Object)string10);
        jSONObject.put((Object)"comment", (Object)jSONObject2);
        if (!StringUtils.isNull((String)string4) && !string4.equalsIgnoreCase("$name")) {
            jSONObject.put((Object)"priority", (Object)string4);
        }
        if (!StringUtils.isNull((String)string5) && !string5.equalsIgnoreCase("$name")) {
            jSONObject.put((Object)"status", (Object)string5);
        }
        jSONObject.put((Object)"type", (Object)this.type);
        if (this.customFieldList.size() > 0) {
            for (int i = 0; i < this.customFieldList.size(); ++i) {
                JSONObject jSONObject3 = new JSONObject();
                String string12 = this.customFieldList.get(i).toString().trim();
                if (!StringUtils.isNull((String)string12) && string12.indexOf("#") > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string12, "#");
                    if (stringTokenizer.hasMoreTokens()) {
                        string8 = stringTokenizer.nextToken().toString().trim();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string9 = stringTokenizer.nextToken().toString().trim();
                    }
                }
                if (StringUtils.isNull((String)string8) || StringUtils.isNull((String)string9)) continue;
                jSONObject3.put((Object)"id", (Object)string8);
                jSONObject3.put((Object)"value", (Object)string9);
                jSONArray.add((Object)jSONObject3);
            }
            jSONObject.put((Object)"custom_fields", (Object)jSONArray);
        }
        if (!bl) {
            jSONObject.put((Object)"submitter_id", (Object)string7);
            jSONObject.put((Object)"organization_id", (Object)string6);
            jSONObject.put((Object)"requester_id", (Object)string7);
        }
        object.put((Object)"ticket", (Object)jSONObject);
        string3 = object.toString();
        return string3;
    }

    private ArrayList getConfiguredUsers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "ZENDESK_ZONE_MAPPING";
        String[] stringArray = this.servicesIni.getVariables(string);
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = "";
                String string3 = this.servicesIni.getValue(string, stringArray[i]);
                if (string3.indexOf("#") > 0) {
                    string2 = string3.substring(string3.indexOf("#") + 1).trim();
                }
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getUserMap() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        try {
            String string = this.username + ":" + this.password;
            byte[] byArray = Base64.encodeBase64((byte[])string.getBytes(Charset.forName("US-ASCII")));
            String string2 = "Basic " + new String(byArray);
            String string3 = "https";
            String string4 = this.apiUrl;
            int n = string4.indexOf(":");
            string4 = string4.replace("tickets", "users");
            if (string4 != null && n > 0 && string4.length() > n + 3) {
                string3 = string4.substring(0, n);
            }
            if (string3 != null && string3.equalsIgnoreCase("https")) {
                this.doTheSSL();
            }
            ArrayList arrayList = this.configuredUsers;
            boolean bl = false;
            int n2 = 1;
            String string5 = string4;
            do {
                HttpGet httpGet = new HttpGet(string4);
                httpGet.setHeader("Authorization", string2);
                HttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
                int n3 = httpResponse.getStatusLine().getStatusCode();
                if (this.enableDetailedLog.equalsIgnoreCase("true") && this.enableUserLog.equalsIgnoreCase("true")) {
                    this.sop("Zendesk Users...|API URL: " + string4);
                    if (n2 > 1) {
                        this.sop("Loading Zendesk users from page " + n2);
                    }
                }
                String string6 = this.getResponseData(httpResponse);
                if (n3 == 201 || n3 == 200) {
                    if (this.enableDetailedLog.equalsIgnoreCase("true") && this.enableUserLog.equalsIgnoreCase("true")) {
                        this.sop("JSON Data received for creating User Map:\n" + string6);
                    }
                    if (!StringUtils.isNull((String)string6) && string6.startsWith("{")) {
                        jSONObject = JSONObject.fromObject((Object)string6);
                    }
                    if (jSONObject.get("users") == null) continue;
                    jSONArray = (JSONArray)jSONObject.get("users");
                    for (int i = 0; i < jSONArray.size(); ++i) {
                        jSONObject2 = (JSONObject)jSONArray.get(i);
                        if (arrayList.contains(jSONObject2.get("name").toString().trim())) {
                            arrayList.remove(jSONObject2.get("name").toString().trim());
                        }
                        if (jSONObject2.get("organization_id") == null || jSONObject2.get("organization_id").toString().trim().equalsIgnoreCase("null")) continue;
                        hashtable.put(jSONObject2.get("organization_id").toString().trim() + "#" + jSONObject2.get("name").toString().trim(), jSONObject2.get("id").toString());
                        hashtable.put(jSONObject2.get("name").toString().trim(), jSONObject2.get("id").toString());
                    }
                    if (arrayList.size() > 0) {
                        string4 = string5 + "?page=" + ++n2;
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
                if (!StringUtils.isNull((String)string6) && string6.startsWith("{")) {
                    jSONObject = JSONObject.fromObject((Object)string6);
                }
                if (jSONObject != null) {
                    string6 = this.gson.toJson((Object)jSONObject);
                }
                this.sop("Error: Failed to get Zendesk users ...|API URL: " + string4 + " Details-> " + string6);
                if (!this.enableDetailedLog.equalsIgnoreCase("true") || !this.enableUserLog.equalsIgnoreCase("true")) continue;
                this.sop("Status Code:" + n3 + "\n");
                this.sop("Response:\n" + string6);
            } while (bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            closeableHttpClient.getConnectionManager().shutdown();
        }
        if (this.enableDetailedLog.equalsIgnoreCase("true")) {
            this.sop("User Map send for referring:\n" + hashtable);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getOrganizationMap() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        try {
            String string = this.username + ":" + this.password;
            byte[] byArray = Base64.encodeBase64((byte[])string.getBytes(Charset.forName("US-ASCII")));
            String string2 = "Basic " + new String(byArray);
            String string3 = "https";
            String string4 = this.apiUrl;
            int n = string4.indexOf(":");
            string4 = string4.replace("tickets", "organizations");
            if (string4 != null && n > 0 && string4.length() > n + 3) {
                string3 = string4.substring(0, n);
            }
            if (string3 != null && string3.equalsIgnoreCase("https")) {
                this.doTheSSL();
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.CONNECTION_TIMEOUT_MS).setConnectTimeout(this.CONNECTION_TIMEOUT_MS).setSocketTimeout(this.CONNECTION_TIMEOUT_MS).build();
            boolean bl = false;
            int n2 = 1;
            String string5 = string4;
            do {
                HttpGet httpGet = new HttpGet(string4);
                httpGet.setHeader("Authorization", string2);
                httpGet.setConfig(requestConfig);
                HttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
                int n3 = httpResponse.getStatusLine().getStatusCode();
                String string6 = this.getResponseData(httpResponse);
                if (this.enableDetailedLog.equalsIgnoreCase("true") && this.enableOrganizationLog.equalsIgnoreCase("true")) {
                    this.sop("Zendesk organizations ...|API URL: " + string4);
                    if (n2 > 1) {
                        this.sop("Loading Zendesk organizations  from " + hashtable.size() + "th record and page is " + n2);
                    }
                }
                if (n3 == 201 || n3 == 200) {
                    if (this.enableDetailedLog.equalsIgnoreCase("true") && this.enableOrganizationLog.equalsIgnoreCase("true")) {
                        this.sop("JSON Data received for creating Organization Map:\n" + string6);
                    }
                    if (!StringUtils.isNull((String)string6) && string6.startsWith("{")) {
                        jSONObject = JSONObject.fromObject((Object)string6);
                    }
                    if (jSONObject.get("organizations") != null) {
                        jSONArray = (JSONArray)jSONObject.get("organizations");
                        for (int i = 0; i < jSONArray.size(); ++i) {
                            jSONObject2 = (JSONObject)jSONArray.get(i);
                            if (jSONObject2.get("name") == null || jSONObject2.get("id") == null) continue;
                            hashtable.put(jSONObject2.get("name").toString().trim(), jSONObject2.get("id").toString().trim());
                        }
                    }
                    if (jSONObject.has("next_page") && !StringUtils.isNull((String)jSONObject.getString("next_page"))) {
                        bl = true;
                        string4 = string5 + "?page=" + ++n2;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
                if (!StringUtils.isNull((String)string6) && string6.startsWith("{")) {
                    jSONObject = JSONObject.fromObject((Object)string6);
                }
                if (jSONObject != null) {
                    string6 = this.gson.toJson((Object)jSONObject);
                }
                this.sop("Error: Failed to get Zendesk organizations ...|API URL: " + string4 + " Details-> " + string6);
                if (!this.enableDetailedLog.equalsIgnoreCase("true") || !this.enableOrganizationLog.equalsIgnoreCase("true")) continue;
                this.sop("Status Code:" + n3 + "\n");
                this.sop("Response:\n" + string6);
            } while (bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            closeableHttpClient.getConnectionManager().shutdown();
        }
        if (this.enableDetailedLog.equalsIgnoreCase("true")) {
            this.sop("Organization Map send for referring:\n" + hashtable + "  size " + hashtable.size());
        }
        return hashtable;
    }

    public Hashtable getZendeskZoneList() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = "ZENDESK_ZONE_MAPPING";
        String[] stringArray = this.servicesIni.getVariables(string);
        String string2 = "";
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = this.servicesIni.getValue(string, stringArray[i]);
                if (!StringUtils.isNull((String)string6) && string6.indexOf("#") > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, "#");
                    if (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken().toString().trim();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken().toString().trim();
                    }
                    if (this.organizationMap.get(string3) != null) {
                        string5 = this.organizationMap.get(string3).toString().trim();
                    }
                    if (this.userMap.get(string5 + "#" + string4) != null) {
                        string2 = this.userMap.get(string5 + "#" + string4).toString().trim();
                    } else if (this.userMap.get(string4) != null) {
                        string2 = this.userMap.get(string4).toString().trim();
                    }
                }
                if (StringUtils.isNull((String)string5) || StringUtils.isNull((String)string2)) continue;
                string6 = string5 + "#" + string2;
                hashtable.put(stringArray[i], string6.trim());
            }
            if (this.enableDetailedLog.equalsIgnoreCase("true")) {
                this.sop("Zendesk Details Map for each Zone:\n" + hashtable);
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getCustomFieldList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        try {
            String string6 = this.username + ":" + this.password;
            byte[] byArray = Base64.encodeBase64((byte[])string6.getBytes(Charset.forName("US-ASCII")));
            String string7 = "Basic " + new String(byArray);
            String string8 = "https";
            String string9 = this.apiUrl;
            int n = string9.indexOf(":");
            string9 = string9.replace("tickets", "ticket_fields");
            if (string9 != null && n > 0 && string9.length() > n + 3) {
                string8 = string9.substring(0, n);
            }
            if (string8 != null && string8.equalsIgnoreCase("https")) {
                this.doTheSSL();
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.CONNECTION_TIMEOUT_MS).setConnectTimeout(this.CONNECTION_TIMEOUT_MS).setSocketTimeout(this.CONNECTION_TIMEOUT_MS).build();
            HttpGet httpGet = new HttpGet(string9);
            httpGet.setHeader("Authorization", string7);
            httpGet.setConfig(requestConfig);
            HttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            int n2 = httpResponse.getStatusLine().getStatusCode();
            String string10 = this.getResponseData(httpResponse);
            if (n2 == 201 || n2 == 200) {
                if (this.enableDetailedLog.equalsIgnoreCase("true") && this.enableticketfieldsLog.equalsIgnoreCase("true")) {
                    this.sop("getCustomFieldList ReqURL : " + string9);
                    this.sop("JSON Data received for Custom Field List:\n" + string10);
                }
                if (!StringUtils.isNull((String)string10) && string10.startsWith("{")) {
                    jSONObject2 = JSONObject.fromObject((Object)string10);
                }
                if (jSONObject2.get("ticket_fields") != null) {
                    jSONArray = (JSONArray)jSONObject2.get("ticket_fields");
                    if (!StringUtils.isNull((String)this.customPayload)) {
                        StringTokenizer stringTokenizer = new StringTokenizer(this.customPayload, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken().toString().trim();
                            if (string.indexOf(":") > 0) {
                                StringTokenizer stringTokenizer2 = new StringTokenizer(string, ":");
                                if (stringTokenizer2.hasMoreTokens()) {
                                    string2 = stringTokenizer2.nextToken().toString().trim();
                                }
                                if (stringTokenizer2.hasMoreTokens()) {
                                    string5 = stringTokenizer2.nextToken().toString().trim();
                                }
                            }
                            block6: for (int i = 0; i < jSONArray.size(); ++i) {
                                String string11;
                                String string12;
                                jSONObject = (JSONObject)jSONArray.get(i);
                                if (jSONObject == null || jSONObject.get("title") == null || jSONObject.get("custom_field_options") == null || jSONObject.get("type") == null || StringUtils.isNull((String)(string12 = jSONObject.get("type").toString().trim())) || !string12.equalsIgnoreCase("tagger") || StringUtils.isNull((String)(string11 = jSONObject.get("title").toString().trim())) || !string11.equalsIgnoreCase(string2.trim())) continue;
                                string3 = jSONObject.get("id").toString().trim();
                                JSONArray jSONArray2 = (JSONArray)jSONObject.get("custom_field_options");
                                JSONObject jSONObject3 = new JSONObject();
                                for (int j = 0; j < jSONArray2.size(); ++j) {
                                    String string13;
                                    jSONObject3 = (JSONObject)jSONArray2.get(j);
                                    if (jSONObject3 == null || StringUtils.isNull((String)(string13 = jSONObject3.get("name").toString().trim())) || !string13.equalsIgnoreCase(string5.trim())) continue;
                                    string4 = jSONObject3.get("value").toString().trim();
                                    if (StringUtils.isNull((String)string3) || StringUtils.isNull((String)string4)) continue block6;
                                    arrayList.add(string3 + "#" + string4);
                                    continue block6;
                                }
                            }
                        }
                    }
                }
            } else {
                if (!StringUtils.isNull((String)string10) && string10.startsWith("{")) {
                    jSONObject2 = JSONObject.fromObject((Object)string10);
                }
                if (jSONObject2 != null) {
                    string10 = this.gson.toJson((Object)jSONObject2);
                }
                this.sop("Error: Failed to get Custom Field List ...|API URL: " + string9 + " Details-> " + string10);
                if (this.enableDetailedLog.equalsIgnoreCase("true") && this.enableticketfieldsLog.equalsIgnoreCase("true")) {
                    this.sop("Status Code:" + n2 + "\n");
                    this.sop("Response:\n" + string10);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            closeableHttpClient.getConnectionManager().shutdown();
        }
        if (this.enableDetailedLog.equalsIgnoreCase("true")) {
            this.sop("Custom Field List send for referring:\n" + arrayList);
        }
        return arrayList;
    }
}

