/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.model;

import com.oracle.ovm.mgr.ws.model.BaseObject;
import com.oracle.ovm.mgr.ws.model.Id;
import com.oracle.ovm.mgr.ws.model.JobError;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Job
extends BaseObject<Job> {
    private Id resultId;
    private JobRunState jobRunState = JobRunState.NONE;
    private JobRunState jobSummaryState = JobRunState.NONE;
    private boolean done = false;
    private boolean summaryDone = false;
    private boolean jobGroup = false;
    private JobError error;
    private String progressMessage;
    private String extraInfo;
    private Id<Job> parentJobId;
    private List<Id<Job>> childJobIds;
    private String user;
    private String abortedByUser;
    private Long startTime;
    private Long endTime;

    public void setResultId(Id resultId) {
        this.resultId = resultId;
    }

    public Id getResultId() {
        return this.resultId;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setSummaryDone(boolean summaryDone) {
        this.summaryDone = summaryDone;
    }

    public boolean isSummaryDone() {
        return this.summaryDone;
    }

    public void setJobGroup(boolean jobGroup) {
        this.jobGroup = jobGroup;
    }

    public boolean isJobGroup() {
        return this.jobGroup;
    }

    public void setJobRunState(JobRunState jobRunState) {
        this.jobRunState = jobRunState;
        this.done = jobRunState.equals((Object)JobRunState.FAILURE) || jobRunState.equals((Object)JobRunState.SUCCESS);
    }

    public JobRunState getJobRunState() {
        return this.jobRunState;
    }

    public void setJobSummaryState(JobRunState jobSummaryState) {
        this.jobSummaryState = jobSummaryState;
        this.summaryDone = jobSummaryState.equals((Object)JobRunState.FAILURE) || jobSummaryState.equals((Object)JobRunState.SUCCESS);
    }

    public JobRunState getJobSummaryState() {
        return this.jobSummaryState;
    }

    public JobError getError() {
        return this.error;
    }

    public void setError(JobError error) {
        this.error = error;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setAbortedByUser(String user) {
        this.abortedByUser = user;
    }

    public String getAbortedByUser() {
        return this.abortedByUser;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setParentJobId(Id<Job> parentJobId) {
        this.parentJobId = parentJobId;
    }

    public Id<Job> getParentJobId() {
        return this.parentJobId;
    }

    public void setChildJobIds(List<Id<Job>> childJobIds) {
        this.childJobIds = childJobIds;
    }

    public List<Id<Job>> getChildJobIds() {
        return this.childJobIds;
    }

    public void setProgressMessage(String progressMessage) {
        this.progressMessage = progressMessage;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public static enum JobRunState {
        NONE,
        CREATED,
        RUNNING,
        SUCCESS,
        FAILURE,
        CHILD_QUEUED,
        CHILD_RUNNING;

    }
}

