/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.client;

import com.oracle.ovm.mgr.ws.OvmUtilities;
import com.oracle.ovm.mgr.ws.WsException_Exception;
import com.oracle.ovm.mgr.ws.client.OvmWsUtilitiesClient;
import com.oracle.ovm.mgr.ws.model.ArchiveManagementAttributes;
import com.oracle.ovm.mgr.ws.model.BackupManagementAttributes;
import com.oracle.ovm.mgr.ws.model.BaseObject;
import com.oracle.ovm.mgr.ws.model.BusinessSelection;
import com.oracle.ovm.mgr.ws.model.CloneTargetType;
import com.oracle.ovm.mgr.ws.model.CloneType;
import com.oracle.ovm.mgr.ws.model.Cluster;
import com.oracle.ovm.mgr.ws.model.ClusterStorageFs;
import com.oracle.ovm.mgr.ws.model.EthernetPort;
import com.oracle.ovm.mgr.ws.model.EventManagementAttributes;
import com.oracle.ovm.mgr.ws.model.FileServer;
import com.oracle.ovm.mgr.ws.model.FileSystem;
import com.oracle.ovm.mgr.ws.model.Hypervisor;
import com.oracle.ovm.mgr.ws.model.Id;
import com.oracle.ovm.mgr.ws.model.Job;
import com.oracle.ovm.mgr.ws.model.JobManagementAttributes;
import com.oracle.ovm.mgr.ws.model.LoggerManagementAttributes;
import com.oracle.ovm.mgr.ws.model.LoginCertificate;
import com.oracle.ovm.mgr.ws.model.MacManagementAttributes;
import com.oracle.ovm.mgr.ws.model.Network;
import com.oracle.ovm.mgr.ws.model.PeriodicTask;
import com.oracle.ovm.mgr.ws.model.Repository;
import com.oracle.ovm.mgr.ws.model.Server;
import com.oracle.ovm.mgr.ws.model.ServerEventAttributes;
import com.oracle.ovm.mgr.ws.model.ServerPool;
import com.oracle.ovm.mgr.ws.model.StatisticsManagementAttributes;
import com.oracle.ovm.mgr.ws.model.StorageArray;
import com.oracle.ovm.mgr.ws.model.StorageElement;
import com.oracle.ovm.mgr.ws.model.StorageUse;
import com.oracle.ovm.mgr.ws.model.Vm;
import com.oracle.ovm.mgr.ws.model.VmCloneDefinition;
import com.oracle.ovm.mgr.ws.model.VolumeGroup;
import com.oracle.ovm.mgr.ws.model.WsException;
import java.util.List;
import javax.xml.ws.BindingProvider;

public class OvmWsUtilitiesSoapClient
implements OvmWsUtilitiesClient {
    private final OvmUtilities api;

    public OvmWsUtilitiesSoapClient(OvmUtilities utilityApi) {
        this.api = utilityApi;
    }

    public BindingProvider getBindingProvider() {
        return (BindingProvider)this.api;
    }

    @Override
    public BusinessSelection<EthernetPort> utilGetAvailableEthernetPorts(Id<Server> serverId, Id<Network> networkId) throws WsException {
        try {
            return this.api.utilGetAvailableEthernetPorts(serverId, networkId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<FileSystem> utilGetAvailableFileSystems(Id<FileServer> fileServerId, StorageUse intendedUse) throws WsException {
        try {
            return this.api.utilGetAvailableFileSystems(fileServerId, intendedUse);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Network> utilGetAvailableNetworksForVm(Id<Vm> vmId) throws WsException {
        try {
            return this.api.utilGetAvailableNetworksForVm(vmId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<Id<Repository>> utilGetAvailableRepositoriesForExport(Id<Server> serverId) throws WsException {
        try {
            return this.api.utilGetAvailableRepositoriesForExport(serverId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetAvailableServers() throws WsException {
        try {
            return this.api.utilGetAvailableServers();
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetAvailableServersForRepository(Id<Repository> repositoryId) throws WsException {
        try {
            return this.api.utilGetAvailableServersForRepository(repositoryId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetAvailableServersForServerPool(Id<ServerPool> serverPoolId, Server.ProcessorType cpuArchitectureType, Hypervisor.HypervisorType hypervisorType) throws WsException {
        try {
            return this.api.utilGetAvailableServersForServerPool(serverPoolId, cpuArchitectureType, hypervisorType);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetAvailableServersForVm(Id<Vm> vmId, List<Id<Server>> serverIds) throws WsException {
        try {
            return this.api.utilGetAvailableServersForVm(vmId, serverIds);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Repository> utilGetAvailableRepositoriesForVm(Id<Vm> vmId) throws WsException {
        try {
            return this.api.utilGetAvailableRepositoriesForVm(vmId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetAvailableServersForVmClone(Id<Vm> vmId, Id<VmCloneDefinition> vmCloneDefinitionId, Id<Repository> targetRepositoryId, List<Id<Server>> serverIds) throws WsException {
        try {
            return this.api.utilGetAvailableServersForVmClone(vmId, vmCloneDefinitionId, targetRepositoryId, serverIds);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<ServerPool> utilGetAvailableServerPoolsForVmClone(Id<Vm> vmId, Id<VmCloneDefinition> vmCloneDefinitionId, Id<Repository> targetRepositoryId) throws WsException {
        try {
            return this.api.utilGetAvailableServerPoolsForVmClone(vmId, vmCloneDefinitionId, targetRepositoryId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<StorageElement> utilGetAvailableStorageElements(List<Id<StorageElement>> candidateStorageElementIds, StorageUse intendedUse) throws WsException {
        try {
            return this.api.utilGetAvailableStorageElements(candidateStorageElementIds, intendedUse);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<StorageElement> utilGetAvailableStorageElementsForVm(Id<Vm> vmId) throws WsException {
        try {
            return this.api.utilGetAvailableStorageElementsForVm(vmId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<? extends BaseObject> utilGetCloneTargets(Id<Vm> vmId, Id<?> sourceDiskId, CloneTargetType targetType) throws WsException {
        try {
            return this.api.utilGetCloneTargets(vmId, sourceDiskId, targetType);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<CloneType> utilGetCloneTypes(Id<?> sourceDiskId, Id<?> cloneTargetId) throws WsException {
        try {
            return this.api.utilGetCloneTypes(sourceDiskId, cloneTargetId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<Id<FileSystem>> utilGetClusteredFileSystems() throws WsException {
        try {
            return this.api.utilGetClusteredFileSystems();
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<Id<ServerPool>> utilGetClusteredServerPools() throws WsException {
        try {
            return this.api.utilGetClusteredServerPools();
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<Id<ClusterStorageFs>> utilGetClusterStorageFs(Id<Cluster> clusterId) throws WsException {
        try {
            return this.api.utilGetClusterStorageFs(clusterId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<Id<?>> utilGetEthernetDevicesWithIpAddress(String ipAddress) throws WsException {
        try {
            return this.api.utilGetEthernetDevicesWithIpAddress(ipAddress);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<Id<FileSystem>> utilGetLocalFileSystems() throws WsException {
        try {
            return this.api.utilGetLocalFileSystems();
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<Id<Network>> utilGetNetworksOnServers(List<Id<Server>> serverIds) throws WsException {
        try {
            return this.api.utilGetNetworksOnServers(serverIds);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<Id<Server>> utilGetServersByStorageElement(Id<StorageElement> storageElementId) throws WsException {
        try {
            return this.api.utilGetServersByStorageElement(storageElementId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<StorageArray> utilGetStorageArraysWithAvailableStorageElements(Id<ServerPool> serverPoolId, StorageUse intendedUse) throws WsException {
        try {
            return this.api.utilGetStorageArraysWithAvailableStorageElements(serverPoolId, intendedUse);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<VolumeGroup> utilGetVolumeGroupsWithAvailableStorageElements(Id<StorageArray> storageArrayId, StorageUse intendedUse) throws WsException {
        try {
            return this.api.utilGetVolumeGroupsWithAvailableStorageElements(storageArrayId, intendedUse);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetWorkerServersForFileServer(Id<FileServer> fileServerId) throws WsException {
        try {
            return this.api.utilGetWorkerServersForFileServer(fileServerId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetWorkerServersForFileSystem(Id<FileSystem> fileSystemId) throws WsException {
        try {
            return this.api.utilGetWorkerServersForFileSystem(fileSystemId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetWorkerServersForRepository(Id<Repository> repositoryId) throws WsException {
        try {
            return this.api.utilGetWorkerServersForRepository(repositoryId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public Id<Server> utilGetWorkerServerForServerPool(Id<ServerPool> serverPoolId) throws WsException {
        try {
            return this.api.utilGetWorkerServerForServerPool(serverPoolId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetWorkerServersForStorageArray(Id<StorageArray> storageArrayId) throws WsException {
        try {
            return this.api.utilGetWorkerServersForStorageArray(storageArrayId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public boolean utilIsThinCloneSupported(Id<?> cloneTargetId) throws WsException {
        try {
            return this.api.utilIsThinCloneSupported(cloneTargetId);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public StatisticsManagementAttributes statisticsManagementAttributesGet() throws WsException {
        try {
            return this.api.statisticsManagementAttributesGet();
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public Job statisticsManagementAttributesModify(StatisticsManagementAttributes attributes) throws WsException {
        try {
            return this.api.statisticsManagementAttributesModify(attributes);
        }
        catch (WsException_Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public MacManagementAttributes macManagementAttributesGet() throws WsException {
        try {
            return this.api.macManagementAttributesGet();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job macManagementAttributesModify(MacManagementAttributes macAttributes) throws WsException {
        try {
            return this.api.macManagementAttributesModify(macAttributes);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    private WsException convertException(WsException_Exception ex) {
        return new WsException(ex.getFaultInfo().getErrorDetails());
    }

    @Override
    public ArchiveManagementAttributes archiveManagementAttributesGet() throws WsException {
        try {
            return this.api.archiveManagementAttributesGet();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job archiveManagementAttributesModify(ArchiveManagementAttributes archiveAttributes) throws WsException {
        try {
            return this.api.archiveManagementAttributesModify(archiveAttributes);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BackupManagementAttributes backupManagementAttributesGet() throws WsException {
        try {
            return this.api.backupManagementAttributesGet();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<String> backupManagementGetAvailableBackups() throws WsException {
        try {
            return this.api.backupManagementGetAvailableBackups();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job backupManagementStartBackup(String location) throws WsException {
        try {
            return this.api.backupManagementStartBackup(location);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job backupManagementCleanupOldBackups(int numToKeep) throws WsException {
        try {
            return this.api.backupManagementCleanupOldBackups(numToKeep);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job modelManagementExportModelData() throws WsException {
        try {
            return this.api.modelManagementExportModelData();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job modelManagementCleanupOldExportedModelData(int numToKeep) throws WsException {
        try {
            return this.api.modelManagementCleanupOldExportedModelData(numToKeep);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public EventManagementAttributes eventManagementAttributesGet() throws WsException {
        try {
            return this.api.eventManagementAttributesGet();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job eventManagementAttributesModify(EventManagementAttributes attributes) throws WsException {
        try {
            return this.api.eventManagementAttributesModify(attributes);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ServerEventAttributes eventManagementServerAttributesGet(Id<Server> serverId) throws WsException {
        try {
            return this.api.eventManagementServerAttributesGet(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job eventManagementServerAttributesModify(Id<Server> serverId, ServerEventAttributes attributes) throws WsException {
        try {
            return this.api.eventManagementServerAttributesModify(serverId, attributes);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job jobManagementAttributesModify(JobManagementAttributes jobAttributes) throws WsException {
        try {
            return this.api.jobManagementAttributesModify(jobAttributes);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public JobManagementAttributes jobManagementAttributesGet() throws WsException {
        try {
            return this.api.jobManagementAttributesGet();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Id<Job> jobManagementGetLockingJob(Id<? extends BaseObject> objectId) throws WsException {
        try {
            return this.api.jobManagementGetLockingJob(objectId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<LoggerManagementAttributes> loggerManagementAttributesGet(String name) throws WsException {
        try {
            return this.api.loggerManagementAttributesGet(name);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job loggerManagementAttributesModify(List<LoggerManagementAttributes> loggerAttributes) throws WsException {
        try {
            return this.api.loggerManagementAttributesModify(loggerAttributes);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public String rasManagementGenerateUniqueSessionId() throws WsException {
        try {
            return this.api.rasManagementGenerateUniqueSessionId();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<PeriodicTask> periodicTaskGetAll() throws WsException {
        try {
            return this.api.periodicTaskGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public PeriodicTask periodicTaskGetById(Id<PeriodicTask> periodicTaskId) throws WsException {
        try {
            return this.api.periodicTaskGetById(periodicTaskId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<PeriodicTask>> periodicTaskGetIds() throws WsException {
        try {
            return this.api.periodicTaskGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<PeriodicTask> periodicTaskGetListById(List<Id<PeriodicTask>> periodicTaskIds) throws WsException {
        try {
            return this.api.periodicTaskGetListById(periodicTaskIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job periodicTaskResetToDefaults(Id<PeriodicTask> periodicTaskId) throws WsException {
        try {
            return this.api.periodicTaskResetToDefaults(periodicTaskId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job periodicTaskModify(PeriodicTask periodicTask) throws WsException {
        try {
            return this.api.periodicTaskModify(periodicTask);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job modelManagementRefreshModel() throws WsException {
        try {
            return this.api.modelManagementRefreshModel();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<LoginCertificate> certificateGetAll() throws WsException {
        try {
            return this.api.certificateGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public LoginCertificate certificateCreate() throws WsException {
        try {
            return this.api.certificateCreate();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void certificateRegister(LoginCertificate certificate) throws WsException {
        try {
            this.api.certificateRegister(certificate);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public LoginCertificate certificateSignAndRegister(LoginCertificate certificate) throws WsException {
        try {
            return this.api.certificateSignAndRegister(certificate);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void certificateUnregister(String certificateFingerprint) throws WsException {
        try {
            this.api.certificateUnregister(certificateFingerprint);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public String certificateGetCaCertificate() throws WsException {
        try {
            return this.api.certificateGetCaCertificate();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }
}

