/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartApplet;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.LineChart;
import com.objectplanet.chart.PieChart;
import com.objectplanet.chart.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChartDataLoader {
    private String[] for = new String[]{"rangestep", "range", "lowerrange", "rangeadjusteron", "currentrange", "currentlowerrange"};
    protected BarChart barChart;
    protected LineChart lineChart;
    protected PieChart pieChart;
    protected Chart theChart;
    protected String chartType;
    private boolean a;
    private double[] do;
    protected String labelDelimiter = ",";
    protected String valueDelimiter = ",";
    protected Hashtable targets;
    protected Hashtable labels;
    protected Hashtable labelURLs;
    protected Hashtable labelURLTargets;
    Hashtable if;

    public ChartDataLoader() {
        this.init();
    }

    public void addChartItemListener(ChartApplet chartApplet) {
    }

    public void init() {
        this.do = new double[25];
        for (int i = 0; i < 25; ++i) {
            this.do[i] = -1.0;
        }
        this.targets = new Hashtable();
        this.labels = new Hashtable();
        this.labelURLs = new Hashtable();
        this.labelURLTargets = new Hashtable();
        this.labelURLTargets.put("urltarget", "_self");
        this.if = new Hashtable();
    }

    public void reset() {
        this.labelURLs.clear();
        this.labelURLTargets.clear();
        this.labelURLTargets.put("urltarget", "_self");
        this.if.clear();
    }

    public void setChartType(String string) {
        this.chartType = string;
    }

    public String getChartType() {
        return this.chartType;
    }

    public Component setChart(Component component) {
        this.theChart = (Chart)component;
        if (this.chartType != null && this.chartType.equals("line")) {
            this.lineChart = (LineChart)component;
        } else if (this.chartType != null && this.chartType.equals("pie")) {
            this.pieChart = (PieChart)component;
        } else if (this.chartType != null && this.chartType.equals("bar")) {
            this.barChart = (BarChart)component;
        }
        return component;
    }

    public Chart getChart() {
        return this.theChart;
    }

    protected GenericChart createExtChart(String string) {
        return null;
    }

    public ChartDataLoader getOverlayDataLoader(String string) {
        return (ChartDataLoader)this.if.get(string);
    }

    public void setParameters(Hashtable hashtable) {
        String string;
        Double[] doubleArray;
        if (hashtable == null) {
            return;
        }
        if (hashtable.get("chart") != null) {
            this.setParameter("chart", (String)hashtable.get("chart"));
        }
        if (hashtable.get("overlay") != null) {
            this.setParameter("overlay", (String)hashtable.get("overlay"));
        }
        if (hashtable.get("overlay_seriescount") != null) {
            this.setParameter("overlay_seriesCount", (String)hashtable.get("overlay_seriescount"));
        }
        if (hashtable.get("overlay0") != null) {
            this.setParameter("overlay0", (String)hashtable.get("overlay0"));
        }
        if (hashtable.get("overlay0_seriescount") != null) {
            this.setParameter("overlay0_seriesCount", (String)hashtable.get("overlay0_seriescount"));
        }
        int n = 1;
        while (hashtable.get("overlay" + n) != null) {
            this.setParameter("overlay" + n, (String)hashtable.get("overlay" + n));
            if (hashtable.get("overlay" + n + "_seriescount") != null) {
                this.setParameter("overlay" + n + "_seriescount", (String)hashtable.get("overlay" + n + "_seriescount"));
            }
            ++n;
        }
        int n2 = 1;
        if (hashtable.containsKey("seriescount")) {
            this.setParameter("seriesCount", (String)hashtable.get("seriescount"));
            n2 = this.theChart.getSeriesCount();
        }
        if (hashtable.containsKey("chartbackground")) {
            this.setParameter("chartBackground", (String)hashtable.get("chartbackground"));
        }
        if (hashtable.get("valuedelimiter") != null) {
            this.setParameter("valueDelimiter", (String)hashtable.get("valuedelimiter"));
            hashtable.remove("valuedelimiter");
        }
        int n3 = 1;
        if (hashtable.get("samplecount") != null) {
            try {
                String string2 = (String)hashtable.get("samplecount");
                n3 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                System.out.println("Invalid sampleCount " + hashtable.get("samplecount"));
            }
        } else if (n2 == 1 && hashtable.get("samplevalues") != null) {
            Double[] doubleArray2 = ChartDataLoader.getDoubleValues((String)hashtable.get("samplevalues"), this.valueDelimiter);
            n3 = Math.max(doubleArray2 != null ? doubleArray2.length : 0, n3);
        } else {
            for (int i = 0; i < n2; ++i) {
                if (hashtable.get("samplevalues_" + i) == null) continue;
                doubleArray = ChartDataLoader.getDoubleValues((String)hashtable.get("samplevalues_" + i), this.valueDelimiter);
                n3 = Math.max(doubleArray != null ? doubleArray.length : 0, n3);
            }
        }
        this.theChart.setSampleCount(n3);
        String string3 = (String)hashtable.get("samplecount");
        doubleArray = (Double[])hashtable.get("seriescount");
        Hashtable hashtable2 = new Hashtable();
        for (int i = 0; i < this.for.length; ++i) {
            for (int j = 0; j < 25; ++j) {
                string = this.for[i];
                if (j > 0) {
                    string = this.for[i] + "_" + j;
                }
                if (!hashtable.containsKey(string)) continue;
                hashtable2.put(string, hashtable.remove(string));
            }
        }
        if (hashtable.get("labeldelimiter") != null) {
            this.setParameter("labelDelimiter", (String)hashtable.get("labeldelimiter"));
            hashtable.remove("labeldelimiter");
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            string = (String)hashtable.get(string4);
            this.setParameter(string4, string);
        }
        for (int i = 0; i < this.for.length; ++i) {
            for (int j = 0; j < 25; ++j) {
                String string5 = this.for[i];
                if (j > 0) {
                    string5 = string5 + "_" + j;
                }
                String string6 = (String)hashtable2.get(string5);
                if (!this.theChart.isRangeOn(j - 1) || j == 1 && string6 == null) continue;
                this.setParameter(string5, string6);
                if (string6 == null) continue;
                hashtable.put(string5, string6);
            }
        }
        if (string3 != null) {
            hashtable.put("samplecount", string3);
        }
        if (doubleArray != null) {
            hashtable.put("seriescount", doubleArray);
        }
    }

    public void setParameter(String string, String string2) {
        block802: {
            if (string == null) {
                return;
            }
            string = string.toLowerCase();
            if (this.theChart == null) {
                throw new IllegalStateException("theChart has not been set");
            }
            if (string.equals("overlayinsets")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Double[] doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter);
                    if (doubleArray != null) {
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        double d4 = 0.0;
                        try {
                            if (doubleArray.length > 0) {
                                d = doubleArray[0];
                            }
                            if (doubleArray.length > 1) {
                                d2 = doubleArray[1];
                            }
                            if (doubleArray.length > 2) {
                                d3 = doubleArray[2];
                            }
                            if (doubleArray.length > 3) {
                                d4 = doubleArray[3];
                            }
                            this.theChart.setOverlayInsets(d, d2, d3, d4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid overlayInsets: " + string2);
                        }
                    }
                } else {
                    this.theChart.setOverlayInsets(0.0, 0.0, 0.0, 0.0);
                }
            } else if (string.startsWith("overlay")) {
                int n = string.indexOf("_");
                if (n > -1) {
                    String string3 = string.substring(0, n).toLowerCase();
                    ChartDataLoader chartDataLoader = (ChartDataLoader)this.if.get(string3);
                    if (chartDataLoader != null) {
                        String string4 = string.substring(n + 1);
                        chartDataLoader.setParameter(string4, string2);
                    }
                } else if (!this.if.containsKey(string)) {
                    if (string2 != null) {
                        ChartDataLoader chartDataLoader = null;
                        GenericChart genericChart = null;
                        if ((string2 = string2.toLowerCase()) != null) {
                            if (string2.equals("bar") || string2.equals("line") || string2.equals("pie") || string2.equals("time_line") || string2.equals("spline") || string2.equals("plotter")) {
                                LineChart lineChart = new LineChart();
                                BarChart barChart = new BarChart();
                                PieChart pieChart = new PieChart();
                                if (string2.equals("spline") || string2.equals("time_line")) {
                                    chartDataLoader = ChartApplet.if();
                                    if (chartDataLoader == null) {
                                        chartDataLoader = new ChartDataLoader();
                                    }
                                    chartDataLoader.setChartType(string2);
                                    genericChart = (GenericChart)chartDataLoader.setChart(null);
                                    lineChart = (LineChart)genericChart;
                                } else if (string2.equals("plotter")) {
                                    chartDataLoader = ChartApplet.if();
                                    if (chartDataLoader == null) {
                                        chartDataLoader = new ChartDataLoader();
                                    }
                                    chartDataLoader.setChartType(string2);
                                    genericChart = (GenericChart)chartDataLoader.setChart(null);
                                } else if (string2.equals("line")) {
                                    genericChart = lineChart;
                                } else if (string2.equals("bar")) {
                                    genericChart = barChart;
                                } else if (string2.equals("pie")) {
                                    genericChart = pieChart;
                                }
                                if (string2.equals("bar") || string2.equals("line") || string2.equals("pie")) {
                                    chartDataLoader = new ChartDataLoader();
                                    chartDataLoader.setChartType(string2);
                                    chartDataLoader.setChart(genericChart);
                                }
                                chartDataLoader.lineChart = lineChart;
                                chartDataLoader.barChart = barChart;
                                chartDataLoader.pieChart = pieChart;
                            } else {
                                System.out.println("Invalid overlay: " + string + " " + string2);
                            }
                        }
                        if (chartDataLoader != null) {
                            this.if.put(string, chartDataLoader);
                            this.theChart.addOverlayChart(genericChart);
                        }
                    } else {
                        this.if.remove(string);
                    }
                }
            } else if (string.equals("width")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        int n = Integer.parseInt(string2.trim());
                        this.theChart.setSize(n, this.theChart.getSize().height);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid width: " + string2);
                    }
                }
            } else if (string.equals("height")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        int n = Integer.parseInt(string2.trim());
                        this.theChart.setSize(this.theChart.getSize().width, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid height: " + string2);
                    }
                }
            } else if (string.startsWith("samplevalues")) {
                try {
                    int n = 0;
                    if (string.startsWith("samplevalues_")) {
                        n = Integer.parseInt(string.substring(13));
                    }
                    if (string2 != null && string2.trim().length() > 0) {
                        Double[] doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter);
                        if (doubleArray != null && n >= 0 && n < this.theChart.getSeriesCount()) {
                            int n2 = this.theChart.getSampleCount();
                            if (!this.a && doubleArray.length > n2) {
                                this.theChart.setSampleCount(doubleArray.length);
                                n2 = doubleArray.length;
                            }
                            for (int i = 0; i < n2; ++i) {
                                if (i < doubleArray.length && doubleArray[i] != null) {
                                    this.theChart.setSampleValue(n, i, doubleArray[i]);
                                    continue;
                                }
                                ChartSample chartSample = this.theChart.getSample(n, i);
                                if (chartSample == null) continue;
                                chartSample.clearValue();
                            }
                        }
                    } else if (n >= 0 && n < this.theChart.getSeriesCount()) {
                        this.theChart.setSampleValues(n, null);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid " + string + " " + string2);
                }
            } else if (string.equals("samplecount")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.theChart.setSampleCount(Math.max(0, Integer.parseInt(string2.trim())));
                        this.a = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid sampleCount: " + string2);
                    }
                }
            } else if (string.equals("samplecolors")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    Color color;
                    String string5 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "|");
                    if (stringTokenizer2.hasMoreTokens()) {
                        color = ChartDataLoader.createColor(((String)stringTokenizer2.nextElement()).trim());
                        if (color != null) {
                            this.theChart.setSampleColor(n, color);
                        } else {
                            this.theChart.setSampleColor(n, null);
                        }
                    }
                    if (stringTokenizer2.hasMoreTokens()) {
                        color = ChartDataLoader.createColor(((String)stringTokenizer2.nextElement()).trim());
                        if (color != null) {
                            this.theChart.setSampleColor2(n, color);
                        } else {
                            this.theChart.setSampleColor2(n, null);
                        }
                    }
                    ++n;
                }
            } else if (string.equals("legendcolors")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color[] colorArray = this.getColorValues(string2);
                    this.theChart.setLegendColors(colorArray);
                } else {
                    this.theChart.setLegendColors(null);
                }
            } else if (string.equals("seriescount")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.theChart.setSeriesCount(Math.max(1, Integer.parseInt(string2.trim())));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid seriesCount: " + string2);
                    }
                } else {
                    this.theChart.setSeriesCount(1);
                }
            } else if (string.startsWith("seriesrange_")) {
                try {
                    int n = Integer.parseInt(string.substring(12));
                    if (n < 0 || n >= this.theChart.getSeriesCount()) break block802;
                    if (string2 != null && string2.length() > 0) {
                        try {
                            int n3 = Math.max(Integer.parseInt(string2.trim()) - 1, 0);
                            this.theChart.setSeriesRange(n, n3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid range index: " + string + " " + string2);
                        }
                        break block802;
                    }
                    this.theChart.setSeriesRange(n, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid series index: " + string + " " + string2);
                }
            } else if (string.startsWith("rangestep")) {
                int n = 0;
                if (!string.equalsIgnoreCase("rangestep")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.do[n] = new Double(string2.trim());
                        this.do[n] = Math.abs(this.do[n]);
                        this.theChart.setRelativeRange(n, 1.0, this.do[n]);
                        this.theChart.setLowerRelativeRange(n, 1.0, this.do[n]);
                        break block802;
                    }
                    this.do[n] = -1.0;
                    this.theChart.a(n, 1.0);
                    this.theChart.if(n, 1.0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid rangeStep: " + string2);
                    this.do[n] = -1.0;
                    this.theChart.setLowerRelativeRange(1.0);
                }
            } else if (string.equals("range") || string.startsWith("range_")) {
                int n = 0;
                if (!string.equalsIgnoreCase("range")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setRange(n, new Double(string2.trim()));
                        break block802;
                    }
                    if (this.do[n] > -1.0) {
                        this.theChart.setRelativeRange(n, 1.0, this.do[n]);
                        break block802;
                    }
                    this.theChart.a(n, 1.0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid range: " + string2);
                    if (this.do[n] != -1.0) {
                        this.theChart.setRelativeRange(n, 1.0, this.do[n]);
                        break block802;
                    }
                    this.theChart.a(n, 1.0);
                }
            } else if (string.startsWith("lowerrange")) {
                int n = 0;
                if (!string.equalsIgnoreCase("lowerrange")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setLowerRange(n, new Double(string2.trim()));
                        break block802;
                    }
                    if (this.do[n] != -1.0) {
                        this.theChart.setLowerRelativeRange(n, 1.0, this.do[n]);
                        break block802;
                    }
                    this.theChart.if(n, 1.0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid lowerRange: " + string2);
                    if (this.do[n] > -1.0) {
                        this.theChart.setLowerRelativeRange(n, 1.0, this.do[n]);
                        break block802;
                    }
                    this.theChart.if(n, 1.0);
                }
            } else if (string.equals("currentrange") || string.startsWith("currentrange_")) {
                int n = 0;
                if (!string.equalsIgnoreCase("currentrange")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setCurrentRange(n, new Double(string2.trim()));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid range index: " + string2);
                }
            } else if (string.equals("currentlowerrange") || string.startsWith("currentlowerrange_")) {
                int n = 0;
                if (!string.equalsIgnoreCase("currentlowerrange")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setCurrentLowerRange(n, new Double(string2.trim()));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid range index: " + string2);
                }
            } else if (string.startsWith("rangeinterval")) {
                int n = 0;
                if (!string.equalsIgnoreCase("rangeinterval")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.theChart.setRangeInterval(n, new Double(string2.trim()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid rangeInterval: " + string2);
                    }
                }
            } else if (string.startsWith("rangeon")) {
                int n = 0;
                if (!string.equalsIgnoreCase("rangeon")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setRangeOn(n, string2.trim().equalsIgnoreCase("true"));
                }
            } else if (string.startsWith("rangecolor")) {
                int n = 0;
                if (!string.equalsIgnoreCase("rangecolor")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setRangeColor(n, ChartDataLoader.createColor(string2));
                }
            } else if (string.startsWith("rangeposition")) {
                int n = 0;
                if (!string.equalsIgnoreCase("rangeposition")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                if (string2 != null && string2.trim().length() > 0) {
                    if ((string2 = string2.trim().toLowerCase()).equals("right") || string2.equals("top")) {
                        this.theChart.setRangePosition(n, 1);
                    } else {
                        this.theChart.setRangePosition(n, 0);
                    }
                }
            } else if (string.startsWith("rangeadjusteron")) {
                if (string2 != null) {
                    int n = 0;
                    if (!string.equalsIgnoreCase("rangeadjusteron")) {
                        try {
                            n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid range index: " + string);
                        }
                    }
                    this.theChart.setRangeAdjusterOn(n, string2 != null && string2.trim().equalsIgnoreCase("true"));
                }
            } else if (string.equals("rangeadjusterposition")) {
                if (string2 != null && string2.length() > 0) {
                    if ((string2 = string2.trim().toLowerCase()).equals("right") || string2.equals("top")) {
                        this.theChart.setRangeAdjusterPosition(1);
                    } else {
                        this.theChart.setRangeAdjusterPosition(0);
                    }
                }
            } else if (string.equalsIgnoreCase("rangeAdjusterPosition_2")) {
                System.out.println("rangeAdjusterPosition_2 is deprecated");
            } else if (string.equals("rangeadjusted") || string.startsWith("rangeadjusted_")) {
                int n = 0;
                if (!string.equals("rangeadjusted")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                if (string2 != null && string2.length() > 0) {
                    try {
                        this.theChart.setRangeAdjusted(n, Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.theChart.setRangeAdjusted(n, -1);
                    }
                }
            } else if (string.startsWith("rangedecimalcount")) {
                int n = 0;
                if (!string.equalsIgnoreCase("rangedecimalcount")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                if (string2.equalsIgnoreCase("auto")) {
                    this.theChart.setRangeDecimalCount(n, -1);
                } else {
                    try {
                        if (string2 != null && string2.trim().length() > 0) {
                            this.theChart.setRangeDecimalCount(n, Integer.parseInt(string2.trim()));
                            break block802;
                        }
                        this.theChart.setRangeDecimalCount(n, 0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid " + string + ": " + string2);
                        this.theChart.setRangeDecimalCount(n, 0);
                    }
                }
            } else if (string.equals("labeldelimiter")) {
                this.labelDelimiter = string2 != null && string2.trim().length() > 0 || string2.equals("\t") ? string2 : ",";
            } else if (string.equals("valuedelimiter")) {
                this.valueDelimiter = string2 != null && string2.trim().length() > 0 || string2.equals("\t") ? string2 : ",";
            } else if (string.equals("serieslabels")) {
                this.theChart.setSeriesLabels(this.getStringValues(ChartDataLoader.convertLineBreaks(string2), this.labelDelimiter));
            } else if (string.equals("serieslabelcolors")) {
                Color[] colorArray = this.getColorValues(string2);
                int n = this.theChart.getSeriesCount();
                for (int i = 0; i < n; ++i) {
                    if (colorArray != null && i < colorArray.length) {
                        this.theChart.setSeriesLabelColor(i, colorArray[i]);
                        continue;
                    }
                    this.theChart.setSeriesLabelColor(i, null);
                }
            } else if (string.equals("serieslabelson")) {
                this.theChart.setSeriesLabelsOn(string2 != null && string2.equalsIgnoreCase("true"));
            } else if (string.equals("serieslabelstyle")) {
                this.theChart.setSeriesLabelStyle(3);
                if (!this.chartType.equals("pie")) {
                    this.theChart.setSeriesLabelStyle(1);
                }
                if (string2 != null && string2.trim().length() > 0) {
                    if (string2.trim().equalsIgnoreCase("inside")) {
                        this.theChart.setSeriesLabelStyle(0);
                    } else if (string2.trim().equalsIgnoreCase("floating")) {
                        this.theChart.setSeriesLabelStyle(3);
                    } else if (string2.trim().equalsIgnoreCase("outside")) {
                        this.theChart.setSeriesLabelStyle(1);
                    } else if (string2.trim().equalsIgnoreCase("pointing")) {
                        this.theChart.setSeriesLabelStyle(5);
                    }
                }
            } else if (string.startsWith("serieslabelfont")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont(string, this.createFont(string2, "Arial", 0, 11));
                } else {
                    this.theChart.setFont(string, new Font("Arial", 0, 11));
                }
            } else if (string.equals("samplelabels")) {
                this.theChart.setSampleLabels(this.getStringValues(ChartDataLoader.convertLineBreaks(string2), this.labelDelimiter));
            } else if (string.equals("samplelabelson")) {
                this.theChart.setSampleLabelsOn(string2 != null && string2.equalsIgnoreCase("true"));
            } else if (string.equals("samplelabelcolors")) {
                Color[] colorArray = this.getColorValues(string2);
                int n = Math.max(colorArray != null ? colorArray.length : 0, this.theChart.getSampleCount());
                for (int i = 0; i < n; ++i) {
                    if (colorArray != null && i < colorArray.length) {
                        this.theChart.setSampleLabelColor(i, colorArray[i]);
                        continue;
                    }
                    this.theChart.setSampleLabelColor(i, null);
                }
            } else if (string.equals("samplelabelstyle")) {
                this.theChart.setSampleLabelStyle(2);
                if (this.chartType.equals("pie")) {
                    this.theChart.setSampleLabelStyle(0);
                }
                if (string2 != null && string2.trim().equalsIgnoreCase("outside")) {
                    this.theChart.setSampleLabelStyle(1);
                } else if (string2 != null && string2.trim().equalsIgnoreCase("pointing")) {
                    this.theChart.setSampleLabelStyle(5);
                } else if (string2 != null && string2.trim().equalsIgnoreCase("inside")) {
                    this.theChart.setSampleLabelStyle(0);
                } else if (string2 != null && string2.trim().equalsIgnoreCase("floating")) {
                    this.theChart.setSampleLabelStyle(3);
                } else if (string2 != null && string2.trim().equalsIgnoreCase("below_and_floating")) {
                    this.theChart.setSampleLabelStyle(4);
                }
            } else if (string.equals("samplelabelselectioncolor")) {
                Color color;
                this.theChart.setSampleLabelSelectionColor(null);
                if (string2 != null && string2.trim().length() > 0 && (color = ChartDataLoader.createColor(string2)) != null) {
                    this.theChart.setSampleLabelSelectionColor(color);
                }
            } else if (string.equals("legendlabels")) {
                this.theChart.setLegendLabels(null);
                if (string2 != null && string2.trim().length() > 0) {
                    String[] stringArray = this.getStringValues(ChartDataLoader.convertLineBreaks(string2), this.labelDelimiter);
                    if (stringArray.length > 1) {
                        this.theChart.setLegendLabels(stringArray);
                    } else if (stringArray.length == 1 && stringArray[0] != null) {
                        if (stringArray[0].trim().equalsIgnoreCase("samplelabels")) {
                            this.theChart.setLegendLabels(this.theChart.getSampleLabels());
                        } else if (stringArray[0].trim().equalsIgnoreCase("serieslabels")) {
                            this.theChart.setLegendLabels(this.theChart.getSeriesLabels());
                        } else {
                            this.theChart.setLegendLabels(stringArray);
                        }
                    }
                }
            } else if (string.startsWith("valuelabelson")) {
                if (string.equals("valuelabelson")) {
                    this.theChart.setValueLabelsOn(-1, string2 != null && string2.trim().equalsIgnoreCase("true"));
                } else if (string.startsWith("valuelabelson_")) {
                    try {
                        int n = Integer.parseInt(string.substring(14));
                        if (n >= 0 && n < this.theChart.getSeriesCount()) {
                            this.theChart.setValueLabelsOn(n, string2 != null && string2.trim().equalsIgnoreCase("true"));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid " + string + " " + string2);
                    }
                }
            } else if (string.startsWith("rangeaxislabelangle") || string.equals("sampleaxislabelangle") || string.equals("valuelabelangle") || string.equals("samplelabelangle") || string.equals("barlabelangle")) {
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setLabelAngle(string, Integer.parseInt(string2));
                        break block802;
                    }
                    this.theChart.setLabelAngle(string, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid " + string + ": " + string2);
                }
            } else if (string.equals("valuelabelcolors")) {
                Color[] colorArray = this.getColorValues(string2);
                int n = this.theChart.getSeriesCount();
                for (int i = 0; i < n; ++i) {
                    if (colorArray != null && i < colorArray.length) {
                        this.theChart.setValueLabelColor(i, colorArray[i]);
                        continue;
                    }
                    this.theChart.setValueLabelColor(i, null);
                }
            } else if (string.equals("valuelabelstyle")) {
                this.theChart.setValueLabelStyle(0);
                if (string2 != null && string2.trim().equalsIgnoreCase("outside")) {
                    this.theChart.setValueLabelStyle(1);
                } else if (string2 != null && string2.trim().equalsIgnoreCase("pointing")) {
                    this.theChart.setValueLabelStyle(5);
                } else if (string2 != null && string2.trim().equalsIgnoreCase("floating")) {
                    this.theChart.setValueLabelStyle(3);
                }
            } else if (string.startsWith("valuelabelprefix") || string.startsWith("valuelabelpostfix")) {
                this.theChart.setLabel(string, ChartDataLoader.convertLineBreaks(string2));
            } else if (string.startsWith("sampledecimalcount")) {
                try {
                    int n;
                    if (string.equals("sampledecimalcount")) {
                        if (string2 != null && string2.trim().length() > 0) {
                            if (string2.equalsIgnoreCase("auto")) {
                                this.theChart.setSampleDecimalCount(-1, -1);
                            } else {
                                this.theChart.setSampleDecimalCount(-1, Integer.parseInt(string2.trim()));
                            }
                        } else {
                            this.theChart.setSampleDecimalCount(-1, 0);
                        }
                        break block802;
                    }
                    if (!string.startsWith("sampledecimalcount_") || (n = Integer.parseInt(string.substring(19))) < 0 || n >= this.theChart.getSeriesCount()) break block802;
                    if (string2 != null && string2.trim().length() > 0) {
                        if (string2.equalsIgnoreCase("auto")) {
                            this.theChart.setSampleDecimalCount(n, -1);
                        } else {
                            this.theChart.setSampleDecimalCount(n, Integer.parseInt(string2.trim()));
                        }
                        break block802;
                    }
                    this.theChart.setSampleDecimalCount(n, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid " + string + " " + string2);
                }
            } else if (string.equalsIgnoreCase("thousandsDelimiter") || string.equalsIgnoreCase("thousandsDelimeter")) {
                this.theChart.setThousandsDelimiter(string2);
                if (string.equalsIgnoreCase("thousandsDelimeter")) {
                    System.out.println("thousandsDelimeter is deprecated, use thousandsDelimiter instead");
                }
            } else if (string.equalsIgnoreCase("locale")) {
                if (string2 != null && string2.length() > 0) {
                    String string6;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                    String string7 = string6 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreElements()) {
                        string7 = stringTokenizer.nextToken();
                    }
                    if (this.theChart != null) {
                        if (string7.equalsIgnoreCase("eu")) {
                            this.theChart.setLocale(new Locale(string6.toUpperCase(), string6.toUpperCase(), "EURO"));
                        } else {
                            this.theChart.setLocale(new Locale(string6.toUpperCase(), string7.toUpperCase()));
                        }
                    }
                } else if (this.theChart != null) {
                    this.theChart.setLocale(null);
                }
            } else if (string.equals("charttitle") || string.equals("title")) {
                this.theChart.setTitle(ChartDataLoader.convertLineBreaks(string2));
                this.theChart.setTitleOn(string2 != null && string2.length() > 0);
            } else if (string.equals("legendon")) {
                this.theChart.setLegendOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("legendposition")) {
                this.theChart.setLegendPosition(1);
                if (string2 != null && string2.trim().length() > 0) {
                    if ((string2 = string2.toLowerCase()).equals("right")) {
                        this.theChart.setLegendPosition(1);
                    } else if (string2.equals("top")) {
                        this.theChart.setLegendPosition(2);
                    } else if (string2.equals("bottom")) {
                        this.theChart.setLegendPosition(3);
                    } else if (string2.equals("left")) {
                        this.theChart.setLegendPosition(0);
                    } else {
                        System.out.println("Invalid legendPosition: " + string2);
                    }
                }
            } else if (string.equals("legendcolumns")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        int n = Integer.parseInt(string2.trim());
                        this.theChart.setLegendColumns(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid legendColumns: " + string2);
                    }
                }
            } else if (string.equals("legendreverseon")) {
                this.theChart.setLegendReverseOn(string2 != null && string2.equalsIgnoreCase("true"));
            } else if (string.equals("legendboxsizeasfont")) {
                this.theChart.setLegendBoxSizeAsFont(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("3dmodeon")) {
                this.theChart.set3DModeOn(string2 != null && string2.equalsIgnoreCase("true"));
            } else if (string.equals("3ddepth")) {
                this.theChart.set3DDepth(-1);
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        int n = Integer.parseInt(string2.trim());
                        this.theChart.set3DDepth(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid 3DDepth: " + string2);
                    }
                }
            } else if (string.equals("gridoutline3don")) {
                this.theChart.setGridOutline3DOn(string2 != null && string2.equalsIgnoreCase("true"));
            } else if (string.equals("foreground")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartDataLoader.createColor(string2);
                    if (color != null) {
                        this.theChart.setForeground(color);
                    } else {
                        this.theChart.setForeground(Color.black);
                    }
                } else {
                    this.theChart.setForeground(Color.black);
                }
            } else if (string.equals("background")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2.trim(), "|");
                    if (stringTokenizer.hasMoreTokens()) {
                        color = ChartDataLoader.createColor((String)stringTokenizer.nextElement());
                        if (color != null) {
                            this.theChart.setBackground(color);
                        } else {
                            this.theChart.setBackground(new Color(231, 221, 231));
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        color = ChartDataLoader.createColor((String)stringTokenizer.nextElement());
                        if (color != null) {
                            this.theChart.setBackground2(color);
                        } else {
                            this.theChart.setBackground2(null);
                        }
                    }
                } else {
                    this.theChart.setBackground(new Color(231, 221, 231));
                    this.theChart.setBackground2(null);
                }
            } else if (string.equals("chartforeground")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartDataLoader.createColor(string2);
                    if (color != null) {
                        this.theChart.setChartForeground(color);
                    } else {
                        this.theChart.setChartForeground(Color.black);
                    }
                } else {
                    this.theChart.setChartForeground(Color.black);
                }
            } else if (string.equals("chartbackground")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2.trim(), "|");
                    if (stringTokenizer.hasMoreTokens()) {
                        color = ChartDataLoader.createColor((String)stringTokenizer.nextElement());
                        if (color != null) {
                            this.theChart.setChartBackground(color);
                        } else {
                            this.theChart.setChartBackground(Color.white);
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        color = ChartDataLoader.createColor((String)stringTokenizer.nextElement());
                        if (color != null) {
                            this.theChart.setChartBackground2(color);
                        } else {
                            this.theChart.setChartBackground2(null);
                        }
                    }
                } else {
                    this.theChart.setChartBackground(Color.white);
                    this.theChart.setChartBackground2(null);
                }
            } else if (string.equals("alternatechartbackground")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2.trim(), "|");
                if (stringTokenizer.hasMoreTokens()) {
                    String string8 = (String)stringTokenizer.nextElement();
                    if (string8.trim().equals("brighter")) {
                        this.theChart.setAlternateChartBackground(Renderer.getBrighter(this.theChart.getChartBackground()));
                    } else if (string8.trim().equals("darker")) {
                        this.theChart.setAlternateChartBackground(Renderer.getDarker(this.theChart.getChartBackground()));
                    } else {
                        this.theChart.setAlternateChartBackground(ChartDataLoader.createColor(string2.trim()));
                    }
                }
            } else if (string.equals("titlefont")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont("titleFont", this.createFont(string2, "Dialog", 1, 14));
                } else {
                    this.theChart.setFont("titleFont", new Font("Dialog", 1, 14));
                }
            } else if (string.equals("font")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont(this.createFont(string2, "Arial", 0, 11));
                } else {
                    this.theChart.setFont(new Font("Arial", 0, 11));
                }
            } else if (string.endsWith("font")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont(string, this.createFont(string2, "Arial", 0, 11));
                } else {
                    this.theChart.setFont(string, null);
                }
            } else if (string.equals("graphinsets")) {
                if (string2 != null && string2.trim().length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2.trim(), ",");
                    int n = -1;
                    int n4 = -1;
                    int n5 = -1;
                    int n6 = -1;
                    try {
                        if (stringTokenizer.hasMoreTokens()) {
                            n = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n4 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n5 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n6 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        this.theChart.setGraphInsets(n, n4, n5, n6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid graphinsets: " + string2);
                    }
                } else {
                    this.theChart.setGraphInsets(-1, -1, -1, -1);
                }
            } else if (string.equals("gridadjustmenton")) {
                this.theChart.setGridAdjustmentOn(2, false);
                this.theChart.setGridAdjustmentOn(1, false);
                this.theChart.setGridAdjustmentOn(3, false);
                this.theChart.setGridAdjustmentOn(0, false);
                if (string2 != null && string2.trim().length() > 0) {
                    if (string2.trim().equalsIgnoreCase("true")) {
                        this.theChart.setGridAdjustmentOn(2, true);
                        this.theChart.setGridAdjustmentOn(1, true);
                        this.theChart.setGridAdjustmentOn(3, true);
                        this.theChart.setGridAdjustmentOn(0, true);
                    } else {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string9 = stringTokenizer.nextToken().trim();
                            if (string9.equalsIgnoreCase("top")) {
                                this.theChart.setGridAdjustmentOn(2, true);
                                continue;
                            }
                            if (string9.equalsIgnoreCase("right")) {
                                this.theChart.setGridAdjustmentOn(1, true);
                                continue;
                            }
                            if (string9.equalsIgnoreCase("bottom")) {
                                this.theChart.setGridAdjustmentOn(3, true);
                                continue;
                            }
                            if (!string9.equalsIgnoreCase("left")) continue;
                            this.theChart.setGridAdjustmentOn(0, true);
                        }
                    }
                }
            } else if (string.equals("valuelineson")) {
                this.theChart.setValueLinesOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("maxvaluelinecount")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.theChart.setMaxValueLineCount(Integer.parseInt(string2.trim()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid maxValueLineCount: " + string2);
                        this.theChart.setMaxValueLineCount(-1);
                    }
                } else {
                    this.theChart.setMaxValueLineCount(-1);
                }
            } else if (string.equals("defaultgridlineson")) {
                if (string2 != null) {
                    String[] stringArray = this.getStringValues(string2, ",");
                    if (stringArray.length < 3) {
                        this.theChart.setDefaultGridLinesOn(stringArray[0].trim().equalsIgnoreCase("true"));
                    } else if (stringArray.length >= 3) {
                        double d = Double.valueOf(stringArray[1]);
                        double d5 = Double.valueOf(stringArray[2]);
                        this.theChart.setDefaultGridLinesOn(stringArray[0].trim().equalsIgnoreCase("true"), d, d5);
                    }
                }
            } else if (string.equals("defaultgridlinescolor")) {
                Color[] colorArray;
                this.theChart.setDefaultGridLinesColor(null);
                if (string2 != null && string2.trim().length() > 0 && (colorArray = this.getColorValues(string2)) != null && colorArray.length > 0 && colorArray[0] != null) {
                    this.theChart.setDefaultGridLinesColor(colorArray[0]);
                }
            } else if (string.equals("gridlines")) {
                Double[] doubleArray;
                this.theChart.setGridLines(null);
                if (string2 != null && (doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter)) != null) {
                    double[] dArray = new double[doubleArray.length];
                    for (int i = 0; i < doubleArray.length; ++i) {
                        if (doubleArray[i] == null) continue;
                        dArray[i] = doubleArray[i];
                    }
                    this.theChart.setGridLines(dArray);
                }
            } else if (string.equals("gridlinescolor")) {
                Color[] colorArray;
                this.theChart.setGridLinesColor(null);
                if (string2 != null && string2.trim().length() > 0 && (colorArray = this.getColorValues(string2)) != null && colorArray.length > 0 && colorArray[0] != null) {
                    this.theChart.setGridLinesColor(colorArray[0]);
                }
            } else if (string.equals("gridlinecolors")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setGridLineColors(this.getColorValues(string2));
                } else {
                    this.theChart.setGridLineColors(null);
                }
            } else if (string.equals("valuelinescolor")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartDataLoader.createColor(string2);
                    if (color != null) {
                        this.theChart.setValueLinesColor(color);
                    } else {
                        this.theChart.setValueLinesColor(Color.lightGray);
                    }
                } else {
                    this.theChart.setValueLinesColor(Color.lightGray);
                }
            } else if (string.startsWith("rangelabelsoff")) {
                int n = 0;
                if (!string.equalsIgnoreCase("rangelabelsoff")) {
                    try {
                        n = Integer.parseInt(string.substring(string.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid range index: " + string);
                    }
                }
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setRangeLabelsOn(n, !string2.trim().equalsIgnoreCase("true"));
                }
            } else if (string.equals("sampleaxislabel") || string.equals("rangeaxislabel") || string.startsWith("rangeaxislabel_")) {
                this.theChart.setLabel(string, ChartDataLoader.convertLineBreaks(string2));
            } else if (string.startsWith("rangelabelprefix") || string.startsWith("rangelabelpostfix")) {
                this.theChart.setLabel(string, ChartDataLoader.convertLineBreaks(string2));
            } else if (string.equals("samplescrolleron")) {
                this.theChart.setSampleScrollerOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("zoomon")) {
                this.theChart.setZoomOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("sampleaxisrange")) {
                Double[] doubleArray;
                this.theChart.setSampleAxisRange(0.0, 100.0);
                if (string2 != null && string2.trim().length() > 0 && (doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter)).length >= 2) {
                    this.theChart.setSampleAxisRange(doubleArray[0] != null ? doubleArray[0] : 0.0, doubleArray[1] != null ? doubleArray[1] : 100.0);
                }
            } else if (string.equals("visiblesamples")) {
                if (string2 != null && string2.length() > 0) {
                    int n = 0;
                    int n7 = -1;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    try {
                        if (stringTokenizer.hasMoreTokens()) {
                            n = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n7 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid visibleSamples: " + string2);
                    }
                    this.theChart.setVisibleSamples(n, n7);
                } else {
                    this.theChart.setVisibleSamples(0, -1);
                }
            } else if (string.startsWith("printasbitmap")) {
                this.theChart.setPrintAsBitmap(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (string.equals("floatingonlegendoff")) {
                this.theChart.setFloatingOnLegendOn(string2 == null || !string2.trim().equalsIgnoreCase("true"));
            } else if (string.startsWith("targetvalueline")) {
                Object object;
                if (this.targets.containsKey(string)) {
                    object = (String)this.targets.remove(string);
                    this.theChart.setTargetValueLine((String)object, 0.0, null, 0);
                }
                if (string2 != null && string2.length() > 0) {
                    String string10;
                    Object object2;
                    object = new StringTokenizer(string2, this.labelDelimiter);
                    String string11 = null;
                    if (((StringTokenizer)object).hasMoreElements()) {
                        string11 = ChartDataLoader.convertLineBreaks((String)((StringTokenizer)object).nextElement());
                    }
                    double d = 0.0;
                    if (((StringTokenizer)object).hasMoreElements()) {
                        try {
                            object2 = (String)((StringTokenizer)object).nextElement();
                            d = new Double(((String)object2).trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid targetValueLine value: " + string2);
                        }
                    }
                    object2 = this.theChart.getValueLinesColor();
                    if (((StringTokenizer)object).hasMoreElements() && (object2 = ChartDataLoader.createColor((string10 = (String)((StringTokenizer)object).nextElement()).trim())) == null) {
                        object2 = this.theChart.getValueLinesColor();
                    }
                    int n = 3;
                    if (((StringTokenizer)object).hasMoreElements()) {
                        String string12 = ((String)((StringTokenizer)object).nextElement()).trim();
                        n = string12.equals("label") ? 1 : (string12.equals("value") ? 2 : 3);
                    }
                    int n8 = 0;
                    if (((StringTokenizer)object).hasMoreElements()) {
                        try {
                            String string13 = (String)((StringTokenizer)object).nextElement();
                            n8 = new Integer(string13.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid targetValueLine range: " + string2);
                        }
                    }
                    if (string11 != null) {
                        this.targets.put(string, string11);
                        this.theChart.setTargetValueLine(string11, d, (Color)object2, n, n8);
                    }
                }
            } else if (string.equals("targetlabelsposition")) {
                if (string2 != null && string2.trim().length() > 0) {
                    if ((string2 = string2.toLowerCase()).equals("right") || string2.equals("top")) {
                        this.theChart.setTargetLabelsPosition(1);
                    } else if (string2.equals("left") || string2.equals("bottom")) {
                        this.theChart.setTargetLabelsPosition(0);
                    } else {
                        this.theChart.setTargetLabelsPosition(-1);
                    }
                }
            } else if (string.startsWith("label_")) {
                if (this.labels.containsKey(string)) {
                    this.labels.remove(string);
                    this.theChart.setLabel(string, (String)null, 0, 0);
                }
                if (string2 != null && string2.length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, this.labelDelimiter);
                    String string14 = null;
                    if (stringTokenizer.hasMoreElements()) {
                        string14 = ChartDataLoader.convertLineBreaks((String)stringTokenizer.nextElement());
                    }
                    int n = -1;
                    double d = -1.0;
                    if (stringTokenizer.hasMoreElements()) {
                        try {
                            String string15 = (String)stringTokenizer.nextElement();
                            if (string15.indexOf(46) == -1) {
                                n = new Integer(string15.trim());
                            } else {
                                d = new Double(string15.trim());
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid " + string + " value: " + string2);
                        }
                    }
                    int n9 = -1;
                    double d6 = -1.0;
                    if (stringTokenizer.hasMoreElements()) {
                        try {
                            String string16 = (String)stringTokenizer.nextElement();
                            if (string16.indexOf(46) == -1) {
                                n9 = new Integer(string16.trim());
                            } else {
                                d6 = new Double(string16.trim());
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid " + string + " value: " + string2);
                        }
                    }
                    int n10 = -1;
                    if (stringTokenizer.hasMoreElements()) {
                        try {
                            String string17 = (String)stringTokenizer.nextElement();
                            n10 = new Integer(string17.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid " + string + " value: " + string2);
                        }
                    }
                    int n11 = -1;
                    if (stringTokenizer.hasMoreElements()) {
                        try {
                            String string18 = (String)stringTokenizer.nextElement();
                            n11 = new Integer(string18.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid " + string + " value: " + string2);
                        }
                    }
                    if (string14 != null) {
                        this.labels.put(string, string);
                        if (n10 > -1 && n11 > -1) {
                            if (n != -1 && n9 != -1) {
                                this.theChart.setLabel(string, string14, n, n9, n11, n10);
                            } else if (d != -1.0 && d6 != -1.0) {
                                this.theChart.setLabel(string, string14, d, d6, n11, n10);
                            } else {
                                System.out.println("Invalid " + string + " value: " + string2);
                            }
                        } else if (n != -1 && n9 != -1) {
                            this.theChart.setLabel(string, string14, n, n9);
                        } else if (d != -1.0 && d6 != -1.0) {
                            this.theChart.setLabel(string, string14, d, d6);
                        } else {
                            System.out.println("Invalid " + string + " value: " + string2);
                        }
                    }
                }
            } else if (string.startsWith("labelposition_")) {
                if (string2 != null && string2.length() > 0) {
                    String string19 = "label" + string.substring(string.indexOf("_"));
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, this.labelDelimiter);
                    int n = -1;
                    double d = -1.0;
                    if (stringTokenizer.hasMoreElements()) {
                        try {
                            String string20 = (String)stringTokenizer.nextElement();
                            if (string20.indexOf(46) == -1) {
                                n = new Integer(string20.trim());
                            } else {
                                d = new Double(string20.trim());
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid " + string + " value: " + string2);
                        }
                    }
                    int n12 = -1;
                    double d7 = -1.0;
                    if (stringTokenizer.hasMoreElements()) {
                        try {
                            String string21 = (String)stringTokenizer.nextElement();
                            if (string21.indexOf(46) == -1) {
                                n12 = new Integer(string21.trim());
                            } else {
                                d7 = new Double(string21.trim());
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid " + string + " value: " + string2);
                        }
                    }
                    if (n != -1 && n12 != -1) {
                        this.theChart.setLabelPosition(string19, n, n12);
                    } else if (d != -1.0 && d7 != -1.0) {
                        this.theChart.setLabelPosition(string19, d, d7);
                    } else {
                        System.out.println("Invalid " + string + " value: " + string2);
                    }
                }
            } else if (string.startsWith("labelurl_")) {
                String string22 = "label" + string.substring(string.indexOf("_"));
                if (this.labelURLs.containsKey(string22)) {
                    this.labelURLs.remove(string22);
                    this.theChart.setLabelURL(string22, null);
                }
                if (string2 != null && string2.length() > 0) {
                    this.labelURLs.put(string22, string2);
                    this.theChart.setLabelURL(string22, string2);
                }
            } else if (string.startsWith("labelurltarget_")) {
                String string23 = "label" + string.substring(string.indexOf("_"));
                if (string2 != null && string2.trim().length() > 0) {
                    this.labelURLTargets.put(string23, string2);
                } else if (string.equals("labelurltarget")) {
                    this.labelURLTargets.put("urltarget", "_self");
                } else {
                    this.labelURLTargets.remove(string);
                }
            } else if (string.startsWith("labelangle_")) {
                String string24 = "label" + string.substring(string.indexOf("_"));
                try {
                    int n = Integer.parseInt(string2.trim());
                    this.theChart.setLabelAngle(string24, n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid custom label angle: " + string2);
                }
            } else if (string.startsWith("labelfont_")) {
                String string25 = "label" + string.substring(string.indexOf("_"));
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont(string25, this.createFont(string2, "Dialog", 0, 11));
                } else {
                    this.theChart.setFont(string25, new Font("Dialog", 0, 11));
                }
            } else if (string.startsWith("labelcolor_")) {
                String string26 = "label" + string.substring(string.indexOf("_"));
                this.theChart.setLabelColor(string26, ChartDataLoader.createColor(string2));
            } else if (string.equalsIgnoreCase("complexLabelSeparator")) {
                this.theChart.setComplexLabelSeparator(ChartDataLoader.convertLineBreaks(string2));
            } else if (string.equalsIgnoreCase("multilineLabelAlignment")) {
                if (string2 != null && string2.trim().length() > 0) {
                    if ((string2 = string2.toLowerCase()).equals("left")) {
                        this.theChart.setMultilineLabelAlignment(-1);
                    } else if (string2.equals("center")) {
                        this.theChart.setMultilineLabelAlignment(0);
                    } else if (string2.equals("right")) {
                        this.theChart.setMultilineLabelAlignment(1);
                    }
                }
            } else if (string.equalsIgnoreCase("displayVersion")) {
                if (this.theChart != null) {
                    this.theChart.displayVersionOn = string2 != null && string2.trim().equalsIgnoreCase("true");
                }
            } else if (string.equalsIgnoreCase("antialias")) {
                this.theChart.setAntialiasingOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
            } else if (!(string.equals("data") || string.equals("datainterval") || string.startsWith("urltarget") || string.startsWith("url") || string.startsWith("exporturl") || string.startsWith("format") || string.equals("singleclickurlon") || string.equals("gridimage") || string.startsWith("legendimage_") || string.startsWith("samplehighlightimage"))) {
                if (this.chartType.equals("bar") && this.barChart != null) {
                    if (string.equals("barlabels")) {
                        if (string2 != null && string2.length() > 0) {
                            String[] stringArray = this.getStringValues(ChartDataLoader.convertLineBreaks(string2), this.labelDelimiter);
                            this.barChart.setBarLabels(stringArray);
                        } else {
                            this.barChart.setBarLabels(null);
                        }
                    } else if (string.equals("barlabelson")) {
                        this.barChart.setBarLabelsOn(string2 != null && string2.equalsIgnoreCase("true"));
                    } else if (string.equals("barlabelstyle")) {
                        System.out.println(string + " is deprecated, use sampleLabelStyle");
                        if (string2 != null && string2.trim().equalsIgnoreCase("floating")) {
                            this.barChart.setSampleLabelStyle(3);
                        } else if (string2 != null && string2.trim().equalsIgnoreCase("below_and_floating")) {
                            this.barChart.setSampleLabelStyle(4);
                        } else {
                            this.barChart.setSampleLabelStyle(2);
                        }
                    } else if (string.equals("barlabelcolors")) {
                        Color[] colorArray = this.getColorValues(string2);
                        int n = this.barChart.getSampleCount();
                        for (int i = 0; i < n; ++i) {
                            if (colorArray != null && i < colorArray.length) {
                                this.barChart.setBarLabelColor(i, colorArray[i]);
                                continue;
                            }
                            this.barChart.setBarLabelColor(i, null);
                        }
                    } else if (string.equals("autolabelspacingon")) {
                        this.barChart.setAutoLabelSpacingOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
                    } else if (string.equals("multicoloron")) {
                        this.barChart.setMultiColorOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
                    } else if (string.equals("multiserieson")) {
                        this.barChart.setMultiSeriesOn(string2 != null && string2.trim().equalsIgnoreCase("true"));
                    } else if (string.equals("baroutlineoff")) {
                        this.barChart.setBarOutlineOn(string2 == null || !string2.trim().equalsIgnoreCase("true"));
                    } else if (string.startsWith("baroutlinecolor")) {
                        this.barChart.setBarOutlineColor(null);
                        if (string2 != null) {
                            this.barChart.setBarOutlineColor(ChartDataLoader.createColor(string2));
                        }
                    } else if (string.equals("baralignment")) {
                        if (string2 != null && string2.trim().equalsIgnoreCase("horizontal")) {
                            this.barChart.setBarAlignment(0);
                        } else {
                            this.barChart.setBarAlignment(1);
                        }
                    } else if (string.equals("bartype")) {
                        if (string2 != null) {
                            if (string2.trim().equalsIgnoreCase("stacked")) {
                                this.barChart.setBarType(1);
                            } else if (string2 != null && string2.trim().equalsIgnoreCase("behind")) {
                                this.barChart.setBarType(2);
                            } else {
                                this.barChart.setBarType(0);
                            }
                        }
                    } else if (string.equals("barshape")) {
                        if (string2 != null) {
                            if (string2.trim().equalsIgnoreCase("cylinder")) {
                                this.barChart.setBarShape(1);
                            } else {
                                this.barChart.setBarShape(0);
                            }
                        }
                    } else if (string.equals("barwidth")) {
                        try {
                            if (string2 != null && string2.trim().length() > 0) {
                                this.barChart.setBarWidth(new Double(string2.trim()));
                                break block802;
                            }
                            this.barChart.setBarWidth(0.4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid barWidth: " + string2);
                            this.barChart.setBarWidth(0.4);
                        }
                    }
                } else if ((this.chartType.equals("line") || this.chartType.equals("time_line") || this.chartType.equals("spline")) && this.lineChart != null) {
                    if (string.equals("autolabelspacingon")) {
                        this.lineChart.setAutoLabelSpacingOn(string2 != null && string2.equalsIgnoreCase("true"));
                    } else if (string.startsWith("area")) {
                        if (string2 != null && string2.length() > 0) {
                            Object object;
                            Object object3;
                            int n = 0;
                            if (string.startsWith("area_")) {
                                n = Integer.parseInt(string.substring(5));
                            }
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, this.labelDelimiter);
                            int n13 = -1;
                            if (stringTokenizer.hasMoreElements()) {
                                try {
                                    String string27 = ChartDataLoader.convertLineBreaks((String)stringTokenizer.nextElement());
                                    n13 = new Integer(string27.trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    System.out.println("Invalid area: " + string2);
                                }
                            }
                            int n14 = -1;
                            if (stringTokenizer.hasMoreElements()) {
                                try {
                                    object3 = ChartDataLoader.convertLineBreaks((String)stringTokenizer.nextElement());
                                    n14 = new Integer(((String)object3).trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    System.out.println("Invalid area: " + string2);
                                }
                            }
                            object3 = null;
                            if (stringTokenizer.hasMoreElements()) {
                                object = (String)stringTokenizer.nextElement();
                                object3 = ChartDataLoader.createColor(((String)object).trim());
                            }
                            object = null;
                            if (stringTokenizer.hasMoreElements()) {
                                String string28 = (String)stringTokenizer.nextElement();
                                object = ChartDataLoader.createColor(string28.trim());
                            }
                            this.lineChart.setArea(n, n13, n14);
                            if (object3 != null) {
                                this.lineChart.setAreaColor(n, (Color)object3);
                            }
                            if (object != null) {
                                this.lineChart.setAreaColor2(n, (Color)object);
                            } else {
                                this.lineChart.setAreaColor2(n, (Color)object3);
                            }
                        }
                    } else if (string.equals("serieslineoff")) {
                        if (string2 != null && string2.trim().equalsIgnoreCase("true")) {
                            this.lineChart.setSeriesLineOn(false);
                        } else if (string2 != null && string2.trim().equalsIgnoreCase("false")) {
                            this.lineChart.setSeriesLineOn(true);
                        } else if (string2 != null && string2.trim().length() > 0) {
                            this.lineChart.setSeriesLineOn(true);
                            Double[] doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter);
                            int n = this.lineChart.getSeriesCount();
                            for (int i = 0; i < doubleArray.length; ++i) {
                                if (doubleArray[i] == null || doubleArray[i].intValue() < 0 || doubleArray[i].intValue() >= n) continue;
                                this.lineChart.setSeriesLineOn(doubleArray[i].intValue(), false);
                            }
                        } else {
                            this.lineChart.setSeriesLineOn(true);
                        }
                    } else if (string.equals("connectedlineson")) {
                        this.lineChart.setConnectedLinesOn(-1, false);
                        if (string2 != null && string2.trim().equalsIgnoreCase("true")) {
                            this.lineChart.setConnectedLinesOn(-1, true);
                        } else if (string2 != null && string2.trim().equalsIgnoreCase("false")) {
                            this.lineChart.setConnectedLinesOn(-1, false);
                        } else if (string2 != null && string2.trim().length() > 0) {
                            Double[] doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter);
                            int n = this.lineChart.getSeriesCount();
                            for (int i = 0; i < doubleArray.length; ++i) {
                                if (doubleArray[i] == null || doubleArray[i].intValue() < 0 || doubleArray[i].intValue() >= n) continue;
                                this.lineChart.setConnectedLinesOn(doubleArray[i].intValue(), true);
                            }
                        }
                    } else if (string.equals("linewidth")) {
                        if (string2 != null && string2.trim().length() > 0) {
                            Double[] doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter);
                            if (doubleArray.length == 1 && this.lineChart.getSeriesCount() > 1 && doubleArray[0] != null) {
                                this.lineChart.setLineWidth(-1, doubleArray[0].intValue());
                            } else {
                                for (int i = 0; i < doubleArray.length; ++i) {
                                    if (doubleArray[i] == null) continue;
                                    this.lineChart.setLineWidth(i, doubleArray[i].intValue());
                                }
                            }
                        } else {
                            this.lineChart.setLineWidth(-1, 2);
                        }
                    } else if (string.equals("linestyle")) {
                        if (string2 != null) {
                            String[] stringArray = this.getStringValues(string2, ",");
                            if (stringArray == null || stringArray.length == 0) {
                                return;
                            }
                            if (stringArray.length == 1 && this.lineChart.getSeriesCount() > 1 && stringArray[0] != null) {
                                if (stringArray[0].trim().equalsIgnoreCase("tube")) {
                                    this.lineChart.setLineStyle(-1, 1);
                                } else {
                                    this.lineChart.setLineStyle(-1, 0);
                                }
                            } else {
                                for (int i = 0; i < stringArray.length; ++i) {
                                    if (stringArray[i] != null && stringArray[i].trim().equalsIgnoreCase("tube")) {
                                        this.lineChart.setLineStyle(i, 1);
                                        continue;
                                    }
                                    this.lineChart.setLineStyle(i, 0);
                                }
                            }
                        }
                    } else if (string.equals("line3ddepth")) {
                        if (string2 != null && string2.trim().length() > 0) {
                            Double[] doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter);
                            if (doubleArray.length == 1 && this.lineChart.getSeriesCount() > 1 && doubleArray[0] != null) {
                                this.lineChart.setLine3DDepth(-1, doubleArray[0]);
                            } else {
                                for (int i = 0; i < doubleArray.length; ++i) {
                                    if (doubleArray[i] == null) continue;
                                    this.lineChart.setLine3DDepth(i, doubleArray[i]);
                                }
                            }
                        } else {
                            this.lineChart.setLine3DDepth(-1, 1.0);
                        }
                    } else if (string.equals("outlineoff")) {
                        boolean[] blArray = this.getBooleanValues(string2);
                        int n = this.lineChart.getSeriesCount();
                        for (int i = 0; i < n; ++i) {
                            this.lineChart.setOutlineOn(i, !blArray[i % blArray.length]);
                        }
                    } else if (string.equals("linestroke")) {
                        if (string2 != null && string2.trim().length() > 0) {
                            String[] stringArray = this.getStringValues(string2, ",");
                            if (stringArray == null || stringArray.length == 0) {
                                return;
                            }
                            for (int i = 0; i < stringArray.length; ++i) {
                                String[] stringArray2 = this.getStringValues(stringArray[i], "|");
                                float[] fArray = new float[stringArray2.length];
                                for (int j = 0; j < stringArray2.length; ++j) {
                                    try {
                                        if (stringArray2[j] == null) continue;
                                        fArray[j] = Integer.parseInt(stringArray2[j].trim());
                                        continue;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        System.out.println("Invalid stroke: " + stringArray2[i]);
                                    }
                                }
                                this.lineChart.setLineStroke(i, fArray);
                            }
                        }
                    } else if (string.equals("line3dlayout")) {
                        if (string2 != null) {
                            if (string2 != null && string2.trim().equalsIgnoreCase("behind")) {
                                this.lineChart.setLine3DLayout(0);
                            } else {
                                this.lineChart.setLine3DLayout(1);
                            }
                        }
                    } else if (string.equals("stackedon")) {
                        this.lineChart.setStackedOn(string2 != null && string2.equalsIgnoreCase("true"));
                    } else if (string.equals("samplehighlighton")) {
                        boolean[] blArray = this.getBooleanValues(string2);
                        int n = this.lineChart.getSeriesCount();
                        for (int i = 0; i < n; ++i) {
                            if (blArray != null && blArray.length > 0) {
                                this.lineChart.setSampleHighlightOn(i, blArray[i % blArray.length]);
                                continue;
                            }
                            this.lineChart.setSampleHighlightOn(i, false);
                        }
                    } else if (string.equals("samplehighlightstyle")) {
                        int[] nArray = this.getStyleValues(string2);
                        int n = this.lineChart.getSeriesCount();
                        for (int i = 0; i < n; ++i) {
                            int n15 = this.lineChart.getSampleHighlightSize(i);
                            int n16 = 0;
                            if (nArray != null && nArray.length > 0) {
                                n16 = nArray[i % nArray.length];
                            }
                            this.lineChart.setSampleHighlightStyle(i, n16, n15);
                        }
                    } else if (string.equals("samplehighlightsize")) {
                        int n = this.lineChart.getSeriesCount();
                        Double[] doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter);
                        for (int i = 0; i < n; ++i) {
                            int n17 = this.lineChart.getSampleHighlightStyle(i);
                            int n18 = 6;
                            if (doubleArray != null && doubleArray.length > 0 && doubleArray[i % doubleArray.length] != null) {
                                n18 = doubleArray[i % doubleArray.length].intValue();
                            }
                            this.lineChart.setSampleHighlightStyle(i, n17, n18);
                        }
                    } else if (string.equalsIgnoreCase("missingvaluesinterpolated")) {
                        this.lineChart.setMissingValuesInterpolated(string2 != null && string2.trim().equalsIgnoreCase("true"));
                    }
                } else if (this.chartType.equals("pie") && this.pieChart != null) {
                    if (string.equals("angle")) {
                        if (string2 != null && string2.trim().length() > 0) {
                            try {
                                int n = Integer.parseInt(string2);
                                n = Math.max(10, n);
                                n = Math.min(80, n);
                                this.pieChart.setAngle(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Invalid angle: " + string2);
                                this.pieChart.setAngle(20);
                            }
                        } else {
                            this.pieChart.setAngle(20);
                        }
                    } else if (string.equals("startangle")) {
                        if (string2 != null && string2.trim().length() > 0) {
                            Double[] doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter);
                            if (doubleArray.length == 1 && doubleArray[0] != null) {
                                this.pieChart.setStartAngle(-1, doubleArray[0].intValue());
                            } else {
                                for (int i = 0; i < doubleArray.length; ++i) {
                                    if (doubleArray[i] == null) continue;
                                    this.pieChart.setStartAngle(i, doubleArray[i].intValue());
                                }
                            }
                        } else {
                            this.pieChart.setStartAngle(-1, 0);
                        }
                    } else if (string.equals("depth")) {
                        if (string2 != null && string2.trim().length() > 0) {
                            try {
                                double d = new Float(string2).floatValue();
                                d = Math.max(0.0, d);
                                d = Math.min(1.0, d);
                                this.pieChart.setDepth((float)d);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Invalid depth: " + string2);
                                this.pieChart.setDepth(0.4f);
                            }
                        } else {
                            this.pieChart.setDepth(0.4f);
                        }
                    } else if (string.equals("percentlabelson")) {
                        this.pieChart.setPercentLabelsOn(string2 != null && string2.equalsIgnoreCase("true"));
                    } else if (string.equals("percentlabelstyle")) {
                        this.pieChart.setPercentLabelStyle(3);
                        if (string2 != null && string2.trim().length() > 0) {
                            if (string2.trim().equalsIgnoreCase("inside")) {
                                this.pieChart.setPercentLabelStyle(0);
                            } else if (string2.trim().equalsIgnoreCase("outside")) {
                                this.pieChart.setPercentLabelStyle(1);
                            } else if (string2.trim().equalsIgnoreCase("pointing")) {
                                this.pieChart.setPercentLabelStyle(5);
                            }
                        }
                    } else if (string.equals("pielabelson")) {
                        this.pieChart.setPieLabelsOn(string2 != null && string2.equalsIgnoreCase("true"));
                    } else if (string.startsWith("insidelabelcolor")) {
                        int n = -1;
                        try {
                            if (string.length() > 18) {
                                n = Integer.parseInt(string.substring(18));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid index in insideLabelColor_N parameter: " + string);
                        }
                        Color color = this.getColorValues(string2)[0];
                        this.pieChart.setInsideLabelColor(n, color);
                    } else if (string.startsWith("outsidelabelcolor")) {
                        int n = -1;
                        try {
                            if (string.length() > 18) {
                                n = Integer.parseInt(string.substring(18));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid index in outsideLabelColor_N parameter: " + string);
                        }
                        Color color = this.getColorValues(string2)[0];
                        this.pieChart.setOutsideLabelColor(n, color);
                    } else if (string.startsWith("pointinglabelcolor")) {
                        int n = -1;
                        try {
                            if (string.length() > 18) {
                                n = Integer.parseInt(string.substring(19));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid index in pointingLabelColor_N parameter: " + string);
                        }
                        Color color = this.getColorValues(string2)[0];
                        this.pieChart.setPointingLabelColor(n, color);
                    } else if (string.equals("percentdecimalcount")) {
                        if (string2 != null && string2.trim().length() > 0) {
                            try {
                                this.pieChart.setPercentDecimalCount(Integer.parseInt(string2));
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Invalid percentDecimalCount: " + string2);
                                this.pieChart.setPercentDecimalCount(0);
                            }
                        } else {
                            this.pieChart.setPercentDecimalCount(0);
                        }
                    } else if (string.equals("sliceseperatoron")) {
                        this.pieChart.setSliceSeperatorOn(string2 != null && string2.equalsIgnoreCase("true"));
                    } else if (string.equals("gradientsampleson")) {
                        this.pieChart.setGradientSamplesOn(string2 != null && string2.equalsIgnoreCase("true"));
                    } else if (string.equals("sliceseperatorcolor")) {
                        if (string2 != null && string2.length() > 0) {
                            this.pieChart.setSliceSeperatorColor(ChartDataLoader.createColor(string2));
                        } else {
                            this.pieChart.setSliceSeperatorColor(null);
                        }
                    } else if (string.equals("selectionstyle")) {
                        int n = 0;
                        if (string2 != null) {
                            if (string2.equals("circle")) {
                                n = 1;
                            } else if (string2.equals("detached")) {
                                n = 2;
                            }
                        }
                        this.pieChart.setSelectionStyle(n);
                    } else if (string.equals("detacheddistance")) {
                        this.pieChart.setDetachedDistance(0.1);
                        if (string2 != null && string2.length() > 0) {
                            try {
                                double d = new Double(string2);
                                this.pieChart.setDetachedDistance(Math.max(0.0, d));
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Invalid detachDistance: " + string2);
                            }
                        }
                    } else if (string.startsWith("detachedslices")) {
                        int n = string.equals("detachedslices") ? 0 : -1;
                        try {
                            if (string.length() > 15) {
                                n = Integer.parseInt(string.substring(15));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid index in detachedSlices_N parameter: " + string);
                        }
                        Double[] doubleArray = ChartDataLoader.getDoubleValues(string2, this.valueDelimiter);
                        int n19 = this.pieChart.getSeriesCount();
                        int n20 = this.pieChart.getSampleCount();
                        if (n19 == 1) {
                            for (int i = 0; i < n20; ++i) {
                                this.pieChart.setDetachedSlice(0, i, 0.0);
                            }
                            if (doubleArray != null) {
                                double d = this.pieChart.getDetachedDistance();
                                for (int i = 0; doubleArray != null && i < doubleArray.length; ++i) {
                                    int n21 = doubleArray[i].intValue();
                                    if (n21 >= n20) continue;
                                    this.pieChart.setDetachedSlice(0, n21, d);
                                }
                            }
                        } else if (n < n20) {
                            for (int i = 0; i < n19; ++i) {
                                this.pieChart.setDetachedSlice(i, n, 0.0);
                            }
                            if (doubleArray != null) {
                                double d = this.pieChart.getDetachedDistance();
                                for (int i = 0; doubleArray != null && i < doubleArray.length; ++i) {
                                    int n22 = doubleArray[i].intValue();
                                    if (n22 >= n19) continue;
                                    this.pieChart.setDetachedSlice(n22, n, d);
                                }
                            }
                        }
                    } else if (string.equals("pierotationon")) {
                        this.pieChart.setPieRotationOn(string2 != null && string2.equalsIgnoreCase("true"));
                    }
                }
            }
        }
    }

    protected void setImage(String string, Image image) {
        block17: {
            if (image != null) {
                this.theChart.addImage(string, image);
            }
            if (string.equalsIgnoreCase("gridimage")) {
                if (image != null) {
                    this.theChart.setGridImage("gridimage");
                } else {
                    this.theChart.setGridImage(null);
                }
            } else if (string.startsWith("legendimage_")) {
                try {
                    int n = Integer.parseInt(string.substring(string.indexOf("_") + 1));
                    if (image != null) {
                        this.theChart.setLegendImage(n, string);
                        break block17;
                    }
                    this.theChart.setLegendImage(n, null);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid legend index: " + string);
                }
            } else if (string.startsWith("samplehighlightimage")) {
                try {
                    if (string.equals("samplehighlightimage")) {
                        this.lineChart.setSampleHighlightImage(-1, -1, string);
                    } else if (string.indexOf(95, 21) == -1) {
                        int n = Integer.parseInt(string.substring(21));
                        this.lineChart.setSampleHighlightImage(n, -1, string);
                    } else {
                        int n = Integer.parseInt(string.substring(21, string.indexOf(95, 21)));
                        int n2 = Integer.parseInt(string.substring(string.indexOf(95, 21) + 1));
                        this.lineChart.setSampleHighlightImage(n, n2, string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid index in insideLableColor_N parameter: " + string);
                }
            }
        }
    }

    protected boolean[] getBooleanValues(String string) {
        boolean[] blArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            blArray = new boolean[stringTokenizer.countTokens()];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = stringTokenizer.nextToken().trim().equalsIgnoreCase("true");
            }
        }
        return blArray;
    }

    protected int[] getStyleValues(String string) {
        int[] nArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            nArray = new int[stringTokenizer.countTokens()];
            for (int i = 0; i < nArray.length; ++i) {
                String string2 = stringTokenizer.nextToken().trim().toLowerCase();
                if (string2.equals("circle")) {
                    nArray[i] = 0;
                    continue;
                }
                if (string2.equals("circle_opaque")) {
                    nArray[i] = 1;
                    continue;
                }
                if (string2.equals("circle_filled")) {
                    nArray[i] = 2;
                    continue;
                }
                if (string2.equals("square")) {
                    nArray[i] = 3;
                    continue;
                }
                if (string2.equals("square_opaque")) {
                    nArray[i] = 4;
                    continue;
                }
                if (string2.equals("square_filled")) {
                    nArray[i] = 5;
                    continue;
                }
                if (string2.equals("diamond")) {
                    nArray[i] = 6;
                    continue;
                }
                if (string2.equals("diamond_opaque")) {
                    nArray[i] = 7;
                    continue;
                }
                if (string2.equals("diamond_filled")) {
                    nArray[i] = 8;
                    continue;
                }
                nArray[i] = 0;
                System.out.println("Invalid sampleHighlightStyle: " + string2);
            }
        }
        return nArray;
    }

    protected String[] getStringValues(String string) {
        return this.getStringValues(string, this.labelDelimiter);
    }

    protected String[] getStringValues(String string, String string2) {
        return Chart.getStringValues(string, string2);
    }

    protected Color[] getColorValues(String string) {
        Color[] colorArray = null;
        String[] stringArray = Chart.getStringValues(string, ",");
        if (stringArray != null) {
            colorArray = new Color[stringArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                if (stringArray[i] == null) continue;
                colorArray[i] = ChartDataLoader.createColor(stringArray[i].trim());
            }
        }
        return colorArray;
    }

    static int a(String string) {
        if ((string = string.toLowerCase().trim()).equals("bold")) {
            return 1;
        }
        if (string.equals("italic")) {
            return 2;
        }
        if (string.equals("bolditalic") || string.equals("italicbold")) {
            return 3;
        }
        return 0;
    }

    public Font createFont(String string, String string2, int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string3 = string2;
        int n3 = Math.max(0, n2);
        int n4 = n;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            n4 = ChartDataLoader.a(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            try {
                n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 12;
            }
        }
        return new Font(string3, n4, n3);
    }

    public static Color createColor(String string) {
        boolean bl;
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl2 = bl = !System.getProperty("java.version").startsWith("1.1");
        if (string.indexOf(",") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                if (bl && stringTokenizer.hasMoreTokens()) {
                    return new Color(n, n2, n3, Integer.parseInt(stringTokenizer.nextToken()));
                }
                return new Color(n, n2, n3);
            }
            catch (Exception exception) {
                System.out.println("Invalid RGB color: " + string);
            }
        } else if (string.startsWith("#")) {
            try {
                int n = Integer.parseInt(string.substring(1, 3), 16);
                int n4 = Integer.parseInt(string.substring(3, 5), 16);
                int n5 = Integer.parseInt(string.substring(5, 7), 16);
                if (bl && string.length() >= 9) {
                    return new Color(n, n4, n5, Integer.parseInt(string.substring(7, 9), 16));
                }
                return new Color(n, n4, n5);
            }
            catch (Exception exception) {
                System.out.println("Invalid hex color: " + string);
            }
        } else {
            if ((string = string.toLowerCase()).equals("black")) {
                return Color.black;
            }
            if (string.equals("blue")) {
                return Color.blue;
            }
            if (string.equals("cyan")) {
                return Color.cyan;
            }
            if (string.equals("darkgray")) {
                return Color.darkGray;
            }
            if (string.equals("gray")) {
                return Color.gray;
            }
            if (string.equals("green")) {
                return Color.green;
            }
            if (string.equals("lightgray")) {
                return Color.lightGray;
            }
            if (string.equals("magenta")) {
                return Color.magenta;
            }
            if (string.equals("orange")) {
                return Color.orange;
            }
            if (string.equals("pink")) {
                return Color.pink;
            }
            if (string.equals("red")) {
                return Color.red;
            }
            if (string.equals("white")) {
                return Color.white;
            }
            if (string.equals("yellow")) {
                return Color.yellow;
            }
            if (!string.equals("x")) {
                System.out.println("Invalid color name: " + string);
            }
        }
        return null;
    }

    public String createArrayString(int[] nArray) {
        if (nArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    protected static String convertLineBreaks(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (i < cArray.length - 1 && cArray[i] == '\\' && cArray[i + 1] == 'n') {
                cArray2[n++] = 10;
                ++i;
                continue;
            }
            if (i < cArray.length - 5 && cArray[i] == '\\' && cArray[i + 1] == 'u') {
                try {
                    cArray2[n++] = (char)Integer.parseInt(string.substring(i + 2, i + 6), 16);
                    i += 5;
                }
                catch (NumberFormatException numberFormatException) {
                    cArray2[n++] = cArray[i];
                }
                continue;
            }
            cArray2[n++] = cArray[i];
        }
        return new String(cArray2, 0, n);
    }

    protected static Double[] getDoubleValues(String string) {
        return ChartDataLoader.getDoubleValues(string, ",");
    }

    protected static Double[] getDoubleValues(String string, String string2) {
        Double[] doubleArray = null;
        String[] stringArray = Chart.getStringValues(string, string2);
        if (stringArray != null) {
            doubleArray = new Double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                try {
                    doubleArray[i] = new Double(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    doubleArray[i] = new Double(Double.NaN);
                }
            }
        }
        return doubleArray;
    }
}

