/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart.ext;

import com.objectplanet.chart.ChartApplet;
import com.objectplanet.chart.ChartDataLoader;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.ext.GaugeChart;
import com.objectplanet.chart.ext.PlotterChart;
import com.objectplanet.chart.ext.SplineChart;
import com.objectplanet.chart.ext.TimeLineChart;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class ChartDataLoaderExt
extends ChartDataLoader {
    private String[] parameters_range_last = new String[]{"xrangestep", "yrangestep", "rangeadjusteron_right", "rangeadjusteron_bottom"};
    protected PlotterChart plotterChart;
    protected GaugeChart gaugeChart;

    public Component setChart(Component chart) {
        if (this.chartType.equals("time_line")) {
            this.lineChart = new TimeLineChart();
            this.theChart = this.lineChart;
        } else if (this.chartType.equals("spline")) {
            this.lineChart = new SplineChart();
            this.theChart = this.lineChart;
        } else {
            if (this.chartType.equals("plotter")) {
                this.plotterChart = chart != null ? (PlotterChart)chart : new PlotterChart();
                return this.plotterChart;
            }
            if (this.chartType.equals("gauge")) {
                this.gaugeChart = (GaugeChart)chart;
                return this.gaugeChart;
            }
        }
        return this.theChart;
    }

    protected GenericChart createExtChart(String type) {
        if (type.equals("plotter")) {
            return new PlotterChart();
        }
        return null;
    }

    public void addChartItemListener(ChartApplet chartApplet) {
        if (this.chartType.equals("plotter")) {
            this.plotterChart.addItemListener(chartApplet);
        } else if (this.chartType.equals("gauge")) {
            this.gaugeChart.addItemListener(chartApplet);
        }
    }

    public void setParameters(Hashtable parameters) {
        block6: {
            block9: {
                block8: {
                    String value;
                    String param;
                    block7: {
                        if (parameters == null) break block6;
                        if (!this.chartType.equals("time_line")) break block7;
                        this.setParameter("timeFormatInputLocale", (String)parameters.get("timeformatinputlocale"));
                        parameters.remove("timeformatinputlocale");
                        this.setParameter("timeFormatInput", (String)parameters.get("timeformatinput"));
                        parameters.remove("timeformatinput");
                        this.setParameter("timeFormatOutLocale", (String)parameters.get("timeformatoutlocale"));
                        parameters.remove("timeformatoutlocale");
                        this.setParameter("timeFormatOut", (String)parameters.get("timeformatout"));
                        parameters.remove("timeformatout");
                        this.setParameter("lowerTime", (String)parameters.get("lowertime"));
                        parameters.remove("lowertime");
                        this.setParameter("upperTime", (String)parameters.get("uppertime"));
                        parameters.remove("uppertime");
                        this.setParameter("timeScale", (String)parameters.get("timescale"));
                        parameters.remove("timescale");
                        this.setParameter("autoTimeLabelsOn", (String)parameters.get("autotimelabelson"));
                        parameters.remove("autotimelabelson");
                        parameters.put("samplecount", this.theChart.getSampleCount() + "");
                        super.setParameters(parameters);
                        this.setParameter("defaultGridLinesOn", (String)parameters.get("defaultgridlineson"));
                        break block6;
                    }
                    if (!this.chartType.equals("plotter")) break block8;
                    Hashtable range_parameters = new Hashtable();
                    for (int i = 0; i < this.parameters_range_last.length; ++i) {
                        param = this.parameters_range_last[i];
                        if (!parameters.containsKey(param)) continue;
                        range_parameters.put(param, parameters.remove(param));
                    }
                    if (parameters.containsKey("seriescount")) {
                        this.setParameter("seriesCount", (String)parameters.get("seriescount"));
                    }
                    if (parameters.containsKey("plotsortingon")) {
                        this.setParameter("plotSortingOn", (String)parameters.get("plotsortingon"));
                    }
                    Enumeration keys = parameters.keys();
                    while (keys.hasMoreElements()) {
                        param = (String)keys.nextElement();
                        value = (String)parameters.get(param);
                        this.setParameter(param, value);
                    }
                    keys = range_parameters.keys();
                    while (keys.hasMoreElements()) {
                        param = (String)keys.nextElement();
                        value = (String)range_parameters.get(param);
                        this.setParameter(param, value);
                    }
                    break block6;
                }
                if (!this.chartType.equals("spline")) break block9;
                super.setParameters(parameters);
                break block6;
            }
            if (!this.chartType.equals("gauge")) break block6;
            Enumeration keys = parameters.keys();
            while (keys.hasMoreElements()) {
                String param = (String)keys.nextElement();
                String value = (String)parameters.get(param);
                this.setParameter(param, value);
            }
        }
    }

    public void setParameter(String name, String value) {
        block763: {
            boolean not_valid = this.chartType.equals("time_line") && this.theChart == null;
            not_valid |= this.chartType.equals("spline") && this.theChart == null;
            not_valid |= this.chartType.equals("plotter") && this.plotterChart == null;
            if (name == null || (not_valid |= this.chartType.equals("gauge") && this.gaugeChart == null)) {
                return;
            }
            name = name.toLowerCase();
            if (this.chartType.equals("time_line") && this.lineChart != null) {
                if (name.equalsIgnoreCase("timeFormatInput")) {
                    if (value != null && value.trim().length() > 0) {
                        ((TimeLineChart)this.theChart).setTimeFormatInput(value);
                    }
                } else if (name.equalsIgnoreCase("timeFormatInputLocale")) {
                    if (value != null && value.length() > 0) {
                        ((TimeLineChart)this.theChart).setTimeFormatInputLocale(value);
                    }
                } else if (name.equalsIgnoreCase("timeFormatOut")) {
                    if (value != null && value.trim().length() > 0) {
                        ((TimeLineChart)this.theChart).setTimeFormatOut(value);
                    }
                } else if (name.equalsIgnoreCase("timeFormatOutLocale")) {
                    if (value != null && value.length() > 0) {
                        ((TimeLineChart)this.theChart).setTimeFormatOutLocale(value);
                    }
                } else if (name.equalsIgnoreCase("lowerTime")) {
                    if (value != null && value.trim().length() > 0) {
                        ((TimeLineChart)this.theChart).setLowerTime(value);
                    }
                } else if (name.equalsIgnoreCase("upperTime")) {
                    if (value != null && value.trim().length() > 0) {
                        ((TimeLineChart)this.theChart).setUpperTime(value);
                    }
                } else if (name.equalsIgnoreCase("timeScale")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            double seconds = Double.valueOf(value);
                            ((TimeLineChart)this.theChart).setTimeScale(seconds);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid timeScale: " + value);
                        }
                    }
                } else if (name.equalsIgnoreCase("autoTimeLabelsOn")) {
                    boolean on = false;
                    if (value != null && value.trim().length() > 0) {
                        on = value.trim().equalsIgnoreCase("true");
                    }
                    ((TimeLineChart)this.theChart).setAutoTimeLabelsOn(on);
                } else if (name.startsWith("timeplots")) {
                    if (value != null && value.indexOf("|") > 0) {
                        int series = -1;
                        if (name.equals("timeplots")) {
                            series = 0;
                        } else {
                            try {
                                series = Integer.parseInt(name.substring(10));
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid timePlot series index: " + name);
                            }
                        }
                        String[] plots = this.getStringValues(value, ",");
                        ((TimeLineChart)this.theChart).setTimePlots(series, plots);
                    }
                } else if (name.equalsIgnoreCase("timeLabels")) {
                    if (value != null) {
                        String[] labels = this.getStringValues(value, ",");
                        ((TimeLineChart)this.theChart).setTimeLabels(labels);
                    }
                } else if (name.equalsIgnoreCase("defaultGridLinesOn")) {
                    boolean on = false;
                    if (value != null && value.trim().startsWith("true")) {
                        on = true;
                    }
                    ((TimeLineChart)this.theChart).setDefaultGridLinesOn(on);
                } else {
                    super.setParameter(name, value);
                }
            } else if (this.chartType.equals("plotter") && this.plotterChart != null) {
                if (name.equals("width")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            int width = Integer.parseInt(value.trim());
                            this.plotterChart.setSize(width, this.plotterChart.getSize().height);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid width: " + value);
                        }
                    }
                } else if (name.equals("height")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            int height = Integer.parseInt(value.trim());
                            this.plotterChart.setSize(this.plotterChart.getSize().width, height);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid height: " + value);
                        }
                    }
                } else if (name.equals("seriescount")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            this.plotterChart.setSeriesCount(Math.max(1, Integer.parseInt(value.trim())));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid seriesCount: " + value);
                        }
                    } else {
                        this.plotterChart.setSeriesCount(1);
                    }
                } else if (name.equals("serieson")) {
                    boolean[] values = this.getBooleanValues(value);
                    int seriesCount = this.plotterChart.getSeriesCount();
                    for (int i = 0; i < seriesCount; ++i) {
                        boolean on = true;
                        if (values != null && values.length > 0) {
                            on = values[i % values.length];
                        }
                        this.plotterChart.setSeriesOn(i, on);
                    }
                } else if (name.equals("plotlabelson")) {
                    this.plotterChart.setPlotLabelsOn(value != null && value.equalsIgnoreCase("true"));
                } else if (name.equals("plotlabelstyle")) {
                    this.plotterChart.setPlotLabelStyle(3);
                    if (value != null && value.trim().equalsIgnoreCase("floating")) {
                        this.plotterChart.setPlotLabelStyle(4);
                    } else if (value != null && value.trim().equalsIgnoreCase("below_and_floating")) {
                        this.plotterChart.setPlotLabelStyle(5);
                    }
                } else if (name.equals("plotlabelangle")) {
                    try {
                        if (value != null && value.trim().length() > 0) {
                            this.plotterChart.setLabelAngle(name, Integer.parseInt(value));
                            break block763;
                        }
                        this.plotterChart.setLabelAngle(name, 0);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid " + name + ": " + value);
                    }
                } else if (name.startsWith("plotlabels")) {
                    int serie = -1;
                    if (name.equalsIgnoreCase("plotlabels")) {
                        serie = 0;
                    } else {
                        try {
                            serie = Integer.parseInt(name.substring(11));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid plots series index: " + name);
                        }
                    }
                    if (value != null) {
                        String[] plotLabels = this.getStringValues(value, ",");
                        if (plotLabels == null) {
                            return;
                        }
                        this.plotterChart.setPlotLabels(serie, plotLabels);
                    }
                } else if (name.equals("autolabelspacingon")) {
                    this.plotterChart.setAutoLabelSpacingOn(value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.equals("plotstyle")) {
                    int[] values = this.getStyleValues(value);
                    int seriesCount = this.plotterChart.getSeriesCount();
                    for (int i = 0; i < seriesCount; ++i) {
                        int style = 0;
                        if (values != null && values.length > 0) {
                            style = values[i % values.length];
                        }
                        this.plotterChart.setPlotStyle(i, style);
                    }
                } else if (name.startsWith("plotsize")) {
                    String serie_str;
                    int serie = -1;
                    if (name.startsWith("plotsize_") && (serie_str = name.substring(9)) != null) {
                        try {
                            serie = Integer.parseInt(serie_str);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid plotSize serie: " + name);
                        }
                    }
                    if (serie >= -1) {
                        String[] sizes = this.getStringValues(value, ",");
                        if (sizes.length == 1) {
                            try {
                                int size = Integer.parseInt(sizes[0]);
                                this.plotterChart.setPlotSize(serie, size);
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid timePlot series index: " + name);
                            }
                        } else if (sizes.length > 1) {
                            int[] plotSize = new int[sizes.length];
                            try {
                                for (int i = 0; i < plotSize.length; ++i) {
                                    plotSize[i] = Integer.parseInt(sizes[i]);
                                }
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid plotSize : " + name + " " + value);
                            }
                            this.plotterChart.setPlotSize(serie, plotSize);
                        }
                    }
                } else if (name.equals("plotsortingon")) {
                    if (value != null && value.trim().length() > 0) {
                        boolean[] plotsorting_on = this.getBooleanValues(value);
                        if (plotsorting_on.length == 1 && this.plotterChart.getSeriesCount() > 1) {
                            this.plotterChart.setPlotSortingOn(-1, plotsorting_on[0]);
                        } else {
                            for (int i = 0; i < plotsorting_on.length; ++i) {
                                this.plotterChart.setPlotSortingOn(i, plotsorting_on[i]);
                            }
                        }
                    } else {
                        this.plotterChart.setPlotSortingOn(-1, false);
                    }
                } else if (name.startsWith("plots")) {
                    int serie = -1;
                    if (name.equalsIgnoreCase("plots")) {
                        serie = 0;
                    } else {
                        try {
                            serie = Integer.parseInt(name.substring(6));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid plots series index: " + name);
                        }
                    }
                    if (value != null && value.indexOf("|") > 0) {
                        String[] plots_str = this.getStringValues(value, ",");
                        if (plots_str == null) {
                            return;
                        }
                        double[][] plots = new double[plots_str.length][2];
                        int[] plotSize = new int[plots_str.length];
                        String[] plotLabels = new String[plots_str.length];
                        boolean is_labels_empty = true;
                        for (int i = 0; i < plots.length; ++i) {
                            String[] coords = this.getStringValues(plots_str[i], "|");
                            try {
                                if (coords.length > 0 && coords[0] != null) {
                                    plots[i][0] = Double.valueOf(coords[0].trim());
                                }
                                if (coords.length > 1 && coords[1] != null) {
                                    plots[i][1] = Double.valueOf(coords[1].trim());
                                }
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid plot: " + plots_str[i]);
                            }
                            if (coords.length > 2 && coords[2] != null) {
                                try {
                                    plotSize[i] = Integer.parseInt(coords[2].trim());
                                }
                                catch (NumberFormatException e) {
                                    // empty catch block
                                }
                            }
                            if (coords.length <= 3 || coords[3] == null) continue;
                            plotLabels[i] = new String(ChartDataLoaderExt.convertLineBreaks(coords[3]));
                            if (plotLabels[i] == null || plotLabels[i].equals("")) continue;
                            is_labels_empty = false;
                        }
                        if (!is_labels_empty) {
                            this.plotterChart.setPlotLabels(serie, plotLabels);
                        }
                        this.plotterChart.setPlots(serie, plots, plotSize);
                    } else if (serie >= 0 && serie < this.plotterChart.getSeriesCount()) {
                        this.plotterChart.setPlotLabels(serie, new String[0]);
                        this.plotterChart.setPlots(serie, new double[0][0], new int[0]);
                    }
                } else if (name.equals("linewidth")) {
                    if (value != null && value.trim().length() > 0) {
                        Double[] width = ChartDataLoaderExt.getDoubleValues(value, this.valueDelimiter);
                        if (width.length == 1 && this.plotterChart.getSeriesCount() > 1) {
                            this.plotterChart.setLineWidth(-1, width[0].intValue());
                        } else {
                            for (int i = 0; i < width.length; ++i) {
                                this.plotterChart.setLineWidth(i, width[i].intValue());
                            }
                        }
                    } else {
                        this.plotterChart.setLineWidth(-1, 1);
                    }
                } else if (name.equals("connectedlineson")) {
                    if (value != null && value.trim().length() > 0) {
                        boolean[] connected_on = this.getBooleanValues(value);
                        if (connected_on.length == 1 && this.plotterChart.getSeriesCount() > 1) {
                            this.plotterChart.setConnectedLinesOn(-1, connected_on[0]);
                        } else {
                            for (int i = 0; i < connected_on.length; ++i) {
                                this.plotterChart.setConnectedLinesOn(i, connected_on[i]);
                            }
                        }
                    } else {
                        this.plotterChart.setConnectedLinesOn(-1, false);
                    }
                } else if (name.equals("xaxison") && value != null) {
                    this.plotterChart.setXAxisOn(value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.equals("yaxison") && value != null) {
                    this.plotterChart.setYAxisOn(value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.equals("xaxiscolor") && value != null) {
                    this.plotterChart.setXAxisColor(ChartDataLoaderExt.createColor(value));
                } else if (name.equals("yaxiscolor") && value != null) {
                    this.plotterChart.setYAxisColor(ChartDataLoaderExt.createColor(value));
                } else if (name.equals("xupperrange")) {
                    try {
                        if (value != null && value.trim().length() > 0) {
                            this.plotterChart.setXUpperRange(new Double(value.trim()));
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range: " + value);
                    }
                } else if (name.equals("xlowerrange")) {
                    try {
                        if (value != null && value.trim().length() > 0) {
                            this.plotterChart.setXLowerRange(new Double(value.trim()));
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range: " + value);
                    }
                } else if (name.equals("yupperrange")) {
                    try {
                        if (value != null && value.trim().length() > 0) {
                            this.plotterChart.setYUpperRange(new Double(value.trim()));
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range: " + value);
                    }
                } else if (name.equals("ylowerrange")) {
                    try {
                        if (value != null && value.trim().length() > 0) {
                            this.plotterChart.setYLowerRange(new Double(value.trim()));
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range: " + value);
                    }
                } else if (name.equals("xrangeinterval")) {
                    try {
                        if (value != null && value.trim().length() > 0) {
                            this.plotterChart.setXRangeInterval(new Double(value.trim()));
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid XRangeInterval: " + value);
                    }
                } else if (name.equals("yrangeinterval")) {
                    try {
                        if (value != null && value.trim().length() > 0) {
                            this.plotterChart.setYRangeInterval(new Double(value.trim()));
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid YRangeInterval: " + value);
                    }
                } else if (name.equals("xrangedecimalcount")) {
                    if (value.equalsIgnoreCase("auto")) {
                        this.plotterChart.setXRangeDecimalCount(-1);
                    } else {
                        try {
                            if (value != null && value.trim().length() > 0) {
                                this.plotterChart.setXRangeDecimalCount(Integer.parseInt(value.trim()));
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + ": " + value);
                        }
                    }
                } else if (name.equals("yrangedecimalcount")) {
                    if (value.equalsIgnoreCase("auto")) {
                        this.plotterChart.setYRangeDecimalCount(-1);
                    } else {
                        try {
                            if (value != null && value.trim().length() > 0) {
                                this.plotterChart.setYRangeDecimalCount(Integer.parseInt(value.trim()));
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + ": " + value);
                        }
                    }
                } else if (name.equals("rangeon")) {
                    this.plotterChart.setRangeOn(2, false);
                    this.plotterChart.setRangeOn(0, false);
                    this.plotterChart.setRangeOn(3, false);
                    this.plotterChart.setRangeOn(1, false);
                    if (value != null && value.trim().length() > 0) {
                        StringTokenizer st = new StringTokenizer(value.trim(), ",");
                        while (st.hasMoreTokens()) {
                            String side = ((String)st.nextElement()).trim();
                            if (side.equals("top")) {
                                this.plotterChart.setRangeOn(2, true);
                                continue;
                            }
                            if (side.equals("left")) {
                                this.plotterChart.setRangeOn(0, true);
                                continue;
                            }
                            if (side.equals("bottom")) {
                                this.plotterChart.setRangeOn(3, true);
                                continue;
                            }
                            if (!side.equals("right")) continue;
                            this.plotterChart.setRangeOn(1, true);
                        }
                    }
                } else if (name.equals("rangecolor")) {
                    if (value != null && value.trim().length() > 0) {
                        Color color;
                        StringTokenizer st = new StringTokenizer(value.trim(), ",");
                        if (st.hasMoreTokens()) {
                            color = ChartDataLoaderExt.createColor(((String)st.nextElement()).trim());
                            this.plotterChart.setRangeColor(2, color);
                        }
                        if (st.hasMoreTokens()) {
                            color = ChartDataLoaderExt.createColor(((String)st.nextElement()).trim());
                            this.plotterChart.setRangeColor(0, color);
                        }
                        if (st.hasMoreTokens()) {
                            color = ChartDataLoaderExt.createColor(((String)st.nextElement()).trim());
                            this.plotterChart.setRangeColor(3, color);
                        }
                        if (st.hasMoreTokens()) {
                            color = ChartDataLoaderExt.createColor(((String)st.nextElement()).trim());
                            this.plotterChart.setRangeColor(1, color);
                        }
                    }
                } else if (name.startsWith("rangeaxislabel_")) {
                    this.plotterChart.setLabel(name, ChartDataLoaderExt.convertLineBreaks(value));
                } else if (name.startsWith("rangeaxislabelangle_")) {
                    try {
                        if (value != null && value.trim().length() > 0) {
                            this.plotterChart.setLabelAngle(name, Integer.parseInt(value));
                            break block763;
                        }
                        this.plotterChart.setLabelAngle(name, 0);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid " + name + ": " + value);
                    }
                } else if (name.equals("xvaluelineson")) {
                    if (value != null) {
                        boolean on = value.trim().equalsIgnoreCase("true");
                        this.plotterChart.setXValueLinesOn(on);
                    }
                } else if (name.equals("yvaluelineson")) {
                    if (value != null) {
                        boolean on = value.trim().equalsIgnoreCase("true");
                        this.plotterChart.setYValueLinesOn(on);
                    }
                } else if (name.equals("xvaluelinescolor")) {
                    if (value != null) {
                        this.plotterChart.setXValueLinesColor(ChartDataLoaderExt.createColor(value));
                    }
                } else if (name.equals("yvaluelinescolor")) {
                    if (value != null) {
                        this.plotterChart.setYValueLinesColor(ChartDataLoaderExt.createColor(value));
                    }
                } else if (name.equals("gridlines")) {
                    Double[] lines;
                    this.plotterChart.setGridLines(null);
                    if (value != null && (lines = ChartDataLoaderExt.getDoubleValues(value)) != null) {
                        double[] dLines = new double[lines.length];
                        for (int i = 0; i < lines.length; ++i) {
                            if (lines[i] == null) continue;
                            dLines[i] = lines[i];
                        }
                        this.plotterChart.setGridLines(dLines);
                    }
                } else if (name.equals("gridlinescolor")) {
                    Color[] colors;
                    this.plotterChart.setGridLinesColor(null);
                    if (value != null && value.trim().length() > 0 && (colors = this.getColorValues(value)) != null && colors.length > 0 && colors[0] != null) {
                        this.plotterChart.setGridLinesColor(colors[0]);
                    }
                } else if (name.equals("gridlinecolors")) {
                    if (value != null && value.trim().length() > 0) {
                        this.plotterChart.setGridLineColors(this.getColorValues(value));
                    } else {
                        this.plotterChart.setGridLineColors(null);
                    }
                } else if (name.equals("xmaxvaluelinecount")) {
                    if (value != null) {
                        this.plotterChart.setXMaxValueLineCount(Integer.parseInt(value.trim()));
                    }
                } else if (name.equals("ymaxvaluelinecount")) {
                    if (value != null) {
                        this.plotterChart.setYMaxValueLineCount(Integer.parseInt(value.trim()));
                    }
                } else if (name.equals("xrangelabels")) {
                    String[] str = this.getStringValues(value, ",");
                    for (int i = 0; i < str.length; ++i) {
                        String[] labelParts = this.getStringValues(str[i], "|");
                        if (labelParts.length <= 1) continue;
                        try {
                            double x = Double.valueOf(labelParts[0]);
                            if (labelParts.length > 1 && labelParts[1] != null) {
                                this.plotterChart.setXRangeLabel(x, ChartDataLoaderExt.convertLineBreaks(labelParts[1]));
                            }
                            if (labelParts.length > 2 && labelParts[2] != null) {
                                this.plotterChart.setXRangeLabelColor(x, ChartDataLoaderExt.createColor(labelParts[2]));
                            }
                            if (labelParts.length <= 3 || labelParts[3] == null) continue;
                            this.plotterChart.setXRangeLabelLineOn(x, labelParts[3].trim().equalsIgnoreCase("true"));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid XRangeLabels value: " + str[i]);
                        }
                    }
                } else if (name.equals("xrangelabelangle")) {
                    try {
                        if (value != null && value.trim().length() > 0) {
                            this.plotterChart.setLabelAngle(name, Integer.parseInt(value));
                            break block763;
                        }
                        this.plotterChart.setLabelAngle(name, 0);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid XRangeLabelAngle: " + value);
                    }
                } else if (name.startsWith("targetvalueline")) {
                    if (this.targets.containsKey(name)) {
                        String id = (String)this.targets.remove(name);
                        this.plotterChart.setTargetValueLine(id, 0.0, null, 0);
                    }
                    if (value != null && value.length() > 0) {
                        String s;
                        StringTokenizer st = new StringTokenizer(value, this.labelDelimiter);
                        String label = null;
                        if (st.hasMoreElements()) {
                            label = ChartDataLoaderExt.convertLineBreaks((String)st.nextElement());
                        }
                        double target = 0.0;
                        if (st.hasMoreElements()) {
                            try {
                                String s2 = (String)st.nextElement();
                                target = new Double(s2.trim());
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid targetValueLine value: " + value);
                            }
                        }
                        Color color = this.plotterChart.getYValueLinesColor();
                        if (st.hasMoreElements() && (color = ChartDataLoaderExt.createColor((s = (String)st.nextElement()).trim())) == null) {
                            color = this.plotterChart.getYValueLinesColor();
                        }
                        int style = 3;
                        if (st.hasMoreElements()) {
                            String s3 = ((String)st.nextElement()).trim();
                            style = s3.equals("label") ? 1 : (s3.equals("value") ? 2 : 3);
                        }
                        if (label != null) {
                            this.targets.put(name, label);
                            this.plotterChart.setTargetValueLine(label, target, color, style);
                        }
                    }
                } else if (name.equals("targetlabelsposition")) {
                    if (value != null && value.trim().length() > 0) {
                        if ((value = value.toLowerCase()).equals("right") || value.equals("top")) {
                            this.plotterChart.setTargetLabelsPosition(1);
                        } else if (value.equals("left") || value.equals("bottom")) {
                            this.plotterChart.setTargetLabelsPosition(0);
                        } else {
                            System.out.println("Invalid targetLabelsPosition: " + value);
                        }
                    }
                } else if (name.equals("foreground")) {
                    if (value != null && value.trim().length() > 0) {
                        Color c = ChartDataLoaderExt.createColor(value);
                        if (c != null) {
                            this.plotterChart.setForeground(c);
                        } else {
                            this.plotterChart.setForeground(Color.black);
                        }
                    } else {
                        this.plotterChart.setForeground(Color.black);
                    }
                } else if (name.equals("background")) {
                    if (value != null && value.trim().length() > 0) {
                        Color c;
                        StringTokenizer st = new StringTokenizer(value.trim(), "|");
                        if (st.hasMoreTokens()) {
                            c = ChartDataLoaderExt.createColor((String)st.nextElement());
                            if (c != null) {
                                this.plotterChart.setBackground(c);
                            } else {
                                this.plotterChart.setBackground(new Color(231, 221, 231));
                            }
                        }
                        if (st.hasMoreTokens()) {
                            c = ChartDataLoaderExt.createColor((String)st.nextElement());
                            if (c != null) {
                                this.plotterChart.setBackground2(c);
                            } else {
                                this.plotterChart.setBackground2(null);
                            }
                        }
                    } else {
                        this.plotterChart.setBackground(new Color(231, 221, 231));
                        this.plotterChart.setBackground2(null);
                    }
                } else if (name.equals("chartforeground")) {
                    if (value != null && value.trim().length() > 0) {
                        Color c = ChartDataLoaderExt.createColor(value);
                        if (c != null) {
                            this.plotterChart.setChartForeground(c);
                        } else {
                            this.plotterChart.setChartForeground(new Color(96, 96, 96));
                        }
                    } else {
                        this.plotterChart.setChartForeground(new Color(96, 96, 96));
                    }
                } else if (name.equals("chartbackground")) {
                    if (value != null && value.trim().length() > 0) {
                        Color c;
                        StringTokenizer st = new StringTokenizer(value.trim(), "|");
                        if (st.hasMoreTokens()) {
                            c = ChartDataLoaderExt.createColor((String)st.nextElement());
                            if (c != null) {
                                this.plotterChart.setChartBackground(c);
                            } else {
                                this.plotterChart.setChartBackground(Color.white);
                            }
                        }
                        if (st.hasMoreTokens()) {
                            c = ChartDataLoaderExt.createColor((String)st.nextElement());
                            if (c != null) {
                                this.plotterChart.setChartBackground2(c);
                            } else {
                                this.plotterChart.setChartBackground2(null);
                            }
                        }
                    } else {
                        this.plotterChart.setChartBackground(Color.white);
                        this.plotterChart.setChartBackground2(null);
                    }
                } else if (name.equals("rangeadjusteron_right")) {
                    if (value != null && value.trim().length() > 0) {
                        this.plotterChart.setRangeAdjusterOn(1, value.trim().equalsIgnoreCase("true"));
                    }
                } else if (name.equals("rangeadjusteron_bottom")) {
                    if (value != null && value.trim().length() > 0) {
                        this.plotterChart.setRangeAdjusterOn(3, value.trim().equalsIgnoreCase("true"));
                    }
                } else if (name.equals("zoomon")) {
                    this.plotterChart.setZoomOn(value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.equals("legendon")) {
                    this.plotterChart.setLegendOn(value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.equals("legendposition")) {
                    this.plotterChart.setLegendPosition(1);
                    if (value != null && value.trim().length() > 0) {
                        if ((value = value.toLowerCase()).equals("right")) {
                            this.plotterChart.setLegendPosition(1);
                        } else if (value.equals("top")) {
                            this.plotterChart.setLegendPosition(2);
                        } else if (value.equals("bottom")) {
                            this.plotterChart.setLegendPosition(3);
                        } else if (value.equals("left")) {
                            this.plotterChart.setLegendPosition(0);
                        } else {
                            System.out.println("Invalid legendPosition: " + value);
                        }
                    }
                } else if (name.equals("legendcolumns")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            int columns = Integer.parseInt(value.trim());
                            this.plotterChart.setLegendColumns(columns);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid legendColumns: " + value);
                        }
                    }
                } else if (name.equals("legendlabels")) {
                    this.plotterChart.setLegendLabels(null);
                    if (value != null && value.trim().length() > 0) {
                        String[] labels = this.getStringValues(ChartDataLoaderExt.convertLineBreaks(value), this.labelDelimiter);
                        if (labels.length > 1) {
                            this.plotterChart.setLegendLabels(labels);
                        } else if (labels.length == 1 && labels[0] != null) {
                            if (labels[0].trim().equalsIgnoreCase("serieslabels")) {
                                this.plotterChart.setLegendLabels(this.plotterChart.getSeriesLabels());
                            } else {
                                this.plotterChart.setLegendLabels(labels);
                            }
                        }
                    }
                } else if (name.equals("seriescolors")) {
                    if (value != null && value.trim().length() > 0) {
                        Color[] colors = this.getColorValues(value);
                        this.plotterChart.setSeriesColors(colors);
                    } else {
                        this.plotterChart.setSeriesColors(null);
                    }
                } else if (name.equals("legendcolors")) {
                    if (value != null && value.trim().length() > 0) {
                        Color[] colors = this.getColorValues(value);
                        this.plotterChart.setLegendColors(colors);
                    } else {
                        this.plotterChart.setLegendColors(null);
                    }
                } else if (name.startsWith("xvaluelabelson")) {
                    if (name.equals("xvaluelabelson")) {
                        this.plotterChart.setXValueLabelsOn(-1, value != null && value.trim().equalsIgnoreCase("true"));
                    } else if (name.startsWith("xvaluelabelson_")) {
                        try {
                            int serie = Integer.parseInt(name.substring(15));
                            if (serie >= 0 && serie < this.plotterChart.getSeriesCount()) {
                                this.plotterChart.setXValueLabelsOn(serie, value != null && value.trim().equalsIgnoreCase("true"));
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " " + value);
                        }
                    }
                } else if (name.startsWith("yvaluelabelson")) {
                    if (name.equals("yvaluelabelson")) {
                        this.plotterChart.setYValueLabelsOn(-1, value != null && value.trim().equalsIgnoreCase("true"));
                    } else if (name.startsWith("yvaluelabelson_")) {
                        try {
                            int serie = Integer.parseInt(name.substring(15));
                            if (serie >= 0 && serie < this.plotterChart.getSeriesCount()) {
                                this.plotterChart.setYValueLabelsOn(serie, value != null && value.trim().equalsIgnoreCase("true"));
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " " + value);
                        }
                    }
                } else if (name.startsWith("xvaluelabelprefix") || name.startsWith("xvaluelabelpostfix")) {
                    this.plotterChart.setLabel(name, ChartDataLoaderExt.convertLineBreaks(value));
                } else if (name.startsWith("yvaluelabelprefix") || name.startsWith("yvaluelabelpostfix")) {
                    this.plotterChart.setLabel(name, ChartDataLoaderExt.convertLineBreaks(value));
                } else if (name.startsWith("xvaluedecimalcount")) {
                    try {
                        int serie;
                        if (name.equals("xvaluedecimalcount")) {
                            if (value != null && value.trim().length() > 0) {
                                if (value.equalsIgnoreCase("auto")) {
                                    this.plotterChart.setXValueDecimalCount(-1, -1);
                                } else {
                                    this.plotterChart.setXValueDecimalCount(-1, Integer.parseInt(value.trim()));
                                }
                            } else {
                                this.plotterChart.setXValueDecimalCount(-1, 0);
                            }
                            break block763;
                        }
                        if (!name.startsWith("xvaluedecimalcount_") || (serie = Integer.parseInt(name.substring(19))) < 0 || serie >= this.plotterChart.getSeriesCount()) break block763;
                        if (value != null && value.trim().length() > 0) {
                            if (value.equalsIgnoreCase("auto")) {
                                this.plotterChart.setXValueDecimalCount(serie, -1);
                            } else {
                                this.plotterChart.setXValueDecimalCount(serie, Integer.parseInt(value.trim()));
                            }
                            break block763;
                        }
                        this.plotterChart.setXValueDecimalCount(serie, 0);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid " + name + " " + value);
                    }
                } else if (name.startsWith("yvaluedecimalcount")) {
                    try {
                        int serie;
                        if (name.equals("yvaluedecimalcount")) {
                            if (value != null && value.trim().length() > 0) {
                                if (value.equalsIgnoreCase("auto")) {
                                    this.plotterChart.setYValueDecimalCount(-1, -1);
                                } else {
                                    this.plotterChart.setYValueDecimalCount(-1, Integer.parseInt(value.trim()));
                                }
                            } else {
                                this.plotterChart.setYValueDecimalCount(-1, 0);
                            }
                            break block763;
                        }
                        if (!name.startsWith("yvaluedecimalcount_") || (serie = Integer.parseInt(name.substring(19))) < 0 || serie >= this.plotterChart.getSeriesCount()) break block763;
                        if (value != null && value.trim().length() > 0) {
                            if (value.equalsIgnoreCase("auto")) {
                                this.plotterChart.setYValueDecimalCount(serie, -1);
                            } else {
                                this.plotterChart.setYValueDecimalCount(serie, Integer.parseInt(value.trim()));
                            }
                            break block763;
                        }
                        this.plotterChart.setYValueDecimalCount(serie, 0);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid " + name + " " + value);
                    }
                } else if (name.equals("valuelabelstyle")) {
                    this.plotterChart.setValueLabelStyle(0);
                    if (value != null && value.trim().length() > 0) {
                        if (value.trim().equalsIgnoreCase("over")) {
                            this.plotterChart.setValueLabelStyle(1);
                        } else if (value.trim().equalsIgnoreCase("under")) {
                            this.plotterChart.setValueLabelStyle(2);
                        } else if (value.trim().equalsIgnoreCase("floating")) {
                            this.plotterChart.setValueLabelStyle(4);
                        }
                    }
                } else if (name.equals("serieslabels")) {
                    this.plotterChart.setSeriesLabels(this.getStringValues(ChartDataLoaderExt.convertLineBreaks(value), ","));
                } else if (name.equals("serieslabelson")) {
                    this.plotterChart.setSeriesLabelsOn(value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.equals("serieslabelstyle")) {
                    this.plotterChart.setSeriesLabelStyle(0);
                    if (value != null && value.trim().length() > 0) {
                        if (value.trim().equalsIgnoreCase("over")) {
                            this.plotterChart.setSeriesLabelStyle(1);
                        } else if (value.trim().equalsIgnoreCase("under")) {
                            this.plotterChart.setSeriesLabelStyle(2);
                        } else if (value.trim().equalsIgnoreCase("floating")) {
                            this.plotterChart.setSeriesLabelStyle(4);
                        }
                    }
                } else if (name.equals("serieslabelcolors")) {
                    Color[] colors = this.getColorValues(value);
                    int seriesCount = this.plotterChart.getSeriesCount();
                    for (int i = 0; i < seriesCount; ++i) {
                        if (colors != null && i < colors.length) {
                            this.plotterChart.setSeriesLabelColor(i, colors[i]);
                            continue;
                        }
                        this.plotterChart.setSeriesLabelColor(i, null);
                    }
                } else if (name.startsWith("serieslabelfont")) {
                    if (value != null && value.trim().length() > 0) {
                        this.plotterChart.setFont(name, this.createFont(value, "Arial", 0, 11));
                    } else {
                        this.plotterChart.setFont(name, new Font("Arial", 0, 11));
                    }
                } else if (name.equals("floatingonlegendoff")) {
                    this.plotterChart.setFloatingOnLegendOn(value == null || !value.trim().equalsIgnoreCase("true"));
                } else if (name.equals("charttitle") || name.equals("title")) {
                    this.plotterChart.setTitle(ChartDataLoaderExt.convertLineBreaks(value));
                    this.plotterChart.setTitleOn(value != null && value.length() > 0);
                } else if (name.equals("titlefont")) {
                    if (value != null && value.trim().length() > 0) {
                        this.plotterChart.setFont("titleFont", this.createFont(value, "Dialog", 1, 14));
                    } else {
                        this.plotterChart.setFont("titleFont", new Font("Dialog", 1, 14));
                    }
                } else if (name.equals("font")) {
                    if (value != null && value.trim().length() > 0) {
                        this.plotterChart.setFont(this.createFont(value, "Arial", 0, 11));
                    } else {
                        this.plotterChart.setFont(new Font("Arial", 0, 11));
                    }
                } else if (name.endsWith("font")) {
                    if (value != null && value.trim().length() > 0) {
                        this.plotterChart.setFont(name, this.createFont(value, "Arial", 0, 11));
                    } else {
                        this.plotterChart.setFont(name, null);
                    }
                } else if (name.equals("graphinsets")) {
                    if (value != null && value.trim().length() > 0) {
                        StringTokenizer st = new StringTokenizer(value.trim(), ",");
                        int top = -1;
                        int left = -1;
                        int bottom = -1;
                        int right = -1;
                        try {
                            if (st.hasMoreTokens()) {
                                top = Integer.parseInt(((String)st.nextElement()).trim());
                            }
                            if (st.hasMoreTokens()) {
                                left = Integer.parseInt(((String)st.nextElement()).trim());
                            }
                            if (st.hasMoreTokens()) {
                                bottom = Integer.parseInt(((String)st.nextElement()).trim());
                            }
                            if (st.hasMoreTokens()) {
                                right = Integer.parseInt(((String)st.nextElement()).trim());
                            }
                            this.plotterChart.setGraphInsets(top, left, bottom, right);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid graphinsets: " + value);
                        }
                    } else {
                        this.plotterChart.setGraphInsets(-1, -1, -1, -1);
                    }
                } else if (name.equals("gridadjustmenton")) {
                    this.plotterChart.setGridAdjustmentOn(2, false);
                    this.plotterChart.setGridAdjustmentOn(1, false);
                    this.plotterChart.setGridAdjustmentOn(3, false);
                    this.plotterChart.setGridAdjustmentOn(0, false);
                    if (value != null && value.trim().length() > 0) {
                        if (value.trim().equalsIgnoreCase("true")) {
                            this.plotterChart.setGridAdjustmentOn(2, true);
                            this.plotterChart.setGridAdjustmentOn(1, true);
                            this.plotterChart.setGridAdjustmentOn(3, true);
                            this.plotterChart.setGridAdjustmentOn(0, true);
                        } else {
                            StringTokenizer st = new StringTokenizer(value, ",");
                            while (st.hasMoreTokens()) {
                                String edge = st.nextToken().trim();
                                if (edge.equalsIgnoreCase("top")) {
                                    this.plotterChart.setGridAdjustmentOn(2, true);
                                    continue;
                                }
                                if (edge.equalsIgnoreCase("right")) {
                                    this.plotterChart.setGridAdjustmentOn(1, true);
                                    continue;
                                }
                                if (edge.equalsIgnoreCase("bottom")) {
                                    this.plotterChart.setGridAdjustmentOn(3, true);
                                    continue;
                                }
                                if (!edge.equalsIgnoreCase("left")) continue;
                                this.plotterChart.setGridAdjustmentOn(0, true);
                            }
                        }
                    }
                } else if (name.equalsIgnoreCase("locale")) {
                    if (value != null && value.length() > 0) {
                        String lang;
                        StringTokenizer st = new StringTokenizer(value, ", ");
                        String country = lang = st.nextToken();
                        if (st.hasMoreElements()) {
                            country = st.nextToken();
                        }
                        if (this.plotterChart != null) {
                            if (country.equalsIgnoreCase("eu")) {
                                this.plotterChart.setLocale(new Locale(lang.toUpperCase(), lang.toUpperCase(), "EURO"));
                            } else {
                                this.plotterChart.setLocale(new Locale(lang.toUpperCase(), country.toUpperCase()));
                            }
                        }
                    } else if (this.plotterChart != null) {
                        this.plotterChart.setLocale(null);
                    }
                } else if (name.equalsIgnoreCase("thousandsDelimiter")) {
                    this.plotterChart.setThousandsDelimiter(value);
                    if (name.equalsIgnoreCase("thousandsDelimeter")) {
                        System.out.println("thousandsDelimeter is deprecated, use thousandsDelimiter instead");
                    }
                } else if (name.startsWith("url")) {
                    if (value != null && value.trim().length() > 0) {
                        this.plotterChart.addUrl(name, value);
                    } else {
                        this.plotterChart.removeUrl(name);
                    }
                } else if (name.startsWith("label_")) {
                    if (this.labels.containsKey(name)) {
                        this.plotterChart.setLabel(name, (String)null, 0, 0);
                    }
                    if (value != null && value.length() > 0) {
                        StringTokenizer st = new StringTokenizer(value, this.labelDelimiter);
                        String label = null;
                        if (st.hasMoreElements()) {
                            label = ChartDataLoaderExt.convertLineBreaks((String)st.nextElement());
                        }
                        int int_x = -1;
                        double double_x = -1.0;
                        if (st.hasMoreElements()) {
                            try {
                                String s = (String)st.nextElement();
                                if (s.indexOf(46) == -1) {
                                    int_x = new Integer(s.trim());
                                } else {
                                    double_x = new Double(s.trim());
                                }
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid " + name + " value: " + value);
                            }
                        }
                        int int_y = -1;
                        double double_y = -1.0;
                        if (st.hasMoreElements()) {
                            try {
                                String s = (String)st.nextElement();
                                if (s.indexOf(46) == -1) {
                                    int_y = new Integer(s.trim());
                                } else {
                                    double_y = new Double(s.trim());
                                }
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid " + name + " value: " + value);
                            }
                        }
                        int pointed_sample = -1;
                        if (st.hasMoreElements()) {
                            try {
                                String s = (String)st.nextElement();
                                pointed_sample = new Integer(s.trim());
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid " + name + " value: " + value);
                            }
                        }
                        int pointed_serie = -1;
                        if (st.hasMoreElements()) {
                            try {
                                String s = (String)st.nextElement();
                                pointed_serie = new Integer(s.trim());
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid " + name + " value: " + value);
                            }
                        }
                        if (label != null) {
                            this.labels.put(name, name);
                            if (pointed_sample > -1 && pointed_serie > -1) {
                                if (int_x != -1 && int_y != -1) {
                                    this.plotterChart.setLabel(name, label, int_x, int_y, pointed_serie, pointed_sample);
                                } else if (double_x != -1.0 && double_y != -1.0) {
                                    this.plotterChart.setLabel(name, label, double_x, double_y, pointed_serie, pointed_sample);
                                } else {
                                    System.out.println("Invalid " + name + " value: " + value);
                                }
                            } else if (int_x != -1 && int_y != -1) {
                                this.plotterChart.setLabel(name, label, int_x, int_y);
                            } else if (double_x != -1.0 && double_y != -1.0) {
                                this.plotterChart.setLabel(name, label, double_x, double_y);
                            } else {
                                System.out.println("Invalid " + name + " value: " + value);
                            }
                        }
                    }
                } else if (name.startsWith("labelposition_")) {
                    if (value != null && value.length() > 0) {
                        String id = "label" + name.substring(name.indexOf("_"));
                        StringTokenizer st = new StringTokenizer(value, this.labelDelimiter);
                        int int_x = -1;
                        double double_x = -1.0;
                        if (st.hasMoreElements()) {
                            try {
                                String s = (String)st.nextElement();
                                if (s.indexOf(46) == -1) {
                                    int_x = new Integer(s.trim());
                                } else {
                                    double_x = new Double(s.trim());
                                }
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid " + name + " value: " + value);
                            }
                        }
                        int int_y = -1;
                        double double_y = -1.0;
                        if (st.hasMoreElements()) {
                            try {
                                String s = (String)st.nextElement();
                                if (s.indexOf(46) == -1) {
                                    int_y = new Integer(s.trim());
                                } else {
                                    double_y = new Double(s.trim());
                                }
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid " + name + " value: " + value);
                            }
                        }
                        if (int_x != -1 && int_y != -1) {
                            this.plotterChart.setLabelPosition(id, int_x, int_y);
                        } else if (double_x != -1.0 && double_y != -1.0) {
                            this.plotterChart.setLabelPosition(id, double_x, double_y);
                        } else {
                            System.out.println("Invalid " + name + " value: " + value);
                        }
                    }
                } else if (name.startsWith("labelurl_")) {
                    String id = "label" + name.substring(name.indexOf("_"));
                    if (this.labelURLs.containsKey(id)) {
                        this.labelURLs.remove(id);
                        this.plotterChart.setLabelURL(id, null);
                    }
                    if (value != null && value.length() > 0) {
                        this.labelURLs.put(id, value);
                        this.plotterChart.setLabelURL(id, value);
                    }
                } else if (name.startsWith("labelurltarget_")) {
                    String id = "label" + name.substring(name.indexOf("_"));
                    if (value != null && value.trim().length() > 0) {
                        this.labelURLTargets.put(id, value);
                    } else if (name.equals("labelurltarget")) {
                        this.labelURLTargets.put("urltarget", "_self");
                    } else {
                        this.labelURLTargets.remove(name);
                    }
                } else if (name.startsWith("labelangle_")) {
                    String id = "label" + name.substring(name.indexOf("_"));
                    try {
                        int angle = Integer.parseInt(value.trim());
                        this.plotterChart.setLabelAngle(id, angle);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid custom label angle: " + value);
                    }
                } else if (name.startsWith("labelfont_")) {
                    String id = "label" + name.substring(name.indexOf("_"));
                    if (value != null && value.trim().length() > 0) {
                        this.plotterChart.setFont(id, this.createFont(value, "Dialog", 0, 11));
                    } else {
                        this.plotterChart.setFont(id, new Font("Dialog", 0, 11));
                    }
                } else if (name.startsWith("labelcolor_")) {
                    String id = "label" + name.substring(name.indexOf("_"));
                    this.plotterChart.setLabelColor(id, ChartDataLoaderExt.createColor(value));
                } else if (name.equalsIgnoreCase("antialias")) {
                    this.plotterChart.setAntialiasingOn(value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.startsWith("overlay")) {
                    System.out.println("Overlays are not allowed for the PlotterChart");
                }
            } else if (this.chartType.equals("gauge") && this.gaugeChart != null) {
                int index = 0;
                if (name.indexOf("_") != -1) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid index: " + name);
                    }
                }
                if (name.equals("width")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            int width = Integer.parseInt(value.trim());
                            this.gaugeChart.setSize(width, this.gaugeChart.getSize().height);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid width: " + value);
                        }
                    }
                } else if (name.equals("height")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            int height = Integer.parseInt(value.trim());
                            this.gaugeChart.setSize(this.gaugeChart.getSize().width, height);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid height: " + value);
                        }
                    }
                } else if (name.equals("startangle")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            int angle = Integer.parseInt(value.trim());
                            this.gaugeChart.setStartAngle(angle);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid start angle: " + value);
                        }
                    }
                } else if (name.equals("endangle")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            int angle = Integer.parseInt(value.trim());
                            this.gaugeChart.setEndAngle(angle);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid end angle: " + value);
                        }
                    }
                } else if (name.equals("rangestartangle")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            int angle = Integer.parseInt(value.trim());
                            this.gaugeChart.setRangeStartAngle(angle);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid range start angle: " + value);
                        }
                    }
                } else if (name.equals("rangeendangle")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            int angle = Integer.parseInt(value.trim());
                            this.gaugeChart.setRangeEndAngle(angle);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid range end angle: " + value);
                        }
                    }
                } else if (name.equals("charttitle") || name.equals("title")) {
                    this.gaugeChart.setTitle(ChartDataLoaderExt.convertLineBreaks(value));
                    this.gaugeChart.setTitleOn(value != null && value.length() > 0);
                } else if (name.endsWith("font")) {
                    if (value != null && value.trim().length() > 0) {
                        this.gaugeChart.setFont(name, this.createFont(value, "Arial", 0, 11));
                    } else {
                        this.gaugeChart.setFont(name, null);
                    }
                } else if (name.startsWith("rangelabelprefix") || name.startsWith("rangelabelpostfix")) {
                    this.gaugeChart.setLabel(name, ChartDataLoaderExt.convertLineBreaks(value));
                } else if (name.equals("rangehighlight")) {
                    if (value != null && value.trim().length() > 0) {
                        Color c = ChartDataLoaderExt.createColor(value);
                        this.gaugeChart.setRangeHighlight(c);
                    }
                } else if (name.startsWith("rangelabelson")) {
                    if (name.equals("rangelabelson")) {
                        this.gaugeChart.setRangeLabelsOn(0, value != null && value.trim().equalsIgnoreCase("true"));
                    } else if (name.startsWith("rangelabelson_")) {
                        try {
                            int range = Integer.parseInt(name.substring(14));
                            this.gaugeChart.setRangeLabelsOn(range, value != null && value.trim().equalsIgnoreCase("true"));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " " + value);
                        }
                    }
                } else if (name.startsWith("floatinglabelson")) {
                    this.gaugeChart.setFloatingLabelsOn(value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.startsWith("rangelabelcolor")) {
                    Color c = ChartDataLoaderExt.createColor(value);
                    if (name.equals("rangelabelcolor")) {
                        this.gaugeChart.setRangeLabelColor(0, c);
                    } else if (name.startsWith("rangelabelcolor_")) {
                        try {
                            int range = Integer.parseInt(name.substring(17));
                            this.gaugeChart.setRangeLabelColor(range, c);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " " + value);
                        }
                    }
                } else if (name.equalsIgnoreCase("floatinglabelcolor")) {
                    this.gaugeChart.setFloatingLabelColor(ChartDataLoaderExt.createColor(value));
                } else if (name.startsWith("rangelabelstyle")) {
                    if (value != null && value.trim().length() > 0) {
                        if (value.trim().equalsIgnoreCase("inside")) {
                            this.gaugeChart.setRangeLabelStyle(0);
                        } else if (value.trim().equalsIgnoreCase("outside")) {
                            this.gaugeChart.setRangeLabelStyle(1);
                        } else if (value.trim().equalsIgnoreCase("border")) {
                            this.gaugeChart.setRangeLabelStyle(2);
                        }
                    }
                } else if (name.startsWith("rangetickstyle")) {
                    if (value != null && value.trim().length() > 0) {
                        if (value.trim().equalsIgnoreCase("round")) {
                            this.gaugeChart.setRangeTickStyle(0);
                        } else if (value.trim().equalsIgnoreCase("diamond")) {
                            this.gaugeChart.setRangeTickStyle(3);
                        } else if (value.trim().equalsIgnoreCase("thin")) {
                            this.gaugeChart.setRangeTickStyle(2);
                        } else if (value.trim().equalsIgnoreCase("thick")) {
                            this.gaugeChart.setRangeTickStyle(1);
                        }
                    }
                } else if (name.equals("rangeticksize")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            this.gaugeChart.setRangeTickSize(Integer.parseInt(value.trim()));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid range tick size: " + value);
                        }
                    }
                } else if (name.startsWith("rangecolor")) {
                    Color c = ChartDataLoaderExt.createColor(value);
                    if (name.equals("rangecolor")) {
                        this.gaugeChart.setRangeColor(0, c);
                    } else if (name.startsWith("rangecolor_")) {
                        try {
                            int range = Integer.parseInt(name.substring(11));
                            this.gaugeChart.setRangeColor(range, c);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " " + value);
                        }
                    }
                } else if (name.startsWith("rangedecimalcount")) {
                    if (value.equalsIgnoreCase("auto")) {
                        this.gaugeChart.setRangeDecimalCount(index, -1);
                    } else {
                        try {
                            if (value != null && value.trim().length() > 0) {
                                this.gaugeChart.setRangeDecimalCount(index, Integer.parseInt(value.trim()));
                                break block763;
                            }
                            this.gaugeChart.setRangeDecimalCount(index, 0);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + ": " + value);
                            this.gaugeChart.setRangeDecimalCount(index, 0);
                        }
                    }
                } else if (name.startsWith("rangeinterval")) {
                    try {
                        this.gaugeChart.setRangeInterval(new Double(value.trim()));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid rangeInterval: " + value);
                    }
                } else if (name.startsWith("lowerrange")) {
                    try {
                        this.gaugeChart.setLowerRange(new Double(value.trim()));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid lower range: " + value);
                    }
                } else if (name.startsWith("range")) {
                    try {
                        this.gaugeChart.setRange(new Double(value.trim()));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range: " + value);
                    }
                } else if (name.startsWith("pointersize")) {
                    StringTokenizer st = new StringTokenizer(value.trim(), ",");
                    if (st.hasMoreTokens()) {
                        try {
                            float size = new Float(st.nextToken().trim()).floatValue();
                            System.out.println(index + " " + size);
                            this.gaugeChart.setPointerSize(index, size);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid pointer size: " + value);
                        }
                    }
                    if (st.hasMoreTokens()) {
                        Color color = ChartDataLoaderExt.createColor(((String)st.nextElement()).trim());
                        this.gaugeChart.setPointerColor(index, color);
                    }
                } else if (name.startsWith("pointerlabelson")) {
                    this.gaugeChart.setPointerLabelsOn(value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.equalsIgnoreCase("pointerlabels")) {
                    this.gaugeChart.setPointerLabels(null);
                    if (value != null && value.trim().length() > 0) {
                        String[] labels = this.getStringValues(ChartDataLoaderExt.convertLineBreaks(value), this.labelDelimiter);
                        this.gaugeChart.setPointerLabels(labels);
                    }
                } else if (name.startsWith("pointer")) {
                    StringTokenizer st = new StringTokenizer(value.trim(), ",");
                    if (st.hasMoreTokens()) {
                        try {
                            this.gaugeChart.setPointer(index, new Double(st.nextToken().trim()));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid pointer value: " + value);
                        }
                    }
                    if (st.hasMoreTokens()) {
                        Color color = ChartDataLoaderExt.createColor(((String)st.nextElement()).trim());
                        this.gaugeChart.setPointerColor(index, color);
                    }
                } else if (name.startsWith("sectorhighlight")) {
                    StringTokenizer st = new StringTokenizer(value.trim(), ",");
                    if (st.hasMoreTokens()) {
                        try {
                            double start = new Double(st.nextToken().trim());
                            if (st.hasMoreTokens()) {
                                double end = new Double(st.nextToken().trim());
                                this.gaugeChart.setSectorHighlight(index, start, end);
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid angles: " + value);
                        }
                    }
                    if (st.hasMoreTokens()) {
                        Color color = ChartDataLoaderExt.createColor(((String)st.nextElement()).trim());
                        this.gaugeChart.setSectorColor(index, color);
                    }
                } else if (name.startsWith("border")) {
                    StringTokenizer st = new StringTokenizer(value.trim(), ",");
                    if (st.hasMoreTokens()) {
                        try {
                            this.gaugeChart.setBorder(index, new Integer(st.nextToken().trim()));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid pointer value: " + value);
                        }
                    }
                    if (st.hasMoreTokens()) {
                        Color color = ChartDataLoaderExt.createColor(((String)st.nextElement()).trim());
                        Color color2 = null;
                        if (st.hasMoreTokens()) {
                            color2 = ChartDataLoaderExt.createColor(((String)st.nextElement()).trim());
                        }
                        this.gaugeChart.setBorderColor(index, color, color2);
                    }
                } else if (name.startsWith("edgecolor")) {
                    if (value != null && value.trim().length() > 0) {
                        this.gaugeChart.setEdgeColor(ChartDataLoaderExt.createColor(value));
                    }
                } else if (name.equals("foreground")) {
                    if (value != null && value.trim().length() > 0) {
                        Color c = ChartDataLoaderExt.createColor(value);
                        if (c != null) {
                            this.gaugeChart.setForeground(c);
                        } else {
                            this.gaugeChart.setForeground(Color.black);
                        }
                    } else {
                        this.gaugeChart.setForeground(Color.black);
                    }
                } else if (name.equals("background")) {
                    if (value != null && value.trim().length() > 0) {
                        Color c;
                        StringTokenizer st = new StringTokenizer(value.trim(), "|");
                        if (st.hasMoreTokens()) {
                            c = ChartDataLoaderExt.createColor((String)st.nextElement());
                            if (c != null) {
                                this.gaugeChart.setBackground(c);
                            } else {
                                this.gaugeChart.setBackground(new Color(231, 221, 231));
                            }
                        }
                        if (st.hasMoreTokens()) {
                            c = ChartDataLoaderExt.createColor((String)st.nextElement());
                            if (c != null) {
                                this.gaugeChart.setBackground2(c);
                            } else {
                                this.gaugeChart.setBackground2(null);
                            }
                        }
                    } else {
                        this.gaugeChart.setBackground(new Color(231, 221, 231));
                        this.gaugeChart.setBackground2(null);
                    }
                } else if (name.equals("chartforeground")) {
                    if (value != null && value.trim().length() > 0) {
                        Color c = ChartDataLoaderExt.createColor(value);
                        if (c != null) {
                            this.gaugeChart.setChartForeground(c);
                        } else {
                            this.gaugeChart.setChartForeground(Color.black);
                        }
                    } else {
                        this.gaugeChart.setChartForeground(Color.black);
                    }
                } else if (name.equals("chartbackground")) {
                    if (value != null && value.trim().length() > 0) {
                        Color c;
                        StringTokenizer st = new StringTokenizer(value.trim(), "|");
                        if (st.hasMoreTokens()) {
                            c = ChartDataLoaderExt.createColor((String)st.nextElement());
                            if (c != null) {
                                this.gaugeChart.setChartBackground(c);
                            } else {
                                this.gaugeChart.setChartBackground(Color.white);
                            }
                        }
                        if (st.hasMoreTokens()) {
                            c = ChartDataLoaderExt.createColor((String)st.nextElement());
                            if (c != null) {
                                this.gaugeChart.setChartBackground2(c);
                            } else {
                                this.gaugeChart.setChartBackground2(null);
                            }
                        }
                    } else {
                        this.gaugeChart.setChartBackground(Color.white);
                        this.gaugeChart.setChartBackground2(null);
                    }
                } else if (name.equalsIgnoreCase("gaugealignment")) {
                    if (value != null && value.trim().length() > 0) {
                        if (value.trim().equalsIgnoreCase("center")) {
                            this.gaugeChart.setGaugeAlignment(0);
                        } else if (value.trim().equalsIgnoreCase("top")) {
                            this.gaugeChart.setGaugeAlignment(1);
                        } else if (value.trim().equalsIgnoreCase("bottom")) {
                            this.gaugeChart.setGaugeAlignment(2);
                        } else if (value.trim().equalsIgnoreCase("left")) {
                            this.gaugeChart.setGaugeAlignment(4);
                        } else if (value.trim().equalsIgnoreCase("right")) {
                            this.gaugeChart.setGaugeAlignment(3);
                        }
                    }
                } else if (name.equals("legendon")) {
                    this.gaugeChart.setLegendOn(value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.equals("legendposition")) {
                    this.gaugeChart.setLegendPosition(1);
                    if (value != null && value.trim().length() > 0) {
                        if ((value = value.toLowerCase()).equals("right")) {
                            this.gaugeChart.setLegendPosition(1);
                        } else if (value.equals("top")) {
                            this.gaugeChart.setLegendPosition(2);
                        } else if (value.equals("bottom")) {
                            this.gaugeChart.setLegendPosition(3);
                        } else if (value.equals("left")) {
                            this.gaugeChart.setLegendPosition(0);
                        } else {
                            System.out.println("Invalid legendPosition: " + value);
                        }
                    }
                } else if (name.equals("legendcolumns")) {
                    if (value != null && value.trim().length() > 0) {
                        try {
                            int columns = Integer.parseInt(value.trim());
                            this.gaugeChart.setLegendColumns(columns);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid legendColumns: " + value);
                        }
                    }
                } else if (name.equals("legendlabels")) {
                    this.gaugeChart.setLegendLabels(null);
                    if (value != null && value.trim().length() > 0) {
                        String[] labels = this.getStringValues(ChartDataLoaderExt.convertLineBreaks(value), this.labelDelimiter);
                        this.gaugeChart.setLegendLabels(labels);
                    }
                } else if (name.equals("legendcolors")) {
                    if (value != null && value.trim().length() > 0) {
                        Color[] colors = this.getColorValues(value);
                        this.gaugeChart.setLegendColors(colors);
                    } else {
                        this.gaugeChart.setLegendColors(null);
                    }
                } else if (name.equals("legendreverseon")) {
                    this.gaugeChart.setLegendReverseOn(value != null && value.equalsIgnoreCase("true"));
                }
            } else if (this.chartType.equals("spline") && this.theChart != null) {
                super.setParameter(name, value);
            }
        }
    }

    protected void setImage(String name, Image image) {
        block19: {
            if (this.chartType.equals("plotter")) {
                if (image != null) {
                    this.plotterChart.addImage(name, image);
                }
                if (name.equalsIgnoreCase("gridimage")) {
                    if (image != null) {
                        this.plotterChart.setGridImage("gridimage");
                    } else {
                        this.plotterChart.setGridImage(null);
                    }
                } else if (name.startsWith("legendimage_")) {
                    try {
                        int index = Integer.parseInt(name.substring(name.indexOf("_") + 1));
                        if (image != null) {
                            this.plotterChart.setLegendImage(index, name);
                            break block19;
                        }
                        this.plotterChart.setLegendImage(index, null);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid legend index: " + name);
                    }
                } else if (name.equals("plotimage")) {
                    if (image != null) {
                        this.plotterChart.setPlotImage(-1, name);
                    }
                } else if (name.startsWith("plotimage_")) {
                    try {
                        int index = Integer.parseInt(name.substring(name.indexOf("_") + 1));
                        if (image != null) {
                            this.plotterChart.setPlotImage(index, name);
                            break block19;
                        }
                        this.plotterChart.setPlotImage(index, null);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid series index: " + name);
                    }
                }
            } else {
                super.setImage(name, image);
            }
        }
    }
}

